A non-`'static` lifetime was used in a const generic. This is currently not
allowed.

Erroneous code example:

```compile_fail,E0771
#![feature(const_generics)]

fn function_with_str<'a, const STRING: &'a str>() {} // error!
```

To fix this issue, the lifetime in the const generic need to be changed to
`'static`:

```
#![feature(const_generics)]

fn function_with_str<const STRING: &'static str>() {} // ok!
```

For more information, see [GitHub issue #74052].

[GitHub issue #74052]: https://github.com/rust-lang/rust/issues/74052
