// REQUIRES: arm, aarch64

// RUN: llvm-mc -filetype=obj -triple=armv7a-none-linux-gnueabi %p/Inputs/arm-shared.s -o %t.a32.so.o
// RUN: ld.lld -shared %t.a32.so.o -soname=so -o %t.a32.so
// RUN: llvm-mc -filetype=obj -triple=armv7a-none-linux-gnueabi %s -o %t.a32.o
// RUN: ld.lld -pie --pack-dyn-relocs=none %t.a32.o %t.a32.so -o %t2.a32
// RUN: llvm-readobj -r %t2.a32 | FileCheck --check-prefix=UNPACKED32 %s

/// Unpacked should have the relative relocations in their natural order.
/// UNPACKED32:          Section ({{.+}}) .rel.dyn {
// UNPACKED32-NEXT:     0x30324 R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x30328 R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x3032C R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x30330 R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x30334 R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x30338 R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x3033C R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x30340 R_ARM_RELATIVE -

// UNPACKED32-NEXT:     0x30348 R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x3034C R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x30350 R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x30354 R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x30358 R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x3035C R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x30360 R_ARM_RELATIVE -

// UNPACKED32-NEXT:     0x3036C R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x30370 R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x30374 R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x30378 R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x3037C R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x30380 R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x30384 R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x30388 R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x3038C R_ARM_RELATIVE -
// UNPACKED32-NEXT:     0x30391 R_ARM_RELATIVE -

// UNPACKED32-NEXT:     0x30344 R_ARM_ABS32 bar2
// UNPACKED32-NEXT:     0x30368 R_ARM_ABS32 bar2
// UNPACKED32-NEXT:     0x30395 R_ARM_ABS32 bar2
// UNPACKED32-NEXT:     0x30399 R_ARM_ABS32 bar2
// UNPACKED32-NEXT:     0x3039D R_ARM_ABS32 bar2
// UNPACKED32-NEXT:     0x303A1 R_ARM_ABS32 bar2
// UNPACKED32-NEXT:     0x303A5 R_ARM_ABS32 bar2
// UNPACKED32-NEXT:     0x30364 R_ARM_ABS32 zed2
// UNPACKED32-NEXT:     }

// RUN: ld.lld -pie --pack-dyn-relocs=android %t.a32.o %t.a32.so -o %t3.a32
// RUN: llvm-readobj -S --dynamic-table %t3.a32 | FileCheck --check-prefix=ANDROID32-HEADERS %s
// RUN: llvm-readobj -r %t3.a32 | FileCheck --check-prefix=ANDROID32 %s

// ANDROID32-HEADERS:       Index: 1
// ANDROID32-HEADERS-NEXT:  Name: .dynsym

// ANDROID32-HEADERS:       Name: .rel.dyn
// ANDROID32-HEADERS-NEXT:  Type: SHT_ANDROID_REL
// ANDROID32-HEADERS-NEXT:  Flags [ (0x2)
// ANDROID32-HEADERS-NEXT:    SHF_ALLOC (0x2)
// ANDROID32-HEADERS-NEXT:  ]
// ANDROID32-HEADERS-NEXT:  Address: [[ADDR:.*]]
// ANDROID32-HEADERS-NEXT:  Offset: [[ADDR]]
// ANDROID32-HEADERS-NEXT:  Size: [[SIZE:.*]]
// ANDROID32-HEADERS-NEXT:  Link: 1
// ANDROID32-HEADERS-NEXT:  Info: 0
// ANDROID32-HEADERS-NEXT:  AddressAlignment: 4
// ANDROID32-HEADERS-NEXT:  EntrySize: 1

// ANDROID32-HEADERS: 0x6000000F ANDROID_REL          [[ADDR]]
// ANDROID32-HEADERS: 0x60000010 ANDROID_RELSZ        [[SIZE]]

/// Packed should have the groups of non-relative relocations first, followed
/// by the larger groups of relative relocations (i.e. the 8 and 9 followed
/// by the 7.)
// ANDROID32:          Section ({{.+}}) .rel.dyn {
// ANDROID32-NEXT:     0x30254 R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x30258 R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x3025C R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x30260 R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x30264 R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x30268 R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x3026C R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x30270 R_ARM_RELATIVE -

// ANDROID32-NEXT:     0x3029C R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x302A0 R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x302A4 R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x302A8 R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x302AC R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x302B0 R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x302B4 R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x302B8 R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x302BC R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x30278 R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x3027C R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x30280 R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x30284 R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x30288 R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x3028C R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x30290 R_ARM_RELATIVE -
// ANDROID32-NEXT:     0x302C1 R_ARM_RELATIVE -

// ANDROID32-NEXT:     0x30274 R_ARM_ABS32 bar2
// ANDROID32-NEXT:     0x30298 R_ARM_ABS32 bar2
// ANDROID32-NEXT:     0x302C5 R_ARM_ABS32 bar2
// ANDROID32-NEXT:     0x302C9 R_ARM_ABS32 bar2
// ANDROID32-NEXT:     0x302CD R_ARM_ABS32 bar2
// ANDROID32-NEXT:     0x302D1 R_ARM_ABS32 bar2
// ANDROID32-NEXT:     0x302D5 R_ARM_ABS32 bar2

// ANDROID32-NEXT:     0x30294 R_ARM_ABS32 zed2 0x0
// ANDROID32-NEXT:     }

// RUN: ld.lld -pie --pack-dyn-relocs=relr %t.a32.o %t.a32.so -o %t4.a32
// RUN: llvm-readobj -S --dynamic-table %t4.a32 | FileCheck --check-prefix=RELR32-HEADERS %s
// RUN: llvm-readobj -r --raw-relr %t4.a32 | FileCheck --check-prefix=RAW-RELR32 %s
// RUN: llvm-readobj -r %t4.a32 | FileCheck --check-prefix=RELR32 %s

// RELR32-HEADERS:       Index: 1
// RELR32-HEADERS-NEXT:  Name: .dynsym

// RELR32-HEADERS:       Name: .relr.dyn
// RELR32-HEADERS-NEXT:  Type: SHT_RELR
// RELR32-HEADERS-NEXT:  Flags [ (0x2)
// RELR32-HEADERS-NEXT:    SHF_ALLOC (0x2)
// RELR32-HEADERS-NEXT:  ]
// RELR32-HEADERS-NEXT:  Address: [[ADDR:.*]]
// RELR32-HEADERS-NEXT:  Offset: [[ADDR]]
// RELR32-HEADERS-NEXT:  Size: 8
// RELR32-HEADERS-NEXT:  Link: 0
// RELR32-HEADERS-NEXT:  Info: 0
// RELR32-HEADERS-NEXT:  AddressAlignment: 4
// RELR32-HEADERS-NEXT:  EntrySize: 4

// RELR32-HEADERS:       0x00000024 RELR                 [[ADDR]]
// RELR32-HEADERS:       0x00000023 RELRSZ               0x8
// RELR32-HEADERS:       0x00000025 RELRENT              0x4

/// SHT_RELR section contains address/bitmap entries
/// encoding the offsets for relative relocation.
// RAW-RELR32:           Section ({{.+}}) .relr.dyn {
// RAW-RELR32-NEXT:      0x30284
// RAW-RELR32-NEXT:      0x7FCFEFF
// RAW-RELR32-NEXT:      }

/// Decoded SHT_RELR section is same as UNPACKED,
/// but contains only the relative relocations.
/// Any relative relocations with odd offset stay in SHT_REL.
// RELR32:               Section ({{.+}}) .rel.dyn {
// RELR32-NEXT:          0x302F1 R_ARM_RELATIVE -
// RELR32-NEXT:          0x302A4 R_ARM_ABS32 bar2
// RELR32-NEXT:          0x302C8 R_ARM_ABS32 bar2
// RELR32-NEXT:          0x302F5 R_ARM_ABS32 bar2
// RELR32-NEXT:          0x302F9 R_ARM_ABS32 bar2
// RELR32-NEXT:          0x302FD R_ARM_ABS32 bar2
// RELR32-NEXT:          0x30301 R_ARM_ABS32 bar2
// RELR32-NEXT:          0x30305 R_ARM_ABS32 bar2
// RELR32-NEXT:          0x302C4 R_ARM_ABS32 zed2
// RELR32-NEXT:          }
// RELR32-NEXT:          Section ({{.+}}) .relr.dyn {
// RELR32-NEXT:          0x30284 R_ARM_RELATIVE -
// RELR32-NEXT:          0x30288 R_ARM_RELATIVE -
// RELR32-NEXT:          0x3028C R_ARM_RELATIVE -
// RELR32-NEXT:          0x30290 R_ARM_RELATIVE -
// RELR32-NEXT:          0x30294 R_ARM_RELATIVE -
// RELR32-NEXT:          0x30298 R_ARM_RELATIVE -
// RELR32-NEXT:          0x3029C R_ARM_RELATIVE -
// RELR32-NEXT:          0x302A0 R_ARM_RELATIVE -

// RELR32-NEXT:          0x302A8 R_ARM_RELATIVE -
// RELR32-NEXT:          0x302AC R_ARM_RELATIVE -
// RELR32-NEXT:          0x302B0 R_ARM_RELATIVE -
// RELR32-NEXT:          0x302B4 R_ARM_RELATIVE -
// RELR32-NEXT:          0x302B8 R_ARM_RELATIVE -
// RELR32-NEXT:          0x302BC R_ARM_RELATIVE -
// RELR32-NEXT:          0x302C0 R_ARM_RELATIVE -

// RELR32-NEXT:          0x302CC R_ARM_RELATIVE -
// RELR32-NEXT:          0x302D0 R_ARM_RELATIVE -
// RELR32-NEXT:          0x302D4 R_ARM_RELATIVE -
// RELR32-NEXT:          0x302D8 R_ARM_RELATIVE -
// RELR32-NEXT:          0x302DC R_ARM_RELATIVE -
// RELR32-NEXT:          0x302E0 R_ARM_RELATIVE -
// RELR32-NEXT:          0x302E4 R_ARM_RELATIVE -
// RELR32-NEXT:          0x302E8 R_ARM_RELATIVE -
// RELR32-NEXT:          0x302EC R_ARM_RELATIVE -
// RELR32-NEXT:          }

// RUN: llvm-mc -filetype=obj -triple=aarch64-unknown-linux %p/Inputs/shared2.s -o %t.a64.so.o
// RUN: ld.lld -shared %t.a64.so.o -soname=so -o %t.a64.so
// RUN: llvm-mc -filetype=obj -triple=aarch64-unknown-linux %s -o %t.a64.o
// RUN: ld.lld -pie --pack-dyn-relocs=none %t.a64.o %t.a64.so -o %t2.a64
// RUN: llvm-readobj -r %t2.a64 | FileCheck --check-prefix=UNPACKED64 %s

// UNPACKED64:          Section ({{.+}}) .rela.dyn {
// UNPACKED64-NEXT:     0x30690 R_AARCH64_RELATIVE - 0x1
// UNPACKED64-NEXT:     0x30698 R_AARCH64_RELATIVE - 0x2
// UNPACKED64-NEXT:     0x306A0 R_AARCH64_RELATIVE - 0x3
// UNPACKED64-NEXT:     0x306A8 R_AARCH64_RELATIVE - 0x4
// UNPACKED64-NEXT:     0x306B0 R_AARCH64_RELATIVE - 0x5
// UNPACKED64-NEXT:     0x306B8 R_AARCH64_RELATIVE - 0x6
// UNPACKED64-NEXT:     0x306C0 R_AARCH64_RELATIVE - 0x7
// UNPACKED64-NEXT:     0x306C8 R_AARCH64_RELATIVE - 0x8

// UNPACKED64-NEXT:     0x306D8 R_AARCH64_RELATIVE - 0x1
// UNPACKED64-NEXT:     0x306E0 R_AARCH64_RELATIVE - 0x2
// UNPACKED64-NEXT:     0x306E8 R_AARCH64_RELATIVE - 0x3
// UNPACKED64-NEXT:     0x306F0 R_AARCH64_RELATIVE - 0x4
// UNPACKED64-NEXT:     0x306F8 R_AARCH64_RELATIVE - 0x5
// UNPACKED64-NEXT:     0x30700 R_AARCH64_RELATIVE - 0x6
// UNPACKED64-NEXT:     0x30708 R_AARCH64_RELATIVE - 0x7

// UNPACKED64-NEXT:     0x30720 R_AARCH64_RELATIVE - 0x1
// UNPACKED64-NEXT:     0x30728 R_AARCH64_RELATIVE - 0x2
// UNPACKED64-NEXT:     0x30730 R_AARCH64_RELATIVE - 0x3
// UNPACKED64-NEXT:     0x30738 R_AARCH64_RELATIVE - 0x4
// UNPACKED64-NEXT:     0x30740 R_AARCH64_RELATIVE - 0x5
// UNPACKED64-NEXT:     0x30748 R_AARCH64_RELATIVE - 0x6
// UNPACKED64-NEXT:     0x30750 R_AARCH64_RELATIVE - 0x7
// UNPACKED64-NEXT:     0x30758 R_AARCH64_RELATIVE - 0x8
// UNPACKED64-NEXT:     0x30760 R_AARCH64_RELATIVE - 0x9

// UNPACKED64-NEXT:     0x30769 R_AARCH64_RELATIVE - 0xA
// UNPACKED64-NEXT:     0x306D0 R_AARCH64_ABS64 bar2 0x1
// UNPACKED64-NEXT:     0x30718 R_AARCH64_ABS64 bar2 0x0
// UNPACKED64-NEXT:     0x30771 R_AARCH64_ABS64 bar2 0x0
// UNPACKED64-NEXT:     0x30779 R_AARCH64_ABS64 bar2 0x0
// UNPACKED64-NEXT:     0x30781 R_AARCH64_ABS64 bar2 0x1
// UNPACKED64-NEXT:     0x30789 R_AARCH64_ABS64 bar2 0x1
// UNPACKED64-NEXT:     0x30791 R_AARCH64_ABS64 bar2 0x0
// UNPACKED64-NEXT:     0x30710 R_AARCH64_ABS64 zed2 0x0
// UNPACKED64-NEXT:     }

// RUN: ld.lld -pie --pack-dyn-relocs=android %t.a64.o %t.a64.so -o %t3.a64
// RUN: llvm-readobj -S --dynamic-table %t3.a64 | FileCheck --check-prefix=ANDROID64-HEADERS %s
// RUN: llvm-readobj -r %t3.a64 | FileCheck --check-prefix=ANDROID64 %s

// ANDROID64-HEADERS:       Index: 1
// ANDROID64-HEADERS-NEXT:  Name: .dynsym

// ANDROID64-HEADERS:       Name: .rela.dyn
// ANDROID64-HEADERS-NEXT:  Type: SHT_ANDROID_RELA
// ANDROID64-HEADERS-NEXT:  Flags [ (0x2)
// ANDROID64-HEADERS-NEXT:    SHF_ALLOC (0x2)
// ANDROID64-HEADERS-NEXT:  ]
// ANDROID64-HEADERS-NEXT:  Address: [[ADDR:.*]]
// ANDROID64-HEADERS-NEXT:  Offset: [[ADDR]]
// ANDROID64-HEADERS-NEXT:  Size: [[SIZE:.*]]
// ANDROID64-HEADERS-NEXT:  Link: 1
// ANDROID64-HEADERS-NEXT:  Info: 0
// ANDROID64-HEADERS-NEXT:  AddressAlignment: 8
// ANDROID64-HEADERS-NEXT:  EntrySize: 1

// ANDROID64-HEADERS: 0x0000000060000011 ANDROID_RELA          [[ADDR]]
// ANDROID64-HEADERS: 0x0000000060000012 ANDROID_RELASZ        [[SIZE]]

// ANDROID64:          Section ({{.+}}) .rela.dyn {
// ANDROID64-NEXT:     0x303F0 R_AARCH64_RELATIVE - 0x1
// ANDROID64-NEXT:     0x303F8 R_AARCH64_RELATIVE - 0x2
// ANDROID64-NEXT:     0x30400 R_AARCH64_RELATIVE - 0x3
// ANDROID64-NEXT:     0x30408 R_AARCH64_RELATIVE - 0x4
// ANDROID64-NEXT:     0x30410 R_AARCH64_RELATIVE - 0x5
// ANDROID64-NEXT:     0x30418 R_AARCH64_RELATIVE - 0x6
// ANDROID64-NEXT:     0x30420 R_AARCH64_RELATIVE - 0x7
// ANDROID64-NEXT:     0x30428 R_AARCH64_RELATIVE - 0x8

// ANDROID64-NEXT:     0x30480 R_AARCH64_RELATIVE - 0x1
// ANDROID64-NEXT:     0x30488 R_AARCH64_RELATIVE - 0x2
// ANDROID64-NEXT:     0x30490 R_AARCH64_RELATIVE - 0x3
// ANDROID64-NEXT:     0x30498 R_AARCH64_RELATIVE - 0x4
// ANDROID64-NEXT:     0x304A0 R_AARCH64_RELATIVE - 0x5
// ANDROID64-NEXT:     0x304A8 R_AARCH64_RELATIVE - 0x6
// ANDROID64-NEXT:     0x304B0 R_AARCH64_RELATIVE - 0x7
// ANDROID64-NEXT:     0x304B8 R_AARCH64_RELATIVE - 0x8
// ANDROID64-NEXT:     0x304C0 R_AARCH64_RELATIVE - 0x9

// ANDROID64-NEXT:     0x30438 R_AARCH64_RELATIVE - 0x1
// ANDROID64-NEXT:     0x30440 R_AARCH64_RELATIVE - 0x2
// ANDROID64-NEXT:     0x30448 R_AARCH64_RELATIVE - 0x3
// ANDROID64-NEXT:     0x30450 R_AARCH64_RELATIVE - 0x4
// ANDROID64-NEXT:     0x30458 R_AARCH64_RELATIVE - 0x5
// ANDROID64-NEXT:     0x30460 R_AARCH64_RELATIVE - 0x6
// ANDROID64-NEXT:     0x30468 R_AARCH64_RELATIVE - 0x7
// ANDROID64-NEXT:     0x304C9 R_AARCH64_RELATIVE - 0xA

// ANDROID64-NEXT:     0x30478 R_AARCH64_ABS64 bar2 0x0
// ANDROID64-NEXT:     0x304D1 R_AARCH64_ABS64 bar2 0x0
// ANDROID64-NEXT:     0x304D9 R_AARCH64_ABS64 bar2 0x0
// ANDROID64-NEXT:     0x304F1 R_AARCH64_ABS64 bar2 0x0
// ANDROID64-NEXT:     0x30430 R_AARCH64_ABS64 bar2 0x1
// ANDROID64-NEXT:     0x30470 R_AARCH64_ABS64 zed2 0x0
// ANDROID64-NEXT:     0x304E1 R_AARCH64_ABS64 bar2 0x1
// ANDROID64-NEXT:     0x304E9 R_AARCH64_ABS64 bar2 0x1
// ANDROID64-NEXT:     }

// RUN: ld.lld -pie --pack-dyn-relocs=relr %t.a64.o %t.a64.so -o %t4.a64
// RUN: llvm-readobj -S --dynamic-table %t4.a64 | FileCheck --check-prefix=RELR64-HEADERS %s
// RUN: llvm-readobj -r --raw-relr %t4.a64 | FileCheck --check-prefix=RAW-RELR64 %s
// RUN: llvm-readobj -r %t4.a64 | FileCheck --check-prefix=RELR64 %s

// RELR64-HEADERS:       Index: 1
// RELR64-HEADERS-NEXT:  Name: .dynsym

// RELR64-HEADERS:       Name: .relr.dyn
// RELR64-HEADERS-NEXT:  Type: SHT_RELR
// RELR64-HEADERS-NEXT:  Flags [ (0x2)
// RELR64-HEADERS-NEXT:    SHF_ALLOC (0x2)
// RELR64-HEADERS-NEXT:  ]
// RELR64-HEADERS-NEXT:  Address: [[ADDR:.*]]
// RELR64-HEADERS-NEXT:  Offset: [[ADDR]]
// RELR64-HEADERS-NEXT:  Size: 16
// RELR64-HEADERS-NEXT:  Link: 0
// RELR64-HEADERS-NEXT:  Info: 0
// RELR64-HEADERS-NEXT:  AddressAlignment: 8
// RELR64-HEADERS-NEXT:  EntrySize: 8

// RELR64-HEADERS:       0x0000000000000024 RELR                 [[ADDR]]
// RELR64-HEADERS:       0x0000000000000023 RELRSZ               0x10
// RELR64-HEADERS:       0x0000000000000025 RELRENT              0x8

/// SHT_RELR section contains address/bitmap entries
/// encoding the offsets for relative relocation.
// RAW-RELR64:           Section ({{.+}}) .relr.dyn {
// RAW-RELR64-NEXT:      0x30490
// RAW-RELR64-NEXT:      0x7FCFEFF
// RAW-RELR64-NEXT:      }

/// Decoded SHT_RELR section is same as UNPACKED,
/// but contains only the relative relocations.
/// Any relative relocations with odd offset stay in SHT_RELA.
// RELR64:      Section ({{.+}}) .rela.dyn {
// RELR64-NEXT:   0x30569 R_AARCH64_RELATIVE - 0xA
// RELR64-NEXT:   0x304D0 R_AARCH64_ABS64 bar2 0x1
// RELR64-NEXT:   0x30518 R_AARCH64_ABS64 bar2 0x0
// RELR64-NEXT:   0x30571 R_AARCH64_ABS64 bar2 0x0
// RELR64-NEXT:   0x30579 R_AARCH64_ABS64 bar2 0x0
// RELR64-NEXT:   0x30581 R_AARCH64_ABS64 bar2 0x1
// RELR64-NEXT:   0x30589 R_AARCH64_ABS64 bar2 0x1
// RELR64-NEXT:   0x30591 R_AARCH64_ABS64 bar2 0x0
// RELR64-NEXT:   0x30510 R_AARCH64_ABS64 zed2 0x0
// RELR64-NEXT: }
// RELR64-NEXT: Section ({{.+}}) .relr.dyn {
// RELR64-NEXT:   0x30490 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x30498 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x304A0 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x304A8 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x304B0 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x304B8 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x304C0 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x304C8 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x304D8 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x304E0 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x304E8 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x304F0 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x304F8 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x30500 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x30508 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x30520 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x30528 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x30530 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x30538 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x30540 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x30548 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x30550 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x30558 R_AARCH64_RELATIVE -
// RELR64-NEXT:   0x30560 R_AARCH64_RELATIVE -
// RELR64-NEXT: }

.data
.align 2
.dc.a __ehdr_start + 1
.dc.a __ehdr_start + 2
.dc.a __ehdr_start + 3
.dc.a __ehdr_start + 4
.dc.a __ehdr_start + 5
.dc.a __ehdr_start + 6
.dc.a __ehdr_start + 7
.dc.a __ehdr_start + 8
.dc.a bar2 + 1

.dc.a __ehdr_start + 1
.dc.a __ehdr_start + 2
.dc.a __ehdr_start + 3
.dc.a __ehdr_start + 4
.dc.a __ehdr_start + 5
.dc.a __ehdr_start + 6
.dc.a __ehdr_start + 7
.dc.a zed2
.dc.a bar2

.dc.a __ehdr_start + 1
.dc.a __ehdr_start + 2
.dc.a __ehdr_start + 3
.dc.a __ehdr_start + 4
.dc.a __ehdr_start + 5
.dc.a __ehdr_start + 6
.dc.a __ehdr_start + 7
.dc.a __ehdr_start + 8
.dc.a __ehdr_start + 9
.byte 00
.dc.a __ehdr_start + 10
.dc.a bar2
.dc.a bar2
.dc.a bar2 + 1
.dc.a bar2 + 1
.dc.a bar2
