var searchIndex={};
searchIndex["alloc"] = {"doc":"The Rust core allocation and collections library","i":[[0,"alloc","alloc","Memory allocation APIs",null,null],[3,"Layout","alloc::alloc","Layout of a block of memory.",null,null],[3,"LayoutErr","","The parameters given to `Layout::from_size_align` or some…",null,null],[3,"AllocErr","","The `AllocErr` error indicates an allocation failure that…",null,null],[3,"CannotReallocInPlace","","The `CannotReallocInPlace` error is used when…",null,null],[8,"GlobalAlloc","","A memory allocator that can be registered as the standard…",null,null],[10,"alloc","","Allocate memory as described by the given `layout`.",0,[[["layout"],["self"]]]],[10,"dealloc","","Deallocate the block of memory at the given `ptr` pointer…",0,[[["layout"],["self"]]]],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents…",0,[[["layout"],["self"]]]],[11,"realloc","","Shrink or grow a block of memory to the given `new_size`.…",0,[[["layout"],["self"],["usize"]]]],[8,"AllocRef","","An implementation of `AllocRef` can allocate, reallocate,…",null,null],[10,"alloc","","On success, returns a pointer meeting the size and…",1,[[["self"],["layout"]],[["result",["allocerr"]],["allocerr"]]]],[10,"dealloc","","Deallocate the memory referenced by `ptr`.",1,[[["layout"],["nonnull",["u8"]],["self"],["u8"]]]],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents…",1,[[["self"],["layout"]],[["result",["allocerr"]],["allocerr"]]]],[11,"realloc","","Returns a pointer suitable for holding data described by a…",1,[[["layout"],["usize"],["nonnull",["u8"]],["self"],["u8"]],[["result",["allocerr"]],["allocerr"]]]],[11,"realloc_zeroed","","Behaves like `realloc`, but also ensures that the new…",1,[[["layout"],["usize"],["nonnull",["u8"]],["self"],["u8"]],[["result",["allocerr"]],["allocerr"]]]],[11,"grow_in_place","","Attempts to extend the allocation referenced by `ptr` to…",1,[[["layout"],["usize"],["nonnull",["u8"]],["self"],["u8"]],[["result",["usize","cannotreallocinplace"]],["usize"],["cannotreallocinplace"]]]],[11,"grow_in_place_zeroed","","Behaves like `grow_in_place`, but also ensures that the…",1,[[["layout"],["usize"],["nonnull",["u8"]],["self"],["u8"]],[["result",["usize","cannotreallocinplace"]],["usize"],["cannotreallocinplace"]]]],[11,"shrink_in_place","","Attempts to shrink the allocation referenced by `ptr` to…",1,[[["layout"],["usize"],["nonnull",["u8"]],["self"],["u8"]],[["result",["usize","cannotreallocinplace"]],["usize"],["cannotreallocinplace"]]]],[3,"Global","","The global memory allocator.",null,null],[5,"alloc","","Allocate memory with the global allocator.",null,[[["layout"]]]],[5,"dealloc","","Deallocate memory with the global allocator.",null,[[["layout"]]]],[5,"realloc","","Reallocate memory with the global allocator.",null,[[["layout"],["usize"]]]],[5,"alloc_zeroed","","Allocate zero-initialized memory with the global allocator.",null,[[["layout"]]]],[5,"handle_alloc_error","","Abort on memory allocation error or failure.",null,[[["layout"]]]],[0,"boxed","alloc","A pointer type for heap allocation.",null,null],[3,"Box","alloc::boxed","A pointer type for heap allocation.",null,null],[11,"new","","Allocates memory on the heap and then places `x` into it.",2,[[["t"]],["box"]]],[11,"new_uninit","","Constructs a new box with uninitialized contents.",2,[[],[["box",["maybeuninit"]],["maybeuninit"]]]],[11,"new_zeroed","","Constructs a new `Box` with uninitialized contents, with…",2,[[],[["box",["maybeuninit"]],["maybeuninit"]]]],[11,"pin","","Constructs a new `Pin<Box<T>>`. If `T` does not implement…",2,[[["t"]],[["box"],["pin",["box"]]]]],[11,"new_uninit_slice","","Constructs a new boxed slice with uninitialized contents.",2,[[["usize"]],["box"]]],[11,"assume_init","","Converts to `Box<T>`.",2,[[],["box"]]],[11,"assume_init","","Converts to `Box<[T]>`.",2,[[],["box"]]],[11,"from_raw","","Constructs a box from a raw pointer.",2,[[],["self"]]],[11,"into_raw","","Consumes the `Box`, returning a wrapped raw pointer.",2,[[["box"]]]],[11,"into_raw_non_null","","Consumes the `Box`, returning the wrapped pointer as…",2,[[["box"]],["nonnull"]]],[11,"leak","","Consumes and leaks the `Box`, returning a mutable…",2,[[["box"]],["t"]]],[11,"into_pin","","Converts a `Box<T>` into a `Pin<Box<T>>`",2,[[["box"]],[["box"],["pin",["box"]]]]],[11,"downcast","","Attempt to downcast the box to a concrete type.",2,[[],[["box"],["result",["box","box"]],["box",["any"]]]]],[11,"downcast","","Attempt to downcast the box to a concrete type.",2,[[],[["box"],["result",["box","box"]],["box",["any"]]]]],[0,"borrow","alloc","A module for working with borrowed data.",null,null],[8,"Borrow","alloc::borrow","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",3,[[["self"]],["borrowed"]]],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",4,[[["self"]],["borrowed"]]],[4,"Cow","","A clone-on-write smart pointer.",null,null],[13,"Borrowed","","Borrowed data.",5,null],[13,"Owned","","Owned data.",5,null],[8,"ToOwned","","A generalization of `Clone` to borrowed data.",null,null],[16,"Owned","","The resulting type after obtaining ownership.",6,null],[10,"to_owned","","Creates owned data from borrowed data, usually by cloning.",6,[[["self"]]]],[11,"clone_into","","Uses borrowed data to replace owned data, usually by…",6,[[["self"]]]],[11,"is_borrowed","","Returns true if the data is borrowed, i.e. if `to_mut`…",5,[[["self"]],["bool"]]],[11,"is_owned","","Returns true if the data is owned, i.e. if `to_mut` would…",5,[[["self"]],["bool"]]],[11,"to_mut","","Acquires a mutable reference to the owned form of the data.",5,[[["self"]]]],[11,"into_owned","","Extracts the owned data.",5,[[]]],[0,"collections","alloc","Collection types.",null,null],[4,"TryReserveError","alloc::collections","The error type for `try_reserve` methods.",null,null],[13,"CapacityOverflow","","Error due to the computed capacity exceeding the…",7,null],[13,"AllocError","","The memory allocator returned an error",7,null],[12,"layout","alloc::collections::TryReserveError","The layout of allocation request that failed",8,null],[0,"binary_heap","alloc::collections","A priority queue implemented with a binary heap.",null,null],[3,"BinaryHeap","alloc::collections::binary_heap","A priority queue implemented with a binary heap.",null,null],[3,"PeekMut","","Structure wrapping a mutable reference to the greatest…",null,null],[3,"Iter","","An iterator over the elements of a `BinaryHeap`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `BinaryHeap`.",null,null],[3,"IntoIterSorted","","",null,null],[3,"Drain","","A draining iterator over the elements of a `BinaryHeap`.",null,null],[3,"DrainSorted","","A draining iterator over the elements of a `BinaryHeap`.",null,null],[11,"pop","","Removes the peeked value from the heap and returns it.",9,[[["peekmut"]],["t"]]],[11,"new","","Creates an empty `BinaryHeap` as a max-heap.",10,[[],["binaryheap"]]],[11,"with_capacity","","Creates an empty `BinaryHeap` with a specific capacity.…",10,[[["usize"]],["binaryheap"]]],[11,"peek_mut","","Returns a mutable reference to the greatest item in the…",10,[[["self"]],[["option",["peekmut"]],["peekmut"]]]],[11,"pop","","Removes the greatest item from the binary heap and returns…",10,[[["self"]],["option"]]],[11,"push","","Pushes an item onto the binary heap.",10,[[["self"],["t"]]]],[11,"into_sorted_vec","","Consumes the `BinaryHeap` and returns a vector in sorted…",10,[[],["vec"]]],[11,"append","","Moves all the elements of `other` into `self`, leaving…",10,[[["self"]]]],[11,"drain_sorted","","Returns an iterator which retrieves elements in heap…",10,[[["self"]],["drainsorted"]]],[11,"iter","","Returns an iterator visiting all values in the underlying…",10,[[["self"]],["iter"]]],[11,"into_iter_sorted","","Returns an iterator which retrieves elements in heap…",10,[[],["intoitersorted"]]],[11,"peek","","Returns the greatest item in the binary heap, or `None` if…",10,[[["self"]],[["option"],["t"]]]],[11,"capacity","","Returns the number of elements the binary heap can hold…",10,[[["self"]],["usize"]]],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional`…",10,[[["self"],["usize"]]]],[11,"reserve","","Reserves capacity for at least `additional` more elements…",10,[[["self"],["usize"]]]],[11,"shrink_to_fit","","Discards as much additional capacity as possible.",10,[[["self"]]]],[11,"shrink_to","","Discards capacity with a lower bound.",10,[[["self"],["usize"]]]],[11,"into_vec","","Consumes the `BinaryHeap` and returns the underlying…",10,[[],["vec"]]],[11,"len","","Returns the length of the binary heap.",10,[[["self"]],["usize"]]],[11,"is_empty","","Checks if the binary heap is empty.",10,[[["self"]],["bool"]]],[11,"drain","","Clears the binary heap, returning an iterator over the…",10,[[["self"]],["drain"]]],[11,"clear","","Drops all items from the binary heap.",10,[[["self"]]]],[0,"linked_list","alloc::collections","A doubly-linked list with owned nodes.",null,null],[3,"LinkedList","alloc::collections::linked_list","A doubly-linked list with owned nodes.",null,null],[3,"Iter","","An iterator over the elements of a `LinkedList`.",null,null],[3,"IterMut","","A mutable iterator over the elements of a `LinkedList`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `LinkedList`.",null,null],[3,"Cursor","","A cursor over a `LinkedList`.",null,null],[3,"CursorMut","","A cursor over a `LinkedList` with editing operations.",null,null],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on…",null,null],[11,"new","","Creates an empty `LinkedList`.",11,[[],["self"]]],[11,"append","","Moves all elements from `other` to the end of the list.",11,[[["self"]]]],[11,"prepend","","Moves all elements from `other` to the begin of the list.",11,[[["self"]]]],[11,"iter","","Provides a forward iterator.",11,[[["self"]],["iter"]]],[11,"iter_mut","","Provides a forward iterator with mutable references.",11,[[["self"]],["itermut"]]],[11,"cursor_front","","Provides a cursor at the front element.",11,[[["self"]],["cursor"]]],[11,"cursor_front_mut","","Provides a cursor with editing operations at the front…",11,[[["self"]],["cursormut"]]],[11,"cursor_back","","Provides a cursor at the back element.",11,[[["self"]],["cursor"]]],[11,"cursor_back_mut","","Provides a cursor with editing operations at the back…",11,[[["self"]],["cursormut"]]],[11,"is_empty","","Returns `true` if the `LinkedList` is empty.",11,[[["self"]],["bool"]]],[11,"len","","Returns the length of the `LinkedList`.",11,[[["self"]],["usize"]]],[11,"clear","","Removes all elements from the `LinkedList`.",11,[[["self"]]]],[11,"contains","","Returns `true` if the `LinkedList` contains an element…",11,[[["t"],["self"]],["bool"]]],[11,"front","","Provides a reference to the front element, or `None` if…",11,[[["self"]],[["option"],["t"]]]],[11,"front_mut","","Provides a mutable reference to the front element, or…",11,[[["self"]],[["option"],["t"]]]],[11,"back","","Provides a reference to the back element, or `None` if the…",11,[[["self"]],[["option"],["t"]]]],[11,"back_mut","","Provides a mutable reference to the back element, or…",11,[[["self"]],[["option"],["t"]]]],[11,"push_front","","Adds an element first in the list.",11,[[["self"],["t"]]]],[11,"pop_front","","Removes the first element and returns it, or `None` if the…",11,[[["self"]],["option"]]],[11,"push_back","","Appends an element to the back of a list.",11,[[["self"],["t"]]]],[11,"pop_back","","Removes the last element from a list and returns it, or…",11,[[["self"]],["option"]]],[11,"split_off","","Splits the list into two at the given index. Returns…",11,[[["self"],["usize"]],["linkedlist"]]],[11,"remove","","Removes the element at the given index and returns it.",11,[[["self"],["usize"]],["t"]]],[11,"drain_filter","","Creates an iterator which uses a closure to determine if…",11,[[["self"],["f"]],["drainfilter"]]],[11,"insert_next","","Inserts the given element just after the element most…",12,[[["self"],["t"]]]],[11,"peek_next","","Provides a reference to the next element, without changing…",12,[[["self"]],[["option"],["t"]]]],[11,"index","","Returns the cursor position index within the `LinkedList`.",13,[[["self"]],[["option",["usize"]],["usize"]]]],[11,"move_next","","Moves the cursor to the next element of the `LinkedList`.",13,[[["self"]]]],[11,"move_prev","","Moves the cursor to the previous element of the…",13,[[["self"]]]],[11,"current","","Returns a reference to the element that the cursor is…",13,[[["self"]],[["option"],["t"]]]],[11,"peek_next","","Returns a reference to the next element.",13,[[["self"]],[["option"],["t"]]]],[11,"peek_prev","","Returns a reference to the previous element.",13,[[["self"]],[["option"],["t"]]]],[11,"index","","Returns the cursor position index within the `LinkedList`.",14,[[["self"]],[["option",["usize"]],["usize"]]]],[11,"move_next","","Moves the cursor to the next element of the `LinkedList`.",14,[[["self"]]]],[11,"move_prev","","Moves the cursor to the previous element of the…",14,[[["self"]]]],[11,"current","","Returns a reference to the element that the cursor is…",14,[[["self"]],[["option"],["t"]]]],[11,"peek_next","","Returns a reference to the next element.",14,[[["self"]],[["option"],["t"]]]],[11,"peek_prev","","Returns a reference to the previous element.",14,[[["self"]],[["option"],["t"]]]],[11,"as_cursor","","Returns a read-only cursor pointing to the current element.",14,[[["self"]],["cursor"]]],[11,"insert_after","","Inserts a new element into the `LinkedList` after the…",14,[[["self"],["t"]]]],[11,"insert_before","","Inserts a new element into the `LinkedList` before the…",14,[[["self"],["t"]]]],[11,"remove_current","","Removes the current element from the `LinkedList`.",14,[[["self"]],["option"]]],[11,"splice_after","","Inserts the elements from the given `LinkedList` after the…",14,[[["self"],["linkedlist"]]]],[11,"splice_before","","Inserts the elements from the given `LinkedList` before…",14,[[["self"],["linkedlist"]]]],[11,"split_after","","Splits the list into two after the current element. This…",14,[[["self"]],["linkedlist"]]],[11,"split_before","","Splits the list into two before the current element. This…",14,[[["self"]],["linkedlist"]]],[0,"vec_deque","alloc::collections","A double-ended queue implemented with a growable ring…",null,null],[3,"Drain","alloc::collections::vec_deque","A draining iterator over the elements of a `VecDeque`.",null,null],[3,"VecDeque","","A double-ended queue implemented with a growable ring…",null,null],[3,"Iter","","An iterator over the elements of a `VecDeque`.",null,null],[3,"IterMut","","A mutable iterator over the elements of a `VecDeque`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `VecDeque`.",null,null],[11,"new","","Creates an empty `VecDeque`.",15,[[],["vecdeque"]]],[11,"with_capacity","","Creates an empty `VecDeque` with space for at least…",15,[[["usize"]],["vecdeque"]]],[11,"get","","Retrieves an element in the `VecDeque` by index.",15,[[["usize"],["self"]],[["option"],["t"]]]],[11,"get_mut","","Retrieves an element in the `VecDeque` mutably by index.",15,[[["self"],["usize"]],[["option"],["t"]]]],[11,"swap","","Swaps elements at indices `i` and `j`.",15,[[["self"],["usize"]]]],[11,"capacity","","Returns the number of elements the `VecDeque` can hold…",15,[[["self"]],["usize"]]],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional`…",15,[[["self"],["usize"]]]],[11,"reserve","","Reserves capacity for at least `additional` more elements…",15,[[["self"],["usize"]]]],[11,"try_reserve_exact","","Tries to reserves the minimum capacity for exactly…",15,[[["self"],["usize"]],[["result",["tryreserveerror"]],["tryreserveerror"]]]],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more…",15,[[["self"],["usize"]],[["result",["tryreserveerror"]],["tryreserveerror"]]]],[11,"shrink_to_fit","","Shrinks the capacity of the `VecDeque` as much as possible.",15,[[["self"]]]],[11,"shrink_to","","Shrinks the capacity of the `VecDeque` with a lower bound.",15,[[["self"],["usize"]]]],[11,"truncate","","Shortens the `VecDeque`, keeping the first `len` elements…",15,[[["self"],["usize"]]]],[11,"iter","","Returns a front-to-back iterator.",15,[[["self"]],["iter"]]],[11,"iter_mut","","Returns a front-to-back iterator that returns mutable…",15,[[["self"]],["itermut"]]],[11,"as_slices","","Returns a pair of slices which contain, in order, the…",15,[[["self"]]]],[11,"as_mut_slices","","Returns a pair of slices which contain, in order, the…",15,[[["self"]]]],[11,"len","","Returns the number of elements in the `VecDeque`.",15,[[["self"]],["usize"]]],[11,"is_empty","","Returns `true` if the `VecDeque` is empty.",15,[[["self"]],["bool"]]],[11,"drain","","Creates a draining iterator that removes the specified…",15,[[["self"],["r"]],["drain"]]],[11,"clear","","Clears the `VecDeque`, removing all values.",15,[[["self"]]]],[11,"contains","","Returns `true` if the `VecDeque` contains an element equal…",15,[[["t"],["self"]],["bool"]]],[11,"front","","Provides a reference to the front element, or `None` if…",15,[[["self"]],[["option"],["t"]]]],[11,"front_mut","","Provides a mutable reference to the front element, or…",15,[[["self"]],[["option"],["t"]]]],[11,"back","","Provides a reference to the back element, or `None` if the…",15,[[["self"]],[["option"],["t"]]]],[11,"back_mut","","Provides a mutable reference to the back element, or…",15,[[["self"]],[["option"],["t"]]]],[11,"pop_front","","Removes the first element and returns it, or `None` if the…",15,[[["self"]],["option"]]],[11,"pop_back","","Removes the last element from the `VecDeque` and returns…",15,[[["self"]],["option"]]],[11,"push_front","","Prepends an element to the `VecDeque`.",15,[[["self"],["t"]]]],[11,"push_back","","Appends an element to the back of the `VecDeque`.",15,[[["self"],["t"]]]],[11,"swap_remove_front","","Removes an element from anywhere in the `VecDeque` and…",15,[[["self"],["usize"]],["option"]]],[11,"swap_remove_back","","Removes an element from anywhere in the `VecDeque` and…",15,[[["self"],["usize"]],["option"]]],[11,"insert","","Inserts an element at `index` within the `VecDeque`,…",15,[[["self"],["usize"],["t"]]]],[11,"remove","","Removes and returns the element at `index` from the…",15,[[["self"],["usize"]],["option"]]],[11,"split_off","","Splits the `VecDeque` into two at the given index.",15,[[["self"],["usize"]],["self"]]],[11,"append","","Moves all the elements of `other` into `self`, leaving…",15,[[["self"]]]],[11,"retain","","Retains only the elements specified by the predicate.",15,[[["self"],["f"]]]],[11,"resize_with","","Modifies the `VecDeque` in-place so that `len()` is equal…",15,[[["self"],["usize"]]]],[11,"rotate_left","","Rotates the double-ended queue `mid` places to the left.",15,[[["self"],["usize"]]]],[11,"rotate_right","","Rotates the double-ended queue `k` places to the right.",15,[[["self"],["usize"]]]],[11,"resize","","Modifies the `VecDeque` in-place so that `len()` is equal…",15,[[["self"],["usize"],["t"]]]],[0,"btree_map","alloc::collections","A map based on a B-Tree.",null,null],[3,"BTreeMap","alloc::collections::btree_map","A map based on a B-Tree.",null,null],[3,"Iter","","An iterator over the entries of a `BTreeMap`.",null,null],[3,"IterMut","","A mutable iterator over the entries of a `BTreeMap`.",null,null],[3,"IntoIter","","An owning iterator over the entries of a `BTreeMap`.",null,null],[3,"Keys","","An iterator over the keys of a `BTreeMap`.",null,null],[3,"Values","","An iterator over the values of a `BTreeMap`.",null,null],[3,"ValuesMut","","A mutable iterator over the values of a `BTreeMap`.",null,null],[3,"Range","","An iterator over a sub-range of entries in a `BTreeMap`.",null,null],[3,"RangeMut","","A mutable iterator over a sub-range of entries in a…",null,null],[3,"VacantEntry","","A view into a vacant entry in a `BTreeMap`. It is part of…",null,null],[3,"OccupiedEntry","","A view into an occupied entry in a `BTreeMap`. It is part…",null,null],[4,"Entry","","A view into a single entry in a map, which may either be…",null,null],[13,"Vacant","","A vacant entry.",16,null],[13,"Occupied","","An occupied entry.",16,null],[0,"btree_set","alloc::collections","A set based on a B-Tree.",null,null],[3,"BTreeSet","alloc::collections::btree_set","A set based on a B-Tree.",null,null],[3,"Iter","","An iterator over the items of a `BTreeSet`.",null,null],[3,"IntoIter","","An owning iterator over the items of a `BTreeSet`.",null,null],[3,"Range","","An iterator over a sub-range of items in a `BTreeSet`.",null,null],[3,"Difference","","A lazy iterator producing elements in the difference of…",null,null],[3,"SymmetricDifference","","A lazy iterator producing elements in the symmetric…",null,null],[3,"Intersection","","A lazy iterator producing elements in the intersection of…",null,null],[3,"Union","","A lazy iterator producing elements in the union of…",null,null],[0,"fmt","alloc","Utilities for formatting and printing `String`s.",null,null],[4,"Alignment","alloc::fmt","Possible alignments returned by `Formatter::align`",null,null],[13,"Left","","Indication that contents should be left-aligned.",17,null],[13,"Right","","Indication that contents should be right-aligned.",17,null],[13,"Center","","Indication that contents should be center-aligned.",17,null],[3,"Error","","The error type which is returned from formatting a message…",null,null],[5,"write","","The `write` function takes an output stream, and an…",null,[[["write"],["arguments"]],[["error"],["result",["error"]]]]],[3,"Arguments","","This structure represents a safely precompiled version of…",null,null],[8,"Binary","","`b` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",18,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[8,"Octal","","`o` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",19,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[8,"Debug","","`?` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",20,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[14,"Debug","","Derive macro generating an impl of the trait `Debug`.",null,null],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",21,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugStruct","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"Formatter","","Configuration for formatting.",null,null],[6,"Result","","The type returned by formatter methods.",null,null],[8,"Write","","A collection of methods that are required to format a…",null,null],[10,"write_str","","Writes a string slice into this writer, returning whether…",22,[[["str"],["self"]],[["error"],["result",["error"]]]]],[11,"write_char","","Writes a [`char`] into this writer, returning whether the…",22,[[["self"],["char"]],[["error"],["result",["error"]]]]],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors…",22,[[["self"],["arguments"]],[["error"],["result",["error"]]]]],[8,"LowerExp","","`e` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",23,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[8,"UpperExp","","`E` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",24,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[8,"LowerHex","","`x` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",25,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[8,"Pointer","","`p` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",26,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[8,"UpperHex","","`X` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",27,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[5,"format","","The `format` function takes an [`Arguments`] struct and…",null,[[["arguments"]],["string"]]],[0,"prelude","alloc","The alloc Prelude",null,null],[0,"v1","alloc::prelude","The first version of the prelude of `alloc` crate.",null,null],[0,"rc","alloc","Single-threaded reference-counting pointers. 'Rc' stands…",null,null],[3,"Rc","alloc::rc","A single-threaded reference-counting pointer. 'Rc' stands…",null,null],[3,"Weak","","`Weak` is a version of [`Rc`] that holds a non-owning…",null,null],[11,"new","","Constructs a new `Rc<T>`.",28,[[["t"]],["rc"]]],[11,"new_uninit","","Constructs a new `Rc` with uninitialized contents.",28,[[],[["rc",["maybeuninit"]],["maybeuninit"]]]],[11,"new_zeroed","","Constructs a new `Rc` with uninitialized contents, with…",28,[[],[["rc",["maybeuninit"]],["maybeuninit"]]]],[11,"pin","","Constructs a new `Pin<Rc<T>>`. If `T` does not implement…",28,[[["t"]],[["pin",["rc"]],["rc"]]]],[11,"try_unwrap","","Returns the inner value, if the `Rc` has exactly one…",28,[[],["result"]]],[11,"new_uninit_slice","","Constructs a new reference-counted slice with…",28,[[["usize"]],["rc"]]],[11,"assume_init","","Converts to `Rc<T>`.",28,[[],["rc"]]],[11,"assume_init","","Converts to `Rc<[T]>`.",28,[[],["rc"]]],[11,"into_raw","","Consumes the `Rc`, returning the wrapped pointer.",28,[[]]],[11,"from_raw","","Constructs an `Rc` from a raw pointer.",28,[[],["self"]]],[11,"into_raw_non_null","","Consumes the `Rc`, returning the wrapped pointer as…",28,[[],["nonnull"]]],[11,"downgrade","","Creates a new [`Weak`][weak] pointer to this allocation.",28,[[["self"]],["weak"]]],[11,"weak_count","","Gets the number of [`Weak`][weak] pointers to this…",28,[[["self"]],["usize"]]],[11,"strong_count","","Gets the number of strong (`Rc`) pointers to this…",28,[[["self"]],["usize"]]],[11,"get_mut","","Returns a mutable reference into the given `Rc`, if there…",28,[[["self"]],[["option"],["t"]]]],[11,"get_mut_unchecked","","Returns a mutable reference into the given `Rc`, without…",28,[[["self"]],["t"]]],[11,"ptr_eq","","Returns `true` if the two `Rc`s point to the same…",28,[[["self"]],["bool"]]],[11,"make_mut","","Makes a mutable reference into the given `Rc`.",28,[[["self"]],["t"]]],[11,"downcast","","Attempt to downcast the `Rc<dyn Any>` to a concrete type.",28,[[],[["result",["rc","rc"]],["rc",["any"]],["rc"]]]],[11,"new","","Constructs a new `Weak<T>`, without allocating any memory.…",29,[[],["weak"]]],[11,"as_raw","","Returns a raw pointer to the object `T` pointed to by this…",29,[[["self"]]]],[11,"into_raw","","Consumes the `Weak<T>` and turns it into a raw pointer.",29,[[]]],[11,"from_raw","","Converts a raw pointer previously created by [`into_raw`]…",29,[[],["self"]]],[11,"upgrade","","Attempts to upgrade the `Weak` pointer to an [`Rc`],…",29,[[["self"]],[["option",["rc"]],["rc"]]]],[11,"strong_count","","Gets the number of strong (`Rc`) pointers pointing to this…",29,[[["self"]],["usize"]]],[11,"weak_count","","Gets the number of `Weak` pointers pointing to this…",29,[[["self"]],["usize"]]],[11,"ptr_eq","","Returns `true` if the two `Weak`s point to the same…",29,[[["self"]],["bool"]]],[0,"slice","alloc","A dynamically-sized view into a contiguous sequence, `[T]`.",null,null],[8,"SliceIndex","alloc::slice","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",30,null],[10,"get","","Returns a shared reference to the output at this location,…",30,[[["t"]],["option"]]],[10,"get_mut","","Returns a mutable reference to the output at this…",30,[[["t"]],["option"]]],[10,"get_unchecked","","Returns a shared reference to the output at this location,…",30,[[["t"]]]],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this…",30,[[["t"]]]],[10,"index","","Returns a shared reference to the output at this location,…",30,[[["t"]]]],[10,"index_mut","","Returns a mutable reference to the output at this…",30,[[["t"]]]],[5,"from_mut","","Converts a reference to T into a slice of length 1…",null,[[["t"]]]],[5,"from_ref","","Converts a reference to T into a slice of length 1…",null,[[["t"]]]],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,[[["usize"]]]],[5,"from_raw_parts_mut","","Performs the same functionality as [`from_raw_parts`],…",null,[[["usize"]]]],[3,"Chunks","","An iterator over a slice in (non-overlapping) chunks…",null,null],[3,"Windows","","An iterator over overlapping subslices of length `size`.",null,null],[3,"ChunksExact","","An iterator over a slice in (non-overlapping) chunks…",null,null],[3,"ChunksExactMut","","An iterator over a slice in (non-overlapping) mutable…",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable…",null,null],[3,"Split","","An iterator over subslices separated by elements that…",null,null],[3,"SplitMut","","An iterator over the mutable subslices of the vector which…",null,null],[3,"Iter","","Immutable slice iterator",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"RChunks","","An iterator over a slice in (non-overlapping) chunks…",null,null],[3,"RChunksExact","","An iterator over a slice in (non-overlapping) chunks…",null,null],[3,"RChunksExactMut","","An iterator over a slice in (non-overlapping) mutable…",null,null],[3,"RChunksMut","","An iterator over a slice in (non-overlapping) mutable…",null,null],[3,"RSplit","","An iterator over subslices separated by elements that…",null,null],[3,"RSplitMut","","An iterator over the subslices of the vector which are…",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that…",null,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that…",null,null],[3,"SplitN","","An iterator over subslices separated by elements that…",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that…",null,null],[8,"Concat","","Helper trait for `[T]::concat`.",null,null],[16,"Output","","The resulting type after concatenation",31,null],[10,"concat","","Implementation of `[T]::concat`",31,[[["self"]]]],[8,"Join","","Helper trait for `[T]::join`",null,null],[16,"Output","","The resulting type after concatenation",32,null],[10,"join","","Implementation of `[T]::join`",32,[[["separator"],["self"]]]],[0,"str","alloc","Unicode string slices.",null,null],[0,"pattern","alloc::str","The string Pattern API.",null,null],[8,"Pattern","alloc::str::pattern","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",33,null],[10,"into_searcher","","Constructs the associated searcher from `self` and the…",33,[[["str"]]]],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",33,[[["str"]],["bool"]]],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the…",33,[[["str"]],["bool"]]],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the…",33,[[["str"]],["bool"]]],[4,"SearchStep","","Result of calling `Searcher::next()` or…",null,null],[13,"Match","","Expresses that a match of the pattern has been found at…",34,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a…",34,null],[13,"Done","","Expresses that every byte of the haystack has been…",34,null],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlying string to be searched in",35,[[["self"]],["str"]]],[10,"next","","Performs the next search step starting from the front.",35,[[["self"]],["searchstep"]]],[11,"next_match","","Finds the next `Match` result. See `next()`",35,[[["self"]],["option"]]],[11,"next_reject","","Finds the next `Reject` result. See `next()` and…",35,[[["self"]],["option"]]],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",36,[[["self"]],["searchstep"]]],[11,"next_match_back","","Finds the next `Match` result. See `next_back()`",36,[[["self"]],["option"]]],[11,"next_reject_back","","Finds the next `Reject` result. See `next_back()`",36,[[["self"]],["option"]]],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be…",null,null],[3,"CharSearcher","","Associated type for `<char as Pattern<'a>>::Searcher`.",null,null],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<'a>>::Searcher`.",null,null],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<'a>>::Searcher`.",null,null],[3,"StrSearcher","","Associated type for `<&str as Pattern<'a>>::Searcher`.",null,null],[3,"EncodeUtf16","alloc::str","An iterator of [`u16`] over the string encoded as UTF-16.",null,null],[3,"SplitAsciiWhitespace","","An iterator over the non-ASCII-whitespace substrings of a…",null,null],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a…",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,[[],[["result",["str","utf8error"]],["str"],["utf8error"]]]],[5,"from_utf8_mut","","Converts a mutable slice of bytes to a mutable string slice.",null,[[],[["utf8error"],["str"],["result",["str","utf8error"]]]]],[3,"Bytes","","An iterator over the bytes of a string slice.",null,null],[3,"CharIndices","","An iterator over the [`char`]s of a string slice, and…",null,null],[3,"Chars","","An iterator over the [`char`]s of a string slice.",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without…",null,[[],["str"]]],[5,"from_utf8_unchecked_mut","","Converts a slice of bytes to a string slice without…",null,[[],["str"]]],[3,"ParseBoolError","","An error returned when parsing a `bool` using [`from_str`]…",null,null],[3,"EscapeDebug","","The return type of [`str::escape_debug`].",null,null],[3,"EscapeDefault","","The return type of [`str::escape_default`].",null,null],[3,"EscapeUnicode","","The return type of [`str::escape_unicode`].",null,null],[8,"FromStr","","Parse a value from a string",null,null],[16,"Err","","The associated error which can be returned from parsing.",37,null],[10,"from_str","","Parses a string `s` to return a value of this type.",37,[[["str"]],["result"]]],[3,"Utf8Error","","Errors which can occur when attempting to interpret a…",null,null],[3,"Lines","","An iterator over the lines of a string, as string slices.",null,null],[3,"LinesAny","","Created with the method [`lines_any`].",null,null],[3,"MatchIndices","","Created with the method [`match_indices`].",null,null],[3,"RMatchIndices","","Created with the method [`rmatch_indices`].",null,null],[3,"Matches","","Created with the method [`matches`].",null,null],[3,"RMatches","","Created with the method [`rmatches`].",null,null],[3,"RSplit","","Created with the method [`rsplit`].",null,null],[3,"Split","","Created with the method [`split`].",null,null],[3,"RSplitN","","Created with the method [`rsplitn`].",null,null],[3,"SplitN","","Created with the method [`splitn`].",null,null],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator`].",null,null],[3,"SplitTerminator","","Created with the method [`split_terminator`].",null,null],[5,"from_boxed_utf8_unchecked","","Converts a boxed slice of bytes to a boxed string slice…",null,[[["box"]],[["str"],["box",["str"]]]]],[0,"string","alloc","A UTF-8 encoded, growable string.",null,null],[3,"String","alloc::string","A UTF-8 encoded, growable string.",null,null],[3,"FromUtf8Error","","A possible error value when converting a `String` from a…",null,null],[3,"FromUtf16Error","","A possible error value when converting a `String` from a…",null,null],[3,"Drain","","A draining iterator for `String`.",null,null],[6,"ParseError","","A type alias for [`Infallible`].",null,null],[8,"ToString","","A trait for converting a value to a `String`.",null,null],[10,"to_string","","Converts the given value to a `String`.",38,[[["self"]],["string"]]],[11,"new","","Creates a new empty `String`.",39,[[],["string"]]],[11,"with_capacity","","Creates a new empty `String` with a particular capacity.",39,[[["usize"]],["string"]]],[11,"from_utf8","","Converts a vector of bytes to a `String`.",39,[[["vec",["u8"]],["u8"]],[["result",["string","fromutf8error"]],["fromutf8error"],["string"]]]],[11,"from_utf8_lossy","","Converts a slice of bytes to a string, including invalid…",39,[[],[["cow",["str"]],["str"]]]],[11,"from_utf16","","Decode a UTF-16 encoded vector `v` into a `String`,…",39,[[],[["result",["string","fromutf16error"]],["fromutf16error"],["string"]]]],[11,"from_utf16_lossy","","Decode a UTF-16 encoded slice `v` into a `String`,…",39,[[],["string"]]],[11,"into_raw_parts","","Decomposes a `String` into its raw components.",39,[[]]],[11,"from_raw_parts","","Creates a new `String` from a length, capacity, and pointer.",39,[[["usize"]],["string"]]],[11,"from_utf8_unchecked","","Converts a vector of bytes to a `String` without checking…",39,[[["vec",["u8"]],["u8"]],["string"]]],[11,"into_bytes","","Converts a `String` into a byte vector.",39,[[],[["u8"],["vec",["u8"]]]]],[11,"as_str","","Extracts a string slice containing the entire `String`.",39,[[["self"]],["str"]]],[11,"as_mut_str","","Converts a `String` into a mutable string slice.",39,[[["self"]],["str"]]],[11,"push_str","","Appends a given string slice onto the end of this `String`.",39,[[["str"],["self"]]]],[11,"capacity","","Returns this `String`'s capacity, in bytes.",39,[[["self"]],["usize"]]],[11,"reserve","","Ensures that this `String`'s capacity is at least…",39,[[["self"],["usize"]]]],[11,"reserve_exact","","Ensures that this `String`'s capacity is `additional`…",39,[[["self"],["usize"]]]],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more…",39,[[["self"],["usize"]],[["result",["tryreserveerror"]],["tryreserveerror"]]]],[11,"try_reserve_exact","","Tries to reserves the minimum capacity for exactly…",39,[[["self"],["usize"]],[["result",["tryreserveerror"]],["tryreserveerror"]]]],[11,"shrink_to_fit","","Shrinks the capacity of this `String` to match its length.",39,[[["self"]]]],[11,"shrink_to","","Shrinks the capacity of this `String` with a lower bound.",39,[[["self"],["usize"]]]],[11,"push","","Appends the given [`char`] to the end of this `String`.",39,[[["self"],["char"]]]],[11,"as_bytes","","Returns a byte slice of this `String`'s contents.",39,[[["self"]]]],[11,"truncate","","Shortens this `String` to the specified length.",39,[[["self"],["usize"]]]],[11,"pop","","Removes the last character from the string buffer and…",39,[[["self"]],[["option",["char"]],["char"]]]],[11,"remove","","Removes a [`char`] from this `String` at a byte position…",39,[[["self"],["usize"]],["char"]]],[11,"retain","","Retains only the characters specified by the predicate.",39,[[["self"],["f"]]]],[11,"insert","","Inserts a character into this `String` at a byte position.",39,[[["self"],["usize"],["char"]]]],[11,"insert_str","","Inserts a string slice into this `String` at a byte…",39,[[["str"],["self"],["usize"]]]],[11,"as_mut_vec","","Returns a mutable reference to the contents of this…",39,[[["self"]],["vec"]]],[11,"len","","Returns the length of this `String`, in bytes, not…",39,[[["self"]],["usize"]]],[11,"is_empty","","Returns `true` if this `String` has a length of zero, and…",39,[[["self"]],["bool"]]],[11,"split_off","","Splits the string into two at the given index.",39,[[["self"],["usize"]],["string"]]],[11,"clear","","Truncates this `String`, removing all contents.",39,[[["self"]]]],[11,"drain","","Creates a draining iterator that removes the specified…",39,[[["self"],["r"]],["drain"]]],[11,"replace_range","","Removes the specified range in the string, and replaces it…",39,[[["str"],["self"],["r"]]]],[11,"into_boxed_str","","Converts this `String` into a [`Box`]`<`[`str`]`>`.",39,[[],[["str"],["box",["str"]]]]],[11,"as_bytes","","Returns a slice of [`u8`]s bytes that were attempted to…",40,[[["self"]]]],[11,"into_bytes","","Returns the bytes that were attempted to convert to a…",40,[[],[["u8"],["vec",["u8"]]]]],[11,"utf8_error","","Fetch a `Utf8Error` to get more details about the…",40,[[["self"]],["utf8error"]]],[0,"sync","alloc","Thread-safe reference-counting pointers.",null,null],[3,"Arc","alloc::sync","A thread-safe reference-counting pointer. 'Arc' stands for…",null,null],[3,"Weak","","`Weak` is a version of [`Arc`] that holds a non-owning…",null,null],[11,"new","","Constructs a new `Arc<T>`.",41,[[["t"]],["arc"]]],[11,"new_uninit","","Constructs a new `Arc` with uninitialized contents.",41,[[],[["arc",["maybeuninit"]],["maybeuninit"]]]],[11,"new_zeroed","","Constructs a new `Arc` with uninitialized contents, with…",41,[[],[["arc",["maybeuninit"]],["maybeuninit"]]]],[11,"pin","","Constructs a new `Pin<Arc<T>>`. If `T` does not implement…",41,[[["t"]],[["pin",["arc"]],["arc"]]]],[11,"try_unwrap","","Returns the inner value, if the `Arc` has exactly one…",41,[[],["result"]]],[11,"new_uninit_slice","","Constructs a new reference-counted slice with…",41,[[["usize"]],["arc"]]],[11,"assume_init","","Converts to `Arc<T>`.",41,[[],["arc"]]],[11,"assume_init","","Converts to `Arc<[T]>`.",41,[[],["arc"]]],[11,"into_raw","","Consumes the `Arc`, returning the wrapped pointer.",41,[[]]],[11,"from_raw","","Constructs an `Arc` from a raw pointer.",41,[[],["self"]]],[11,"into_raw_non_null","","Consumes the `Arc`, returning the wrapped pointer as…",41,[[],["nonnull"]]],[11,"downgrade","","Creates a new [`Weak`][weak] pointer to this allocation.",41,[[["self"]],["weak"]]],[11,"weak_count","","Gets the number of [`Weak`][weak] pointers to this…",41,[[["self"]],["usize"]]],[11,"strong_count","","Gets the number of strong (`Arc`) pointers to this…",41,[[["self"]],["usize"]]],[11,"ptr_eq","","Returns `true` if the two `Arc`s point to the same…",41,[[["self"]],["bool"]]],[11,"make_mut","","Makes a mutable reference into the given `Arc`.",41,[[["self"]],["t"]]],[11,"get_mut","","Returns a mutable reference into the given `Arc`, if there…",41,[[["self"]],[["option"],["t"]]]],[11,"get_mut_unchecked","","Returns a mutable reference into the given `Arc`, without…",41,[[["self"]],["t"]]],[11,"downcast","","Attempt to downcast the `Arc<dyn Any + Send + Sync>` to a…",41,[[],[["arc"],["result",["arc"]]]]],[11,"new","","Constructs a new `Weak<T>`, without allocating any memory.…",42,[[],["weak"]]],[11,"as_raw","","Returns a raw pointer to the object `T` pointed to by this…",42,[[["self"]]]],[11,"into_raw","","Consumes the `Weak<T>` and turns it into a raw pointer.",42,[[]]],[11,"from_raw","","Converts a raw pointer previously created by [`into_raw`]…",42,[[],["self"]]],[11,"upgrade","","Attempts to upgrade the `Weak` pointer to an [`Arc`],…",42,[[["self"]],[["arc"],["option",["arc"]]]]],[11,"strong_count","","Gets the number of strong (`Arc`) pointers pointing to…",42,[[["self"]],["usize"]]],[11,"weak_count","","Gets an approximation of the number of `Weak` pointers…",42,[[["self"]],["usize"]]],[11,"ptr_eq","","Returns `true` if the two `Weak`s point to the same…",42,[[["self"]],["bool"]]],[0,"vec","alloc","A contiguous growable array type with heap-allocated…",null,null],[3,"Vec","alloc::vec","A contiguous growable array type, written `Vec<T>` but…",null,null],[3,"IntoIter","","An iterator that moves out of a vector.",null,null],[3,"Drain","","A draining iterator for `Vec<T>`.",null,null],[3,"Splice","","A splicing iterator for `Vec`.",null,null],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on Vec.",null,null],[11,"new","","Constructs a new, empty `Vec<T>`.",43,[[],["vec"]]],[11,"with_capacity","","Constructs a new, empty `Vec<T>` with the specified…",43,[[["usize"]],["vec"]]],[11,"into_raw_parts","","Decomposes a `Vec<T>` into its raw components.",43,[[]]],[11,"from_raw_parts","","Creates a `Vec<T>` directly from the raw components of…",43,[[["usize"]],["vec"]]],[11,"capacity","","Returns the number of elements the vector can hold without…",43,[[["self"]],["usize"]]],[11,"reserve","","Reserves capacity for at least `additional` more elements…",43,[[["self"],["usize"]]]],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional`…",43,[[["self"],["usize"]]]],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more…",43,[[["self"],["usize"]],[["result",["tryreserveerror"]],["tryreserveerror"]]]],[11,"try_reserve_exact","","Tries to reserves the minimum capacity for exactly…",43,[[["self"],["usize"]],[["result",["tryreserveerror"]],["tryreserveerror"]]]],[11,"shrink_to_fit","","Shrinks the capacity of the vector as much as possible.",43,[[["self"]]]],[11,"shrink_to","","Shrinks the capacity of the vector with a lower bound.",43,[[["self"],["usize"]]]],[11,"into_boxed_slice","","Converts the vector into [`Box<[T]>`][owned slice].",43,[[],["box"]]],[11,"truncate","","Shortens the vector, keeping the first `len` elements and…",43,[[["self"],["usize"]]]],[11,"as_slice","","Extracts a slice containing the entire vector.",43,[[["self"]]]],[11,"as_mut_slice","","Extracts a mutable slice of the entire vector.",43,[[["self"]]]],[11,"as_ptr","","Returns a raw pointer to the vector's buffer.",43,[[["self"]]]],[11,"as_mut_ptr","","Returns an unsafe mutable pointer to the vector's buffer.",43,[[["self"]]]],[11,"set_len","","Forces the length of the vector to `new_len`.",43,[[["self"],["usize"]]]],[11,"swap_remove","","Removes an element from the vector and returns it.",43,[[["self"],["usize"]],["t"]]],[11,"insert","","Inserts an element at position `index` within the vector,…",43,[[["self"],["usize"],["t"]]]],[11,"remove","","Removes and returns the element at position `index` within…",43,[[["self"],["usize"]],["t"]]],[11,"retain","","Retains only the elements specified by the predicate.",43,[[["self"],["f"]]]],[11,"dedup_by_key","","Removes all but the first of consecutive elements in the…",43,[[["self"],["f"]]]],[11,"dedup_by","","Removes all but the first of consecutive elements in the…",43,[[["self"],["f"]]]],[11,"push","","Appends an element to the back of a collection.",43,[[["self"],["t"]]]],[11,"pop","","Removes the last element from a vector and returns it, or…",43,[[["self"]],["option"]]],[11,"append","","Moves all the elements of `other` into `Self`, leaving…",43,[[["self"]]]],[11,"drain","","Creates a draining iterator that removes the specified…",43,[[["self"],["r"]],["drain"]]],[11,"clear","","Clears the vector, removing all values.",43,[[["self"]]]],[11,"len","","Returns the number of elements in the vector, also…",43,[[["self"]],["usize"]]],[11,"is_empty","","Returns `true` if the vector contains no elements.",43,[[["self"]],["bool"]]],[11,"split_off","","Splits the collection into two at the given index.",43,[[["self"],["usize"]],["self"]]],[11,"resize_with","","Resizes the `Vec` in-place so that `len` is equal to…",43,[[["self"],["usize"],["f"]]]],[11,"leak","","Consumes and leaks the `Vec`, returning a mutable…",43,[[["vec"]]]],[11,"resize","","Resizes the `Vec` in-place so that `len` is equal to…",43,[[["self"],["usize"],["t"]]]],[11,"extend_from_slice","","Clones and appends all elements in a slice to the `Vec`.",43,[[["self"]]]],[11,"resize_default","","Resizes the `Vec` in-place so that `len` is equal to…",43,[[["self"],["usize"]]]],[11,"dedup","","Removes consecutive repeated elements in the vector…",43,[[["self"]]]],[11,"remove_item","","Removes the first instance of `item` from the vector if…",43,[[["self"],["v"]],["option"]]],[11,"splice","","Creates a splicing iterator that replaces the specified…",43,[[["self"],["i"],["r"]],["splice"]]],[11,"drain_filter","","Creates an iterator which uses a closure to determine if…",43,[[["self"],["f"]],["drainfilter"]]],[11,"as_slice","","Returns the remaining items of this iterator as a slice.",44,[[["self"]]]],[11,"as_mut_slice","","Returns the remaining items of this iterator as a mutable…",44,[[["self"]]]],[11,"as_slice","","Returns the remaining items of this iterator as a slice.",45,[[["self"]]]],[14,"vec","alloc","Creates a [`Vec`] containing the arguments.",null,null],[14,"format","","Creates a `String` using interpolation of runtime…",null,null],[11,"to_owned","alloc::alloc","",46,[[["self"]],["t"]]],[11,"clone_into","","",46,[[["t"],["self"]]]],[11,"from","","",46,[[["t"]],["t"]]],[11,"try_from","","",46,[[["u"]],["result"]]],[11,"into","","",46,[[],["u"]]],[11,"try_into","","",46,[[],["result"]]],[11,"borrow","","",46,[[["self"]],["t"]]],[11,"borrow_mut","","",46,[[["self"]],["t"]]],[11,"type_id","","",46,[[["self"]],["typeid"]]],[11,"to_owned","","",47,[[["self"]],["t"]]],[11,"clone_into","","",47,[[["t"],["self"]]]],[11,"to_string","","",47,[[["self"]],["string"]]],[11,"from","","",47,[[["t"]],["t"]]],[11,"try_from","","",47,[[["u"]],["result"]]],[11,"into","","",47,[[],["u"]]],[11,"try_into","","",47,[[],["result"]]],[11,"borrow","","",47,[[["self"]],["t"]]],[11,"borrow_mut","","",47,[[["self"]],["t"]]],[11,"type_id","","",47,[[["self"]],["typeid"]]],[11,"to_owned","","",48,[[["self"]],["t"]]],[11,"clone_into","","",48,[[["t"],["self"]]]],[11,"to_string","","",48,[[["self"]],["string"]]],[11,"from","","",48,[[["t"]],["t"]]],[11,"try_from","","",48,[[["u"]],["result"]]],[11,"into","","",48,[[],["u"]]],[11,"try_into","","",48,[[],["result"]]],[11,"borrow","","",48,[[["self"]],["t"]]],[11,"borrow_mut","","",48,[[["self"]],["t"]]],[11,"type_id","","",48,[[["self"]],["typeid"]]],[11,"to_owned","","",49,[[["self"]],["t"]]],[11,"clone_into","","",49,[[["t"],["self"]]]],[11,"to_string","","",49,[[["self"]],["string"]]],[11,"from","","",49,[[["t"]],["t"]]],[11,"try_from","","",49,[[["u"]],["result"]]],[11,"into","","",49,[[],["u"]]],[11,"try_into","","",49,[[],["result"]]],[11,"borrow","","",49,[[["self"]],["t"]]],[11,"borrow_mut","","",49,[[["self"]],["t"]]],[11,"type_id","","",49,[[["self"]],["typeid"]]],[11,"to_owned","","",50,[[["self"]],["t"]]],[11,"clone_into","","",50,[[["t"],["self"]]]],[11,"from","","",50,[[["t"]],["t"]]],[11,"try_from","","",50,[[["u"]],["result"]]],[11,"into","","",50,[[],["u"]]],[11,"try_into","","",50,[[],["result"]]],[11,"borrow","","",50,[[["self"]],["t"]]],[11,"borrow_mut","","",50,[[["self"]],["t"]]],[11,"type_id","","",50,[[["self"]],["typeid"]]],[11,"to_owned","alloc::boxed","",2,[[["self"]],["t"]]],[11,"clone_into","","",2,[[["t"],["self"]]]],[11,"to_string","","",2,[[["self"]],["string"]]],[11,"from","","",2,[[["t"]],["t"]]],[11,"from","","",2,[[],["t"]]],[11,"into_iter","","",2,[[],["i"]]],[11,"into_searcher","","",2,[[["str"]],["charpredicatesearcher"]]],[11,"is_contained_in","","",2,[[["str"]],["bool"]]],[11,"is_prefix_of","","",2,[[["str"]],["bool"]]],[11,"is_suffix_of","","",2,[[["str"]],["bool"]]],[11,"try_from","","",2,[[["u"]],["result"]]],[11,"into","","",2,[[],["u"]]],[11,"try_into","","",2,[[],["result"]]],[11,"borrow","","",2,[[["self"]],["t"]]],[11,"borrow_mut","","",2,[[["self"]],["t"]]],[11,"type_id","","",2,[[["self"]],["typeid"]]],[11,"to_owned","alloc::borrow","",5,[[["self"]],["t"]]],[11,"clone_into","","",5,[[["t"],["self"]]]],[11,"to_string","","",5,[[["self"]],["string"]]],[11,"from","","",5,[[["t"]],["t"]]],[11,"try_from","","",5,[[["u"]],["result"]]],[11,"into","","",5,[[],["u"]]],[11,"try_into","","",5,[[],["result"]]],[11,"borrow","","",5,[[["self"]],["t"]]],[11,"borrow_mut","","",5,[[["self"]],["t"]]],[11,"type_id","","",5,[[["self"]],["typeid"]]],[11,"to_owned","alloc::collections","",7,[[["self"]],["t"]]],[11,"clone_into","","",7,[[["t"],["self"]]]],[11,"from","","",7,[[["t"]],["t"]]],[11,"try_from","","",7,[[["u"]],["result"]]],[11,"into","","",7,[[],["u"]]],[11,"try_into","","",7,[[],["result"]]],[11,"borrow","","",7,[[["self"]],["t"]]],[11,"borrow_mut","","",7,[[["self"]],["t"]]],[11,"type_id","","",7,[[["self"]],["typeid"]]],[11,"to_owned","alloc::collections::binary_heap","",10,[[["self"]],["t"]]],[11,"clone_into","","",10,[[["t"],["self"]]]],[11,"from","","",10,[[["t"]],["t"]]],[11,"into_iter","","",10,[[],["i"]]],[11,"try_from","","",10,[[["u"]],["result"]]],[11,"into","","",10,[[],["u"]]],[11,"try_into","","",10,[[],["result"]]],[11,"borrow","","",10,[[["self"]],["t"]]],[11,"borrow_mut","","",10,[[["self"]],["t"]]],[11,"type_id","","",10,[[["self"]],["typeid"]]],[11,"from","","",9,[[["t"]],["t"]]],[11,"try_from","","",9,[[["u"]],["result"]]],[11,"into","","",9,[[],["u"]]],[11,"try_into","","",9,[[],["result"]]],[11,"borrow","","",9,[[["self"]],["t"]]],[11,"borrow_mut","","",9,[[["self"]],["t"]]],[11,"type_id","","",9,[[["self"]],["typeid"]]],[11,"to_owned","","",51,[[["self"]],["t"]]],[11,"clone_into","","",51,[[["t"],["self"]]]],[11,"from","","",51,[[["t"]],["t"]]],[11,"into_iter","","",51,[[],["i"]]],[11,"try_from","","",51,[[["u"]],["result"]]],[11,"into","","",51,[[],["u"]]],[11,"try_into","","",51,[[],["result"]]],[11,"borrow","","",51,[[["self"]],["t"]]],[11,"borrow_mut","","",51,[[["self"]],["t"]]],[11,"type_id","","",51,[[["self"]],["typeid"]]],[11,"to_owned","","",52,[[["self"]],["t"]]],[11,"clone_into","","",52,[[["t"],["self"]]]],[11,"from","","",52,[[["t"]],["t"]]],[11,"into_iter","","",52,[[],["i"]]],[11,"try_from","","",52,[[["u"]],["result"]]],[11,"into","","",52,[[],["u"]]],[11,"try_into","","",52,[[],["result"]]],[11,"borrow","","",52,[[["self"]],["t"]]],[11,"borrow_mut","","",52,[[["self"]],["t"]]],[11,"type_id","","",52,[[["self"]],["typeid"]]],[11,"to_owned","","",53,[[["self"]],["t"]]],[11,"clone_into","","",53,[[["t"],["self"]]]],[11,"from","","",53,[[["t"]],["t"]]],[11,"into_iter","","",53,[[],["i"]]],[11,"try_from","","",53,[[["u"]],["result"]]],[11,"into","","",53,[[],["u"]]],[11,"try_into","","",53,[[],["result"]]],[11,"borrow","","",53,[[["self"]],["t"]]],[11,"borrow_mut","","",53,[[["self"]],["t"]]],[11,"type_id","","",53,[[["self"]],["typeid"]]],[11,"from","","",54,[[["t"]],["t"]]],[11,"into_iter","","",54,[[],["i"]]],[11,"try_from","","",54,[[["u"]],["result"]]],[11,"into","","",54,[[],["u"]]],[11,"try_into","","",54,[[],["result"]]],[11,"borrow","","",54,[[["self"]],["t"]]],[11,"borrow_mut","","",54,[[["self"]],["t"]]],[11,"type_id","","",54,[[["self"]],["typeid"]]],[11,"from","","",55,[[["t"]],["t"]]],[11,"into_iter","","",55,[[],["i"]]],[11,"try_from","","",55,[[["u"]],["result"]]],[11,"into","","",55,[[],["u"]]],[11,"try_into","","",55,[[],["result"]]],[11,"borrow","","",55,[[["self"]],["t"]]],[11,"borrow_mut","","",55,[[["self"]],["t"]]],[11,"type_id","","",55,[[["self"]],["typeid"]]],[11,"to_owned","alloc::collections::btree_map","",56,[[["self"]],["t"]]],[11,"clone_into","","",56,[[["t"],["self"]]]],[11,"from","","",56,[[["t"]],["t"]]],[11,"into_iter","","",56,[[],["i"]]],[11,"try_from","","",56,[[["u"]],["result"]]],[11,"into","","",56,[[],["u"]]],[11,"try_into","","",56,[[],["result"]]],[11,"borrow","","",56,[[["self"]],["t"]]],[11,"borrow_mut","","",56,[[["self"]],["t"]]],[11,"type_id","","",56,[[["self"]],["typeid"]]],[11,"to_owned","","",57,[[["self"]],["t"]]],[11,"clone_into","","",57,[[["t"],["self"]]]],[11,"from","","",57,[[["t"]],["t"]]],[11,"into_iter","","",57,[[],["i"]]],[11,"try_from","","",57,[[["u"]],["result"]]],[11,"into","","",57,[[],["u"]]],[11,"try_into","","",57,[[],["result"]]],[11,"borrow","","",57,[[["self"]],["t"]]],[11,"borrow_mut","","",57,[[["self"]],["t"]]],[11,"type_id","","",57,[[["self"]],["typeid"]]],[11,"from","","",58,[[["t"]],["t"]]],[11,"into_iter","","",58,[[],["i"]]],[11,"try_from","","",58,[[["u"]],["result"]]],[11,"into","","",58,[[],["u"]]],[11,"try_into","","",58,[[],["result"]]],[11,"borrow","","",58,[[["self"]],["t"]]],[11,"borrow_mut","","",58,[[["self"]],["t"]]],[11,"type_id","","",58,[[["self"]],["typeid"]]],[11,"from","","",59,[[["t"]],["t"]]],[11,"into_iter","","",59,[[],["i"]]],[11,"try_from","","",59,[[["u"]],["result"]]],[11,"into","","",59,[[],["u"]]],[11,"try_into","","",59,[[],["result"]]],[11,"borrow","","",59,[[["self"]],["t"]]],[11,"borrow_mut","","",59,[[["self"]],["t"]]],[11,"type_id","","",59,[[["self"]],["typeid"]]],[11,"to_owned","","",60,[[["self"]],["t"]]],[11,"clone_into","","",60,[[["t"],["self"]]]],[11,"from","","",60,[[["t"]],["t"]]],[11,"into_iter","","",60,[[],["i"]]],[11,"try_from","","",60,[[["u"]],["result"]]],[11,"into","","",60,[[],["u"]]],[11,"try_into","","",60,[[],["result"]]],[11,"borrow","","",60,[[["self"]],["t"]]],[11,"borrow_mut","","",60,[[["self"]],["t"]]],[11,"type_id","","",60,[[["self"]],["typeid"]]],[11,"to_owned","","",61,[[["self"]],["t"]]],[11,"clone_into","","",61,[[["t"],["self"]]]],[11,"from","","",61,[[["t"]],["t"]]],[11,"into_iter","","",61,[[],["i"]]],[11,"try_from","","",61,[[["u"]],["result"]]],[11,"into","","",61,[[],["u"]]],[11,"try_into","","",61,[[],["result"]]],[11,"borrow","","",61,[[["self"]],["t"]]],[11,"borrow_mut","","",61,[[["self"]],["t"]]],[11,"type_id","","",61,[[["self"]],["typeid"]]],[11,"from","","",62,[[["t"]],["t"]]],[11,"into_iter","","",62,[[],["i"]]],[11,"try_from","","",62,[[["u"]],["result"]]],[11,"into","","",62,[[],["u"]]],[11,"try_into","","",62,[[],["result"]]],[11,"borrow","","",62,[[["self"]],["t"]]],[11,"borrow_mut","","",62,[[["self"]],["t"]]],[11,"type_id","","",62,[[["self"]],["typeid"]]],[11,"to_owned","","",63,[[["self"]],["t"]]],[11,"clone_into","","",63,[[["t"],["self"]]]],[11,"from","","",63,[[["t"]],["t"]]],[11,"into_iter","","",63,[[],["i"]]],[11,"try_from","","",63,[[["u"]],["result"]]],[11,"into","","",63,[[],["u"]]],[11,"try_into","","",63,[[],["result"]]],[11,"borrow","","",63,[[["self"]],["t"]]],[11,"borrow_mut","","",63,[[["self"]],["t"]]],[11,"type_id","","",63,[[["self"]],["typeid"]]],[11,"from","","",64,[[["t"]],["t"]]],[11,"into_iter","","",64,[[],["i"]]],[11,"try_from","","",64,[[["u"]],["result"]]],[11,"into","","",64,[[],["u"]]],[11,"try_into","","",64,[[],["result"]]],[11,"borrow","","",64,[[["self"]],["t"]]],[11,"borrow_mut","","",64,[[["self"]],["t"]]],[11,"type_id","","",64,[[["self"]],["typeid"]]],[11,"from","","",65,[[["t"]],["t"]]],[11,"try_from","","",65,[[["u"]],["result"]]],[11,"into","","",65,[[],["u"]]],[11,"try_into","","",65,[[],["result"]]],[11,"borrow","","",65,[[["self"]],["t"]]],[11,"borrow_mut","","",65,[[["self"]],["t"]]],[11,"type_id","","",65,[[["self"]],["typeid"]]],[11,"from","","",66,[[["t"]],["t"]]],[11,"try_from","","",66,[[["u"]],["result"]]],[11,"into","","",66,[[],["u"]]],[11,"try_into","","",66,[[],["result"]]],[11,"borrow","","",66,[[["self"]],["t"]]],[11,"borrow_mut","","",66,[[["self"]],["t"]]],[11,"type_id","","",66,[[["self"]],["typeid"]]],[11,"from","","",16,[[["t"]],["t"]]],[11,"try_from","","",16,[[["u"]],["result"]]],[11,"into","","",16,[[],["u"]]],[11,"try_into","","",16,[[],["result"]]],[11,"borrow","","",16,[[["self"]],["t"]]],[11,"borrow_mut","","",16,[[["self"]],["t"]]],[11,"type_id","","",16,[[["self"]],["typeid"]]],[11,"to_owned","alloc::collections::btree_set","",67,[[["self"]],["t"]]],[11,"clone_into","","",67,[[["t"],["self"]]]],[11,"from","","",67,[[["t"]],["t"]]],[11,"into_iter","","",67,[[],["i"]]],[11,"try_from","","",67,[[["u"]],["result"]]],[11,"into","","",67,[[],["u"]]],[11,"try_into","","",67,[[],["result"]]],[11,"borrow","","",67,[[["self"]],["t"]]],[11,"borrow_mut","","",67,[[["self"]],["t"]]],[11,"type_id","","",67,[[["self"]],["typeid"]]],[11,"to_owned","","",68,[[["self"]],["t"]]],[11,"clone_into","","",68,[[["t"],["self"]]]],[11,"from","","",68,[[["t"]],["t"]]],[11,"into_iter","","",68,[[],["i"]]],[11,"try_from","","",68,[[["u"]],["result"]]],[11,"into","","",68,[[],["u"]]],[11,"try_into","","",68,[[],["result"]]],[11,"borrow","","",68,[[["self"]],["t"]]],[11,"borrow_mut","","",68,[[["self"]],["t"]]],[11,"type_id","","",68,[[["self"]],["typeid"]]],[11,"from","","",69,[[["t"]],["t"]]],[11,"into_iter","","",69,[[],["i"]]],[11,"try_from","","",69,[[["u"]],["result"]]],[11,"into","","",69,[[],["u"]]],[11,"try_into","","",69,[[],["result"]]],[11,"borrow","","",69,[[["self"]],["t"]]],[11,"borrow_mut","","",69,[[["self"]],["t"]]],[11,"type_id","","",69,[[["self"]],["typeid"]]],[11,"to_owned","","",70,[[["self"]],["t"]]],[11,"clone_into","","",70,[[["t"],["self"]]]],[11,"from","","",70,[[["t"]],["t"]]],[11,"into_iter","","",70,[[],["i"]]],[11,"try_from","","",70,[[["u"]],["result"]]],[11,"into","","",70,[[],["u"]]],[11,"try_into","","",70,[[],["result"]]],[11,"borrow","","",70,[[["self"]],["t"]]],[11,"borrow_mut","","",70,[[["self"]],["t"]]],[11,"type_id","","",70,[[["self"]],["typeid"]]],[11,"to_owned","","",71,[[["self"]],["t"]]],[11,"clone_into","","",71,[[["t"],["self"]]]],[11,"from","","",71,[[["t"]],["t"]]],[11,"into_iter","","",71,[[],["i"]]],[11,"try_from","","",71,[[["u"]],["result"]]],[11,"into","","",71,[[],["u"]]],[11,"try_into","","",71,[[],["result"]]],[11,"borrow","","",71,[[["self"]],["t"]]],[11,"borrow_mut","","",71,[[["self"]],["t"]]],[11,"type_id","","",71,[[["self"]],["typeid"]]],[11,"to_owned","","",72,[[["self"]],["t"]]],[11,"clone_into","","",72,[[["t"],["self"]]]],[11,"from","","",72,[[["t"]],["t"]]],[11,"into_iter","","",72,[[],["i"]]],[11,"try_from","","",72,[[["u"]],["result"]]],[11,"into","","",72,[[],["u"]]],[11,"try_into","","",72,[[],["result"]]],[11,"borrow","","",72,[[["self"]],["t"]]],[11,"borrow_mut","","",72,[[["self"]],["t"]]],[11,"type_id","","",72,[[["self"]],["typeid"]]],[11,"to_owned","","",73,[[["self"]],["t"]]],[11,"clone_into","","",73,[[["t"],["self"]]]],[11,"from","","",73,[[["t"]],["t"]]],[11,"into_iter","","",73,[[],["i"]]],[11,"try_from","","",73,[[["u"]],["result"]]],[11,"into","","",73,[[],["u"]]],[11,"try_into","","",73,[[],["result"]]],[11,"borrow","","",73,[[["self"]],["t"]]],[11,"borrow_mut","","",73,[[["self"]],["t"]]],[11,"type_id","","",73,[[["self"]],["typeid"]]],[11,"to_owned","","",74,[[["self"]],["t"]]],[11,"clone_into","","",74,[[["t"],["self"]]]],[11,"from","","",74,[[["t"]],["t"]]],[11,"into_iter","","",74,[[],["i"]]],[11,"try_from","","",74,[[["u"]],["result"]]],[11,"into","","",74,[[],["u"]]],[11,"try_into","","",74,[[],["result"]]],[11,"borrow","","",74,[[["self"]],["t"]]],[11,"borrow_mut","","",74,[[["self"]],["t"]]],[11,"type_id","","",74,[[["self"]],["typeid"]]],[11,"to_owned","alloc::collections::linked_list","",11,[[["self"]],["t"]]],[11,"clone_into","","",11,[[["t"],["self"]]]],[11,"from","","",11,[[["t"]],["t"]]],[11,"into_iter","","",11,[[],["i"]]],[11,"try_from","","",11,[[["u"]],["result"]]],[11,"into","","",11,[[],["u"]]],[11,"try_into","","",11,[[],["result"]]],[11,"borrow","","",11,[[["self"]],["t"]]],[11,"borrow_mut","","",11,[[["self"]],["t"]]],[11,"type_id","","",11,[[["self"]],["typeid"]]],[11,"to_owned","","",75,[[["self"]],["t"]]],[11,"clone_into","","",75,[[["t"],["self"]]]],[11,"from","","",75,[[["t"]],["t"]]],[11,"into_iter","","",75,[[],["i"]]],[11,"try_from","","",75,[[["u"]],["result"]]],[11,"into","","",75,[[],["u"]]],[11,"try_into","","",75,[[],["result"]]],[11,"borrow","","",75,[[["self"]],["t"]]],[11,"borrow_mut","","",75,[[["self"]],["t"]]],[11,"type_id","","",75,[[["self"]],["typeid"]]],[11,"from","","",12,[[["t"]],["t"]]],[11,"into_iter","","",12,[[],["i"]]],[11,"try_from","","",12,[[["u"]],["result"]]],[11,"into","","",12,[[],["u"]]],[11,"try_into","","",12,[[],["result"]]],[11,"borrow","","",12,[[["self"]],["t"]]],[11,"borrow_mut","","",12,[[["self"]],["t"]]],[11,"type_id","","",12,[[["self"]],["typeid"]]],[11,"to_owned","","",76,[[["self"]],["t"]]],[11,"clone_into","","",76,[[["t"],["self"]]]],[11,"from","","",76,[[["t"]],["t"]]],[11,"into_iter","","",76,[[],["i"]]],[11,"try_from","","",76,[[["u"]],["result"]]],[11,"into","","",76,[[],["u"]]],[11,"try_into","","",76,[[],["result"]]],[11,"borrow","","",76,[[["self"]],["t"]]],[11,"borrow_mut","","",76,[[["self"]],["t"]]],[11,"type_id","","",76,[[["self"]],["typeid"]]],[11,"from","","",13,[[["t"]],["t"]]],[11,"try_from","","",13,[[["u"]],["result"]]],[11,"into","","",13,[[],["u"]]],[11,"try_into","","",13,[[],["result"]]],[11,"borrow","","",13,[[["self"]],["t"]]],[11,"borrow_mut","","",13,[[["self"]],["t"]]],[11,"type_id","","",13,[[["self"]],["typeid"]]],[11,"from","","",14,[[["t"]],["t"]]],[11,"try_from","","",14,[[["u"]],["result"]]],[11,"into","","",14,[[],["u"]]],[11,"try_into","","",14,[[],["result"]]],[11,"borrow","","",14,[[["self"]],["t"]]],[11,"borrow_mut","","",14,[[["self"]],["t"]]],[11,"type_id","","",14,[[["self"]],["typeid"]]],[11,"from","","",77,[[["t"]],["t"]]],[11,"into_iter","","",77,[[],["i"]]],[11,"try_from","","",77,[[["u"]],["result"]]],[11,"into","","",77,[[],["u"]]],[11,"try_into","","",77,[[],["result"]]],[11,"borrow","","",77,[[["self"]],["t"]]],[11,"borrow_mut","","",77,[[["self"]],["t"]]],[11,"type_id","","",77,[[["self"]],["typeid"]]],[11,"from","alloc::collections::vec_deque","",78,[[["t"]],["t"]]],[11,"into_iter","","",78,[[],["i"]]],[11,"try_from","","",78,[[["u"]],["result"]]],[11,"into","","",78,[[],["u"]]],[11,"try_into","","",78,[[],["result"]]],[11,"borrow","","",78,[[["self"]],["t"]]],[11,"borrow_mut","","",78,[[["self"]],["t"]]],[11,"type_id","","",78,[[["self"]],["typeid"]]],[11,"to_owned","","",15,[[["self"]],["t"]]],[11,"clone_into","","",15,[[["t"],["self"]]]],[11,"from","","",15,[[["t"]],["t"]]],[11,"into_iter","","",15,[[],["i"]]],[11,"try_from","","",15,[[["u"]],["result"]]],[11,"into","","",15,[[],["u"]]],[11,"try_into","","",15,[[],["result"]]],[11,"borrow","","",15,[[["self"]],["t"]]],[11,"borrow_mut","","",15,[[["self"]],["t"]]],[11,"type_id","","",15,[[["self"]],["typeid"]]],[11,"to_owned","","",79,[[["self"]],["t"]]],[11,"clone_into","","",79,[[["t"],["self"]]]],[11,"from","","",79,[[["t"]],["t"]]],[11,"into_iter","","",79,[[],["i"]]],[11,"try_from","","",79,[[["u"]],["result"]]],[11,"into","","",79,[[],["u"]]],[11,"try_into","","",79,[[],["result"]]],[11,"borrow","","",79,[[["self"]],["t"]]],[11,"borrow_mut","","",79,[[["self"]],["t"]]],[11,"type_id","","",79,[[["self"]],["typeid"]]],[11,"from","","",80,[[["t"]],["t"]]],[11,"into_iter","","",80,[[],["i"]]],[11,"try_from","","",80,[[["u"]],["result"]]],[11,"into","","",80,[[],["u"]]],[11,"try_into","","",80,[[],["result"]]],[11,"borrow","","",80,[[["self"]],["t"]]],[11,"borrow_mut","","",80,[[["self"]],["t"]]],[11,"type_id","","",80,[[["self"]],["typeid"]]],[11,"to_owned","","",81,[[["self"]],["t"]]],[11,"clone_into","","",81,[[["t"],["self"]]]],[11,"from","","",81,[[["t"]],["t"]]],[11,"into_iter","","",81,[[],["i"]]],[11,"try_from","","",81,[[["u"]],["result"]]],[11,"into","","",81,[[],["u"]]],[11,"try_into","","",81,[[],["result"]]],[11,"borrow","","",81,[[["self"]],["t"]]],[11,"borrow_mut","","",81,[[["self"]],["t"]]],[11,"type_id","","",81,[[["self"]],["typeid"]]],[11,"from","alloc::fmt","",17,[[["t"]],["t"]]],[11,"try_from","","",17,[[["u"]],["result"]]],[11,"into","","",17,[[],["u"]]],[11,"try_into","","",17,[[],["result"]]],[11,"borrow","","",17,[[["self"]],["t"]]],[11,"borrow_mut","","",17,[[["self"]],["t"]]],[11,"type_id","","",17,[[["self"]],["typeid"]]],[11,"to_owned","","",82,[[["self"]],["t"]]],[11,"clone_into","","",82,[[["t"],["self"]]]],[11,"to_string","","",82,[[["self"]],["string"]]],[11,"from","","",82,[[["t"]],["t"]]],[11,"try_from","","",82,[[["u"]],["result"]]],[11,"into","","",82,[[],["u"]]],[11,"try_into","","",82,[[],["result"]]],[11,"borrow","","",82,[[["self"]],["t"]]],[11,"borrow_mut","","",82,[[["self"]],["t"]]],[11,"type_id","","",82,[[["self"]],["typeid"]]],[11,"to_owned","","",83,[[["self"]],["t"]]],[11,"clone_into","","",83,[[["t"],["self"]]]],[11,"to_string","","",83,[[["self"]],["string"]]],[11,"from","","",83,[[["t"]],["t"]]],[11,"try_from","","",83,[[["u"]],["result"]]],[11,"into","","",83,[[],["u"]]],[11,"try_into","","",83,[[],["result"]]],[11,"borrow","","",83,[[["self"]],["t"]]],[11,"borrow_mut","","",83,[[["self"]],["t"]]],[11,"type_id","","",83,[[["self"]],["typeid"]]],[11,"from","","",84,[[["t"]],["t"]]],[11,"try_from","","",84,[[["u"]],["result"]]],[11,"into","","",84,[[],["u"]]],[11,"try_into","","",84,[[],["result"]]],[11,"borrow","","",84,[[["self"]],["t"]]],[11,"borrow_mut","","",84,[[["self"]],["t"]]],[11,"type_id","","",84,[[["self"]],["typeid"]]],[11,"from","","",85,[[["t"]],["t"]]],[11,"try_from","","",85,[[["u"]],["result"]]],[11,"into","","",85,[[],["u"]]],[11,"try_into","","",85,[[],["result"]]],[11,"borrow","","",85,[[["self"]],["t"]]],[11,"borrow_mut","","",85,[[["self"]],["t"]]],[11,"type_id","","",85,[[["self"]],["typeid"]]],[11,"from","","",86,[[["t"]],["t"]]],[11,"try_from","","",86,[[["u"]],["result"]]],[11,"into","","",86,[[],["u"]]],[11,"try_into","","",86,[[],["result"]]],[11,"borrow","","",86,[[["self"]],["t"]]],[11,"borrow_mut","","",86,[[["self"]],["t"]]],[11,"type_id","","",86,[[["self"]],["typeid"]]],[11,"from","","",87,[[["t"]],["t"]]],[11,"try_from","","",87,[[["u"]],["result"]]],[11,"into","","",87,[[],["u"]]],[11,"try_into","","",87,[[],["result"]]],[11,"borrow","","",87,[[["self"]],["t"]]],[11,"borrow_mut","","",87,[[["self"]],["t"]]],[11,"type_id","","",87,[[["self"]],["typeid"]]],[11,"from","","",88,[[["t"]],["t"]]],[11,"try_from","","",88,[[["u"]],["result"]]],[11,"into","","",88,[[],["u"]]],[11,"try_into","","",88,[[],["result"]]],[11,"borrow","","",88,[[["self"]],["t"]]],[11,"borrow_mut","","",88,[[["self"]],["t"]]],[11,"type_id","","",88,[[["self"]],["typeid"]]],[11,"from","","",89,[[["t"]],["t"]]],[11,"try_from","","",89,[[["u"]],["result"]]],[11,"into","","",89,[[],["u"]]],[11,"try_into","","",89,[[],["result"]]],[11,"borrow","","",89,[[["self"]],["t"]]],[11,"borrow_mut","","",89,[[["self"]],["t"]]],[11,"type_id","","",89,[[["self"]],["typeid"]]],[11,"to_owned","alloc::rc","",28,[[["self"]],["t"]]],[11,"clone_into","","",28,[[["t"],["self"]]]],[11,"to_string","","",28,[[["self"]],["string"]]],[11,"from","","",28,[[["t"]],["t"]]],[11,"from","","",28,[[],["t"]]],[11,"try_from","","",28,[[["u"]],["result"]]],[11,"into","","",28,[[],["u"]]],[11,"try_into","","",28,[[],["result"]]],[11,"borrow","","",28,[[["self"]],["t"]]],[11,"borrow_mut","","",28,[[["self"]],["t"]]],[11,"type_id","","",28,[[["self"]],["typeid"]]],[11,"to_owned","","",29,[[["self"]],["t"]]],[11,"clone_into","","",29,[[["t"],["self"]]]],[11,"from","","",29,[[["t"]],["t"]]],[11,"try_from","","",29,[[["u"]],["result"]]],[11,"into","","",29,[[],["u"]]],[11,"try_into","","",29,[[],["result"]]],[11,"borrow","","",29,[[["self"]],["t"]]],[11,"borrow_mut","","",29,[[["self"]],["t"]]],[11,"type_id","","",29,[[["self"]],["typeid"]]],[11,"to_owned","alloc::slice","",90,[[["self"]],["t"]]],[11,"clone_into","","",90,[[["t"],["self"]]]],[11,"from","","",90,[[["t"]],["t"]]],[11,"into_iter","","",90,[[],["i"]]],[11,"try_from","","",90,[[["u"]],["result"]]],[11,"into","","",90,[[],["u"]]],[11,"try_into","","",90,[[],["result"]]],[11,"borrow","","",90,[[["self"]],["t"]]],[11,"borrow_mut","","",90,[[["self"]],["t"]]],[11,"type_id","","",90,[[["self"]],["typeid"]]],[11,"to_owned","","",91,[[["self"]],["t"]]],[11,"clone_into","","",91,[[["t"],["self"]]]],[11,"from","","",91,[[["t"]],["t"]]],[11,"into_iter","","",91,[[],["i"]]],[11,"try_from","","",91,[[["u"]],["result"]]],[11,"into","","",91,[[],["u"]]],[11,"try_into","","",91,[[],["result"]]],[11,"borrow","","",91,[[["self"]],["t"]]],[11,"borrow_mut","","",91,[[["self"]],["t"]]],[11,"type_id","","",91,[[["self"]],["typeid"]]],[11,"to_owned","","",92,[[["self"]],["t"]]],[11,"clone_into","","",92,[[["t"],["self"]]]],[11,"from","","",92,[[["t"]],["t"]]],[11,"into_iter","","",92,[[],["i"]]],[11,"try_from","","",92,[[["u"]],["result"]]],[11,"into","","",92,[[],["u"]]],[11,"try_into","","",92,[[],["result"]]],[11,"borrow","","",92,[[["self"]],["t"]]],[11,"borrow_mut","","",92,[[["self"]],["t"]]],[11,"type_id","","",92,[[["self"]],["typeid"]]],[11,"from","","",93,[[["t"]],["t"]]],[11,"into_iter","","",93,[[],["i"]]],[11,"try_from","","",93,[[["u"]],["result"]]],[11,"into","","",93,[[],["u"]]],[11,"try_into","","",93,[[],["result"]]],[11,"borrow","","",93,[[["self"]],["t"]]],[11,"borrow_mut","","",93,[[["self"]],["t"]]],[11,"type_id","","",93,[[["self"]],["typeid"]]],[11,"from","","",94,[[["t"]],["t"]]],[11,"into_iter","","",94,[[],["i"]]],[11,"try_from","","",94,[[["u"]],["result"]]],[11,"into","","",94,[[],["u"]]],[11,"try_into","","",94,[[],["result"]]],[11,"borrow","","",94,[[["self"]],["t"]]],[11,"borrow_mut","","",94,[[["self"]],["t"]]],[11,"type_id","","",94,[[["self"]],["typeid"]]],[11,"to_owned","","",95,[[["self"]],["t"]]],[11,"clone_into","","",95,[[["t"],["self"]]]],[11,"from","","",95,[[["t"]],["t"]]],[11,"into_iter","","",95,[[],["i"]]],[11,"try_from","","",95,[[["u"]],["result"]]],[11,"into","","",95,[[],["u"]]],[11,"try_into","","",95,[[],["result"]]],[11,"borrow","","",95,[[["self"]],["t"]]],[11,"borrow_mut","","",95,[[["self"]],["t"]]],[11,"type_id","","",95,[[["self"]],["typeid"]]],[11,"from","","",96,[[["t"]],["t"]]],[11,"into_iter","","",96,[[],["i"]]],[11,"try_from","","",96,[[["u"]],["result"]]],[11,"into","","",96,[[],["u"]]],[11,"try_into","","",96,[[],["result"]]],[11,"borrow","","",96,[[["self"]],["t"]]],[11,"borrow_mut","","",96,[[["self"]],["t"]]],[11,"type_id","","",96,[[["self"]],["typeid"]]],[11,"to_owned","","",97,[[["self"]],["t"]]],[11,"clone_into","","",97,[[["t"],["self"]]]],[11,"from","","",97,[[["t"]],["t"]]],[11,"into_iter","","",97,[[],["i"]]],[11,"try_from","","",97,[[["u"]],["result"]]],[11,"into","","",97,[[],["u"]]],[11,"try_into","","",97,[[],["result"]]],[11,"borrow","","",97,[[["self"]],["t"]]],[11,"borrow_mut","","",97,[[["self"]],["t"]]],[11,"type_id","","",97,[[["self"]],["typeid"]]],[11,"from","","",98,[[["t"]],["t"]]],[11,"into_iter","","",98,[[],["i"]]],[11,"try_from","","",98,[[["u"]],["result"]]],[11,"into","","",98,[[],["u"]]],[11,"try_into","","",98,[[],["result"]]],[11,"borrow","","",98,[[["self"]],["t"]]],[11,"borrow_mut","","",98,[[["self"]],["t"]]],[11,"type_id","","",98,[[["self"]],["typeid"]]],[11,"to_owned","","",99,[[["self"]],["t"]]],[11,"clone_into","","",99,[[["t"],["self"]]]],[11,"from","","",99,[[["t"]],["t"]]],[11,"into_iter","","",99,[[],["i"]]],[11,"try_from","","",99,[[["u"]],["result"]]],[11,"into","","",99,[[],["u"]]],[11,"try_into","","",99,[[],["result"]]],[11,"borrow","","",99,[[["self"]],["t"]]],[11,"borrow_mut","","",99,[[["self"]],["t"]]],[11,"type_id","","",99,[[["self"]],["typeid"]]],[11,"to_owned","","",100,[[["self"]],["t"]]],[11,"clone_into","","",100,[[["t"],["self"]]]],[11,"from","","",100,[[["t"]],["t"]]],[11,"into_iter","","",100,[[],["i"]]],[11,"try_from","","",100,[[["u"]],["result"]]],[11,"into","","",100,[[],["u"]]],[11,"try_into","","",100,[[],["result"]]],[11,"borrow","","",100,[[["self"]],["t"]]],[11,"borrow_mut","","",100,[[["self"]],["t"]]],[11,"type_id","","",100,[[["self"]],["typeid"]]],[11,"from","","",101,[[["t"]],["t"]]],[11,"into_iter","","",101,[[],["i"]]],[11,"try_from","","",101,[[["u"]],["result"]]],[11,"into","","",101,[[],["u"]]],[11,"try_into","","",101,[[],["result"]]],[11,"borrow","","",101,[[["self"]],["t"]]],[11,"borrow_mut","","",101,[[["self"]],["t"]]],[11,"type_id","","",101,[[["self"]],["typeid"]]],[11,"from","","",102,[[["t"]],["t"]]],[11,"into_iter","","",102,[[],["i"]]],[11,"try_from","","",102,[[["u"]],["result"]]],[11,"into","","",102,[[],["u"]]],[11,"try_into","","",102,[[],["result"]]],[11,"borrow","","",102,[[["self"]],["t"]]],[11,"borrow_mut","","",102,[[["self"]],["t"]]],[11,"type_id","","",102,[[["self"]],["typeid"]]],[11,"to_owned","","",103,[[["self"]],["t"]]],[11,"clone_into","","",103,[[["t"],["self"]]]],[11,"from","","",103,[[["t"]],["t"]]],[11,"into_iter","","",103,[[],["i"]]],[11,"try_from","","",103,[[["u"]],["result"]]],[11,"into","","",103,[[],["u"]]],[11,"try_into","","",103,[[],["result"]]],[11,"borrow","","",103,[[["self"]],["t"]]],[11,"borrow_mut","","",103,[[["self"]],["t"]]],[11,"type_id","","",103,[[["self"]],["typeid"]]],[11,"from","","",104,[[["t"]],["t"]]],[11,"into_iter","","",104,[[],["i"]]],[11,"try_from","","",104,[[["u"]],["result"]]],[11,"into","","",104,[[],["u"]]],[11,"try_into","","",104,[[],["result"]]],[11,"borrow","","",104,[[["self"]],["t"]]],[11,"borrow_mut","","",104,[[["self"]],["t"]]],[11,"type_id","","",104,[[["self"]],["typeid"]]],[11,"from","","",105,[[["t"]],["t"]]],[11,"into_iter","","",105,[[],["i"]]],[11,"try_from","","",105,[[["u"]],["result"]]],[11,"into","","",105,[[],["u"]]],[11,"try_into","","",105,[[],["result"]]],[11,"borrow","","",105,[[["self"]],["t"]]],[11,"borrow_mut","","",105,[[["self"]],["t"]]],[11,"type_id","","",105,[[["self"]],["typeid"]]],[11,"from","","",106,[[["t"]],["t"]]],[11,"into_iter","","",106,[[],["i"]]],[11,"try_from","","",106,[[["u"]],["result"]]],[11,"into","","",106,[[],["u"]]],[11,"try_into","","",106,[[],["result"]]],[11,"borrow","","",106,[[["self"]],["t"]]],[11,"borrow_mut","","",106,[[["self"]],["t"]]],[11,"type_id","","",106,[[["self"]],["typeid"]]],[11,"from","","",107,[[["t"]],["t"]]],[11,"into_iter","","",107,[[],["i"]]],[11,"try_from","","",107,[[["u"]],["result"]]],[11,"into","","",107,[[],["u"]]],[11,"try_into","","",107,[[],["result"]]],[11,"borrow","","",107,[[["self"]],["t"]]],[11,"borrow_mut","","",107,[[["self"]],["t"]]],[11,"type_id","","",107,[[["self"]],["typeid"]]],[11,"from","","",108,[[["t"]],["t"]]],[11,"into_iter","","",108,[[],["i"]]],[11,"try_from","","",108,[[["u"]],["result"]]],[11,"into","","",108,[[],["u"]]],[11,"try_into","","",108,[[],["result"]]],[11,"borrow","","",108,[[["self"]],["t"]]],[11,"borrow_mut","","",108,[[["self"]],["t"]]],[11,"type_id","","",108,[[["self"]],["typeid"]]],[11,"to_owned","alloc::str::pattern","",34,[[["self"]],["t"]]],[11,"clone_into","","",34,[[["t"],["self"]]]],[11,"from","","",34,[[["t"]],["t"]]],[11,"try_from","","",34,[[["u"]],["result"]]],[11,"into","","",34,[[],["u"]]],[11,"try_into","","",34,[[],["result"]]],[11,"borrow","","",34,[[["self"]],["t"]]],[11,"borrow_mut","","",34,[[["self"]],["t"]]],[11,"type_id","","",34,[[["self"]],["typeid"]]],[11,"to_owned","","",109,[[["self"]],["t"]]],[11,"clone_into","","",109,[[["t"],["self"]]]],[11,"from","","",109,[[["t"]],["t"]]],[11,"try_from","","",109,[[["u"]],["result"]]],[11,"into","","",109,[[],["u"]]],[11,"try_into","","",109,[[],["result"]]],[11,"borrow","","",109,[[["self"]],["t"]]],[11,"borrow_mut","","",109,[[["self"]],["t"]]],[11,"type_id","","",109,[[["self"]],["typeid"]]],[11,"to_owned","","",110,[[["self"]],["t"]]],[11,"clone_into","","",110,[[["t"],["self"]]]],[11,"from","","",110,[[["t"]],["t"]]],[11,"try_from","","",110,[[["u"]],["result"]]],[11,"into","","",110,[[],["u"]]],[11,"try_into","","",110,[[],["result"]]],[11,"borrow","","",110,[[["self"]],["t"]]],[11,"borrow_mut","","",110,[[["self"]],["t"]]],[11,"type_id","","",110,[[["self"]],["typeid"]]],[11,"to_owned","","",111,[[["self"]],["t"]]],[11,"clone_into","","",111,[[["t"],["self"]]]],[11,"from","","",111,[[["t"]],["t"]]],[11,"try_from","","",111,[[["u"]],["result"]]],[11,"into","","",111,[[],["u"]]],[11,"try_into","","",111,[[],["result"]]],[11,"borrow","","",111,[[["self"]],["t"]]],[11,"borrow_mut","","",111,[[["self"]],["t"]]],[11,"type_id","","",111,[[["self"]],["typeid"]]],[11,"to_owned","","",112,[[["self"]],["t"]]],[11,"clone_into","","",112,[[["t"],["self"]]]],[11,"from","","",112,[[["t"]],["t"]]],[11,"try_from","","",112,[[["u"]],["result"]]],[11,"into","","",112,[[],["u"]]],[11,"try_into","","",112,[[],["result"]]],[11,"borrow","","",112,[[["self"]],["t"]]],[11,"borrow_mut","","",112,[[["self"]],["t"]]],[11,"type_id","","",112,[[["self"]],["typeid"]]],[11,"to_owned","alloc::str","",113,[[["self"]],["t"]]],[11,"clone_into","","",113,[[["t"],["self"]]]],[11,"from","","",113,[[["t"]],["t"]]],[11,"into_iter","","",113,[[],["i"]]],[11,"try_from","","",113,[[["u"]],["result"]]],[11,"into","","",113,[[],["u"]]],[11,"try_into","","",113,[[],["result"]]],[11,"borrow","","",113,[[["self"]],["t"]]],[11,"borrow_mut","","",113,[[["self"]],["t"]]],[11,"type_id","","",113,[[["self"]],["typeid"]]],[11,"to_owned","","",114,[[["self"]],["t"]]],[11,"clone_into","","",114,[[["t"],["self"]]]],[11,"from","","",114,[[["t"]],["t"]]],[11,"into_iter","","",114,[[],["i"]]],[11,"try_from","","",114,[[["u"]],["result"]]],[11,"into","","",114,[[],["u"]]],[11,"try_into","","",114,[[],["result"]]],[11,"borrow","","",114,[[["self"]],["t"]]],[11,"borrow_mut","","",114,[[["self"]],["t"]]],[11,"type_id","","",114,[[["self"]],["typeid"]]],[11,"to_owned","","",115,[[["self"]],["t"]]],[11,"clone_into","","",115,[[["t"],["self"]]]],[11,"from","","",115,[[["t"]],["t"]]],[11,"into_iter","","",115,[[],["i"]]],[11,"try_from","","",115,[[["u"]],["result"]]],[11,"into","","",115,[[],["u"]]],[11,"try_into","","",115,[[],["result"]]],[11,"borrow","","",115,[[["self"]],["t"]]],[11,"borrow_mut","","",115,[[["self"]],["t"]]],[11,"type_id","","",115,[[["self"]],["typeid"]]],[11,"to_owned","","",116,[[["self"]],["t"]]],[11,"clone_into","","",116,[[["t"],["self"]]]],[11,"from","","",116,[[["t"]],["t"]]],[11,"into_iter","","",116,[[],["i"]]],[11,"try_from","","",116,[[["u"]],["result"]]],[11,"into","","",116,[[],["u"]]],[11,"try_into","","",116,[[],["result"]]],[11,"borrow","","",116,[[["self"]],["t"]]],[11,"borrow_mut","","",116,[[["self"]],["t"]]],[11,"type_id","","",116,[[["self"]],["typeid"]]],[11,"to_owned","","",117,[[["self"]],["t"]]],[11,"clone_into","","",117,[[["t"],["self"]]]],[11,"from","","",117,[[["t"]],["t"]]],[11,"into_iter","","",117,[[],["i"]]],[11,"try_from","","",117,[[["u"]],["result"]]],[11,"into","","",117,[[],["u"]]],[11,"try_into","","",117,[[],["result"]]],[11,"borrow","","",117,[[["self"]],["t"]]],[11,"borrow_mut","","",117,[[["self"]],["t"]]],[11,"type_id","","",117,[[["self"]],["typeid"]]],[11,"to_owned","","",118,[[["self"]],["t"]]],[11,"clone_into","","",118,[[["t"],["self"]]]],[11,"from","","",118,[[["t"]],["t"]]],[11,"into_iter","","",118,[[],["i"]]],[11,"try_from","","",118,[[["u"]],["result"]]],[11,"into","","",118,[[],["u"]]],[11,"try_into","","",118,[[],["result"]]],[11,"borrow","","",118,[[["self"]],["t"]]],[11,"borrow_mut","","",118,[[["self"]],["t"]]],[11,"type_id","","",118,[[["self"]],["typeid"]]],[11,"to_owned","","",119,[[["self"]],["t"]]],[11,"clone_into","","",119,[[["t"],["self"]]]],[11,"to_string","","",119,[[["self"]],["string"]]],[11,"from","","",119,[[["t"]],["t"]]],[11,"try_from","","",119,[[["u"]],["result"]]],[11,"into","","",119,[[],["u"]]],[11,"try_into","","",119,[[],["result"]]],[11,"borrow","","",119,[[["self"]],["t"]]],[11,"borrow_mut","","",119,[[["self"]],["t"]]],[11,"type_id","","",119,[[["self"]],["typeid"]]],[11,"to_owned","","",120,[[["self"]],["t"]]],[11,"clone_into","","",120,[[["t"],["self"]]]],[11,"to_string","","",120,[[["self"]],["string"]]],[11,"from","","",120,[[["t"]],["t"]]],[11,"into_iter","","",120,[[],["i"]]],[11,"try_from","","",120,[[["u"]],["result"]]],[11,"into","","",120,[[],["u"]]],[11,"try_into","","",120,[[],["result"]]],[11,"borrow","","",120,[[["self"]],["t"]]],[11,"borrow_mut","","",120,[[["self"]],["t"]]],[11,"type_id","","",120,[[["self"]],["typeid"]]],[11,"to_owned","","",121,[[["self"]],["t"]]],[11,"clone_into","","",121,[[["t"],["self"]]]],[11,"to_string","","",121,[[["self"]],["string"]]],[11,"from","","",121,[[["t"]],["t"]]],[11,"into_iter","","",121,[[],["i"]]],[11,"try_from","","",121,[[["u"]],["result"]]],[11,"into","","",121,[[],["u"]]],[11,"try_into","","",121,[[],["result"]]],[11,"borrow","","",121,[[["self"]],["t"]]],[11,"borrow_mut","","",121,[[["self"]],["t"]]],[11,"type_id","","",121,[[["self"]],["typeid"]]],[11,"to_owned","","",122,[[["self"]],["t"]]],[11,"clone_into","","",122,[[["t"],["self"]]]],[11,"to_string","","",122,[[["self"]],["string"]]],[11,"from","","",122,[[["t"]],["t"]]],[11,"into_iter","","",122,[[],["i"]]],[11,"try_from","","",122,[[["u"]],["result"]]],[11,"into","","",122,[[],["u"]]],[11,"try_into","","",122,[[],["result"]]],[11,"borrow","","",122,[[["self"]],["t"]]],[11,"borrow_mut","","",122,[[["self"]],["t"]]],[11,"type_id","","",122,[[["self"]],["typeid"]]],[11,"to_owned","","",123,[[["self"]],["t"]]],[11,"clone_into","","",123,[[["t"],["self"]]]],[11,"to_string","","",123,[[["self"]],["string"]]],[11,"from","","",123,[[["t"]],["t"]]],[11,"try_from","","",123,[[["u"]],["result"]]],[11,"into","","",123,[[],["u"]]],[11,"try_into","","",123,[[],["result"]]],[11,"borrow","","",123,[[["self"]],["t"]]],[11,"borrow_mut","","",123,[[["self"]],["t"]]],[11,"type_id","","",123,[[["self"]],["typeid"]]],[11,"to_owned","","",124,[[["self"]],["t"]]],[11,"clone_into","","",124,[[["t"],["self"]]]],[11,"from","","",124,[[["t"]],["t"]]],[11,"into_iter","","",124,[[],["i"]]],[11,"try_from","","",124,[[["u"]],["result"]]],[11,"into","","",124,[[],["u"]]],[11,"try_into","","",124,[[],["result"]]],[11,"borrow","","",124,[[["self"]],["t"]]],[11,"borrow_mut","","",124,[[["self"]],["t"]]],[11,"type_id","","",124,[[["self"]],["typeid"]]],[11,"to_owned","","",125,[[["self"]],["t"]]],[11,"clone_into","","",125,[[["t"],["self"]]]],[11,"from","","",125,[[["t"]],["t"]]],[11,"into_iter","","",125,[[],["i"]]],[11,"try_from","","",125,[[["u"]],["result"]]],[11,"into","","",125,[[],["u"]]],[11,"try_into","","",125,[[],["result"]]],[11,"borrow","","",125,[[["self"]],["t"]]],[11,"borrow_mut","","",125,[[["self"]],["t"]]],[11,"type_id","","",125,[[["self"]],["typeid"]]],[11,"to_owned","","",126,[[["self"]],["t"]]],[11,"clone_into","","",126,[[["t"],["self"]]]],[11,"from","","",126,[[["t"]],["t"]]],[11,"into_iter","","",126,[[],["i"]]],[11,"try_from","","",126,[[["u"]],["result"]]],[11,"into","","",126,[[],["u"]]],[11,"try_into","","",126,[[],["result"]]],[11,"borrow","","",126,[[["self"]],["t"]]],[11,"borrow_mut","","",126,[[["self"]],["t"]]],[11,"type_id","","",126,[[["self"]],["typeid"]]],[11,"to_owned","","",127,[[["self"]],["t"]]],[11,"clone_into","","",127,[[["t"],["self"]]]],[11,"from","","",127,[[["t"]],["t"]]],[11,"into_iter","","",127,[[],["i"]]],[11,"try_from","","",127,[[["u"]],["result"]]],[11,"into","","",127,[[],["u"]]],[11,"try_into","","",127,[[],["result"]]],[11,"borrow","","",127,[[["self"]],["t"]]],[11,"borrow_mut","","",127,[[["self"]],["t"]]],[11,"type_id","","",127,[[["self"]],["typeid"]]],[11,"to_owned","","",128,[[["self"]],["t"]]],[11,"clone_into","","",128,[[["t"],["self"]]]],[11,"from","","",128,[[["t"]],["t"]]],[11,"into_iter","","",128,[[],["i"]]],[11,"try_from","","",128,[[["u"]],["result"]]],[11,"into","","",128,[[],["u"]]],[11,"try_into","","",128,[[],["result"]]],[11,"borrow","","",128,[[["self"]],["t"]]],[11,"borrow_mut","","",128,[[["self"]],["t"]]],[11,"type_id","","",128,[[["self"]],["typeid"]]],[11,"to_owned","","",129,[[["self"]],["t"]]],[11,"clone_into","","",129,[[["t"],["self"]]]],[11,"from","","",129,[[["t"]],["t"]]],[11,"into_iter","","",129,[[],["i"]]],[11,"try_from","","",129,[[["u"]],["result"]]],[11,"into","","",129,[[],["u"]]],[11,"try_into","","",129,[[],["result"]]],[11,"borrow","","",129,[[["self"]],["t"]]],[11,"borrow_mut","","",129,[[["self"]],["t"]]],[11,"type_id","","",129,[[["self"]],["typeid"]]],[11,"to_owned","","",130,[[["self"]],["t"]]],[11,"clone_into","","",130,[[["t"],["self"]]]],[11,"from","","",130,[[["t"]],["t"]]],[11,"into_iter","","",130,[[],["i"]]],[11,"try_from","","",130,[[["u"]],["result"]]],[11,"into","","",130,[[],["u"]]],[11,"try_into","","",130,[[],["result"]]],[11,"borrow","","",130,[[["self"]],["t"]]],[11,"borrow_mut","","",130,[[["self"]],["t"]]],[11,"type_id","","",130,[[["self"]],["typeid"]]],[11,"to_owned","","",131,[[["self"]],["t"]]],[11,"clone_into","","",131,[[["t"],["self"]]]],[11,"from","","",131,[[["t"]],["t"]]],[11,"into_iter","","",131,[[],["i"]]],[11,"try_from","","",131,[[["u"]],["result"]]],[11,"into","","",131,[[],["u"]]],[11,"try_into","","",131,[[],["result"]]],[11,"borrow","","",131,[[["self"]],["t"]]],[11,"borrow_mut","","",131,[[["self"]],["t"]]],[11,"type_id","","",131,[[["self"]],["typeid"]]],[11,"to_owned","","",132,[[["self"]],["t"]]],[11,"clone_into","","",132,[[["t"],["self"]]]],[11,"from","","",132,[[["t"]],["t"]]],[11,"into_iter","","",132,[[],["i"]]],[11,"try_from","","",132,[[["u"]],["result"]]],[11,"into","","",132,[[],["u"]]],[11,"try_into","","",132,[[],["result"]]],[11,"borrow","","",132,[[["self"]],["t"]]],[11,"borrow_mut","","",132,[[["self"]],["t"]]],[11,"type_id","","",132,[[["self"]],["typeid"]]],[11,"to_owned","","",133,[[["self"]],["t"]]],[11,"clone_into","","",133,[[["t"],["self"]]]],[11,"from","","",133,[[["t"]],["t"]]],[11,"into_iter","","",133,[[],["i"]]],[11,"try_from","","",133,[[["u"]],["result"]]],[11,"into","","",133,[[],["u"]]],[11,"try_into","","",133,[[],["result"]]],[11,"borrow","","",133,[[["self"]],["t"]]],[11,"borrow_mut","","",133,[[["self"]],["t"]]],[11,"type_id","","",133,[[["self"]],["typeid"]]],[11,"to_owned","","",134,[[["self"]],["t"]]],[11,"clone_into","","",134,[[["t"],["self"]]]],[11,"from","","",134,[[["t"]],["t"]]],[11,"into_iter","","",134,[[],["i"]]],[11,"try_from","","",134,[[["u"]],["result"]]],[11,"into","","",134,[[],["u"]]],[11,"try_into","","",134,[[],["result"]]],[11,"borrow","","",134,[[["self"]],["t"]]],[11,"borrow_mut","","",134,[[["self"]],["t"]]],[11,"type_id","","",134,[[["self"]],["typeid"]]],[11,"to_owned","","",135,[[["self"]],["t"]]],[11,"clone_into","","",135,[[["t"],["self"]]]],[11,"from","","",135,[[["t"]],["t"]]],[11,"into_iter","","",135,[[],["i"]]],[11,"try_from","","",135,[[["u"]],["result"]]],[11,"into","","",135,[[],["u"]]],[11,"try_into","","",135,[[],["result"]]],[11,"borrow","","",135,[[["self"]],["t"]]],[11,"borrow_mut","","",135,[[["self"]],["t"]]],[11,"type_id","","",135,[[["self"]],["typeid"]]],[11,"to_owned","alloc::string","",39,[[["self"]],["t"]]],[11,"clone_into","","",39,[[["t"],["self"]]]],[11,"to_string","","",39,[[["self"]],["string"]]],[11,"from","","",39,[[["t"]],["t"]]],[11,"try_from","","",39,[[["u"]],["result"]]],[11,"into","","",39,[[],["u"]]],[11,"try_into","","",39,[[],["result"]]],[11,"borrow","","",39,[[["self"]],["t"]]],[11,"borrow_mut","","",39,[[["self"]],["t"]]],[11,"type_id","","",39,[[["self"]],["typeid"]]],[11,"to_owned","","",40,[[["self"]],["t"]]],[11,"clone_into","","",40,[[["t"],["self"]]]],[11,"to_string","","",40,[[["self"]],["string"]]],[11,"from","","",40,[[["t"]],["t"]]],[11,"try_from","","",40,[[["u"]],["result"]]],[11,"into","","",40,[[],["u"]]],[11,"try_into","","",40,[[],["result"]]],[11,"borrow","","",40,[[["self"]],["t"]]],[11,"borrow_mut","","",40,[[["self"]],["t"]]],[11,"type_id","","",40,[[["self"]],["typeid"]]],[11,"to_string","","",136,[[["self"]],["string"]]],[11,"from","","",136,[[["t"]],["t"]]],[11,"try_from","","",136,[[["u"]],["result"]]],[11,"into","","",136,[[],["u"]]],[11,"try_into","","",136,[[],["result"]]],[11,"borrow","","",136,[[["self"]],["t"]]],[11,"borrow_mut","","",136,[[["self"]],["t"]]],[11,"type_id","","",136,[[["self"]],["typeid"]]],[11,"from","","",137,[[["t"]],["t"]]],[11,"into_iter","","",137,[[],["i"]]],[11,"try_from","","",137,[[["u"]],["result"]]],[11,"into","","",137,[[],["u"]]],[11,"try_into","","",137,[[],["result"]]],[11,"borrow","","",137,[[["self"]],["t"]]],[11,"borrow_mut","","",137,[[["self"]],["t"]]],[11,"type_id","","",137,[[["self"]],["typeid"]]],[11,"to_owned","alloc::sync","",41,[[["self"]],["t"]]],[11,"clone_into","","",41,[[["t"],["self"]]]],[11,"to_string","","",41,[[["self"]],["string"]]],[11,"from","","",41,[[["t"]],["t"]]],[11,"from","","",41,[[],["t"]]],[11,"try_from","","",41,[[["u"]],["result"]]],[11,"into","","",41,[[],["u"]]],[11,"try_into","","",41,[[],["result"]]],[11,"borrow","","",41,[[["self"]],["t"]]],[11,"borrow_mut","","",41,[[["self"]],["t"]]],[11,"type_id","","",41,[[["self"]],["typeid"]]],[11,"to_owned","","",42,[[["self"]],["t"]]],[11,"clone_into","","",42,[[["t"],["self"]]]],[11,"from","","",42,[[["t"]],["t"]]],[11,"try_from","","",42,[[["u"]],["result"]]],[11,"into","","",42,[[],["u"]]],[11,"try_into","","",42,[[],["result"]]],[11,"borrow","","",42,[[["self"]],["t"]]],[11,"borrow_mut","","",42,[[["self"]],["t"]]],[11,"type_id","","",42,[[["self"]],["typeid"]]],[11,"to_owned","alloc::vec","",43,[[["self"]],["t"]]],[11,"clone_into","","",43,[[["t"],["self"]]]],[11,"from","","",43,[[["t"]],["t"]]],[11,"into_iter","","",43,[[],["i"]]],[11,"try_from","","",43,[[["u"]],["result"]]],[11,"into","","",43,[[],["u"]]],[11,"try_into","","",43,[[],["result"]]],[11,"borrow","","",43,[[["self"]],["t"]]],[11,"borrow_mut","","",43,[[["self"]],["t"]]],[11,"type_id","","",43,[[["self"]],["typeid"]]],[11,"to_owned","","",44,[[["self"]],["t"]]],[11,"clone_into","","",44,[[["t"],["self"]]]],[11,"from","","",44,[[["t"]],["t"]]],[11,"into_iter","","",44,[[],["i"]]],[11,"try_from","","",44,[[["u"]],["result"]]],[11,"into","","",44,[[],["u"]]],[11,"try_into","","",44,[[],["result"]]],[11,"borrow","","",44,[[["self"]],["t"]]],[11,"borrow_mut","","",44,[[["self"]],["t"]]],[11,"type_id","","",44,[[["self"]],["typeid"]]],[11,"from","","",45,[[["t"]],["t"]]],[11,"into_iter","","",45,[[],["i"]]],[11,"try_from","","",45,[[["u"]],["result"]]],[11,"into","","",45,[[],["u"]]],[11,"try_into","","",45,[[],["result"]]],[11,"borrow","","",45,[[["self"]],["t"]]],[11,"borrow_mut","","",45,[[["self"]],["t"]]],[11,"type_id","","",45,[[["self"]],["typeid"]]],[11,"from","","",138,[[["t"]],["t"]]],[11,"into_iter","","",138,[[],["i"]]],[11,"try_from","","",138,[[["u"]],["result"]]],[11,"into","","",138,[[],["u"]]],[11,"try_into","","",138,[[],["result"]]],[11,"borrow","","",138,[[["self"]],["t"]]],[11,"borrow_mut","","",138,[[["self"]],["t"]]],[11,"type_id","","",138,[[["self"]],["typeid"]]],[11,"from","","",139,[[["t"]],["t"]]],[11,"into_iter","","",139,[[],["i"]]],[11,"try_from","","",139,[[["u"]],["result"]]],[11,"into","","",139,[[],["u"]]],[11,"try_into","","",139,[[],["result"]]],[11,"borrow","","",139,[[["self"]],["t"]]],[11,"borrow_mut","","",139,[[["self"]],["t"]]],[11,"type_id","","",139,[[["self"]],["typeid"]]],[11,"next_back","alloc::slice","",94,[[["self"]],["option"]]],[11,"nth_back","","",94,[[["self"],["usize"]],["option"]]],[11,"next_back","alloc::str","",126,[[["self"]],["option"]]],[11,"next_back","alloc::slice","",93,[[["self"]],["option"]]],[11,"nth_back","","",93,[[["self"],["usize"]],["option"]]],[11,"next_back","","",91,[[["self"]],["option"]]],[11,"nth_back","","",91,[[["self"],["usize"]],["option"]]],[11,"next_back","","",103,[[["self"]],["option"]]],[11,"next_back","alloc::str","",118,[[["self"]],[["option",["char"]],["char"]]]],[11,"next_back","","",115,[[["self"]],[["str"],["option",["str"]]]]],[11,"next_back","","",130,[[["self"]],[["str"],["option",["str"]]]]],[11,"next_back","","",129,[[["self"]],[["str"],["option",["str"]]]]],[11,"next_back","","",124,[[["self"]],[["str"],["option",["str"]]]]],[11,"next_back","","",134,[[["self"]],[["str"],["option",["str"]]]]],[11,"next_back","","",127,[[["self"]],["option"]]],[11,"next_back","","",131,[[["self"]],[["str"],["option",["str"]]]]],[11,"next_back","alloc::slice","",100,[[["self"]],["option"]]],[11,"nth_back","","",100,[[["self"],["usize"]],["option"]]],[11,"next_back","alloc::str","",135,[[["self"]],[["str"],["option",["str"]]]]],[11,"next_back","","",117,[[["self"]],["option"]]],[11,"next_back","alloc::slice","",90,[[["self"]],["option"]]],[11,"nth_back","","",90,[[["self"],["usize"]],["option"]]],[11,"next_back","alloc::str","",114,[[["self"]],[["str"],["option",["str"]]]]],[11,"next_back","alloc::slice","",102,[[["self"]],["option"]]],[11,"nth_back","","",102,[[["self"],["usize"]],["option"]]],[11,"next_back","","",104,[[["self"]],["option"]]],[11,"next_back","","",99,[[["self"]],["option"]]],[11,"nth_back","","",99,[[["self"],["usize"]],["option"]]],[11,"next_back","","",101,[[["self"]],["option"]]],[11,"nth_back","","",101,[[["self"],["usize"]],["option"]]],[11,"next_back","","",96,[[["self"]],["option"]]],[11,"next_back","alloc::str","",128,[[["self"]],[["str"],["option",["str"]]]]],[11,"next_back","","",116,[[["self"]],[["option",["u8"]],["u8"]]]],[11,"nth_back","","",116,[[["self"],["usize"]],["option"]]],[11,"rfind","","",116,[[["self"],["p"]],["option"]]],[11,"next_back","alloc::slice","",98,[[["self"]],[["option"],["t"]]]],[11,"nth_back","","",98,[[["self"],["usize"]],[["option"],["t"]]]],[11,"next_back","","",97,[[["self"]],[["option"],["t"]]]],[11,"nth_back","","",97,[[["self"],["usize"]],[["option"],["t"]]]],[11,"next_back","alloc::str","",125,[[["self"]],[["str"],["option",["str"]]]]],[11,"next_back","alloc::slice","",95,[[["self"]],["option"]]],[11,"next_back","","",92,[[["self"]],["option"]]],[11,"nth_back","","",92,[[["self"],["usize"]],["option"]]],[11,"next","alloc::str","",127,[[["self"]],["option"]]],[11,"next","alloc::slice","",108,[[["self"]],["option"]]],[11,"size_hint","","",108,[[["self"]]]],[11,"next","alloc::str","",131,[[["self"]],[["str"],["option",["str"]]]]],[11,"next","alloc::slice","",107,[[["self"]],["option"]]],[11,"size_hint","","",107,[[["self"]]]],[11,"next","alloc::str","",124,[[["self"]],[["str"],["option",["str"]]]]],[11,"size_hint","","",124,[[["self"]]]],[11,"last","","",124,[[],[["str"],["option",["str"]]]]],[11,"next","","",116,[[["self"]],[["option",["u8"]],["u8"]]]],[11,"size_hint","","",116,[[["self"]]]],[11,"count","","",116,[[],["usize"]]],[11,"last","","",116,[[],["option"]]],[11,"nth","","",116,[[["self"],["usize"]],["option"]]],[11,"all","","",116,[[["self"],["f"]],["bool"]]],[11,"any","","",116,[[["self"],["f"]],["bool"]]],[11,"find","","",116,[[["self"],["p"]],["option"]]],[11,"position","","",116,[[["self"],["p"]],[["usize"],["option",["usize"]]]]],[11,"rposition","","",116,[[["self"],["p"]],[["usize"],["option",["usize"]]]]],[11,"next","","",130,[[["self"]],[["str"],["option",["str"]]]]],[11,"next","","",115,[[["self"]],[["str"],["option",["str"]]]]],[11,"size_hint","","",115,[[["self"]]]],[11,"last","","",115,[[],[["str"],["option",["str"]]]]],[11,"next","alloc::slice","",105,[[["self"]],["option"]]],[11,"size_hint","","",105,[[["self"]]]],[11,"next","","",101,[[["self"]],["option"]]],[11,"size_hint","","",101,[[["self"]]]],[11,"count","","",101,[[],["usize"]]],[11,"nth","","",101,[[["self"],["usize"]],["option"]]],[11,"last","","",101,[[],["option"]]],[11,"next","","",93,[[["self"]],["option"]]],[11,"size_hint","","",93,[[["self"]]]],[11,"count","","",93,[[],["usize"]]],[11,"nth","","",93,[[["self"],["usize"]],["option"]]],[11,"last","","",93,[[],["option"]]],[11,"next","","",106,[[["self"]],["option"]]],[11,"size_hint","","",106,[[["self"]]]],[11,"next","alloc::str","",114,[[["self"]],[["str"],["option",["str"]]]]],[11,"size_hint","","",114,[[["self"]]]],[11,"last","","",114,[[],[["str"],["option",["str"]]]]],[11,"next","","",129,[[["self"]],[["str"],["option",["str"]]]]],[11,"next","alloc::slice","",90,[[["self"]],["option"]]],[11,"size_hint","","",90,[[["self"]]]],[11,"count","","",90,[[],["usize"]]],[11,"nth","","",90,[[["self"],["usize"]],["option"]]],[11,"last","","",90,[[],["option"]]],[11,"next","","",99,[[["self"]],["option"]]],[11,"size_hint","","",99,[[["self"]]]],[11,"count","","",99,[[],["usize"]]],[11,"nth","","",99,[[["self"],["usize"]],["option"]]],[11,"last","","",99,[[],["option"]]],[11,"next","","",97,[[["self"]],[["option"],["t"]]]],[11,"size_hint","","",97,[[["self"]]]],[11,"count","","",97,[[],["usize"]]],[11,"nth","","",97,[[["self"],["usize"]],[["option"],["t"]]]],[11,"last","","",97,[[],[["option"],["t"]]]],[11,"position","","",97,[[["self"],["p"]],[["usize"],["option",["usize"]]]]],[11,"rposition","","",97,[[["self"],["p"]],[["usize"],["option",["usize"]]]]],[11,"is_sorted_by","","",97,[[["f"]],["bool"]]],[11,"next","alloc::str","",132,[[["self"]],[["str"],["option",["str"]]]]],[11,"next","alloc::slice","",104,[[["self"]],["option"]]],[11,"size_hint","","",104,[[["self"]]]],[11,"next","alloc::str","",135,[[["self"]],[["str"],["option",["str"]]]]],[11,"next","alloc::slice","",91,[[["self"]],["option"]]],[11,"size_hint","","",91,[[["self"]]]],[11,"count","","",91,[[],["usize"]]],[11,"nth","","",91,[[["self"],["usize"]],["option"]]],[11,"last","","",91,[[],["option"]]],[11,"next","alloc::str","",122,[[["self"]],[["option",["char"]],["char"]]]],[11,"size_hint","","",122,[[["self"]]]],[11,"try_fold","","",122,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",122,[[["acc"],["fold"]],["acc"]]],[11,"next","","",125,[[["self"]],[["str"],["option",["str"]]]]],[11,"size_hint","","",125,[[["self"]]]],[11,"next","","",113,[[["self"]],[["u16"],["option",["u16"]]]]],[11,"size_hint","","",113,[[["self"]]]],[11,"next","","",134,[[["self"]],[["str"],["option",["str"]]]]],[11,"next","alloc::slice","",94,[[["self"]],["option"]]],[11,"size_hint","","",94,[[["self"]]]],[11,"count","","",94,[[],["usize"]]],[11,"nth","","",94,[[["self"],["usize"]],["option"]]],[11,"last","","",94,[[],["option"]]],[11,"next","","",92,[[["self"]],["option"]]],[11,"size_hint","","",92,[[["self"]]]],[11,"count","","",92,[[],["usize"]]],[11,"nth","","",92,[[["self"],["usize"]],["option"]]],[11,"last","","",92,[[],["option"]]],[11,"next","alloc::str","",120,[[["self"]],[["option",["char"]],["char"]]]],[11,"size_hint","","",120,[[["self"]]]],[11,"try_fold","","",120,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",120,[[["acc"],["fold"]],["acc"]]],[11,"next","","",117,[[["self"]],["option"]]],[11,"count","","",117,[[],["usize"]]],[11,"size_hint","","",117,[[["self"]]]],[11,"last","","",117,[[],["option"]]],[11,"next","alloc::slice","",96,[[["self"]],["option"]]],[11,"size_hint","","",96,[[["self"]]]],[11,"next","alloc::str","",128,[[["self"]],[["str"],["option",["str"]]]]],[11,"next","","",121,[[["self"]],[["option",["char"]],["char"]]]],[11,"size_hint","","",121,[[["self"]]]],[11,"try_fold","","",121,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",121,[[["acc"],["fold"]],["acc"]]],[11,"next","alloc::slice","",98,[[["self"]],[["option"],["t"]]]],[11,"size_hint","","",98,[[["self"]]]],[11,"count","","",98,[[],["usize"]]],[11,"nth","","",98,[[["self"],["usize"]],[["option"],["t"]]]],[11,"last","","",98,[[],[["option"],["t"]]]],[11,"position","","",98,[[["self"],["p"]],[["usize"],["option",["usize"]]]]],[11,"rposition","","",98,[[["self"],["p"]],[["usize"],["option",["usize"]]]]],[11,"next","alloc::str","",126,[[["self"]],["option"]]],[11,"next","alloc::slice","",100,[[["self"]],["option"]]],[11,"size_hint","","",100,[[["self"]]]],[11,"count","","",100,[[],["usize"]]],[11,"nth","","",100,[[["self"],["usize"]],["option"]]],[11,"last","","",100,[[],["option"]]],[11,"next","alloc::str","",118,[[["self"]],[["option",["char"]],["char"]]]],[11,"count","","",118,[[],["usize"]]],[11,"size_hint","","",118,[[["self"]]]],[11,"last","","",118,[[],[["option",["char"]],["char"]]]],[11,"next","","",133,[[["self"]],[["str"],["option",["str"]]]]],[11,"next","alloc::slice","",103,[[["self"]],["option"]]],[11,"size_hint","","",103,[[["self"]]]],[11,"next","","",102,[[["self"]],["option"]]],[11,"size_hint","","",102,[[["self"]]]],[11,"count","","",102,[[],["usize"]]],[11,"nth","","",102,[[["self"],["usize"]],["option"]]],[11,"last","","",102,[[],["option"]]],[11,"next","","",95,[[["self"]],["option"]]],[11,"size_hint","","",95,[[["self"]]]],[11,"clone","alloc::alloc","",46,[[["self"]],["layout"]]],[11,"clone","alloc::str::pattern","",112,[[["self"]],["strsearcher"]]],[11,"clone","","",109,[[["self"]],["charsearcher"]]],[11,"clone","alloc::str","",134,[[["self"]],["rsplitterminator"]]],[11,"clone","","",128,[[["self"]],["matches"]]],[11,"clone","","",121,[[["self"]],["escapedefault"]]],[11,"clone","","",124,[[["self"]],["lines"]]],[11,"clone","alloc::slice","",91,[[["self"]],["windows"]]],[11,"clone","","",103,[[["self"]],["rsplit"]]],[11,"clone","alloc::str","",135,[[["self"]],["splitterminator"]]],[11,"clone","alloc::str::pattern","",34,[[["self"]],["searchstep"]]],[11,"clone","alloc::alloc","",48,[[["self"]],["allocerr"]]],[11,"clone","alloc::str","",132,[[["self"]],["rsplitn"]]],[11,"clone","","",118,[[["self"]],["chars"]]],[11,"clone","","",119,[[["self"]],["parseboolerror"]]],[11,"clone","alloc::str::pattern","",110,[[["self"]],["charslicesearcher"]]],[11,"clone","alloc::slice","",99,[[["self"]],["rchunks"]]],[11,"clone","alloc::str::pattern","",111,[[["self"]],["charpredicatesearcher"]]],[11,"clone","alloc::str","",123,[[["self"]],["utf8error"]]],[11,"clone","","",116,[[["self"]],["bytes"]]],[11,"clone","alloc::alloc","",49,[[["self"]],["cannotreallocinplace"]]],[11,"clone","alloc::str","",130,[[["self"]],["rsplit"]]],[11,"clone","","",127,[[["self"]],["rmatchindices"]]],[11,"clone","","",122,[[["self"]],["escapeunicode"]]],[11,"clone","","",115,[[["self"]],["splitwhitespace"]]],[11,"clone","alloc::slice","",100,[[["self"]],["rchunksexact"]]],[11,"clone","","",90,[[["self"]],["chunks"]]],[11,"clone","alloc::str","",113,[[["self"]],["encodeutf16"]]],[11,"clone","alloc::fmt","",83,[[["self"]],["arguments"]]],[11,"clone","alloc::str","",131,[[["self"]],["split"]]],[11,"clone","","",117,[[["self"]],["charindices"]]],[11,"clone","","",114,[[["self"]],["splitasciiwhitespace"]]],[11,"clone","alloc::slice","",95,[[["self"]],["split"]]],[11,"clone","alloc::alloc","",47,[[["self"]],["layouterr"]]],[11,"clone","alloc::str","",125,[[["self"]],["linesany"]]],[11,"clone","","",120,[[["self"]],["escapedebug"]]],[11,"clone","","",126,[[["self"]],["matchindices"]]],[11,"clone","","",133,[[["self"]],["splitn"]]],[11,"clone","alloc::slice","",97,[[["self"]],["iter"]]],[11,"clone","","",92,[[["self"]],["chunksexact"]]],[11,"clone","alloc::fmt","",82,[[["self"]],["error"]]],[11,"clone","alloc::str","",129,[[["self"]],["rmatches"]]],[11,"eq","alloc::alloc","",49,[[["cannotreallocinplace"],["self"]],["bool"]]],[11,"eq","","",48,[[["allocerr"],["self"]],["bool"]]],[11,"eq","alloc::str::pattern","",34,[[["searchstep"],["self"]],["bool"]]],[11,"ne","","",34,[[["searchstep"],["self"]],["bool"]]],[11,"eq","alloc::str","",119,[[["parseboolerror"],["self"]],["bool"]]],[11,"ne","","",119,[[["parseboolerror"],["self"]],["bool"]]],[11,"eq","","",123,[[["utf8error"],["self"]],["bool"]]],[11,"ne","","",123,[[["utf8error"],["self"]],["bool"]]],[11,"eq","alloc::alloc","",46,[[["layout"],["self"]],["bool"]]],[11,"ne","","",46,[[["layout"],["self"]],["bool"]]],[11,"eq","","",47,[[["layouterr"],["self"]],["bool"]]],[11,"ne","","",47,[[["layouterr"],["self"]],["bool"]]],[11,"eq","alloc::fmt","",82,[[["error"],["self"]],["bool"]]],[11,"next_back","alloc::str::pattern","",111,[[["self"]],["searchstep"]]],[11,"next_match_back","","",111,[[["self"]],["option"]]],[11,"next_reject_back","","",111,[[["self"]],["option"]]],[11,"next_back","","",110,[[["self"]],["searchstep"]]],[11,"next_match_back","","",110,[[["self"]],["option"]]],[11,"next_reject_back","","",110,[[["self"]],["option"]]],[11,"next_back","","",109,[[["self"]],["searchstep"]]],[11,"next_match_back","","",109,[[["self"]],["option"]]],[11,"next_back","","",112,[[["self"]],["searchstep"]]],[11,"next_match_back","","",112,[[["self"]],["option"]]],[11,"fmt","alloc::alloc","",48,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::str","",121,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",122,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",120,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::fmt","",82,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::str","",119,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::alloc","",47,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::fmt","",83,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::str","",123,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::alloc","",49,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"cmp","alloc::fmt","",82,[[["error"],["self"]],["ordering"]]],[11,"fmt","alloc::str","",128,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",118,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",121,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",132,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::slice","",105,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::str","",126,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::slice","",96,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::str","",127,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::slice","",92,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::str","",119,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::slice","",94,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::str","",133,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",129,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::alloc","",47,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::str","",116,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",125,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",131,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::slice","",98,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",101,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::str","",117,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::slice","",97,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::str::pattern","",112,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",110,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",109,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::slice","",107,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",99,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::str","",115,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::str::pattern","",111,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::slice","",100,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::fmt","",82,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::str","",123,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",134,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::slice","",90,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::str","",124,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::alloc","",49,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::slice","",106,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",102,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",104,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",95,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::str","",135,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::slice","",103,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",93,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",108,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::str","",130,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::fmt","",17,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::str","",122,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",114,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",113,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::alloc","",48,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","","",46,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::str","",120,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::str::pattern","",34,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::fmt","",83,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"fmt","alloc::slice","",91,[[["formatter"],["self"]],[["error"],["result",["error"]]]]],[11,"as_ref","","",97,[[["self"]]]],[11,"hash","alloc::fmt","",82,[[["__h"],["self"]]]],[11,"default","","",82,[[],["error"]]],[11,"write_str","","",89,[[["str"],["self"]],[["error"],["result",["error"]]]]],[11,"write_char","","",89,[[["self"],["char"]],[["error"],["result",["error"]]]]],[11,"write_fmt","","",89,[[["self"],["arguments"]],[["error"],["result",["error"]]]]],[11,"partial_cmp","","",82,[[["error"],["self"]],[["ordering"],["option",["ordering"]]]]],[11,"haystack","alloc::str::pattern","",110,[[["self"]],["str"]]],[11,"next","","",110,[[["self"]],["searchstep"]]],[11,"next_match","","",110,[[["self"]],["option"]]],[11,"next_reject","","",110,[[["self"]],["option"]]],[11,"haystack","","",112,[[["self"]],["str"]]],[11,"next","","",112,[[["self"]],["searchstep"]]],[11,"next_match","","",112,[[["self"]],["option"]]],[11,"haystack","","",109,[[["self"]],["str"]]],[11,"next","","",109,[[["self"]],["searchstep"]]],[11,"next_match","","",109,[[["self"]],["option"]]],[11,"haystack","","",111,[[["self"]],["str"]]],[11,"next","","",111,[[["self"]],["searchstep"]]],[11,"next_match","","",111,[[["self"]],["option"]]],[11,"next_reject","","",111,[[["self"]],["option"]]],[11,"len","alloc::str","",116,[[["self"]],["usize"]]],[11,"is_empty","","",116,[[["self"]],["bool"]]],[11,"is_empty","alloc::slice","",100,[[["self"]],["bool"]]],[11,"len","","",97,[[["self"]],["usize"]]],[11,"is_empty","","",97,[[["self"]],["bool"]]],[11,"len","","",98,[[["self"]],["usize"]]],[11,"is_empty","","",98,[[["self"]],["bool"]]],[11,"is_empty","","",101,[[["self"]],["bool"]]],[11,"is_empty","","",92,[[["self"]],["bool"]]],[11,"is_empty","","",93,[[["self"]],["bool"]]],[11,"to_string","alloc::borrow","",5,[[["self"]],["string"]]],[11,"to_string","alloc::string","",39,[[["self"]],["string"]]],[11,"deref","alloc::boxed","",2,[[["self"]],["t"]]],[11,"deref","alloc::borrow","",5,[[["self"]],["b"]]],[11,"deref","alloc::collections::binary_heap","",9,[[["self"]],["t"]]],[11,"deref","alloc::rc","",28,[[["self"]],["t"]]],[11,"deref","alloc::string","",39,[[["self"]],["str"]]],[11,"deref","alloc::sync","",41,[[["self"]],["t"]]],[11,"deref","alloc::vec","",43,[[["self"]]]],[11,"deref_mut","alloc::boxed","",2,[[["self"]],["t"]]],[11,"deref_mut","alloc::collections::binary_heap","",9,[[["self"]],["t"]]],[11,"deref_mut","alloc::string","",39,[[["self"]],["str"]]],[11,"deref_mut","alloc::vec","",43,[[["self"]]]],[11,"from","alloc::boxed","Converts a generic type `T` into a `Box<T>`",2,[[["t"]],["self"]]],[11,"from","","Converts a `&[T]` into a `Box<[T]>`",2,[[],["box"]]],[11,"from","","Converts a `&str` into a `Box<str>`",2,[[["str"]],[["str"],["box",["str"]]]]],[11,"from","","Converts a `Box<str>>` into a `Box<[u8]>`",2,[[["str"],["box",["str"]]],["self"]]],[11,"from","alloc::collections::binary_heap","Converts a `Vec<T>` into a `BinaryHeap<T>`.",10,[[["vec"]],["binaryheap"]]],[11,"from","alloc::vec","",43,[[["binaryheap"]],["vec"]]],[11,"from","alloc::collections::vec_deque","Turn a [`Vec<T>`] into a [`VecDeque<T>`].",15,[[["vec"]],["self"]]],[11,"from","alloc::vec","Turn a [`VecDeque<T>`] into a [`Vec<T>`].",43,[[["vecdeque"]],["self"]]],[11,"from","alloc::collections","",7,[[["layouterr"]],["self"]]],[11,"from","alloc::rc","",28,[[["t"]],["self"]]],[11,"from","","",28,[[],["rc"]]],[11,"from","","",28,[[["str"]],[["rc",["str"]],["str"]]]],[11,"from","","",28,[[["string"]],[["rc",["str"]],["str"]]]],[11,"from","","",28,[[["box"]],["rc"]]],[11,"from","","",28,[[["vec"]],["rc"]]],[11,"from","alloc::string","",39,[[["str"]],["string"]]],[11,"from","","",39,[[["string"]],["string"]]],[11,"from","","Converts the given boxed `str` slice to a `String`. It is…",39,[[["str"],["box",["str"]]],["string"]]],[11,"from","alloc::boxed","Converts the given `String` to a boxed `str` slice that is…",2,[[["string"]],[["str"],["box",["str"]]]]],[11,"from","alloc::string","",39,[[["cow",["str"]],["str"]],["string"]]],[11,"from","alloc::borrow","",5,[[["str"]],[["cow",["str"]],["str"]]]],[11,"from","","",5,[[["string"]],[["cow",["str"]],["str"]]]],[11,"from","","",5,[[["string"]],[["cow",["str"]],["str"]]]],[11,"from","alloc::vec","Converts the given `String` to a vector `Vec` that holds…",43,[[["string"]],[["u8"],["vec",["u8"]]]]],[11,"from","alloc::sync","",41,[[["t"]],["self"]]],[11,"from","","",41,[[],["arc"]]],[11,"from","","",41,[[["str"]],[["str"],["arc",["str"]]]]],[11,"from","","",41,[[["string"]],[["str"],["arc",["str"]]]]],[11,"from","","",41,[[["box"]],["arc"]]],[11,"from","","",41,[[["vec"]],["arc"]]],[11,"from","alloc::vec","",43,[[],["vec"]]],[11,"from","","",43,[[],["vec"]]],[11,"from","","",43,[[["cow"]],["vec"]]],[11,"from","","",43,[[["box"]],["vec"]]],[11,"from","alloc::boxed","",2,[[["vec"]],["box"]]],[11,"from","alloc::vec","",43,[[["str"]],[["u8"],["vec",["u8"]]]]],[11,"from","alloc::borrow","",5,[[],["cow"]]],[11,"from","","",5,[[["vec"]],["cow"]]],[11,"from","","",5,[[["vec"]],["cow"]]],[11,"fmt","alloc::alloc","",50,[[["formatter"],["self"]],["result"]]],[11,"fmt","alloc::boxed","",2,[[["formatter"],["self"]],["result"]]],[11,"fmt","alloc::borrow","",5,[[["formatter"],["self"]],["result"]]],[11,"fmt","alloc::collections::binary_heap","",9,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",10,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",51,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",52,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",53,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",54,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",55,[[["formatter"],["self"]],["result"]]],[11,"fmt","alloc::collections::btree_map","",57,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",58,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",59,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",60,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",61,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",62,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",63,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",64,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",16,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",65,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",66,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",56,[[["formatter"],["self"]],["result"]]],[11,"fmt","alloc::collections::btree_set","",68,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",69,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",70,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",71,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",72,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",73,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",74,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",67,[[["formatter"],["self"]],["result"]]],[11,"fmt","alloc::collections::linked_list","",75,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",12,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",76,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",13,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",14,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",77,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",11,[[["formatter"],["self"]],["result"]]],[11,"fmt","alloc::collections::vec_deque","",78,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",79,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",80,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",81,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",15,[[["formatter"],["self"]],["result"]]],[11,"fmt","alloc::collections","",7,[[["formatter"],["self"]],["result"]]],[11,"fmt","alloc::rc","",28,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",29,[[["formatter"],["self"]],["result"]]],[11,"fmt","alloc::string","",40,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",136,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",39,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",137,[[["formatter"],["self"]],["result"]]],[11,"fmt","alloc::sync","",42,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",41,[[["formatter"],["self"]],["result"]]],[11,"fmt","alloc::vec","",43,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",44,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",45,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",138,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",139,[[["formatter"],["self"]],["result"]]],[11,"fmt","alloc::boxed","",2,[[["formatter"],["self"]],["result"]]],[11,"fmt","alloc::borrow","",5,[[["formatter"],["self"]],["result"]]],[11,"fmt","alloc::rc","",28,[[["formatter"],["self"]],["result"]]],[11,"fmt","alloc::string","",40,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",136,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",39,[[["formatter"],["self"]],["result"]]],[11,"fmt","alloc::sync","",41,[[["formatter"],["self"]],["result"]]],[11,"eq","alloc::boxed","",2,[[["box"],["self"]],["bool"]]],[11,"ne","","",2,[[["box"],["self"]],["bool"]]],[11,"eq","alloc::borrow","",5,[[["cow"],["self"]],["bool"]]],[11,"eq","alloc::collections::btree_map","",56,[[["btreemap"],["self"]],["bool"]]],[11,"eq","alloc::collections::btree_set","",67,[[["btreeset"],["self"]],["bool"]]],[11,"ne","","",67,[[["btreeset"],["self"]],["bool"]]],[11,"eq","alloc::collections::linked_list","",11,[[["self"]],["bool"]]],[11,"ne","","",11,[[["self"]],["bool"]]],[11,"eq","alloc::collections::vec_deque","",15,[[["vecdeque"],["self"]],["bool"]]],[11,"eq","","",15,[[["vec"],["self"]],["bool"]]],[11,"eq","","",15,[[["self"]],["bool"]]],[11,"eq","","",15,[[["self"]],["bool"]]],[11,"eq","","",15,[[["self"]],["bool"]]],[11,"eq","","",15,[[["self"]],["bool"]]],[11,"eq","","",15,[[["self"]],["bool"]]],[11,"eq","alloc::collections","",7,[[["tryreserveerror"],["self"]],["bool"]]],[11,"ne","","",7,[[["tryreserveerror"],["self"]],["bool"]]],[11,"eq","alloc::rc","Equality for two `Rc`s.",28,[[["rc"],["self"]],["bool"]]],[11,"ne","","Inequality for two `Rc`s.",28,[[["rc"],["self"]],["bool"]]],[11,"eq","alloc::string","",40,[[["fromutf8error"],["self"]],["bool"]]],[11,"ne","","",40,[[["fromutf8error"],["self"]],["bool"]]],[11,"eq","","",39,[[["string"],["self"]],["bool"]]],[11,"ne","","",39,[[["string"],["self"]],["bool"]]],[11,"eq","","",39,[[["str"],["self"]],["bool"]]],[11,"ne","","",39,[[["str"],["self"]],["bool"]]],[11,"eq","","",39,[[["str"],["self"]],["bool"]]],[11,"ne","","",39,[[["str"],["self"]],["bool"]]],[11,"eq","alloc::borrow","",5,[[["str"],["self"]],["bool"]]],[11,"ne","","",5,[[["str"],["self"]],["bool"]]],[11,"eq","","",5,[[["str"],["self"]],["bool"]]],[11,"ne","","",5,[[["str"],["self"]],["bool"]]],[11,"eq","","",5,[[["string"],["self"]],["bool"]]],[11,"ne","","",5,[[["string"],["self"]],["bool"]]],[11,"eq","alloc::string","",39,[[["cow"],["self"]],["bool"]]],[11,"ne","","",39,[[["cow"],["self"]],["bool"]]],[11,"eq","alloc::sync","Equality for two `Arc`s.",41,[[["arc"],["self"]],["bool"]]],[11,"ne","","Inequality for two `Arc`s.",41,[[["arc"],["self"]],["bool"]]],[11,"eq","alloc::vec","",43,[[["vec"],["self"]],["bool"]]],[11,"ne","","",43,[[["vec"],["self"]],["bool"]]],[11,"eq","","",43,[[["self"]],["bool"]]],[11,"ne","","",43,[[["self"]],["bool"]]],[11,"eq","","",43,[[["self"]],["bool"]]],[11,"ne","","",43,[[["self"]],["bool"]]],[11,"eq","alloc::borrow","",5,[[["self"]],["bool"]]],[11,"ne","","",5,[[["self"]],["bool"]]],[11,"eq","","",5,[[["self"]],["bool"]]],[11,"ne","","",5,[[["self"]],["bool"]]],[11,"eq","","",5,[[["vec"],["self"]],["bool"]]],[11,"ne","","",5,[[["vec"],["self"]],["bool"]]],[11,"eq","alloc::vec","",43,[[["self"]],["bool"]]],[11,"ne","","",43,[[["self"]],["bool"]]],[11,"eq","","",43,[[["self"]],["bool"]]],[11,"ne","","",43,[[["self"]],["bool"]]],[11,"cmp","alloc::boxed","",2,[[["box"],["self"]],["ordering"]]],[11,"cmp","alloc::borrow","",5,[[["self"]],["ordering"]]],[11,"cmp","alloc::collections::btree_map","",56,[[["btreemap"],["self"]],["ordering"]]],[11,"cmp","alloc::collections::btree_set","",67,[[["btreeset"],["self"]],["ordering"]]],[11,"cmp","alloc::collections::linked_list","",11,[[["self"]],["ordering"]]],[11,"cmp","alloc::collections::vec_deque","",15,[[["vecdeque"],["self"]],["ordering"]]],[11,"cmp","alloc::rc","Comparison for two `Rc`s.",28,[[["rc"],["self"]],["ordering"]]],[11,"cmp","alloc::string","",39,[[["string"],["self"]],["ordering"]]],[11,"cmp","alloc::sync","Comparison for two `Arc`s.",41,[[["arc"],["self"]],["ordering"]]],[11,"cmp","alloc::vec","",43,[[["vec"],["self"]],["ordering"]]],[11,"partial_cmp","alloc::boxed","",2,[[["box"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",2,[[["box"],["self"]],["bool"]]],[11,"le","","",2,[[["box"],["self"]],["bool"]]],[11,"ge","","",2,[[["box"],["self"]],["bool"]]],[11,"gt","","",2,[[["box"],["self"]],["bool"]]],[11,"partial_cmp","alloc::borrow","",5,[[["cow"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"partial_cmp","alloc::collections::btree_map","",56,[[["btreemap"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"partial_cmp","alloc::collections::btree_set","",67,[[["btreeset"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",67,[[["btreeset"],["self"]],["bool"]]],[11,"le","","",67,[[["btreeset"],["self"]],["bool"]]],[11,"gt","","",67,[[["btreeset"],["self"]],["bool"]]],[11,"ge","","",67,[[["btreeset"],["self"]],["bool"]]],[11,"partial_cmp","alloc::collections::linked_list","",11,[[["self"]],[["option",["ordering"]],["ordering"]]]],[11,"partial_cmp","alloc::collections::vec_deque","",15,[[["vecdeque"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"partial_cmp","alloc::rc","Partial comparison for two `Rc`s.",28,[[["rc"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","Less-than comparison for two `Rc`s.",28,[[["rc"],["self"]],["bool"]]],[11,"le","","'Less than or equal to' comparison for two `Rc`s.",28,[[["rc"],["self"]],["bool"]]],[11,"gt","","Greater-than comparison for two `Rc`s.",28,[[["rc"],["self"]],["bool"]]],[11,"ge","","'Greater than or equal to' comparison for two `Rc`s.",28,[[["rc"],["self"]],["bool"]]],[11,"partial_cmp","alloc::string","",39,[[["string"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",39,[[["string"],["self"]],["bool"]]],[11,"le","","",39,[[["string"],["self"]],["bool"]]],[11,"gt","","",39,[[["string"],["self"]],["bool"]]],[11,"ge","","",39,[[["string"],["self"]],["bool"]]],[11,"partial_cmp","alloc::sync","Partial comparison for two `Arc`s.",41,[[["arc"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","Less-than comparison for two `Arc`s.",41,[[["arc"],["self"]],["bool"]]],[11,"le","","'Less than or equal to' comparison for two `Arc`s.",41,[[["arc"],["self"]],["bool"]]],[11,"gt","","Greater-than comparison for two `Arc`s.",41,[[["arc"],["self"]],["bool"]]],[11,"ge","","'Greater than or equal to' comparison for two `Arc`s.",41,[[["arc"],["self"]],["bool"]]],[11,"partial_cmp","alloc::vec","",43,[[["vec"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"add","alloc::borrow","",5,[[["str"]]]],[11,"add","","",5,[[["cow",["str"]],["str"]]]],[11,"add","alloc::string","",39,[[["str"]],["string"]]],[11,"add_assign","alloc::borrow","",5,[[["str"],["self"]]]],[11,"add_assign","","",5,[[["cow",["str"]],["self"],["str"]]]],[11,"add_assign","alloc::string","",39,[[["str"],["self"]]]],[11,"drop","alloc::boxed","",2,[[["self"]]]],[11,"drop","alloc::collections::binary_heap","",9,[[["self"]]]],[11,"drop","","Removes heap elements in heap order.",55,[[["self"]]]],[11,"drop","alloc::collections::btree_map","",56,[[["self"]]]],[11,"drop","","",59,[[["self"]]]],[11,"drop","alloc::collections::linked_list","",11,[[["self"]]]],[11,"drop","","",77,[[["self"]]]],[11,"drop","alloc::collections::vec_deque","",78,[[["self"]]]],[11,"drop","","",15,[[["self"]]]],[11,"drop","alloc::rc","Drops the `Rc`.",28,[[["self"]]]],[11,"drop","","Drops the `Weak` pointer.",29,[[["self"]]]],[11,"drop","alloc::string","",137,[[["self"]]]],[11,"drop","alloc::sync","Drops the `Arc`.",41,[[["self"]]]],[11,"drop","","Drops the `Weak` pointer.",42,[[["self"]]]],[11,"drop","alloc::vec","",43,[[["self"]]]],[11,"drop","","",44,[[["self"]]]],[11,"drop","","",45,[[["self"]]]],[11,"drop","","",138,[[["self"]]]],[11,"drop","","",139,[[["self"]]]],[11,"call","alloc::boxed","",2,[[["a"],["self"]]]],[11,"call_mut","","",2,[[["a"],["self"]]]],[11,"call_once","","",2,[[["a"]]]],[11,"resume","","",2,[[["self"],["pin"],["r"]],["generatorstate"]]],[11,"index","alloc::collections::btree_map","Returns a reference to the value corresponding to the…",56,[[["q"],["self"]],["v"]]],[11,"index","alloc::collections::vec_deque","",15,[[["usize"],["self"]],["a"]]],[11,"index","alloc::string","",39,[[["range",["usize"]],["usize"],["self"]],["str"]]],[11,"index","","",39,[[["rangeto",["usize"]],["usize"],["self"]],["str"]]],[11,"index","","",39,[[["rangefrom",["usize"]],["usize"],["self"]],["str"]]],[11,"index","","",39,[[["rangefull"],["self"]],["str"]]],[11,"index","","",39,[[["rangeinclusive",["usize"]],["usize"],["self"]],["str"]]],[11,"index","","",39,[[["rangetoinclusive",["usize"]],["usize"],["self"]],["str"]]],[11,"index","alloc::vec","",43,[[["i"],["self"]]]],[11,"index_mut","alloc::collections::vec_deque","",15,[[["self"],["usize"]],["a"]]],[11,"index_mut","alloc::string","",39,[[["range",["usize"]],["self"],["usize"]],["str"]]],[11,"index_mut","","",39,[[["rangeto",["usize"]],["self"],["usize"]],["str"]]],[11,"index_mut","","",39,[[["self"],["rangefrom",["usize"]],["usize"]],["str"]]],[11,"index_mut","","",39,[[["rangefull"],["self"]],["str"]]],[11,"index_mut","","",39,[[["rangeinclusive",["usize"]],["self"],["usize"]],["str"]]],[11,"index_mut","","",39,[[["self"],["rangetoinclusive",["usize"]],["usize"]],["str"]]],[11,"index_mut","alloc::vec","",43,[[["self"],["i"]]]],[11,"hash","alloc::boxed","",2,[[["h"],["self"]]]],[11,"hash","alloc::borrow","",5,[[["h"],["self"]]]],[11,"hash","alloc::collections::btree_map","",56,[[["h"],["self"]]]],[11,"hash","alloc::collections::btree_set","",67,[[["__h"],["self"]]]],[11,"hash","alloc::collections::linked_list","",11,[[["h"],["self"]]]],[11,"hash","alloc::collections::vec_deque","",15,[[["h"],["self"]]]],[11,"hash","alloc::rc","",28,[[["h"],["self"]]]],[11,"hash","alloc::string","",39,[[["h"],["self"]]]],[11,"hash","alloc::sync","",41,[[["h"],["self"]]]],[11,"hash","alloc::vec","",43,[[["h"],["self"]]]],[11,"finish","alloc::boxed","",2,[[["self"]],["u64"]]],[11,"write","","",2,[[["self"]]]],[11,"write_u8","","",2,[[["self"],["u8"]]]],[11,"write_u16","","",2,[[["u16"],["self"]]]],[11,"write_u32","","",2,[[["self"],["u32"]]]],[11,"write_u64","","",2,[[["self"],["u64"]]]],[11,"write_u128","","",2,[[["self"],["u128"]]]],[11,"write_usize","","",2,[[["self"],["usize"]]]],[11,"write_i8","","",2,[[["self"],["i8"]]]],[11,"write_i16","","",2,[[["self"],["i16"]]]],[11,"write_i32","","",2,[[["self"],["i32"]]]],[11,"write_i64","","",2,[[["i64"],["self"]]]],[11,"write_i128","","",2,[[["self"],["i128"]]]],[11,"write_isize","","",2,[[["isize"],["self"]]]],[11,"next","","",2,[[["self"]],["option"]]],[11,"size_hint","","",2,[[["self"]]]],[11,"nth","","",2,[[["self"],["usize"]],["option"]]],[11,"last","","",2,[[],["option"]]],[11,"next","alloc::collections::binary_heap","",51,[[["self"]],[["option"],["t"]]]],[11,"size_hint","","",51,[[["self"]]]],[11,"last","","",51,[[],[["option"],["t"]]]],[11,"next","","",52,[[["self"]],["option"]]],[11,"size_hint","","",52,[[["self"]]]],[11,"next","","",53,[[["self"]],["option"]]],[11,"size_hint","","",53,[[["self"]]]],[11,"next","","",54,[[["self"]],["option"]]],[11,"size_hint","","",54,[[["self"]]]],[11,"next","","",55,[[["self"]],["option"]]],[11,"size_hint","","",55,[[["self"]]]],[11,"next","alloc::collections::btree_map","",57,[[["self"]],["option"]]],[11,"size_hint","","",57,[[["self"]]]],[11,"last","","",57,[[],["option"]]],[11,"next","","",58,[[["self"]],["option"]]],[11,"size_hint","","",58,[[["self"]]]],[11,"last","","",58,[[],["option"]]],[11,"next","","",59,[[["self"]],["option"]]],[11,"size_hint","","",59,[[["self"]]]],[11,"next","","",60,[[["self"]],[["option"],["k"]]]],[11,"size_hint","","",60,[[["self"]]]],[11,"last","","",60,[[],[["option"],["k"]]]],[11,"next","","",61,[[["self"]],[["option"],["v"]]]],[11,"size_hint","","",61,[[["self"]]]],[11,"last","","",61,[[],[["option"],["v"]]]],[11,"next","","",63,[[["self"]],["option"]]],[11,"last","","",63,[[],["option"]]],[11,"next","","",62,[[["self"]],[["v"],["option"]]]],[11,"size_hint","","",62,[[["self"]]]],[11,"last","","",62,[[],[["v"],["option"]]]],[11,"next","","",64,[[["self"]],["option"]]],[11,"last","","",64,[[],["option"]]],[11,"next","alloc::collections::btree_set","",68,[[["self"]],[["option"],["t"]]]],[11,"size_hint","","",68,[[["self"]]]],[11,"last","","",68,[[],[["option"],["t"]]]],[11,"next","","",69,[[["self"]],["option"]]],[11,"size_hint","","",69,[[["self"]]]],[11,"next","","",70,[[["self"]],[["option"],["t"]]]],[11,"last","","",70,[[],[["option"],["t"]]]],[11,"next","","",71,[[["self"]],[["option"],["t"]]]],[11,"size_hint","","",71,[[["self"]]]],[11,"next","","",72,[[["self"]],[["option"],["t"]]]],[11,"size_hint","","",72,[[["self"]]]],[11,"next","","",73,[[["self"]],[["option"],["t"]]]],[11,"size_hint","","",73,[[["self"]]]],[11,"next","","",74,[[["self"]],[["option"],["t"]]]],[11,"size_hint","","",74,[[["self"]]]],[11,"next","alloc::collections::linked_list","",75,[[["self"]],[["option"],["t"]]]],[11,"size_hint","","",75,[[["self"]]]],[11,"last","","",75,[[],[["option"],["t"]]]],[11,"next","","",12,[[["self"]],[["t"],["option"]]]],[11,"size_hint","","",12,[[["self"]]]],[11,"last","","",12,[[],[["t"],["option"]]]],[11,"next","","",77,[[["self"]],["option"]]],[11,"size_hint","","",77,[[["self"]]]],[11,"next","","",76,[[["self"]],["option"]]],[11,"size_hint","","",76,[[["self"]]]],[11,"next","alloc::collections::vec_deque","",78,[[["self"]],["option"]]],[11,"size_hint","","",78,[[["self"]]]],[11,"next","","",79,[[["self"]],[["option"],["t"]]]],[11,"size_hint","","",79,[[["self"]]]],[11,"fold","","",79,[[["acc"],["f"]],["acc"]]],[11,"try_fold","","",79,[[["self"],["b"],["f"]],["r"]]],[11,"nth","","",79,[[["self"],["usize"]],["option"]]],[11,"last","","",79,[[],[["option"],["t"]]]],[11,"next","","",80,[[["self"]],[["t"],["option"]]]],[11,"size_hint","","",80,[[["self"]]]],[11,"fold","","",80,[[["acc"],["f"]],["acc"]]],[11,"nth","","",80,[[["self"],["usize"]],["option"]]],[11,"last","","",80,[[],[["t"],["option"]]]],[11,"next","","",81,[[["self"]],["option"]]],[11,"size_hint","","",81,[[["self"]]]],[11,"next","alloc::string","",137,[[["self"]],[["option",["char"]],["char"]]]],[11,"size_hint","","",137,[[["self"]]]],[11,"last","","",137,[[],[["option",["char"]],["char"]]]],[11,"next","alloc::vec","",44,[[["self"]],["option"]]],[11,"size_hint","","",44,[[["self"]]]],[11,"count","","",44,[[],["usize"]]],[11,"next","","",45,[[["self"]],["option"]]],[11,"size_hint","","",45,[[["self"]]]],[11,"next","","",138,[[["self"]],["option"]]],[11,"size_hint","","",138,[[["self"]]]],[11,"next","","",139,[[["self"]],["option"]]],[11,"size_hint","","",139,[[["self"]]]],[11,"next_back","alloc::boxed","",2,[[["self"]],["option"]]],[11,"nth_back","","",2,[[["self"],["usize"]],["option"]]],[11,"next_back","alloc::collections::binary_heap","",51,[[["self"]],[["option"],["t"]]]],[11,"next_back","","",52,[[["self"]],["option"]]],[11,"next_back","","",54,[[["self"]],["option"]]],[11,"next_back","alloc::collections::btree_map","",57,[[["self"]],["option"]]],[11,"next_back","","",58,[[["self"]],["option"]]],[11,"next_back","","",59,[[["self"]],["option"]]],[11,"next_back","","",60,[[["self"]],[["option"],["k"]]]],[11,"next_back","","",61,[[["self"]],[["option"],["v"]]]],[11,"next_back","","",62,[[["self"]],[["v"],["option"]]]],[11,"next_back","","",63,[[["self"]],["option"]]],[11,"next_back","","",64,[[["self"]],["option"]]],[11,"next_back","alloc::collections::btree_set","",68,[[["self"]],[["option"],["t"]]]],[11,"next_back","","",69,[[["self"]],["option"]]],[11,"next_back","","",70,[[["self"]],[["option"],["t"]]]],[11,"next_back","alloc::collections::linked_list","",75,[[["self"]],[["option"],["t"]]]],[11,"next_back","","",12,[[["self"]],[["t"],["option"]]]],[11,"next_back","","",76,[[["self"]],["option"]]],[11,"next_back","alloc::collections::vec_deque","",78,[[["self"]],["option"]]],[11,"next_back","","",79,[[["self"]],[["option"],["t"]]]],[11,"rfold","","",79,[[["acc"],["f"]],["acc"]]],[11,"try_rfold","","",79,[[["self"],["b"],["f"]],["r"]]],[11,"next_back","","",80,[[["self"]],[["t"],["option"]]]],[11,"rfold","","",80,[[["acc"],["f"]],["acc"]]],[11,"next_back","","",81,[[["self"]],["option"]]],[11,"next_back","alloc::string","",137,[[["self"]],[["option",["char"]],["char"]]]],[11,"next_back","alloc::vec","",44,[[["self"]],["option"]]],[11,"next_back","","",45,[[["self"]],["option"]]],[11,"next_back","","",138,[[["self"]],["option"]]],[11,"extend","alloc::collections::binary_heap","",10,[[["self"],["intoiterator"]]]],[11,"extend","","",10,[[["self"],["intoiterator"]]]],[11,"extend","alloc::collections::btree_map","",56,[[["self"],["intoiterator"]]]],[11,"extend","","",56,[[["self"],["intoiterator"]]]],[11,"extend","alloc::collections::btree_set","",67,[[["self"],["intoiterator"]]]],[11,"extend","","",67,[[["self"],["intoiterator"]]]],[11,"extend","alloc::collections::linked_list","",11,[[["self"],["intoiterator"]]]],[11,"extend","","",11,[[["self"],["intoiterator"]]]],[11,"extend","alloc::collections::vec_deque","",15,[[["self"],["intoiterator"]]]],[11,"extend","","",15,[[["self"],["intoiterator"]]]],[11,"extend","alloc::string","",39,[[["intoiterator"],["self"]]]],[11,"extend","","",39,[[["intoiterator"],["self"]]]],[11,"extend","","",39,[[["intoiterator"],["self"]]]],[11,"extend","","",39,[[["self"],["intoiterator"]]]],[11,"extend","","",39,[[["intoiterator"],["self"]]]],[11,"extend","alloc::vec","",43,[[["self"],["intoiterator"]]]],[11,"extend","","",43,[[["self"],["intoiterator"]]]],[11,"from_iter","alloc::boxed","",2,[[["intoiterator"]],["self"]]],[11,"from_iter","alloc::collections::binary_heap","",10,[[["intoiterator"]],["binaryheap"]]],[11,"from_iter","alloc::collections::btree_map","",56,[[["intoiterator"]],["btreemap"]]],[11,"from_iter","alloc::collections::btree_set","",67,[[["intoiterator"]],["btreeset"]]],[11,"from_iter","alloc::collections::linked_list","",11,[[["intoiterator"]],["self"]]],[11,"from_iter","alloc::collections::vec_deque","",15,[[["intoiterator"]],["vecdeque"]]],[11,"from_iter","alloc::rc","Takes each element in the `Iterator` and collects it into…",28,[[["intoiterator"]],["self"]]],[11,"from_iter","alloc::string","",39,[[["intoiterator"]],["string"]]],[11,"from_iter","","",39,[[["intoiterator"]],["string"]]],[11,"from_iter","","",39,[[["intoiterator"]],["string"]]],[11,"from_iter","","",39,[[["intoiterator"]],["string"]]],[11,"from_iter","","",39,[[["intoiterator"]],["string"]]],[11,"from_iter","alloc::borrow","",5,[[["intoiterator"]],[["cow",["str"]],["str"]]]],[11,"from_iter","","",5,[[["intoiterator"]],[["cow",["str"]],["str"]]]],[11,"from_iter","","",5,[[["intoiterator"]],[["cow",["str"]],["str"]]]],[11,"from_iter","alloc::sync","Takes each element in the `Iterator` and collects it into…",41,[[["intoiterator"]],["self"]]],[11,"from_iter","alloc::vec","",43,[[["intoiterator"]],["vec"]]],[11,"from_iter","alloc::borrow","",5,[[["intoiterator"]],["cow"]]],[11,"into_iter","alloc::collections::binary_heap","Creates a consuming iterator, that is, one that moves each…",10,[[],["intoiter"]]],[11,"into_iter","alloc::collections::btree_map","",56,[[],["intoiter"]]],[11,"into_iter","alloc::collections::btree_set","Gets an iterator for moving out the `BTreeSet`'s contents.",67,[[],["intoiter"]]],[11,"into_iter","alloc::collections::linked_list","Consumes the list into an iterator yielding elements by…",11,[[],["intoiter"]]],[11,"into_iter","alloc::collections::vec_deque","Consumes the `VecDeque` into a front-to-back iterator…",15,[[],["intoiter"]]],[11,"into_iter","alloc::vec","Creates a consuming iterator, that is, one that moves each…",43,[[],["intoiter"]]],[11,"len","alloc::boxed","",2,[[["self"]],["usize"]]],[11,"is_empty","","",2,[[["self"]],["bool"]]],[11,"is_empty","alloc::collections::binary_heap","",51,[[["self"]],["bool"]]],[11,"is_empty","","",52,[[["self"]],["bool"]]],[11,"is_empty","","",54,[[["self"]],["bool"]]],[11,"len","alloc::collections::btree_map","",57,[[["self"]],["usize"]]],[11,"len","","",58,[[["self"]],["usize"]]],[11,"len","","",59,[[["self"]],["usize"]]],[11,"len","","",60,[[["self"]],["usize"]]],[11,"len","","",61,[[["self"]],["usize"]]],[11,"len","","",62,[[["self"]],["usize"]]],[11,"len","alloc::collections::btree_set","",68,[[["self"]],["usize"]]],[11,"len","","",69,[[["self"]],["usize"]]],[11,"is_empty","alloc::collections::vec_deque","",79,[[["self"]],["bool"]]],[11,"is_empty","","",80,[[["self"]],["bool"]]],[11,"is_empty","","",81,[[["self"]],["bool"]]],[11,"is_empty","alloc::vec","",44,[[["self"]],["bool"]]],[11,"is_empty","","",45,[[["self"]],["bool"]]],[11,"try_from","alloc::boxed","",2,[[["box"]],["result"]]],[11,"try_from","alloc::rc","",28,[[["rc"]],["result"]]],[11,"try_from","alloc::sync","",41,[[["arc"]],["result"]]],[11,"from_str","alloc::string","",39,[[["str"]],[["result",["string"]],["string"]]]],[11,"write_str","","",39,[[["str"],["self"]],["result"]]],[11,"write_char","","",39,[[["self"],["char"]],["result"]]],[11,"as_ref","alloc::boxed","",2,[[["self"]],["t"]]],[11,"as_ref","alloc::borrow","",5,[[["self"]],["t"]]],[11,"as_ref","alloc::rc","",28,[[["self"]],["t"]]],[11,"as_ref","alloc::string","",39,[[["self"]],["str"]]],[11,"as_ref","","",39,[[["self"]]]],[11,"as_ref","alloc::sync","",41,[[["self"]],["t"]]],[11,"as_ref","alloc::vec","",43,[[["self"]],["vec"]]],[11,"as_ref","","",43,[[["self"]]]],[11,"as_mut","alloc::boxed","",2,[[["self"]],["t"]]],[11,"as_mut","alloc::string","",39,[[["self"]],["str"]]],[11,"as_mut","alloc::vec","",43,[[["self"]],["vec"]]],[11,"as_mut","","",43,[[["self"]]]],[11,"fmt","alloc::boxed","",2,[[["formatter"],["self"]],["result"]]],[11,"fmt","alloc::rc","",28,[[["formatter"],["self"]],["result"]]],[11,"fmt","alloc::sync","",41,[[["formatter"],["self"]],["result"]]],[11,"clone","alloc::alloc","",50,[[["self"]],["global"]]],[11,"clone","alloc::boxed","Returns a new box with a `clone()` of this box's contents.",2,[[["self"]],["box"]]],[11,"clone_from","","Copies `source`'s contents into `self` without creating a…",2,[[["self"],["box"]]]],[11,"clone","","",2,[[["self"]],["self"]]],[11,"clone","","",2,[[["self"]],["self"]]],[11,"clone","alloc::borrow","",5,[[["self"]],["self"]]],[11,"clone_from","","",5,[[["self"],["self"]]]],[11,"clone","alloc::collections::binary_heap","",10,[[["self"]],["self"]]],[11,"clone_from","","",10,[[["self"],["self"]]]],[11,"clone","","",51,[[["self"]],["self"]]],[11,"clone","","",52,[[["self"]],["intoiter"]]],[11,"clone","","",53,[[["self"]],["intoitersorted"]]],[11,"clone","alloc::collections::btree_map","",56,[[["self"]],["btreemap"]]],[11,"clone_from","","",56,[[["self"],["self"]]]],[11,"clone","","",57,[[["self"]],["self"]]],[11,"clone","","",60,[[["self"]],["self"]]],[11,"clone","","",61,[[["self"]],["self"]]],[11,"clone","","",63,[[["self"]],["self"]]],[11,"clone","alloc::collections::btree_set","",67,[[["self"]],["self"]]],[11,"clone_from","","",67,[[["self"],["self"]]]],[11,"clone","","",68,[[["self"]],["self"]]],[11,"clone","","",70,[[["self"]],["self"]]],[11,"clone","","",71,[[["self"]],["self"]]],[11,"clone","","",72,[[["self"]],["self"]]],[11,"clone","","",73,[[["self"]],["self"]]],[11,"clone","","",74,[[["self"]],["self"]]],[11,"clone","alloc::collections::linked_list","",75,[[["self"]],["self"]]],[11,"clone","","",76,[[["self"]],["intoiter"]]],[11,"clone","","",11,[[["self"]],["self"]]],[11,"clone_from","","",11,[[["self"],["self"]]]],[11,"clone","alloc::collections::vec_deque","",15,[[["self"]],["vecdeque"]]],[11,"clone_from","","",15,[[["self"],["self"]]]],[11,"clone","","",79,[[["self"]],["self"]]],[11,"clone","","",81,[[["self"]],["intoiter"]]],[11,"clone","alloc::collections","",7,[[["self"]],["tryreserveerror"]]],[11,"clone","alloc::rc","Makes a clone of the `Rc` pointer.",28,[[["self"]],["rc"]]],[11,"clone","","Makes a clone of the `Weak` pointer that points to the…",29,[[["self"]],["weak"]]],[11,"clone","alloc::string","",40,[[["self"]],["fromutf8error"]]],[11,"clone","","",39,[[["self"]],["self"]]],[11,"clone_from","","",39,[[["self"],["self"]]]],[11,"clone","alloc::sync","Makes a clone of the `Arc` pointer.",41,[[["self"]],["arc"]]],[11,"clone","","Makes a clone of the `Weak` pointer that points to the…",42,[[["self"]],["weak"]]],[11,"clone","alloc::vec","",43,[[["self"]],["vec"]]],[11,"clone_from","","",43,[[["vec"],["self"]]]],[11,"clone","","",44,[[["self"]],["intoiter"]]],[11,"default","alloc::alloc","",50,[[],["global"]]],[11,"default","alloc::boxed","Creates a `Box<T>`, with the `Default` value for T.",2,[[],["box"]]],[11,"default","","",2,[[],["box"]]],[11,"default","","",2,[[],[["str"],["box",["str"]]]]],[11,"default","alloc::borrow","Creates an owned Cow<'a, B> with the default value for the…",5,[[],["self"]]],[11,"default","alloc::collections::binary_heap","Creates an empty `BinaryHeap<T>`.",10,[[],["binaryheap"]]],[11,"default","alloc::collections::btree_map","Creates an empty `BTreeMap<K, V>`.",56,[[],["btreemap"]]],[11,"default","alloc::collections::btree_set","Makes an empty `BTreeSet<T>` with a reasonable choice of B.",67,[[],["btreeset"]]],[11,"default","alloc::collections::linked_list","Creates an empty `LinkedList<T>`.",11,[[],["self"]]],[11,"default","alloc::collections::vec_deque","Creates an empty `VecDeque<T>`.",15,[[],["vecdeque"]]],[11,"default","alloc::rc","Creates a new `Rc<T>`, with the `Default` value for `T`.",28,[[],["rc"]]],[11,"default","","Constructs a new `Weak<T>`, allocating memory for `T`…",29,[[],["weak"]]],[11,"default","alloc::string","Creates an empty `String`.",39,[[],["string"]]],[11,"default","alloc::sync","Constructs a new `Weak<T>`, without allocating memory.…",42,[[],["weak"]]],[11,"default","","Creates a new `Arc<T>`, with the `Default` value for `T`.",41,[[],["arc"]]],[11,"default","alloc::vec","Creates an empty `Vec<T>`.",43,[[],["vec"]]],[11,"borrow","alloc::boxed","",2,[[["self"]],["t"]]],[11,"borrow","alloc::borrow","",5,[[["self"]],["b"]]],[11,"borrow","alloc::rc","",28,[[["self"]],["t"]]],[11,"borrow","alloc::vec","",43,[[["self"]]]],[11,"borrow","alloc::string","",39,[[["self"]],["str"]]],[11,"borrow","alloc::sync","",41,[[["self"]],["t"]]],[11,"borrow_mut","alloc::boxed","",2,[[["self"]],["t"]]],[11,"borrow_mut","alloc::vec","",43,[[["self"]]]],[11,"borrow_mut","alloc::string","",39,[[["self"]],["str"]]],[11,"poll","alloc::boxed","",2,[[["self"],["pin"],["context"]],["poll"]]],[11,"alloc","alloc::alloc","",50,[[["self"],["layout"]],[["result",["allocerr"]],["allocerr"]]]],[11,"dealloc","","",50,[[["nonnull",["u8"]],["self"],["layout"],["u8"]]]],[11,"realloc","","",50,[[["nonnull",["u8"]],["usize"],["self"],["layout"],["u8"]],[["result",["allocerr"]],["allocerr"]]]],[11,"alloc_zeroed","","",50,[[["self"],["layout"]],[["result",["allocerr"]],["allocerr"]]]],[11,"from_size_align","","Constructs a `Layout` from a given `size` and `align`, or…",46,[[["usize"]],[["layouterr"],["layout"],["result",["layout","layouterr"]]]]],[11,"from_size_align_unchecked","","Creates a layout, bypassing all checks.",46,[[["usize"]],["layout"]]],[11,"size","","The minimum size in bytes for a memory block of this layout.",46,[[["self"]],["usize"]]],[11,"align","","The minimum byte alignment for a memory block of this…",46,[[["self"]],["usize"]]],[11,"new","","Constructs a `Layout` suitable for holding a value of type…",46,[[],["layout"]]],[11,"for_value","","Produces layout describing a record that could be used to…",46,[[["t"]],["layout"]]],[11,"dangling","","Creates a `NonNull` that is dangling, but well-aligned for…",46,[[["self"]],[["nonnull",["u8"]],["u8"]]]],[11,"align_to","","Creates a layout describing the record that can hold a…",46,[[["usize"],["self"]],[["layouterr"],["layout"],["result",["layout","layouterr"]]]]],[11,"padding_needed_for","","Returns the amount of padding we must insert after `self`…",46,[[["usize"],["self"]],["usize"]]],[11,"pad_to_align","","Creates a layout by rounding the size of this layout up to…",46,[[["self"]],["layout"]]],[11,"repeat","","Creates a layout describing the record for `n` instances…",46,[[["usize"],["self"]],[["result",["layouterr"]],["layouterr"]]]],[11,"extend","","Creates a layout describing the record for `self` followed…",46,[[["layout"],["self"]],[["result",["layouterr"]],["layouterr"]]]],[11,"repeat_packed","","Creates a layout describing the record for `n` instances…",46,[[["usize"],["self"]],[["layouterr"],["layout"],["result",["layout","layouterr"]]]]],[11,"extend_packed","","Creates a layout describing the record for `self` followed…",46,[[["layout"],["self"]],[["layouterr"],["layout"],["result",["layout","layouterr"]]]]],[11,"array","","Creates a layout describing the record for a `[T; n]`.",46,[[["usize"]],[["layouterr"],["layout"],["result",["layout","layouterr"]]]]],[11,"description","","",49,[[["self"]],["str"]]],[11,"new","alloc::collections::btree_map","Makes a new empty BTreeMap with a reasonable choice for B.",56,[[],["btreemap"]]],[11,"clear","","Clears the map, removing all elements.",56,[[["self"]]]],[11,"get","","Returns a reference to the value corresponding to the key.",56,[[["q"],["self"]],[["option"],["v"]]]],[11,"get_key_value","","Returns the key-value pair corresponding to the supplied…",56,[[["q"],["self"]],["option"]]],[11,"first_key_value","","Returns the first key-value pair in the map. The key in…",56,[[["self"]],["option"]]],[11,"first_entry","","Returns the first entry in the map for in-place…",56,[[["self"]],[["option",["occupiedentry"]],["occupiedentry"]]]],[11,"last_key_value","","Returns the last key-value pair in the map. The key in…",56,[[["self"]],["option"]]],[11,"last_entry","","Returns the last entry in the map for in-place…",56,[[["self"]],[["option",["occupiedentry"]],["occupiedentry"]]]],[11,"contains_key","","Returns `true` if the map contains a value for the…",56,[[["q"],["self"]],["bool"]]],[11,"get_mut","","Returns a mutable reference to the value corresponding to…",56,[[["self"],["q"]],[["option"],["v"]]]],[11,"insert","","Inserts a key-value pair into the map.",56,[[["self"],["k"],["v"]],["option"]]],[11,"remove","","Removes a key from the map, returning the value at the key…",56,[[["self"],["q"]],["option"]]],[11,"remove_entry","","Removes a key from the map, returning the stored key and…",56,[[["self"],["q"]],["option"]]],[11,"append","","Moves all elements from `other` into `Self`, leaving…",56,[[["self"]]]],[11,"range","","Constructs a double-ended iterator over a sub-range of…",56,[[["r"],["self"]],["range"]]],[11,"range_mut","","Constructs a mutable double-ended iterator over a…",56,[[["self"],["r"]],["rangemut"]]],[11,"entry","","Gets the given key's corresponding entry in the map for…",56,[[["self"],["k"]],["entry"]]],[11,"split_off","","Splits the collection into two at the given key. Returns…",56,[[["self"],["q"]],["self"]]],[11,"iter","","Gets an iterator over the entries of the map, sorted by key.",56,[[["self"]],["iter"]]],[11,"iter_mut","","Gets a mutable iterator over the entries of the map,…",56,[[["self"]],["itermut"]]],[11,"keys","","Gets an iterator over the keys of the map, in sorted order.",56,[[["self"]],["keys"]]],[11,"values","","Gets an iterator over the values of the map, in order by…",56,[[["self"]],["values"]]],[11,"values_mut","","Gets a mutable iterator over the values of the map, in…",56,[[["self"]],["valuesmut"]]],[11,"len","","Returns the number of elements in the map.",56,[[["self"]],["usize"]]],[11,"is_empty","","Returns `true` if the map contains no elements.",56,[[["self"]],["bool"]]],[11,"or_insert","","Ensures a value is in the entry by inserting the default…",16,[[["v"]],["v"]]],[11,"or_insert_with","","Ensures a value is in the entry by inserting the result of…",16,[[["fnonce"]],["v"]]],[11,"key","","Returns a reference to this entry's key.",16,[[["self"]],["k"]]],[11,"and_modify","","Provides in-place mutable access to an occupied entry…",16,[[["f"]],["self"]]],[11,"or_default","","Ensures a value is in the entry by inserting the default…",16,[[],["v"]]],[11,"key","","Gets a reference to the key that would be used when…",65,[[["self"]],["k"]]],[11,"into_key","","Take ownership of the key.",65,[[],["k"]]],[11,"insert","","Sets the value of the entry with the `VacantEntry`'s key,…",65,[[["v"]],["v"]]],[11,"key","","Gets a reference to the key in the entry.",66,[[["self"]],["k"]]],[11,"remove_entry","","Take ownership of the key and value from the map.",66,[[]]],[11,"get","","Gets a reference to the value in the entry.",66,[[["self"]],["v"]]],[11,"get_mut","","Gets a mutable reference to the value in the entry.",66,[[["self"]],["v"]]],[11,"into_mut","","Converts the entry into a mutable reference to its value.",66,[[],["v"]]],[11,"insert","","Sets the value of the entry with the `OccupiedEntry`'s…",66,[[["self"],["v"]],["v"]]],[11,"remove","","Takes the value of the entry out of the map, and returns it.",66,[[],["v"]]],[11,"new","alloc::collections::btree_set","Makes a new `BTreeSet` with a reasonable choice of B.",67,[[],["btreeset"]]],[11,"range","","Constructs a double-ended iterator over a sub-range of…",67,[[["r"],["self"]],["range"]]],[11,"difference","","Visits the values representing the difference, i.e., the…",67,[[["self"],["btreeset"]],["difference"]]],[11,"symmetric_difference","","Visits the values representing the symmetric difference,…",67,[[["self"],["btreeset"]],["symmetricdifference"]]],[11,"intersection","","Visits the values representing the intersection, i.e., the…",67,[[["self"],["btreeset"]],["intersection"]]],[11,"union","","Visits the values representing the union, i.e., all the…",67,[[["self"],["btreeset"]],["union"]]],[11,"clear","","Clears the set, removing all values.",67,[[["self"]]]],[11,"contains","","Returns `true` if the set contains a value.",67,[[["q"],["self"]],["bool"]]],[11,"get","","Returns a reference to the value in the set, if any, that…",67,[[["q"],["self"]],[["option"],["t"]]]],[11,"is_disjoint","","Returns `true` if `self` has no elements in common with…",67,[[["btreeset"],["self"]],["bool"]]],[11,"is_subset","","Returns `true` if the set is a subset of another, i.e.,…",67,[[["btreeset"],["self"]],["bool"]]],[11,"is_superset","","Returns `true` if the set is a superset of another, i.e.,…",67,[[["btreeset"],["self"]],["bool"]]],[11,"first","","Returns a reference to the first value in the set, if any.…",67,[[["self"]],[["option"],["t"]]]],[11,"last","","Returns a reference to the last value in the set, if any.…",67,[[["self"]],[["option"],["t"]]]],[11,"pop_first","","Removes the first value from the set and returns it, if…",67,[[["self"]],["option"]]],[11,"pop_last","","Removes the last value from the set and returns it, if…",67,[[["self"]],["option"]]],[11,"insert","","Adds a value to the set.",67,[[["self"],["t"]],["bool"]]],[11,"replace","","Adds a value to the set, replacing the existing value, if…",67,[[["self"],["t"]],["option"]]],[11,"remove","","Removes a value from the set. Returns whether the value…",67,[[["self"],["q"]],["bool"]]],[11,"take","","Removes and returns the value in the set, if any, that is…",67,[[["self"],["q"]],["option"]]],[11,"append","","Moves all elements from `other` into `Self`, leaving…",67,[[["self"]]]],[11,"split_off","","Splits the collection into two at the given key. Returns…",67,[[["self"],["q"]],["self"]]],[11,"iter","","Gets an iterator that visits the values in the `BTreeSet`…",67,[[["self"]],["iter"]]],[11,"len","","Returns the number of elements in the set.",67,[[["self"]],["usize"]]],[11,"is_empty","","Returns `true` if the set contains no elements.",67,[[["self"]],["bool"]]],[11,"entry","alloc::fmt","Adds a new entry to the list output.",84,[[["debug"],["self"]],["debuglist"]]],[11,"entries","","Adds the contents of an iterator of entries to the list…",84,[[["self"],["i"]],["debuglist"]]],[11,"finish","","Finishes output and returns any error encountered.",84,[[["self"]],[["error"],["result",["error"]]]]],[11,"entry","","Adds a new entry to the map output.",85,[[["debug"],["self"]],["debugmap"]]],[11,"key","","Adds the key part of a new entry to the map output.",85,[[["debug"],["self"]],["debugmap"]]],[11,"value","","Adds the value part of a new entry to the map output.",85,[[["debug"],["self"]],["debugmap"]]],[11,"entries","","Adds the contents of an iterator of entries to the map…",85,[[["self"],["i"]],["debugmap"]]],[11,"finish","","Finishes output and returns any error encountered.",85,[[["self"]],[["error"],["result",["error"]]]]],[11,"entry","","Adds a new entry to the set output.",86,[[["debug"],["self"]],["debugset"]]],[11,"entries","","Adds the contents of an iterator of entries to the set…",86,[[["self"],["i"]],["debugset"]]],[11,"finish","","Finishes output and returns any error encountered.",86,[[["self"]],[["error"],["result",["error"]]]]],[11,"field","","Adds a new field to the generated struct output.",87,[[["str"],["self"],["debug"]],["debugstruct"]]],[11,"finish_non_exhaustive","","Marks the struct as non-exhaustive, indicating to the…",87,[[["self"]],[["error"],["result",["error"]]]]],[11,"finish","","Finishes output and returns any error encountered.",87,[[["self"]],[["error"],["result",["error"]]]]],[11,"field","","Adds a new field to the generated tuple struct output.",88,[[["debug"],["self"]],["debugtuple"]]],[11,"finish","","Finishes output and returns any error encountered.",88,[[["self"]],[["error"],["result",["error"]]]]],[11,"pad_integral","","Performs the correct padding for an integer which has…",89,[[["str"],["self"],["bool"]],[["error"],["result",["error"]]]]],[11,"pad","","This function takes a string slice and emits it to the…",89,[[["str"],["self"]],[["error"],["result",["error"]]]]],[11,"write_str","","Writes some data to the underlying buffer contained within…",89,[[["str"],["self"]],[["error"],["result",["error"]]]]],[11,"write_fmt","","Writes some formatted information into this instance.",89,[[["self"],["arguments"]],[["error"],["result",["error"]]]]],[11,"flags","","Flags for formatting",89,[[["self"]],["u32"]]],[11,"fill","","Character used as 'fill' whenever there is alignment.",89,[[["self"]],["char"]]],[11,"align","","Flag indicating what form of alignment was requested.",89,[[["self"]],[["option",["alignment"]],["alignment"]]]],[11,"width","","Optionally specified integer width that the output should…",89,[[["self"]],[["usize"],["option",["usize"]]]]],[11,"precision","","Optionally specified precision for numeric types.",89,[[["self"]],[["usize"],["option",["usize"]]]]],[11,"sign_plus","","Determines if the `+` flag was specified.",89,[[["self"]],["bool"]]],[11,"sign_minus","","Determines if the `-` flag was specified.",89,[[["self"]],["bool"]]],[11,"alternate","","Determines if the `#` flag was specified.",89,[[["self"]],["bool"]]],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",89,[[["self"]],["bool"]]],[11,"debug_struct","","Creates a [`DebugStruct`] builder designed to assist with…",89,[[["str"],["self"]],["debugstruct"]]],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with…",89,[[["str"],["self"]],["debugtuple"]]],[11,"debug_list","","Creates a `DebugList` builder designed to assist with…",89,[[["self"]],["debuglist"]]],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with…",89,[[["self"]],["debugset"]]],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with…",89,[[["self"]],["debugmap"]]],[11,"remainder","alloc::slice","Returns the remainder of the original slice that is not…",92,[[["self"]]]],[11,"into_remainder","","Returns the remainder of the original slice that is not…",93,[[]]],[11,"as_slice","","Views the underlying data as a subslice of the original…",97,[[["self"]]]],[11,"into_slice","","Views the underlying data as a subslice of the original…",98,[[]]],[11,"as_slice","","Views the underlying data as a subslice of the original…",98,[[["self"]]]],[11,"remainder","","Returns the remainder of the original slice that is not…",100,[[["self"]]]],[11,"into_remainder","","Returns the remainder of the original slice that is not…",101,[[]]],[11,"as_str","alloc::str","Views the underlying data as a subslice of the original…",117,[[["self"]],["str"]]],[11,"as_str","","Views the underlying data as a subslice of the original…",118,[[["self"]],["str"]]],[11,"valid_up_to","","Returns the index in the given string up to which valid…",123,[[["self"]],["usize"]]],[11,"error_len","","Provides more information about the failure:",123,[[["self"]],[["usize"],["option",["usize"]]]]]],"p":[[8,"GlobalAlloc"],[8,"AllocRef"],[3,"Box"],[8,"Borrow"],[8,"BorrowMut"],[4,"Cow"],[8,"ToOwned"],[4,"TryReserveError"],[13,"AllocError"],[3,"PeekMut"],[3,"BinaryHeap"],[3,"LinkedList"],[3,"IterMut"],[3,"Cursor"],[3,"CursorMut"],[3,"VecDeque"],[4,"Entry"],[4,"Alignment"],[8,"Binary"],[8,"Octal"],[8,"Debug"],[8,"Display"],[8,"Write"],[8,"LowerExp"],[8,"UpperExp"],[8,"LowerHex"],[8,"Pointer"],[8,"UpperHex"],[3,"Rc"],[3,"Weak"],[8,"SliceIndex"],[8,"Concat"],[8,"Join"],[8,"Pattern"],[4,"SearchStep"],[8,"Searcher"],[8,"ReverseSearcher"],[8,"FromStr"],[8,"ToString"],[3,"String"],[3,"FromUtf8Error"],[3,"Arc"],[3,"Weak"],[3,"Vec"],[3,"IntoIter"],[3,"Drain"],[3,"Layout"],[3,"LayoutErr"],[3,"AllocErr"],[3,"CannotReallocInPlace"],[3,"Global"],[3,"Iter"],[3,"IntoIter"],[3,"IntoIterSorted"],[3,"Drain"],[3,"DrainSorted"],[3,"BTreeMap"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Keys"],[3,"Values"],[3,"ValuesMut"],[3,"Range"],[3,"RangeMut"],[3,"VacantEntry"],[3,"OccupiedEntry"],[3,"BTreeSet"],[3,"Iter"],[3,"IntoIter"],[3,"Range"],[3,"Difference"],[3,"SymmetricDifference"],[3,"Intersection"],[3,"Union"],[3,"Iter"],[3,"IntoIter"],[3,"DrainFilter"],[3,"Drain"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Error"],[3,"Arguments"],[3,"DebugList"],[3,"DebugMap"],[3,"DebugSet"],[3,"DebugStruct"],[3,"DebugTuple"],[3,"Formatter"],[3,"Chunks"],[3,"Windows"],[3,"ChunksExact"],[3,"ChunksExactMut"],[3,"ChunksMut"],[3,"Split"],[3,"SplitMut"],[3,"Iter"],[3,"IterMut"],[3,"RChunks"],[3,"RChunksExact"],[3,"RChunksExactMut"],[3,"RChunksMut"],[3,"RSplit"],[3,"RSplitMut"],[3,"RSplitN"],[3,"RSplitNMut"],[3,"SplitN"],[3,"SplitNMut"],[3,"CharSearcher"],[3,"CharSliceSearcher"],[3,"CharPredicateSearcher"],[3,"StrSearcher"],[3,"EncodeUtf16"],[3,"SplitAsciiWhitespace"],[3,"SplitWhitespace"],[3,"Bytes"],[3,"CharIndices"],[3,"Chars"],[3,"ParseBoolError"],[3,"EscapeDebug"],[3,"EscapeDefault"],[3,"EscapeUnicode"],[3,"Utf8Error"],[3,"Lines"],[3,"LinesAny"],[3,"MatchIndices"],[3,"RMatchIndices"],[3,"Matches"],[3,"RMatches"],[3,"RSplit"],[3,"Split"],[3,"RSplitN"],[3,"SplitN"],[3,"RSplitTerminator"],[3,"SplitTerminator"],[3,"FromUtf16Error"],[3,"Drain"],[3,"Splice"],[3,"DrainFilter"]]};
searchIndex["core"] = {"doc":"The Rust Core Library","i":[[0,"i128","core","The 128-bit signed integer type.",null,null],[17,"MIN","core::i128","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"i16","core","The 16-bit signed integer type.",null,null],[17,"MIN","core::i16","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"i32","core","The 32-bit signed integer type.",null,null],[17,"MIN","core::i32","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"i64","core","The 64-bit signed integer type.",null,null],[17,"MIN","core::i64","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"i8","core","The 8-bit signed integer type.",null,null],[17,"MIN","core::i8","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"isize","core","The pointer-sized signed integer type.",null,null],[17,"MIN","core::isize","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"u128","core","The 128-bit unsigned integer type.",null,null],[17,"MIN","core::u128","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"u16","core","The 16-bit unsigned integer type.",null,null],[17,"MIN","core::u16","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"u32","core","The 32-bit unsigned integer type.",null,null],[17,"MIN","core::u32","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"u64","core","The 64-bit unsigned integer type.",null,null],[17,"MIN","core::u64","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"u8","core","The 8-bit unsigned integer type.",null,null],[17,"MIN","core::u8","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"usize","core","The pointer-sized unsigned integer type.",null,null],[17,"MIN","core::usize","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"f32","core","This module provides constants which are specific to the…",null,null],[0,"consts","core::f32","Basic mathematical constants.",null,null],[17,"PI","core::f32::consts","Archimedes' constant (π)",null,null],[17,"TAU","","The full circle constant (τ)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler's number (e)",null,null],[17,"LOG2_E","","log2(e)",null,null],[17,"LOG2_10","","log2(10)",null,null],[17,"LOG10_E","","log10(e)",null,null],[17,"LOG10_2","","log10(2)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[17,"RADIX","core::f32","The radix or base of the internal representation of `f32`.…",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2. Use…",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10. Use…",null,null],[17,"EPSILON","","[Machine epsilon] value for `f32`. Use `f32::EPSILON`…",null,null],[17,"MIN","","Smallest finite `f32` value. Use `f32::MIN` instead.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f32` value. Use…",null,null],[17,"MAX","","Largest finite `f32` value. Use `f32::MAX` instead.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2…",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent. Use `f32::MAX_EXP`…",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent. Use…",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent. Use…",null,null],[17,"NAN","","Not a Number (NaN). Use `f32::NAN` instead.",null,null],[17,"INFINITY","","Infinity (∞). Use `f32::INFINITY` instead.",null,null],[17,"NEG_INFINITY","","Negative infinity (−∞). Use `f32::NEG_INFINITY` instead.",null,null],[0,"f64","core","This module provides constants which are specific to the…",null,null],[0,"consts","core::f64","Basic mathematical constants.",null,null],[17,"PI","core::f64::consts","Archimedes' constant (π)",null,null],[17,"TAU","","The full circle constant (τ)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler's number (e)",null,null],[17,"LOG2_10","","log2(10)",null,null],[17,"LOG2_E","","log2(e)",null,null],[17,"LOG10_2","","log10(2)",null,null],[17,"LOG10_E","","log10(e)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[17,"RADIX","core::f64","The radix or base of the internal representation of `f64`.…",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2. Use…",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10. Use…",null,null],[17,"EPSILON","","[Machine epsilon] value for `f64`. Use `f64::EPSILON`…",null,null],[17,"MIN","","Smallest finite `f64` value. Use `f64::MIN` instead.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f64` value. Use…",null,null],[17,"MAX","","Largest finite `f64` value. Use `f64::MAX` instead.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2…",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent. Use `f64::MAX_EXP`…",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent. Use…",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent. Use…",null,null],[17,"NAN","","Not a Number (NaN). Use `f64::NAN` instead.",null,null],[17,"INFINITY","","Infinity (∞). Use `f64::INFINITY` instead.",null,null],[17,"NEG_INFINITY","","Negative infinity (−∞). Use `f64::NEG_INFINITY` instead.",null,null],[0,"num","core","Numeric traits and functions for the built-in numeric types.",null,null],[3,"NonZeroU8","core::num","An integer that is known not to equal zero.",null,null],[3,"NonZeroU16","","An integer that is known not to equal zero.",null,null],[3,"NonZeroU32","","An integer that is known not to equal zero.",null,null],[3,"NonZeroU64","","An integer that is known not to equal zero.",null,null],[3,"NonZeroU128","","An integer that is known not to equal zero.",null,null],[3,"NonZeroUsize","","An integer that is known not to equal zero.",null,null],[3,"NonZeroI8","","An integer that is known not to equal zero.",null,null],[3,"NonZeroI16","","An integer that is known not to equal zero.",null,null],[3,"NonZeroI32","","An integer that is known not to equal zero.",null,null],[3,"NonZeroI64","","An integer that is known not to equal zero.",null,null],[3,"NonZeroI128","","An integer that is known not to equal zero.",null,null],[3,"NonZeroIsize","","An integer that is known not to equal zero.",null,null],[3,"Wrapping","","Provides intentionally-wrapped arithmetic on `T`.",null,null],[12,"0","","",0,null],[3,"TryFromIntError","","The error type returned when a checked integral type…",null,null],[3,"ParseIntError","","An error which can be returned when parsing an integer.",null,null],[3,"ParseFloatError","","An error which can be returned when parsing a float.",null,null],[4,"FpCategory","","A classification of floating point numbers.",null,null],[13,"Nan","","\"Not a Number\", often obtained by dividing by zero.",1,null],[13,"Infinite","","Positive or negative infinity.",1,null],[13,"Zero","","Positive or negative zero.",1,null],[13,"Subnormal","","De-normalized floating point representation (less precise…",1,null],[13,"Normal","","A regular floating point number.",1,null],[4,"IntErrorKind","","Enum to store the various types of errors that can cause…",null,null],[13,"Empty","","Value being parsed is empty.",2,null],[13,"InvalidDigit","","Contains an invalid digit.",2,null],[13,"Overflow","","Integer is too large to store in target integer type.",2,null],[13,"Underflow","","Integer is too small to store in target integer type.",2,null],[13,"Zero","","Value was Zero",2,null],[11,"min_value","","Returns the smallest value that can be represented by this…",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this…",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's…",0,[[],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's…",0,[[],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's…",0,[[],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this…",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this…",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's…",0,[[],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's…",0,[[],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's…",0,[[],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this…",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this…",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's…",0,[[],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's…",0,[[],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's…",0,[[],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this…",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this…",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's…",0,[[],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's…",0,[[],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's…",0,[[],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this…",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this…",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's…",0,[[],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's…",0,[[],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's…",0,[[],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this…",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this…",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's…",0,[[],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's…",0,[[],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's…",0,[[],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this…",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this…",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's…",0,[[],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's…",0,[[],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's…",0,[[],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this…",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this…",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's…",0,[[],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's…",0,[[],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's…",0,[[],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this…",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this…",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's…",0,[[],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's…",0,[[],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's…",0,[[],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this…",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this…",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's…",0,[[],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's…",0,[[],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's…",0,[[],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this…",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this…",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's…",0,[[],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's…",0,[[],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's…",0,[[],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[["u32"]],["self"]]],[11,"min_value","","Returns the smallest value that can be represented by this…",0,[[],["self"]]],[11,"max_value","","Returns the largest value that can be represented by this…",0,[[],["self"]]],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[],["u32"]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[],["u32"]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[],["u32"]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[["u32"]],["self"]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[],["self"]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[],["self"]]],[11,"from_be","","Converts an integer from big endian to the target's…",0,[[],["self"]]],[11,"from_le","","Converts an integer from little endian to the target's…",0,[[],["self"]]],[11,"to_be","","Converts `self` to big endian from the target's endianness.",0,[[],["self"]]],[11,"to_le","","Converts `self` to little endian from the target's…",0,[[],["self"]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[["u32"]],["self"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[],["u32"]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at…",0,[[],[["isize"],["wrapping",["isize"]]]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[],[["isize"],["wrapping",["isize"]]]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the…",0,[[],["bool"]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the…",0,[[],["bool"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[],["u32"]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at…",0,[[],[["wrapping",["i8"]],["i8"]]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[],[["wrapping",["i8"]],["i8"]]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the…",0,[[],["bool"]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the…",0,[[],["bool"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[],["u32"]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at…",0,[[],[["wrapping",["i16"]],["i16"]]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[],[["wrapping",["i16"]],["i16"]]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the…",0,[[],["bool"]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the…",0,[[],["bool"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[],["u32"]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at…",0,[[],[["wrapping",["i32"]],["i32"]]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[],[["wrapping",["i32"]],["i32"]]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the…",0,[[],["bool"]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the…",0,[[],["bool"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[],["u32"]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at…",0,[[],[["i64"],["wrapping",["i64"]]]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[],[["i64"],["wrapping",["i64"]]]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the…",0,[[],["bool"]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the…",0,[[],["bool"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[],["u32"]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at…",0,[[],[["i128"],["wrapping",["i128"]]]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[],[["i128"],["wrapping",["i128"]]]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the…",0,[[],["bool"]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the…",0,[[],["bool"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[],["u32"]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[],["bool"]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to…",0,[[],["self"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[],["u32"]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[],["bool"]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to…",0,[[],["self"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[],["u32"]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[],["bool"]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to…",0,[[],["self"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[],["u32"]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[],["bool"]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to…",0,[[],["self"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[],["u32"]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[],["bool"]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to…",0,[[],["self"]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[],["u32"]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[],["bool"]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to…",0,[[],["self"]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",3,[[["u8"]],["self"]]],[11,"new","","Creates a non-zero if the given value is not zero.",3,[[["u8"]],["option"]]],[11,"get","","Returns the value as a primitive type.",3,[[],["u8"]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",4,[[["u16"]],["self"]]],[11,"new","","Creates a non-zero if the given value is not zero.",4,[[["u16"]],["option"]]],[11,"get","","Returns the value as a primitive type.",4,[[],["u16"]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",5,[[["u32"]],["self"]]],[11,"new","","Creates a non-zero if the given value is not zero.",5,[[["u32"]],["option"]]],[11,"get","","Returns the value as a primitive type.",5,[[],["u32"]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",6,[[["u64"]],["self"]]],[11,"new","","Creates a non-zero if the given value is not zero.",6,[[["u64"]],["option"]]],[11,"get","","Returns the value as a primitive type.",6,[[],["u64"]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",7,[[["u128"]],["self"]]],[11,"new","","Creates a non-zero if the given value is not zero.",7,[[["u128"]],["option"]]],[11,"get","","Returns the value as a primitive type.",7,[[],["u128"]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",8,[[["usize"]],["self"]]],[11,"new","","Creates a non-zero if the given value is not zero.",8,[[["usize"]],["option"]]],[11,"get","","Returns the value as a primitive type.",8,[[],["usize"]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",9,[[["i8"]],["self"]]],[11,"new","","Creates a non-zero if the given value is not zero.",9,[[["i8"]],["option"]]],[11,"get","","Returns the value as a primitive type.",9,[[],["i8"]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",10,[[["i16"]],["self"]]],[11,"new","","Creates a non-zero if the given value is not zero.",10,[[["i16"]],["option"]]],[11,"get","","Returns the value as a primitive type.",10,[[],["i16"]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",11,[[["i32"]],["self"]]],[11,"new","","Creates a non-zero if the given value is not zero.",11,[[["i32"]],["option"]]],[11,"get","","Returns the value as a primitive type.",11,[[],["i32"]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",12,[[["i64"]],["self"]]],[11,"new","","Creates a non-zero if the given value is not zero.",12,[[["i64"]],["option"]]],[11,"get","","Returns the value as a primitive type.",12,[[],["i64"]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",13,[[["i128"]],["self"]]],[11,"new","","Creates a non-zero if the given value is not zero.",13,[[["i128"]],["option"]]],[11,"get","","Returns the value as a primitive type.",13,[[],["i128"]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",14,[[["isize"]],["self"]]],[11,"new","","Creates a non-zero if the given value is not zero.",14,[[["isize"]],["option"]]],[11,"get","","Returns the value as a primitive type.",14,[[],["isize"]]],[11,"kind","","Outputs the detailed cause of parsing an integer failing.",15,[[["self"]],["interrorkind"]]],[0,"prelude","core","The libcore prelude",null,null],[0,"v1","core::prelude","The core prelude",null,null],[0,"hint","core","Hints to compiler that affects how code should be emitted…",null,null],[5,"unreachable_unchecked","core::hint","Informs the compiler that this point in the code is not…",null,[[]]],[5,"spin_loop","","Emits a machine instruction hinting to the processor that…",null,[[]]],[5,"black_box","","An identity function that hints to the compiler to be…",null,[[["t"]],["t"]]],[0,"intrinsics","core","Compiler intrinsics.",null,null],[5,"copy_nonoverlapping","core::intrinsics","Copies `count * size_of::<T>()` bytes from `src` to `dst`.…",null,[[["usize"]]]],[5,"copy","","Copies `count * size_of::<T>()` bytes from `src` to `dst`.…",null,[[["usize"]]]],[5,"write_bytes","","Sets `count * size_of::<T>()` bytes of memory starting at…",null,[[["u8"],["usize"]]]],[5,"atomic_cxchg","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchg_acq","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchg_rel","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchg_acqrel","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchg_relaxed","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchg_failrelaxed","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchg_failacq","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchg_acq_failrelaxed","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchg_acqrel_failrelaxed","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchgweak","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchgweak_acq","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchgweak_rel","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchgweak_acqrel","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchgweak_relaxed","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchgweak_failrelaxed","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchgweak_failacq","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchgweak_acq_failrelaxed","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchgweak_acqrel_failrelaxed","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_load","","Loads the current value of the pointer.",null,null],[5,"atomic_load_acq","","Loads the current value of the pointer.",null,null],[5,"atomic_load_relaxed","","Loads the current value of the pointer.",null,null],[5,"atomic_load_unordered","","",null,null],[5,"atomic_store","","Stores the value at the specified memory location.",null,null],[5,"atomic_store_rel","","Stores the value at the specified memory location.",null,null],[5,"atomic_store_relaxed","","Stores the value at the specified memory location.",null,null],[5,"atomic_store_unordered","","",null,null],[5,"atomic_xchg","","Stores the value at the specified memory location,…",null,null],[5,"atomic_xchg_acq","","Stores the value at the specified memory location,…",null,null],[5,"atomic_xchg_rel","","Stores the value at the specified memory location,…",null,null],[5,"atomic_xchg_acqrel","","Stores the value at the specified memory location,…",null,null],[5,"atomic_xchg_relaxed","","Stores the value at the specified memory location,…",null,null],[5,"atomic_xadd","","Adds to the current value, returning the previous value.",null,null],[5,"atomic_xadd_acq","","Adds to the current value, returning the previous value.",null,null],[5,"atomic_xadd_rel","","Adds to the current value, returning the previous value.",null,null],[5,"atomic_xadd_acqrel","","Adds to the current value, returning the previous value.",null,null],[5,"atomic_xadd_relaxed","","Adds to the current value, returning the previous value.",null,null],[5,"atomic_xsub","","Subtract from the current value, returning the previous…",null,null],[5,"atomic_xsub_acq","","Subtract from the current value, returning the previous…",null,null],[5,"atomic_xsub_rel","","Subtract from the current value, returning the previous…",null,null],[5,"atomic_xsub_acqrel","","Subtract from the current value, returning the previous…",null,null],[5,"atomic_xsub_relaxed","","Subtract from the current value, returning the previous…",null,null],[5,"atomic_and","","Bitwise and with the current value, returning the previous…",null,null],[5,"atomic_and_acq","","Bitwise and with the current value, returning the previous…",null,null],[5,"atomic_and_rel","","Bitwise and with the current value, returning the previous…",null,null],[5,"atomic_and_acqrel","","Bitwise and with the current value, returning the previous…",null,null],[5,"atomic_and_relaxed","","Bitwise and with the current value, returning the previous…",null,null],[5,"atomic_nand","","Bitwise nand with the current value, returning the…",null,null],[5,"atomic_nand_acq","","Bitwise nand with the current value, returning the…",null,null],[5,"atomic_nand_rel","","Bitwise nand with the current value, returning the…",null,null],[5,"atomic_nand_acqrel","","Bitwise nand with the current value, returning the…",null,null],[5,"atomic_nand_relaxed","","Bitwise nand with the current value, returning the…",null,null],[5,"atomic_or","","Bitwise or with the current value, returning the previous…",null,null],[5,"atomic_or_acq","","Bitwise or with the current value, returning the previous…",null,null],[5,"atomic_or_rel","","Bitwise or with the current value, returning the previous…",null,null],[5,"atomic_or_acqrel","","Bitwise or with the current value, returning the previous…",null,null],[5,"atomic_or_relaxed","","Bitwise or with the current value, returning the previous…",null,null],[5,"atomic_xor","","Bitwise xor with the current value, returning the previous…",null,null],[5,"atomic_xor_acq","","Bitwise xor with the current value, returning the previous…",null,null],[5,"atomic_xor_rel","","Bitwise xor with the current value, returning the previous…",null,null],[5,"atomic_xor_acqrel","","Bitwise xor with the current value, returning the previous…",null,null],[5,"atomic_xor_relaxed","","Bitwise xor with the current value, returning the previous…",null,null],[5,"atomic_max","","Maximum with the current value using a signed comparison.",null,null],[5,"atomic_max_acq","","Maximum with the current value using a signed comparison.",null,null],[5,"atomic_max_rel","","Maximum with the current value using a signed comparison.",null,null],[5,"atomic_max_acqrel","","Maximum with the current value using a signed comparison.",null,null],[5,"atomic_max_relaxed","","Maximum with the current value.",null,null],[5,"atomic_min","","Minimum with the current value using a signed comparison.",null,null],[5,"atomic_min_acq","","Minimum with the current value using a signed comparison.",null,null],[5,"atomic_min_rel","","Minimum with the current value using a signed comparison.",null,null],[5,"atomic_min_acqrel","","Minimum with the current value using a signed comparison.",null,null],[5,"atomic_min_relaxed","","Minimum with the current value using a signed comparison.",null,null],[5,"atomic_umin","","Minimum with the current value using an unsigned comparison.",null,null],[5,"atomic_umin_acq","","Minimum with the current value using an unsigned comparison.",null,null],[5,"atomic_umin_rel","","Minimum with the current value using an unsigned comparison.",null,null],[5,"atomic_umin_acqrel","","Minimum with the current value using an unsigned comparison.",null,null],[5,"atomic_umin_relaxed","","Minimum with the current value using an unsigned comparison.",null,null],[5,"atomic_umax","","Maximum with the current value using an unsigned comparison.",null,null],[5,"atomic_umax_acq","","Maximum with the current value using an unsigned comparison.",null,null],[5,"atomic_umax_rel","","Maximum with the current value using an unsigned comparison.",null,null],[5,"atomic_umax_acqrel","","Maximum with the current value using an unsigned comparison.",null,null],[5,"atomic_umax_relaxed","","Maximum with the current value using an unsigned comparison.",null,null],[5,"prefetch_read_data","","The `prefetch` intrinsic is a hint to the code generator…",null,null],[5,"prefetch_write_data","","The `prefetch` intrinsic is a hint to the code generator…",null,null],[5,"prefetch_read_instruction","","The `prefetch` intrinsic is a hint to the code generator…",null,null],[5,"prefetch_write_instruction","","The `prefetch` intrinsic is a hint to the code generator…",null,null],[5,"atomic_fence","","An atomic fence.",null,null],[5,"atomic_fence_acq","","An atomic fence.",null,null],[5,"atomic_fence_rel","","An atomic fence.",null,null],[5,"atomic_fence_acqrel","","An atomic fence.",null,null],[5,"atomic_singlethreadfence","","A compiler-only memory barrier.",null,null],[5,"atomic_singlethreadfence_acq","","A compiler-only memory barrier.",null,null],[5,"atomic_singlethreadfence_rel","","A compiler-only memory barrier.",null,null],[5,"atomic_singlethreadfence_acqrel","","A compiler-only memory barrier.",null,null],[5,"rustc_peek","","Magic intrinsic that derives its meaning from attributes…",null,null],[5,"abort","","Aborts the execution of the process.",null,null],[5,"unreachable","","Tells LLVM that this point in the code is not reachable,…",null,null],[5,"assume","","Informs the optimizer that a condition is always true. If…",null,null],[5,"likely","","Hints to the compiler that branch condition is likely to…",null,null],[5,"unlikely","","Hints to the compiler that branch condition is likely to…",null,null],[5,"breakpoint","","Executes a breakpoint trap, for inspection by a debugger.",null,null],[5,"size_of","","The size of a type in bytes.",null,null],[5,"move_val_init","","Moves a value to an uninitialized memory location.",null,null],[5,"min_align_of","","The minimum alignment of a type.",null,null],[5,"pref_align_of","","",null,null],[5,"size_of_val","","The size of the referenced value in bytes.",null,null],[5,"min_align_of_val","","The minimum alignment of the type of the value that `val`…",null,null],[5,"type_name","","Gets a static string slice containing the name of a type.",null,null],[5,"type_id","","Gets an identifier which is globally unique to the…",null,null],[5,"panic_if_uninhabited","","A guard for unsafe functions that cannot ever be executed…",null,null],[5,"caller_location","","Gets a reference to a static `Location` indicating where…",null,null],[5,"init","","Creates a value initialized to zero.",null,null],[5,"uninit","","Creates an uninitialized value.",null,null],[5,"forget","","Moves a value out of scope without running drop glue.",null,null],[5,"transmute","","Reinterprets the bits of a value of one type as another…",null,null],[5,"needs_drop","","Returns `true` if the actual type given as `T` requires…",null,null],[5,"offset","","Calculates the offset from a pointer.",null,null],[5,"arith_offset","","Calculates the offset from a pointer, potentially wrapping.",null,null],[5,"volatile_copy_nonoverlapping_memory","","Equivalent to the appropriate `llvm.memcpy.p0i8.0i8.*`…",null,null],[5,"volatile_copy_memory","","Equivalent to the appropriate `llvm.memmove.p0i8.0i8.*`…",null,null],[5,"volatile_set_memory","","Equivalent to the appropriate `llvm.memset.p0i8.*`…",null,null],[5,"volatile_load","","Performs a volatile load from the `src` pointer.",null,null],[5,"volatile_store","","Performs a volatile store to the `dst` pointer.",null,null],[5,"unaligned_volatile_load","","Performs a volatile load from the `src` pointer The…",null,null],[5,"unaligned_volatile_store","","Performs a volatile store to the `dst` pointer. The…",null,null],[5,"sqrtf32","","Returns the square root of an `f32`",null,null],[5,"sqrtf64","","Returns the square root of an `f64`",null,null],[5,"powif32","","Raises an `f32` to an integer power.",null,null],[5,"powif64","","Raises an `f64` to an integer power.",null,null],[5,"sinf32","","Returns the sine of an `f32`.",null,null],[5,"sinf64","","Returns the sine of an `f64`.",null,null],[5,"cosf32","","Returns the cosine of an `f32`.",null,null],[5,"cosf64","","Returns the cosine of an `f64`.",null,null],[5,"powf32","","Raises an `f32` to an `f32` power.",null,null],[5,"powf64","","Raises an `f64` to an `f64` power.",null,null],[5,"expf32","","Returns the exponential of an `f32`.",null,null],[5,"expf64","","Returns the exponential of an `f64`.",null,null],[5,"exp2f32","","Returns 2 raised to the power of an `f32`.",null,null],[5,"exp2f64","","Returns 2 raised to the power of an `f64`.",null,null],[5,"logf32","","Returns the natural logarithm of an `f32`.",null,null],[5,"logf64","","Returns the natural logarithm of an `f64`.",null,null],[5,"log10f32","","Returns the base 10 logarithm of an `f32`.",null,null],[5,"log10f64","","Returns the base 10 logarithm of an `f64`.",null,null],[5,"log2f32","","Returns the base 2 logarithm of an `f32`.",null,null],[5,"log2f64","","Returns the base 2 logarithm of an `f64`.",null,null],[5,"fmaf32","","Returns `a * b + c` for `f32` values.",null,null],[5,"fmaf64","","Returns `a * b + c` for `f64` values.",null,null],[5,"fabsf32","","Returns the absolute value of an `f32`.",null,null],[5,"fabsf64","","Returns the absolute value of an `f64`.",null,null],[5,"minnumf32","","Returns the minimum of two `f32` values.",null,null],[5,"minnumf64","","Returns the minimum of two `f64` values.",null,null],[5,"maxnumf32","","Returns the maximum of two `f32` values.",null,null],[5,"maxnumf64","","Returns the maximum of two `f64` values.",null,null],[5,"copysignf32","","Copies the sign from `y` to `x` for `f32` values.",null,null],[5,"copysignf64","","Copies the sign from `y` to `x` for `f64` values.",null,null],[5,"floorf32","","Returns the largest integer less than or equal to an `f32`.",null,null],[5,"floorf64","","Returns the largest integer less than or equal to an `f64`.",null,null],[5,"ceilf32","","Returns the smallest integer greater than or equal to an…",null,null],[5,"ceilf64","","Returns the smallest integer greater than or equal to an…",null,null],[5,"truncf32","","Returns the integer part of an `f32`.",null,null],[5,"truncf64","","Returns the integer part of an `f64`.",null,null],[5,"rintf32","","Returns the nearest integer to an `f32`. May raise an…",null,null],[5,"rintf64","","Returns the nearest integer to an `f64`. May raise an…",null,null],[5,"nearbyintf32","","Returns the nearest integer to an `f32`.",null,null],[5,"nearbyintf64","","Returns the nearest integer to an `f64`.",null,null],[5,"roundf32","","Returns the nearest integer to an `f32`. Rounds half-way…",null,null],[5,"roundf64","","Returns the nearest integer to an `f64`. Rounds half-way…",null,null],[5,"fadd_fast","","Float addition that allows optimizations based on…",null,null],[5,"fsub_fast","","Float subtraction that allows optimizations based on…",null,null],[5,"fmul_fast","","Float multiplication that allows optimizations based on…",null,null],[5,"fdiv_fast","","Float division that allows optimizations based on…",null,null],[5,"frem_fast","","Float remainder that allows optimizations based on…",null,null],[5,"float_to_int_approx_unchecked","","Convert with LLVM’s fptoui/fptosi, which may return undef…",null,null],[5,"ctpop","","Returns the number of bits set in an integer type `T`",null,null],[5,"ctlz","","Returns the number of leading unset bits (zeroes) in an…",null,null],[5,"ctlz_nonzero","","Like `ctlz`, but extra-unsafe as it returns `undef` when…",null,null],[5,"cttz","","Returns the number of trailing unset bits (zeroes) in an…",null,null],[5,"cttz_nonzero","","Like `cttz`, but extra-unsafe as it returns `undef` when…",null,null],[5,"bswap","","Reverses the bytes in an integer type `T`.",null,null],[5,"bitreverse","","Reverses the bits in an integer type `T`.",null,null],[5,"add_with_overflow","","Performs checked integer addition.",null,null],[5,"sub_with_overflow","","Performs checked integer subtraction",null,null],[5,"mul_with_overflow","","Performs checked integer multiplication",null,null],[5,"exact_div","","Performs an exact division, resulting in undefined…",null,null],[5,"unchecked_div","","Performs an unchecked division, resulting in undefined…",null,null],[5,"unchecked_rem","","Returns the remainder of an unchecked division, resulting…",null,null],[5,"unchecked_shl","","Performs an unchecked left shift, resulting in undefined…",null,null],[5,"unchecked_shr","","Performs an unchecked right shift, resulting in undefined…",null,null],[5,"unchecked_add","","Returns the result of an unchecked addition, resulting in…",null,null],[5,"unchecked_sub","","Returns the result of an unchecked subtraction, resulting…",null,null],[5,"unchecked_mul","","Returns the result of an unchecked multiplication,…",null,null],[5,"rotate_left","","Performs rotate left.",null,null],[5,"rotate_right","","Performs rotate right.",null,null],[5,"wrapping_add","","Returns (a + b) mod 2N, where N is the width of T in bits.",null,null],[5,"wrapping_sub","","Returns (a - b) mod 2N, where N is the width of T in bits.",null,null],[5,"wrapping_mul","","Returns (a * b) mod 2N, where N is the width of T in bits.",null,null],[5,"saturating_add","","Computes `a + b`, while saturating at numeric bounds.",null,null],[5,"saturating_sub","","Computes `a - b`, while saturating at numeric bounds.",null,null],[5,"discriminant_value","","Returns the value of the discriminant for the variant in…",null,null],[5,"try","","Rust's \"try catch\" construct which invokes the function…",null,null],[5,"nontemporal_store","","Emits a `!nontemporal` store according to LLVM (see their…",null,null],[5,"ptr_offset_from","","See documentation of `<*const T>::offset_from` for details.",null,null],[5,"miri_start_panic","","Internal hook used by Miri to implement unwinding.…",null,null],[0,"mem","core","Basic functions for dealing with memory.",null,null],[3,"ManuallyDrop","core::mem","A wrapper to inhibit compiler from automatically calling…",null,null],[3,"Discriminant","","Opaque type representing the discriminant of an enum.",null,null],[19,"MaybeUninit","","A wrapper type to construct uninitialized instances of `T`.",null,null],[5,"forget","","Takes ownership and \"forgets\" about the value without…",null,[[["t"]]]],[5,"forget_unsized","","Like [`forget`], but also accepts unsized values.",null,[[["sized"]]]],[5,"size_of","","Returns the size of a type in bytes.",null,[[],["usize"]]],[5,"size_of_val","","Returns the size of the pointed-to value in bytes.",null,[[["t"]],["usize"]]],[5,"min_align_of","","Returns the [ABI]-required minimum alignment of a type.",null,[[],["usize"]]],[5,"min_align_of_val","","Returns the [ABI]-required minimum alignment of the type…",null,[[["t"]],["usize"]]],[5,"align_of","","Returns the [ABI]-required minimum alignment of a type.",null,[[],["usize"]]],[5,"align_of_val","","Returns the [ABI]-required minimum alignment of the type…",null,[[["t"]],["usize"]]],[5,"needs_drop","","Returns `true` if dropping values of type `T` matters.",null,[[],["bool"]]],[5,"zeroed","","Returns the value of type `T` represented by the all-zero…",null,[[],["t"]]],[5,"uninitialized","","Bypasses Rust's normal memory-initialization checks by…",null,[[],["t"]]],[5,"swap","","Swaps the values at two mutable locations, without…",null,[[["t"]]]],[5,"take","","Replaces `dest` with the default value of `T`, returning…",null,[[["t"]],["default"]]],[5,"replace","","Moves `src` into the referenced `dest`, returning the…",null,[[["t"],["t"]],["t"]]],[5,"drop","","Disposes of a value.",null,[[["t"]]]],[5,"transmute_copy","","Interprets `src` as having type `&U`, and then reads `src`…",null,[[["t"]],["u"]]],[5,"discriminant","","Returns a value uniquely identifying the enum variant in…",null,[[["t"]],["discriminant"]]],[5,"transmute","","Reinterprets the bits of a value of one type as another…",null,null],[11,"new","","Wrap a value to be manually dropped.",16,[[["t"]],["manuallydrop"]]],[11,"into_inner","","Extracts the value from the `ManuallyDrop` container.",16,[[["manuallydrop"]],["t"]]],[11,"take","","Takes the value from the `ManuallyDrop<T>` container out.",16,[[["manuallydrop"]],["t"]]],[11,"drop","","Manually drops the contained value.",16,[[["manuallydrop"]]]],[11,"new","","Creates a new `MaybeUninit<T>` initialized with the given…",17,[[["t"]],["maybeuninit"]]],[11,"uninit","","Creates a new `MaybeUninit<T>` in an uninitialized state.",17,[[],["maybeuninit"]]],[11,"uninit_array","","Create a new array of `MaybeUninit<T>` items, in an…",17,[[]]],[18,"UNINIT","","A promotable constant, equivalent to `uninit()`.",17,null],[11,"zeroed","","Creates a new `MaybeUninit<T>` in an uninitialized state,…",17,[[],["maybeuninit"]]],[11,"write","","Sets the value of the `MaybeUninit<T>`. This overwrites…",17,[[["self"],["t"]],["t"]]],[11,"as_ptr","","Gets a pointer to the contained value. Reading from this…",17,[[["self"]]]],[11,"as_mut_ptr","","Gets a mutable pointer to the contained value. Reading…",17,[[["self"]]]],[11,"assume_init","","Extracts the value from the `MaybeUninit<T>` container.…",17,[[],["t"]]],[11,"read","","Reads the value from the `MaybeUninit<T>` container. The…",17,[[["self"]],["t"]]],[11,"get_ref","","Gets a shared reference to the contained value.",17,[[["self"]],["t"]]],[11,"get_mut","","Gets a mutable (unique) reference to the contained value.",17,[[["self"]],["t"]]],[11,"slice_get_ref","","Assuming all the elements are initialized, get a slice to…",17,[[]]],[11,"slice_get_mut","","Assuming all the elements are initialized, get a mutable…",17,[[]]],[11,"first_ptr","","Gets a pointer to the first element of the array.",17,[[]]],[11,"first_ptr_mut","","Gets a mutable pointer to the first element of the array.",17,[[]]],[0,"ptr","core","Manually manage memory through raw pointers.",null,null],[3,"NonNull","core::ptr","`*mut T` but non-zero and covariant.",null,null],[5,"drop_in_place","","Executes the destructor (if any) of the pointed-to value.",null,[[]]],[5,"null","","Creates a null raw pointer.",null,[[]]],[5,"null_mut","","Creates a null mutable raw pointer.",null,[[]]],[5,"slice_from_raw_parts","","Forms a raw slice from a pointer and a length.",null,[[["usize"]]]],[5,"slice_from_raw_parts_mut","","Performs the same functionality as…",null,[[["usize"]]]],[5,"swap","","Swaps the values at two mutable locations of the same…",null,[[]]],[5,"swap_nonoverlapping","","Swaps `count * size_of::<T>()` bytes between the two…",null,[[["usize"]]]],[5,"replace","","Moves `src` into the pointed `dst`, returning the previous…",null,[[["t"]],["t"]]],[5,"read","","Reads the value from `src` without moving it. This leaves…",null,[[],["t"]]],[5,"read_unaligned","","Reads the value from `src` without moving it. This leaves…",null,[[],["t"]]],[5,"write","","Overwrites a memory location with the given value without…",null,[[["t"]]]],[5,"write_unaligned","","Overwrites a memory location with the given value without…",null,[[["t"]]]],[5,"read_volatile","","Performs a volatile read of the value from `src` without…",null,[[],["t"]]],[5,"write_volatile","","Performs a volatile write of a memory location with the…",null,[[["t"]]]],[5,"eq","","Compares raw pointers for equality.",null,[[],["bool"]]],[5,"hash","","Hash a raw pointer.",null,[[["s"]]]],[11,"dangling","","Creates a new `NonNull` that is dangling, but well-aligned.",18,[[],["self"]]],[11,"new_unchecked","","Creates a new `NonNull`.",18,[[],["self"]]],[11,"new","","Creates a new `NonNull` if `ptr` is non-null.",18,[[],["option"]]],[11,"as_ptr","","Acquires the underlying `*mut` pointer.",18,[[]]],[11,"as_ref","","Dereferences the content.",18,[[["self"]],["t"]]],[11,"as_mut","","Mutably dereferences the content.",18,[[["self"]],["t"]]],[11,"cast","","Casts to a pointer of another type.",18,[[],["nonnull"]]],[0,"borrow","core","A module for working with borrowed data.",null,null],[8,"Borrow","core::borrow","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",19,[[["self"]],["borrowed"]]],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",20,[[["self"]],["borrowed"]]],[0,"clone","core","The `Clone` trait for types that cannot be 'implicitly…",null,null],[8,"Clone","core::clone","A common trait for the ability to explicitly duplicate an…",null,null],[10,"clone","","Returns a copy of the value.",21,[[["self"]],["self"]]],[11,"clone_from","","Performs copy-assignment from `source`.",21,[[["self"],["self"]]]],[0,"cmp","core","Functionality for ordering and comparison.",null,null],[3,"Reverse","core::cmp","A helper struct for reverse ordering.",null,null],[12,"0","","",22,null],[4,"Ordering","","An `Ordering` is the result of a comparison between two…",null,null],[13,"Less","","An ordering where a compared value is less than another.",23,null],[13,"Equal","","An ordering where a compared value is equal to another.",23,null],[13,"Greater","","An ordering where a compared value is greater than another.",23,null],[5,"min","","Compares and returns the minimum of two values.",null,[[["ord"]],["ord"]]],[5,"min_by","","Returns the minimum of two values with respect to the…",null,[[["fnonce"],["t"]],["t"]]],[5,"min_by_key","","Returns the element that gives the minimum value from the…",null,[[["fnmut"],["t"]],["t"]]],[5,"max","","Compares and returns the maximum of two values.",null,[[["ord"]],["ord"]]],[5,"max_by","","Returns the maximum of two values with respect to the…",null,[[["fnonce"],["t"]],["t"]]],[5,"max_by_key","","Returns the element that gives the maximum value from the…",null,[[["fnmut"],["t"]],["t"]]],[8,"PartialEq","","Trait for equality comparisons which are partial…",null,null],[10,"eq","","This method tests for `self` and `other` values to be…",24,[[["rhs"],["self"]],["bool"]]],[11,"ne","","This method tests for `!=`.",24,[[["rhs"],["self"]],["bool"]]],[8,"Eq","","Trait for equality comparisons which are equivalence…",null,null],[8,"Ord","","Trait for types that form a total order.",null,null],[10,"cmp","","This method returns an [`Ordering`] between `self` and…",25,[[["self"]],["ordering"]]],[11,"max","","Compares and returns the maximum of two values.",25,[[],["self"]]],[11,"min","","Compares and returns the minimum of two values.",25,[[],["self"]]],[11,"clamp","","Restrict a value to a certain interval.",25,[[],["self"]]],[8,"PartialOrd","","Trait for values that can be compared for a sort-order.",null,null],[10,"partial_cmp","","This method returns an ordering between `self` and `other`…",26,[[["rhs"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","This method tests less than (for `self` and `other`) and…",26,[[["rhs"],["self"]],["bool"]]],[11,"le","","This method tests less than or equal to (for `self` and…",26,[[["rhs"],["self"]],["bool"]]],[11,"gt","","This method tests greater than (for `self` and `other`)…",26,[[["rhs"],["self"]],["bool"]]],[11,"ge","","This method tests greater than or equal to (for `self` and…",26,[[["rhs"],["self"]],["bool"]]],[11,"reverse","","Reverses the `Ordering`.",23,[[],["ordering"]]],[11,"then","","Chains two orderings.",23,[[["ordering"]],["ordering"]]],[11,"then_with","","Chains the ordering with the given function.",23,[[["fnonce"]],["ordering"]]],[0,"convert","core","Traits for conversions between types.",null,null],[4,"Infallible","core::convert","The error type for errors that can never happen.",null,null],[5,"identity","","The identity function.",null,[[["t"]],["t"]]],[8,"FloatToInt","","Supporting trait for inherent methods of `f32` and `f64`…",null,null],[8,"AsRef","","Used to do a cheap reference-to-reference conversion.",null,null],[10,"as_ref","","Performs the conversion.",27,[[["self"]],["t"]]],[8,"AsMut","","Used to do a cheap mutable-to-mutable reference conversion.",null,null],[10,"as_mut","","Performs the conversion.",28,[[["self"]],["t"]]],[8,"Into","","A value-to-value conversion that consumes the input value.…",null,null],[10,"into","","Performs the conversion.",29,[[],["t"]]],[8,"From","","Used to do value-to-value conversions while consuming the…",null,null],[10,"from","","Performs the conversion.",30,[[["t"]],["self"]]],[8,"TryInto","","An attempted conversion that consumes `self`, which may or…",null,null],[16,"Error","","The type returned in the event of a conversion error.",31,null],[10,"try_into","","Performs the conversion.",31,[[],["result"]]],[8,"TryFrom","","Simple and safe type conversions that may fail in a…",null,null],[16,"Error","","The type returned in the event of a conversion error.",32,null],[10,"try_from","","Performs the conversion.",32,[[["t"]],["result"]]],[0,"default","core","The `Default` trait for types which may have meaningful…",null,null],[8,"Default","core::default","A trait for giving a type a useful default value.",null,null],[10,"default","","Returns the \"default value\" for a type.",33,[[],["self"]]],[0,"marker","core","Primitive traits and types representing basic properties…",null,null],[3,"PhantomData","core::marker","Zero-sized type used to mark things that \"act like\" they…",null,null],[3,"PhantomPinned","","A marker type which does not implement `Unpin`.",null,null],[8,"Send","","Types that can be transferred across thread boundaries.",null,null],[8,"Sized","","Types with a constant size known at compile time.",null,null],[8,"Unsize","","Types that can be \"unsized\" to a dynamically-sized type.",null,null],[8,"StructuralPartialEq","","Required trait for constants used in pattern matches.",null,null],[8,"StructuralEq","","Required trait for constants used in pattern matches.",null,null],[8,"Copy","","Types whose values can be duplicated simply by copying bits.",null,null],[8,"Sync","","Types for which it is safe to share references between…",null,null],[8,"Unpin","","Types that can be safely moved after being pinned.",null,null],[0,"ops","core","Overloadable operators.",null,null],[3,"Range","core::ops","A (half-open) range bounded inclusively below and…",null,null],[12,"start","","The lower bound of the range (inclusive).",34,null],[12,"end","","The upper bound of the range (exclusive).",34,null],[3,"RangeFrom","","A range only bounded inclusively below (`start..`).",null,null],[12,"start","","The lower bound of the range (inclusive).",35,null],[3,"RangeFull","","An unbounded range (`..`).",null,null],[3,"RangeTo","","A range only bounded exclusively above (`..end`).",null,null],[12,"end","","The upper bound of the range (exclusive).",36,null],[3,"RangeInclusive","","A range bounded inclusively below and above (`start..=end`).",null,null],[3,"RangeToInclusive","","A range only bounded inclusively above (`..=end`).",null,null],[12,"end","","The upper bound of the range (inclusive)",37,null],[4,"Bound","","An endpoint of a range of keys.",null,null],[13,"Included","","An inclusive bound.",38,null],[13,"Excluded","","An exclusive bound.",38,null],[13,"Unbounded","","An infinite endpoint. Indicates that there is no bound in…",38,null],[4,"GeneratorState","","The result of a generator resumption.",null,null],[13,"Yielded","","The generator suspended with a value.",39,null],[13,"Complete","","The generator completed with a return value.",39,null],[11,"contains","","Returns `true` if `item` is contained in the range.",34,[[["u"],["self"]],["bool"]]],[11,"is_empty","","Returns `true` if the range contains no items.",34,[[["self"]],["bool"]]],[11,"contains","","Returns `true` if `item` is contained in the range.",35,[[["u"],["self"]],["bool"]]],[11,"contains","","Returns `true` if `item` is contained in the range.",36,[[["u"],["self"]],["bool"]]],[11,"new","","Creates a new inclusive range. Equivalent to writing…",40,[[["idx"]],["self"]]],[11,"start","","Returns the lower bound of the range (inclusive).",40,[[["self"]],["idx"]]],[11,"end","","Returns the upper bound of the range (inclusive).",40,[[["self"]],["idx"]]],[11,"into_inner","","Destructures the `RangeInclusive` into (lower bound, upper…",40,[[]]],[11,"contains","","Returns `true` if `item` is contained in the range.",40,[[["u"],["self"]],["bool"]]],[11,"is_empty","","Returns `true` if the range contains no items.",40,[[["self"]],["bool"]]],[11,"contains","","Returns `true` if `item` is contained in the range.",37,[[["u"],["self"]],["bool"]]],[11,"cloned","","Map a `Bound<&T>` to a `Bound<T>` by cloning the contents…",38,[[],["bound"]]],[8,"Add","","The addition operator `+`.",null,null],[16,"Output","","The resulting type after applying the `+` operator.",41,null],[10,"add","","Performs the `+` operation.",41,[[["rhs"]]]],[8,"Div","","The division operator `/`.",null,null],[16,"Output","","The resulting type after applying the `/` operator.",42,null],[10,"div","","Performs the `/` operation.",42,[[["rhs"]]]],[8,"Mul","","The multiplication operator `*`.",null,null],[16,"Output","","The resulting type after applying the `*` operator.",43,null],[10,"mul","","Performs the `*` operation.",43,[[["rhs"]]]],[8,"Neg","","The unary negation operator `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator.",44,null],[10,"neg","","Performs the unary `-` operation.",44,[[]]],[8,"Rem","","The remainder operator `%`.",null,null],[16,"Output","","The resulting type after applying the `%` operator.",45,null],[10,"rem","","Performs the `%` operation.",45,[[["rhs"]]]],[8,"Sub","","The subtraction operator `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator.",46,null],[10,"sub","","Performs the `-` operation.",46,[[["rhs"]]]],[8,"AddAssign","","The addition assignment operator `+=`.",null,null],[10,"add_assign","","Performs the `+=` operation.",47,[[["self"],["rhs"]]]],[8,"DivAssign","","The division assignment operator `/=`.",null,null],[10,"div_assign","","Performs the `/=` operation.",48,[[["self"],["rhs"]]]],[8,"MulAssign","","The multiplication assignment operator `*=`.",null,null],[10,"mul_assign","","Performs the `*=` operation.",49,[[["self"],["rhs"]]]],[8,"RemAssign","","The remainder assignment operator `%=`.",null,null],[10,"rem_assign","","Performs the `%=` operation.",50,[[["self"],["rhs"]]]],[8,"SubAssign","","The subtraction assignment operator `-=`.",null,null],[10,"sub_assign","","Performs the `-=` operation.",51,[[["self"],["rhs"]]]],[8,"BitAnd","","The bitwise AND operator `&`.",null,null],[16,"Output","","The resulting type after applying the `&` operator.",52,null],[10,"bitand","","Performs the `&` operation.",52,[[["rhs"]]]],[8,"BitOr","","The bitwise OR operator `|`.",null,null],[16,"Output","","The resulting type after applying the `|` operator.",53,null],[10,"bitor","","Performs the `|` operation.",53,[[["rhs"]]]],[8,"BitXor","","The bitwise XOR operator `^`.",null,null],[16,"Output","","The resulting type after applying the `^` operator.",54,null],[10,"bitxor","","Performs the `^` operation.",54,[[["rhs"]]]],[8,"Not","","The unary logical negation operator `!`.",null,null],[16,"Output","","The resulting type after applying the `!` operator.",55,null],[10,"not","","Performs the unary `!` operation.",55,[[]]],[8,"Shl","","The left shift operator `<<`. Note that because this trait…",null,null],[16,"Output","","The resulting type after applying the `<<` operator.",56,null],[10,"shl","","Performs the `<<` operation.",56,[[["rhs"]]]],[8,"Shr","","The right shift operator `>>`. Note that because this…",null,null],[16,"Output","","The resulting type after applying the `>>` operator.",57,null],[10,"shr","","Performs the `>>` operation.",57,[[["rhs"]]]],[8,"BitAndAssign","","The bitwise AND assignment operator `&=`.",null,null],[10,"bitand_assign","","Performs the `&=` operation.",58,[[["self"],["rhs"]]]],[8,"BitOrAssign","","The bitwise OR assignment operator `|=`.",null,null],[10,"bitor_assign","","Performs the `|=` operation.",59,[[["self"],["rhs"]]]],[8,"BitXorAssign","","The bitwise XOR assignment operator `^=`.",null,null],[10,"bitxor_assign","","Performs the `^=` operation.",60,[[["self"],["rhs"]]]],[8,"ShlAssign","","The left shift assignment operator `<<=`.",null,null],[10,"shl_assign","","Performs the `<<=` operation.",61,[[["self"],["rhs"]]]],[8,"ShrAssign","","The right shift assignment operator `>>=`.",null,null],[10,"shr_assign","","Performs the `>>=` operation.",62,[[["self"],["rhs"]]]],[8,"Deref","","Used for immutable dereferencing operations, like `*v`.",null,null],[16,"Target","","The resulting type after dereferencing.",63,null],[10,"deref","","Dereferences the value.",63,[[["self"]]]],[8,"DerefMut","","Used for mutable dereferencing operations, like in `*v =…",null,null],[10,"deref_mut","","Mutably dereferences the value.",64,[[["self"]]]],[8,"Drop","","Used to run some code when a value goes out of scope. This…",null,null],[10,"drop","","Executes the destructor for this type.",65,[[["self"]]]],[8,"Fn","","The version of the call operator that takes an immutable…",null,null],[10,"call","","Performs the call operation.",66,[[["args"],["self"]]]],[8,"FnMut","","The version of the call operator that takes a mutable…",null,null],[10,"call_mut","","Performs the call operation.",67,[[["self"],["args"]]]],[8,"FnOnce","","The version of the call operator that takes a by-value…",null,null],[16,"Output","","The returned type after the call operator is used.",68,null],[10,"call_once","","Performs the call operation.",68,[[["args"]]]],[8,"Index","","Used for indexing operations (`container[index]`) in…",null,null],[16,"Output","","The returned type after indexing.",69,null],[10,"index","","Performs the indexing (`container[index]`) operation.",69,[[["idx"],["self"]]]],[8,"IndexMut","","Used for indexing operations (`container[index]`) in…",null,null],[10,"index_mut","","Performs the mutable indexing (`container[index]`)…",70,[[["self"],["idx"]]]],[8,"RangeBounds","","`RangeBounds` is implemented by Rust's built-in range…",null,null],[10,"start_bound","","Start index bound.",71,[[["self"]],[["t"],["bound"]]]],[10,"end_bound","","End index bound.",71,[[["self"]],[["t"],["bound"]]]],[11,"contains","","Returns `true` if `item` is contained in the range.",71,[[["u"],["self"]],["bool"]]],[8,"Try","","A trait for customizing the behavior of the `?` operator.",null,null],[16,"Ok","","The type of this value when viewed as successful.",72,null],[16,"Error","","The type of this value when viewed as failed.",72,null],[10,"into_result","","Applies the \"?\" operator. A return of `Ok(t)` means that…",72,[[],["result"]]],[10,"from_error","","Wrap an error value to construct the composite result. For…",72,[[],["self"]]],[10,"from_ok","","Wrap an OK value to construct the composite result. For…",72,[[],["self"]]],[8,"Generator","","The trait implemented by builtin generator types.",null,null],[16,"Yield","","The type of value this generator yields.",73,null],[16,"Return","","The type of value this generator returns.",73,null],[10,"resume","","Resumes the execution of this generator.",73,[[["r"],["self"],["pin"]],["generatorstate"]]],[8,"CoerceUnsized","","Trait that indicates that this is a pointer or a wrapper…",null,null],[8,"DispatchFromDyn","","This is used for object safety, to check that a method's…",null,null],[0,"any","core","This module implements the `Any` trait, which enables…",null,null],[3,"TypeId","core::any","A `TypeId` represents a globally unique identifier for a…",null,null],[5,"type_name","","Returns the name of a type as a string slice.",null,[[],["str"]]],[5,"type_name_of_val","","Returns the name of the type of the pointed-to value as a…",null,[[["t"]],["str"]]],[8,"Any","","A trait to emulate dynamic typing.",null,null],[10,"type_id","","Gets the `TypeId` of `self`.",74,[[["self"]],["typeid"]]],[11,"is","","Returns `true` if the boxed type is the same as `T`.",74,[[["self"]],["bool"]]],[11,"downcast_ref","","Returns some reference to the boxed value if it is of type…",74,[[["self"]],[["t"],["option"]]]],[11,"downcast_mut","","Returns some mutable reference to the boxed value if it is…",74,[[["self"]],[["option"],["t"]]]],[11,"is","","Forwards to the method defined on the type `Any`.",74,[[["self"]],["bool"]]],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",74,[[["self"]],[["t"],["option"]]]],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",74,[[["self"]],[["option"],["t"]]]],[11,"is","","Forwards to the method defined on the type `Any`.",74,[[["self"]],["bool"]]],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",74,[[["self"]],[["t"],["option"]]]],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",74,[[["self"]],[["option"],["t"]]]],[11,"of","","Returns the `TypeId` of the type this generic function has…",75,[[],["typeid"]]],[0,"array","core","Implementations of things like `Eq` for fixed-length…",null,null],[3,"IntoIter","core::array","A by-value [array] iterator.",null,null],[3,"TryFromSliceError","","The error type returned when a conversion from a slice to…",null,null],[11,"new","","Creates a new iterator over the given `array`.",76,[[],["self"]]],[8,"FixedSizeArray","","Utility trait implemented only on arrays of fixed size",null,null],[10,"as_slice","","Converts the array to immutable slice",77,[[["self"]]]],[10,"as_mut_slice","","Converts the array to mutable slice",77,[[["self"]]]],[8,"LengthAtMost32","","Implemented for lengths where trait impls are allowed on…",null,null],[0,"ascii","core","Operations on ASCII strings and characters.",null,null],[3,"EscapeDefault","core::ascii","An iterator over the escaped version of a byte.",null,null],[5,"escape_default","","Returns an iterator that produces an escaped version of a…",null,[[["u8"]],["escapedefault"]]],[0,"cell","core","Shareable mutable containers.",null,null],[3,"Cell","core::cell","A mutable memory location.",null,null],[3,"RefCell","","A mutable memory location with dynamically checked borrow…",null,null],[3,"BorrowError","","An error returned by `RefCell::try_borrow`.",null,null],[3,"BorrowMutError","","An error returned by `RefCell::try_borrow_mut`.",null,null],[3,"Ref","","Wraps a borrowed reference to a value in a `RefCell` box.…",null,null],[3,"RefMut","","A wrapper type for a mutably borrowed value from a…",null,null],[3,"UnsafeCell","","The core primitive for interior mutability in Rust.",null,null],[11,"new","","Creates a new `Cell` containing the given value.",78,[[["t"]],["cell"]]],[11,"set","","Sets the contained value.",78,[[["t"],["self"]]]],[11,"swap","","Swaps the values of two Cells. Difference with…",78,[[["self"]]]],[11,"replace","","Replaces the contained value, and returns it.",78,[[["t"],["self"]],["t"]]],[11,"into_inner","","Unwraps the value.",78,[[],["t"]]],[11,"get","","Returns a copy of the contained value.",78,[[["self"]],["t"]]],[11,"update","","Updates the contained value using a function and returns…",78,[[["f"],["self"]],["t"]]],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",78,[[["self"]]]],[11,"get_mut","","Returns a mutable reference to the underlying data.",78,[[["self"]],["t"]]],[11,"from_mut","","Returns a `&Cell<T>` from a `&mut T`",78,[[["t"]],["cell"]]],[11,"take","","Takes the value of the cell, leaving `Default::default()`…",78,[[["self"]],["t"]]],[11,"as_slice_of_cells","","Returns a `&[Cell<T>]` from a `&Cell<[T]>`",78,[[["self"]]]],[11,"new","","Creates a new `RefCell` containing `value`.",79,[[["t"]],["refcell"]]],[11,"into_inner","","Consumes the `RefCell`, returning the wrapped value.",79,[[],["t"]]],[11,"replace","","Replaces the wrapped value with a new one, returning the…",79,[[["t"],["self"]],["t"]]],[11,"replace_with","","Replaces the wrapped value with a new one computed from…",79,[[["fnonce"],["self"]],["t"]]],[11,"swap","","Swaps the wrapped value of `self` with the wrapped value…",79,[[["self"]]]],[11,"borrow","","Immutably borrows the wrapped value.",79,[[["self"]],["ref"]]],[11,"try_borrow","","Immutably borrows the wrapped value, returning an error if…",79,[[["self"]],[["ref"],["result",["ref","borrowerror"]],["borrowerror"]]]],[11,"borrow_mut","","Mutably borrows the wrapped value.",79,[[["self"]],["refmut"]]],[11,"try_borrow_mut","","Mutably borrows the wrapped value, returning an error if…",79,[[["self"]],[["refmut"],["borrowmuterror"],["result",["refmut","borrowmuterror"]]]]],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",79,[[["self"]]]],[11,"get_mut","","Returns a mutable reference to the underlying data.",79,[[["self"]],["t"]]],[11,"try_borrow_unguarded","","Immutably borrows the wrapped value, returning an error if…",79,[[["self"]],[["t"],["borrowerror"],["result",["borrowerror"]]]]],[11,"clone","","Copies a `Ref`.",80,[[["ref"]],["ref"]]],[11,"map","","Makes a new `Ref` for a component of the borrowed data.",80,[[["ref"],["f"]],[["sized"],["ref"]]]],[11,"map_split","","Splits a `Ref` into multiple `Ref`s for different…",80,[[["ref"],["f"]]]],[11,"leak","","Convert into a reference to the underlying data.",80,[[["ref"]],["t"]]],[11,"map","","Makes a new `RefMut` for a component of the borrowed data,…",81,[[["refmut"],["f"]],[["sized"],["refmut"]]]],[11,"map_split","","Splits a `RefMut` into multiple `RefMut`s for different…",81,[[["refmut"],["f"]]]],[11,"leak","","Convert into a mutable reference to the underlying data.",81,[[["refmut"]],["t"]]],[11,"new","","Constructs a new instance of `UnsafeCell` which will wrap…",82,[[["t"]],["unsafecell"]]],[11,"into_inner","","Unwraps the value.",82,[[],["t"]]],[11,"get","","Gets a mutable pointer to the wrapped value.",82,[[["self"]]]],[11,"raw_get","","Gets a mutable pointer to the wrapped value. The…",82,[[]]],[0,"char","core","A character type.",null,null],[3,"CharTryFromError","core::char","The error type returned when a conversion from u32 to char…",null,null],[3,"ParseCharError","","An error which can be returned when parsing a char.",null,null],[3,"DecodeUtf16","","An iterator that decodes UTF-16 encoded code points from…",null,null],[3,"DecodeUtf16Error","","An error that can be returned when decoding UTF-16 code…",null,null],[3,"UnicodeVersion","","Represents a Unicode Version.",null,null],[12,"major","","Major version.",83,null],[12,"minor","","Minor version.",83,null],[12,"micro","","Micro (or Update) version.",83,null],[3,"EscapeUnicode","","Returns an iterator that yields the hexadecimal Unicode…",null,null],[3,"EscapeDefault","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"EscapeDebug","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"ToLowercase","","Returns an iterator that yields the lowercase equivalent…",null,null],[3,"ToUppercase","","Returns an iterator that yields the uppercase equivalent…",null,null],[5,"from_u32_unchecked","","Converts a `u32` to a `char`, ignoring validity.",null,[[["u32"]],["char"]]],[5,"from_digit","","Converts a digit in the given radix to a `char`.",null,[[["u32"]],[["char"],["option",["char"]]]]],[5,"from_u32","","Converts a `u32` to a `char`.",null,[[["u32"]],[["char"],["option",["char"]]]]],[5,"decode_utf16","","Creates an iterator over the UTF-16 encoded code points in…",null,[[["intoiterator"]],["decodeutf16"]]],[11,"unpaired_surrogate","","Returns the unpaired surrogate which caused this error.",84,[[["self"]],["u16"]]],[17,"MAX","","The highest valid code point a `char` can have.",null,null],[17,"REPLACEMENT_CHARACTER","","`U+FFFD REPLACEMENT CHARACTER` (�) is used in Unicode to…",null,null],[0,"ffi","core","Utilities related to FFI bindings.",null,null],[3,"VaListImpl","core::ffi","Basic implementation of a `va_list`.",null,null],[3,"VaList","","A wrapper for a `va_list`",null,null],[4,"c_void","","Equivalent to C's `void` type when used as a [pointer].",null,null],[11,"as_va_list","","Convert a `VaListImpl` into a `VaList` that is…",85,[[["self"]],["valist"]]],[11,"arg","","Advance to the next arg.",85,[[["self"]],["vaargsafe"]]],[11,"with_copy","","Copies the `va_list` at the current location.",85,[[["f"],["self"]],["r"]]],[0,"iter","core","Composable external iteration.",null,null],[3,"Empty","core::iter","An iterator that yields nothing.",null,null],[3,"FromFn","","An iterator where each iteration calls the provided…",null,null],[3,"Once","","An iterator that yields an element exactly once.",null,null],[3,"OnceWith","","An iterator that yields a single element of type `A` by…",null,null],[3,"Repeat","","An iterator that repeats an element endlessly.",null,null],[3,"RepeatWith","","An iterator that repeats elements of type `A` endlessly by…",null,null],[3,"Successors","","An new iterator where each successive item is computed…",null,null],[3,"Cloned","","An iterator that clones the elements of an underlying…",null,null],[3,"Copied","","An iterator that copies the elements of an underlying…",null,null],[3,"Flatten","","An iterator that flattens one level of nesting in an…",null,null],[3,"MapWhile","","An iterator that only accepts elements while `predicate`…",null,null],[3,"StepBy","","An iterator for stepping iterators by a custom amount.",null,null],[3,"Chain","","An iterator that links two iterators together, in a chain.",null,null],[3,"Cycle","","An iterator that repeats endlessly.",null,null],[3,"Enumerate","","An iterator that yields the current count and the element…",null,null],[3,"Filter","","An iterator that filters the elements of `iter` with…",null,null],[3,"FilterMap","","An iterator that uses `f` to both filter and map elements…",null,null],[3,"Map","","An iterator that maps the values of `iter` with `f`.",null,null],[3,"Rev","","A double-ended iterator with the direction inverted.",null,null],[3,"Zip","","An iterator that iterates two other iterators…",null,null],[3,"FlatMap","","An iterator that maps each element to an iterator, and…",null,null],[3,"Peekable","","An iterator with a `peek()` that returns an optional…",null,null],[3,"Scan","","An iterator to maintain state while iterating another…",null,null],[3,"Skip","","An iterator that skips over `n` elements of `iter`.",null,null],[3,"SkipWhile","","An iterator that rejects elements while `predicate`…",null,null],[3,"Take","","An iterator that only iterates over the first `n`…",null,null],[3,"TakeWhile","","An iterator that only accepts elements while `predicate`…",null,null],[3,"Fuse","","An iterator that yields `None` forever after the…",null,null],[3,"Inspect","","An iterator that calls a function with a reference to each…",null,null],[5,"empty","","Creates an iterator that yields nothing.",null,[[],["empty"]]],[5,"from_fn","","Creates a new iterator where each iteration calls the…",null,[[["f"]],["fromfn"]]],[5,"once","","Creates an iterator that yields an element exactly once.",null,[[["t"]],["once"]]],[5,"once_with","","Creates an iterator that lazily generates a value exactly…",null,[[["fnonce"]],[["oncewith"],["fnonce"]]]],[5,"repeat","","Creates a new iterator that endlessly repeats a single…",null,[[["clone"]],[["repeat"],["clone"]]]],[5,"repeat_with","","Creates a new iterator that repeats elements of type `A`…",null,[[["fnmut"]],[["fnmut"],["repeatwith"]]]],[5,"successors","","Creates a new iterator where each successive item is…",null,[[["option"],["f"]],["successors"]]],[11,"peek","","Returns a reference to the next() value without advancing…",86,[[["self"]],["option"]]],[8,"Iterator","","An interface for dealing with iterators.",null,null],[16,"Item","","The type of the elements being iterated over.",87,null],[10,"next","","Advances the iterator and returns the next value.",87,[[["self"]],["option"]]],[11,"size_hint","","Returns the bounds on the remaining length of the iterator.",87,[[["self"]]]],[11,"count","","Consumes the iterator, counting the number of iterations…",87,[[],["usize"]]],[11,"last","","Consumes the iterator, returning the last element.",87,[[],["option"]]],[11,"nth","","Returns the `n`th element of the iterator.",87,[[["self"],["usize"]],["option"]]],[11,"step_by","","Creates an iterator starting at the same point, but…",87,[[["usize"]],["stepby"]]],[11,"chain","","Takes two iterators and creates a new iterator over both…",87,[[["u"]],["chain"]]],[11,"zip","","'Zips up' two iterators into a single iterator of pairs.",87,[[["u"]],["zip"]]],[11,"map","","Takes a closure and creates an iterator which calls that…",87,[[["f"]],["map"]]],[11,"for_each","","Calls a closure on each element of an iterator.",87,[[["f"]]]],[11,"filter","","Creates an iterator which uses a closure to determine if…",87,[[["p"]],["filter"]]],[11,"filter_map","","Creates an iterator that both filters and maps.",87,[[["f"]],["filtermap"]]],[11,"enumerate","","Creates an iterator which gives the current iteration…",87,[[],["enumerate"]]],[11,"peekable","","Creates an iterator which can use `peek` to look at the…",87,[[],["peekable"]]],[11,"skip_while","","Creates an iterator that [`skip`]s elements based on a…",87,[[["p"]],["skipwhile"]]],[11,"take_while","","Creates an iterator that yields elements based on a…",87,[[["p"]],["takewhile"]]],[11,"map_while","","Creates an iterator that both yields elements based on a…",87,[[["p"]],["mapwhile"]]],[11,"skip","","Creates an iterator that skips the first `n` elements.",87,[[["usize"]],["skip"]]],[11,"take","","Creates an iterator that yields its first `n` elements.",87,[[["usize"]],["take"]]],[11,"scan","","An iterator adaptor similar to [`fold`] that holds…",87,[[["f"],["st"]],["scan"]]],[11,"flat_map","","Creates an iterator that works like map, but flattens…",87,[[["f"]],["flatmap"]]],[11,"flatten","","Creates an iterator that flattens nested structure.",87,[[],["flatten"]]],[11,"fuse","","Creates an iterator which ends after the first [`None`].",87,[[],["fuse"]]],[11,"inspect","","Does something with each element of an iterator, passing…",87,[[["f"]],["inspect"]]],[11,"by_ref","","Borrows an iterator, rather than consuming it.",87,[[["self"]],["self"]]],[11,"collect","","Transforms an iterator into a collection.",87,[[],["fromiterator"]]],[11,"partition","","Consumes an iterator, creating two collections from it.",87,[[["f"]]]],[11,"partition_in_place","","Reorders the elements of this iterator in-place according…",87,[[["p"]],["usize"]]],[11,"is_partitioned","","Checks if the elements of this iterator are partitioned…",87,[[["p"]],["bool"]]],[11,"try_fold","","An iterator method that applies a function as long as it…",87,[[["self"],["b"],["f"]],["r"]]],[11,"try_for_each","","An iterator method that applies a fallible function to…",87,[[["self"],["f"]],["r"]]],[11,"fold","","An iterator method that applies a function, producing a…",87,[[["b"],["f"]],["b"]]],[11,"all","","Tests if every element of the iterator matches a predicate.",87,[[["self"],["f"]],["bool"]]],[11,"any","","Tests if any element of the iterator matches a predicate.",87,[[["self"],["f"]],["bool"]]],[11,"find","","Searches for an element of an iterator that satisfies a…",87,[[["self"],["p"]],["option"]]],[11,"find_map","","Applies function to the elements of iterator and returns…",87,[[["self"],["f"]],["option"]]],[11,"try_find","","Applies function to the elements of iterator and returns…",87,[[["self"],["f"]],[["result",["option"]],["option"]]]],[11,"position","","Searches for an element in an iterator, returning its index.",87,[[["self"],["p"]],[["option",["usize"]],["usize"]]]],[11,"rposition","","Searches for an element in an iterator from the right,…",87,[[["self"],["p"]],[["option",["usize"]],["usize"]]]],[11,"max","","Returns the maximum element of an iterator.",87,[[],["option"]]],[11,"min","","Returns the minimum element of an iterator.",87,[[],["option"]]],[11,"max_by_key","","Returns the element that gives the maximum value from the…",87,[[["f"]],["option"]]],[11,"max_by","","Returns the element that gives the maximum value with…",87,[[["f"]],["option"]]],[11,"min_by_key","","Returns the element that gives the minimum value from the…",87,[[["f"]],["option"]]],[11,"min_by","","Returns the element that gives the minimum value with…",87,[[["f"]],["option"]]],[11,"rev","","Reverses an iterator's direction.",87,[[],["rev"]]],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",87,[[]]],[11,"copied","","Creates an iterator which copies all of its elements.",87,[[],["copied"]]],[11,"cloned","","Creates an iterator which [`clone`]s all of its elements.",87,[[],["cloned"]]],[11,"cycle","","Repeats an iterator endlessly.",87,[[],["cycle"]]],[11,"sum","","Sums the elements of an iterator.",87,[[],["s"]]],[11,"product","","Iterates over the entire iterator, multiplying all the…",87,[[],["p"]]],[11,"cmp","","Lexicographically compares the elements of this `Iterator`…",87,[[["i"]],["ordering"]]],[11,"cmp_by","","Lexicographically compares the elements of this `Iterator`…",87,[[["i"],["f"]],["ordering"]]],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator`…",87,[[["i"]],[["option",["ordering"]],["ordering"]]]],[11,"partial_cmp_by","","Lexicographically compares the elements of this `Iterator`…",87,[[["i"],["f"]],[["option",["ordering"]],["ordering"]]]],[11,"eq","","Determines if the elements of this `Iterator` are equal to…",87,[[["i"]],["bool"]]],[11,"eq_by","","Determines if the elements of this `Iterator` are equal to…",87,[[["i"],["f"]],["bool"]]],[11,"ne","","Determines if the elements of this `Iterator` are unequal…",87,[[["i"]],["bool"]]],[11,"lt","","Determines if the elements of this `Iterator` are…",87,[[["i"]],["bool"]]],[11,"le","","Determines if the elements of this `Iterator` are…",87,[[["i"]],["bool"]]],[11,"gt","","Determines if the elements of this `Iterator` are…",87,[[["i"]],["bool"]]],[11,"ge","","Determines if the elements of this `Iterator` are…",87,[[["i"]],["bool"]]],[11,"is_sorted","","Checks if the elements of this iterator are sorted.",87,[[],["bool"]]],[11,"is_sorted_by","","Checks if the elements of this iterator are sorted using…",87,[[["f"]],["bool"]]],[11,"is_sorted_by_key","","Checks if the elements of this iterator are sorted using…",87,[[["f"]],["bool"]]],[8,"Step","","Objects that can be stepped over in both directions.",null,null],[10,"steps_between","","Returns the number of steps between two step objects. The…",88,[[["self"]],[["option",["usize"]],["usize"]]]],[10,"replace_one","","Replaces this step with `1`, returning a clone of itself.",88,[[["self"]],["self"]]],[10,"replace_zero","","Replaces this step with `0`, returning a clone of itself.",88,[[["self"]],["self"]]],[10,"add_one","","Adds one to this step, returning the result.",88,[[["self"]],["self"]]],[10,"sub_one","","Subtracts one to this step, returning the result.",88,[[["self"]],["self"]]],[10,"add_usize","","Adds a `usize`, returning `None` on overflow.",88,[[["usize"],["self"]],["option"]]],[11,"sub_usize","","Subtracts a `usize`, returning `None` on underflow.",88,[[["usize"],["self"]],["option"]]],[8,"FusedIterator","","An iterator that always continues to yield `None` when…",null,null],[8,"TrustedLen","","An iterator that reports an accurate length using size_hint.",null,null],[8,"DoubleEndedIterator","","An iterator able to yield elements from both ends.",null,null],[10,"next_back","","Removes and returns an element from the end of the iterator.",89,[[["self"]],["option"]]],[11,"nth_back","","Returns the `n`th element from the end of the iterator.",89,[[["self"],["usize"]],["option"]]],[11,"try_rfold","","This is the reverse version of [`try_fold()`]: it takes…",89,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","An iterator method that reduces the iterator's elements to…",89,[[["b"],["f"]],["b"]]],[11,"rfind","","Searches for an element of an iterator from the back that…",89,[[["self"],["p"]],["option"]]],[8,"Extend","","Extend a collection with the contents of an iterator.",null,null],[10,"extend","","Extends a collection with the contents of an iterator.",90,[[["intoiterator"],["self"]]]],[8,"FromIterator","","Conversion from an `Iterator`.",null,null],[10,"from_iter","","Creates a value from an iterator.",91,[[["intoiterator"]],["self"]]],[8,"IntoIterator","","Conversion into an `Iterator`.",null,null],[16,"Item","","The type of the elements being iterated over.",92,null],[16,"IntoIter","","Which kind of iterator are we turning this into?",92,null],[10,"into_iter","","Creates an iterator from a value.",92,[[]]],[8,"ExactSizeIterator","","An iterator that knows its exact length.",null,null],[11,"len","","Returns the exact length of the iterator.",93,[[["self"]],["usize"]]],[11,"is_empty","","Returns `true` if the iterator is empty.",93,[[["self"]],["bool"]]],[8,"Product","","Trait to represent types that can be created by…",null,null],[10,"product","","Method which takes an iterator and generates `Self` from…",94,[[["iterator"]],["self"]]],[8,"Sum","","Trait to represent types that can be created by summing up…",null,null],[10,"sum","","Method which takes an iterator and generates `Self` from…",95,[[["iterator"]],["self"]]],[0,"option","core","Optional values.",null,null],[3,"Iter","core::option","An iterator over a reference to the [`Some`] variant of an…",null,null],[3,"IterMut","","An iterator over a mutable reference to the [`Some`]…",null,null],[3,"IntoIter","","An iterator over the value in [`Some`] variant of an…",null,null],[3,"NoneError","","The error type that results from applying the try operator…",null,null],[4,"Option","","The `Option` type. See the module level documentation for…",null,null],[13,"None","","No value",96,null],[13,"Some","","Some value `T`",96,null],[11,"is_some","","Returns `true` if the option is a [`Some`] value.",96,[[["self"]],["bool"]]],[11,"is_none","","Returns `true` if the option is a [`None`] value.",96,[[["self"]],["bool"]]],[11,"contains","","Returns `true` if the option is a [`Some`] value…",96,[[["u"],["self"]],["bool"]]],[11,"as_ref","","Converts from `&Option<T>` to `Option<&T>`.",96,[[["self"]],[["t"],["option"]]]],[11,"as_mut","","Converts from `&mut Option<T>` to `Option<&mut T>`.",96,[[["self"]],[["option"],["t"]]]],[11,"as_pin_ref","","Converts from [`Pin`]`<&Option<T>>` to…",96,[[["pin"],["self"]],[["option",["pin"]],["pin"]]]],[11,"as_pin_mut","","Converts from [`Pin`]`<&mut Option<T>>` to…",96,[[["self"],["pin"]],[["option",["pin"]],["pin"]]]],[11,"expect","","Returns the contained [`Some`] value, consuming the `self`…",96,[[["str"]],["t"]]],[11,"unwrap","","Returns the contained [`Some`] value, consuming the `self`…",96,[[],["t"]]],[11,"unwrap_or","","Returns the contained [`Some`] value or a provided default.",96,[[["t"]],["t"]]],[11,"unwrap_or_else","","Returns the contained [`Some`] value or computes it from a…",96,[[["fnonce"]],["t"]]],[11,"map","","Maps an `Option<T>` to `Option<U>` by applying a function…",96,[[["fnonce"]],["option"]]],[11,"map_or","","Applies a function to the contained value (if any), or…",96,[[["u"],["fnonce"]],["u"]]],[11,"map_or_else","","Applies a function to the contained value (if any), or…",96,[[["fnonce"],["fnonce"]],["u"]]],[11,"ok_or","","Transforms the `Option<T>` into a [`Result<T, E>`],…",96,[[["e"]],["result"]]],[11,"ok_or_else","","Transforms the `Option<T>` into a [`Result<T, E>`],…",96,[[["fnonce"]],["result"]]],[11,"iter","","Returns an iterator over the possibly contained value.",96,[[["self"]],["iter"]]],[11,"iter_mut","","Returns a mutable iterator over the possibly contained…",96,[[["self"]],["itermut"]]],[11,"and","","Returns [`None`] if the option is [`None`], otherwise…",96,[[["option"]],["option"]]],[11,"and_then","","Returns [`None`] if the option is [`None`], otherwise…",96,[[["fnonce"]],["option"]]],[11,"filter","","Returns [`None`] if the option is [`None`], otherwise…",96,[[["fnonce"]],["self"]]],[11,"or","","Returns the option if it contains a value, otherwise…",96,[[["option"]],["option"]]],[11,"or_else","","Returns the option if it contains a value, otherwise calls…",96,[[["fnonce"]],["option"]]],[11,"xor","","Returns [`Some`] if exactly one of `self`, `optb` is…",96,[[["option"]],["option"]]],[11,"get_or_insert","","Inserts `v` into the option if it is [`None`], then…",96,[[["self"],["t"]],["t"]]],[11,"get_or_insert_with","","Inserts a value computed from `f` into the option if it is…",96,[[["self"],["fnonce"]],["t"]]],[11,"take","","Takes the value out of the option, leaving a [`None`] in…",96,[[["self"]],["option"]]],[11,"replace","","Replaces the actual value in the option by the value given…",96,[[["self"],["t"]],["option"]]],[11,"copied","","Maps an `Option<&T>` to an `Option<T>` by copying the…",96,[[],["option"]]],[11,"copied","","Maps an `Option<&mut T>` to an `Option<T>` by copying the…",96,[[],["option"]]],[11,"cloned","","Maps an `Option<&T>` to an `Option<T>` by cloning the…",96,[[],["option"]]],[11,"cloned","","Maps an `Option<&mut T>` to an `Option<T>` by cloning the…",96,[[],["option"]]],[11,"expect_none","","Consumes `self` while expecting [`None`] and returning…",96,[[["str"]]]],[11,"unwrap_none","","Consumes `self` while expecting [`None`] and returning…",96,[[]]],[11,"unwrap_or_default","","Returns the contained [`Some`] value or a default",96,[[],["t"]]],[11,"as_deref","","Converts from `Option<T>` (or `&Option<T>`) to…",96,[[["self"]],["option"]]],[11,"as_deref_mut","","Converts from `Option<T>` (or `&mut Option<T>`) to…",96,[[["self"]],["option"]]],[11,"transpose","","Transposes an `Option` of a [`Result`] into a [`Result`]…",96,[[],[["option"],["result",["option"]]]]],[11,"flatten","","Converts from `Option<Option<T>>` to `Option<T>`",96,[[],["option"]]],[0,"panic","core","Panic support in the standard library.",null,null],[3,"PanicInfo","core::panic","A struct providing information about a panic.",null,null],[3,"Location","","A struct containing information about the location of a…",null,null],[11,"payload","","Returns the payload associated with the panic.",97,[[["self"]],["any"]]],[11,"message","","If the `panic!` macro from the `core` crate (not from…",97,[[["self"]],[["arguments"],["option",["arguments"]]]]],[11,"location","","Returns information about the location from which the…",97,[[["self"]],[["option",["location"]],["location"]]]],[11,"caller","","Returns the source location of the caller of this…",98,[[],["location"]]],[11,"file","","Returns the name of the source file from which the panic…",98,[[["self"]],["str"]]],[11,"line","","Returns the line number from which the panic originated.",98,[[["self"]],["u32"]]],[11,"column","","Returns the column from which the panic originated.",98,[[["self"]],["u32"]]],[0,"panicking","core","Panic support for libcore",null,null],[5,"panic","core::panicking","",null,[[["str"]]]],[5,"panic_fmt","","",null,[[["arguments"],["location"]]]],[0,"pin","core","Types that pin data to its location in memory.",null,null],[3,"Pin","core::pin","A pinned pointer.",null,null],[11,"new","","Construct a new `Pin<P>` around a pointer to some data of…",99,[[["p"]],["pin"]]],[11,"into_inner","","Unwraps this `Pin<P>` returning the underlying pointer.",99,[[["pin"]],["p"]]],[11,"new_unchecked","","Construct a new `Pin<P>` around a reference to some data…",99,[[["p"]],["pin"]]],[11,"as_ref","","Gets a pinned shared reference from this pinned pointer.",99,[[["self"]],["pin"]]],[11,"into_inner_unchecked","","Unwraps this `Pin<P>` returning the underlying pointer.",99,[[["pin"]],["p"]]],[11,"as_mut","","Gets a pinned mutable reference from this pinned pointer.",99,[[["self"]],["pin"]]],[11,"set","","Assigns a new value to the memory behind the pinned…",99,[[["self"]]]],[11,"map_unchecked","","Constructs a new pin by mapping the interior value.",99,[[["f"]],[["u"],["pin"]]]],[11,"get_ref","","Gets a shared reference out of a pin.",99,[[],["t"]]],[11,"into_ref","","Converts this `Pin<&mut T>` into a `Pin<&T>` with the same…",99,[[],[["t"],["pin"]]]],[11,"get_mut","","Gets a mutable reference to the data inside of this `Pin`.",99,[[],["t"]]],[11,"get_unchecked_mut","","Gets a mutable reference to the data inside of this `Pin`.",99,[[],["t"]]],[11,"map_unchecked_mut","","Construct a new pin by mapping the interior value.",99,[[["f"]],[["u"],["pin"]]]],[0,"raw","core","Contains struct definitions for the layout of compiler…",null,null],[3,"TraitObject","core::raw","The representation of a trait object like `&SomeTrait`.",null,null],[12,"data","","",100,null],[12,"vtable","","",100,null],[0,"result","core","Error handling with the `Result` type.",null,null],[3,"Iter","core::result","An iterator over a reference to the [`Ok`] variant of a…",null,null],[3,"IterMut","","An iterator over a mutable reference to the [`Ok`] variant…",null,null],[3,"IntoIter","","An iterator over the value in a [`Ok`] variant of a…",null,null],[4,"Result","","`Result` is a type that represents either success ([`Ok`])…",null,null],[13,"Ok","","Contains the success value",101,null],[13,"Err","","Contains the error value",101,null],[11,"is_ok","","Returns `true` if the result is [`Ok`].",101,[[["self"]],["bool"]]],[11,"is_err","","Returns `true` if the result is [`Err`].",101,[[["self"]],["bool"]]],[11,"contains","","Returns `true` if the result is an [`Ok`] value containing…",101,[[["u"],["self"]],["bool"]]],[11,"contains_err","","Returns `true` if the result is an [`Err`] value…",101,[[["f"],["self"]],["bool"]]],[11,"ok","","Converts from `Result<T, E>` to [`Option<T>`].",101,[[],["option"]]],[11,"err","","Converts from `Result<T, E>` to [`Option<E>`].",101,[[],["option"]]],[11,"as_ref","","Converts from `&Result<T, E>` to `Result<&T, &E>`.",101,[[["self"]],[["result"],["t"],["e"]]]],[11,"as_mut","","Converts from `&mut Result<T, E>` to `Result<&mut T, &mut…",101,[[["self"]],[["result"],["t"],["e"]]]],[11,"map","","Maps a `Result<T, E>` to `Result<U, E>` by applying a…",101,[[["fnonce"]],["result"]]],[11,"map_or","","Applies a function to the contained value (if any), or…",101,[[["u"],["fnonce"]],["u"]]],[11,"map_or_else","","Maps a `Result<T, E>` to `U` by applying a function to a…",101,[[["fnonce"],["fnonce"]],["u"]]],[11,"map_err","","Maps a `Result<T, E>` to `Result<T, F>` by applying a…",101,[[["fnonce"]],["result"]]],[11,"iter","","Returns an iterator over the possibly contained value.",101,[[["self"]],["iter"]]],[11,"iter_mut","","Returns a mutable iterator over the possibly contained…",101,[[["self"]],["itermut"]]],[11,"and","","Returns `res` if the result is [`Ok`], otherwise returns…",101,[[["result"]],["result"]]],[11,"and_then","","Calls `op` if the result is [`Ok`], otherwise returns the…",101,[[["fnonce"]],["result"]]],[11,"or","","Returns `res` if the result is [`Err`], otherwise returns…",101,[[["result"]],["result"]]],[11,"or_else","","Calls `op` if the result is [`Err`], otherwise returns the…",101,[[["fnonce"]],["result"]]],[11,"unwrap_or","","Returns the contained [`Ok`] value or a provided default.",101,[[["t"]],["t"]]],[11,"unwrap_or_else","","Returns the contained [`Ok`] value or computes it from a…",101,[[["fnonce"]],["t"]]],[11,"copied","","Maps a `Result<&T, E>` to a `Result<T, E>` by copying the…",101,[[],["result"]]],[11,"copied","","Maps a `Result<&mut T, E>` to a `Result<T, E>` by copying…",101,[[],["result"]]],[11,"cloned","","Maps a `Result<&T, E>` to a `Result<T, E>` by cloning the…",101,[[],["result"]]],[11,"cloned","","Maps a `Result<&mut T, E>` to a `Result<T, E>` by cloning…",101,[[],["result"]]],[11,"expect","","Returns the contained [`Ok`] value, consuming the `self`…",101,[[["str"]],["t"]]],[11,"unwrap","","Returns the contained [`Ok`] value, consuming the `self`…",101,[[],["t"]]],[11,"expect_err","","Returns the contained [`Err`] value, consuming the `self`…",101,[[["str"]],["e"]]],[11,"unwrap_err","","Returns the contained [`Err`] value, consuming the `self`…",101,[[],["e"]]],[11,"unwrap_or_default","","Returns the contained [`Ok`] value or a default",101,[[],["t"]]],[11,"into_ok","","Returns the contained [`Ok`] value, but never panics.",101,[[],["t"]]],[11,"as_deref","","Converts from `Result<T, E>` (or `&Result<T, E>`) to…",101,[[["self"]],[["result"],["e"]]]],[11,"as_deref_err","","Converts from `Result<T, E>` (or `&Result<T, E>`) to…",101,[[["self"]],[["result"],["t"]]]],[11,"as_deref_mut","","Converts from `Result<T, E>` (or `&mut Result<T, E>`) to…",101,[[["self"]],[["e"],["result"]]]],[11,"as_deref_mut_err","","Converts from `Result<T, E>` (or `&mut Result<T, E>`) to…",101,[[["self"]],[["t"],["result"]]]],[11,"transpose","","Transposes a `Result` of an `Option` into an `Option` of a…",101,[[],[["result"],["option",["result"]]]]],[0,"sync","core","Synchronization primitives",null,null],[0,"atomic","core::sync","Atomic types",null,null],[3,"AtomicBool","core::sync::atomic","A boolean type which can be safely shared between threads.",null,null],[3,"AtomicPtr","","A raw pointer type which can be safely shared between…",null,null],[3,"AtomicI8","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU8","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI16","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU16","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI32","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU32","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI64","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU64","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicIsize","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicUsize","","An integer type which can be safely shared between threads.",null,null],[4,"Ordering","","Atomic memory orderings",null,null],[13,"Relaxed","","No ordering constraints, only atomic operations.",102,null],[13,"Release","","When coupled with a store, all previous operations become…",102,null],[13,"Acquire","","When coupled with a load, if the loaded value was written…",102,null],[13,"AcqRel","","Has the effects of both [`Acquire`] and [`Release`]…",102,null],[13,"SeqCst","","Like [`Acquire`]/[`Release`]/[`AcqRel`] (for load, store,…",102,null],[5,"spin_loop_hint","","Signals the processor that it is inside a busy-wait…",null,[[]]],[5,"fence","","An atomic fence.",null,[[["ordering"]]]],[5,"compiler_fence","","A compiler memory fence.",null,[[["ordering"]]]],[17,"ATOMIC_BOOL_INIT","","An [`AtomicBool`] initialized to `false`.",null,null],[17,"ATOMIC_I8_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U8_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I16_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U16_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I32_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U32_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I64_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U64_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_ISIZE_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_USIZE_INIT","","An atomic integer initialized to `0`.",null,null],[11,"new","","Creates a new `AtomicBool`.",103,[[["bool"]],["atomicbool"]]],[11,"get_mut","","Returns a mutable reference to the underlying [`bool`].",103,[[["self"]],["bool"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",103,[[],["bool"]]],[11,"load","","Loads a value from the bool.",103,[[["ordering"],["self"]],["bool"]]],[11,"store","","Stores a value into the bool.",103,[[["bool"],["ordering"],["self"]]]],[11,"swap","","Stores a value into the bool, returning the previous value.",103,[[["bool"],["ordering"],["self"]],["bool"]]],[11,"compare_and_swap","","Stores a value into the [`bool`] if the current value is…",103,[[["bool"],["ordering"],["self"]],["bool"]]],[11,"compare_exchange","","Stores a value into the [`bool`] if the current value is…",103,[[["ordering"],["self"],["bool"]],[["bool"],["result",["bool","bool"]]]]],[11,"compare_exchange_weak","","Stores a value into the [`bool`] if the current value is…",103,[[["ordering"],["self"],["bool"]],[["bool"],["result",["bool","bool"]]]]],[11,"fetch_and","","Logical \"and\" with a boolean value.",103,[[["bool"],["ordering"],["self"]],["bool"]]],[11,"fetch_nand","","Logical \"nand\" with a boolean value.",103,[[["bool"],["ordering"],["self"]],["bool"]]],[11,"fetch_or","","Logical \"or\" with a boolean value.",103,[[["bool"],["ordering"],["self"]],["bool"]]],[11,"fetch_xor","","Logical \"xor\" with a boolean value.",103,[[["bool"],["ordering"],["self"]],["bool"]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying [`bool`].",103,[[["self"]]]],[11,"new","","Creates a new `AtomicPtr`.",104,[[],["atomicptr"]]],[11,"get_mut","","Returns a mutable reference to the underlying pointer.",104,[[["self"]]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",104,[[]]],[11,"load","","Loads a value from the pointer.",104,[[["ordering"],["self"]]]],[11,"store","","Stores a value into the pointer.",104,[[["ordering"],["self"]]]],[11,"swap","","Stores a value into the pointer, returning the previous…",104,[[["ordering"],["self"]]]],[11,"compare_and_swap","","Stores a value into the pointer if the current value is…",104,[[["ordering"],["self"]]]],[11,"compare_exchange","","Stores a value into the pointer if the current value is…",104,[[["ordering"],["self"]],["result"]]],[11,"compare_exchange_weak","","Stores a value into the pointer if the current value is…",104,[[["ordering"],["self"]],["result"]]],[11,"new","","Creates a new atomic integer.",105,[[["i8"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",105,[[["self"]],["i8"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",105,[[],["i8"]]],[11,"load","","Loads a value from the atomic integer.",105,[[["ordering"],["self"]],["i8"]]],[11,"store","","Stores a value into the atomic integer.",105,[[["i8"],["ordering"],["self"]]]],[11,"swap","","Stores a value into the atomic integer, returning the…",105,[[["i8"],["ordering"],["self"]],["i8"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current…",105,[[["i8"],["ordering"],["self"]],["i8"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current…",105,[[["i8"],["ordering"],["self"]],[["i8"],["result",["i8","i8"]]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current…",105,[[["i8"],["ordering"],["self"]],[["i8"],["result",["i8","i8"]]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",105,[[["i8"],["ordering"],["self"]],["i8"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous…",105,[[["i8"],["ordering"],["self"]],["i8"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",105,[[["i8"],["ordering"],["self"]],["i8"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",105,[[["i8"],["ordering"],["self"]],["i8"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",105,[[["i8"],["ordering"],["self"]],["i8"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",105,[[["i8"],["ordering"],["self"]],["i8"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that…",105,[[["ordering"],["self"],["f"]],[["i8"],["result",["i8","i8"]]]]],[11,"fetch_max","","Maximum with the current value.",105,[[["i8"],["ordering"],["self"]],["i8"]]],[11,"fetch_min","","Minimum with the current value.",105,[[["i8"],["ordering"],["self"]],["i8"]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",105,[[["self"]]]],[11,"new","","Creates a new atomic integer.",106,[[["u8"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",106,[[["self"]],["u8"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",106,[[],["u8"]]],[11,"load","","Loads a value from the atomic integer.",106,[[["ordering"],["self"]],["u8"]]],[11,"store","","Stores a value into the atomic integer.",106,[[["u8"],["ordering"],["self"]]]],[11,"swap","","Stores a value into the atomic integer, returning the…",106,[[["u8"],["ordering"],["self"]],["u8"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current…",106,[[["u8"],["ordering"],["self"]],["u8"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current…",106,[[["ordering"],["self"],["u8"]],[["result",["u8","u8"]],["u8"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current…",106,[[["ordering"],["self"],["u8"]],[["result",["u8","u8"]],["u8"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",106,[[["u8"],["ordering"],["self"]],["u8"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous…",106,[[["u8"],["ordering"],["self"]],["u8"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",106,[[["u8"],["ordering"],["self"]],["u8"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",106,[[["u8"],["ordering"],["self"]],["u8"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",106,[[["u8"],["ordering"],["self"]],["u8"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",106,[[["u8"],["ordering"],["self"]],["u8"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that…",106,[[["ordering"],["self"],["f"]],[["result",["u8","u8"]],["u8"]]]],[11,"fetch_max","","Maximum with the current value.",106,[[["u8"],["ordering"],["self"]],["u8"]]],[11,"fetch_min","","Minimum with the current value.",106,[[["u8"],["ordering"],["self"]],["u8"]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",106,[[["self"]]]],[11,"new","","Creates a new atomic integer.",107,[[["i16"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",107,[[["self"]],["i16"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",107,[[],["i16"]]],[11,"load","","Loads a value from the atomic integer.",107,[[["ordering"],["self"]],["i16"]]],[11,"store","","Stores a value into the atomic integer.",107,[[["ordering"],["i16"],["self"]]]],[11,"swap","","Stores a value into the atomic integer, returning the…",107,[[["ordering"],["i16"],["self"]],["i16"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current…",107,[[["ordering"],["i16"],["self"]],["i16"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current…",107,[[["ordering"],["self"],["i16"]],[["result",["i16","i16"]],["i16"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current…",107,[[["ordering"],["self"],["i16"]],[["result",["i16","i16"]],["i16"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",107,[[["ordering"],["i16"],["self"]],["i16"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous…",107,[[["ordering"],["i16"],["self"]],["i16"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",107,[[["ordering"],["i16"],["self"]],["i16"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",107,[[["ordering"],["i16"],["self"]],["i16"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",107,[[["ordering"],["i16"],["self"]],["i16"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",107,[[["ordering"],["i16"],["self"]],["i16"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that…",107,[[["ordering"],["self"],["f"]],[["result",["i16","i16"]],["i16"]]]],[11,"fetch_max","","Maximum with the current value.",107,[[["ordering"],["i16"],["self"]],["i16"]]],[11,"fetch_min","","Minimum with the current value.",107,[[["ordering"],["i16"],["self"]],["i16"]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",107,[[["self"]]]],[11,"new","","Creates a new atomic integer.",108,[[["u16"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",108,[[["self"]],["u16"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",108,[[],["u16"]]],[11,"load","","Loads a value from the atomic integer.",108,[[["ordering"],["self"]],["u16"]]],[11,"store","","Stores a value into the atomic integer.",108,[[["u16"],["ordering"],["self"]]]],[11,"swap","","Stores a value into the atomic integer, returning the…",108,[[["u16"],["ordering"],["self"]],["u16"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current…",108,[[["u16"],["ordering"],["self"]],["u16"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current…",108,[[["ordering"],["self"],["u16"]],[["u16"],["result",["u16","u16"]]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current…",108,[[["ordering"],["self"],["u16"]],[["u16"],["result",["u16","u16"]]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",108,[[["u16"],["ordering"],["self"]],["u16"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous…",108,[[["u16"],["ordering"],["self"]],["u16"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",108,[[["u16"],["ordering"],["self"]],["u16"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",108,[[["u16"],["ordering"],["self"]],["u16"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",108,[[["u16"],["ordering"],["self"]],["u16"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",108,[[["u16"],["ordering"],["self"]],["u16"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that…",108,[[["ordering"],["self"],["f"]],[["u16"],["result",["u16","u16"]]]]],[11,"fetch_max","","Maximum with the current value.",108,[[["u16"],["ordering"],["self"]],["u16"]]],[11,"fetch_min","","Minimum with the current value.",108,[[["u16"],["ordering"],["self"]],["u16"]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",108,[[["self"]]]],[11,"new","","Creates a new atomic integer.",109,[[["i32"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",109,[[["self"]],["i32"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",109,[[],["i32"]]],[11,"load","","Loads a value from the atomic integer.",109,[[["ordering"],["self"]],["i32"]]],[11,"store","","Stores a value into the atomic integer.",109,[[["i32"],["ordering"],["self"]]]],[11,"swap","","Stores a value into the atomic integer, returning the…",109,[[["i32"],["ordering"],["self"]],["i32"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current…",109,[[["i32"],["ordering"],["self"]],["i32"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current…",109,[[["ordering"],["i32"],["self"]],[["result",["i32","i32"]],["i32"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current…",109,[[["ordering"],["i32"],["self"]],[["result",["i32","i32"]],["i32"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",109,[[["i32"],["ordering"],["self"]],["i32"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous…",109,[[["i32"],["ordering"],["self"]],["i32"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",109,[[["i32"],["ordering"],["self"]],["i32"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",109,[[["i32"],["ordering"],["self"]],["i32"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",109,[[["i32"],["ordering"],["self"]],["i32"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",109,[[["i32"],["ordering"],["self"]],["i32"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that…",109,[[["ordering"],["self"],["f"]],[["result",["i32","i32"]],["i32"]]]],[11,"fetch_max","","Maximum with the current value.",109,[[["i32"],["ordering"],["self"]],["i32"]]],[11,"fetch_min","","Minimum with the current value.",109,[[["i32"],["ordering"],["self"]],["i32"]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",109,[[["self"]]]],[11,"new","","Creates a new atomic integer.",110,[[["u32"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",110,[[["self"]],["u32"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",110,[[],["u32"]]],[11,"load","","Loads a value from the atomic integer.",110,[[["ordering"],["self"]],["u32"]]],[11,"store","","Stores a value into the atomic integer.",110,[[["u32"],["ordering"],["self"]]]],[11,"swap","","Stores a value into the atomic integer, returning the…",110,[[["u32"],["ordering"],["self"]],["u32"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current…",110,[[["u32"],["ordering"],["self"]],["u32"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current…",110,[[["u32"],["ordering"],["self"]],[["result",["u32","u32"]],["u32"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current…",110,[[["u32"],["ordering"],["self"]],[["result",["u32","u32"]],["u32"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",110,[[["u32"],["ordering"],["self"]],["u32"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous…",110,[[["u32"],["ordering"],["self"]],["u32"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",110,[[["u32"],["ordering"],["self"]],["u32"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",110,[[["u32"],["ordering"],["self"]],["u32"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",110,[[["u32"],["ordering"],["self"]],["u32"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",110,[[["u32"],["ordering"],["self"]],["u32"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that…",110,[[["ordering"],["self"],["f"]],[["result",["u32","u32"]],["u32"]]]],[11,"fetch_max","","Maximum with the current value.",110,[[["u32"],["ordering"],["self"]],["u32"]]],[11,"fetch_min","","Minimum with the current value.",110,[[["u32"],["ordering"],["self"]],["u32"]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",110,[[["self"]]]],[11,"new","","Creates a new atomic integer.",111,[[["i64"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",111,[[["self"]],["i64"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",111,[[],["i64"]]],[11,"load","","Loads a value from the atomic integer.",111,[[["ordering"],["self"]],["i64"]]],[11,"store","","Stores a value into the atomic integer.",111,[[["i64"],["ordering"],["self"]]]],[11,"swap","","Stores a value into the atomic integer, returning the…",111,[[["i64"],["ordering"],["self"]],["i64"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current…",111,[[["i64"],["ordering"],["self"]],["i64"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current…",111,[[["i64"],["ordering"],["self"]],[["i64"],["result",["i64","i64"]]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current…",111,[[["i64"],["ordering"],["self"]],[["i64"],["result",["i64","i64"]]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",111,[[["i64"],["ordering"],["self"]],["i64"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous…",111,[[["i64"],["ordering"],["self"]],["i64"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",111,[[["i64"],["ordering"],["self"]],["i64"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",111,[[["i64"],["ordering"],["self"]],["i64"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",111,[[["i64"],["ordering"],["self"]],["i64"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",111,[[["i64"],["ordering"],["self"]],["i64"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that…",111,[[["ordering"],["self"],["f"]],[["i64"],["result",["i64","i64"]]]]],[11,"fetch_max","","Maximum with the current value.",111,[[["i64"],["ordering"],["self"]],["i64"]]],[11,"fetch_min","","Minimum with the current value.",111,[[["i64"],["ordering"],["self"]],["i64"]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",111,[[["self"]]]],[11,"new","","Creates a new atomic integer.",112,[[["u64"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",112,[[["self"]],["u64"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",112,[[],["u64"]]],[11,"load","","Loads a value from the atomic integer.",112,[[["ordering"],["self"]],["u64"]]],[11,"store","","Stores a value into the atomic integer.",112,[[["ordering"],["u64"],["self"]]]],[11,"swap","","Stores a value into the atomic integer, returning the…",112,[[["ordering"],["u64"],["self"]],["u64"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current…",112,[[["ordering"],["u64"],["self"]],["u64"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current…",112,[[["ordering"],["self"],["u64"]],[["result",["u64","u64"]],["u64"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current…",112,[[["ordering"],["self"],["u64"]],[["result",["u64","u64"]],["u64"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",112,[[["ordering"],["u64"],["self"]],["u64"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous…",112,[[["ordering"],["u64"],["self"]],["u64"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",112,[[["ordering"],["u64"],["self"]],["u64"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",112,[[["ordering"],["u64"],["self"]],["u64"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",112,[[["ordering"],["u64"],["self"]],["u64"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",112,[[["ordering"],["u64"],["self"]],["u64"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that…",112,[[["ordering"],["self"],["f"]],[["result",["u64","u64"]],["u64"]]]],[11,"fetch_max","","Maximum with the current value.",112,[[["ordering"],["u64"],["self"]],["u64"]]],[11,"fetch_min","","Minimum with the current value.",112,[[["ordering"],["u64"],["self"]],["u64"]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",112,[[["self"]]]],[11,"new","","Creates a new atomic integer.",113,[[["isize"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",113,[[["self"]],["isize"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",113,[[],["isize"]]],[11,"load","","Loads a value from the atomic integer.",113,[[["ordering"],["self"]],["isize"]]],[11,"store","","Stores a value into the atomic integer.",113,[[["isize"],["ordering"],["self"]]]],[11,"swap","","Stores a value into the atomic integer, returning the…",113,[[["isize"],["ordering"],["self"]],["isize"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current…",113,[[["isize"],["ordering"],["self"]],["isize"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current…",113,[[["ordering"],["self"],["isize"]],[["isize"],["result",["isize","isize"]]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current…",113,[[["ordering"],["self"],["isize"]],[["isize"],["result",["isize","isize"]]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",113,[[["isize"],["ordering"],["self"]],["isize"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous…",113,[[["isize"],["ordering"],["self"]],["isize"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",113,[[["isize"],["ordering"],["self"]],["isize"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",113,[[["isize"],["ordering"],["self"]],["isize"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",113,[[["isize"],["ordering"],["self"]],["isize"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",113,[[["isize"],["ordering"],["self"]],["isize"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that…",113,[[["ordering"],["self"],["f"]],[["isize"],["result",["isize","isize"]]]]],[11,"fetch_max","","Maximum with the current value.",113,[[["isize"],["ordering"],["self"]],["isize"]]],[11,"fetch_min","","Minimum with the current value.",113,[[["isize"],["ordering"],["self"]],["isize"]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",113,[[["self"]]]],[11,"new","","Creates a new atomic integer.",114,[[["usize"]],["self"]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",114,[[["self"]],["usize"]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",114,[[],["usize"]]],[11,"load","","Loads a value from the atomic integer.",114,[[["ordering"],["self"]],["usize"]]],[11,"store","","Stores a value into the atomic integer.",114,[[["ordering"],["usize"],["self"]]]],[11,"swap","","Stores a value into the atomic integer, returning the…",114,[[["ordering"],["usize"],["self"]],["usize"]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current…",114,[[["ordering"],["usize"],["self"]],["usize"]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current…",114,[[["ordering"],["usize"],["self"]],[["result",["usize","usize"]],["usize"]]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current…",114,[[["ordering"],["usize"],["self"]],[["result",["usize","usize"]],["usize"]]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",114,[[["ordering"],["usize"],["self"]],["usize"]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous…",114,[[["ordering"],["usize"],["self"]],["usize"]]],[11,"fetch_and","","Bitwise \"and\" with the current value.",114,[[["ordering"],["usize"],["self"]],["usize"]]],[11,"fetch_nand","","Bitwise \"nand\" with the current value.",114,[[["ordering"],["usize"],["self"]],["usize"]]],[11,"fetch_or","","Bitwise \"or\" with the current value.",114,[[["ordering"],["usize"],["self"]],["usize"]]],[11,"fetch_xor","","Bitwise \"xor\" with the current value.",114,[[["ordering"],["usize"],["self"]],["usize"]]],[11,"fetch_update","","Fetches the value, and applies a function to it that…",114,[[["ordering"],["self"],["f"]],[["result",["usize","usize"]],["usize"]]]],[11,"fetch_max","","Maximum with the current value.",114,[[["ordering"],["usize"],["self"]],["usize"]]],[11,"fetch_min","","Minimum with the current value.",114,[[["ordering"],["usize"],["self"]],["usize"]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",114,[[["self"]]]],[0,"fmt","core","Utilities for formatting and printing strings.",null,null],[3,"DebugList","core::fmt","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugStruct","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"Error","","The error type which is returned from formatting a message…",null,null],[3,"Formatter","","Configuration for formatting.",null,null],[3,"Arguments","","This structure represents a safely precompiled version of…",null,null],[4,"Alignment","","Possible alignments returned by `Formatter::align`",null,null],[13,"Left","","Indication that contents should be left-aligned.",115,null],[13,"Right","","Indication that contents should be right-aligned.",115,null],[13,"Center","","Indication that contents should be center-aligned.",115,null],[5,"write","","The `write` function takes an output stream, and an…",null,[[["write"],["arguments"]],["result"]]],[11,"field","","Adds a new field to the generated struct output.",116,[[["str"],["self"],["debug"]],["self"]]],[11,"finish_non_exhaustive","","Marks the struct as non-exhaustive, indicating to the…",116,[[["self"]],["result"]]],[11,"finish","","Finishes output and returns any error encountered.",116,[[["self"]],["result"]]],[11,"field","","Adds a new field to the generated tuple struct output.",117,[[["self"],["debug"]],["self"]]],[11,"finish","","Finishes output and returns any error encountered.",117,[[["self"]],["result"]]],[11,"entry","","Adds a new entry to the set output.",118,[[["self"],["debug"]],["self"]]],[11,"entries","","Adds the contents of an iterator of entries to the set…",118,[[["self"],["i"]],["self"]]],[11,"finish","","Finishes output and returns any error encountered.",118,[[["self"]],["result"]]],[11,"entry","","Adds a new entry to the list output.",119,[[["self"],["debug"]],["self"]]],[11,"entries","","Adds the contents of an iterator of entries to the list…",119,[[["self"],["i"]],["self"]]],[11,"finish","","Finishes output and returns any error encountered.",119,[[["self"]],["result"]]],[11,"entry","","Adds a new entry to the map output.",120,[[["self"],["debug"]],["self"]]],[11,"key","","Adds the key part of a new entry to the map output.",120,[[["self"],["debug"]],["self"]]],[11,"value","","Adds the value part of a new entry to the map output.",120,[[["self"],["debug"]],["self"]]],[11,"entries","","Adds the contents of an iterator of entries to the map…",120,[[["self"],["i"]],["self"]]],[11,"finish","","Finishes output and returns any error encountered.",120,[[["self"]],["result"]]],[6,"Result","","The type returned by formatter methods.",null,null],[8,"Write","","A collection of methods that are required to format a…",null,null],[10,"write_str","","Writes a string slice into this writer, returning whether…",121,[[["str"],["self"]],["result"]]],[11,"write_char","","Writes a [`char`] into this writer, returning whether the…",121,[[["self"],["char"]],["result"]]],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors…",121,[[["self"],["arguments"]],["result"]]],[8,"Debug","","`?` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",122,[[["formatter"],["self"]],["result"]]],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",123,[[["formatter"],["self"]],["result"]]],[8,"Octal","","`o` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",124,[[["formatter"],["self"]],["result"]]],[8,"Binary","","`b` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",125,[[["formatter"],["self"]],["result"]]],[8,"LowerHex","","`x` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",126,[[["formatter"],["self"]],["result"]]],[8,"UpperHex","","`X` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",127,[[["formatter"],["self"]],["result"]]],[8,"Pointer","","`p` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",128,[[["formatter"],["self"]],["result"]]],[8,"LowerExp","","`e` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",129,[[["formatter"],["self"]],["result"]]],[8,"UpperExp","","`E` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",130,[[["formatter"],["self"]],["result"]]],[11,"pad_integral","","Performs the correct padding for an integer which has…",131,[[["str"],["self"],["bool"]],["result"]]],[11,"pad","","This function takes a string slice and emits it to the…",131,[[["str"],["self"]],["result"]]],[11,"write_str","","Writes some data to the underlying buffer contained within…",131,[[["str"],["self"]],["result"]]],[11,"write_fmt","","Writes some formatted information into this instance.",131,[[["self"],["arguments"]],["result"]]],[11,"flags","","Flags for formatting",131,[[["self"]],["u32"]]],[11,"fill","","Character used as 'fill' whenever there is alignment.",131,[[["self"]],["char"]]],[11,"align","","Flag indicating what form of alignment was requested.",131,[[["self"]],[["option",["alignment"]],["alignment"]]]],[11,"width","","Optionally specified integer width that the output should…",131,[[["self"]],[["option",["usize"]],["usize"]]]],[11,"precision","","Optionally specified precision for numeric types.",131,[[["self"]],[["option",["usize"]],["usize"]]]],[11,"sign_plus","","Determines if the `+` flag was specified.",131,[[["self"]],["bool"]]],[11,"sign_minus","","Determines if the `-` flag was specified.",131,[[["self"]],["bool"]]],[11,"alternate","","Determines if the `#` flag was specified.",131,[[["self"]],["bool"]]],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",131,[[["self"]],["bool"]]],[11,"debug_struct","","Creates a [`DebugStruct`] builder designed to assist with…",131,[[["str"],["self"]],["debugstruct"]]],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with…",131,[[["str"],["self"]],["debugtuple"]]],[11,"debug_list","","Creates a `DebugList` builder designed to assist with…",131,[[["self"]],["debuglist"]]],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with…",131,[[["self"]],["debugset"]]],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with…",131,[[["self"]],["debugmap"]]],[14,"Debug","","Derive macro generating an impl of the trait `Debug`.",null,null],[0,"hash","core","Generic hashing support.",null,null],[3,"SipHasher","core::hash","An implementation of SipHash 2-4.",null,null],[3,"BuildHasherDefault","","Used to create a default [`BuildHasher`] instance for…",null,null],[11,"new","","Creates a new `SipHasher` with the two initial keys set to…",132,[[],["siphasher"]]],[11,"new_with_keys","","Creates a `SipHasher` that is keyed off the provided keys.",132,[[["u64"]],["siphasher"]]],[8,"Hash","","A hashable type.",null,null],[10,"hash","","Feeds this value into the given [`Hasher`].",133,[[["h"],["self"]]]],[11,"hash_slice","","Feeds a slice of this type into the given [`Hasher`].",133,[[["h"]]]],[8,"Hasher","","A trait for hashing an arbitrary stream of bytes.",null,null],[10,"finish","","Returns the hash value for the values written so far.",134,[[["self"]],["u64"]]],[10,"write","","Writes some data into this `Hasher`.",134,[[["self"]]]],[11,"write_u8","","Writes a single `u8` into this hasher.",134,[[["self"],["u8"]]]],[11,"write_u16","","Writes a single `u16` into this hasher.",134,[[["u16"],["self"]]]],[11,"write_u32","","Writes a single `u32` into this hasher.",134,[[["self"],["u32"]]]],[11,"write_u64","","Writes a single `u64` into this hasher.",134,[[["self"],["u64"]]]],[11,"write_u128","","Writes a single `u128` into this hasher.",134,[[["self"],["u128"]]]],[11,"write_usize","","Writes a single `usize` into this hasher.",134,[[["self"],["usize"]]]],[11,"write_i8","","Writes a single `i8` into this hasher.",134,[[["self"],["i8"]]]],[11,"write_i16","","Writes a single `i16` into this hasher.",134,[[["self"],["i16"]]]],[11,"write_i32","","Writes a single `i32` into this hasher.",134,[[["self"],["i32"]]]],[11,"write_i64","","Writes a single `i64` into this hasher.",134,[[["i64"],["self"]]]],[11,"write_i128","","Writes a single `i128` into this hasher.",134,[[["self"],["i128"]]]],[11,"write_isize","","Writes a single `isize` into this hasher.",134,[[["isize"],["self"]]]],[8,"BuildHasher","","A trait for creating instances of [`Hasher`].",null,null],[16,"Hasher","","Type of the hasher that will be created.",135,null],[10,"build_hasher","","Creates a new hasher.",135,[[["self"]]]],[14,"Hash","","Derive macro generating an impl of the trait `Hash`.",null,null],[0,"slice","core","Slice management and manipulation.",null,null],[3,"Iter","core::slice","Immutable slice iterator",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"Split","","An iterator over subslices separated by elements that…",null,null],[3,"SplitInclusive","","An iterator over subslices separated by elements that…",null,null],[3,"SplitMut","","An iterator over the mutable subslices of the vector which…",null,null],[3,"SplitInclusiveMut","","An iterator over the mutable subslices of the vector which…",null,null],[3,"RSplit","","An iterator over subslices separated by elements that…",null,null],[3,"RSplitMut","","An iterator over the subslices of the vector which are…",null,null],[3,"SplitN","","An iterator over subslices separated by elements that…",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that…",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that…",null,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that…",null,null],[3,"Windows","","An iterator over overlapping subslices of length `size`.",null,null],[3,"Chunks","","An iterator over a slice in (non-overlapping) chunks…",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable…",null,null],[3,"ChunksExact","","An iterator over a slice in (non-overlapping) chunks…",null,null],[3,"ChunksExactMut","","An iterator over a slice in (non-overlapping) mutable…",null,null],[3,"RChunks","","An iterator over a slice in (non-overlapping) chunks…",null,null],[3,"RChunksMut","","An iterator over a slice in (non-overlapping) mutable…",null,null],[3,"RChunksExact","","An iterator over a slice in (non-overlapping) chunks…",null,null],[3,"RChunksExactMut","","An iterator over a slice in (non-overlapping) mutable…",null,null],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,[[["usize"]]]],[5,"from_raw_parts_mut","","Performs the same functionality as [`from_raw_parts`],…",null,[[["usize"]]]],[5,"from_ref","","Converts a reference to T into a slice of length 1…",null,[[["t"]]]],[5,"from_mut","","Converts a reference to T into a slice of length 1…",null,[[["t"]]]],[0,"memchr","","Pure rust memchr implementation, taken from rust-memchr",null,null],[5,"memchr","core::slice::memchr","Returns the first index matching the byte `x` in `text`.",null,[[["u8"]],[["option",["usize"]],["usize"]]]],[5,"memrchr","","Returns the last index matching the byte `x` in `text`.",null,[[["u8"]],[["option",["usize"]],["usize"]]]],[8,"SliceIndex","core::slice","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",136,null],[10,"get","","Returns a shared reference to the output at this location,…",136,[[["t"]],["option"]]],[10,"get_mut","","Returns a mutable reference to the output at this…",136,[[["t"]],["option"]]],[10,"get_unchecked","","Returns a shared reference to the output at this location,…",136,[[["t"]]]],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this…",136,[[["t"]]]],[10,"index","","Returns a shared reference to the output at this location,…",136,[[["t"]]]],[10,"index_mut","","Returns a mutable reference to the output at this…",136,[[["t"]]]],[11,"as_slice","","Views the underlying data as a subslice of the original…",137,[[["self"]]]],[11,"into_slice","","Views the underlying data as a subslice of the original…",138,[[]]],[11,"as_slice","","Views the underlying data as a subslice of the original…",138,[[["self"]]]],[11,"remainder","","Returns the remainder of the original slice that is not…",139,[[["self"]]]],[11,"into_remainder","","Returns the remainder of the original slice that is not…",140,[[]]],[11,"remainder","","Returns the remainder of the original slice that is not…",141,[[["self"]]]],[11,"into_remainder","","Returns the remainder of the original slice that is not…",142,[[]]],[0,"str","core","String manipulation.",null,null],[3,"ParseBoolError","core::str","An error returned when parsing a `bool` using [`from_str`]…",null,null],[3,"Utf8Error","","Errors which can occur when attempting to interpret a…",null,null],[3,"Chars","","An iterator over the [`char`]s of a string slice.",null,null],[3,"CharIndices","","An iterator over the [`char`]s of a string slice, and…",null,null],[3,"Bytes","","An iterator over the bytes of a string slice.",null,null],[3,"Split","","Created with the method [`split`].",null,null],[3,"RSplit","","Created with the method [`rsplit`].",null,null],[3,"SplitTerminator","","Created with the method [`split_terminator`].",null,null],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator`].",null,null],[3,"SplitN","","Created with the method [`splitn`].",null,null],[3,"RSplitN","","Created with the method [`rsplitn`].",null,null],[3,"MatchIndices","","Created with the method [`match_indices`].",null,null],[3,"RMatchIndices","","Created with the method [`rmatch_indices`].",null,null],[3,"Matches","","Created with the method [`matches`].",null,null],[3,"RMatches","","Created with the method [`rmatches`].",null,null],[3,"Lines","","An iterator over the lines of a string, as string slices.",null,null],[3,"LinesAny","","Created with the method [`lines_any`].",null,null],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a…",null,null],[3,"SplitAsciiWhitespace","","An iterator over the non-ASCII-whitespace substrings of a…",null,null],[3,"SplitInclusive","","An iterator over the substrings of a string, terminated by…",null,null],[3,"EncodeUtf16","","An iterator of [`u16`] over the string encoded as UTF-16.",null,null],[3,"EscapeDebug","","The return type of [`str::escape_debug`].",null,null],[3,"EscapeDefault","","The return type of [`str::escape_default`].",null,null],[3,"EscapeUnicode","","The return type of [`str::escape_unicode`].",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,[[],[["str"],["result",["str","utf8error"]],["utf8error"]]]],[5,"from_utf8_mut","","Converts a mutable slice of bytes to a mutable string slice.",null,[[],[["utf8error"],["str"],["result",["str","utf8error"]]]]],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without…",null,[[],["str"]]],[5,"from_utf8_unchecked_mut","","Converts a slice of bytes to a string slice without…",null,[[],["str"]]],[5,"next_code_point","","Reads the next code point out of a byte iterator (assuming…",null,[[["i"]],[["u32"],["option",["u32"]]]]],[5,"utf8_char_width","","Given a first byte, determines how many bytes are in this…",null,[[["u8"]],["usize"]]],[0,"pattern","","The string Pattern API.",null,null],[3,"CharSearcher","core::str::pattern","Associated type for `<char as Pattern<'a>>::Searcher`.",null,null],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<'a>>::Searcher`.",null,null],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<'a>>::Searcher`.",null,null],[3,"StrSearcher","","Associated type for `<&str as Pattern<'a>>::Searcher`.",null,null],[4,"SearchStep","","Result of calling `Searcher::next()` or…",null,null],[13,"Match","","Expresses that a match of the pattern has been found at…",143,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a…",143,null],[13,"Done","","Expresses that every byte of the haystack has been…",143,null],[8,"Pattern","","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",144,null],[10,"into_searcher","","Constructs the associated searcher from `self` and the…",144,[[["str"]]]],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",144,[[["str"]],["bool"]]],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the…",144,[[["str"]],["bool"]]],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the…",144,[[["str"]],["bool"]]],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlying string to be searched in",145,[[["self"]],["str"]]],[10,"next","","Performs the next search step starting from the front.",145,[[["self"]],["searchstep"]]],[11,"next_match","","Finds the next `Match` result. See `next()`",145,[[["self"]],["option"]]],[11,"next_reject","","Finds the next `Reject` result. See `next()` and…",145,[[["self"]],["option"]]],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",146,[[["self"]],["searchstep"]]],[11,"next_match_back","","Finds the next `Match` result. See `next_back()`",146,[[["self"]],["option"]]],[11,"next_reject_back","","Finds the next `Reject` result. See `next_back()`",146,[[["self"]],["option"]]],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be…",null,null],[0,"lossy","core::str","",null,null],[3,"Utf8Lossy","core::str::lossy","Lossy UTF-8 string.",null,null],[3,"Utf8LossyChunksIter","","Iterator over lossy UTF-8 string",null,null],[3,"Utf8LossyChunk","","",null,null],[12,"valid","","Sequence of valid chars. Can be empty between broken UTF-8…",147,null],[12,"broken","","Single broken char, empty if none. Empty iff iterator item…",147,null],[11,"from_str","","",148,[[["str"]],["utf8lossy"]]],[11,"from_bytes","","",148,[[],["utf8lossy"]]],[11,"chunks","","",148,[[["self"]],["utf8lossychunksiter"]]],[8,"FromStr","core::str","Parse a value from a string",null,null],[16,"Err","","The associated error which can be returned from parsing.",149,null],[10,"from_str","","Parses a string `s` to return a value of this type.",149,[[["str"]],["result"]]],[11,"valid_up_to","","Returns the index in the given string up to which valid…",150,[[["self"]],["usize"]]],[11,"error_len","","Provides more information about the failure:",150,[[["self"]],[["option",["usize"]],["usize"]]]],[11,"as_str","","Views the underlying data as a subslice of the original…",151,[[["self"]],["str"]]],[11,"as_str","","Views the underlying data as a subslice of the original…",152,[[["self"]],["str"]]],[0,"time","core","Temporal quantification.",null,null],[3,"Duration","core::time","A `Duration` type to represent a span of time, typically…",null,null],[18,"SECOND","","The duration of one second.",153,null],[18,"MILLISECOND","","The duration of one millisecond.",153,null],[18,"MICROSECOND","","The duration of one microsecond.",153,null],[18,"NANOSECOND","","The duration of one nanosecond.",153,null],[11,"new","","Creates a new `Duration` from the specified number of…",153,[[["u32"],["u64"]],["duration"]]],[11,"from_secs","","Creates a new `Duration` from the specified number of…",153,[[["u64"]],["duration"]]],[11,"from_millis","","Creates a new `Duration` from the specified number of…",153,[[["u64"]],["duration"]]],[11,"from_micros","","Creates a new `Duration` from the specified number of…",153,[[["u64"]],["duration"]]],[11,"from_nanos","","Creates a new `Duration` from the specified number of…",153,[[["u64"]],["duration"]]],[11,"as_secs","","Returns the number of whole seconds contained by this…",153,[[["self"]],["u64"]]],[11,"subsec_millis","","Returns the fractional part of this `Duration`, in whole…",153,[[["self"]],["u32"]]],[11,"subsec_micros","","Returns the fractional part of this `Duration`, in whole…",153,[[["self"]],["u32"]]],[11,"subsec_nanos","","Returns the fractional part of this `Duration`, in…",153,[[["self"]],["u32"]]],[11,"as_millis","","Returns the total number of whole milliseconds contained…",153,[[["self"]],["u128"]]],[11,"as_micros","","Returns the total number of whole microseconds contained…",153,[[["self"]],["u128"]]],[11,"as_nanos","","Returns the total number of nanoseconds contained by this…",153,[[["self"]],["u128"]]],[11,"checked_add","","Checked `Duration` addition. Computes `self + other`,…",153,[[["duration"]],[["option",["duration"]],["duration"]]]],[11,"checked_sub","","Checked `Duration` subtraction. Computes `self - other`,…",153,[[["duration"]],[["option",["duration"]],["duration"]]]],[11,"checked_mul","","Checked `Duration` multiplication. Computes `self *…",153,[[["u32"]],[["option",["duration"]],["duration"]]]],[11,"checked_div","","Checked `Duration` division. Computes `self / other`,…",153,[[["u32"]],[["option",["duration"]],["duration"]]]],[11,"as_secs_f64","","Returns the number of seconds contained by this `Duration`…",153,[[["self"]],["f64"]]],[11,"as_secs_f32","","Returns the number of seconds contained by this `Duration`…",153,[[["self"]],["f32"]]],[11,"from_secs_f64","","Creates a new `Duration` from the specified number of…",153,[[["f64"]],["duration"]]],[11,"from_secs_f32","","Creates a new `Duration` from the specified number of…",153,[[["f32"]],["duration"]]],[11,"mul_f64","","Multiplies `Duration` by `f64`.",153,[[["f64"]],["duration"]]],[11,"mul_f32","","Multiplies `Duration` by `f32`.",153,[[["f32"]],["duration"]]],[11,"div_f64","","Divide `Duration` by `f64`.",153,[[["f64"]],["duration"]]],[11,"div_f32","","Divide `Duration` by `f32`.",153,[[["f32"]],["duration"]]],[11,"div_duration_f64","","Divide `Duration` by `Duration` and return `f64`.",153,[[["duration"]],["f64"]]],[11,"div_duration_f32","","Divide `Duration` by `Duration` and return `f32`.",153,[[["duration"]],["f32"]]],[0,"unicode","core","",null,null],[5,"Alphabetic","core::unicode","",null,[[["char"]],["bool"]]],[5,"Case_Ignorable","","",null,[[["char"]],["bool"]]],[5,"Cased","","",null,[[["char"]],["bool"]]],[5,"Cc","","",null,[[["char"]],["bool"]]],[5,"Grapheme_Extend","","",null,[[["char"]],["bool"]]],[5,"Lowercase","","",null,[[["char"]],["bool"]]],[5,"N","","",null,[[["char"]],["bool"]]],[5,"Uppercase","","",null,[[["char"]],["bool"]]],[5,"White_Space","","",null,[[["char"]],["bool"]]],[0,"derived_property","","",null,null],[5,"Case_Ignorable","core::unicode::derived_property","",null,[[["char"]],["bool"]]],[5,"Cased","","",null,[[["char"]],["bool"]]],[0,"conversions","core::unicode","",null,null],[5,"to_lower","core::unicode::conversions","",null,[[["char"]]]],[5,"to_upper","","",null,[[["char"]]]],[17,"UNICODE_VERSION","core::unicode","The version of Unicode that the Unicode parts of `char`…",null,null],[0,"future","core","Asynchronous values.",null,null],[8,"Future","core::future","A future represents an asynchronous computation.",null,null],[16,"Output","","The type of value produced on completion.",154,null],[10,"poll","","Attempt to resolve the future to a final value,…",154,[[["self"],["context"],["pin"]],["poll"]]],[0,"task","core","Types and Traits for working with asynchronous tasks.",null,null],[3,"Context","core::task","The `Context` of an asynchronous task.",null,null],[3,"RawWaker","","A `RawWaker` allows the implementor of a task executor to…",null,null],[3,"RawWakerVTable","","A virtual function pointer table (vtable) that specifies…",null,null],[3,"Waker","","A `Waker` is a handle for waking up a task by notifying…",null,null],[4,"Poll","","Indicates whether a value is available or if the current…",null,null],[13,"Ready","","Represents that a value is immediately ready.",155,null],[13,"Pending","","Represents that a value is not ready yet.",155,null],[11,"map","","Changes the ready value of this `Poll` with the closure…",155,[[["f"]],["poll"]]],[11,"is_ready","","Returns `true` if this is `Poll::Ready`",155,[[["self"]],["bool"]]],[11,"is_pending","","Returns `true` if this is `Poll::Pending`",155,[[["self"]],["bool"]]],[11,"map_ok","","Changes the success value of this `Poll` with the closure…",155,[[["f"]],[["result"],["poll",["result"]]]]],[11,"map_err","","Changes the error value of this `Poll` with the closure…",155,[[["f"]],[["result"],["poll",["result"]]]]],[11,"map_ok","","Changes the success value of this `Poll` with the closure…",155,[[["f"]],[["poll",["option"]],["option",["result"]]]]],[11,"map_err","","Changes the error value of this `Poll` with the closure…",155,[[["f"]],[["option",["result"]],["poll",["option"]]]]],[11,"new","","Creates a new `RawWaker` from the provided `data` pointer…",156,[[["rawwakervtable"]],["rawwaker"]]],[11,"new","","Creates a new `RawWakerVTable` from the provided `clone`,…",157,[[],["self"]]],[11,"from_waker","","Create a new `Context` from a `&Waker`.",158,[[["waker"]],["self"]]],[11,"waker","","Returns a reference to the `Waker` for the current task.",158,[[["self"]],["waker"]]],[11,"wake","","Wake up the task associated with this `Waker`.",159,[[]]],[11,"wake_by_ref","","Wake up the task associated with this `Waker` without…",159,[[["self"]]]],[11,"will_wake","","Returns `true` if this `Waker` and another `Waker` have…",159,[[["waker"],["self"]],["bool"]]],[11,"from_raw","","Creates a new `Waker` from [`RawWaker`].",159,[[["rawwaker"]],["waker"]]],[0,"alloc","core","Memory allocation APIs",null,null],[3,"Layout","core::alloc","Layout of a block of memory.",null,null],[3,"LayoutErr","","The parameters given to `Layout::from_size_align` or some…",null,null],[3,"AllocErr","","The `AllocErr` error indicates an allocation failure that…",null,null],[3,"CannotReallocInPlace","","The `CannotReallocInPlace` error is used when…",null,null],[8,"GlobalAlloc","","A memory allocator that can be registered as the standard…",null,null],[10,"alloc","","Allocate memory as described by the given `layout`.",160,[[["layout"],["self"]]]],[10,"dealloc","","Deallocate the block of memory at the given `ptr` pointer…",160,[[["layout"],["self"]]]],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents…",160,[[["layout"],["self"]]]],[11,"realloc","","Shrink or grow a block of memory to the given `new_size`.…",160,[[["usize"],["self"],["layout"]]]],[8,"AllocRef","","An implementation of `AllocRef` can allocate, reallocate,…",null,null],[10,"alloc","","On success, returns a pointer meeting the size and…",161,[[["self"],["layout"]],[["allocerr"],["result",["allocerr"]]]]],[10,"dealloc","","Deallocate the memory referenced by `ptr`.",161,[[["u8"],["layout"],["self"],["nonnull",["u8"]]]]],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents…",161,[[["self"],["layout"]],[["allocerr"],["result",["allocerr"]]]]],[11,"realloc","","Returns a pointer suitable for holding data described by a…",161,[[["u8"],["layout"],["usize"],["self"],["nonnull",["u8"]]],[["allocerr"],["result",["allocerr"]]]]],[11,"realloc_zeroed","","Behaves like `realloc`, but also ensures that the new…",161,[[["u8"],["layout"],["usize"],["self"],["nonnull",["u8"]]],[["allocerr"],["result",["allocerr"]]]]],[11,"grow_in_place","","Attempts to extend the allocation referenced by `ptr` to…",161,[[["u8"],["layout"],["usize"],["self"],["nonnull",["u8"]]],[["result",["usize","cannotreallocinplace"]],["cannotreallocinplace"],["usize"]]]],[11,"grow_in_place_zeroed","","Behaves like `grow_in_place`, but also ensures that the…",161,[[["u8"],["layout"],["usize"],["self"],["nonnull",["u8"]]],[["result",["usize","cannotreallocinplace"]],["cannotreallocinplace"],["usize"]]]],[11,"shrink_in_place","","Attempts to shrink the allocation referenced by `ptr` to…",161,[[["u8"],["layout"],["usize"],["self"],["nonnull",["u8"]]],[["result",["usize","cannotreallocinplace"]],["cannotreallocinplace"],["usize"]]]],[11,"from_size_align","","Constructs a `Layout` from a given `size` and `align`, or…",162,[[["usize"]],[["result",["layouterr"]],["layouterr"]]]],[11,"from_size_align_unchecked","","Creates a layout, bypassing all checks.",162,[[["usize"]],["self"]]],[11,"size","","The minimum size in bytes for a memory block of this layout.",162,[[["self"]],["usize"]]],[11,"align","","The minimum byte alignment for a memory block of this…",162,[[["self"]],["usize"]]],[11,"new","","Constructs a `Layout` suitable for holding a value of type…",162,[[],["self"]]],[11,"for_value","","Produces layout describing a record that could be used to…",162,[[["t"]],["self"]]],[11,"dangling","","Creates a `NonNull` that is dangling, but well-aligned for…",162,[[["self"]],[["u8"],["nonnull",["u8"]]]]],[11,"align_to","","Creates a layout describing the record that can hold a…",162,[[["usize"],["self"]],[["result",["layouterr"]],["layouterr"]]]],[11,"padding_needed_for","","Returns the amount of padding we must insert after `self`…",162,[[["usize"],["self"]],["usize"]]],[11,"pad_to_align","","Creates a layout by rounding the size of this layout up to…",162,[[["self"]],["layout"]]],[11,"repeat","","Creates a layout describing the record for `n` instances…",162,[[["usize"],["self"]],[["result",["layouterr"]],["layouterr"]]]],[11,"extend","","Creates a layout describing the record for `self` followed…",162,[[["self"]],[["result",["layouterr"]],["layouterr"]]]],[11,"repeat_packed","","Creates a layout describing the record for `n` instances…",162,[[["usize"],["self"]],[["result",["layouterr"]],["layouterr"]]]],[11,"extend_packed","","Creates a layout describing the record for `self` followed…",162,[[["self"]],[["result",["layouterr"]],["layouterr"]]]],[11,"array","","Creates a layout describing the record for a `[T; n]`.",162,[[["usize"]],[["result",["layouterr"]],["layouterr"]]]],[11,"description","","",163,[[["self"]],["str"]]],[0,"primitive","core","This module reexports the primitive types to allow usage…",null,null],[0,"arch","","SIMD and vendor intrinsics module.",null,null],[0,"x86","core::arch","Platform-specific intrinsics for the `x86` platform.",null,null],[3,"__m64","core::arch::x86","64-bit wide integer vector type, x86-specific",null,null],[3,"__m128i","","128-bit wide integer vector type, x86-specific",null,null],[3,"__m128","","128-bit wide set of four `f32` types, x86-specific",null,null],[3,"__m128d","","128-bit wide set of two `f64` types, x86-specific",null,null],[3,"__m256i","","256-bit wide integer vector type, x86-specific",null,null],[3,"__m256","","256-bit wide set of eight `f32` types, x86-specific",null,null],[3,"__m256d","","256-bit wide set of four `f64` types, x86-specific",null,null],[3,"__m512i","","512-bit wide integer vector type, x86-specific",null,null],[3,"__m512","","512-bit wide set of sixteen `f32` types, x86-specific",null,null],[3,"__m512d","","512-bit wide set of eight `f64` types, x86-specific",null,null],[3,"CpuidResult","","Result of the `cpuid` instruction.",null,null],[12,"eax","","EAX register.",164,null],[12,"ebx","","EBX register.",164,null],[12,"ecx","","ECX register.",164,null],[12,"edx","","EDX register.",164,null],[5,"_fxsave","","Saves the `x87` FPU, `MMX` technology, `XMM`, and `MXCSR`…",null,[[]]],[5,"_fxrstor","","Restores the `XMM`, `MMX`, `MXCSR`, and `x87` FPU…",null,[[]]],[5,"_bswap","","Returns an integer with the reversed byte order of x",null,[[["i32"]],["i32"]]],[5,"_rdtsc","","Reads the current value of the processor’s time-stamp…",null,[[],["u64"]]],[5,"__rdtscp","","Reads the current value of the processor’s time-stamp…",null,[[],["u64"]]],[5,"__cpuid_count","","Returns the result of the `cpuid` instruction for a given…",null,[[["u32"]],["cpuidresult"]]],[5,"__cpuid","","See `__cpuid_count`.",null,[[["u32"]],["cpuidresult"]]],[5,"has_cpuid","","Does the host support the `cpuid` instruction?",null,[[],["bool"]]],[5,"__get_cpuid_max","","Returns the highest-supported `leaf` (`EAX`) and sub-leaf…",null,[[["u32"]]]],[5,"_xsave","","Performs a full or partial save of the enabled processor…",null,[[["u64"]]]],[5,"_xrstor","","Performs a full or partial restore of the enabled…",null,[[["u64"]]]],[5,"_xsetbv","","Copies 64-bits from `val` to the extended control register…",null,[[["u32"],["u64"]]]],[5,"_xgetbv","","Reads the contents of the extended control register `XCR`…",null,[[["u32"]],["u64"]]],[5,"_xsaveopt","","Performs a full or partial save of the enabled processor…",null,[[["u64"]]]],[5,"_xsavec","","Performs a full or partial save of the enabled processor…",null,[[["u64"]]]],[5,"_xsaves","","Performs a full or partial save of the enabled processor…",null,[[["u64"]]]],[5,"_xrstors","","Performs a full or partial restore of the enabled…",null,[[["u64"]]]],[5,"_mm_add_ss","","Adds the first component of `a` and `b`, the other…",null,[[["__m128"]],["__m128"]]],[5,"_mm_add_ps","","Adds __m128 vectors.",null,[[["__m128"]],["__m128"]]],[5,"_mm_sub_ss","","Subtracts the first component of `b` from `a`, the other…",null,[[["__m128"]],["__m128"]]],[5,"_mm_sub_ps","","Subtracts __m128 vectors.",null,[[["__m128"]],["__m128"]]],[5,"_mm_mul_ss","","Multiplies the first component of `a` and `b`, the other…",null,[[["__m128"]],["__m128"]]],[5,"_mm_mul_ps","","Multiplies __m128 vectors.",null,[[["__m128"]],["__m128"]]],[5,"_mm_div_ss","","Divides the first component of `b` by `a`, the other…",null,[[["__m128"]],["__m128"]]],[5,"_mm_div_ps","","Divides __m128 vectors.",null,[[["__m128"]],["__m128"]]],[5,"_mm_sqrt_ss","","Returns the square root of the first single-precision…",null,[[["__m128"]],["__m128"]]],[5,"_mm_sqrt_ps","","Returns the square root of packed single-precision…",null,[[["__m128"]],["__m128"]]],[5,"_mm_rcp_ss","","Returns the approximate reciprocal of the first…",null,[[["__m128"]],["__m128"]]],[5,"_mm_rcp_ps","","Returns the approximate reciprocal of packed…",null,[[["__m128"]],["__m128"]]],[5,"_mm_rsqrt_ss","","Returns the approximate reciprocal square root of the fist…",null,[[["__m128"]],["__m128"]]],[5,"_mm_rsqrt_ps","","Returns the approximate reciprocal square root of packed…",null,[[["__m128"]],["__m128"]]],[5,"_mm_min_ss","","Compares the first single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_min_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm_max_ss","","Compares the first single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_max_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm_and_ps","","Bitwise AND of packed single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_andnot_ps","","Bitwise AND-NOT of packed single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_or_ps","","Bitwise OR of packed single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_xor_ps","","Bitwise exclusive OR of packed single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpeq_ss","","Compares the lowest `f32` of both inputs for equality. The…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmplt_ss","","Compares the lowest `f32` of both inputs for less than.…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmple_ss","","Compares the lowest `f32` of both inputs for less than or…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpgt_ss","","Compares the lowest `f32` of both inputs for greater than.…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpge_ss","","Compares the lowest `f32` of both inputs for greater than…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpneq_ss","","Compares the lowest `f32` of both inputs for inequality.…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpnlt_ss","","Compares the lowest `f32` of both inputs for…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpnle_ss","","Compares the lowest `f32` of both inputs for…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpngt_ss","","Compares the lowest `f32` of both inputs for…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpnge_ss","","Compares the lowest `f32` of both inputs for…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpord_ss","","Checks if the lowest `f32` of both inputs are ordered. The…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpunord_ss","","Checks if the lowest `f32` of both inputs are unordered.…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpeq_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmplt_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmple_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpgt_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpge_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpneq_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpnlt_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpnle_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpngt_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpnge_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpord_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpunord_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_comieq_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_comilt_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_comile_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_comigt_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_comige_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_comineq_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_ucomieq_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_ucomilt_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_ucomile_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_ucomigt_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_ucomige_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_ucomineq_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_cvtss_si32","","Converts the lowest 32 bit float in the input vector to a…",null,[[["__m128"]],["i32"]]],[5,"_mm_cvt_ss2si","","Alias for `_mm_cvtss_si32`.",null,[[["__m128"]],["i32"]]],[5,"_mm_cvttss_si32","","Converts the lowest 32 bit float in the input vector to a…",null,[[["__m128"]],["i32"]]],[5,"_mm_cvtt_ss2si","","Alias for `_mm_cvttss_si32`.",null,[[["__m128"]],["i32"]]],[5,"_mm_cvtss_f32","","Extracts the lowest 32 bit float from the input vector.",null,[[["__m128"]],["f32"]]],[5,"_mm_cvtsi32_ss","","Converts a 32 bit integer to a 32 bit float. The result…",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm_cvt_si2ss","","Alias for `_mm_cvtsi32_ss`.",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm_set_ss","","Construct a `__m128` with the lowest element set to `a`…",null,[[["f32"]],["__m128"]]],[5,"_mm_set1_ps","","Construct a `__m128` with all element set to `a`.",null,[[["f32"]],["__m128"]]],[5,"_mm_set_ps1","","Alias for `_mm_set1_ps`",null,[[["f32"]],["__m128"]]],[5,"_mm_set_ps","","Construct a `__m128` from four floating point values…",null,[[["f32"]],["__m128"]]],[5,"_mm_setr_ps","","Construct a `__m128` from four floating point values…",null,[[["f32"]],["__m128"]]],[5,"_mm_setzero_ps","","Construct a `__m128` with all elements initialized to zero.",null,[[],["__m128"]]],[5,"_MM_SHUFFLE","","A utility function for creating masks to use with Intel…",null,[[["u32"]],["i32"]]],[5,"_mm_shuffle_ps","","Shuffles packed single-precision (32-bit) floating-point…",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm_unpackhi_ps","","Unpacks and interleave single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_unpacklo_ps","","Unpacks and interleave single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_movehl_ps","","Combine higher half of `a` and `b`. The highwe half of `b`…",null,[[["__m128"]],["__m128"]]],[5,"_mm_movelh_ps","","Combine lower half of `a` and `b`. The lower half of `b`…",null,[[["__m128"]],["__m128"]]],[5,"_mm_movemask_ps","","Returns a mask of the most significant bit of each element…",null,[[["__m128"]],["i32"]]],[5,"_mm_loadh_pi","","Sets the upper two single-precision floating-point values…",null,[[["__m128"]],["__m128"]]],[5,"_mm_loadl_pi","","Loads two floats from `p` into the lower half of a…",null,[[["__m128"]],["__m128"]]],[5,"_mm_load_ss","","Construct a `__m128` with the lowest element read from `p`…",null,[[],["__m128"]]],[5,"_mm_load1_ps","","Construct a `__m128` by duplicating the value read from…",null,[[],["__m128"]]],[5,"_mm_load_ps1","","Alias for `_mm_load1_ps`",null,[[],["__m128"]]],[5,"_mm_load_ps","","Loads four `f32` values from aligned memory into a…",null,[[],["__m128"]]],[5,"_mm_loadu_ps","","Loads four `f32` values from memory into a `__m128`. There…",null,[[],["__m128"]]],[5,"_mm_loadr_ps","","Loads four `f32` values from aligned memory into a…",null,[[],["__m128"]]],[5,"_mm_storeh_pi","","Stores the upper half of `a` (64 bits) into memory.",null,[[["__m128"]]]],[5,"_mm_storel_pi","","Stores the lower half of `a` (64 bits) into memory.",null,[[["__m128"]]]],[5,"_mm_store_ss","","Stores the lowest 32 bit float of `a` into memory.",null,[[["__m128"]]]],[5,"_mm_store1_ps","","Stores the lowest 32 bit float of `a` repeated four times…",null,[[["__m128"]]]],[5,"_mm_store_ps1","","Alias for `_mm_store1_ps`",null,[[["__m128"]]]],[5,"_mm_store_ps","","Stores four 32-bit floats into aligned memory.",null,[[["__m128"]]]],[5,"_mm_storeu_ps","","Stores four 32-bit floats into memory. There are no…",null,[[["__m128"]]]],[5,"_mm_storer_ps","","Stores four 32-bit floats into aligned memory in reverse…",null,[[["__m128"]]]],[5,"_mm_move_ss","","Returns a `__m128` with the first component from `b` and…",null,[[["__m128"]],["__m128"]]],[5,"_mm_sfence","","Performs a serializing operation on all store-to-memory…",null,[[]]],[5,"_mm_getcsr","","Gets the unsigned 32-bit value of the MXCSR control and…",null,[[],["u32"]]],[5,"_mm_setcsr","","Sets the MXCSR register with the 32-bit unsigned integer…",null,[[["u32"]]]],[5,"_MM_GET_EXCEPTION_MASK","","See `_mm_setcsr`",null,[[],["u32"]]],[5,"_MM_GET_EXCEPTION_STATE","","See `_mm_setcsr`",null,[[],["u32"]]],[5,"_MM_GET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",null,[[],["u32"]]],[5,"_MM_GET_ROUNDING_MODE","","See `_mm_setcsr`",null,[[],["u32"]]],[5,"_MM_SET_EXCEPTION_MASK","","See `_mm_setcsr`",null,[[["u32"]]]],[5,"_MM_SET_EXCEPTION_STATE","","See `_mm_setcsr`",null,[[["u32"]]]],[5,"_MM_SET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",null,[[["u32"]]]],[5,"_MM_SET_ROUNDING_MODE","","See `_mm_setcsr`",null,[[["u32"]]]],[5,"_mm_prefetch","","Fetch the cache line that contains address `p` using the…",null,[[["i32"]]]],[5,"_mm_undefined_ps","","Returns vector of type __m128 with undefined elements.",null,[[],["__m128"]]],[5,"_MM_TRANSPOSE4_PS","","Transpose the 4x4 matrix formed by 4 rows of __m128 in…",null,[[["__m128"]]]],[5,"_mm_stream_ps","","Stores `a` into the memory at `mem_addr` using a…",null,[[["__m128"]]]],[5,"_mm_stream_pi","","Stores 64-bits of integer data from a into memory using a…",null,[[["__m64"]]]],[5,"_mm_max_pi16","","Compares the packed 16-bit signed integers of `a` and `b`…",null,[[["__m64"]],["__m64"]]],[5,"_m_pmaxsw","","Compares the packed 16-bit signed integers of `a` and `b`…",null,[[["__m64"]],["__m64"]]],[5,"_mm_max_pu8","","Compares the packed 8-bit signed integers of `a` and `b`…",null,[[["__m64"]],["__m64"]]],[5,"_m_pmaxub","","Compares the packed 8-bit signed integers of `a` and `b`…",null,[[["__m64"]],["__m64"]]],[5,"_mm_min_pi16","","Compares the packed 16-bit signed integers of `a` and `b`…",null,[[["__m64"]],["__m64"]]],[5,"_m_pminsw","","Compares the packed 16-bit signed integers of `a` and `b`…",null,[[["__m64"]],["__m64"]]],[5,"_mm_min_pu8","","Compares the packed 8-bit signed integers of `a` and `b`…",null,[[["__m64"]],["__m64"]]],[5,"_m_pminub","","Compares the packed 8-bit signed integers of `a` and `b`…",null,[[["__m64"]],["__m64"]]],[5,"_mm_mulhi_pu16","","Multiplies packed 16-bit unsigned integer values and…",null,[[["__m64"]],["__m64"]]],[5,"_mm_mullo_pi16","","Multiplies packed 16-bit integer values and writes the…",null,[[["__m64"]],["__m64"]]],[5,"_m_pmulhuw","","Multiplies packed 16-bit unsigned integer values and…",null,[[["__m64"]],["__m64"]]],[5,"_mm_avg_pu8","","Computes the rounded averages of the packed unsigned 8-bit…",null,[[["__m64"]],["__m64"]]],[5,"_m_pavgb","","Computes the rounded averages of the packed unsigned 8-bit…",null,[[["__m64"]],["__m64"]]],[5,"_mm_avg_pu16","","Computes the rounded averages of the packed unsigned…",null,[[["__m64"]],["__m64"]]],[5,"_m_pavgw","","Computes the rounded averages of the packed unsigned…",null,[[["__m64"]],["__m64"]]],[5,"_mm_sad_pu8","","Subtracts the corresponding 8-bit unsigned integer values…",null,[[["__m64"]],["__m64"]]],[5,"_m_psadbw","","Subtracts the corresponding 8-bit unsigned integer values…",null,[[["__m64"]],["__m64"]]],[5,"_mm_cvtpi32_ps","","Converts two elements of a 64-bit vector of `[2 x i32]`…",null,[[["__m64"],["__m128"]],["__m128"]]],[5,"_mm_cvt_pi2ps","","Converts two elements of a 64-bit vector of `[2 x i32]`…",null,[[["__m64"],["__m128"]],["__m128"]]],[5,"_mm_cvtpi8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit…",null,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpu8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit…",null,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpi16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector…",null,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpu16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector…",null,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpi32x2_ps","","Converts the two 32-bit signed integer values from each…",null,[[["__m64"]],["__m128"]]],[5,"_mm_maskmove_si64","","Conditionally copies the values from each 8-bit element in…",null,[[["__m64"]]]],[5,"_m_maskmovq","","Conditionally copies the values from each 8-bit element in…",null,[[["__m64"]]]],[5,"_mm_extract_pi16","","Extracts 16-bit element from a 64-bit vector of `[4 x…",null,[[["__m64"],["i32"]],["i32"]]],[5,"_m_pextrw","","Extracts 16-bit element from a 64-bit vector of `[4 x…",null,[[["__m64"],["i32"]],["i32"]]],[5,"_mm_insert_pi16","","Copies data from the 64-bit vector of `[4 x i16]` to the…",null,[[["__m64"],["i32"]],["__m64"]]],[5,"_m_pinsrw","","Copies data from the 64-bit vector of `[4 x i16]` to the…",null,[[["__m64"],["i32"]],["__m64"]]],[5,"_mm_movemask_pi8","","Takes the most significant bit from each 8-bit element in…",null,[[["__m64"]],["i32"]]],[5,"_m_pmovmskb","","Takes the most significant bit from each 8-bit element in…",null,[[["__m64"]],["i32"]]],[5,"_mm_shuffle_pi16","","Shuffles the 4 16-bit integers from a 64-bit integer…",null,[[["__m64"],["i32"]],["__m64"]]],[5,"_m_pshufw","","Shuffles the 4 16-bit integers from a 64-bit integer…",null,[[["__m64"],["i32"]],["__m64"]]],[5,"_mm_cvttps_pi32","","Converts the two lower packed single-precision (32-bit)…",null,[[["__m128"]],["__m64"]]],[5,"_mm_cvtt_ps2pi","","Converts the two lower packed single-precision (32-bit)…",null,[[["__m128"]],["__m64"]]],[5,"_mm_cvtps_pi32","","Converts the two lower packed single-precision (32-bit)…",null,[[["__m128"]],["__m64"]]],[5,"_mm_cvt_ps2pi","","Converts the two lower packed single-precision (32-bit)…",null,[[["__m128"]],["__m64"]]],[5,"_mm_cvtps_pi16","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m64"]]],[5,"_mm_cvtps_pi8","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m64"]]],[5,"_mm_pause","","Provides a hint to the processor that the code sequence is…",null,[[]]],[5,"_mm_clflush","","Invalidates and flushes the cache line that contains `p`…",null,[[]]],[5,"_mm_lfence","","Performs a serializing operation on all load-from-memory…",null,[[]]],[5,"_mm_mfence","","Performs a serializing operation on all load-from-memory…",null,[[]]],[5,"_mm_add_epi8","","Adds packed 8-bit integers in `a` and `b`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_add_epi16","","Adds packed 16-bit integers in `a` and `b`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_add_epi32","","Adds packed 32-bit integers in `a` and `b`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_add_epi64","","Adds packed 64-bit integers in `a` and `b`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_adds_epi8","","Adds packed 8-bit integers in `a` and `b` using saturation.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_adds_epi16","","Adds packed 16-bit integers in `a` and `b` using saturation.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_adds_epu8","","Adds packed unsigned 8-bit integers in `a` and `b` using…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_adds_epu16","","Adds packed unsigned 16-bit integers in `a` and `b` using…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_avg_epu8","","Averages packed unsigned 8-bit integers in `a` and `b`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_avg_epu16","","Averages packed unsigned 16-bit integers in `a` and `b`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_madd_epi16","","Multiplies and then horizontally add signed 16 bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_max_epi16","","Compares packed 16-bit integers in `a` and `b`, and…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_max_epu8","","Compares packed unsigned 8-bit integers in `a` and `b`,…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_min_epi16","","Compares packed 16-bit integers in `a` and `b`, and…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_min_epu8","","Compares packed unsigned 8-bit integers in `a` and `b`,…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_mulhi_epi16","","Multiplies the packed 16-bit integers in `a` and `b`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_mulhi_epu16","","Multiplies the packed unsigned 16-bit integers in `a` and…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_mullo_epi16","","Multiplies the packed 16-bit integers in `a` and `b`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_mul_epu32","","Multiplies the low unsigned 32-bit integers from each…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sad_epu8","","Sum the absolute differences of packed unsigned 8-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi8","","Subtracts packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi16","","Subtracts packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 32-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 64-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_slli_si128","","Shifts `a` left by `imm8` bytes while shifting in zeros.",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_bslli_si128","","Shifts `a` left by `imm8` bytes while shifting in zeros.",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_bsrli_si128","","Shifts `a` right by `imm8` bytes while shifting in zeros.",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_slli_epi16","","Shifts packed 16-bit integers in `a` left by `imm8` while…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sll_epi16","","Shifts packed 16-bit integers in `a` left by `count` while…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_slli_epi32","","Shifts packed 32-bit integers in `a` left by `imm8` while…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sll_epi32","","Shifts packed 32-bit integers in `a` left by `count` while…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_slli_epi64","","Shifts packed 64-bit integers in `a` left by `imm8` while…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sll_epi64","","Shifts packed 64-bit integers in `a` left by `count` while…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_srai_epi16","","Shifts packed 16-bit integers in `a` right by `imm8` while…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sra_epi16","","Shifts packed 16-bit integers in `a` right by `count`…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_srai_epi32","","Shifts packed 32-bit integers in `a` right by `imm8` while…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sra_epi32","","Shifts packed 32-bit integers in `a` right by `count`…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_srli_si128","","Shifts `a` right by `imm8` bytes while shifting in zeros.",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srli_epi16","","Shifts packed 16-bit integers in `a` right by `imm8` while…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srl_epi16","","Shifts packed 16-bit integers in `a` right by `count`…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_srli_epi32","","Shifts packed 32-bit integers in `a` right by `imm8` while…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srl_epi32","","Shifts packed 32-bit integers in `a` right by `count`…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_srli_epi64","","Shifts packed 64-bit integers in `a` right by `imm8` while…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srl_epi64","","Shifts packed 64-bit integers in `a` right by `count`…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_and_si128","","Computes the bitwise AND of 128 bits (representing integer…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_andnot_si128","","Computes the bitwise NOT of 128 bits (representing integer…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_or_si128","","Computes the bitwise OR of 128 bits (representing integer…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_xor_si128","","Computes the bitwise XOR of 128 bits (representing integer…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi8","","Compares packed 8-bit integers in `a` and `b` for equality.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi16","","Compares packed 16-bit integers in `a` and `b` for equality.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi32","","Compares packed 32-bit integers in `a` and `b` for equality.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cmpgt_epi8","","Compares packed 8-bit integers in `a` and `b` for…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cmpgt_epi16","","Compares packed 16-bit integers in `a` and `b` for…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cmpgt_epi32","","Compares packed 32-bit integers in `a` and `b` for…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cmplt_epi8","","Compares packed 8-bit integers in `a` and `b` for less-than.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cmplt_epi16","","Compares packed 16-bit integers in `a` and `b` for…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cmplt_epi32","","Compares packed 32-bit integers in `a` and `b` for…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi32_pd","","Converts the lower two packed 32-bit integers in `a` to…",null,[[["__m128i"]],["__m128d"]]],[5,"_mm_cvtsi32_sd","","Returns `a` with its lower element replaced by `b` after…",null,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_cvtepi32_ps","","Converts packed 32-bit integers in `a` to packed…",null,[[["__m128i"]],["__m128"]]],[5,"_mm_cvtps_epi32","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128i"]]],[5,"_mm_cvtsi32_si128","","Returns a vector whose lowest element is `a` and all…",null,[[["i32"]],["__m128i"]]],[5,"_mm_cvtsi128_si32","","Returns the lowest element of `a`.",null,[[["__m128i"]],["i32"]]],[5,"_mm_set_epi64x","","Sets packed 64-bit integers with the supplied values, from…",null,[[["i64"]],["__m128i"]]],[5,"_mm_set_epi32","","Sets packed 32-bit integers with the supplied values.",null,[[["i32"]],["__m128i"]]],[5,"_mm_set_epi16","","Sets packed 16-bit integers with the supplied values.",null,[[["i16"]],["__m128i"]]],[5,"_mm_set_epi8","","Sets packed 8-bit integers with the supplied values.",null,[[["i8"]],["__m128i"]]],[5,"_mm_set1_epi64x","","Broadcasts 64-bit integer `a` to all elements.",null,[[["i64"]],["__m128i"]]],[5,"_mm_set1_epi32","","Broadcasts 32-bit integer `a` to all elements.",null,[[["i32"]],["__m128i"]]],[5,"_mm_set1_epi16","","Broadcasts 16-bit integer `a` to all elements.",null,[[["i16"]],["__m128i"]]],[5,"_mm_set1_epi8","","Broadcasts 8-bit integer `a` to all elements.",null,[[["i8"]],["__m128i"]]],[5,"_mm_setr_epi32","","Sets packed 32-bit integers with the supplied values in…",null,[[["i32"]],["__m128i"]]],[5,"_mm_setr_epi16","","Sets packed 16-bit integers with the supplied values in…",null,[[["i16"]],["__m128i"]]],[5,"_mm_setr_epi8","","Sets packed 8-bit integers with the supplied values in…",null,[[["i8"]],["__m128i"]]],[5,"_mm_setzero_si128","","Returns a vector with all elements set to zero.",null,[[],["__m128i"]]],[5,"_mm_loadl_epi64","","Loads 64-bit integer from memory into first element of…",null,[[],["__m128i"]]],[5,"_mm_load_si128","","Loads 128-bits of integer data from memory into a new…",null,[[],["__m128i"]]],[5,"_mm_loadu_si128","","Loads 128-bits of integer data from memory into a new…",null,[[],["__m128i"]]],[5,"_mm_maskmoveu_si128","","Conditionally store 8-bit integer elements from `a` into…",null,[[["__m128i"]]]],[5,"_mm_store_si128","","Stores 128-bits of integer data from `a` into memory.",null,[[["__m128i"]]]],[5,"_mm_storeu_si128","","Stores 128-bits of integer data from `a` into memory.",null,[[["__m128i"]]]],[5,"_mm_storel_epi64","","Stores the lower 64-bit integer `a` to a memory location.",null,[[["__m128i"]]]],[5,"_mm_stream_si128","","Stores a 128-bit integer vector to a 128-bit aligned…",null,[[["__m128i"]]]],[5,"_mm_stream_si32","","Stores a 32-bit integer value in the specified memory…",null,[[["i32"]]]],[5,"_mm_move_epi64","","Returns a vector where the low element is extracted from…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_packs_epi16","","Converts packed 16-bit integers from `a` and `b` to packed…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_packs_epi32","","Converts packed 32-bit integers from `a` and `b` to packed…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_packus_epi16","","Converts packed 16-bit integers from `a` and `b` to packed…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_extract_epi16","","Returns the `imm8` element of `a`.",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_insert_epi16","","Returns a new vector where the `imm8` element of `a` is…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_movemask_epi8","","Returns a mask of the most significant bit of each element…",null,[[["__m128i"]],["i32"]]],[5,"_mm_shuffle_epi32","","Shuffles 32-bit integers in `a` using the control in `imm8`.",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_shufflehi_epi16","","Shuffles 16-bit integers in the high 64 bits of `a` using…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_shufflelo_epi16","","Shuffles 16-bit integers in the low 64 bits of `a` using…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_unpackhi_epi8","","Unpacks and interleave 8-bit integers from the high half…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_unpackhi_epi16","","Unpacks and interleave 16-bit integers from the high half…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_unpackhi_epi32","","Unpacks and interleave 32-bit integers from the high half…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_unpackhi_epi64","","Unpacks and interleave 64-bit integers from the high half…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi8","","Unpacks and interleave 8-bit integers from the low half of…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi16","","Unpacks and interleave 16-bit integers from the low half…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi32","","Unpacks and interleave 32-bit integers from the low half…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi64","","Unpacks and interleave 64-bit integers from the low half…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_add_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_add_pd","","Adds packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_div_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_div_pd","","Divide packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_max_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_max_pd","","Returns a new vector with the maximum values from…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_min_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_min_pd","","Returns a new vector with the minimum values from…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_mul_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_mul_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_sqrt_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_sqrt_pd","","Returns a new vector with the square root of each of the…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_sub_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_sub_pd","","Subtract packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_and_pd","","Computes the bitwise AND of packed double-precision…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_andnot_pd","","Computes the bitwise NOT of `a` and then AND with `b`.",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_or_pd","","Computes the bitwise OR of `a` and `b`.",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_xor_pd","","Computes the bitwise OR of `a` and `b`.",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpeq_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmplt_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmple_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpgt_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpge_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpord_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpunord_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpneq_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpnlt_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpnle_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpngt_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpnge_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpeq_pd","","Compares corresponding elements in `a` and `b` for equality.",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmplt_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmple_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpgt_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpge_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpord_pd","","Compares corresponding elements in `a` and `b` to see if…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpunord_pd","","Compares corresponding elements in `a` and `b` to see if…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpneq_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpnlt_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpnle_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpngt_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpnge_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_comieq_sd","","Compares the lower element of `a` and `b` for equality.",null,[[["__m128d"]],["i32"]]],[5,"_mm_comilt_sd","","Compares the lower element of `a` and `b` for less-than.",null,[[["__m128d"]],["i32"]]],[5,"_mm_comile_sd","","Compares the lower element of `a` and `b` for…",null,[[["__m128d"]],["i32"]]],[5,"_mm_comigt_sd","","Compares the lower element of `a` and `b` for greater-than.",null,[[["__m128d"]],["i32"]]],[5,"_mm_comige_sd","","Compares the lower element of `a` and `b` for…",null,[[["__m128d"]],["i32"]]],[5,"_mm_comineq_sd","","Compares the lower element of `a` and `b` for not-equal.",null,[[["__m128d"]],["i32"]]],[5,"_mm_ucomieq_sd","","Compares the lower element of `a` and `b` for equality.",null,[[["__m128d"]],["i32"]]],[5,"_mm_ucomilt_sd","","Compares the lower element of `a` and `b` for less-than.",null,[[["__m128d"]],["i32"]]],[5,"_mm_ucomile_sd","","Compares the lower element of `a` and `b` for…",null,[[["__m128d"]],["i32"]]],[5,"_mm_ucomigt_sd","","Compares the lower element of `a` and `b` for greater-than.",null,[[["__m128d"]],["i32"]]],[5,"_mm_ucomige_sd","","Compares the lower element of `a` and `b` for…",null,[[["__m128d"]],["i32"]]],[5,"_mm_ucomineq_sd","","Compares the lower element of `a` and `b` for not-equal.",null,[[["__m128d"]],["i32"]]],[5,"_mm_cvtpd_ps","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128"]]],[5,"_mm_cvtps_pd","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128d"]]],[5,"_mm_cvtpd_epi32","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128i"]]],[5,"_mm_cvtsd_si32","","Converts the lower double-precision (64-bit)…",null,[[["__m128d"]],["i32"]]],[5,"_mm_cvtsd_ss","","Converts the lower double-precision (64-bit)…",null,[[["__m128d"],["__m128"]],["__m128"]]],[5,"_mm_cvtsd_f64","","Returns the lower double-precision (64-bit) floating-point…",null,[[["__m128d"]],["f64"]]],[5,"_mm_cvtss_sd","","Converts the lower single-precision (32-bit)…",null,[[["__m128d"],["__m128"]],["__m128d"]]],[5,"_mm_cvttpd_epi32","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128i"]]],[5,"_mm_cvttsd_si32","","Converts the lower double-precision (64-bit)…",null,[[["__m128d"]],["i32"]]],[5,"_mm_cvttps_epi32","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128i"]]],[5,"_mm_set_sd","","Copies double-precision (64-bit) floating-point element…",null,[[["f64"]],["__m128d"]]],[5,"_mm_set1_pd","","Broadcasts double-precision (64-bit) floating-point value…",null,[[["f64"]],["__m128d"]]],[5,"_mm_set_pd1","","Broadcasts double-precision (64-bit) floating-point value…",null,[[["f64"]],["__m128d"]]],[5,"_mm_set_pd","","Sets packed double-precision (64-bit) floating-point…",null,[[["f64"]],["__m128d"]]],[5,"_mm_setr_pd","","Sets packed double-precision (64-bit) floating-point…",null,[[["f64"]],["__m128d"]]],[5,"_mm_setzero_pd","","Returns packed double-precision (64-bit) floating-point…",null,[[],["__m128d"]]],[5,"_mm_movemask_pd","","Returns a mask of the most significant bit of each element…",null,[[["__m128d"]],["i32"]]],[5,"_mm_load_pd","","Loads 128-bits (composed of 2 packed double-precision…",null,[[],["__m128d"]]],[5,"_mm_load_sd","","Loads a 64-bit double-precision value to the low element…",null,[[],["__m128d"]]],[5,"_mm_loadh_pd","","Loads a double-precision value into the high-order bits of…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_loadl_pd","","Loads a double-precision value into the low-order bits of…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_stream_pd","","Stores a 128-bit floating point vector of `[2 x double]`…",null,[[["__m128d"]]]],[5,"_mm_store_sd","","Stores the lower 64 bits of a 128-bit vector of `[2 x…",null,[[["__m128d"]]]],[5,"_mm_store_pd","","Stores 128-bits (composed of 2 packed double-precision…",null,[[["__m128d"]]]],[5,"_mm_storeu_pd","","Stores 128-bits (composed of 2 packed double-precision…",null,[[["__m128d"]]]],[5,"_mm_store1_pd","","Stores the lower double-precision (64-bit) floating-point…",null,[[["__m128d"]]]],[5,"_mm_store_pd1","","Stores the lower double-precision (64-bit) floating-point…",null,[[["__m128d"]]]],[5,"_mm_storer_pd","","Stores 2 double-precision (64-bit) floating-point elements…",null,[[["__m128d"]]]],[5,"_mm_storeh_pd","","Stores the upper 64 bits of a 128-bit vector of `[2 x…",null,[[["__m128d"]]]],[5,"_mm_storel_pd","","Stores the lower 64 bits of a 128-bit vector of `[2 x…",null,[[["__m128d"]]]],[5,"_mm_load1_pd","","Loads a double-precision (64-bit) floating-point element…",null,[[],["__m128d"]]],[5,"_mm_load_pd1","","Loads a double-precision (64-bit) floating-point element…",null,[[],["__m128d"]]],[5,"_mm_loadr_pd","","Loads 2 double-precision (64-bit) floating-point elements…",null,[[],["__m128d"]]],[5,"_mm_loadu_pd","","Loads 128-bits (composed of 2 packed double-precision…",null,[[],["__m128d"]]],[5,"_mm_shuffle_pd","","Constructs a 128-bit floating-point vector of `[2 x…",null,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_move_sd","","Constructs a 128-bit floating-point vector of `[2 x…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_castpd_ps","","Casts a 128-bit floating-point vector of `[2 x double]`…",null,[[["__m128d"]],["__m128"]]],[5,"_mm_castpd_si128","","Casts a 128-bit floating-point vector of `[2 x double]`…",null,[[["__m128d"]],["__m128i"]]],[5,"_mm_castps_pd","","Casts a 128-bit floating-point vector of `[4 x float]`…",null,[[["__m128"]],["__m128d"]]],[5,"_mm_castps_si128","","Casts a 128-bit floating-point vector of `[4 x float]`…",null,[[["__m128"]],["__m128i"]]],[5,"_mm_castsi128_pd","","Casts a 128-bit integer vector into a 128-bit…",null,[[["__m128i"]],["__m128d"]]],[5,"_mm_castsi128_ps","","Casts a 128-bit integer vector into a 128-bit…",null,[[["__m128i"]],["__m128"]]],[5,"_mm_undefined_pd","","Returns vector of type __m128d with undefined elements.",null,[[],["__m128d"]]],[5,"_mm_undefined_si128","","Returns vector of type __m128i with undefined elements.",null,[[],["__m128i"]]],[5,"_mm_unpackhi_pd","","The resulting `__m128d` element is composed by the…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_unpacklo_pd","","The resulting `__m128d` element is composed by the…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_add_si64","","Adds two signed or unsigned 64-bit integer values,…",null,[[["__m64"]],["__m64"]]],[5,"_mm_mul_su32","","Multiplies 32-bit unsigned integer values contained in the…",null,[[["__m64"]],["__m64"]]],[5,"_mm_sub_si64","","Subtracts signed or unsigned 64-bit integer values and…",null,[[["__m64"]],["__m64"]]],[5,"_mm_cvtpi32_pd","","Converts the two signed 32-bit integer elements of a…",null,[[["__m64"]],["__m128d"]]],[5,"_mm_set_epi64","","Initializes both 64-bit values in a 128-bit vector of `[2…",null,[[["__m64"]],["__m128i"]]],[5,"_mm_set1_epi64","","Initializes both values in a 128-bit vector of `[2 x i64]`…",null,[[["__m64"]],["__m128i"]]],[5,"_mm_setr_epi64","","Constructs a 128-bit integer vector, initialized in…",null,[[["__m64"]],["__m128i"]]],[5,"_mm_movepi64_pi64","","Returns the lower 64 bits of a 128-bit integer vector as a…",null,[[["__m128i"]],["__m64"]]],[5,"_mm_movpi64_epi64","","Moves the 64-bit operand to a 128-bit integer vector,…",null,[[["__m64"]],["__m128i"]]],[5,"_mm_cvtpd_pi32","","Converts the two double-precision floating-point elements…",null,[[["__m128d"]],["__m64"]]],[5,"_mm_cvttpd_pi32","","Converts the two double-precision floating-point elements…",null,[[["__m128d"]],["__m64"]]],[5,"_mm_addsub_ps","","Alternatively add and subtract packed single-precision…",null,[[["__m128"]],["__m128"]]],[5,"_mm_addsub_pd","","Alternatively add and subtract packed double-precision…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_hadd_pd","","Horizontally adds adjacent pairs of double-precision…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_hadd_ps","","Horizontally adds adjacent pairs of single-precision…",null,[[["__m128"]],["__m128"]]],[5,"_mm_hsub_pd","","Horizontally subtract adjacent pairs of double-precision…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_hsub_ps","","Horizontally adds adjacent pairs of single-precision…",null,[[["__m128"]],["__m128"]]],[5,"_mm_lddqu_si128","","Loads 128-bits of integer data from unaligned memory. This…",null,[[],["__m128i"]]],[5,"_mm_movedup_pd","","Duplicate the low double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_loaddup_pd","","Loads a double-precision (64-bit) floating-point element…",null,[[],["__m128d"]]],[5,"_mm_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_moveldup_ps","","Duplicate even-indexed single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_abs_epi8","","Computes the absolute value of packed 8-bit signed…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_abs_epi16","","Computes the absolute value of each of the packed 16-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_abs_epi32","","Computes the absolute value of each of the packed 32-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_shuffle_epi8","","Shuffles bytes from `a` according to the content of `b`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_alignr_epi8","","Concatenate 16-byte blocks in `a` and `b` into a 32-byte…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_hadd_epi16","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_hadds_epi16","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_hadd_epi32","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_hsub_epi16","","Horizontally subtract the adjacent pairs of values…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_hsubs_epi16","","Horizontally subtract the adjacent pairs of values…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_hsub_epi32","","Horizontally subtract the adjacent pairs of values…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_maddubs_epi16","","Multiplies corresponding pairs of packed 8-bit unsigned…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_mulhrs_epi16","","Multiplies packed 16-bit signed integer values, truncate…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sign_epi8","","Negates packed 8-bit integers in `a` when the…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sign_epi16","","Negates packed 16-bit integers in `a` when the…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sign_epi32","","Negates packed 32-bit integers in `a` when the…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_abs_pi8","","Computes the absolute value of packed 8-bit integers in…",null,[[["__m64"]],["__m64"]]],[5,"_mm_abs_pi16","","Computes the absolute value of packed 8-bit integers in…",null,[[["__m64"]],["__m64"]]],[5,"_mm_abs_pi32","","Computes the absolute value of packed 32-bit integers in…",null,[[["__m64"]],["__m64"]]],[5,"_mm_shuffle_pi8","","Shuffles packed 8-bit integers in `a` according to shuffle…",null,[[["__m64"]],["__m64"]]],[5,"_mm_alignr_pi8","","Concatenates the two 64-bit integer vector operands, and…",null,[[["__m64"],["i32"]],["__m64"]]],[5,"_mm_hadd_pi16","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m64"]],["__m64"]]],[5,"_mm_hadd_pi32","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m64"]],["__m64"]]],[5,"_mm_hadds_pi16","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m64"]],["__m64"]]],[5,"_mm_hsub_pi16","","Horizontally subtracts the adjacent pairs of values…",null,[[["__m64"]],["__m64"]]],[5,"_mm_hsub_pi32","","Horizontally subtracts the adjacent pairs of values…",null,[[["__m64"]],["__m64"]]],[5,"_mm_hsubs_pi16","","Horizontally subtracts the adjacent pairs of values…",null,[[["__m64"]],["__m64"]]],[5,"_mm_maddubs_pi16","","Multiplies corresponding pairs of packed 8-bit unsigned…",null,[[["__m64"]],["__m64"]]],[5,"_mm_mulhrs_pi16","","Multiplies packed 16-bit signed integer values, truncates…",null,[[["__m64"]],["__m64"]]],[5,"_mm_sign_pi8","","Negates packed 8-bit integers in `a` when the…",null,[[["__m64"]],["__m64"]]],[5,"_mm_sign_pi16","","Negates packed 16-bit integers in `a` when the…",null,[[["__m64"]],["__m64"]]],[5,"_mm_sign_pi32","","Negates packed 32-bit integers in `a` when the…",null,[[["__m64"]],["__m64"]]],[5,"_mm_blendv_epi8","","Blend packed 8-bit integers from `a` and `b` using `mask`",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_blend_epi16","","Blend packed 16-bit integers from `a` and `b` using the…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_blendv_pd","","Blend packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_blendv_ps","","Blend packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm_blend_pd","","Blend packed double-precision (64-bit) floating-point…",null,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_blend_ps","","Blend packed single-precision (32-bit) floating-point…",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm_extract_ps","","Extracts a single-precision (32-bit) floating-point…",null,[[["i32"],["__m128"]],["i32"]]],[5,"_mm_extract_epi8","","Extracts an 8-bit integer from `a`, selected with `imm8`.…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_extract_epi32","","Extracts an 32-bit integer from `a` selected with `imm8`",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_insert_ps","","Select a single value in `a` to store at some position in…",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm_insert_epi8","","Returns a copy of `a` with the 8-bit integer from `i`…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_insert_epi32","","Returns a copy of `a` with the 32-bit integer from `i`…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_max_epi8","","Compares packed 8-bit integers in `a` and `b` and returns…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_max_epu16","","Compares packed unsigned 16-bit integers in `a` and `b`,…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_max_epi32","","Compares packed 32-bit integers in `a` and `b`, and…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_max_epu32","","Compares packed unsigned 32-bit integers in `a` and `b`,…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_min_epi8","","Compares packed 8-bit integers in `a` and `b` and returns…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_min_epu16","","Compares packed unsigned 16-bit integers in `a` and `b`,…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_min_epi32","","Compares packed 32-bit integers in `a` and `b`, and…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_min_epu32","","Compares packed unsigned 32-bit integers in `a` and `b`,…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_packus_epi32","","Converts packed 32-bit integers from `a` and `b` to packed…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi64","","Compares packed 64-bit integers in `a` and `b` for equality",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi8_epi16","","Sign extend packed 8-bit integers in `a` to packed 16-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi8_epi32","","Sign extend packed 8-bit integers in `a` to packed 32-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi8_epi64","","Sign extend packed 8-bit integers in the low 8 bytes of…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi16_epi32","","Sign extend packed 16-bit integers in `a` to packed 32-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi16_epi64","","Sign extend packed 16-bit integers in `a` to packed 64-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi32_epi64","","Sign extend packed 32-bit integers in `a` to packed 64-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu8_epi16","","Zeroes extend packed unsigned 8-bit integers in `a` to…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu8_epi32","","Zeroes extend packed unsigned 8-bit integers in `a` to…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu8_epi64","","Zeroes extend packed unsigned 8-bit integers in `a` to…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu16_epi32","","Zeroes extend packed unsigned 16-bit integers in `a` to…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu16_epi64","","Zeroes extend packed unsigned 16-bit integers in `a` to…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu32_epi64","","Zeroes extend packed unsigned 32-bit integers in `a` to…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_dp_pd","","Returns the dot product of two __m128d vectors.",null,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_dp_ps","","Returns the dot product of two __m128 vectors.",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm_floor_pd","","Round the packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_floor_ps","","Round the packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm_floor_sd","","Round the lower double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_floor_ss","","Round the lower single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm_ceil_pd","","Round the packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_ceil_ps","","Round the packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm_ceil_sd","","Round the lower double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_ceil_ss","","Round the lower single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm_round_pd","","Round the packed double-precision (64-bit) floating-point…",null,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_round_ps","","Round the packed single-precision (32-bit) floating-point…",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm_round_sd","","Round the lower double-precision (64-bit) floating-point…",null,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_round_ss","","Round the lower single-precision (32-bit) floating-point…",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm_minpos_epu16","","Finds the minimum unsigned 16-bit element in the 128-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_mul_epi32","","Multiplies the low 32-bit integers from each packed 64-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_mullo_epi32","","Multiplies the packed 32-bit integers in `a` and `b`,…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_mpsadbw_epu8","","Subtracts 8-bit unsigned integer values and computes the…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_testz_si128","","Tests whether the specified bits in a 128-bit integer…",null,[[["__m128i"]],["i32"]]],[5,"_mm_testc_si128","","Tests whether the specified bits in a 128-bit integer…",null,[[["__m128i"]],["i32"]]],[5,"_mm_testnzc_si128","","Tests whether the specified bits in a 128-bit integer…",null,[[["__m128i"]],["i32"]]],[5,"_mm_test_all_zeros","","Tests whether the specified bits in a 128-bit integer…",null,[[["__m128i"]],["i32"]]],[5,"_mm_test_all_ones","","Tests whether the specified bits in `a` 128-bit integer…",null,[[["__m128i"]],["i32"]]],[5,"_mm_test_mix_ones_zeros","","Tests whether the specified bits in a 128-bit integer…",null,[[["__m128i"]],["i32"]]],[5,"_mm_cmpistrm","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_cmpistri","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistrz","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistrc","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistrs","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistro","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistra","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpestrm","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_cmpestri","","Compares packed strings `a` and `b` with lengths `la` and…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpestrz","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpestrc","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpestrs","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpestro","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpestra","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_crc32_u8","","Starting with the initial value in `crc`, return the…",null,[[["u32"],["u8"]],["u32"]]],[5,"_mm_crc32_u16","","Starting with the initial value in `crc`, return the…",null,[[["u16"],["u32"]],["u32"]]],[5,"_mm_crc32_u32","","Starting with the initial value in `crc`, return the…",null,[[["u32"]],["u32"]]],[5,"_mm_cmpgt_epi64","","Compares packed 64-bit integers in `a` and `b` for…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_add_pd","","Adds packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_add_ps","","Adds packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_and_pd","","Computes the bitwise AND of a packed double-precision…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_and_ps","","Computes the bitwise AND of packed single-precision…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_or_pd","","Computes the bitwise OR packed double-precision (64-bit)…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_or_ps","","Computes the bitwise OR packed single-precision (32-bit)…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_shuffle_pd","","Shuffles double-precision (64-bit) floating-point elements…",null,[[["i32"],["__m256d"]],["__m256d"]]],[5,"_mm256_shuffle_ps","","Shuffles single-precision (32-bit) floating-point elements…",null,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm256_andnot_pd","","Computes the bitwise NOT of packed double-precision…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_andnot_ps","","Computes the bitwise NOT of packed single-precision…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_max_pd","","Compares packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_max_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_min_pd","","Compares packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_min_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_mul_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_mul_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_addsub_pd","","Alternatively adds and subtracts packed double-precision…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_addsub_ps","","Alternatively adds and subtracts packed single-precision…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_sub_pd","","Subtracts packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_sub_ps","","Subtracts packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_div_ps","","Computes the division of each of the 8 packed 32-bit…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_div_pd","","Computes the division of each of the 4 packed 64-bit…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_round_pd","","Rounds packed double-precision (64-bit) floating point…",null,[[["i32"],["__m256d"]],["__m256d"]]],[5,"_mm256_ceil_pd","","Rounds packed double-precision (64-bit) floating point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_floor_pd","","Rounds packed double-precision (64-bit) floating point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_round_ps","","Rounds packed single-precision (32-bit) floating point…",null,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm256_ceil_ps","","Rounds packed single-precision (32-bit) floating point…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_floor_ps","","Rounds packed single-precision (32-bit) floating point…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_sqrt_ps","","Returns the square root of packed single-precision…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_sqrt_pd","","Returns the square root of packed double-precision…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_blend_pd","","Blends packed double-precision (64-bit) floating-point…",null,[[["i32"],["__m256d"]],["__m256d"]]],[5,"_mm256_blend_ps","","Blends packed single-precision (32-bit) floating-point…",null,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm256_blendv_pd","","Blends packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_blendv_ps","","Blends packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_dp_ps","","Conditionally multiplies the packed single-precision…",null,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm256_hadd_pd","","Horizontal addition of adjacent pairs in the two packed…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_hadd_ps","","Horizontal addition of adjacent pairs in the two packed…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_hsub_pd","","Horizontal subtraction of adjacent pairs in the two packed…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_hsub_ps","","Horizontal subtraction of adjacent pairs in the two packed…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_xor_pd","","Computes the bitwise XOR of packed double-precision…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_xor_ps","","Computes the bitwise XOR of packed single-precision…",null,[[["__m256"]],["__m256"]]],[5,"_mm_cmp_pd","","Compares packed double-precision (64-bit) floating-point…",null,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm256_cmp_pd","","Compares packed double-precision (64-bit) floating-point…",null,[[["i32"],["__m256d"]],["__m256d"]]],[5,"_mm_cmp_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm256_cmp_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm_cmp_sd","","Compares the lower double-precision (64-bit)…",null,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_cmp_ss","","Compares the lower single-precision (32-bit)…",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm256_cvtepi32_pd","","Converts packed 32-bit integers in `a` to packed…",null,[[["__m128i"]],["__m256d"]]],[5,"_mm256_cvtepi32_ps","","Converts packed 32-bit integers in `a` to packed…",null,[[["__m256i"]],["__m256"]]],[5,"_mm256_cvtpd_ps","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m128"]]],[5,"_mm256_cvtps_epi32","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256i"]]],[5,"_mm256_cvtps_pd","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m256d"]]],[5,"_mm256_cvttpd_epi32","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m128i"]]],[5,"_mm256_cvtpd_epi32","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m128i"]]],[5,"_mm256_cvttps_epi32","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256i"]]],[5,"_mm256_extractf128_ps","","Extracts 128 bits (composed of 4 packed single-precision…",null,[[["__m256"],["i32"]],["__m128"]]],[5,"_mm256_extractf128_pd","","Extracts 128 bits (composed of 2 packed double-precision…",null,[[["i32"],["__m256d"]],["__m128d"]]],[5,"_mm256_extractf128_si256","","Extracts 128 bits (composed of integer data) from `a`,…",null,[[["__m256i"],["i32"]],["__m128i"]]],[5,"_mm256_zeroall","","Zeroes the contents of all XMM or YMM registers.",null,[[]]],[5,"_mm256_zeroupper","","Zeroes the upper 128 bits of all YMM registers; the lower…",null,[[]]],[5,"_mm256_permutevar_ps","","Shuffles single-precision (32-bit) floating-point elements…",null,[[["__m256"],["__m256i"]],["__m256"]]],[5,"_mm_permutevar_ps","","Shuffles single-precision (32-bit) floating-point elements…",null,[[["__m128i"],["__m128"]],["__m128"]]],[5,"_mm256_permute_ps","","Shuffles single-precision (32-bit) floating-point elements…",null,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm_permute_ps","","Shuffles single-precision (32-bit) floating-point elements…",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm256_permutevar_pd","","Shuffles double-precision (64-bit) floating-point elements…",null,[[["__m256i"],["__m256d"]],["__m256d"]]],[5,"_mm_permutevar_pd","","Shuffles double-precision (64-bit) floating-point elements…",null,[[["__m128d"],["__m128i"]],["__m128d"]]],[5,"_mm256_permute_pd","","Shuffles double-precision (64-bit) floating-point elements…",null,[[["i32"],["__m256d"]],["__m256d"]]],[5,"_mm_permute_pd","","Shuffles double-precision (64-bit) floating-point elements…",null,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm256_permute2f128_ps","","Shuffles 256 bits (composed of 8 packed single-precision…",null,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm256_permute2f128_pd","","Shuffles 256 bits (composed of 4 packed double-precision…",null,[[["i32"],["__m256d"]],["__m256d"]]],[5,"_mm256_permute2f128_si256","","Shuffles 258-bits (composed of integer data) selected by…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_broadcast_ss","","Broadcasts a single-precision (32-bit) floating-point…",null,[[["f32"]],["__m256"]]],[5,"_mm_broadcast_ss","","Broadcasts a single-precision (32-bit) floating-point…",null,[[["f32"]],["__m128"]]],[5,"_mm256_broadcast_sd","","Broadcasts a double-precision (64-bit) floating-point…",null,[[["f64"]],["__m256d"]]],[5,"_mm256_broadcast_ps","","Broadcasts 128 bits from memory (composed of 4 packed…",null,[[["__m128"]],["__m256"]]],[5,"_mm256_broadcast_pd","","Broadcasts 128 bits from memory (composed of 2 packed…",null,[[["__m128d"]],["__m256d"]]],[5,"_mm256_insertf128_ps","","Copies `a` to result, then inserts 128 bits (composed of 4…",null,[[["__m256"],["i32"],["__m128"]],["__m256"]]],[5,"_mm256_insertf128_pd","","Copies `a` to result, then inserts 128 bits (composed of 2…",null,[[["i32"],["__m128d"],["__m256d"]],["__m256d"]]],[5,"_mm256_insertf128_si256","","Copies `a` to result, then inserts 128 bits from `b` into…",null,[[["i32"],["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_insert_epi8","","Copies `a` to result, and inserts the 8-bit integer `i`…",null,[[["i8"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_insert_epi16","","Copies `a` to result, and inserts the 16-bit integer `i`…",null,[[["i32"],["__m256i"],["i16"]],["__m256i"]]],[5,"_mm256_insert_epi32","","Copies `a` to result, and inserts the 32-bit integer `i`…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_load_pd","","Loads 256-bits (composed of 4 packed double-precision…",null,[[],["__m256d"]]],[5,"_mm256_store_pd","","Stores 256-bits (composed of 4 packed double-precision…",null,[[["__m256d"]]]],[5,"_mm256_load_ps","","Loads 256-bits (composed of 8 packed single-precision…",null,[[],["__m256"]]],[5,"_mm256_store_ps","","Stores 256-bits (composed of 8 packed single-precision…",null,[[["__m256"]]]],[5,"_mm256_loadu_pd","","Loads 256-bits (composed of 4 packed double-precision…",null,[[],["__m256d"]]],[5,"_mm256_storeu_pd","","Stores 256-bits (composed of 4 packed double-precision…",null,[[["__m256d"]]]],[5,"_mm256_loadu_ps","","Loads 256-bits (composed of 8 packed single-precision…",null,[[],["__m256"]]],[5,"_mm256_storeu_ps","","Stores 256-bits (composed of 8 packed single-precision…",null,[[["__m256"]]]],[5,"_mm256_load_si256","","Loads 256-bits of integer data from memory into result.…",null,[[],["__m256i"]]],[5,"_mm256_store_si256","","Stores 256-bits of integer data from `a` into memory.…",null,[[["__m256i"]]]],[5,"_mm256_loadu_si256","","Loads 256-bits of integer data from memory into result.…",null,[[],["__m256i"]]],[5,"_mm256_storeu_si256","","Stores 256-bits of integer data from `a` into memory.…",null,[[["__m256i"]]]],[5,"_mm256_maskload_pd","","Loads packed double-precision (64-bit) floating-point…",null,[[["__m256i"]],["__m256d"]]],[5,"_mm256_maskstore_pd","","Stores packed double-precision (64-bit) floating-point…",null,[[["__m256d"],["__m256i"]]]],[5,"_mm_maskload_pd","","Loads packed double-precision (64-bit) floating-point…",null,[[["__m128i"]],["__m128d"]]],[5,"_mm_maskstore_pd","","Stores packed double-precision (64-bit) floating-point…",null,[[["__m128d"],["__m128i"]]]],[5,"_mm256_maskload_ps","","Loads packed single-precision (32-bit) floating-point…",null,[[["__m256i"]],["__m256"]]],[5,"_mm256_maskstore_ps","","Stores packed single-precision (32-bit) floating-point…",null,[[["__m256"],["__m256i"]]]],[5,"_mm_maskload_ps","","Loads packed single-precision (32-bit) floating-point…",null,[[["__m128i"]],["__m128"]]],[5,"_mm_maskstore_ps","","Stores packed single-precision (32-bit) floating-point…",null,[[["__m128"],["__m128i"]]]],[5,"_mm256_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit)…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_moveldup_ps","","Duplicate even-indexed single-precision (32-bit)…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_movedup_pd","","Duplicate even-indexed double-precision (64-bit)…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_lddqu_si256","","Loads 256-bits of integer data from unaligned memory into…",null,[[],["__m256i"]]],[5,"_mm256_stream_si256","","Moves integer data from a 256-bit integer vector to a…",null,[[["__m256i"]]]],[5,"_mm256_stream_pd","","Moves double-precision values from a 256-bit vector of `[4…",null,[[["__m256d"]]]],[5,"_mm256_stream_ps","","Moves single-precision floating point values from a…",null,[[["__m256"]]]],[5,"_mm256_rcp_ps","","Computes the approximate reciprocal of packed…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_rsqrt_ps","","Computes the approximate reciprocal square root of packed…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_unpackhi_pd","","Unpacks and interleave double-precision (64-bit)…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_unpackhi_ps","","Unpacks and interleave single-precision (32-bit)…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_unpacklo_pd","","Unpacks and interleave double-precision (64-bit)…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_unpacklo_ps","","Unpacks and interleave single-precision (32-bit)…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_testz_si256","","Computes the bitwise AND of 256 bits (representing integer…",null,[[["__m256i"]],["i32"]]],[5,"_mm256_testc_si256","","Computes the bitwise AND of 256 bits (representing integer…",null,[[["__m256i"]],["i32"]]],[5,"_mm256_testnzc_si256","","Computes the bitwise AND of 256 bits (representing integer…",null,[[["__m256i"]],["i32"]]],[5,"_mm256_testz_pd","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256d"]],["i32"]]],[5,"_mm256_testc_pd","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256d"]],["i32"]]],[5,"_mm256_testnzc_pd","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256d"]],["i32"]]],[5,"_mm_testz_pd","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128d"]],["i32"]]],[5,"_mm_testc_pd","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128d"]],["i32"]]],[5,"_mm_testnzc_pd","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128d"]],["i32"]]],[5,"_mm256_testz_ps","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256"]],["i32"]]],[5,"_mm256_testc_ps","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256"]],["i32"]]],[5,"_mm256_testnzc_ps","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256"]],["i32"]]],[5,"_mm_testz_ps","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128"]],["i32"]]],[5,"_mm_testc_ps","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128"]],["i32"]]],[5,"_mm_testnzc_ps","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128"]],["i32"]]],[5,"_mm256_movemask_pd","","Sets each bit of the returned mask based on the most…",null,[[["__m256d"]],["i32"]]],[5,"_mm256_movemask_ps","","Sets each bit of the returned mask based on the most…",null,[[["__m256"]],["i32"]]],[5,"_mm256_setzero_pd","","Returns vector of type __m256d with all elements set to…",null,[[],["__m256d"]]],[5,"_mm256_setzero_ps","","Returns vector of type __m256 with all elements set to zero.",null,[[],["__m256"]]],[5,"_mm256_setzero_si256","","Returns vector of type __m256i with all elements set to…",null,[[],["__m256i"]]],[5,"_mm256_set_pd","","Sets packed double-precision (64-bit) floating-point…",null,[[["f64"]],["__m256d"]]],[5,"_mm256_set_ps","","Sets packed single-precision (32-bit) floating-point…",null,[[["f32"]],["__m256"]]],[5,"_mm256_set_epi8","","Sets packed 8-bit integers in returned vector with the…",null,[[["i8"]],["__m256i"]]],[5,"_mm256_set_epi16","","Sets packed 16-bit integers in returned vector with the…",null,[[["i16"]],["__m256i"]]],[5,"_mm256_set_epi32","","Sets packed 32-bit integers in returned vector with the…",null,[[["i32"]],["__m256i"]]],[5,"_mm256_set_epi64x","","Sets packed 64-bit integers in returned vector with the…",null,[[["i64"]],["__m256i"]]],[5,"_mm256_setr_pd","","Sets packed double-precision (64-bit) floating-point…",null,[[["f64"]],["__m256d"]]],[5,"_mm256_setr_ps","","Sets packed single-precision (32-bit) floating-point…",null,[[["f32"]],["__m256"]]],[5,"_mm256_setr_epi8","","Sets packed 8-bit integers in returned vector with the…",null,[[["i8"]],["__m256i"]]],[5,"_mm256_setr_epi16","","Sets packed 16-bit integers in returned vector with the…",null,[[["i16"]],["__m256i"]]],[5,"_mm256_setr_epi32","","Sets packed 32-bit integers in returned vector with the…",null,[[["i32"]],["__m256i"]]],[5,"_mm256_setr_epi64x","","Sets packed 64-bit integers in returned vector with the…",null,[[["i64"]],["__m256i"]]],[5,"_mm256_set1_pd","","Broadcasts double-precision (64-bit) floating-point value…",null,[[["f64"]],["__m256d"]]],[5,"_mm256_set1_ps","","Broadcasts single-precision (32-bit) floating-point value…",null,[[["f32"]],["__m256"]]],[5,"_mm256_set1_epi8","","Broadcasts 8-bit integer `a` to all elements of returned…",null,[[["i8"]],["__m256i"]]],[5,"_mm256_set1_epi16","","Broadcasts 16-bit integer `a` to all all elements of…",null,[[["i16"]],["__m256i"]]],[5,"_mm256_set1_epi32","","Broadcasts 32-bit integer `a` to all elements of returned…",null,[[["i32"]],["__m256i"]]],[5,"_mm256_set1_epi64x","","Broadcasts 64-bit integer `a` to all elements of returned…",null,[[["i64"]],["__m256i"]]],[5,"_mm256_castpd_ps","","Cast vector of type __m256d to type __m256.",null,[[["__m256d"]],["__m256"]]],[5,"_mm256_castps_pd","","Cast vector of type __m256 to type __m256d.",null,[[["__m256"]],["__m256d"]]],[5,"_mm256_castps_si256","","Casts vector of type __m256 to type __m256i.",null,[[["__m256"]],["__m256i"]]],[5,"_mm256_castsi256_ps","","Casts vector of type __m256i to type __m256.",null,[[["__m256i"]],["__m256"]]],[5,"_mm256_castpd_si256","","Casts vector of type __m256d to type __m256i.",null,[[["__m256d"]],["__m256i"]]],[5,"_mm256_castsi256_pd","","Casts vector of type __m256i to type __m256d.",null,[[["__m256i"]],["__m256d"]]],[5,"_mm256_castps256_ps128","","Casts vector of type __m256 to type __m128.",null,[[["__m256"]],["__m128"]]],[5,"_mm256_castpd256_pd128","","Casts vector of type __m256d to type __m128d.",null,[[["__m256d"]],["__m128d"]]],[5,"_mm256_castsi256_si128","","Casts vector of type __m256i to type __m128i.",null,[[["__m256i"]],["__m128i"]]],[5,"_mm256_castps128_ps256","","Casts vector of type __m128 to type __m256; the upper 128…",null,[[["__m128"]],["__m256"]]],[5,"_mm256_castpd128_pd256","","Casts vector of type __m128d to type __m256d; the upper…",null,[[["__m128d"]],["__m256d"]]],[5,"_mm256_castsi128_si256","","Casts vector of type __m128i to type __m256i; the upper…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_zextps128_ps256","","Constructs a 256-bit floating-point vector of `[8 x…",null,[[["__m128"]],["__m256"]]],[5,"_mm256_zextsi128_si256","","Constructs a 256-bit integer vector from a 128-bit integer…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_zextpd128_pd256","","Constructs a 256-bit floating-point vector of `[4 x…",null,[[["__m128d"]],["__m256d"]]],[5,"_mm256_undefined_ps","","Returns vector of type `__m256` with undefined elements.",null,[[],["__m256"]]],[5,"_mm256_undefined_pd","","Returns vector of type `__m256d` with undefined elements.",null,[[],["__m256d"]]],[5,"_mm256_undefined_si256","","Returns vector of type __m256i with undefined elements.",null,[[],["__m256i"]]],[5,"_mm256_set_m128","","Sets packed __m256 returned vector with the supplied values.",null,[[["__m128"]],["__m256"]]],[5,"_mm256_set_m128d","","Sets packed __m256d returned vector with the supplied…",null,[[["__m128d"]],["__m256d"]]],[5,"_mm256_set_m128i","","Sets packed __m256i returned vector with the supplied…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_setr_m128","","Sets packed __m256 returned vector with the supplied values.",null,[[["__m128"]],["__m256"]]],[5,"_mm256_setr_m128d","","Sets packed __m256d returned vector with the supplied…",null,[[["__m128d"]],["__m256d"]]],[5,"_mm256_setr_m128i","","Sets packed __m256i returned vector with the supplied…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_loadu2_m128","","Loads two 128-bit values (composed of 4 packed…",null,[[],["__m256"]]],[5,"_mm256_loadu2_m128d","","Loads two 128-bit values (composed of 2 packed…",null,[[],["__m256d"]]],[5,"_mm256_loadu2_m128i","","Loads two 128-bit values (composed of integer data) from…",null,[[],["__m256i"]]],[5,"_mm256_storeu2_m128","","Stores the high and low 128-bit halves (each composed of 4…",null,[[["__m256"]]]],[5,"_mm256_storeu2_m128d","","Stores the high and low 128-bit halves (each composed of 2…",null,[[["__m256d"]]]],[5,"_mm256_storeu2_m128i","","Stores the high and low 128-bit halves (each composed of…",null,[[["__m256i"]]]],[5,"_mm256_cvtss_f32","","Returns the first element of the input vector of `[8 x…",null,[[["__m256"]],["f32"]]],[5,"_mm256_abs_epi32","","Computes the absolute values of packed 32-bit integers in…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_abs_epi16","","Computes the absolute values of packed 16-bit integers in…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_abs_epi8","","Computes the absolute values of packed 8-bit integers in…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi64","","Adds packed 64-bit integers in `a` and `b`.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi32","","Adds packed 32-bit integers in `a` and `b`.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi16","","Adds packed 16-bit integers in `a` and `b`.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi8","","Adds packed 8-bit integers in `a` and `b`.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epi8","","Adds packed 8-bit integers in `a` and `b` using saturation.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epi16","","Adds packed 16-bit integers in `a` and `b` using saturation.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epu8","","Adds packed unsigned 8-bit integers in `a` and `b` using…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epu16","","Adds packed unsigned 16-bit integers in `a` and `b` using…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_alignr_epi8","","Concatenates pairs of 16-byte blocks in `a` and `b` into a…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_and_si256","","Computes the bitwise AND of 256 bits (representing integer…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_andnot_si256","","Computes the bitwise NOT of 256 bits (representing integer…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_avg_epu16","","Averages packed unsigned 16-bit integers in `a` and `b`.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_avg_epu8","","Averages packed unsigned 8-bit integers in `a` and `b`.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm_blend_epi32","","Blends packed 32-bit integers from `a` and `b` using…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm256_blend_epi32","","Blends packed 32-bit integers from `a` and `b` using…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_blend_epi16","","Blends packed 16-bit integers from `a` and `b` using…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_blendv_epi8","","Blends packed 8-bit integers from `a` and `b` using `mask`.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm_broadcastb_epi8","","Broadcasts the low packed 8-bit integer from `a` to all…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastb_epi8","","Broadcasts the low packed 8-bit integer from `a` to all…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastd_epi32","","Broadcasts the low packed 32-bit integer from `a` to all…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastd_epi32","","Broadcasts the low packed 32-bit integer from `a` to all…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastq_epi64","","Broadcasts the low packed 64-bit integer from `a` to all…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastq_epi64","","Broadcasts the low packed 64-bit integer from `a` to all…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastsd_pd","","Broadcasts the low double-precision (64-bit)…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm256_broadcastsd_pd","","Broadcasts the low double-precision (64-bit)…",null,[[["__m128d"]],["__m256d"]]],[5,"_mm256_broadcastsi128_si256","","Broadcasts 128 bits of integer data from a to all 128-bit…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastss_ps","","Broadcasts the low single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm256_broadcastss_ps","","Broadcasts the low single-precision (32-bit)…",null,[[["__m128"]],["__m256"]]],[5,"_mm_broadcastw_epi16","","Broadcasts the low packed 16-bit integer from a to all…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastw_epi16","","Broadcasts the low packed 16-bit integer from a to all…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi64","","Compares packed 64-bit integers in `a` and `b` for equality.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi32","","Compares packed 32-bit integers in `a` and `b` for equality.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi16","","Compares packed 16-bit integers in `a` and `b` for equality.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi8","","Compares packed 8-bit integers in `a` and `b` for equality.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi64","","Compares packed 64-bit integers in `a` and `b` for…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi32","","Compares packed 32-bit integers in `a` and `b` for…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi16","","Compares packed 16-bit integers in `a` and `b` for…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi8","","Compares packed 8-bit integers in `a` and `b` for…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_cvtepi16_epi32","","Sign-extend 16-bit integers to 32-bit integers.",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi16_epi64","","Sign-extend 16-bit integers to 64-bit integers.",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi32_epi64","","Sign-extend 32-bit integers to 64-bit integers.",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi8_epi16","","Sign-extend 8-bit integers to 16-bit integers.",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi8_epi32","","Sign-extend 8-bit integers to 32-bit integers.",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi8_epi64","","Sign-extend 8-bit integers to 64-bit integers.",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu16_epi32","","Zeroes extend packed unsigned 16-bit integers in `a` to…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu16_epi64","","Zero-extend the lower four unsigned 16-bit integers in `a`…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu32_epi64","","Zero-extend unsigned 32-bit integers in `a` to 64-bit…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu8_epi16","","Zero-extend unsigned 8-bit integers in `a` to 16-bit…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu8_epi32","","Zero-extend the lower eight unsigned 8-bit integers in `a`…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu8_epi64","","Zero-extend the lower four unsigned 8-bit integers in `a`…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_extracti128_si256","","Extracts 128 bits (of integer data) from `a` selected with…",null,[[["__m256i"],["i32"]],["__m128i"]]],[5,"_mm256_hadd_epi16","","Horizontally adds adjacent pairs of 16-bit integers in `a`…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_hadd_epi32","","Horizontally adds adjacent pairs of 32-bit integers in `a`…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_hadds_epi16","","Horizontally adds adjacent pairs of 16-bit integers in `a`…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_hsub_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_hsub_epi32","","Horizontally subtract adjacent pairs of 32-bit integers in…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_hsubs_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm_i32gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["i32"],["__m128i"]],["__m128i"]]],[5,"_mm_mask_i32gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["i32"],["__m128i"]],["__m128i"]]],[5,"_mm256_i32gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["i32"],["__m256i"]],["__m256i"]]],[5,"_mm256_mask_i32gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["i32"],["__m256i"]],["__m256i"]]],[5,"_mm_i32gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m128i"],["i32"]],["__m128"]]],[5,"_mm_mask_i32gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m128"],["i32"],["__m128i"]],["__m128"]]],[5,"_mm256_i32gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m256i"],["i32"]],["__m256"]]],[5,"_mm256_mask_i32gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m256i"],["i32"],["__m256"]],["__m256"]]],[5,"_mm_i32gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_mask_i32gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm256_i32gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i"],["i32"]],["__m256i"]]],[5,"_mm256_mask_i32gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m256i"],["i32"],["__m128i"]],["__m256i"]]],[5,"_mm_i32gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m128i"],["i32"]],["__m128d"]]],[5,"_mm_mask_i32gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["i32"],["__m128d"],["__m128i"]],["__m128d"]]],[5,"_mm256_i32gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m128i"],["i32"]],["__m256d"]]],[5,"_mm256_mask_i32gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["i32"],["__m128i"],["__m256d"]],["__m256d"]]],[5,"_mm_i64gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["i32"],["__m128i"]],["__m128i"]]],[5,"_mm_mask_i64gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["i32"],["__m128i"]],["__m128i"]]],[5,"_mm256_i64gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["i32"],["__m256i"]],["__m128i"]]],[5,"_mm256_mask_i64gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["__m256i"],["i32"],["__m128i"]],["__m128i"]]],[5,"_mm_i64gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m128i"],["i32"]],["__m128"]]],[5,"_mm_mask_i64gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m128"],["i32"],["__m128i"]],["__m128"]]],[5,"_mm256_i64gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m256i"],["i32"]],["__m128"]]],[5,"_mm256_mask_i64gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m256i"],["__m128"],["i32"]],["__m128"]]],[5,"_mm_i64gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_mask_i64gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm256_i64gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_mask_i64gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm_i64gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m128i"],["i32"]],["__m128d"]]],[5,"_mm_mask_i64gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["i32"],["__m128d"],["__m128i"]],["__m128d"]]],[5,"_mm256_i64gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m256i"],["i32"]],["__m256d"]]],[5,"_mm256_mask_i64gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m256i"],["i32"],["__m256d"]],["__m256d"]]],[5,"_mm256_inserti128_si256","","Copies `a` to `dst`, then insert 128 bits (of integer…",null,[[["i32"],["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_madd_epi16","","Multiplies packed signed 16-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_maddubs_epi16","","Vertically multiplies each unsigned 8-bit integer from `a`…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm_maskload_epi32","","Loads packed 32-bit integers from memory pointed by…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_maskload_epi32","","Loads packed 32-bit integers from memory pointed by…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm_maskload_epi64","","Loads packed 64-bit integers from memory pointed by…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_maskload_epi64","","Loads packed 64-bit integers from memory pointed by…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm_maskstore_epi32","","Stores packed 32-bit integers from `a` into memory pointed…",null,[[["__m128i"]]]],[5,"_mm256_maskstore_epi32","","Stores packed 32-bit integers from `a` into memory pointed…",null,[[["__m256i"]]]],[5,"_mm_maskstore_epi64","","Stores packed 64-bit integers from `a` into memory pointed…",null,[[["__m128i"]]]],[5,"_mm256_maskstore_epi64","","Stores packed 64-bit integers from `a` into memory pointed…",null,[[["__m256i"]]]],[5,"_mm256_max_epi16","","Compares packed 16-bit integers in `a` and `b`, and…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_max_epi32","","Compares packed 32-bit integers in `a` and `b`, and…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_max_epi8","","Compares packed 8-bit integers in `a` and `b`, and returns…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_max_epu16","","Compares packed unsigned 16-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_max_epu32","","Compares packed unsigned 32-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_max_epu8","","Compares packed unsigned 8-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_min_epi16","","Compares packed 16-bit integers in `a` and `b`, and…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_min_epi32","","Compares packed 32-bit integers in `a` and `b`, and…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_min_epi8","","Compares packed 8-bit integers in `a` and `b`, and returns…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_min_epu16","","Compares packed unsigned 16-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_min_epu32","","Compares packed unsigned 32-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_min_epu8","","Compares packed unsigned 8-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_movemask_epi8","","Creates mask from the most significant bit of each 8-bit…",null,[[["__m256i"]],["i32"]]],[5,"_mm256_mpsadbw_epu8","","Computes the sum of absolute differences (SADs) of…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_mul_epi32","","Multiplies the low 32-bit integers from each packed 64-bit…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_mul_epu32","","Multiplies the low unsigned 32-bit integers from each…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_mulhi_epi16","","Multiplies the packed 16-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_mulhi_epu16","","Multiplies the packed unsigned 16-bit integers in `a` and…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_mullo_epi16","","Multiplies the packed 16-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_mullo_epi32","","Multiplies the packed 32-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_mulhrs_epi16","","Multiplies packed 16-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_or_si256","","Computes the bitwise OR of 256 bits (representing integer…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_packs_epi16","","Converts packed 16-bit integers from `a` and `b` to packed…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_packs_epi32","","Converts packed 32-bit integers from `a` and `b` to packed…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_packus_epi16","","Converts packed 16-bit integers from `a` and `b` to packed…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_packus_epi32","","Converts packed 32-bit integers from `a` and `b` to packed…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_permutevar8x32_epi32","","Permutes packed 32-bit integers from `a` according to the…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_permute4x64_epi64","","Permutes 64-bit integers from `a` using control mask `imm8`.",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_permute2x128_si256","","Shuffles 128-bits of integer data selected by `imm8` from…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_permute4x64_pd","","Shuffles 64-bit floating-point elements in `a` across…",null,[[["i32"],["__m256d"]],["__m256d"]]],[5,"_mm256_permutevar8x32_ps","","Shuffles eight 32-bit foating-point elements in `a` across…",null,[[["__m256"],["__m256i"]],["__m256"]]],[5,"_mm256_sad_epu8","","Computes the absolute differences of packed unsigned 8-bit…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_shuffle_epi8","","Shuffles bytes from `a` according to the content of `b`.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_shuffle_epi32","","Shuffles 32-bit integers in 128-bit lanes of `a` using the…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_shufflehi_epi16","","Shuffles 16-bit integers in the high 64 bits of 128-bit…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_shufflelo_epi16","","Shuffles 16-bit integers in the low 64 bits of 128-bit…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_sign_epi16","","Negates packed 16-bit integers in `a` when the…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_sign_epi32","","Negates packed 32-bit integers in `a` when the…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_sign_epi8","","Negates packed 8-bit integers in `a` when the…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_sll_epi16","","Shifts packed 16-bit integers in `a` left by `count` while…",null,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_sll_epi32","","Shifts packed 32-bit integers in `a` left by `count` while…",null,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_sll_epi64","","Shifts packed 64-bit integers in `a` left by `count` while…",null,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_slli_epi16","","Shifts packed 16-bit integers in `a` left by `imm8` while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_slli_epi32","","Shifts packed 32-bit integers in `a` left by `imm8` while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_slli_epi64","","Shifts packed 64-bit integers in `a` left by `imm8` while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_slli_si256","","Shifts 128-bit lanes in `a` left by `imm8` bytes while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_bslli_epi128","","Shifts 128-bit lanes in `a` left by `imm8` bytes while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm_sllv_epi32","","Shifts packed 32-bit integers in `a` left by the amount…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_sllv_epi32","","Shifts packed 32-bit integers in `a` left by the amount…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm_sllv_epi64","","Shifts packed 64-bit integers in `a` left by the amount…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_sllv_epi64","","Shifts packed 64-bit integers in `a` left by the amount…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_sra_epi16","","Shifts packed 16-bit integers in `a` right by `count`…",null,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_sra_epi32","","Shifts packed 32-bit integers in `a` right by `count`…",null,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srai_epi16","","Shifts packed 16-bit integers in `a` right by `imm8` while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srai_epi32","","Shifts packed 32-bit integers in `a` right by `imm8` while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm_srav_epi32","","Shifts packed 32-bit integers in `a` right by the amount…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_srav_epi32","","Shifts packed 32-bit integers in `a` right by the amount…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_srli_si256","","Shifts 128-bit lanes in `a` right by `imm8` bytes while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_bsrli_epi128","","Shifts 128-bit lanes in `a` right by `imm8` bytes while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srl_epi16","","Shifts packed 16-bit integers in `a` right by `count`…",null,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srl_epi32","","Shifts packed 32-bit integers in `a` right by `count`…",null,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srl_epi64","","Shifts packed 64-bit integers in `a` right by `count`…",null,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srli_epi16","","Shifts packed 16-bit integers in `a` right by `imm8` while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srli_epi32","","Shifts packed 32-bit integers in `a` right by `imm8` while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srli_epi64","","Shifts packed 64-bit integers in `a` right by `imm8` while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm_srlv_epi32","","Shifts packed 32-bit integers in `a` right by the amount…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_srlv_epi32","","Shifts packed 32-bit integers in `a` right by the amount…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm_srlv_epi64","","Shifts packed 64-bit integers in `a` right by the amount…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_srlv_epi64","","Shifts packed 64-bit integers in `a` right by the amount…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 16-bit…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 16-bit…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi8","","Subtract packed 8-bit integers in `b` from packed 16-bit…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi8","","Unpacks and interleave 8-bit integers from the high half…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi8","","Unpacks and interleave 8-bit integers from the low half of…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi16","","Unpacks and interleave 16-bit integers from the high half…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi16","","Unpacks and interleave 16-bit integers from the low half…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi32","","Unpacks and interleave 32-bit integers from the high half…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi32","","Unpacks and interleave 32-bit integers from the low half…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi64","","Unpacks and interleave 64-bit integers from the high half…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi64","","Unpacks and interleave 64-bit integers from the low half…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_xor_si256","","Computes the bitwise XOR of 256 bits (representing integer…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_extract_epi8","","Extracts an 8-bit integer from `a`, selected with `imm8`.…",null,[[["__m256i"],["i32"]],["i8"]]],[5,"_mm256_extract_epi16","","Extracts a 16-bit integer from `a`, selected with `imm8`.…",null,[[["__m256i"],["i32"]],["i16"]]],[5,"_mm256_extract_epi32","","Extracts a 32-bit integer from `a`, selected with `imm8`.",null,[[["__m256i"],["i32"]],["i32"]]],[5,"_mm256_cvtsd_f64","","Returns the first element of the input vector of `[4 x…",null,[[["__m256d"]],["f64"]]],[5,"_mm256_cvtsi256_si32","","Returns the first element of the input vector of `[8 x…",null,[[["__m256i"]],["i32"]]],[5,"_mm_fmadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm256_fmadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm_fmadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm256_fmadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm_fmadd_sd","","Multiplies the lower double-precision (64-bit)…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_fmadd_ss","","Multiplies the lower single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_fmaddsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm256_fmaddsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm_fmaddsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm256_fmaddsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm_fmsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm256_fmsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm_fmsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm256_fmsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm_fmsub_sd","","Multiplies the lower double-precision (64-bit)…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_fmsub_ss","","Multiplies the lower single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_fmsubadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm256_fmsubadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm_fmsubadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm256_fmsubadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm_fnmadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm256_fnmadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm_fnmadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm256_fnmadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm_fnmadd_sd","","Multiplies the lower double-precision (64-bit)…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_fnmadd_ss","","Multiplies the lower single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_fnmsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm256_fnmsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm_fnmsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm256_fnmsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm_fnmsub_sd","","Multiplies the lower double-precision (64-bit)…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_fnmsub_ss","","Multiplies the lower single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_lzcnt_u32","","Counts the leading most significant zero bits.",null,[[["u32"]],["u32"]]],[5,"_popcnt32","","Counts the bits that are set.",null,[[["i32"]],["i32"]]],[5,"_bextr_u32","","Extracts bits in range [`start`, `start` + `length`) from…",null,[[["u32"]],["u32"]]],[5,"_bextr2_u32","","Extracts bits of `a` specified by `control` into the least…",null,[[["u32"]],["u32"]]],[5,"_andn_u32","","Bitwise logical `AND` of inverted `a` with `b`.",null,[[["u32"]],["u32"]]],[5,"_blsi_u32","","Extracts lowest set isolated bit.",null,[[["u32"]],["u32"]]],[5,"_blsmsk_u32","","Gets mask up to lowest set bit.",null,[[["u32"]],["u32"]]],[5,"_blsr_u32","","Resets the lowest set bit of `x`.",null,[[["u32"]],["u32"]]],[5,"_tzcnt_u32","","Counts the number of trailing least significant zero bits.",null,[[["u32"]],["u32"]]],[5,"_mm_tzcnt_32","","Counts the number of trailing least significant zero bits.",null,[[["u32"]],["i32"]]],[5,"_mulx_u32","","Unsigned multiply without affecting flags.",null,[[["u32"],["u32"]],["u32"]]],[5,"_bzhi_u32","","Zeroes higher bits of `a` >= `index`.",null,[[["u32"]],["u32"]]],[5,"_pdep_u32","","Scatter contiguous low order bits of `a` to the result at…",null,[[["u32"]],["u32"]]],[5,"_pext_u32","","Gathers the bits of `x` specified by the `mask` into the…",null,[[["u32"]],["u32"]]],[5,"_mm_extract_si64","","Extracts the bit range specified by `y` from the lower 64…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_insert_si64","","Inserts the `[length:0]` bits of `y` into `x` at `index`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_stream_sd","","Non-temporal store of `a.0` into `p`.",null,[[["__m128d"]]]],[5,"_mm_stream_ss","","Non-temporal store of `a.0` into `p`.",null,[[["__m128"]]]],[5,"_blcfill_u32","","Clears all bits below the least significant zero bit of `x`.",null,[[["u32"]],["u32"]]],[5,"_blci_u32","","Sets all bits of `x` to 1 except for the least significant…",null,[[["u32"]],["u32"]]],[5,"_blcic_u32","","Sets the least significant zero bit of `x` and clears all…",null,[[["u32"]],["u32"]]],[5,"_blcmsk_u32","","Sets the least significant zero bit of `x` and clears all…",null,[[["u32"]],["u32"]]],[5,"_blcs_u32","","Sets the least significant zero bit of `x`.",null,[[["u32"]],["u32"]]],[5,"_blsfill_u32","","Sets all bits of `x` below the least significant one.",null,[[["u32"]],["u32"]]],[5,"_blsic_u32","","Clears least significant bit and sets all other bits.",null,[[["u32"]],["u32"]]],[5,"_t1mskc_u32","","Clears all bits below the least significant zero of `x`…",null,[[["u32"]],["u32"]]],[5,"_tzmsk_u32","","Sets all bits below the least significant one of `x` and…",null,[[["u32"]],["u32"]]],[5,"_mm_setzero_si64","","Constructs a 64-bit integer vector initialized to zero.",null,[[],["__m64"]]],[5,"_mm_add_pi8","","Adds packed 8-bit integers in `a` and `b`.",null,[[["__m64"]],["__m64"]]],[5,"_m_paddb","","Adds packed 8-bit integers in `a` and `b`.",null,[[["__m64"]],["__m64"]]],[5,"_mm_add_pi16","","Adds packed 16-bit integers in `a` and `b`.",null,[[["__m64"]],["__m64"]]],[5,"_m_paddw","","Adds packed 16-bit integers in `a` and `b`.",null,[[["__m64"]],["__m64"]]],[5,"_mm_add_pi32","","Adds packed 32-bit integers in `a` and `b`.",null,[[["__m64"]],["__m64"]]],[5,"_m_paddd","","Adds packed 32-bit integers in `a` and `b`.",null,[[["__m64"]],["__m64"]]],[5,"_mm_adds_pi8","","Adds packed 8-bit integers in `a` and `b` using saturation.",null,[[["__m64"]],["__m64"]]],[5,"_m_paddsb","","Adds packed 8-bit integers in `a` and `b` using saturation.",null,[[["__m64"]],["__m64"]]],[5,"_mm_adds_pi16","","Adds packed 16-bit integers in `a` and `b` using saturation.",null,[[["__m64"]],["__m64"]]],[5,"_m_paddsw","","Adds packed 16-bit integers in `a` and `b` using saturation.",null,[[["__m64"]],["__m64"]]],[5,"_mm_adds_pu8","","Adds packed unsigned 8-bit integers in `a` and `b` using…",null,[[["__m64"]],["__m64"]]],[5,"_m_paddusb","","Adds packed unsigned 8-bit integers in `a` and `b` using…",null,[[["__m64"]],["__m64"]]],[5,"_mm_adds_pu16","","Adds packed unsigned 16-bit integers in `a` and `b` using…",null,[[["__m64"]],["__m64"]]],[5,"_m_paddusw","","Adds packed unsigned 16-bit integers in `a` and `b` using…",null,[[["__m64"]],["__m64"]]],[5,"_mm_sub_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m64"]],["__m64"]]],[5,"_m_psubb","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m64"]],["__m64"]]],[5,"_mm_sub_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m64"]],["__m64"]]],[5,"_m_psubw","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m64"]],["__m64"]]],[5,"_mm_sub_pi32","","Subtract packed 32-bit integers in `b` from packed 32-bit…",null,[[["__m64"]],["__m64"]]],[5,"_m_psubd","","Subtract packed 32-bit integers in `b` from packed 32-bit…",null,[[["__m64"]],["__m64"]]],[5,"_mm_subs_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m64"]],["__m64"]]],[5,"_m_psubsb","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m64"]],["__m64"]]],[5,"_mm_subs_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m64"]],["__m64"]]],[5,"_m_psubsw","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m64"]],["__m64"]]],[5,"_mm_subs_pu8","","Subtract packed unsigned 8-bit integers in `b` from packed…",null,[[["__m64"]],["__m64"]]],[5,"_m_psubusb","","Subtract packed unsigned 8-bit integers in `b` from packed…",null,[[["__m64"]],["__m64"]]],[5,"_mm_subs_pu16","","Subtract packed unsigned 16-bit integers in `b` from…",null,[[["__m64"]],["__m64"]]],[5,"_m_psubusw","","Subtract packed unsigned 16-bit integers in `b` from…",null,[[["__m64"]],["__m64"]]],[5,"_mm_packs_pi16","","Converts packed 16-bit integers from `a` and `b` to packed…",null,[[["__m64"]],["__m64"]]],[5,"_mm_packs_pi32","","Converts packed 32-bit integers from `a` and `b` to packed…",null,[[["__m64"]],["__m64"]]],[5,"_mm_cmpgt_pi8","","Compares whether each element of `a` is greater than the…",null,[[["__m64"]],["__m64"]]],[5,"_mm_cmpgt_pi16","","Compares whether each element of `a` is greater than the…",null,[[["__m64"]],["__m64"]]],[5,"_mm_cmpgt_pi32","","Compares whether each element of `a` is greater than the…",null,[[["__m64"]],["__m64"]]],[5,"_mm_unpackhi_pi16","","Unpacks the upper two elements from two `i16x4` vectors…",null,[[["__m64"]],["__m64"]]],[5,"_mm_unpackhi_pi8","","Unpacks the upper four elements from two `i8x8` vectors…",null,[[["__m64"]],["__m64"]]],[5,"_mm_unpacklo_pi8","","Unpacks the lower four elements from two `i8x8` vectors…",null,[[["__m64"]],["__m64"]]],[5,"_mm_unpacklo_pi16","","Unpacks the lower two elements from two `i16x4` vectors…",null,[[["__m64"]],["__m64"]]],[5,"_mm_unpackhi_pi32","","Unpacks the upper element from two `i32x2` vectors and…",null,[[["__m64"]],["__m64"]]],[5,"_mm_unpacklo_pi32","","Unpacks the lower element from two `i32x2` vectors and…",null,[[["__m64"]],["__m64"]]],[5,"_mm_set_pi16","","Sets packed 16-bit integers in dst with the supplied values.",null,[[["i16"]],["__m64"]]],[5,"_mm_set_pi32","","Sets packed 32-bit integers in dst with the supplied values.",null,[[["i32"]],["__m64"]]],[5,"_mm_set_pi8","","Sets packed 8-bit integers in dst with the supplied values.",null,[[["i8"]],["__m64"]]],[5,"_mm_set1_pi16","","Broadcasts 16-bit integer a to all all elements of dst.",null,[[["i16"]],["__m64"]]],[5,"_mm_set1_pi32","","Broadcasts 32-bit integer a to all all elements of dst.",null,[[["i32"]],["__m64"]]],[5,"_mm_set1_pi8","","Broadcasts 8-bit integer a to all all elements of dst.",null,[[["i8"]],["__m64"]]],[5,"_mm_setr_pi16","","Sets packed 16-bit integers in dst with the supplied…",null,[[["i16"]],["__m64"]]],[5,"_mm_setr_pi32","","Sets packed 32-bit integers in dst with the supplied…",null,[[["i32"]],["__m64"]]],[5,"_mm_setr_pi8","","Sets packed 8-bit integers in dst with the supplied values…",null,[[["i8"]],["__m64"]]],[5,"_mm_empty","","Empty the MMX state, which marks the x87 FPU registers as…",null,[[]]],[5,"_m_empty","","Empty the MMX state, which marks the x87 FPU registers as…",null,[[]]],[5,"_mm_cvtsi32_si64","","Copies 32-bit integer `a` to the lower elements of the…",null,[[["i32"]],["__m64"]]],[5,"_mm_cvtsi64_si32","","Return the lower 32-bit integer in `a`.",null,[[["__m64"]],["i32"]]],[5,"_mm_clmulepi64_si128","","Performs a carry-less multiplication of two 64-bit…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_aesdec_si128","","Performs one round of an AES decryption flow on data…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_aesdeclast_si128","","Performs the last round of an AES decryption flow on data…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_aesenc_si128","","Performs one round of an AES encryption flow on data…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_aesenclast_si128","","Performs the last round of an AES encryption flow on data…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_aesimc_si128","","Performs the `InvMixColumns` transformation on `a`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_aeskeygenassist_si128","","Assist in expanding the AES cipher key.",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_rdrand16_step","","Read a hardware generated 16-bit random value and store…",null,[[["u16"]],["i32"]]],[5,"_rdrand32_step","","Read a hardware generated 32-bit random value and store…",null,[[["u32"]],["i32"]]],[5,"_rdseed16_step","","Read a 16-bit NIST SP800-90B and SP800-90C compliant…",null,[[["u16"]],["i32"]]],[5,"_rdseed32_step","","Read a 32-bit NIST SP800-90B and SP800-90C compliant…",null,[[["u32"]],["i32"]]],[5,"_mm_sha1msg1_epu32","","Performs an intermediate calculation for the next four…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sha1msg2_epu32","","Performs the final calculation for the next four SHA1…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sha1nexte_epu32","","Calculate SHA1 state variable E after four rounds of…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sha1rnds4_epu32","","Performs four rounds of SHA1 operation using an initial…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sha256msg1_epu32","","Performs an intermediate calculation for the next four…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sha256msg2_epu32","","Performs the final calculation for the next four SHA256…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sha256rnds2_epu32","","Performs 2 rounds of SHA256 operation using an initial…",null,[[["__m128i"]],["__m128i"]]],[5,"_addcarry_u32","","Adds unsigned 32-bit integers `a` and `b` with unsigned…",null,[[["u32"],["u32"],["u8"]],["u8"]]],[5,"_addcarryx_u32","","Adds unsigned 32-bit integers `a` and `b` with unsigned…",null,[[["u32"],["u32"],["u8"]],["u8"]]],[5,"_subborrow_u32","","Adds unsigned 32-bit integers `a` and `b` with unsigned…",null,[[["u32"],["u32"],["u8"]],["u8"]]],[5,"ud2","","Generates the trap instruction `UD2`",null,[[]]],[5,"_mm512_abs_epi32","","Computes the absolute values of packed 32-bit integers in…",null,[[["__m512i"]],["__m512i"]]],[5,"_mm512_mask_abs_epi32","","Computes the absolute value of packed 32-bit integers in…",null,[[["__m512i"],["__mmask16"]],["__m512i"]]],[5,"_mm512_maskz_abs_epi32","","Computes the absolute value of packed 32-bit integers in…",null,[[["__m512i"],["__mmask16"]],["__m512i"]]],[5,"_mm512_setzero_si512","","Returns vector of type `__m512i` with all elements set to…",null,[[],["__m512i"]]],[5,"_mm512_setr_epi32","","Sets packed 32-bit integers in `dst` with the supplied…",null,[[["i32"]],["__m512i"]]],[5,"_mm512_set1_epi64","","Broadcast 64-bit integer `a` to all elements of `dst`.",null,[[["i64"]],["__m512i"]]],[5,"_mm512_madd52hi_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m512i"]],["__m512i"]]],[5,"_mm512_madd52lo_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m512i"]],["__m512i"]]],[5,"_mm256_madd52hi_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_madd52lo_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm_madd52hi_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_madd52lo_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_bittest","","Returns the bit in position `b` of the memory addressed by…",null,[[["i32"]],["u8"]]],[5,"_bittestandset","","Returns the bit in position `b` of the memory addressed by…",null,[[["i32"]],["u8"]]],[5,"_bittestandreset","","Returns the bit in position `b` of the memory addressed by…",null,[[["i32"]],["u8"]]],[5,"_bittestandcomplement","","Returns the bit in position `b` of the memory addressed by…",null,[[["i32"]],["u8"]]],[5,"_xbegin","","Specifies the start of a restricted transactional memory…",null,[[],["u32"]]],[5,"_xend","","Specifies the end of a restricted transactional memory…",null,[[]]],[5,"_xabort","","Forces a restricted transactional memory (RTM) region to…",null,[[["u32"]]]],[5,"_xtest","","Queries whether the processor is executing in a…",null,[[],["u8"]]],[5,"_xabort_code","","Retrieves the parameter passed to [`_xabort`] when…",null,[[["u32"]],["u32"]]],[5,"_mm_cvtph_ps","","Converts the 4 x 16-bit half-precision float values in the…",null,[[["__m128i"]],["__m128"]]],[5,"_mm256_cvtph_ps","","Converts the 8 x 16-bit half-precision float values in the…",null,[[["__m128i"]],["__m256"]]],[5,"_mm_cvtps_ph","","Converts the 4 x 32-bit float values in the 128-bit vector…",null,[[["i32"],["__m128"]],["__m128i"]]],[5,"_mm256_cvtps_ph","","Converts the 8 x 32-bit float values in the 256-bit vector…",null,[[["__m256"],["i32"]],["__m128i"]]],[6,"__mmask16","","The `__mmask16` type used in AVX-512 intrinsics, a 16-bit…",null,null],[17,"_XCR_XFEATURE_ENABLED_MASK","","`XFEATURE_ENABLED_MASK` for `XCR`",null,null],[17,"_MM_EXCEPT_INVALID","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_DENORM","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_DIV_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_OVERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_UNDERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_INEXACT","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_MASK","","See `_MM_GET_EXCEPTION_STATE`",null,null],[17,"_MM_MASK_INVALID","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_DENORM","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_DIV_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_OVERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_UNDERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_INEXACT","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_MASK","","See `_MM_GET_EXCEPTION_MASK`",null,null],[17,"_MM_ROUND_NEAREST","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_DOWN","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_UP","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_TOWARD_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_MASK","","See `_MM_GET_ROUNDING_MODE`",null,null],[17,"_MM_FLUSH_ZERO_MASK","","See `_MM_GET_FLUSH_ZERO_MODE`",null,null],[17,"_MM_FLUSH_ZERO_ON","","See `_mm_setcsr`",null,null],[17,"_MM_FLUSH_ZERO_OFF","","See `_mm_setcsr`",null,null],[17,"_MM_HINT_T0","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_T1","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_T2","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_NTA","","See `_mm_prefetch`.",null,null],[17,"_MM_FROUND_TO_NEAREST_INT","","round to nearest",null,null],[17,"_MM_FROUND_TO_NEG_INF","","round down",null,null],[17,"_MM_FROUND_TO_POS_INF","","round up",null,null],[17,"_MM_FROUND_TO_ZERO","","truncate",null,null],[17,"_MM_FROUND_CUR_DIRECTION","","use MXCSR.RC; see `vendor::_MM_SET_ROUNDING_MODE`",null,null],[17,"_MM_FROUND_RAISE_EXC","","do not suppress exceptions",null,null],[17,"_MM_FROUND_NO_EXC","","suppress exceptions",null,null],[17,"_MM_FROUND_NINT","","round to nearest and do not suppress exceptions",null,null],[17,"_MM_FROUND_FLOOR","","round down and do not suppress exceptions",null,null],[17,"_MM_FROUND_CEIL","","round up and do not suppress exceptions",null,null],[17,"_MM_FROUND_TRUNC","","truncate and do not suppress exceptions",null,null],[17,"_MM_FROUND_RINT","","use MXCSR.RC and do not suppress exceptions; see…",null,null],[17,"_MM_FROUND_NEARBYINT","","use MXCSR.RC and suppress exceptions; see…",null,null],[17,"_SIDD_UBYTE_OPS","","String contains unsigned 8-bit characters (Default)",null,null],[17,"_SIDD_UWORD_OPS","","String contains unsigned 16-bit characters",null,null],[17,"_SIDD_SBYTE_OPS","","String contains signed 8-bit characters",null,null],[17,"_SIDD_SWORD_OPS","","String contains unsigned 16-bit characters",null,null],[17,"_SIDD_CMP_EQUAL_ANY","","For each character in `a`, find if it is in `b` (Default)",null,null],[17,"_SIDD_CMP_RANGES","","For each character in `a`, determine if `b[0] <= c <= b[1]…",null,null],[17,"_SIDD_CMP_EQUAL_EACH","","The strings defined by `a` and `b` are equal",null,null],[17,"_SIDD_CMP_EQUAL_ORDERED","","Search for the defined substring in the target",null,null],[17,"_SIDD_POSITIVE_POLARITY","","Do not negate results (Default)",null,null],[17,"_SIDD_NEGATIVE_POLARITY","","Negates results",null,null],[17,"_SIDD_MASKED_POSITIVE_POLARITY","","Do not negate results before the end of the string",null,null],[17,"_SIDD_MASKED_NEGATIVE_POLARITY","","Negates results only before the end of the string",null,null],[17,"_SIDD_LEAST_SIGNIFICANT","","Index only: return the least significant bit (Default)",null,null],[17,"_SIDD_MOST_SIGNIFICANT","","Index only: return the most significant bit",null,null],[17,"_SIDD_BIT_MASK","","Mask only: return the bit mask",null,null],[17,"_SIDD_UNIT_MASK","","Mask only: return the byte mask",null,null],[17,"_CMP_EQ_OQ","","Equal (ordered, non-signaling)",null,null],[17,"_CMP_LT_OS","","Less-than (ordered, signaling)",null,null],[17,"_CMP_LE_OS","","Less-than-or-equal (ordered, signaling)",null,null],[17,"_CMP_UNORD_Q","","Unordered (non-signaling)",null,null],[17,"_CMP_NEQ_UQ","","Not-equal (unordered, non-signaling)",null,null],[17,"_CMP_NLT_US","","Not-less-than (unordered, signaling)",null,null],[17,"_CMP_NLE_US","","Not-less-than-or-equal (unordered, signaling)",null,null],[17,"_CMP_ORD_Q","","Ordered (non-signaling)",null,null],[17,"_CMP_EQ_UQ","","Equal (unordered, non-signaling)",null,null],[17,"_CMP_NGE_US","","Not-greater-than-or-equal (unordered, signaling)",null,null],[17,"_CMP_NGT_US","","Not-greater-than (unordered, signaling)",null,null],[17,"_CMP_FALSE_OQ","","False (ordered, non-signaling)",null,null],[17,"_CMP_NEQ_OQ","","Not-equal (ordered, non-signaling)",null,null],[17,"_CMP_GE_OS","","Greater-than-or-equal (ordered, signaling)",null,null],[17,"_CMP_GT_OS","","Greater-than (ordered, signaling)",null,null],[17,"_CMP_TRUE_UQ","","True (unordered, non-signaling)",null,null],[17,"_CMP_EQ_OS","","Equal (ordered, signaling)",null,null],[17,"_CMP_LT_OQ","","Less-than (ordered, non-signaling)",null,null],[17,"_CMP_LE_OQ","","Less-than-or-equal (ordered, non-signaling)",null,null],[17,"_CMP_UNORD_S","","Unordered (signaling)",null,null],[17,"_CMP_NEQ_US","","Not-equal (unordered, signaling)",null,null],[17,"_CMP_NLT_UQ","","Not-less-than (unordered, non-signaling)",null,null],[17,"_CMP_NLE_UQ","","Not-less-than-or-equal (unordered, non-signaling)",null,null],[17,"_CMP_ORD_S","","Ordered (signaling)",null,null],[17,"_CMP_EQ_US","","Equal (unordered, signaling)",null,null],[17,"_CMP_NGE_UQ","","Not-greater-than-or-equal (unordered, non-signaling)",null,null],[17,"_CMP_NGT_UQ","","Not-greater-than (unordered, non-signaling)",null,null],[17,"_CMP_FALSE_OS","","False (ordered, signaling)",null,null],[17,"_CMP_NEQ_OS","","Not-equal (ordered, signaling)",null,null],[17,"_CMP_GE_OQ","","Greater-than-or-equal (ordered, non-signaling)",null,null],[17,"_CMP_GT_OQ","","Greater-than (ordered, non-signaling)",null,null],[17,"_CMP_TRUE_US","","True (unordered, signaling)",null,null],[17,"_XBEGIN_STARTED","","Transaction successfully started.",null,null],[17,"_XABORT_EXPLICIT","","Transaction explicitly aborted with xabort. The parameter…",null,null],[17,"_XABORT_RETRY","","Transaction retry is possible.",null,null],[17,"_XABORT_CONFLICT","","Transaction abort due to a memory conflict with another…",null,null],[17,"_XABORT_CAPACITY","","Transaction abort due to the transaction using too much…",null,null],[17,"_XABORT_DEBUG","","Transaction abort due to a debug trap.",null,null],[17,"_XABORT_NESTED","","Transaction abort in a inner nested transaction.",null,null],[0,"x86_64","core::arch","Platform-specific intrinsics for the `x86_64` platform.",null,null],[3,"__m64","core::arch::x86_64","64-bit wide integer vector type, x86-specific",null,null],[3,"__m128i","","128-bit wide integer vector type, x86-specific",null,null],[3,"__m128","","128-bit wide set of four `f32` types, x86-specific",null,null],[3,"__m128d","","128-bit wide set of two `f64` types, x86-specific",null,null],[3,"__m256i","","256-bit wide integer vector type, x86-specific",null,null],[3,"__m256","","256-bit wide set of eight `f32` types, x86-specific",null,null],[3,"__m256d","","256-bit wide set of four `f64` types, x86-specific",null,null],[3,"__m512i","","512-bit wide integer vector type, x86-specific",null,null],[3,"__m512","","512-bit wide set of sixteen `f32` types, x86-specific",null,null],[3,"__m512d","","512-bit wide set of eight `f64` types, x86-specific",null,null],[3,"CpuidResult","","Result of the `cpuid` instruction.",null,null],[12,"eax","","EAX register.",164,null],[12,"ebx","","EBX register.",164,null],[12,"ecx","","ECX register.",164,null],[12,"edx","","EDX register.",164,null],[5,"_fxsave","","Saves the `x87` FPU, `MMX` technology, `XMM`, and `MXCSR`…",null,[[]]],[5,"_fxrstor","","Restores the `XMM`, `MMX`, `MXCSR`, and `x87` FPU…",null,[[]]],[5,"_bswap","","Returns an integer with the reversed byte order of x",null,[[["i32"]],["i32"]]],[5,"_rdtsc","","Reads the current value of the processor’s time-stamp…",null,[[],["u64"]]],[5,"__rdtscp","","Reads the current value of the processor’s time-stamp…",null,[[],["u64"]]],[5,"__cpuid_count","","Returns the result of the `cpuid` instruction for a given…",null,[[["u32"]],["cpuidresult"]]],[5,"__cpuid","","See `__cpuid_count`.",null,[[["u32"]],["cpuidresult"]]],[5,"has_cpuid","","Does the host support the `cpuid` instruction?",null,[[],["bool"]]],[5,"__get_cpuid_max","","Returns the highest-supported `leaf` (`EAX`) and sub-leaf…",null,[[["u32"]]]],[5,"_xsave","","Performs a full or partial save of the enabled processor…",null,[[["u64"]]]],[5,"_xrstor","","Performs a full or partial restore of the enabled…",null,[[["u64"]]]],[5,"_xsetbv","","Copies 64-bits from `val` to the extended control register…",null,[[["u32"],["u64"]]]],[5,"_xgetbv","","Reads the contents of the extended control register `XCR`…",null,[[["u32"]],["u64"]]],[5,"_xsaveopt","","Performs a full or partial save of the enabled processor…",null,[[["u64"]]]],[5,"_xsavec","","Performs a full or partial save of the enabled processor…",null,[[["u64"]]]],[5,"_xsaves","","Performs a full or partial save of the enabled processor…",null,[[["u64"]]]],[5,"_xrstors","","Performs a full or partial restore of the enabled…",null,[[["u64"]]]],[5,"_mm_add_ss","","Adds the first component of `a` and `b`, the other…",null,[[["__m128"]],["__m128"]]],[5,"_mm_add_ps","","Adds __m128 vectors.",null,[[["__m128"]],["__m128"]]],[5,"_mm_sub_ss","","Subtracts the first component of `b` from `a`, the other…",null,[[["__m128"]],["__m128"]]],[5,"_mm_sub_ps","","Subtracts __m128 vectors.",null,[[["__m128"]],["__m128"]]],[5,"_mm_mul_ss","","Multiplies the first component of `a` and `b`, the other…",null,[[["__m128"]],["__m128"]]],[5,"_mm_mul_ps","","Multiplies __m128 vectors.",null,[[["__m128"]],["__m128"]]],[5,"_mm_div_ss","","Divides the first component of `b` by `a`, the other…",null,[[["__m128"]],["__m128"]]],[5,"_mm_div_ps","","Divides __m128 vectors.",null,[[["__m128"]],["__m128"]]],[5,"_mm_sqrt_ss","","Returns the square root of the first single-precision…",null,[[["__m128"]],["__m128"]]],[5,"_mm_sqrt_ps","","Returns the square root of packed single-precision…",null,[[["__m128"]],["__m128"]]],[5,"_mm_rcp_ss","","Returns the approximate reciprocal of the first…",null,[[["__m128"]],["__m128"]]],[5,"_mm_rcp_ps","","Returns the approximate reciprocal of packed…",null,[[["__m128"]],["__m128"]]],[5,"_mm_rsqrt_ss","","Returns the approximate reciprocal square root of the fist…",null,[[["__m128"]],["__m128"]]],[5,"_mm_rsqrt_ps","","Returns the approximate reciprocal square root of packed…",null,[[["__m128"]],["__m128"]]],[5,"_mm_min_ss","","Compares the first single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_min_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm_max_ss","","Compares the first single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_max_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm_and_ps","","Bitwise AND of packed single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_andnot_ps","","Bitwise AND-NOT of packed single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_or_ps","","Bitwise OR of packed single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_xor_ps","","Bitwise exclusive OR of packed single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpeq_ss","","Compares the lowest `f32` of both inputs for equality. The…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmplt_ss","","Compares the lowest `f32` of both inputs for less than.…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmple_ss","","Compares the lowest `f32` of both inputs for less than or…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpgt_ss","","Compares the lowest `f32` of both inputs for greater than.…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpge_ss","","Compares the lowest `f32` of both inputs for greater than…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpneq_ss","","Compares the lowest `f32` of both inputs for inequality.…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpnlt_ss","","Compares the lowest `f32` of both inputs for…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpnle_ss","","Compares the lowest `f32` of both inputs for…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpngt_ss","","Compares the lowest `f32` of both inputs for…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpnge_ss","","Compares the lowest `f32` of both inputs for…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpord_ss","","Checks if the lowest `f32` of both inputs are ordered. The…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpunord_ss","","Checks if the lowest `f32` of both inputs are unordered.…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpeq_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmplt_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmple_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpgt_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpge_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpneq_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpnlt_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpnle_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpngt_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpnge_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpord_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_cmpunord_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128"]],["__m128"]]],[5,"_mm_comieq_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_comilt_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_comile_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_comigt_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_comige_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_comineq_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_ucomieq_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_ucomilt_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_ucomile_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_ucomigt_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_ucomige_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_ucomineq_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128"]],["i32"]]],[5,"_mm_cvtss_si32","","Converts the lowest 32 bit float in the input vector to a…",null,[[["__m128"]],["i32"]]],[5,"_mm_cvt_ss2si","","Alias for `_mm_cvtss_si32`.",null,[[["__m128"]],["i32"]]],[5,"_mm_cvttss_si32","","Converts the lowest 32 bit float in the input vector to a…",null,[[["__m128"]],["i32"]]],[5,"_mm_cvtt_ss2si","","Alias for `_mm_cvttss_si32`.",null,[[["__m128"]],["i32"]]],[5,"_mm_cvtss_f32","","Extracts the lowest 32 bit float from the input vector.",null,[[["__m128"]],["f32"]]],[5,"_mm_cvtsi32_ss","","Converts a 32 bit integer to a 32 bit float. The result…",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm_cvt_si2ss","","Alias for `_mm_cvtsi32_ss`.",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm_set_ss","","Construct a `__m128` with the lowest element set to `a`…",null,[[["f32"]],["__m128"]]],[5,"_mm_set1_ps","","Construct a `__m128` with all element set to `a`.",null,[[["f32"]],["__m128"]]],[5,"_mm_set_ps1","","Alias for `_mm_set1_ps`",null,[[["f32"]],["__m128"]]],[5,"_mm_set_ps","","Construct a `__m128` from four floating point values…",null,[[["f32"]],["__m128"]]],[5,"_mm_setr_ps","","Construct a `__m128` from four floating point values…",null,[[["f32"]],["__m128"]]],[5,"_mm_setzero_ps","","Construct a `__m128` with all elements initialized to zero.",null,[[],["__m128"]]],[5,"_MM_SHUFFLE","","A utility function for creating masks to use with Intel…",null,[[["u32"]],["i32"]]],[5,"_mm_shuffle_ps","","Shuffles packed single-precision (32-bit) floating-point…",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm_unpackhi_ps","","Unpacks and interleave single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_unpacklo_ps","","Unpacks and interleave single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_movehl_ps","","Combine higher half of `a` and `b`. The highwe half of `b`…",null,[[["__m128"]],["__m128"]]],[5,"_mm_movelh_ps","","Combine lower half of `a` and `b`. The lower half of `b`…",null,[[["__m128"]],["__m128"]]],[5,"_mm_movemask_ps","","Returns a mask of the most significant bit of each element…",null,[[["__m128"]],["i32"]]],[5,"_mm_loadh_pi","","Sets the upper two single-precision floating-point values…",null,[[["__m128"]],["__m128"]]],[5,"_mm_loadl_pi","","Loads two floats from `p` into the lower half of a…",null,[[["__m128"]],["__m128"]]],[5,"_mm_load_ss","","Construct a `__m128` with the lowest element read from `p`…",null,[[],["__m128"]]],[5,"_mm_load1_ps","","Construct a `__m128` by duplicating the value read from…",null,[[],["__m128"]]],[5,"_mm_load_ps1","","Alias for `_mm_load1_ps`",null,[[],["__m128"]]],[5,"_mm_load_ps","","Loads four `f32` values from aligned memory into a…",null,[[],["__m128"]]],[5,"_mm_loadu_ps","","Loads four `f32` values from memory into a `__m128`. There…",null,[[],["__m128"]]],[5,"_mm_loadr_ps","","Loads four `f32` values from aligned memory into a…",null,[[],["__m128"]]],[5,"_mm_storeh_pi","","Stores the upper half of `a` (64 bits) into memory.",null,[[["__m128"]]]],[5,"_mm_storel_pi","","Stores the lower half of `a` (64 bits) into memory.",null,[[["__m128"]]]],[5,"_mm_store_ss","","Stores the lowest 32 bit float of `a` into memory.",null,[[["__m128"]]]],[5,"_mm_store1_ps","","Stores the lowest 32 bit float of `a` repeated four times…",null,[[["__m128"]]]],[5,"_mm_store_ps1","","Alias for `_mm_store1_ps`",null,[[["__m128"]]]],[5,"_mm_store_ps","","Stores four 32-bit floats into aligned memory.",null,[[["__m128"]]]],[5,"_mm_storeu_ps","","Stores four 32-bit floats into memory. There are no…",null,[[["__m128"]]]],[5,"_mm_storer_ps","","Stores four 32-bit floats into aligned memory in reverse…",null,[[["__m128"]]]],[5,"_mm_move_ss","","Returns a `__m128` with the first component from `b` and…",null,[[["__m128"]],["__m128"]]],[5,"_mm_sfence","","Performs a serializing operation on all store-to-memory…",null,[[]]],[5,"_mm_getcsr","","Gets the unsigned 32-bit value of the MXCSR control and…",null,[[],["u32"]]],[5,"_mm_setcsr","","Sets the MXCSR register with the 32-bit unsigned integer…",null,[[["u32"]]]],[5,"_MM_GET_EXCEPTION_MASK","","See `_mm_setcsr`",null,[[],["u32"]]],[5,"_MM_GET_EXCEPTION_STATE","","See `_mm_setcsr`",null,[[],["u32"]]],[5,"_MM_GET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",null,[[],["u32"]]],[5,"_MM_GET_ROUNDING_MODE","","See `_mm_setcsr`",null,[[],["u32"]]],[5,"_MM_SET_EXCEPTION_MASK","","See `_mm_setcsr`",null,[[["u32"]]]],[5,"_MM_SET_EXCEPTION_STATE","","See `_mm_setcsr`",null,[[["u32"]]]],[5,"_MM_SET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",null,[[["u32"]]]],[5,"_MM_SET_ROUNDING_MODE","","See `_mm_setcsr`",null,[[["u32"]]]],[5,"_mm_prefetch","","Fetch the cache line that contains address `p` using the…",null,[[["i32"]]]],[5,"_mm_undefined_ps","","Returns vector of type __m128 with undefined elements.",null,[[],["__m128"]]],[5,"_MM_TRANSPOSE4_PS","","Transpose the 4x4 matrix formed by 4 rows of __m128 in…",null,[[["__m128"]]]],[5,"_mm_stream_ps","","Stores `a` into the memory at `mem_addr` using a…",null,[[["__m128"]]]],[5,"_mm_stream_pi","","Stores 64-bits of integer data from a into memory using a…",null,[[["__m64"]]]],[5,"_mm_max_pi16","","Compares the packed 16-bit signed integers of `a` and `b`…",null,[[["__m64"]],["__m64"]]],[5,"_m_pmaxsw","","Compares the packed 16-bit signed integers of `a` and `b`…",null,[[["__m64"]],["__m64"]]],[5,"_mm_max_pu8","","Compares the packed 8-bit signed integers of `a` and `b`…",null,[[["__m64"]],["__m64"]]],[5,"_m_pmaxub","","Compares the packed 8-bit signed integers of `a` and `b`…",null,[[["__m64"]],["__m64"]]],[5,"_mm_min_pi16","","Compares the packed 16-bit signed integers of `a` and `b`…",null,[[["__m64"]],["__m64"]]],[5,"_m_pminsw","","Compares the packed 16-bit signed integers of `a` and `b`…",null,[[["__m64"]],["__m64"]]],[5,"_mm_min_pu8","","Compares the packed 8-bit signed integers of `a` and `b`…",null,[[["__m64"]],["__m64"]]],[5,"_m_pminub","","Compares the packed 8-bit signed integers of `a` and `b`…",null,[[["__m64"]],["__m64"]]],[5,"_mm_mulhi_pu16","","Multiplies packed 16-bit unsigned integer values and…",null,[[["__m64"]],["__m64"]]],[5,"_mm_mullo_pi16","","Multiplies packed 16-bit integer values and writes the…",null,[[["__m64"]],["__m64"]]],[5,"_m_pmulhuw","","Multiplies packed 16-bit unsigned integer values and…",null,[[["__m64"]],["__m64"]]],[5,"_mm_avg_pu8","","Computes the rounded averages of the packed unsigned 8-bit…",null,[[["__m64"]],["__m64"]]],[5,"_m_pavgb","","Computes the rounded averages of the packed unsigned 8-bit…",null,[[["__m64"]],["__m64"]]],[5,"_mm_avg_pu16","","Computes the rounded averages of the packed unsigned…",null,[[["__m64"]],["__m64"]]],[5,"_m_pavgw","","Computes the rounded averages of the packed unsigned…",null,[[["__m64"]],["__m64"]]],[5,"_mm_sad_pu8","","Subtracts the corresponding 8-bit unsigned integer values…",null,[[["__m64"]],["__m64"]]],[5,"_m_psadbw","","Subtracts the corresponding 8-bit unsigned integer values…",null,[[["__m64"]],["__m64"]]],[5,"_mm_cvtpi32_ps","","Converts two elements of a 64-bit vector of `[2 x i32]`…",null,[[["__m64"],["__m128"]],["__m128"]]],[5,"_mm_cvt_pi2ps","","Converts two elements of a 64-bit vector of `[2 x i32]`…",null,[[["__m64"],["__m128"]],["__m128"]]],[5,"_mm_cvtpi8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit…",null,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpu8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit…",null,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpi16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector…",null,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpu16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector…",null,[[["__m64"]],["__m128"]]],[5,"_mm_cvtpi32x2_ps","","Converts the two 32-bit signed integer values from each…",null,[[["__m64"]],["__m128"]]],[5,"_mm_maskmove_si64","","Conditionally copies the values from each 8-bit element in…",null,[[["__m64"]]]],[5,"_m_maskmovq","","Conditionally copies the values from each 8-bit element in…",null,[[["__m64"]]]],[5,"_mm_extract_pi16","","Extracts 16-bit element from a 64-bit vector of `[4 x…",null,[[["__m64"],["i32"]],["i32"]]],[5,"_m_pextrw","","Extracts 16-bit element from a 64-bit vector of `[4 x…",null,[[["__m64"],["i32"]],["i32"]]],[5,"_mm_insert_pi16","","Copies data from the 64-bit vector of `[4 x i16]` to the…",null,[[["__m64"],["i32"]],["__m64"]]],[5,"_m_pinsrw","","Copies data from the 64-bit vector of `[4 x i16]` to the…",null,[[["__m64"],["i32"]],["__m64"]]],[5,"_mm_movemask_pi8","","Takes the most significant bit from each 8-bit element in…",null,[[["__m64"]],["i32"]]],[5,"_m_pmovmskb","","Takes the most significant bit from each 8-bit element in…",null,[[["__m64"]],["i32"]]],[5,"_mm_shuffle_pi16","","Shuffles the 4 16-bit integers from a 64-bit integer…",null,[[["__m64"],["i32"]],["__m64"]]],[5,"_m_pshufw","","Shuffles the 4 16-bit integers from a 64-bit integer…",null,[[["__m64"],["i32"]],["__m64"]]],[5,"_mm_cvttps_pi32","","Converts the two lower packed single-precision (32-bit)…",null,[[["__m128"]],["__m64"]]],[5,"_mm_cvtt_ps2pi","","Converts the two lower packed single-precision (32-bit)…",null,[[["__m128"]],["__m64"]]],[5,"_mm_cvtps_pi32","","Converts the two lower packed single-precision (32-bit)…",null,[[["__m128"]],["__m64"]]],[5,"_mm_cvt_ps2pi","","Converts the two lower packed single-precision (32-bit)…",null,[[["__m128"]],["__m64"]]],[5,"_mm_cvtps_pi16","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m64"]]],[5,"_mm_cvtps_pi8","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m64"]]],[5,"_mm_pause","","Provides a hint to the processor that the code sequence is…",null,[[]]],[5,"_mm_clflush","","Invalidates and flushes the cache line that contains `p`…",null,[[]]],[5,"_mm_lfence","","Performs a serializing operation on all load-from-memory…",null,[[]]],[5,"_mm_mfence","","Performs a serializing operation on all load-from-memory…",null,[[]]],[5,"_mm_add_epi8","","Adds packed 8-bit integers in `a` and `b`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_add_epi16","","Adds packed 16-bit integers in `a` and `b`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_add_epi32","","Adds packed 32-bit integers in `a` and `b`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_add_epi64","","Adds packed 64-bit integers in `a` and `b`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_adds_epi8","","Adds packed 8-bit integers in `a` and `b` using saturation.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_adds_epi16","","Adds packed 16-bit integers in `a` and `b` using saturation.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_adds_epu8","","Adds packed unsigned 8-bit integers in `a` and `b` using…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_adds_epu16","","Adds packed unsigned 16-bit integers in `a` and `b` using…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_avg_epu8","","Averages packed unsigned 8-bit integers in `a` and `b`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_avg_epu16","","Averages packed unsigned 16-bit integers in `a` and `b`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_madd_epi16","","Multiplies and then horizontally add signed 16 bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_max_epi16","","Compares packed 16-bit integers in `a` and `b`, and…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_max_epu8","","Compares packed unsigned 8-bit integers in `a` and `b`,…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_min_epi16","","Compares packed 16-bit integers in `a` and `b`, and…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_min_epu8","","Compares packed unsigned 8-bit integers in `a` and `b`,…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_mulhi_epi16","","Multiplies the packed 16-bit integers in `a` and `b`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_mulhi_epu16","","Multiplies the packed unsigned 16-bit integers in `a` and…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_mullo_epi16","","Multiplies the packed 16-bit integers in `a` and `b`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_mul_epu32","","Multiplies the low unsigned 32-bit integers from each…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sad_epu8","","Sum the absolute differences of packed unsigned 8-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi8","","Subtracts packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi16","","Subtracts packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 32-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 64-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_slli_si128","","Shifts `a` left by `imm8` bytes while shifting in zeros.",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_bslli_si128","","Shifts `a` left by `imm8` bytes while shifting in zeros.",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_bsrli_si128","","Shifts `a` right by `imm8` bytes while shifting in zeros.",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_slli_epi16","","Shifts packed 16-bit integers in `a` left by `imm8` while…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sll_epi16","","Shifts packed 16-bit integers in `a` left by `count` while…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_slli_epi32","","Shifts packed 32-bit integers in `a` left by `imm8` while…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sll_epi32","","Shifts packed 32-bit integers in `a` left by `count` while…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_slli_epi64","","Shifts packed 64-bit integers in `a` left by `imm8` while…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sll_epi64","","Shifts packed 64-bit integers in `a` left by `count` while…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_srai_epi16","","Shifts packed 16-bit integers in `a` right by `imm8` while…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sra_epi16","","Shifts packed 16-bit integers in `a` right by `count`…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_srai_epi32","","Shifts packed 32-bit integers in `a` right by `imm8` while…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sra_epi32","","Shifts packed 32-bit integers in `a` right by `count`…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_srli_si128","","Shifts `a` right by `imm8` bytes while shifting in zeros.",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srli_epi16","","Shifts packed 16-bit integers in `a` right by `imm8` while…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srl_epi16","","Shifts packed 16-bit integers in `a` right by `count`…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_srli_epi32","","Shifts packed 32-bit integers in `a` right by `imm8` while…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srl_epi32","","Shifts packed 32-bit integers in `a` right by `count`…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_srli_epi64","","Shifts packed 64-bit integers in `a` right by `imm8` while…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_srl_epi64","","Shifts packed 64-bit integers in `a` right by `count`…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_and_si128","","Computes the bitwise AND of 128 bits (representing integer…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_andnot_si128","","Computes the bitwise NOT of 128 bits (representing integer…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_or_si128","","Computes the bitwise OR of 128 bits (representing integer…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_xor_si128","","Computes the bitwise XOR of 128 bits (representing integer…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi8","","Compares packed 8-bit integers in `a` and `b` for equality.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi16","","Compares packed 16-bit integers in `a` and `b` for equality.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi32","","Compares packed 32-bit integers in `a` and `b` for equality.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cmpgt_epi8","","Compares packed 8-bit integers in `a` and `b` for…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cmpgt_epi16","","Compares packed 16-bit integers in `a` and `b` for…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cmpgt_epi32","","Compares packed 32-bit integers in `a` and `b` for…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cmplt_epi8","","Compares packed 8-bit integers in `a` and `b` for less-than.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cmplt_epi16","","Compares packed 16-bit integers in `a` and `b` for…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cmplt_epi32","","Compares packed 32-bit integers in `a` and `b` for…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi32_pd","","Converts the lower two packed 32-bit integers in `a` to…",null,[[["__m128i"]],["__m128d"]]],[5,"_mm_cvtsi32_sd","","Returns `a` with its lower element replaced by `b` after…",null,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_cvtepi32_ps","","Converts packed 32-bit integers in `a` to packed…",null,[[["__m128i"]],["__m128"]]],[5,"_mm_cvtps_epi32","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128i"]]],[5,"_mm_cvtsi32_si128","","Returns a vector whose lowest element is `a` and all…",null,[[["i32"]],["__m128i"]]],[5,"_mm_cvtsi128_si32","","Returns the lowest element of `a`.",null,[[["__m128i"]],["i32"]]],[5,"_mm_set_epi64x","","Sets packed 64-bit integers with the supplied values, from…",null,[[["i64"]],["__m128i"]]],[5,"_mm_set_epi32","","Sets packed 32-bit integers with the supplied values.",null,[[["i32"]],["__m128i"]]],[5,"_mm_set_epi16","","Sets packed 16-bit integers with the supplied values.",null,[[["i16"]],["__m128i"]]],[5,"_mm_set_epi8","","Sets packed 8-bit integers with the supplied values.",null,[[["i8"]],["__m128i"]]],[5,"_mm_set1_epi64x","","Broadcasts 64-bit integer `a` to all elements.",null,[[["i64"]],["__m128i"]]],[5,"_mm_set1_epi32","","Broadcasts 32-bit integer `a` to all elements.",null,[[["i32"]],["__m128i"]]],[5,"_mm_set1_epi16","","Broadcasts 16-bit integer `a` to all elements.",null,[[["i16"]],["__m128i"]]],[5,"_mm_set1_epi8","","Broadcasts 8-bit integer `a` to all elements.",null,[[["i8"]],["__m128i"]]],[5,"_mm_setr_epi32","","Sets packed 32-bit integers with the supplied values in…",null,[[["i32"]],["__m128i"]]],[5,"_mm_setr_epi16","","Sets packed 16-bit integers with the supplied values in…",null,[[["i16"]],["__m128i"]]],[5,"_mm_setr_epi8","","Sets packed 8-bit integers with the supplied values in…",null,[[["i8"]],["__m128i"]]],[5,"_mm_setzero_si128","","Returns a vector with all elements set to zero.",null,[[],["__m128i"]]],[5,"_mm_loadl_epi64","","Loads 64-bit integer from memory into first element of…",null,[[],["__m128i"]]],[5,"_mm_load_si128","","Loads 128-bits of integer data from memory into a new…",null,[[],["__m128i"]]],[5,"_mm_loadu_si128","","Loads 128-bits of integer data from memory into a new…",null,[[],["__m128i"]]],[5,"_mm_maskmoveu_si128","","Conditionally store 8-bit integer elements from `a` into…",null,[[["__m128i"]]]],[5,"_mm_store_si128","","Stores 128-bits of integer data from `a` into memory.",null,[[["__m128i"]]]],[5,"_mm_storeu_si128","","Stores 128-bits of integer data from `a` into memory.",null,[[["__m128i"]]]],[5,"_mm_storel_epi64","","Stores the lower 64-bit integer `a` to a memory location.",null,[[["__m128i"]]]],[5,"_mm_stream_si128","","Stores a 128-bit integer vector to a 128-bit aligned…",null,[[["__m128i"]]]],[5,"_mm_stream_si32","","Stores a 32-bit integer value in the specified memory…",null,[[["i32"]]]],[5,"_mm_move_epi64","","Returns a vector where the low element is extracted from…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_packs_epi16","","Converts packed 16-bit integers from `a` and `b` to packed…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_packs_epi32","","Converts packed 32-bit integers from `a` and `b` to packed…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_packus_epi16","","Converts packed 16-bit integers from `a` and `b` to packed…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_extract_epi16","","Returns the `imm8` element of `a`.",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_insert_epi16","","Returns a new vector where the `imm8` element of `a` is…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_movemask_epi8","","Returns a mask of the most significant bit of each element…",null,[[["__m128i"]],["i32"]]],[5,"_mm_shuffle_epi32","","Shuffles 32-bit integers in `a` using the control in `imm8`.",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_shufflehi_epi16","","Shuffles 16-bit integers in the high 64 bits of `a` using…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_shufflelo_epi16","","Shuffles 16-bit integers in the low 64 bits of `a` using…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_unpackhi_epi8","","Unpacks and interleave 8-bit integers from the high half…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_unpackhi_epi16","","Unpacks and interleave 16-bit integers from the high half…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_unpackhi_epi32","","Unpacks and interleave 32-bit integers from the high half…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_unpackhi_epi64","","Unpacks and interleave 64-bit integers from the high half…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi8","","Unpacks and interleave 8-bit integers from the low half of…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi16","","Unpacks and interleave 16-bit integers from the low half…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi32","","Unpacks and interleave 32-bit integers from the low half…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_unpacklo_epi64","","Unpacks and interleave 64-bit integers from the low half…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_add_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_add_pd","","Adds packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_div_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_div_pd","","Divide packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_max_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_max_pd","","Returns a new vector with the maximum values from…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_min_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_min_pd","","Returns a new vector with the minimum values from…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_mul_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_mul_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_sqrt_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_sqrt_pd","","Returns a new vector with the square root of each of the…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_sub_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_sub_pd","","Subtract packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_and_pd","","Computes the bitwise AND of packed double-precision…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_andnot_pd","","Computes the bitwise NOT of `a` and then AND with `b`.",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_or_pd","","Computes the bitwise OR of `a` and `b`.",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_xor_pd","","Computes the bitwise OR of `a` and `b`.",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpeq_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmplt_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmple_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpgt_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpge_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpord_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpunord_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpneq_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpnlt_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpnle_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpngt_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpnge_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpeq_pd","","Compares corresponding elements in `a` and `b` for equality.",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmplt_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmple_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpgt_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpge_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpord_pd","","Compares corresponding elements in `a` and `b` to see if…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpunord_pd","","Compares corresponding elements in `a` and `b` to see if…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpneq_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpnlt_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpnle_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpngt_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_cmpnge_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_comieq_sd","","Compares the lower element of `a` and `b` for equality.",null,[[["__m128d"]],["i32"]]],[5,"_mm_comilt_sd","","Compares the lower element of `a` and `b` for less-than.",null,[[["__m128d"]],["i32"]]],[5,"_mm_comile_sd","","Compares the lower element of `a` and `b` for…",null,[[["__m128d"]],["i32"]]],[5,"_mm_comigt_sd","","Compares the lower element of `a` and `b` for greater-than.",null,[[["__m128d"]],["i32"]]],[5,"_mm_comige_sd","","Compares the lower element of `a` and `b` for…",null,[[["__m128d"]],["i32"]]],[5,"_mm_comineq_sd","","Compares the lower element of `a` and `b` for not-equal.",null,[[["__m128d"]],["i32"]]],[5,"_mm_ucomieq_sd","","Compares the lower element of `a` and `b` for equality.",null,[[["__m128d"]],["i32"]]],[5,"_mm_ucomilt_sd","","Compares the lower element of `a` and `b` for less-than.",null,[[["__m128d"]],["i32"]]],[5,"_mm_ucomile_sd","","Compares the lower element of `a` and `b` for…",null,[[["__m128d"]],["i32"]]],[5,"_mm_ucomigt_sd","","Compares the lower element of `a` and `b` for greater-than.",null,[[["__m128d"]],["i32"]]],[5,"_mm_ucomige_sd","","Compares the lower element of `a` and `b` for…",null,[[["__m128d"]],["i32"]]],[5,"_mm_ucomineq_sd","","Compares the lower element of `a` and `b` for not-equal.",null,[[["__m128d"]],["i32"]]],[5,"_mm_cvtpd_ps","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128"]]],[5,"_mm_cvtps_pd","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128d"]]],[5,"_mm_cvtpd_epi32","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128i"]]],[5,"_mm_cvtsd_si32","","Converts the lower double-precision (64-bit)…",null,[[["__m128d"]],["i32"]]],[5,"_mm_cvtsd_ss","","Converts the lower double-precision (64-bit)…",null,[[["__m128d"],["__m128"]],["__m128"]]],[5,"_mm_cvtsd_f64","","Returns the lower double-precision (64-bit) floating-point…",null,[[["__m128d"]],["f64"]]],[5,"_mm_cvtss_sd","","Converts the lower single-precision (32-bit)…",null,[[["__m128d"],["__m128"]],["__m128d"]]],[5,"_mm_cvttpd_epi32","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128i"]]],[5,"_mm_cvttsd_si32","","Converts the lower double-precision (64-bit)…",null,[[["__m128d"]],["i32"]]],[5,"_mm_cvttps_epi32","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128i"]]],[5,"_mm_set_sd","","Copies double-precision (64-bit) floating-point element…",null,[[["f64"]],["__m128d"]]],[5,"_mm_set1_pd","","Broadcasts double-precision (64-bit) floating-point value…",null,[[["f64"]],["__m128d"]]],[5,"_mm_set_pd1","","Broadcasts double-precision (64-bit) floating-point value…",null,[[["f64"]],["__m128d"]]],[5,"_mm_set_pd","","Sets packed double-precision (64-bit) floating-point…",null,[[["f64"]],["__m128d"]]],[5,"_mm_setr_pd","","Sets packed double-precision (64-bit) floating-point…",null,[[["f64"]],["__m128d"]]],[5,"_mm_setzero_pd","","Returns packed double-precision (64-bit) floating-point…",null,[[],["__m128d"]]],[5,"_mm_movemask_pd","","Returns a mask of the most significant bit of each element…",null,[[["__m128d"]],["i32"]]],[5,"_mm_load_pd","","Loads 128-bits (composed of 2 packed double-precision…",null,[[],["__m128d"]]],[5,"_mm_load_sd","","Loads a 64-bit double-precision value to the low element…",null,[[],["__m128d"]]],[5,"_mm_loadh_pd","","Loads a double-precision value into the high-order bits of…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_loadl_pd","","Loads a double-precision value into the low-order bits of…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_stream_pd","","Stores a 128-bit floating point vector of `[2 x double]`…",null,[[["__m128d"]]]],[5,"_mm_store_sd","","Stores the lower 64 bits of a 128-bit vector of `[2 x…",null,[[["__m128d"]]]],[5,"_mm_store_pd","","Stores 128-bits (composed of 2 packed double-precision…",null,[[["__m128d"]]]],[5,"_mm_storeu_pd","","Stores 128-bits (composed of 2 packed double-precision…",null,[[["__m128d"]]]],[5,"_mm_store1_pd","","Stores the lower double-precision (64-bit) floating-point…",null,[[["__m128d"]]]],[5,"_mm_store_pd1","","Stores the lower double-precision (64-bit) floating-point…",null,[[["__m128d"]]]],[5,"_mm_storer_pd","","Stores 2 double-precision (64-bit) floating-point elements…",null,[[["__m128d"]]]],[5,"_mm_storeh_pd","","Stores the upper 64 bits of a 128-bit vector of `[2 x…",null,[[["__m128d"]]]],[5,"_mm_storel_pd","","Stores the lower 64 bits of a 128-bit vector of `[2 x…",null,[[["__m128d"]]]],[5,"_mm_load1_pd","","Loads a double-precision (64-bit) floating-point element…",null,[[],["__m128d"]]],[5,"_mm_load_pd1","","Loads a double-precision (64-bit) floating-point element…",null,[[],["__m128d"]]],[5,"_mm_loadr_pd","","Loads 2 double-precision (64-bit) floating-point elements…",null,[[],["__m128d"]]],[5,"_mm_loadu_pd","","Loads 128-bits (composed of 2 packed double-precision…",null,[[],["__m128d"]]],[5,"_mm_shuffle_pd","","Constructs a 128-bit floating-point vector of `[2 x…",null,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_move_sd","","Constructs a 128-bit floating-point vector of `[2 x…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_castpd_ps","","Casts a 128-bit floating-point vector of `[2 x double]`…",null,[[["__m128d"]],["__m128"]]],[5,"_mm_castpd_si128","","Casts a 128-bit floating-point vector of `[2 x double]`…",null,[[["__m128d"]],["__m128i"]]],[5,"_mm_castps_pd","","Casts a 128-bit floating-point vector of `[4 x float]`…",null,[[["__m128"]],["__m128d"]]],[5,"_mm_castps_si128","","Casts a 128-bit floating-point vector of `[4 x float]`…",null,[[["__m128"]],["__m128i"]]],[5,"_mm_castsi128_pd","","Casts a 128-bit integer vector into a 128-bit…",null,[[["__m128i"]],["__m128d"]]],[5,"_mm_castsi128_ps","","Casts a 128-bit integer vector into a 128-bit…",null,[[["__m128i"]],["__m128"]]],[5,"_mm_undefined_pd","","Returns vector of type __m128d with undefined elements.",null,[[],["__m128d"]]],[5,"_mm_undefined_si128","","Returns vector of type __m128i with undefined elements.",null,[[],["__m128i"]]],[5,"_mm_unpackhi_pd","","The resulting `__m128d` element is composed by the…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_unpacklo_pd","","The resulting `__m128d` element is composed by the…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_add_si64","","Adds two signed or unsigned 64-bit integer values,…",null,[[["__m64"]],["__m64"]]],[5,"_mm_mul_su32","","Multiplies 32-bit unsigned integer values contained in the…",null,[[["__m64"]],["__m64"]]],[5,"_mm_sub_si64","","Subtracts signed or unsigned 64-bit integer values and…",null,[[["__m64"]],["__m64"]]],[5,"_mm_cvtpi32_pd","","Converts the two signed 32-bit integer elements of a…",null,[[["__m64"]],["__m128d"]]],[5,"_mm_set_epi64","","Initializes both 64-bit values in a 128-bit vector of `[2…",null,[[["__m64"]],["__m128i"]]],[5,"_mm_set1_epi64","","Initializes both values in a 128-bit vector of `[2 x i64]`…",null,[[["__m64"]],["__m128i"]]],[5,"_mm_setr_epi64","","Constructs a 128-bit integer vector, initialized in…",null,[[["__m64"]],["__m128i"]]],[5,"_mm_movepi64_pi64","","Returns the lower 64 bits of a 128-bit integer vector as a…",null,[[["__m128i"]],["__m64"]]],[5,"_mm_movpi64_epi64","","Moves the 64-bit operand to a 128-bit integer vector,…",null,[[["__m64"]],["__m128i"]]],[5,"_mm_cvtpd_pi32","","Converts the two double-precision floating-point elements…",null,[[["__m128d"]],["__m64"]]],[5,"_mm_cvttpd_pi32","","Converts the two double-precision floating-point elements…",null,[[["__m128d"]],["__m64"]]],[5,"_mm_addsub_ps","","Alternatively add and subtract packed single-precision…",null,[[["__m128"]],["__m128"]]],[5,"_mm_addsub_pd","","Alternatively add and subtract packed double-precision…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_hadd_pd","","Horizontally adds adjacent pairs of double-precision…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_hadd_ps","","Horizontally adds adjacent pairs of single-precision…",null,[[["__m128"]],["__m128"]]],[5,"_mm_hsub_pd","","Horizontally subtract adjacent pairs of double-precision…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_hsub_ps","","Horizontally adds adjacent pairs of single-precision…",null,[[["__m128"]],["__m128"]]],[5,"_mm_lddqu_si128","","Loads 128-bits of integer data from unaligned memory. This…",null,[[],["__m128i"]]],[5,"_mm_movedup_pd","","Duplicate the low double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_loaddup_pd","","Loads a double-precision (64-bit) floating-point element…",null,[[],["__m128d"]]],[5,"_mm_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_moveldup_ps","","Duplicate even-indexed single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_abs_epi8","","Computes the absolute value of packed 8-bit signed…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_abs_epi16","","Computes the absolute value of each of the packed 16-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_abs_epi32","","Computes the absolute value of each of the packed 32-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_shuffle_epi8","","Shuffles bytes from `a` according to the content of `b`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_alignr_epi8","","Concatenate 16-byte blocks in `a` and `b` into a 32-byte…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_hadd_epi16","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_hadds_epi16","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_hadd_epi32","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_hsub_epi16","","Horizontally subtract the adjacent pairs of values…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_hsubs_epi16","","Horizontally subtract the adjacent pairs of values…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_hsub_epi32","","Horizontally subtract the adjacent pairs of values…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_maddubs_epi16","","Multiplies corresponding pairs of packed 8-bit unsigned…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_mulhrs_epi16","","Multiplies packed 16-bit signed integer values, truncate…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sign_epi8","","Negates packed 8-bit integers in `a` when the…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sign_epi16","","Negates packed 16-bit integers in `a` when the…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sign_epi32","","Negates packed 32-bit integers in `a` when the…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_abs_pi8","","Computes the absolute value of packed 8-bit integers in…",null,[[["__m64"]],["__m64"]]],[5,"_mm_abs_pi16","","Computes the absolute value of packed 8-bit integers in…",null,[[["__m64"]],["__m64"]]],[5,"_mm_abs_pi32","","Computes the absolute value of packed 32-bit integers in…",null,[[["__m64"]],["__m64"]]],[5,"_mm_shuffle_pi8","","Shuffles packed 8-bit integers in `a` according to shuffle…",null,[[["__m64"]],["__m64"]]],[5,"_mm_alignr_pi8","","Concatenates the two 64-bit integer vector operands, and…",null,[[["__m64"],["i32"]],["__m64"]]],[5,"_mm_hadd_pi16","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m64"]],["__m64"]]],[5,"_mm_hadd_pi32","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m64"]],["__m64"]]],[5,"_mm_hadds_pi16","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m64"]],["__m64"]]],[5,"_mm_hsub_pi16","","Horizontally subtracts the adjacent pairs of values…",null,[[["__m64"]],["__m64"]]],[5,"_mm_hsub_pi32","","Horizontally subtracts the adjacent pairs of values…",null,[[["__m64"]],["__m64"]]],[5,"_mm_hsubs_pi16","","Horizontally subtracts the adjacent pairs of values…",null,[[["__m64"]],["__m64"]]],[5,"_mm_maddubs_pi16","","Multiplies corresponding pairs of packed 8-bit unsigned…",null,[[["__m64"]],["__m64"]]],[5,"_mm_mulhrs_pi16","","Multiplies packed 16-bit signed integer values, truncates…",null,[[["__m64"]],["__m64"]]],[5,"_mm_sign_pi8","","Negates packed 8-bit integers in `a` when the…",null,[[["__m64"]],["__m64"]]],[5,"_mm_sign_pi16","","Negates packed 16-bit integers in `a` when the…",null,[[["__m64"]],["__m64"]]],[5,"_mm_sign_pi32","","Negates packed 32-bit integers in `a` when the…",null,[[["__m64"]],["__m64"]]],[5,"_mm_blendv_epi8","","Blend packed 8-bit integers from `a` and `b` using `mask`",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_blend_epi16","","Blend packed 16-bit integers from `a` and `b` using the…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_blendv_pd","","Blend packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_blendv_ps","","Blend packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm_blend_pd","","Blend packed double-precision (64-bit) floating-point…",null,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_blend_ps","","Blend packed single-precision (32-bit) floating-point…",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm_extract_ps","","Extracts a single-precision (32-bit) floating-point…",null,[[["i32"],["__m128"]],["i32"]]],[5,"_mm_extract_epi8","","Extracts an 8-bit integer from `a`, selected with `imm8`.…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_extract_epi32","","Extracts an 32-bit integer from `a` selected with `imm8`",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_insert_ps","","Select a single value in `a` to store at some position in…",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm_insert_epi8","","Returns a copy of `a` with the 8-bit integer from `i`…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_insert_epi32","","Returns a copy of `a` with the 32-bit integer from `i`…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_max_epi8","","Compares packed 8-bit integers in `a` and `b` and returns…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_max_epu16","","Compares packed unsigned 16-bit integers in `a` and `b`,…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_max_epi32","","Compares packed 32-bit integers in `a` and `b`, and…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_max_epu32","","Compares packed unsigned 32-bit integers in `a` and `b`,…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_min_epi8","","Compares packed 8-bit integers in `a` and `b` and returns…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_min_epu16","","Compares packed unsigned 16-bit integers in `a` and `b`,…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_min_epi32","","Compares packed 32-bit integers in `a` and `b`, and…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_min_epu32","","Compares packed unsigned 32-bit integers in `a` and `b`,…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_packus_epi32","","Converts packed 32-bit integers from `a` and `b` to packed…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cmpeq_epi64","","Compares packed 64-bit integers in `a` and `b` for equality",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi8_epi16","","Sign extend packed 8-bit integers in `a` to packed 16-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi8_epi32","","Sign extend packed 8-bit integers in `a` to packed 32-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi8_epi64","","Sign extend packed 8-bit integers in the low 8 bytes of…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi16_epi32","","Sign extend packed 16-bit integers in `a` to packed 32-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi16_epi64","","Sign extend packed 16-bit integers in `a` to packed 64-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepi32_epi64","","Sign extend packed 32-bit integers in `a` to packed 64-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu8_epi16","","Zeroes extend packed unsigned 8-bit integers in `a` to…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu8_epi32","","Zeroes extend packed unsigned 8-bit integers in `a` to…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu8_epi64","","Zeroes extend packed unsigned 8-bit integers in `a` to…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu16_epi32","","Zeroes extend packed unsigned 16-bit integers in `a` to…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu16_epi64","","Zeroes extend packed unsigned 16-bit integers in `a` to…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_cvtepu32_epi64","","Zeroes extend packed unsigned 32-bit integers in `a` to…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_dp_pd","","Returns the dot product of two __m128d vectors.",null,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_dp_ps","","Returns the dot product of two __m128 vectors.",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm_floor_pd","","Round the packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_floor_ps","","Round the packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm_floor_sd","","Round the lower double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_floor_ss","","Round the lower single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm_ceil_pd","","Round the packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_ceil_ps","","Round the packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm_ceil_sd","","Round the lower double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_ceil_ss","","Round the lower single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm_round_pd","","Round the packed double-precision (64-bit) floating-point…",null,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_round_ps","","Round the packed single-precision (32-bit) floating-point…",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm_round_sd","","Round the lower double-precision (64-bit) floating-point…",null,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_round_ss","","Round the lower single-precision (32-bit) floating-point…",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm_minpos_epu16","","Finds the minimum unsigned 16-bit element in the 128-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_mul_epi32","","Multiplies the low 32-bit integers from each packed 64-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_mullo_epi32","","Multiplies the packed 32-bit integers in `a` and `b`,…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_mpsadbw_epu8","","Subtracts 8-bit unsigned integer values and computes the…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_testz_si128","","Tests whether the specified bits in a 128-bit integer…",null,[[["__m128i"]],["i32"]]],[5,"_mm_testc_si128","","Tests whether the specified bits in a 128-bit integer…",null,[[["__m128i"]],["i32"]]],[5,"_mm_testnzc_si128","","Tests whether the specified bits in a 128-bit integer…",null,[[["__m128i"]],["i32"]]],[5,"_mm_test_all_zeros","","Tests whether the specified bits in a 128-bit integer…",null,[[["__m128i"]],["i32"]]],[5,"_mm_test_all_ones","","Tests whether the specified bits in `a` 128-bit integer…",null,[[["__m128i"]],["i32"]]],[5,"_mm_test_mix_ones_zeros","","Tests whether the specified bits in a 128-bit integer…",null,[[["__m128i"]],["i32"]]],[5,"_mm_cmpistrm","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_cmpistri","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistrz","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistrc","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistrs","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistro","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpistra","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpestrm","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_cmpestri","","Compares packed strings `a` and `b` with lengths `la` and…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpestrz","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpestrc","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpestrs","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpestro","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_cmpestra","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i"],["i32"]],["i32"]]],[5,"_mm_crc32_u8","","Starting with the initial value in `crc`, return the…",null,[[["u32"],["u8"]],["u32"]]],[5,"_mm_crc32_u16","","Starting with the initial value in `crc`, return the…",null,[[["u16"],["u32"]],["u32"]]],[5,"_mm_crc32_u32","","Starting with the initial value in `crc`, return the…",null,[[["u32"]],["u32"]]],[5,"_mm_cmpgt_epi64","","Compares packed 64-bit integers in `a` and `b` for…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_add_pd","","Adds packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_add_ps","","Adds packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_and_pd","","Computes the bitwise AND of a packed double-precision…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_and_ps","","Computes the bitwise AND of packed single-precision…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_or_pd","","Computes the bitwise OR packed double-precision (64-bit)…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_or_ps","","Computes the bitwise OR packed single-precision (32-bit)…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_shuffle_pd","","Shuffles double-precision (64-bit) floating-point elements…",null,[[["i32"],["__m256d"]],["__m256d"]]],[5,"_mm256_shuffle_ps","","Shuffles single-precision (32-bit) floating-point elements…",null,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm256_andnot_pd","","Computes the bitwise NOT of packed double-precision…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_andnot_ps","","Computes the bitwise NOT of packed single-precision…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_max_pd","","Compares packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_max_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_min_pd","","Compares packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_min_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_mul_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_mul_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_addsub_pd","","Alternatively adds and subtracts packed double-precision…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_addsub_ps","","Alternatively adds and subtracts packed single-precision…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_sub_pd","","Subtracts packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_sub_ps","","Subtracts packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_div_ps","","Computes the division of each of the 8 packed 32-bit…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_div_pd","","Computes the division of each of the 4 packed 64-bit…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_round_pd","","Rounds packed double-precision (64-bit) floating point…",null,[[["i32"],["__m256d"]],["__m256d"]]],[5,"_mm256_ceil_pd","","Rounds packed double-precision (64-bit) floating point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_floor_pd","","Rounds packed double-precision (64-bit) floating point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_round_ps","","Rounds packed single-precision (32-bit) floating point…",null,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm256_ceil_ps","","Rounds packed single-precision (32-bit) floating point…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_floor_ps","","Rounds packed single-precision (32-bit) floating point…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_sqrt_ps","","Returns the square root of packed single-precision…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_sqrt_pd","","Returns the square root of packed double-precision…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_blend_pd","","Blends packed double-precision (64-bit) floating-point…",null,[[["i32"],["__m256d"]],["__m256d"]]],[5,"_mm256_blend_ps","","Blends packed single-precision (32-bit) floating-point…",null,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm256_blendv_pd","","Blends packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_blendv_ps","","Blends packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_dp_ps","","Conditionally multiplies the packed single-precision…",null,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm256_hadd_pd","","Horizontal addition of adjacent pairs in the two packed…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_hadd_ps","","Horizontal addition of adjacent pairs in the two packed…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_hsub_pd","","Horizontal subtraction of adjacent pairs in the two packed…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_hsub_ps","","Horizontal subtraction of adjacent pairs in the two packed…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_xor_pd","","Computes the bitwise XOR of packed double-precision…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_xor_ps","","Computes the bitwise XOR of packed single-precision…",null,[[["__m256"]],["__m256"]]],[5,"_mm_cmp_pd","","Compares packed double-precision (64-bit) floating-point…",null,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm256_cmp_pd","","Compares packed double-precision (64-bit) floating-point…",null,[[["i32"],["__m256d"]],["__m256d"]]],[5,"_mm_cmp_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm256_cmp_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm_cmp_sd","","Compares the lower double-precision (64-bit)…",null,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm_cmp_ss","","Compares the lower single-precision (32-bit)…",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm256_cvtepi32_pd","","Converts packed 32-bit integers in `a` to packed…",null,[[["__m128i"]],["__m256d"]]],[5,"_mm256_cvtepi32_ps","","Converts packed 32-bit integers in `a` to packed…",null,[[["__m256i"]],["__m256"]]],[5,"_mm256_cvtpd_ps","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m128"]]],[5,"_mm256_cvtps_epi32","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256i"]]],[5,"_mm256_cvtps_pd","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m256d"]]],[5,"_mm256_cvttpd_epi32","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m128i"]]],[5,"_mm256_cvtpd_epi32","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m128i"]]],[5,"_mm256_cvttps_epi32","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256i"]]],[5,"_mm256_extractf128_ps","","Extracts 128 bits (composed of 4 packed single-precision…",null,[[["__m256"],["i32"]],["__m128"]]],[5,"_mm256_extractf128_pd","","Extracts 128 bits (composed of 2 packed double-precision…",null,[[["i32"],["__m256d"]],["__m128d"]]],[5,"_mm256_extractf128_si256","","Extracts 128 bits (composed of integer data) from `a`,…",null,[[["__m256i"],["i32"]],["__m128i"]]],[5,"_mm256_zeroall","","Zeroes the contents of all XMM or YMM registers.",null,[[]]],[5,"_mm256_zeroupper","","Zeroes the upper 128 bits of all YMM registers; the lower…",null,[[]]],[5,"_mm256_permutevar_ps","","Shuffles single-precision (32-bit) floating-point elements…",null,[[["__m256"],["__m256i"]],["__m256"]]],[5,"_mm_permutevar_ps","","Shuffles single-precision (32-bit) floating-point elements…",null,[[["__m128i"],["__m128"]],["__m128"]]],[5,"_mm256_permute_ps","","Shuffles single-precision (32-bit) floating-point elements…",null,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm_permute_ps","","Shuffles single-precision (32-bit) floating-point elements…",null,[[["i32"],["__m128"]],["__m128"]]],[5,"_mm256_permutevar_pd","","Shuffles double-precision (64-bit) floating-point elements…",null,[[["__m256i"],["__m256d"]],["__m256d"]]],[5,"_mm_permutevar_pd","","Shuffles double-precision (64-bit) floating-point elements…",null,[[["__m128d"],["__m128i"]],["__m128d"]]],[5,"_mm256_permute_pd","","Shuffles double-precision (64-bit) floating-point elements…",null,[[["i32"],["__m256d"]],["__m256d"]]],[5,"_mm_permute_pd","","Shuffles double-precision (64-bit) floating-point elements…",null,[[["__m128d"],["i32"]],["__m128d"]]],[5,"_mm256_permute2f128_ps","","Shuffles 256 bits (composed of 8 packed single-precision…",null,[[["__m256"],["i32"]],["__m256"]]],[5,"_mm256_permute2f128_pd","","Shuffles 256 bits (composed of 4 packed double-precision…",null,[[["i32"],["__m256d"]],["__m256d"]]],[5,"_mm256_permute2f128_si256","","Shuffles 258-bits (composed of integer data) selected by…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_broadcast_ss","","Broadcasts a single-precision (32-bit) floating-point…",null,[[["f32"]],["__m256"]]],[5,"_mm_broadcast_ss","","Broadcasts a single-precision (32-bit) floating-point…",null,[[["f32"]],["__m128"]]],[5,"_mm256_broadcast_sd","","Broadcasts a double-precision (64-bit) floating-point…",null,[[["f64"]],["__m256d"]]],[5,"_mm256_broadcast_ps","","Broadcasts 128 bits from memory (composed of 4 packed…",null,[[["__m128"]],["__m256"]]],[5,"_mm256_broadcast_pd","","Broadcasts 128 bits from memory (composed of 2 packed…",null,[[["__m128d"]],["__m256d"]]],[5,"_mm256_insertf128_ps","","Copies `a` to result, then inserts 128 bits (composed of 4…",null,[[["__m256"],["i32"],["__m128"]],["__m256"]]],[5,"_mm256_insertf128_pd","","Copies `a` to result, then inserts 128 bits (composed of 2…",null,[[["i32"],["__m128d"],["__m256d"]],["__m256d"]]],[5,"_mm256_insertf128_si256","","Copies `a` to result, then inserts 128 bits from `b` into…",null,[[["i32"],["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_insert_epi8","","Copies `a` to result, and inserts the 8-bit integer `i`…",null,[[["i8"],["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_insert_epi16","","Copies `a` to result, and inserts the 16-bit integer `i`…",null,[[["i32"],["__m256i"],["i16"]],["__m256i"]]],[5,"_mm256_insert_epi32","","Copies `a` to result, and inserts the 32-bit integer `i`…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_load_pd","","Loads 256-bits (composed of 4 packed double-precision…",null,[[],["__m256d"]]],[5,"_mm256_store_pd","","Stores 256-bits (composed of 4 packed double-precision…",null,[[["__m256d"]]]],[5,"_mm256_load_ps","","Loads 256-bits (composed of 8 packed single-precision…",null,[[],["__m256"]]],[5,"_mm256_store_ps","","Stores 256-bits (composed of 8 packed single-precision…",null,[[["__m256"]]]],[5,"_mm256_loadu_pd","","Loads 256-bits (composed of 4 packed double-precision…",null,[[],["__m256d"]]],[5,"_mm256_storeu_pd","","Stores 256-bits (composed of 4 packed double-precision…",null,[[["__m256d"]]]],[5,"_mm256_loadu_ps","","Loads 256-bits (composed of 8 packed single-precision…",null,[[],["__m256"]]],[5,"_mm256_storeu_ps","","Stores 256-bits (composed of 8 packed single-precision…",null,[[["__m256"]]]],[5,"_mm256_load_si256","","Loads 256-bits of integer data from memory into result.…",null,[[],["__m256i"]]],[5,"_mm256_store_si256","","Stores 256-bits of integer data from `a` into memory.…",null,[[["__m256i"]]]],[5,"_mm256_loadu_si256","","Loads 256-bits of integer data from memory into result.…",null,[[],["__m256i"]]],[5,"_mm256_storeu_si256","","Stores 256-bits of integer data from `a` into memory.…",null,[[["__m256i"]]]],[5,"_mm256_maskload_pd","","Loads packed double-precision (64-bit) floating-point…",null,[[["__m256i"]],["__m256d"]]],[5,"_mm256_maskstore_pd","","Stores packed double-precision (64-bit) floating-point…",null,[[["__m256d"],["__m256i"]]]],[5,"_mm_maskload_pd","","Loads packed double-precision (64-bit) floating-point…",null,[[["__m128i"]],["__m128d"]]],[5,"_mm_maskstore_pd","","Stores packed double-precision (64-bit) floating-point…",null,[[["__m128d"],["__m128i"]]]],[5,"_mm256_maskload_ps","","Loads packed single-precision (32-bit) floating-point…",null,[[["__m256i"]],["__m256"]]],[5,"_mm256_maskstore_ps","","Stores packed single-precision (32-bit) floating-point…",null,[[["__m256"],["__m256i"]]]],[5,"_mm_maskload_ps","","Loads packed single-precision (32-bit) floating-point…",null,[[["__m128i"]],["__m128"]]],[5,"_mm_maskstore_ps","","Stores packed single-precision (32-bit) floating-point…",null,[[["__m128"],["__m128i"]]]],[5,"_mm256_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit)…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_moveldup_ps","","Duplicate even-indexed single-precision (32-bit)…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_movedup_pd","","Duplicate even-indexed double-precision (64-bit)…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_lddqu_si256","","Loads 256-bits of integer data from unaligned memory into…",null,[[],["__m256i"]]],[5,"_mm256_stream_si256","","Moves integer data from a 256-bit integer vector to a…",null,[[["__m256i"]]]],[5,"_mm256_stream_pd","","Moves double-precision values from a 256-bit vector of `[4…",null,[[["__m256d"]]]],[5,"_mm256_stream_ps","","Moves single-precision floating point values from a…",null,[[["__m256"]]]],[5,"_mm256_rcp_ps","","Computes the approximate reciprocal of packed…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_rsqrt_ps","","Computes the approximate reciprocal square root of packed…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_unpackhi_pd","","Unpacks and interleave double-precision (64-bit)…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_unpackhi_ps","","Unpacks and interleave single-precision (32-bit)…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_unpacklo_pd","","Unpacks and interleave double-precision (64-bit)…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm256_unpacklo_ps","","Unpacks and interleave single-precision (32-bit)…",null,[[["__m256"]],["__m256"]]],[5,"_mm256_testz_si256","","Computes the bitwise AND of 256 bits (representing integer…",null,[[["__m256i"]],["i32"]]],[5,"_mm256_testc_si256","","Computes the bitwise AND of 256 bits (representing integer…",null,[[["__m256i"]],["i32"]]],[5,"_mm256_testnzc_si256","","Computes the bitwise AND of 256 bits (representing integer…",null,[[["__m256i"]],["i32"]]],[5,"_mm256_testz_pd","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256d"]],["i32"]]],[5,"_mm256_testc_pd","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256d"]],["i32"]]],[5,"_mm256_testnzc_pd","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256d"]],["i32"]]],[5,"_mm_testz_pd","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128d"]],["i32"]]],[5,"_mm_testc_pd","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128d"]],["i32"]]],[5,"_mm_testnzc_pd","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128d"]],["i32"]]],[5,"_mm256_testz_ps","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256"]],["i32"]]],[5,"_mm256_testc_ps","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256"]],["i32"]]],[5,"_mm256_testnzc_ps","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256"]],["i32"]]],[5,"_mm_testz_ps","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128"]],["i32"]]],[5,"_mm_testc_ps","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128"]],["i32"]]],[5,"_mm_testnzc_ps","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128"]],["i32"]]],[5,"_mm256_movemask_pd","","Sets each bit of the returned mask based on the most…",null,[[["__m256d"]],["i32"]]],[5,"_mm256_movemask_ps","","Sets each bit of the returned mask based on the most…",null,[[["__m256"]],["i32"]]],[5,"_mm256_setzero_pd","","Returns vector of type __m256d with all elements set to…",null,[[],["__m256d"]]],[5,"_mm256_setzero_ps","","Returns vector of type __m256 with all elements set to zero.",null,[[],["__m256"]]],[5,"_mm256_setzero_si256","","Returns vector of type __m256i with all elements set to…",null,[[],["__m256i"]]],[5,"_mm256_set_pd","","Sets packed double-precision (64-bit) floating-point…",null,[[["f64"]],["__m256d"]]],[5,"_mm256_set_ps","","Sets packed single-precision (32-bit) floating-point…",null,[[["f32"]],["__m256"]]],[5,"_mm256_set_epi8","","Sets packed 8-bit integers in returned vector with the…",null,[[["i8"]],["__m256i"]]],[5,"_mm256_set_epi16","","Sets packed 16-bit integers in returned vector with the…",null,[[["i16"]],["__m256i"]]],[5,"_mm256_set_epi32","","Sets packed 32-bit integers in returned vector with the…",null,[[["i32"]],["__m256i"]]],[5,"_mm256_set_epi64x","","Sets packed 64-bit integers in returned vector with the…",null,[[["i64"]],["__m256i"]]],[5,"_mm256_setr_pd","","Sets packed double-precision (64-bit) floating-point…",null,[[["f64"]],["__m256d"]]],[5,"_mm256_setr_ps","","Sets packed single-precision (32-bit) floating-point…",null,[[["f32"]],["__m256"]]],[5,"_mm256_setr_epi8","","Sets packed 8-bit integers in returned vector with the…",null,[[["i8"]],["__m256i"]]],[5,"_mm256_setr_epi16","","Sets packed 16-bit integers in returned vector with the…",null,[[["i16"]],["__m256i"]]],[5,"_mm256_setr_epi32","","Sets packed 32-bit integers in returned vector with the…",null,[[["i32"]],["__m256i"]]],[5,"_mm256_setr_epi64x","","Sets packed 64-bit integers in returned vector with the…",null,[[["i64"]],["__m256i"]]],[5,"_mm256_set1_pd","","Broadcasts double-precision (64-bit) floating-point value…",null,[[["f64"]],["__m256d"]]],[5,"_mm256_set1_ps","","Broadcasts single-precision (32-bit) floating-point value…",null,[[["f32"]],["__m256"]]],[5,"_mm256_set1_epi8","","Broadcasts 8-bit integer `a` to all elements of returned…",null,[[["i8"]],["__m256i"]]],[5,"_mm256_set1_epi16","","Broadcasts 16-bit integer `a` to all all elements of…",null,[[["i16"]],["__m256i"]]],[5,"_mm256_set1_epi32","","Broadcasts 32-bit integer `a` to all elements of returned…",null,[[["i32"]],["__m256i"]]],[5,"_mm256_set1_epi64x","","Broadcasts 64-bit integer `a` to all elements of returned…",null,[[["i64"]],["__m256i"]]],[5,"_mm256_castpd_ps","","Cast vector of type __m256d to type __m256.",null,[[["__m256d"]],["__m256"]]],[5,"_mm256_castps_pd","","Cast vector of type __m256 to type __m256d.",null,[[["__m256"]],["__m256d"]]],[5,"_mm256_castps_si256","","Casts vector of type __m256 to type __m256i.",null,[[["__m256"]],["__m256i"]]],[5,"_mm256_castsi256_ps","","Casts vector of type __m256i to type __m256.",null,[[["__m256i"]],["__m256"]]],[5,"_mm256_castpd_si256","","Casts vector of type __m256d to type __m256i.",null,[[["__m256d"]],["__m256i"]]],[5,"_mm256_castsi256_pd","","Casts vector of type __m256i to type __m256d.",null,[[["__m256i"]],["__m256d"]]],[5,"_mm256_castps256_ps128","","Casts vector of type __m256 to type __m128.",null,[[["__m256"]],["__m128"]]],[5,"_mm256_castpd256_pd128","","Casts vector of type __m256d to type __m128d.",null,[[["__m256d"]],["__m128d"]]],[5,"_mm256_castsi256_si128","","Casts vector of type __m256i to type __m128i.",null,[[["__m256i"]],["__m128i"]]],[5,"_mm256_castps128_ps256","","Casts vector of type __m128 to type __m256; the upper 128…",null,[[["__m128"]],["__m256"]]],[5,"_mm256_castpd128_pd256","","Casts vector of type __m128d to type __m256d; the upper…",null,[[["__m128d"]],["__m256d"]]],[5,"_mm256_castsi128_si256","","Casts vector of type __m128i to type __m256i; the upper…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_zextps128_ps256","","Constructs a 256-bit floating-point vector of `[8 x…",null,[[["__m128"]],["__m256"]]],[5,"_mm256_zextsi128_si256","","Constructs a 256-bit integer vector from a 128-bit integer…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_zextpd128_pd256","","Constructs a 256-bit floating-point vector of `[4 x…",null,[[["__m128d"]],["__m256d"]]],[5,"_mm256_undefined_ps","","Returns vector of type `__m256` with undefined elements.",null,[[],["__m256"]]],[5,"_mm256_undefined_pd","","Returns vector of type `__m256d` with undefined elements.",null,[[],["__m256d"]]],[5,"_mm256_undefined_si256","","Returns vector of type __m256i with undefined elements.",null,[[],["__m256i"]]],[5,"_mm256_set_m128","","Sets packed __m256 returned vector with the supplied values.",null,[[["__m128"]],["__m256"]]],[5,"_mm256_set_m128d","","Sets packed __m256d returned vector with the supplied…",null,[[["__m128d"]],["__m256d"]]],[5,"_mm256_set_m128i","","Sets packed __m256i returned vector with the supplied…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_setr_m128","","Sets packed __m256 returned vector with the supplied values.",null,[[["__m128"]],["__m256"]]],[5,"_mm256_setr_m128d","","Sets packed __m256d returned vector with the supplied…",null,[[["__m128d"]],["__m256d"]]],[5,"_mm256_setr_m128i","","Sets packed __m256i returned vector with the supplied…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_loadu2_m128","","Loads two 128-bit values (composed of 4 packed…",null,[[],["__m256"]]],[5,"_mm256_loadu2_m128d","","Loads two 128-bit values (composed of 2 packed…",null,[[],["__m256d"]]],[5,"_mm256_loadu2_m128i","","Loads two 128-bit values (composed of integer data) from…",null,[[],["__m256i"]]],[5,"_mm256_storeu2_m128","","Stores the high and low 128-bit halves (each composed of 4…",null,[[["__m256"]]]],[5,"_mm256_storeu2_m128d","","Stores the high and low 128-bit halves (each composed of 2…",null,[[["__m256d"]]]],[5,"_mm256_storeu2_m128i","","Stores the high and low 128-bit halves (each composed of…",null,[[["__m256i"]]]],[5,"_mm256_cvtss_f32","","Returns the first element of the input vector of `[8 x…",null,[[["__m256"]],["f32"]]],[5,"_mm256_abs_epi32","","Computes the absolute values of packed 32-bit integers in…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_abs_epi16","","Computes the absolute values of packed 16-bit integers in…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_abs_epi8","","Computes the absolute values of packed 8-bit integers in…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi64","","Adds packed 64-bit integers in `a` and `b`.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi32","","Adds packed 32-bit integers in `a` and `b`.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi16","","Adds packed 16-bit integers in `a` and `b`.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_add_epi8","","Adds packed 8-bit integers in `a` and `b`.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epi8","","Adds packed 8-bit integers in `a` and `b` using saturation.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epi16","","Adds packed 16-bit integers in `a` and `b` using saturation.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epu8","","Adds packed unsigned 8-bit integers in `a` and `b` using…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_adds_epu16","","Adds packed unsigned 16-bit integers in `a` and `b` using…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_alignr_epi8","","Concatenates pairs of 16-byte blocks in `a` and `b` into a…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_and_si256","","Computes the bitwise AND of 256 bits (representing integer…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_andnot_si256","","Computes the bitwise NOT of 256 bits (representing integer…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_avg_epu16","","Averages packed unsigned 16-bit integers in `a` and `b`.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_avg_epu8","","Averages packed unsigned 8-bit integers in `a` and `b`.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm_blend_epi32","","Blends packed 32-bit integers from `a` and `b` using…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm256_blend_epi32","","Blends packed 32-bit integers from `a` and `b` using…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_blend_epi16","","Blends packed 16-bit integers from `a` and `b` using…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_blendv_epi8","","Blends packed 8-bit integers from `a` and `b` using `mask`.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm_broadcastb_epi8","","Broadcasts the low packed 8-bit integer from `a` to all…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastb_epi8","","Broadcasts the low packed 8-bit integer from `a` to all…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastd_epi32","","Broadcasts the low packed 32-bit integer from `a` to all…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastd_epi32","","Broadcasts the low packed 32-bit integer from `a` to all…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastq_epi64","","Broadcasts the low packed 64-bit integer from `a` to all…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastq_epi64","","Broadcasts the low packed 64-bit integer from `a` to all…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastsd_pd","","Broadcasts the low double-precision (64-bit)…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm256_broadcastsd_pd","","Broadcasts the low double-precision (64-bit)…",null,[[["__m128d"]],["__m256d"]]],[5,"_mm256_broadcastsi128_si256","","Broadcasts 128 bits of integer data from a to all 128-bit…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm_broadcastss_ps","","Broadcasts the low single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm256_broadcastss_ps","","Broadcasts the low single-precision (32-bit)…",null,[[["__m128"]],["__m256"]]],[5,"_mm_broadcastw_epi16","","Broadcasts the low packed 16-bit integer from a to all…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_broadcastw_epi16","","Broadcasts the low packed 16-bit integer from a to all…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi64","","Compares packed 64-bit integers in `a` and `b` for equality.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi32","","Compares packed 32-bit integers in `a` and `b` for equality.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi16","","Compares packed 16-bit integers in `a` and `b` for equality.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_cmpeq_epi8","","Compares packed 8-bit integers in `a` and `b` for equality.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi64","","Compares packed 64-bit integers in `a` and `b` for…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi32","","Compares packed 32-bit integers in `a` and `b` for…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi16","","Compares packed 16-bit integers in `a` and `b` for…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_cmpgt_epi8","","Compares packed 8-bit integers in `a` and `b` for…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_cvtepi16_epi32","","Sign-extend 16-bit integers to 32-bit integers.",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi16_epi64","","Sign-extend 16-bit integers to 64-bit integers.",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi32_epi64","","Sign-extend 32-bit integers to 64-bit integers.",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi8_epi16","","Sign-extend 8-bit integers to 16-bit integers.",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi8_epi32","","Sign-extend 8-bit integers to 32-bit integers.",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepi8_epi64","","Sign-extend 8-bit integers to 64-bit integers.",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu16_epi32","","Zeroes extend packed unsigned 16-bit integers in `a` to…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu16_epi64","","Zero-extend the lower four unsigned 16-bit integers in `a`…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu32_epi64","","Zero-extend unsigned 32-bit integers in `a` to 64-bit…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu8_epi16","","Zero-extend unsigned 8-bit integers in `a` to 16-bit…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu8_epi32","","Zero-extend the lower eight unsigned 8-bit integers in `a`…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_cvtepu8_epi64","","Zero-extend the lower four unsigned 8-bit integers in `a`…",null,[[["__m128i"]],["__m256i"]]],[5,"_mm256_extracti128_si256","","Extracts 128 bits (of integer data) from `a` selected with…",null,[[["__m256i"],["i32"]],["__m128i"]]],[5,"_mm256_hadd_epi16","","Horizontally adds adjacent pairs of 16-bit integers in `a`…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_hadd_epi32","","Horizontally adds adjacent pairs of 32-bit integers in `a`…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_hadds_epi16","","Horizontally adds adjacent pairs of 16-bit integers in `a`…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_hsub_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_hsub_epi32","","Horizontally subtract adjacent pairs of 32-bit integers in…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_hsubs_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm_i32gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["i32"],["__m128i"]],["__m128i"]]],[5,"_mm_mask_i32gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["i32"],["__m128i"]],["__m128i"]]],[5,"_mm256_i32gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["i32"],["__m256i"]],["__m256i"]]],[5,"_mm256_mask_i32gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["i32"],["__m256i"]],["__m256i"]]],[5,"_mm_i32gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m128i"],["i32"]],["__m128"]]],[5,"_mm_mask_i32gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m128"],["i32"],["__m128i"]],["__m128"]]],[5,"_mm256_i32gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m256i"],["i32"]],["__m256"]]],[5,"_mm256_mask_i32gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m256i"],["i32"],["__m256"]],["__m256"]]],[5,"_mm_i32gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_mask_i32gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm256_i32gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i"],["i32"]],["__m256i"]]],[5,"_mm256_mask_i32gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m256i"],["i32"],["__m128i"]],["__m256i"]]],[5,"_mm_i32gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m128i"],["i32"]],["__m128d"]]],[5,"_mm_mask_i32gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["i32"],["__m128d"],["__m128i"]],["__m128d"]]],[5,"_mm256_i32gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m128i"],["i32"]],["__m256d"]]],[5,"_mm256_mask_i32gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["i32"],["__m128i"],["__m256d"]],["__m256d"]]],[5,"_mm_i64gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["i32"],["__m128i"]],["__m128i"]]],[5,"_mm_mask_i64gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["i32"],["__m128i"]],["__m128i"]]],[5,"_mm256_i64gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["i32"],["__m256i"]],["__m128i"]]],[5,"_mm256_mask_i64gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["__m256i"],["i32"],["__m128i"]],["__m128i"]]],[5,"_mm_i64gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m128i"],["i32"]],["__m128"]]],[5,"_mm_mask_i64gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m128"],["i32"],["__m128i"]],["__m128"]]],[5,"_mm256_i64gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m256i"],["i32"]],["__m128"]]],[5,"_mm256_mask_i64gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m256i"],["__m128"],["i32"]],["__m128"]]],[5,"_mm_i64gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_mask_i64gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm256_i64gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_mask_i64gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm_i64gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m128i"],["i32"]],["__m128d"]]],[5,"_mm_mask_i64gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["i32"],["__m128d"],["__m128i"]],["__m128d"]]],[5,"_mm256_i64gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m256i"],["i32"]],["__m256d"]]],[5,"_mm256_mask_i64gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m256i"],["i32"],["__m256d"]],["__m256d"]]],[5,"_mm256_inserti128_si256","","Copies `a` to `dst`, then insert 128 bits (of integer…",null,[[["i32"],["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_madd_epi16","","Multiplies packed signed 16-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_maddubs_epi16","","Vertically multiplies each unsigned 8-bit integer from `a`…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm_maskload_epi32","","Loads packed 32-bit integers from memory pointed by…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_maskload_epi32","","Loads packed 32-bit integers from memory pointed by…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm_maskload_epi64","","Loads packed 64-bit integers from memory pointed by…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_maskload_epi64","","Loads packed 64-bit integers from memory pointed by…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm_maskstore_epi32","","Stores packed 32-bit integers from `a` into memory pointed…",null,[[["__m128i"]]]],[5,"_mm256_maskstore_epi32","","Stores packed 32-bit integers from `a` into memory pointed…",null,[[["__m256i"]]]],[5,"_mm_maskstore_epi64","","Stores packed 64-bit integers from `a` into memory pointed…",null,[[["__m128i"]]]],[5,"_mm256_maskstore_epi64","","Stores packed 64-bit integers from `a` into memory pointed…",null,[[["__m256i"]]]],[5,"_mm256_max_epi16","","Compares packed 16-bit integers in `a` and `b`, and…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_max_epi32","","Compares packed 32-bit integers in `a` and `b`, and…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_max_epi8","","Compares packed 8-bit integers in `a` and `b`, and returns…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_max_epu16","","Compares packed unsigned 16-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_max_epu32","","Compares packed unsigned 32-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_max_epu8","","Compares packed unsigned 8-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_min_epi16","","Compares packed 16-bit integers in `a` and `b`, and…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_min_epi32","","Compares packed 32-bit integers in `a` and `b`, and…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_min_epi8","","Compares packed 8-bit integers in `a` and `b`, and returns…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_min_epu16","","Compares packed unsigned 16-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_min_epu32","","Compares packed unsigned 32-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_min_epu8","","Compares packed unsigned 8-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_movemask_epi8","","Creates mask from the most significant bit of each 8-bit…",null,[[["__m256i"]],["i32"]]],[5,"_mm256_mpsadbw_epu8","","Computes the sum of absolute differences (SADs) of…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_mul_epi32","","Multiplies the low 32-bit integers from each packed 64-bit…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_mul_epu32","","Multiplies the low unsigned 32-bit integers from each…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_mulhi_epi16","","Multiplies the packed 16-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_mulhi_epu16","","Multiplies the packed unsigned 16-bit integers in `a` and…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_mullo_epi16","","Multiplies the packed 16-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_mullo_epi32","","Multiplies the packed 32-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_mulhrs_epi16","","Multiplies packed 16-bit integers in `a` and `b`,…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_or_si256","","Computes the bitwise OR of 256 bits (representing integer…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_packs_epi16","","Converts packed 16-bit integers from `a` and `b` to packed…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_packs_epi32","","Converts packed 32-bit integers from `a` and `b` to packed…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_packus_epi16","","Converts packed 16-bit integers from `a` and `b` to packed…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_packus_epi32","","Converts packed 32-bit integers from `a` and `b` to packed…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_permutevar8x32_epi32","","Permutes packed 32-bit integers from `a` according to the…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_permute4x64_epi64","","Permutes 64-bit integers from `a` using control mask `imm8`.",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_permute2x128_si256","","Shuffles 128-bits of integer data selected by `imm8` from…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_permute4x64_pd","","Shuffles 64-bit floating-point elements in `a` across…",null,[[["i32"],["__m256d"]],["__m256d"]]],[5,"_mm256_permutevar8x32_ps","","Shuffles eight 32-bit foating-point elements in `a` across…",null,[[["__m256"],["__m256i"]],["__m256"]]],[5,"_mm256_sad_epu8","","Computes the absolute differences of packed unsigned 8-bit…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_shuffle_epi8","","Shuffles bytes from `a` according to the content of `b`.",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_shuffle_epi32","","Shuffles 32-bit integers in 128-bit lanes of `a` using the…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_shufflehi_epi16","","Shuffles 16-bit integers in the high 64 bits of 128-bit…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_shufflelo_epi16","","Shuffles 16-bit integers in the low 64 bits of 128-bit…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_sign_epi16","","Negates packed 16-bit integers in `a` when the…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_sign_epi32","","Negates packed 32-bit integers in `a` when the…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_sign_epi8","","Negates packed 8-bit integers in `a` when the…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_sll_epi16","","Shifts packed 16-bit integers in `a` left by `count` while…",null,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_sll_epi32","","Shifts packed 32-bit integers in `a` left by `count` while…",null,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_sll_epi64","","Shifts packed 64-bit integers in `a` left by `count` while…",null,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_slli_epi16","","Shifts packed 16-bit integers in `a` left by `imm8` while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_slli_epi32","","Shifts packed 32-bit integers in `a` left by `imm8` while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_slli_epi64","","Shifts packed 64-bit integers in `a` left by `imm8` while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_slli_si256","","Shifts 128-bit lanes in `a` left by `imm8` bytes while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_bslli_epi128","","Shifts 128-bit lanes in `a` left by `imm8` bytes while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm_sllv_epi32","","Shifts packed 32-bit integers in `a` left by the amount…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_sllv_epi32","","Shifts packed 32-bit integers in `a` left by the amount…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm_sllv_epi64","","Shifts packed 64-bit integers in `a` left by the amount…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_sllv_epi64","","Shifts packed 64-bit integers in `a` left by the amount…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_sra_epi16","","Shifts packed 16-bit integers in `a` right by `count`…",null,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_sra_epi32","","Shifts packed 32-bit integers in `a` right by `count`…",null,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srai_epi16","","Shifts packed 16-bit integers in `a` right by `imm8` while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srai_epi32","","Shifts packed 32-bit integers in `a` right by `imm8` while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm_srav_epi32","","Shifts packed 32-bit integers in `a` right by the amount…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_srav_epi32","","Shifts packed 32-bit integers in `a` right by the amount…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_srli_si256","","Shifts 128-bit lanes in `a` right by `imm8` bytes while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_bsrli_epi128","","Shifts 128-bit lanes in `a` right by `imm8` bytes while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srl_epi16","","Shifts packed 16-bit integers in `a` right by `count`…",null,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srl_epi32","","Shifts packed 32-bit integers in `a` right by `count`…",null,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srl_epi64","","Shifts packed 64-bit integers in `a` right by `count`…",null,[[["__m256i"],["__m128i"]],["__m256i"]]],[5,"_mm256_srli_epi16","","Shifts packed 16-bit integers in `a` right by `imm8` while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srli_epi32","","Shifts packed 32-bit integers in `a` right by `imm8` while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm256_srli_epi64","","Shifts packed 64-bit integers in `a` right by `imm8` while…",null,[[["__m256i"],["i32"]],["__m256i"]]],[5,"_mm_srlv_epi32","","Shifts packed 32-bit integers in `a` right by the amount…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_srlv_epi32","","Shifts packed 32-bit integers in `a` right by the amount…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm_srlv_epi64","","Shifts packed 64-bit integers in `a` right by the amount…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm256_srlv_epi64","","Shifts packed 64-bit integers in `a` right by the amount…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 16-bit…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 16-bit…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_sub_epi8","","Subtract packed 8-bit integers in `b` from packed 16-bit…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi8","","Unpacks and interleave 8-bit integers from the high half…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi8","","Unpacks and interleave 8-bit integers from the low half of…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi16","","Unpacks and interleave 16-bit integers from the high half…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi16","","Unpacks and interleave 16-bit integers from the low half…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi32","","Unpacks and interleave 32-bit integers from the high half…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi32","","Unpacks and interleave 32-bit integers from the low half…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_unpackhi_epi64","","Unpacks and interleave 64-bit integers from the high half…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_unpacklo_epi64","","Unpacks and interleave 64-bit integers from the low half…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_xor_si256","","Computes the bitwise XOR of 256 bits (representing integer…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_extract_epi8","","Extracts an 8-bit integer from `a`, selected with `imm8`.…",null,[[["__m256i"],["i32"]],["i8"]]],[5,"_mm256_extract_epi16","","Extracts a 16-bit integer from `a`, selected with `imm8`.…",null,[[["__m256i"],["i32"]],["i16"]]],[5,"_mm256_extract_epi32","","Extracts a 32-bit integer from `a`, selected with `imm8`.",null,[[["__m256i"],["i32"]],["i32"]]],[5,"_mm256_cvtsd_f64","","Returns the first element of the input vector of `[4 x…",null,[[["__m256d"]],["f64"]]],[5,"_mm256_cvtsi256_si32","","Returns the first element of the input vector of `[8 x…",null,[[["__m256i"]],["i32"]]],[5,"_mm_fmadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm256_fmadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm_fmadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm256_fmadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm_fmadd_sd","","Multiplies the lower double-precision (64-bit)…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_fmadd_ss","","Multiplies the lower single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_fmaddsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm256_fmaddsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm_fmaddsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm256_fmaddsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm_fmsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm256_fmsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm_fmsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm256_fmsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm_fmsub_sd","","Multiplies the lower double-precision (64-bit)…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_fmsub_ss","","Multiplies the lower single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_fmsubadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm256_fmsubadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm_fmsubadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm256_fmsubadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm_fnmadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm256_fnmadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm_fnmadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm256_fnmadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm_fnmadd_sd","","Multiplies the lower double-precision (64-bit)…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_fnmadd_ss","","Multiplies the lower single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_mm_fnmsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm256_fnmsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d"]],["__m256d"]]],[5,"_mm_fnmsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128"]],["__m128"]]],[5,"_mm256_fnmsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256"]],["__m256"]]],[5,"_mm_fnmsub_sd","","Multiplies the lower double-precision (64-bit)…",null,[[["__m128d"]],["__m128d"]]],[5,"_mm_fnmsub_ss","","Multiplies the lower single-precision (32-bit)…",null,[[["__m128"]],["__m128"]]],[5,"_lzcnt_u32","","Counts the leading most significant zero bits.",null,[[["u32"]],["u32"]]],[5,"_popcnt32","","Counts the bits that are set.",null,[[["i32"]],["i32"]]],[5,"_bextr_u32","","Extracts bits in range [`start`, `start` + `length`) from…",null,[[["u32"]],["u32"]]],[5,"_bextr2_u32","","Extracts bits of `a` specified by `control` into the least…",null,[[["u32"]],["u32"]]],[5,"_andn_u32","","Bitwise logical `AND` of inverted `a` with `b`.",null,[[["u32"]],["u32"]]],[5,"_blsi_u32","","Extracts lowest set isolated bit.",null,[[["u32"]],["u32"]]],[5,"_blsmsk_u32","","Gets mask up to lowest set bit.",null,[[["u32"]],["u32"]]],[5,"_blsr_u32","","Resets the lowest set bit of `x`.",null,[[["u32"]],["u32"]]],[5,"_tzcnt_u32","","Counts the number of trailing least significant zero bits.",null,[[["u32"]],["u32"]]],[5,"_mm_tzcnt_32","","Counts the number of trailing least significant zero bits.",null,[[["u32"]],["i32"]]],[5,"_mulx_u32","","Unsigned multiply without affecting flags.",null,[[["u32"],["u32"]],["u32"]]],[5,"_bzhi_u32","","Zeroes higher bits of `a` >= `index`.",null,[[["u32"]],["u32"]]],[5,"_pdep_u32","","Scatter contiguous low order bits of `a` to the result at…",null,[[["u32"]],["u32"]]],[5,"_pext_u32","","Gathers the bits of `x` specified by the `mask` into the…",null,[[["u32"]],["u32"]]],[5,"_mm_extract_si64","","Extracts the bit range specified by `y` from the lower 64…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_insert_si64","","Inserts the `[length:0]` bits of `y` into `x` at `index`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_stream_sd","","Non-temporal store of `a.0` into `p`.",null,[[["__m128d"]]]],[5,"_mm_stream_ss","","Non-temporal store of `a.0` into `p`.",null,[[["__m128"]]]],[5,"_blcfill_u32","","Clears all bits below the least significant zero bit of `x`.",null,[[["u32"]],["u32"]]],[5,"_blci_u32","","Sets all bits of `x` to 1 except for the least significant…",null,[[["u32"]],["u32"]]],[5,"_blcic_u32","","Sets the least significant zero bit of `x` and clears all…",null,[[["u32"]],["u32"]]],[5,"_blcmsk_u32","","Sets the least significant zero bit of `x` and clears all…",null,[[["u32"]],["u32"]]],[5,"_blcs_u32","","Sets the least significant zero bit of `x`.",null,[[["u32"]],["u32"]]],[5,"_blsfill_u32","","Sets all bits of `x` below the least significant one.",null,[[["u32"]],["u32"]]],[5,"_blsic_u32","","Clears least significant bit and sets all other bits.",null,[[["u32"]],["u32"]]],[5,"_t1mskc_u32","","Clears all bits below the least significant zero of `x`…",null,[[["u32"]],["u32"]]],[5,"_tzmsk_u32","","Sets all bits below the least significant one of `x` and…",null,[[["u32"]],["u32"]]],[5,"_mm_setzero_si64","","Constructs a 64-bit integer vector initialized to zero.",null,[[],["__m64"]]],[5,"_mm_add_pi8","","Adds packed 8-bit integers in `a` and `b`.",null,[[["__m64"]],["__m64"]]],[5,"_m_paddb","","Adds packed 8-bit integers in `a` and `b`.",null,[[["__m64"]],["__m64"]]],[5,"_mm_add_pi16","","Adds packed 16-bit integers in `a` and `b`.",null,[[["__m64"]],["__m64"]]],[5,"_m_paddw","","Adds packed 16-bit integers in `a` and `b`.",null,[[["__m64"]],["__m64"]]],[5,"_mm_add_pi32","","Adds packed 32-bit integers in `a` and `b`.",null,[[["__m64"]],["__m64"]]],[5,"_m_paddd","","Adds packed 32-bit integers in `a` and `b`.",null,[[["__m64"]],["__m64"]]],[5,"_mm_adds_pi8","","Adds packed 8-bit integers in `a` and `b` using saturation.",null,[[["__m64"]],["__m64"]]],[5,"_m_paddsb","","Adds packed 8-bit integers in `a` and `b` using saturation.",null,[[["__m64"]],["__m64"]]],[5,"_mm_adds_pi16","","Adds packed 16-bit integers in `a` and `b` using saturation.",null,[[["__m64"]],["__m64"]]],[5,"_m_paddsw","","Adds packed 16-bit integers in `a` and `b` using saturation.",null,[[["__m64"]],["__m64"]]],[5,"_mm_adds_pu8","","Adds packed unsigned 8-bit integers in `a` and `b` using…",null,[[["__m64"]],["__m64"]]],[5,"_m_paddusb","","Adds packed unsigned 8-bit integers in `a` and `b` using…",null,[[["__m64"]],["__m64"]]],[5,"_mm_adds_pu16","","Adds packed unsigned 16-bit integers in `a` and `b` using…",null,[[["__m64"]],["__m64"]]],[5,"_m_paddusw","","Adds packed unsigned 16-bit integers in `a` and `b` using…",null,[[["__m64"]],["__m64"]]],[5,"_mm_sub_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m64"]],["__m64"]]],[5,"_m_psubb","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m64"]],["__m64"]]],[5,"_mm_sub_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m64"]],["__m64"]]],[5,"_m_psubw","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m64"]],["__m64"]]],[5,"_mm_sub_pi32","","Subtract packed 32-bit integers in `b` from packed 32-bit…",null,[[["__m64"]],["__m64"]]],[5,"_m_psubd","","Subtract packed 32-bit integers in `b` from packed 32-bit…",null,[[["__m64"]],["__m64"]]],[5,"_mm_subs_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m64"]],["__m64"]]],[5,"_m_psubsb","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m64"]],["__m64"]]],[5,"_mm_subs_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m64"]],["__m64"]]],[5,"_m_psubsw","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m64"]],["__m64"]]],[5,"_mm_subs_pu8","","Subtract packed unsigned 8-bit integers in `b` from packed…",null,[[["__m64"]],["__m64"]]],[5,"_m_psubusb","","Subtract packed unsigned 8-bit integers in `b` from packed…",null,[[["__m64"]],["__m64"]]],[5,"_mm_subs_pu16","","Subtract packed unsigned 16-bit integers in `b` from…",null,[[["__m64"]],["__m64"]]],[5,"_m_psubusw","","Subtract packed unsigned 16-bit integers in `b` from…",null,[[["__m64"]],["__m64"]]],[5,"_mm_packs_pi16","","Converts packed 16-bit integers from `a` and `b` to packed…",null,[[["__m64"]],["__m64"]]],[5,"_mm_packs_pi32","","Converts packed 32-bit integers from `a` and `b` to packed…",null,[[["__m64"]],["__m64"]]],[5,"_mm_cmpgt_pi8","","Compares whether each element of `a` is greater than the…",null,[[["__m64"]],["__m64"]]],[5,"_mm_cmpgt_pi16","","Compares whether each element of `a` is greater than the…",null,[[["__m64"]],["__m64"]]],[5,"_mm_cmpgt_pi32","","Compares whether each element of `a` is greater than the…",null,[[["__m64"]],["__m64"]]],[5,"_mm_unpackhi_pi16","","Unpacks the upper two elements from two `i16x4` vectors…",null,[[["__m64"]],["__m64"]]],[5,"_mm_unpackhi_pi8","","Unpacks the upper four elements from two `i8x8` vectors…",null,[[["__m64"]],["__m64"]]],[5,"_mm_unpacklo_pi8","","Unpacks the lower four elements from two `i8x8` vectors…",null,[[["__m64"]],["__m64"]]],[5,"_mm_unpacklo_pi16","","Unpacks the lower two elements from two `i16x4` vectors…",null,[[["__m64"]],["__m64"]]],[5,"_mm_unpackhi_pi32","","Unpacks the upper element from two `i32x2` vectors and…",null,[[["__m64"]],["__m64"]]],[5,"_mm_unpacklo_pi32","","Unpacks the lower element from two `i32x2` vectors and…",null,[[["__m64"]],["__m64"]]],[5,"_mm_set_pi16","","Sets packed 16-bit integers in dst with the supplied values.",null,[[["i16"]],["__m64"]]],[5,"_mm_set_pi32","","Sets packed 32-bit integers in dst with the supplied values.",null,[[["i32"]],["__m64"]]],[5,"_mm_set_pi8","","Sets packed 8-bit integers in dst with the supplied values.",null,[[["i8"]],["__m64"]]],[5,"_mm_set1_pi16","","Broadcasts 16-bit integer a to all all elements of dst.",null,[[["i16"]],["__m64"]]],[5,"_mm_set1_pi32","","Broadcasts 32-bit integer a to all all elements of dst.",null,[[["i32"]],["__m64"]]],[5,"_mm_set1_pi8","","Broadcasts 8-bit integer a to all all elements of dst.",null,[[["i8"]],["__m64"]]],[5,"_mm_setr_pi16","","Sets packed 16-bit integers in dst with the supplied…",null,[[["i16"]],["__m64"]]],[5,"_mm_setr_pi32","","Sets packed 32-bit integers in dst with the supplied…",null,[[["i32"]],["__m64"]]],[5,"_mm_setr_pi8","","Sets packed 8-bit integers in dst with the supplied values…",null,[[["i8"]],["__m64"]]],[5,"_mm_empty","","Empty the MMX state, which marks the x87 FPU registers as…",null,[[]]],[5,"_m_empty","","Empty the MMX state, which marks the x87 FPU registers as…",null,[[]]],[5,"_mm_cvtsi32_si64","","Copies 32-bit integer `a` to the lower elements of the…",null,[[["i32"]],["__m64"]]],[5,"_mm_cvtsi64_si32","","Return the lower 32-bit integer in `a`.",null,[[["__m64"]],["i32"]]],[5,"_mm_clmulepi64_si128","","Performs a carry-less multiplication of two 64-bit…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_aesdec_si128","","Performs one round of an AES decryption flow on data…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_aesdeclast_si128","","Performs the last round of an AES decryption flow on data…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_aesenc_si128","","Performs one round of an AES encryption flow on data…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_aesenclast_si128","","Performs the last round of an AES encryption flow on data…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_aesimc_si128","","Performs the `InvMixColumns` transformation on `a`.",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_aeskeygenassist_si128","","Assist in expanding the AES cipher key.",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_rdrand16_step","","Read a hardware generated 16-bit random value and store…",null,[[["u16"]],["i32"]]],[5,"_rdrand32_step","","Read a hardware generated 32-bit random value and store…",null,[[["u32"]],["i32"]]],[5,"_rdseed16_step","","Read a 16-bit NIST SP800-90B and SP800-90C compliant…",null,[[["u16"]],["i32"]]],[5,"_rdseed32_step","","Read a 32-bit NIST SP800-90B and SP800-90C compliant…",null,[[["u32"]],["i32"]]],[5,"_mm_sha1msg1_epu32","","Performs an intermediate calculation for the next four…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sha1msg2_epu32","","Performs the final calculation for the next four SHA1…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sha1nexte_epu32","","Calculate SHA1 state variable E after four rounds of…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sha1rnds4_epu32","","Performs four rounds of SHA1 operation using an initial…",null,[[["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_sha256msg1_epu32","","Performs an intermediate calculation for the next four…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sha256msg2_epu32","","Performs the final calculation for the next four SHA256…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_sha256rnds2_epu32","","Performs 2 rounds of SHA256 operation using an initial…",null,[[["__m128i"]],["__m128i"]]],[5,"_addcarry_u32","","Adds unsigned 32-bit integers `a` and `b` with unsigned…",null,[[["u32"],["u32"],["u8"]],["u8"]]],[5,"_addcarryx_u32","","Adds unsigned 32-bit integers `a` and `b` with unsigned…",null,[[["u32"],["u32"],["u8"]],["u8"]]],[5,"_subborrow_u32","","Adds unsigned 32-bit integers `a` and `b` with unsigned…",null,[[["u32"],["u32"],["u8"]],["u8"]]],[5,"ud2","","Generates the trap instruction `UD2`",null,[[]]],[5,"_mm512_abs_epi32","","Computes the absolute values of packed 32-bit integers in…",null,[[["__m512i"]],["__m512i"]]],[5,"_mm512_mask_abs_epi32","","Computes the absolute value of packed 32-bit integers in…",null,[[["__m512i"],["__mmask16"]],["__m512i"]]],[5,"_mm512_maskz_abs_epi32","","Computes the absolute value of packed 32-bit integers in…",null,[[["__m512i"],["__mmask16"]],["__m512i"]]],[5,"_mm512_setzero_si512","","Returns vector of type `__m512i` with all elements set to…",null,[[],["__m512i"]]],[5,"_mm512_setr_epi32","","Sets packed 32-bit integers in `dst` with the supplied…",null,[[["i32"]],["__m512i"]]],[5,"_mm512_set1_epi64","","Broadcast 64-bit integer `a` to all elements of `dst`.",null,[[["i64"]],["__m512i"]]],[5,"_mm512_madd52hi_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m512i"]],["__m512i"]]],[5,"_mm512_madd52lo_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m512i"]],["__m512i"]]],[5,"_mm256_madd52hi_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm256_madd52lo_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m256i"]],["__m256i"]]],[5,"_mm_madd52hi_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_mm_madd52lo_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m128i"]],["__m128i"]]],[5,"_bittest","","Returns the bit in position `b` of the memory addressed by…",null,[[["i32"]],["u8"]]],[5,"_bittestandset","","Returns the bit in position `b` of the memory addressed by…",null,[[["i32"]],["u8"]]],[5,"_bittestandreset","","Returns the bit in position `b` of the memory addressed by…",null,[[["i32"]],["u8"]]],[5,"_bittestandcomplement","","Returns the bit in position `b` of the memory addressed by…",null,[[["i32"]],["u8"]]],[5,"_xbegin","","Specifies the start of a restricted transactional memory…",null,[[],["u32"]]],[5,"_xend","","Specifies the end of a restricted transactional memory…",null,[[]]],[5,"_xabort","","Forces a restricted transactional memory (RTM) region to…",null,[[["u32"]]]],[5,"_xtest","","Queries whether the processor is executing in a…",null,[[],["u8"]]],[5,"_xabort_code","","Retrieves the parameter passed to [`_xabort`] when…",null,[[["u32"]],["u32"]]],[5,"_mm_cvtph_ps","","Converts the 4 x 16-bit half-precision float values in the…",null,[[["__m128i"]],["__m128"]]],[5,"_mm256_cvtph_ps","","Converts the 8 x 16-bit half-precision float values in the…",null,[[["__m128i"]],["__m256"]]],[5,"_mm_cvtps_ph","","Converts the 4 x 32-bit float values in the 128-bit vector…",null,[[["i32"],["__m128"]],["__m128i"]]],[5,"_mm256_cvtps_ph","","Converts the 8 x 32-bit float values in the 256-bit vector…",null,[[["__m256"],["i32"]],["__m128i"]]],[5,"_fxsave64","","Saves the `x87` FPU, `MMX` technology, `XMM`, and `MXCSR`…",null,[[]]],[5,"_fxrstor64","","Restores the `XMM`, `MMX`, `MXCSR`, and `x87` FPU…",null,[[]]],[5,"_mm_cvtss_si64","","Converts the lowest 32 bit float in the input vector to a…",null,[[["__m128"]],["i64"]]],[5,"_mm_cvttss_si64","","Converts the lowest 32 bit float in the input vector to a…",null,[[["__m128"]],["i64"]]],[5,"_mm_cvtsi64_ss","","Converts a 64 bit integer to a 32 bit float. The result…",null,[[["i64"],["__m128"]],["__m128"]]],[5,"_mm_cvtsd_si64","","Converts the lower double-precision (64-bit)…",null,[[["__m128d"]],["i64"]]],[5,"_mm_cvtsd_si64x","","Alias for `_mm_cvtsd_si64`",null,[[["__m128d"]],["i64"]]],[5,"_mm_cvttsd_si64","","Converts the lower double-precision (64-bit)…",null,[[["__m128d"]],["i64"]]],[5,"_mm_cvttsd_si64x","","Alias for `_mm_cvttsd_si64`",null,[[["__m128d"]],["i64"]]],[5,"_mm_stream_si64","","Stores a 64-bit integer value in the specified memory…",null,[[["i64"]]]],[5,"_mm_cvtsi64_si128","","Returns a vector whose lowest element is `a` and all…",null,[[["i64"]],["__m128i"]]],[5,"_mm_cvtsi64x_si128","","Returns a vector whose lowest element is `a` and all…",null,[[["i64"]],["__m128i"]]],[5,"_mm_cvtsi128_si64","","Returns the lowest element of `a`.",null,[[["__m128i"]],["i64"]]],[5,"_mm_cvtsi128_si64x","","Returns the lowest element of `a`.",null,[[["__m128i"]],["i64"]]],[5,"_mm_cvtsi64_sd","","Returns `a` with its lower element replaced by `b` after…",null,[[["i64"],["__m128d"]],["__m128d"]]],[5,"_mm_cvtsi64x_sd","","Returns `a` with its lower element replaced by `b` after…",null,[[["i64"],["__m128d"]],["__m128d"]]],[5,"_mm_extract_epi64","","Extracts an 64-bit integer from `a` selected with `imm8`",null,[[["__m128i"],["i32"]],["i64"]]],[5,"_mm_insert_epi64","","Returns a copy of `a` with the 64-bit integer from `i`…",null,[[["i64"],["__m128i"],["i32"]],["__m128i"]]],[5,"_mm_crc32_u64","","Starting with the initial value in `crc`, return the…",null,[[["u64"]],["u64"]]],[5,"_xsave64","","Performs a full or partial save of the enabled processor…",null,[[["u64"]]]],[5,"_xrstor64","","Performs a full or partial restore of the enabled…",null,[[["u64"]]]],[5,"_xsaveopt64","","Performs a full or partial save of the enabled processor…",null,[[["u64"]]]],[5,"_xsavec64","","Performs a full or partial save of the enabled processor…",null,[[["u64"]]]],[5,"_xsaves64","","Performs a full or partial save of the enabled processor…",null,[[["u64"]]]],[5,"_xrstors64","","Performs a full or partial restore of the enabled…",null,[[["u64"]]]],[5,"_lzcnt_u64","","Counts the leading most significant zero bits.",null,[[["u64"]],["u64"]]],[5,"_popcnt64","","Counts the bits that are set.",null,[[["i64"]],["i32"]]],[5,"_mm256_insert_epi64","","Copies `a` to result, and insert the 64-bit integer `i`…",null,[[["i64"],["__m256i"],["i32"]],["__m256i"]]],[5,"_andn_u64","","Bitwise logical `AND` of inverted `a` with `b`.",null,[[["u64"]],["u64"]]],[5,"_tzcnt_u64","","Counts the number of trailing least significant zero bits.",null,[[["u64"]],["u64"]]],[5,"_mm_tzcnt_64","","Counts the number of trailing least significant zero bits.",null,[[["u64"]],["i64"]]],[5,"_mm256_extract_epi64","","Extracts a 64-bit integer from `a`, selected with `imm8`.",null,[[["__m256i"],["i32"]],["i64"]]],[5,"_bswap64","","Returns an integer with the reversed byte order of x",null,[[["i64"]],["i64"]]],[5,"_rdrand64_step","","Read a hardware generated 64-bit random value and store…",null,[[["u64"]],["i32"]]],[5,"_rdseed64_step","","Read a 64-bit NIST SP800-90B and SP800-90C compliant…",null,[[["u64"]],["i32"]]],[5,"cmpxchg16b","","Compares and exchange 16 bytes (128 bits) of data…",null,[[["ordering"],["u128"]],["u128"]]],[5,"_addcarry_u64","","Adds unsigned 64-bit integers `a` and `b` with unsigned…",null,[[["u64"],["u64"],["u8"]],["u8"]]],[5,"_addcarryx_u64","","Adds unsigned 64-bit integers `a` and `b` with unsigned…",null,[[["u64"],["u64"],["u8"]],["u8"]]],[5,"_subborrow_u64","","Adds unsigned 64-bit integers `a` and `b` with unsigned…",null,[[["u64"],["u64"],["u8"]],["u8"]]],[5,"_bittest64","","Returns the bit in position `b` of the memory addressed by…",null,[[["i64"]],["u8"]]],[5,"_bittestandset64","","Returns the bit in position `b` of the memory addressed by…",null,[[["i64"]],["u8"]]],[5,"_bittestandreset64","","Returns the bit in position `b` of the memory addressed by…",null,[[["i64"]],["u8"]]],[5,"_bittestandcomplement64","","Returns the bit in position `b` of the memory addressed by…",null,[[["i64"]],["u8"]]],[6,"__mmask16","","The `__mmask16` type used in AVX-512 intrinsics, a 16-bit…",null,null],[17,"_XCR_XFEATURE_ENABLED_MASK","","`XFEATURE_ENABLED_MASK` for `XCR`",null,null],[17,"_MM_EXCEPT_INVALID","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_DENORM","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_DIV_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_OVERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_UNDERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_INEXACT","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_MASK","","See `_MM_GET_EXCEPTION_STATE`",null,null],[17,"_MM_MASK_INVALID","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_DENORM","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_DIV_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_OVERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_UNDERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_INEXACT","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_MASK","","See `_MM_GET_EXCEPTION_MASK`",null,null],[17,"_MM_ROUND_NEAREST","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_DOWN","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_UP","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_TOWARD_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_MASK","","See `_MM_GET_ROUNDING_MODE`",null,null],[17,"_MM_FLUSH_ZERO_MASK","","See `_MM_GET_FLUSH_ZERO_MODE`",null,null],[17,"_MM_FLUSH_ZERO_ON","","See `_mm_setcsr`",null,null],[17,"_MM_FLUSH_ZERO_OFF","","See `_mm_setcsr`",null,null],[17,"_MM_HINT_T0","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_T1","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_T2","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_NTA","","See `_mm_prefetch`.",null,null],[17,"_MM_FROUND_TO_NEAREST_INT","","round to nearest",null,null],[17,"_MM_FROUND_TO_NEG_INF","","round down",null,null],[17,"_MM_FROUND_TO_POS_INF","","round up",null,null],[17,"_MM_FROUND_TO_ZERO","","truncate",null,null],[17,"_MM_FROUND_CUR_DIRECTION","","use MXCSR.RC; see `vendor::_MM_SET_ROUNDING_MODE`",null,null],[17,"_MM_FROUND_RAISE_EXC","","do not suppress exceptions",null,null],[17,"_MM_FROUND_NO_EXC","","suppress exceptions",null,null],[17,"_MM_FROUND_NINT","","round to nearest and do not suppress exceptions",null,null],[17,"_MM_FROUND_FLOOR","","round down and do not suppress exceptions",null,null],[17,"_MM_FROUND_CEIL","","round up and do not suppress exceptions",null,null],[17,"_MM_FROUND_TRUNC","","truncate and do not suppress exceptions",null,null],[17,"_MM_FROUND_RINT","","use MXCSR.RC and do not suppress exceptions; see…",null,null],[17,"_MM_FROUND_NEARBYINT","","use MXCSR.RC and suppress exceptions; see…",null,null],[17,"_SIDD_UBYTE_OPS","","String contains unsigned 8-bit characters (Default)",null,null],[17,"_SIDD_UWORD_OPS","","String contains unsigned 16-bit characters",null,null],[17,"_SIDD_SBYTE_OPS","","String contains signed 8-bit characters",null,null],[17,"_SIDD_SWORD_OPS","","String contains unsigned 16-bit characters",null,null],[17,"_SIDD_CMP_EQUAL_ANY","","For each character in `a`, find if it is in `b` (Default)",null,null],[17,"_SIDD_CMP_RANGES","","For each character in `a`, determine if `b[0] <= c <= b[1]…",null,null],[17,"_SIDD_CMP_EQUAL_EACH","","The strings defined by `a` and `b` are equal",null,null],[17,"_SIDD_CMP_EQUAL_ORDERED","","Search for the defined substring in the target",null,null],[17,"_SIDD_POSITIVE_POLARITY","","Do not negate results (Default)",null,null],[17,"_SIDD_NEGATIVE_POLARITY","","Negates results",null,null],[17,"_SIDD_MASKED_POSITIVE_POLARITY","","Do not negate results before the end of the string",null,null],[17,"_SIDD_MASKED_NEGATIVE_POLARITY","","Negates results only before the end of the string",null,null],[17,"_SIDD_LEAST_SIGNIFICANT","","Index only: return the least significant bit (Default)",null,null],[17,"_SIDD_MOST_SIGNIFICANT","","Index only: return the most significant bit",null,null],[17,"_SIDD_BIT_MASK","","Mask only: return the bit mask",null,null],[17,"_SIDD_UNIT_MASK","","Mask only: return the byte mask",null,null],[17,"_CMP_EQ_OQ","","Equal (ordered, non-signaling)",null,null],[17,"_CMP_LT_OS","","Less-than (ordered, signaling)",null,null],[17,"_CMP_LE_OS","","Less-than-or-equal (ordered, signaling)",null,null],[17,"_CMP_UNORD_Q","","Unordered (non-signaling)",null,null],[17,"_CMP_NEQ_UQ","","Not-equal (unordered, non-signaling)",null,null],[17,"_CMP_NLT_US","","Not-less-than (unordered, signaling)",null,null],[17,"_CMP_NLE_US","","Not-less-than-or-equal (unordered, signaling)",null,null],[17,"_CMP_ORD_Q","","Ordered (non-signaling)",null,null],[17,"_CMP_EQ_UQ","","Equal (unordered, non-signaling)",null,null],[17,"_CMP_NGE_US","","Not-greater-than-or-equal (unordered, signaling)",null,null],[17,"_CMP_NGT_US","","Not-greater-than (unordered, signaling)",null,null],[17,"_CMP_FALSE_OQ","","False (ordered, non-signaling)",null,null],[17,"_CMP_NEQ_OQ","","Not-equal (ordered, non-signaling)",null,null],[17,"_CMP_GE_OS","","Greater-than-or-equal (ordered, signaling)",null,null],[17,"_CMP_GT_OS","","Greater-than (ordered, signaling)",null,null],[17,"_CMP_TRUE_UQ","","True (unordered, non-signaling)",null,null],[17,"_CMP_EQ_OS","","Equal (ordered, signaling)",null,null],[17,"_CMP_LT_OQ","","Less-than (ordered, non-signaling)",null,null],[17,"_CMP_LE_OQ","","Less-than-or-equal (ordered, non-signaling)",null,null],[17,"_CMP_UNORD_S","","Unordered (signaling)",null,null],[17,"_CMP_NEQ_US","","Not-equal (unordered, signaling)",null,null],[17,"_CMP_NLT_UQ","","Not-less-than (unordered, non-signaling)",null,null],[17,"_CMP_NLE_UQ","","Not-less-than-or-equal (unordered, non-signaling)",null,null],[17,"_CMP_ORD_S","","Ordered (signaling)",null,null],[17,"_CMP_EQ_US","","Equal (unordered, signaling)",null,null],[17,"_CMP_NGE_UQ","","Not-greater-than-or-equal (unordered, non-signaling)",null,null],[17,"_CMP_NGT_UQ","","Not-greater-than (unordered, non-signaling)",null,null],[17,"_CMP_FALSE_OS","","False (ordered, signaling)",null,null],[17,"_CMP_NEQ_OS","","Not-equal (ordered, signaling)",null,null],[17,"_CMP_GE_OQ","","Greater-than-or-equal (ordered, non-signaling)",null,null],[17,"_CMP_GT_OQ","","Greater-than (ordered, non-signaling)",null,null],[17,"_CMP_TRUE_US","","True (unordered, signaling)",null,null],[17,"_XBEGIN_STARTED","","Transaction successfully started.",null,null],[17,"_XABORT_EXPLICIT","","Transaction explicitly aborted with xabort. The parameter…",null,null],[17,"_XABORT_RETRY","","Transaction retry is possible.",null,null],[17,"_XABORT_CONFLICT","","Transaction abort due to a memory conflict with another…",null,null],[17,"_XABORT_CAPACITY","","Transaction abort due to the transaction using too much…",null,null],[17,"_XABORT_DEBUG","","Transaction abort due to a debug trap.",null,null],[17,"_XABORT_NESTED","","Transaction abort in a inner nested transaction.",null,null],[0,"arm","core::arch","Platform-specific intrinsics for the `arm` platform.",null,null],[3,"int8x8_t","core::arch::arm","ARM-specific 64-bit wide vector of eight packed `i8`.",null,null],[3,"uint8x8_t","","ARM-specific 64-bit wide vector of eight packed `u8`.",null,null],[3,"poly8x8_t","","ARM-specific 64-bit wide polynomial vector of eight packed…",null,null],[3,"int16x4_t","","ARM-specific 64-bit wide vector of four packed `i16`.",null,null],[3,"uint16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",null,null],[3,"poly16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",null,null],[3,"int32x2_t","","ARM-specific 64-bit wide vector of two packed `i32`.",null,null],[3,"uint32x2_t","","ARM-specific 64-bit wide vector of two packed `u32`.",null,null],[3,"float32x2_t","","ARM-specific 64-bit wide vector of two packed `f32`.",null,null],[3,"int64x1_t","","ARM-specific 64-bit wide vector of one packed `i64`.",null,null],[3,"uint64x1_t","","ARM-specific 64-bit wide vector of one packed `u64`.",null,null],[3,"int8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `i8`.",null,null],[3,"uint8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",null,null],[3,"poly8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",null,null],[3,"int16x8_t","","ARM-specific 128-bit wide vector of eight packed `i16`.",null,null],[3,"uint16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",null,null],[3,"poly16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",null,null],[3,"int32x4_t","","ARM-specific 128-bit wide vector of four packed `i32`.",null,null],[3,"uint32x4_t","","ARM-specific 128-bit wide vector of four packed `u32`.",null,null],[3,"float32x4_t","","ARM-specific 128-bit wide vector of four packed `f32`.",null,null],[3,"int64x2_t","","ARM-specific 128-bit wide vector of two packed `i64`.",null,null],[3,"uint64x2_t","","ARM-specific 128-bit wide vector of two packed `u64`.",null,null],[3,"int8x8x2_t","","ARM-specific type containing two `int8x8_t` vectors.",null,null],[12,"0","","",165,null],[12,"1","","",165,null],[3,"int8x8x3_t","","ARM-specific type containing three `int8x8_t` vectors.",null,null],[12,"0","","",166,null],[12,"1","","",166,null],[12,"2","","",166,null],[3,"int8x8x4_t","","ARM-specific type containing four `int8x8_t` vectors.",null,null],[12,"0","","",167,null],[12,"1","","",167,null],[12,"2","","",167,null],[12,"3","","",167,null],[3,"uint8x8x2_t","","ARM-specific type containing two `uint8x8_t` vectors.",null,null],[12,"0","","",168,null],[12,"1","","",168,null],[3,"uint8x8x3_t","","ARM-specific type containing three `uint8x8_t` vectors.",null,null],[12,"0","","",169,null],[12,"1","","",169,null],[12,"2","","",169,null],[3,"uint8x8x4_t","","ARM-specific type containing four `uint8x8_t` vectors.",null,null],[12,"0","","",170,null],[12,"1","","",170,null],[12,"2","","",170,null],[12,"3","","",170,null],[3,"poly8x8x2_t","","ARM-specific type containing two `poly8x8_t` vectors.",null,null],[12,"0","","",171,null],[12,"1","","",171,null],[3,"poly8x8x3_t","","ARM-specific type containing three `poly8x8_t` vectors.",null,null],[12,"0","","",172,null],[12,"1","","",172,null],[12,"2","","",172,null],[3,"poly8x8x4_t","","ARM-specific type containing four `poly8x8_t` vectors.",null,null],[12,"0","","",173,null],[12,"1","","",173,null],[12,"2","","",173,null],[12,"3","","",173,null],[3,"SY","","Full system is the required shareability domain, reads and…",null,null],[3,"APSR","","Application Program Status Register",null,null],[5,"__breakpoint","","Inserts a breakpoint instruction.",null,[[["i32"]]]],[5,"_rev_u16","","Reverse the order of the bytes.",null,[[["u16"]],["u16"]]],[5,"_rev_u32","","Reverse the order of the bytes.",null,[[["u32"]],["u32"]]],[5,"vand_s8","","Vector bitwise and",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vandq_s8","","Vector bitwise and",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vand_s16","","Vector bitwise and",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vandq_s16","","Vector bitwise and",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vand_s32","","Vector bitwise and",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vandq_s32","","Vector bitwise and",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vand_u8","","Vector bitwise and",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vandq_u8","","Vector bitwise and",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vand_u16","","Vector bitwise and",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vandq_u16","","Vector bitwise and",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vand_u32","","Vector bitwise and",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vandq_u32","","Vector bitwise and",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vand_s64","","Vector bitwise and",null,[[["int64x1_t"]],["int64x1_t"]]],[5,"vandq_s64","","Vector bitwise and",null,[[["int64x2_t"]],["int64x2_t"]]],[5,"vand_u64","","Vector bitwise and",null,[[["uint64x1_t"]],["uint64x1_t"]]],[5,"vandq_u64","","Vector bitwise and",null,[[["uint64x2_t"]],["uint64x2_t"]]],[5,"vorr_s8","","Vector bitwise or (immediate, inclusive)",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vorrq_s8","","Vector bitwise or (immediate, inclusive)",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vorr_s16","","Vector bitwise or (immediate, inclusive)",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vorrq_s16","","Vector bitwise or (immediate, inclusive)",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vorr_s32","","Vector bitwise or (immediate, inclusive)",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vorrq_s32","","Vector bitwise or (immediate, inclusive)",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vorr_u8","","Vector bitwise or (immediate, inclusive)",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vorrq_u8","","Vector bitwise or (immediate, inclusive)",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vorr_u16","","Vector bitwise or (immediate, inclusive)",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vorrq_u16","","Vector bitwise or (immediate, inclusive)",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vorr_u32","","Vector bitwise or (immediate, inclusive)",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vorrq_u32","","Vector bitwise or (immediate, inclusive)",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vorr_s64","","Vector bitwise or (immediate, inclusive)",null,[[["int64x1_t"]],["int64x1_t"]]],[5,"vorrq_s64","","Vector bitwise or (immediate, inclusive)",null,[[["int64x2_t"]],["int64x2_t"]]],[5,"vorr_u64","","Vector bitwise or (immediate, inclusive)",null,[[["uint64x1_t"]],["uint64x1_t"]]],[5,"vorrq_u64","","Vector bitwise or (immediate, inclusive)",null,[[["uint64x2_t"]],["uint64x2_t"]]],[5,"veor_s8","","Vector bitwise exclusive or (vector)",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"veorq_s8","","Vector bitwise exclusive or (vector)",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"veor_s16","","Vector bitwise exclusive or (vector)",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"veorq_s16","","Vector bitwise exclusive or (vector)",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"veor_s32","","Vector bitwise exclusive or (vector)",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"veorq_s32","","Vector bitwise exclusive or (vector)",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"veor_u8","","Vector bitwise exclusive or (vector)",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"veorq_u8","","Vector bitwise exclusive or (vector)",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"veor_u16","","Vector bitwise exclusive or (vector)",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"veorq_u16","","Vector bitwise exclusive or (vector)",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"veor_u32","","Vector bitwise exclusive or (vector)",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"veorq_u32","","Vector bitwise exclusive or (vector)",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"veor_s64","","Vector bitwise exclusive or (vector)",null,[[["int64x1_t"]],["int64x1_t"]]],[5,"veorq_s64","","Vector bitwise exclusive or (vector)",null,[[["int64x2_t"]],["int64x2_t"]]],[5,"veor_u64","","Vector bitwise exclusive or (vector)",null,[[["uint64x1_t"]],["uint64x1_t"]]],[5,"veorq_u64","","Vector bitwise exclusive or (vector)",null,[[["uint64x2_t"]],["uint64x2_t"]]],[5,"vceq_u8","","Compare bitwise Equal (vector)",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vceqq_u8","","Compare bitwise Equal (vector)",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vceq_u16","","Compare bitwise Equal (vector)",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vceqq_u16","","Compare bitwise Equal (vector)",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vceq_u32","","Compare bitwise Equal (vector)",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vceqq_u32","","Compare bitwise Equal (vector)",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vceq_s8","","Compare bitwise Equal (vector)",null,[[["int8x8_t"]],["uint8x8_t"]]],[5,"vceqq_s8","","Compare bitwise Equal (vector)",null,[[["int8x16_t"]],["uint8x16_t"]]],[5,"vceq_s16","","Compare bitwise Equal (vector)",null,[[["int16x4_t"]],["uint16x4_t"]]],[5,"vceqq_s16","","Compare bitwise Equal (vector)",null,[[["int16x8_t"]],["uint16x8_t"]]],[5,"vceq_s32","","Compare bitwise Equal (vector)",null,[[["int32x2_t"]],["uint32x2_t"]]],[5,"vceqq_s32","","Compare bitwise Equal (vector)",null,[[["int32x4_t"]],["uint32x4_t"]]],[5,"vceq_f32","","Floating-point compare equal",null,[[["float32x2_t"]],["uint32x2_t"]]],[5,"vceqq_f32","","Floating-point compare equal",null,[[["float32x4_t"]],["uint32x4_t"]]],[5,"vcgt_s8","","Compare signed greater than",null,[[["int8x8_t"]],["uint8x8_t"]]],[5,"vcgtq_s8","","Compare signed greater than",null,[[["int8x16_t"]],["uint8x16_t"]]],[5,"vcgt_s16","","Compare signed greater than",null,[[["int16x4_t"]],["uint16x4_t"]]],[5,"vcgtq_s16","","Compare signed greater than",null,[[["int16x8_t"]],["uint16x8_t"]]],[5,"vcgt_s32","","Compare signed greater than",null,[[["int32x2_t"]],["uint32x2_t"]]],[5,"vcgtq_s32","","Compare signed greater than",null,[[["int32x4_t"]],["uint32x4_t"]]],[5,"vcgt_u8","","Compare unsigned highe",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vcgtq_u8","","Compare unsigned highe",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vcgt_u16","","Compare unsigned highe",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vcgtq_u16","","Compare unsigned highe",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vcgt_u32","","Compare unsigned highe",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vcgtq_u32","","Compare unsigned highe",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vcgt_f32","","Floating-point compare greater than",null,[[["float32x2_t"]],["uint32x2_t"]]],[5,"vcgtq_f32","","Floating-point compare greater than",null,[[["float32x4_t"]],["uint32x4_t"]]],[5,"vclt_s8","","Compare signed less than",null,[[["int8x8_t"]],["uint8x8_t"]]],[5,"vcltq_s8","","Compare signed less than",null,[[["int8x16_t"]],["uint8x16_t"]]],[5,"vclt_s16","","Compare signed less than",null,[[["int16x4_t"]],["uint16x4_t"]]],[5,"vcltq_s16","","Compare signed less than",null,[[["int16x8_t"]],["uint16x8_t"]]],[5,"vclt_s32","","Compare signed less than",null,[[["int32x2_t"]],["uint32x2_t"]]],[5,"vcltq_s32","","Compare signed less than",null,[[["int32x4_t"]],["uint32x4_t"]]],[5,"vclt_u8","","Compare unsigned less than",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vcltq_u8","","Compare unsigned less than",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vclt_u16","","Compare unsigned less than",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vcltq_u16","","Compare unsigned less than",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vclt_u32","","Compare unsigned less than",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vcltq_u32","","Compare unsigned less than",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vclt_f32","","Floating-point compare less than",null,[[["float32x2_t"]],["uint32x2_t"]]],[5,"vcltq_f32","","Floating-point compare less than",null,[[["float32x4_t"]],["uint32x4_t"]]],[5,"vcle_s8","","Compare signed less than or equal",null,[[["int8x8_t"]],["uint8x8_t"]]],[5,"vcleq_s8","","Compare signed less than or equal",null,[[["int8x16_t"]],["uint8x16_t"]]],[5,"vcle_s16","","Compare signed less than or equal",null,[[["int16x4_t"]],["uint16x4_t"]]],[5,"vcleq_s16","","Compare signed less than or equal",null,[[["int16x8_t"]],["uint16x8_t"]]],[5,"vcle_s32","","Compare signed less than or equal",null,[[["int32x2_t"]],["uint32x2_t"]]],[5,"vcleq_s32","","Compare signed less than or equal",null,[[["int32x4_t"]],["uint32x4_t"]]],[5,"vcle_u8","","Compare unsigned less than or equal",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vcleq_u8","","Compare unsigned less than or equal",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vcle_u16","","Compare unsigned less than or equal",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vcleq_u16","","Compare unsigned less than or equal",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vcle_u32","","Compare unsigned less than or equal",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vcleq_u32","","Compare unsigned less than or equal",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vcle_f32","","Floating-point compare less than or equal",null,[[["float32x2_t"]],["uint32x2_t"]]],[5,"vcleq_f32","","Floating-point compare less than or equal",null,[[["float32x4_t"]],["uint32x4_t"]]],[5,"vcge_s8","","Compare signed greater than or equal",null,[[["int8x8_t"]],["uint8x8_t"]]],[5,"vcgeq_s8","","Compare signed greater than or equal",null,[[["int8x16_t"]],["uint8x16_t"]]],[5,"vcge_s16","","Compare signed greater than or equal",null,[[["int16x4_t"]],["uint16x4_t"]]],[5,"vcgeq_s16","","Compare signed greater than or equal",null,[[["int16x8_t"]],["uint16x8_t"]]],[5,"vcge_s32","","Compare signed greater than or equal",null,[[["int32x2_t"]],["uint32x2_t"]]],[5,"vcgeq_s32","","Compare signed greater than or equal",null,[[["int32x4_t"]],["uint32x4_t"]]],[5,"vcge_u8","","Compare unsigned greater than or equal",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vcgeq_u8","","Compare unsigned greater than or equal",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vcge_u16","","Compare unsigned greater than or equal",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vcgeq_u16","","Compare unsigned greater than or equal",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vcge_u32","","Compare unsigned greater than or equal",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vcgeq_u32","","Compare unsigned greater than or equal",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vcge_f32","","Floating-point compare greater than or equal",null,[[["float32x2_t"]],["uint32x2_t"]]],[5,"vcgeq_f32","","Floating-point compare greater than or equal",null,[[["float32x4_t"]],["uint32x4_t"]]],[5,"vqsub_u8","","Saturating subtract",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vqsubq_u8","","Saturating subtract",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vqsub_u16","","Saturating subtract",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vqsubq_u16","","Saturating subtract",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vqsub_u32","","Saturating subtract",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vqsubq_u32","","Saturating subtract",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vqsub_s8","","Saturating subtract",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vqsubq_s8","","Saturating subtract",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vqsub_s16","","Saturating subtract",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vqsubq_s16","","Saturating subtract",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vqsub_s32","","Saturating subtract",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vqsubq_s32","","Saturating subtract",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vhadd_u8","","Halving add",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vhaddq_u8","","Halving add",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vhadd_u16","","Halving add",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vhaddq_u16","","Halving add",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vhadd_u32","","Halving add",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vhaddq_u32","","Halving add",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vhadd_s8","","Halving add",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vhaddq_s8","","Halving add",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vhadd_s16","","Halving add",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vhaddq_s16","","Halving add",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vhadd_s32","","Halving add",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vhaddq_s32","","Halving add",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vrhadd_u8","","Rounding halving add",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vrhaddq_u8","","Rounding halving add",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vrhadd_u16","","Rounding halving add",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vrhaddq_u16","","Rounding halving add",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vrhadd_u32","","Rounding halving add",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vrhaddq_u32","","Rounding halving add",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vrhadd_s8","","Rounding halving add",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vrhaddq_s8","","Rounding halving add",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vrhadd_s16","","Rounding halving add",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vrhaddq_s16","","Rounding halving add",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vrhadd_s32","","Rounding halving add",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vrhaddq_s32","","Rounding halving add",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vqadd_u8","","Saturating add",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vqaddq_u8","","Saturating add",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vqadd_u16","","Saturating add",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vqaddq_u16","","Saturating add",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vqadd_u32","","Saturating add",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vqaddq_u32","","Saturating add",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vqadd_s8","","Saturating add",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vqaddq_s8","","Saturating add",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vqadd_s16","","Saturating add",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vqaddq_s16","","Saturating add",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vqadd_s32","","Saturating add",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vqaddq_s32","","Saturating add",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vmul_s8","","Multiply",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vmulq_s8","","Multiply",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vmul_s16","","Multiply",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vmulq_s16","","Multiply",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vmul_s32","","Multiply",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vmulq_s32","","Multiply",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vmul_u8","","Multiply",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vmulq_u8","","Multiply",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vmul_u16","","Multiply",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vmulq_u16","","Multiply",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vmul_u32","","Multiply",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vmulq_u32","","Multiply",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vmul_f32","","Multiply",null,[[["float32x2_t"]],["float32x2_t"]]],[5,"vmulq_f32","","Multiply",null,[[["float32x4_t"]],["float32x4_t"]]],[5,"vsub_s8","","Subtract",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vsubq_s8","","Subtract",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vsub_s16","","Subtract",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vsubq_s16","","Subtract",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vsub_s32","","Subtract",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vsubq_s32","","Subtract",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vsub_u8","","Subtract",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vsubq_u8","","Subtract",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vsub_u16","","Subtract",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vsubq_u16","","Subtract",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vsub_u32","","Subtract",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vsubq_u32","","Subtract",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vsub_s64","","Subtract",null,[[["int64x1_t"]],["int64x1_t"]]],[5,"vsubq_s64","","Subtract",null,[[["int64x2_t"]],["int64x2_t"]]],[5,"vsub_u64","","Subtract",null,[[["uint64x1_t"]],["uint64x1_t"]]],[5,"vsubq_u64","","Subtract",null,[[["uint64x2_t"]],["uint64x2_t"]]],[5,"vsub_f32","","Subtract",null,[[["float32x2_t"]],["float32x2_t"]]],[5,"vsubq_f32","","Subtract",null,[[["float32x4_t"]],["float32x4_t"]]],[5,"vhsub_u8","","Signed halving subtract",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vhsubq_u8","","Signed halving subtract",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vhsub_u16","","Signed halving subtract",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vhsubq_u16","","Signed halving subtract",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vhsub_u32","","Signed halving subtract",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vhsubq_u32","","Signed halving subtract",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vhsub_s8","","Signed halving subtract",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vhsubq_s8","","Signed halving subtract",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vhsub_s16","","Signed halving subtract",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vhsubq_s16","","Signed halving subtract",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vhsub_s32","","Signed halving subtract",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vhsubq_s32","","Signed halving subtract",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vqmovn_u64","","Unsigned saturating extract narrow.",null,[[["uint64x2_t"]],["uint32x2_t"]]],[5,"vadd_s8","","Vector add.",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vaddq_s8","","Vector add.",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vadd_s16","","Vector add.",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vaddq_s16","","Vector add.",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vadd_s32","","Vector add.",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vaddq_s32","","Vector add.",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vaddq_s64","","Vector add.",null,[[["int64x2_t"]],["int64x2_t"]]],[5,"vadd_u8","","Vector add.",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vaddq_u8","","Vector add.",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vadd_u16","","Vector add.",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vaddq_u16","","Vector add.",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vadd_u32","","Vector add.",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vaddq_u32","","Vector add.",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vaddq_u64","","Vector add.",null,[[["uint64x2_t"]],["uint64x2_t"]]],[5,"vadd_f32","","Vector add.",null,[[["float32x2_t"]],["float32x2_t"]]],[5,"vaddq_f32","","Vector add.",null,[[["float32x4_t"]],["float32x4_t"]]],[5,"vaddl_s8","","Vector long add.",null,[[["int8x8_t"]],["int16x8_t"]]],[5,"vaddl_s16","","Vector long add.",null,[[["int16x4_t"]],["int32x4_t"]]],[5,"vaddl_s32","","Vector long add.",null,[[["int32x2_t"]],["int64x2_t"]]],[5,"vaddl_u8","","Vector long add.",null,[[["uint8x8_t"]],["uint16x8_t"]]],[5,"vaddl_u16","","Vector long add.",null,[[["uint16x4_t"]],["uint32x4_t"]]],[5,"vaddl_u32","","Vector long add.",null,[[["uint32x2_t"]],["uint64x2_t"]]],[5,"vmovn_s16","","Vector narrow integer.",null,[[["int16x8_t"]],["int8x8_t"]]],[5,"vmovn_s32","","Vector narrow integer.",null,[[["int32x4_t"]],["int16x4_t"]]],[5,"vmovn_s64","","Vector narrow integer.",null,[[["int64x2_t"]],["int32x2_t"]]],[5,"vmovn_u16","","Vector narrow integer.",null,[[["uint16x8_t"]],["uint8x8_t"]]],[5,"vmovn_u32","","Vector narrow integer.",null,[[["uint32x4_t"]],["uint16x4_t"]]],[5,"vmovn_u64","","Vector narrow integer.",null,[[["uint64x2_t"]],["uint32x2_t"]]],[5,"vmovl_s8","","Vector long move.",null,[[["int8x8_t"]],["int16x8_t"]]],[5,"vmovl_s16","","Vector long move.",null,[[["int16x4_t"]],["int32x4_t"]]],[5,"vmovl_s32","","Vector long move.",null,[[["int32x2_t"]],["int64x2_t"]]],[5,"vmovl_u8","","Vector long move.",null,[[["uint8x8_t"]],["uint16x8_t"]]],[5,"vmovl_u16","","Vector long move.",null,[[["uint16x4_t"]],["uint32x4_t"]]],[5,"vmovl_u32","","Vector long move.",null,[[["uint32x2_t"]],["uint64x2_t"]]],[5,"vrsqrte_f32","","Reciprocal square-root estimate.",null,[[["float32x2_t"]],["float32x2_t"]]],[5,"vmvn_s8","","Vector bitwise not.",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vmvnq_s8","","Vector bitwise not.",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vmvn_s16","","Vector bitwise not.",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vmvnq_s16","","Vector bitwise not.",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vmvn_s32","","Vector bitwise not.",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vmvnq_s32","","Vector bitwise not.",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vmvn_u8","","Vector bitwise not.",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vmvnq_u8","","Vector bitwise not.",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vmvn_u16","","Vector bitwise not.",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vmvnq_u16","","Vector bitwise not.",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vmvn_u32","","Vector bitwise not.",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vmvnq_u32","","Vector bitwise not.",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vmvn_p8","","Vector bitwise not.",null,[[["poly8x8_t"]],["poly8x8_t"]]],[5,"vmvnq_p8","","Vector bitwise not.",null,[[["poly8x16_t"]],["poly8x16_t"]]],[5,"vpmin_s8","","Folding minimum of adjacent pairs",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vpmin_s16","","Folding minimum of adjacent pairs",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vpmin_s32","","Folding minimum of adjacent pairs",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vpmin_u8","","Folding minimum of adjacent pairs",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vpmin_u16","","Folding minimum of adjacent pairs",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vpmin_u32","","Folding minimum of adjacent pairs",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vpmin_f32","","Folding minimum of adjacent pairs",null,[[["float32x2_t"]],["float32x2_t"]]],[5,"vpmax_s8","","Folding maximum of adjacent pairs",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vpmax_s16","","Folding maximum of adjacent pairs",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vpmax_s32","","Folding maximum of adjacent pairs",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vpmax_u8","","Folding maximum of adjacent pairs",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vpmax_u16","","Folding maximum of adjacent pairs",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vpmax_u32","","Folding maximum of adjacent pairs",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vpmax_f32","","Folding maximum of adjacent pairs",null,[[["float32x2_t"]],["float32x2_t"]]],[5,"vgetq_lane_u64","","Move vector element to general-purpose register",null,[[["i32"],["uint64x2_t"]],["u64"]]],[5,"vget_lane_u64","","Move vector element to general-purpose register",null,[[["uint64x1_t"],["i32"]],["u64"]]],[5,"vgetq_lane_u16","","Move vector element to general-purpose register",null,[[["uint16x8_t"],["i32"]],["u16"]]],[5,"vgetq_lane_u32","","Move vector element to general-purpose register",null,[[["i32"],["uint32x4_t"]],["u32"]]],[5,"vget_lane_u8","","Move vector element to general-purpose register",null,[[["uint8x8_t"],["i32"]],["u8"]]],[5,"vdupq_n_s8","","Duplicate vector element to vector or scalar",null,[[["i8"]],["int8x16_t"]]],[5,"vdupq_n_u8","","Duplicate vector element to vector or scalar",null,[[["u8"]],["uint8x16_t"]]],[5,"vmovq_n_u8","","Duplicate vector element to vector or scalar",null,[[["u8"]],["uint8x16_t"]]],[5,"vreinterpret_u64_u32","","Vector reinterpret cast operation",null,[[["uint32x2_t"]],["uint64x1_t"]]],[5,"vreinterpretq_s8_u8","","Vector reinterpret cast operation",null,[[["uint8x16_t"]],["int8x16_t"]]],[5,"vreinterpretq_u16_u8","","Vector reinterpret cast operation",null,[[["uint8x16_t"]],["uint16x8_t"]]],[5,"vreinterpretq_u32_u8","","Vector reinterpret cast operation",null,[[["uint8x16_t"]],["uint32x4_t"]]],[5,"vreinterpretq_u64_u8","","Vector reinterpret cast operation",null,[[["uint8x16_t"]],["uint64x2_t"]]],[5,"vreinterpretq_u8_s8","","Vector reinterpret cast operation",null,[[["int8x16_t"]],["uint8x16_t"]]],[5,"vshrq_n_u8","","Unsigned shift right",null,[[["uint8x16_t"],["i32"]],["uint8x16_t"]]],[5,"vshlq_n_u8","","Shift right",null,[[["uint8x16_t"],["i32"]],["uint8x16_t"]]],[5,"vextq_s8","","Extract vector from pair of vectors",null,[[["int8x16_t"],["i32"]],["int8x16_t"]]],[5,"vextq_u8","","Extract vector from pair of vectors",null,[[["uint8x16_t"],["i32"]],["uint8x16_t"]]],[5,"vld1q_s8","","Load multiple single-element structures to one, two,…",null,[[],["int8x16_t"]]],[5,"vld1q_u8","","Load multiple single-element structures to one, two,…",null,[[],["uint8x16_t"]]],[5,"__dmb","","Generates a DMB (data memory barrier) instruction or…",null,[[["a"]]]],[5,"__dsb","","Generates a DSB (data synchronization barrier) instruction…",null,[[["a"]]]],[5,"__isb","","Generates an ISB (instruction synchronization barrier)…",null,[[["a"]]]],[5,"__nop","","Generates an unspecified no-op instruction.",null,[[]]],[5,"__rsr","","Reads a 32-bit system register",null,[[["r"]],["u32"]]],[5,"__rsrp","","Reads a system register containing an address",null,[[["r"]]]],[5,"__wsr","","Writes a 32-bit system register",null,[[["u32"],["r"]]]],[5,"__wsrp","","Writes a system register containing an address",null,[[["r"]]]],[0,"aarch64","core::arch","Platform-specific intrinsics for the `aarch64` platform.",null,null],[3,"float64x1_t","core::arch::aarch64","ARM-specific 64-bit wide vector of one packed `f64`.",null,null],[3,"float64x2_t","","ARM-specific 128-bit wide vector of two packed `f64`.",null,null],[3,"poly64x1_t","","ARM-specific 64-bit wide vector of one packed `p64`.",null,null],[3,"poly64_t","","ARM-specific 64-bit wide vector of one packed `p64`.",null,null],[3,"poly64x2_t","","ARM-specific 64-bit wide vector of two packed `p64`.",null,null],[3,"poly128_t","","ARM-specific 128-bit wide vector of one packed `p64`.",null,null],[3,"int8x16x2_t","","ARM-specific type containing two `int8x16_t` vectors.",null,null],[12,"0","","",174,null],[12,"1","","",174,null],[3,"int8x16x3_t","","ARM-specific type containing three `int8x16_t` vectors.",null,null],[12,"0","","",175,null],[12,"1","","",175,null],[12,"2","","",175,null],[3,"int8x16x4_t","","ARM-specific type containing four `int8x16_t` vectors.",null,null],[12,"0","","",176,null],[12,"1","","",176,null],[12,"2","","",176,null],[12,"3","","",176,null],[3,"uint8x16x2_t","","ARM-specific type containing two `uint8x16_t` vectors.",null,null],[12,"0","","",177,null],[12,"1","","",177,null],[3,"uint8x16x3_t","","ARM-specific type containing three `uint8x16_t` vectors.",null,null],[12,"0","","",178,null],[12,"1","","",178,null],[12,"2","","",178,null],[3,"uint8x16x4_t","","ARM-specific type containing four `uint8x16_t` vectors.",null,null],[12,"0","","",179,null],[12,"1","","",179,null],[12,"2","","",179,null],[12,"3","","",179,null],[3,"poly8x16x2_t","","ARM-specific type containing two `poly8x16_t` vectors.",null,null],[12,"0","","",180,null],[12,"1","","",180,null],[3,"poly8x16x3_t","","ARM-specific type containing three `poly8x16_t` vectors.",null,null],[12,"0","","",181,null],[12,"1","","",181,null],[12,"2","","",181,null],[3,"poly8x16x4_t","","ARM-specific type containing four `poly8x16_t` vectors.",null,null],[12,"0","","",182,null],[12,"1","","",182,null],[12,"2","","",182,null],[12,"3","","",182,null],[3,"SY","","Full system is the required shareability domain, reads and…",null,null],[3,"APSR","","Application Program Status Register",null,null],[3,"int8x8_t","","ARM-specific 64-bit wide vector of eight packed `i8`.",null,null],[3,"uint8x8_t","","ARM-specific 64-bit wide vector of eight packed `u8`.",null,null],[3,"poly8x8_t","","ARM-specific 64-bit wide polynomial vector of eight packed…",null,null],[3,"int16x4_t","","ARM-specific 64-bit wide vector of four packed `i16`.",null,null],[3,"uint16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",null,null],[3,"poly16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",null,null],[3,"int32x2_t","","ARM-specific 64-bit wide vector of two packed `i32`.",null,null],[3,"uint32x2_t","","ARM-specific 64-bit wide vector of two packed `u32`.",null,null],[3,"float32x2_t","","ARM-specific 64-bit wide vector of two packed `f32`.",null,null],[3,"int64x1_t","","ARM-specific 64-bit wide vector of one packed `i64`.",null,null],[3,"uint64x1_t","","ARM-specific 64-bit wide vector of one packed `u64`.",null,null],[3,"int8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `i8`.",null,null],[3,"uint8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",null,null],[3,"poly8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",null,null],[3,"int16x8_t","","ARM-specific 128-bit wide vector of eight packed `i16`.",null,null],[3,"uint16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",null,null],[3,"poly16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",null,null],[3,"int32x4_t","","ARM-specific 128-bit wide vector of four packed `i32`.",null,null],[3,"uint32x4_t","","ARM-specific 128-bit wide vector of four packed `u32`.",null,null],[3,"float32x4_t","","ARM-specific 128-bit wide vector of four packed `f32`.",null,null],[3,"int64x2_t","","ARM-specific 128-bit wide vector of two packed `i64`.",null,null],[3,"uint64x2_t","","ARM-specific 128-bit wide vector of two packed `u64`.",null,null],[3,"int8x8x2_t","","ARM-specific type containing two `int8x8_t` vectors.",null,null],[12,"0","","",165,null],[12,"1","","",165,null],[3,"int8x8x3_t","","ARM-specific type containing three `int8x8_t` vectors.",null,null],[12,"0","","",166,null],[12,"1","","",166,null],[12,"2","","",166,null],[3,"int8x8x4_t","","ARM-specific type containing four `int8x8_t` vectors.",null,null],[12,"0","","",167,null],[12,"1","","",167,null],[12,"2","","",167,null],[12,"3","","",167,null],[3,"uint8x8x2_t","","ARM-specific type containing two `uint8x8_t` vectors.",null,null],[12,"0","","",168,null],[12,"1","","",168,null],[3,"uint8x8x3_t","","ARM-specific type containing three `uint8x8_t` vectors.",null,null],[12,"0","","",169,null],[12,"1","","",169,null],[12,"2","","",169,null],[3,"uint8x8x4_t","","ARM-specific type containing four `uint8x8_t` vectors.",null,null],[12,"0","","",170,null],[12,"1","","",170,null],[12,"2","","",170,null],[12,"3","","",170,null],[3,"poly8x8x2_t","","ARM-specific type containing two `poly8x8_t` vectors.",null,null],[12,"0","","",171,null],[12,"1","","",171,null],[3,"poly8x8x3_t","","ARM-specific type containing three `poly8x8_t` vectors.",null,null],[12,"0","","",172,null],[12,"1","","",172,null],[12,"2","","",172,null],[3,"poly8x8x4_t","","ARM-specific type containing four `poly8x8_t` vectors.",null,null],[12,"0","","",173,null],[12,"1","","",173,null],[12,"2","","",173,null],[12,"3","","",173,null],[3,"SY","","Full system is the required shareability domain, reads and…",null,null],[3,"APSR","","Application Program Status Register",null,null],[5,"_rev_u64","","Reverse the order of the bytes.",null,[[["u64"]],["u64"]]],[5,"_clz_u64","","Count Leading Zeros.",null,[[["u64"]],["u64"]]],[5,"_rbit_u64","","Reverse the bit order.",null,[[["u64"]],["u64"]]],[5,"_cls_u32","","Counts the leading most significant bits set.",null,[[["u32"]],["u32"]]],[5,"_cls_u64","","Counts the leading most significant bits set.",null,[[["u64"]],["u64"]]],[5,"vceq_u64","","Compare bitwise Equal (vector)",null,[[["uint64x1_t"]],["uint64x1_t"]]],[5,"vceqq_u64","","Compare bitwise Equal (vector)",null,[[["uint64x2_t"]],["uint64x2_t"]]],[5,"vceq_s64","","Compare bitwise Equal (vector)",null,[[["int64x1_t"]],["uint64x1_t"]]],[5,"vceqq_s64","","Compare bitwise Equal (vector)",null,[[["int64x2_t"]],["uint64x2_t"]]],[5,"vceq_p64","","Compare bitwise Equal (vector)",null,[[["poly64x1_t"]],["uint64x1_t"]]],[5,"vceqq_p64","","Compare bitwise Equal (vector)",null,[[["poly64x2_t"]],["uint64x2_t"]]],[5,"vceq_f64","","Floating-point compare equal",null,[[["float64x1_t"]],["uint64x1_t"]]],[5,"vceqq_f64","","Floating-point compare equal",null,[[["float64x2_t"]],["uint64x2_t"]]],[5,"vcgt_s64","","Compare signed greater than",null,[[["int64x1_t"]],["uint64x1_t"]]],[5,"vcgtq_s64","","Compare signed greater than",null,[[["int64x2_t"]],["uint64x2_t"]]],[5,"vcgt_u64","","Compare unsigned highe",null,[[["uint64x1_t"]],["uint64x1_t"]]],[5,"vcgtq_u64","","Compare unsigned highe",null,[[["uint64x2_t"]],["uint64x2_t"]]],[5,"vcgt_f64","","Floating-point compare greater than",null,[[["float64x1_t"]],["uint64x1_t"]]],[5,"vcgtq_f64","","Floating-point compare greater than",null,[[["float64x2_t"]],["uint64x2_t"]]],[5,"vclt_s64","","Compare signed less than",null,[[["int64x1_t"]],["uint64x1_t"]]],[5,"vcltq_s64","","Compare signed less than",null,[[["int64x2_t"]],["uint64x2_t"]]],[5,"vclt_u64","","Compare unsigned less than",null,[[["uint64x1_t"]],["uint64x1_t"]]],[5,"vcltq_u64","","Compare unsigned less than",null,[[["uint64x2_t"]],["uint64x2_t"]]],[5,"vclt_f64","","Floating-point compare less than",null,[[["float64x1_t"]],["uint64x1_t"]]],[5,"vcltq_f64","","Floating-point compare less than",null,[[["float64x2_t"]],["uint64x2_t"]]],[5,"vcle_s64","","Compare signed less than or equal",null,[[["int64x1_t"]],["uint64x1_t"]]],[5,"vcleq_s64","","Compare signed less than or equal",null,[[["int64x2_t"]],["uint64x2_t"]]],[5,"vcle_u64","","Compare unsigned less than or equal",null,[[["uint64x1_t"]],["uint64x1_t"]]],[5,"vcleq_u64","","Compare unsigned less than or equal",null,[[["uint64x2_t"]],["uint64x2_t"]]],[5,"vcle_f64","","Floating-point compare less than or equal",null,[[["float64x1_t"]],["uint64x1_t"]]],[5,"vcleq_f64","","Floating-point compare less than or equal",null,[[["float64x2_t"]],["uint64x2_t"]]],[5,"vcge_s64","","Compare signed greater than or equal",null,[[["int64x1_t"]],["uint64x1_t"]]],[5,"vcgeq_s64","","Compare signed greater than or equal",null,[[["int64x2_t"]],["uint64x2_t"]]],[5,"vcge_u64","","Compare unsigned greater than or equal",null,[[["uint64x1_t"]],["uint64x1_t"]]],[5,"vcgeq_u64","","Compare unsigned greater than or equal",null,[[["uint64x2_t"]],["uint64x2_t"]]],[5,"vcge_f64","","Floating-point compare greater than or equal",null,[[["float64x1_t"]],["uint64x1_t"]]],[5,"vcgeq_f64","","Floating-point compare greater than or equal",null,[[["float64x2_t"]],["uint64x2_t"]]],[5,"vmul_f64","","Multiply",null,[[["float64x1_t"]],["float64x1_t"]]],[5,"vmulq_f64","","Multiply",null,[[["float64x2_t"]],["float64x2_t"]]],[5,"vsub_f64","","Subtract",null,[[["float64x1_t"]],["float64x1_t"]]],[5,"vsubq_f64","","Subtract",null,[[["float64x2_t"]],["float64x2_t"]]],[5,"vpaddq_u8","","Add pairwise",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vmull_p64","","Polynomial multiply long",null,[[["poly64_t"]],["poly128_t"]]],[5,"vadd_f64","","Vector add.",null,[[["float64x1_t"]],["float64x1_t"]]],[5,"vaddq_f64","","Vector add.",null,[[["float64x2_t"]],["float64x2_t"]]],[5,"vaddd_s64","","Vector add.",null,[[["i64"]],["i64"]]],[5,"vaddd_u64","","Vector add.",null,[[["u64"]],["u64"]]],[5,"vmaxv_s8","","Horizontal vector max.",null,[[["int8x8_t"]],["i8"]]],[5,"vmaxvq_s8","","Horizontal vector max.",null,[[["int8x16_t"]],["i8"]]],[5,"vmaxv_s16","","Horizontal vector max.",null,[[["int16x4_t"]],["i16"]]],[5,"vmaxvq_s16","","Horizontal vector max.",null,[[["int16x8_t"]],["i16"]]],[5,"vmaxv_s32","","Horizontal vector max.",null,[[["int32x2_t"]],["i32"]]],[5,"vmaxvq_s32","","Horizontal vector max.",null,[[["int32x4_t"]],["i32"]]],[5,"vmaxv_u8","","Horizontal vector max.",null,[[["uint8x8_t"]],["u8"]]],[5,"vmaxvq_u8","","Horizontal vector max.",null,[[["uint8x16_t"]],["u8"]]],[5,"vmaxv_u16","","Horizontal vector max.",null,[[["uint16x4_t"]],["u16"]]],[5,"vmaxvq_u16","","Horizontal vector max.",null,[[["uint16x8_t"]],["u16"]]],[5,"vmaxv_u32","","Horizontal vector max.",null,[[["uint32x2_t"]],["u32"]]],[5,"vmaxvq_u32","","Horizontal vector max.",null,[[["uint32x4_t"]],["u32"]]],[5,"vmaxv_f32","","Horizontal vector max.",null,[[["float32x2_t"]],["f32"]]],[5,"vmaxvq_f32","","Horizontal vector max.",null,[[["float32x4_t"]],["f32"]]],[5,"vmaxvq_f64","","Horizontal vector max.",null,[[["float64x2_t"]],["f64"]]],[5,"vminv_s8","","Horizontal vector min.",null,[[["int8x8_t"]],["i8"]]],[5,"vminvq_s8","","Horizontal vector min.",null,[[["int8x16_t"]],["i8"]]],[5,"vminv_s16","","Horizontal vector min.",null,[[["int16x4_t"]],["i16"]]],[5,"vminvq_s16","","Horizontal vector min.",null,[[["int16x8_t"]],["i16"]]],[5,"vminv_s32","","Horizontal vector min.",null,[[["int32x2_t"]],["i32"]]],[5,"vminvq_s32","","Horizontal vector min.",null,[[["int32x4_t"]],["i32"]]],[5,"vminv_u8","","Horizontal vector min.",null,[[["uint8x8_t"]],["u8"]]],[5,"vminvq_u8","","Horizontal vector min.",null,[[["uint8x16_t"]],["u8"]]],[5,"vminv_u16","","Horizontal vector min.",null,[[["uint16x4_t"]],["u16"]]],[5,"vminvq_u16","","Horizontal vector min.",null,[[["uint16x8_t"]],["u16"]]],[5,"vminv_u32","","Horizontal vector min.",null,[[["uint32x2_t"]],["u32"]]],[5,"vminvq_u32","","Horizontal vector min.",null,[[["uint32x4_t"]],["u32"]]],[5,"vminv_f32","","Horizontal vector min.",null,[[["float32x2_t"]],["f32"]]],[5,"vminvq_f32","","Horizontal vector min.",null,[[["float32x4_t"]],["f32"]]],[5,"vminvq_f64","","Horizontal vector min.",null,[[["float64x2_t"]],["f64"]]],[5,"vpminq_s8","","Folding minimum of adjacent pairs",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vpminq_s16","","Folding minimum of adjacent pairs",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vpminq_s32","","Folding minimum of adjacent pairs",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vpminq_u8","","Folding minimum of adjacent pairs",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vpminq_u16","","Folding minimum of adjacent pairs",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vpminq_u32","","Folding minimum of adjacent pairs",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vpminq_f32","","Folding minimum of adjacent pairs",null,[[["float32x4_t"]],["float32x4_t"]]],[5,"vpminq_f64","","Folding minimum of adjacent pairs",null,[[["float64x2_t"]],["float64x2_t"]]],[5,"vpmaxq_s8","","Folding maximum of adjacent pairs",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vpmaxq_s16","","Folding maximum of adjacent pairs",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vpmaxq_s32","","Folding maximum of adjacent pairs",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vpmaxq_u8","","Folding maximum of adjacent pairs",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vpmaxq_u16","","Folding maximum of adjacent pairs",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vpmaxq_u32","","Folding maximum of adjacent pairs",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vpmaxq_f32","","Folding maximum of adjacent pairs",null,[[["float32x4_t"]],["float32x4_t"]]],[5,"vpmaxq_f64","","Folding maximum of adjacent pairs",null,[[["float64x2_t"]],["float64x2_t"]]],[5,"vcombine_s8","","Vector combine",null,[[["int8x8_t"]],["int8x16_t"]]],[5,"vcombine_s16","","Vector combine",null,[[["int16x4_t"]],["int16x8_t"]]],[5,"vcombine_s32","","Vector combine",null,[[["int32x2_t"]],["int32x4_t"]]],[5,"vcombine_s64","","Vector combine",null,[[["int64x1_t"]],["int64x2_t"]]],[5,"vcombine_u8","","Vector combine",null,[[["uint8x8_t"]],["uint8x16_t"]]],[5,"vcombine_u16","","Vector combine",null,[[["uint16x4_t"]],["uint16x8_t"]]],[5,"vcombine_u32","","Vector combine",null,[[["uint32x2_t"]],["uint32x4_t"]]],[5,"vcombine_u64","","Vector combine",null,[[["uint64x1_t"]],["uint64x2_t"]]],[5,"vcombine_p64","","Vector combine",null,[[["poly64x1_t"]],["poly64x2_t"]]],[5,"vcombine_f32","","Vector combine",null,[[["float32x2_t"]],["float32x4_t"]]],[5,"vcombine_p8","","Vector combine",null,[[["poly8x8_t"]],["poly8x16_t"]]],[5,"vcombine_p16","","Vector combine",null,[[["poly16x4_t"]],["poly16x8_t"]]],[5,"vcombine_f64","","Vector combine",null,[[["float64x1_t"]],["float64x2_t"]]],[5,"vtbl1_s8","","Table look-up",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vtbl1_u8","","Table look-up",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vtbl1_p8","","Table look-up",null,[[["uint8x8_t"],["poly8x8_t"]],["poly8x8_t"]]],[5,"vtbl2_s8","","Table look-up",null,[[["int8x8x2_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vtbl2_u8","","Table look-up",null,[[["uint8x8x2_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vtbl2_p8","","Table look-up",null,[[["poly8x8x2_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vtbl3_s8","","Table look-up",null,[[["int8x8x3_t"],["int8x8_t"]],["int8x8_t"]]],[5,"vtbl3_u8","","Table look-up",null,[[["uint8x8_t"],["uint8x8x3_t"]],["uint8x8_t"]]],[5,"vtbl3_p8","","Table look-up",null,[[["uint8x8_t"],["poly8x8x3_t"]],["poly8x8_t"]]],[5,"vtbl4_s8","","Table look-up",null,[[["int8x8_t"],["int8x8x4_t"]],["int8x8_t"]]],[5,"vtbl4_u8","","Table look-up",null,[[["uint8x8_t"],["uint8x8x4_t"]],["uint8x8_t"]]],[5,"vtbl4_p8","","Table look-up",null,[[["poly8x8x4_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vtbx1_s8","","Extended table look-up",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vtbx1_u8","","Extended table look-up",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vtbx1_p8","","Extended table look-up",null,[[["uint8x8_t"],["poly8x8_t"]],["poly8x8_t"]]],[5,"vtbx2_s8","","Extended table look-up",null,[[["int8x8_t"],["int8x8x2_t"]],["int8x8_t"]]],[5,"vtbx2_u8","","Extended table look-up",null,[[["uint8x8_t"],["uint8x8x2_t"]],["uint8x8_t"]]],[5,"vtbx2_p8","","Extended table look-up",null,[[["poly8x8x2_t"],["uint8x8_t"],["poly8x8_t"]],["poly8x8_t"]]],[5,"vtbx3_s8","","Extended table look-up",null,[[["int8x8_t"],["int8x8x3_t"]],["int8x8_t"]]],[5,"vtbx3_u8","","Extended table look-up",null,[[["uint8x8_t"],["uint8x8x3_t"]],["uint8x8_t"]]],[5,"vtbx3_p8","","Extended table look-up",null,[[["uint8x8_t"],["poly8x8x3_t"],["poly8x8_t"]],["poly8x8_t"]]],[5,"vtbx4_s8","","Extended table look-up",null,[[["int8x8_t"],["int8x8x4_t"]],["int8x8_t"]]],[5,"vtbx4_u8","","Extended table look-up",null,[[["uint8x8_t"],["uint8x8x4_t"]],["uint8x8_t"]]],[5,"vtbx4_p8","","Extended table look-up",null,[[["poly8x8x4_t"],["uint8x8_t"],["poly8x8_t"]],["poly8x8_t"]]],[5,"vqtbl1_s8","","Table look-up",null,[[["int8x16_t"],["uint8x8_t"]],["int8x8_t"]]],[5,"vqtbl1q_s8","","Table look-up",null,[[["int8x16_t"],["uint8x16_t"]],["int8x16_t"]]],[5,"vqtbl1_u8","","Table look-up",null,[[["uint8x16_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vqtbl1q_u8","","Table look-up",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vqtbl1_p8","","Table look-up",null,[[["poly8x16_t"],["uint8x8_t"]],["poly8x8_t"]]],[5,"vqtbl1q_p8","","Table look-up",null,[[["poly8x16_t"],["uint8x16_t"]],["poly8x16_t"]]],[5,"vqtbx1_s8","","Extended table look-up",null,[[["int8x8_t"],["int8x16_t"],["uint8x8_t"]],["int8x8_t"]]],[5,"vqtbx1q_s8","","Extended table look-up",null,[[["int8x16_t"],["uint8x16_t"]],["int8x16_t"]]],[5,"vqtbx1_u8","","Extended table look-up",null,[[["uint8x8_t"],["uint8x16_t"]],["uint8x8_t"]]],[5,"vqtbx1q_u8","","Extended table look-up",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vqtbx1_p8","","Extended table look-up",null,[[["poly8x16_t"],["uint8x8_t"],["poly8x8_t"]],["poly8x8_t"]]],[5,"vqtbx1q_p8","","Extended table look-up",null,[[["poly8x16_t"],["uint8x16_t"]],["poly8x16_t"]]],[5,"vqtbl2_s8","","Table look-up",null,[[["int8x16x2_t"],["uint8x8_t"]],["int8x8_t"]]],[5,"vqtbl2q_s8","","Table look-up",null,[[["int8x16x2_t"],["uint8x16_t"]],["int8x16_t"]]],[5,"vqtbl2_u8","","Table look-up",null,[[["uint8x8_t"],["uint8x16x2_t"]],["uint8x8_t"]]],[5,"vqtbl2q_u8","","Table look-up",null,[[["uint8x16_t"],["uint8x16x2_t"]],["uint8x16_t"]]],[5,"vqtbl2_p8","","Table look-up",null,[[["uint8x8_t"],["poly8x16x2_t"]],["poly8x8_t"]]],[5,"vqtbl2q_p8","","Table look-up",null,[[["uint8x16_t"],["poly8x16x2_t"]],["poly8x16_t"]]],[5,"vqtbx2_s8","","Extended table look-up",null,[[["int8x8_t"],["int8x16x2_t"],["uint8x8_t"]],["int8x8_t"]]],[5,"vqtbx2q_s8","","Extended table look-up",null,[[["int8x16_t"],["int8x16x2_t"],["uint8x16_t"]],["int8x16_t"]]],[5,"vqtbx2_u8","","Extended table look-up",null,[[["uint8x8_t"],["uint8x16x2_t"]],["uint8x8_t"]]],[5,"vqtbx2q_u8","","Extended table look-up",null,[[["uint8x16_t"],["uint8x16x2_t"]],["uint8x16_t"]]],[5,"vqtbx2_p8","","Extended table look-up",null,[[["poly8x16x2_t"],["uint8x8_t"],["poly8x8_t"]],["poly8x8_t"]]],[5,"vqtbx2q_p8","","Extended table look-up",null,[[["poly8x16_t"],["uint8x16_t"],["poly8x16x2_t"]],["poly8x16_t"]]],[5,"vqtbl3_s8","","Table look-up",null,[[["uint8x8_t"],["int8x16x3_t"]],["int8x8_t"]]],[5,"vqtbl3q_s8","","Table look-up",null,[[["uint8x16_t"],["int8x16x3_t"]],["int8x16_t"]]],[5,"vqtbl3_u8","","Table look-up",null,[[["uint8x16x3_t"],["uint8x8_t"]],["uint8x8_t"]]],[5,"vqtbl3q_u8","","Table look-up",null,[[["uint8x16x3_t"],["uint8x16_t"]],["uint8x16_t"]]],[5,"vqtbl3_p8","","Table look-up",null,[[["uint8x8_t"],["poly8x16x3_t"]],["poly8x8_t"]]],[5,"vqtbl3q_p8","","Table look-up",null,[[["uint8x16_t"],["poly8x16x3_t"]],["poly8x16_t"]]],[5,"vqtbx3_s8","","Extended table look-up",null,[[["int8x8_t"],["uint8x8_t"],["int8x16x3_t"]],["int8x8_t"]]],[5,"vqtbx3q_s8","","Extended table look-up",null,[[["int8x16_t"],["int8x16x3_t"],["uint8x16_t"]],["int8x16_t"]]],[5,"vqtbx3_u8","","Extended table look-up",null,[[["uint8x8_t"],["uint8x16x3_t"]],["uint8x8_t"]]],[5,"vqtbx3q_u8","","Extended table look-up",null,[[["uint8x16_t"],["uint8x16x3_t"]],["uint8x16_t"]]],[5,"vqtbx3_p8","","Extended table look-up",null,[[["uint8x8_t"],["poly8x16x3_t"],["poly8x8_t"]],["poly8x8_t"]]],[5,"vqtbx3q_p8","","Extended table look-up",null,[[["poly8x16_t"],["poly8x16x3_t"],["uint8x16_t"]],["poly8x16_t"]]],[5,"vqtbl4_s8","","Table look-up",null,[[["uint8x8_t"],["int8x16x4_t"]],["int8x8_t"]]],[5,"vqtbl4q_s8","","Table look-up",null,[[["uint8x16_t"],["int8x16x4_t"]],["int8x16_t"]]],[5,"vqtbl4_u8","","Table look-up",null,[[["uint8x8_t"],["uint8x16x4_t"]],["uint8x8_t"]]],[5,"vqtbl4q_u8","","Table look-up",null,[[["uint8x16_t"],["uint8x16x4_t"]],["uint8x16_t"]]],[5,"vqtbl4_p8","","Table look-up",null,[[["uint8x8_t"],["poly8x16x4_t"]],["poly8x8_t"]]],[5,"vqtbl4q_p8","","Table look-up",null,[[["uint8x16_t"],["poly8x16x4_t"]],["poly8x16_t"]]],[5,"vqtbx4_s8","","Extended table look-up",null,[[["int8x8_t"],["uint8x8_t"],["int8x16x4_t"]],["int8x8_t"]]],[5,"vqtbx4q_s8","","Extended table look-up",null,[[["int8x16_t"],["int8x16x4_t"],["uint8x16_t"]],["int8x16_t"]]],[5,"vqtbx4_u8","","Extended table look-up",null,[[["uint8x8_t"],["uint8x16x4_t"]],["uint8x8_t"]]],[5,"vqtbx4q_u8","","Extended table look-up",null,[[["uint8x16_t"],["uint8x16x4_t"]],["uint8x16_t"]]],[5,"vqtbx4_p8","","Extended table look-up",null,[[["poly8x16x4_t"],["uint8x8_t"],["poly8x8_t"]],["poly8x8_t"]]],[5,"vqtbx4q_p8","","Extended table look-up",null,[[["poly8x16_t"],["uint8x16_t"],["poly8x16x4_t"]],["poly8x16_t"]]],[5,"vaeseq_u8","","AES single round encryption.",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vaesdq_u8","","AES single round decryption.",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vaesmcq_u8","","AES mix columns.",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vaesimcq_u8","","AES inverse mix columns.",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vsha1h_u32","","SHA1 fixed rotate.",null,[[["u32"]],["u32"]]],[5,"vsha1cq_u32","","SHA1 hash update accelerator, choose.",null,[[["u32"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha1mq_u32","","SHA1 hash update accelerator, majority.",null,[[["u32"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha1pq_u32","","SHA1 hash update accelerator, parity.",null,[[["u32"],["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha1su0q_u32","","SHA1 schedule update accelerator, first part.",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha1su1q_u32","","SHA1 schedule update accelerator, second part.",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha256hq_u32","","SHA256 hash update accelerator.",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha256h2q_u32","","SHA256 hash update accelerator, upper part.",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha256su0q_u32","","SHA256 schedule update accelerator, first part.",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vsha256su1q_u32","","SHA256 schedule update accelerator, second part.",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"__crc32d","","CRC32 single round checksum for quad words (64 bits).",null,[[["u32"],["u64"]],["u32"]]],[5,"__crc32cd","","CRC32-C single round checksum for quad words (64 bits).",null,[[["u32"],["u64"]],["u32"]]],[5,"__dmb","","Generates a DMB (data memory barrier) instruction or…",null,[[["a"]]]],[5,"__dsb","","Generates a DSB (data synchronization barrier) instruction…",null,[[["a"]]]],[5,"__isb","","Generates an ISB (instruction synchronization barrier)…",null,[[["a"]]]],[5,"__nop","","Generates an unspecified no-op instruction.",null,[[]]],[5,"__rsr","","Reads a 32-bit system register",null,[[["r"]],["u32"]]],[5,"__rsrp","","Reads a system register containing an address",null,[[["r"]]]],[5,"__wsr","","Writes a 32-bit system register",null,[[["u32"],["r"]]]],[5,"__wsrp","","Writes a system register containing an address",null,[[["r"]]]],[5,"brk","","Generates the trap instruction `BRK 1`",null,[[]]],[5,"__breakpoint","","Inserts a breakpoint instruction.",null,[[["i32"]]]],[5,"_rev_u16","","Reverse the order of the bytes.",null,[[["u16"]],["u16"]]],[5,"_rev_u32","","Reverse the order of the bytes.",null,[[["u32"]],["u32"]]],[5,"vand_s8","","Vector bitwise and",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vandq_s8","","Vector bitwise and",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vand_s16","","Vector bitwise and",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vandq_s16","","Vector bitwise and",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vand_s32","","Vector bitwise and",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vandq_s32","","Vector bitwise and",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vand_u8","","Vector bitwise and",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vandq_u8","","Vector bitwise and",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vand_u16","","Vector bitwise and",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vandq_u16","","Vector bitwise and",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vand_u32","","Vector bitwise and",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vandq_u32","","Vector bitwise and",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vand_s64","","Vector bitwise and",null,[[["int64x1_t"]],["int64x1_t"]]],[5,"vandq_s64","","Vector bitwise and",null,[[["int64x2_t"]],["int64x2_t"]]],[5,"vand_u64","","Vector bitwise and",null,[[["uint64x1_t"]],["uint64x1_t"]]],[5,"vandq_u64","","Vector bitwise and",null,[[["uint64x2_t"]],["uint64x2_t"]]],[5,"vorr_s8","","Vector bitwise or (immediate, inclusive)",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vorrq_s8","","Vector bitwise or (immediate, inclusive)",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vorr_s16","","Vector bitwise or (immediate, inclusive)",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vorrq_s16","","Vector bitwise or (immediate, inclusive)",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vorr_s32","","Vector bitwise or (immediate, inclusive)",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vorrq_s32","","Vector bitwise or (immediate, inclusive)",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vorr_u8","","Vector bitwise or (immediate, inclusive)",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vorrq_u8","","Vector bitwise or (immediate, inclusive)",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vorr_u16","","Vector bitwise or (immediate, inclusive)",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vorrq_u16","","Vector bitwise or (immediate, inclusive)",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vorr_u32","","Vector bitwise or (immediate, inclusive)",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vorrq_u32","","Vector bitwise or (immediate, inclusive)",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vorr_s64","","Vector bitwise or (immediate, inclusive)",null,[[["int64x1_t"]],["int64x1_t"]]],[5,"vorrq_s64","","Vector bitwise or (immediate, inclusive)",null,[[["int64x2_t"]],["int64x2_t"]]],[5,"vorr_u64","","Vector bitwise or (immediate, inclusive)",null,[[["uint64x1_t"]],["uint64x1_t"]]],[5,"vorrq_u64","","Vector bitwise or (immediate, inclusive)",null,[[["uint64x2_t"]],["uint64x2_t"]]],[5,"veor_s8","","Vector bitwise exclusive or (vector)",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"veorq_s8","","Vector bitwise exclusive or (vector)",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"veor_s16","","Vector bitwise exclusive or (vector)",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"veorq_s16","","Vector bitwise exclusive or (vector)",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"veor_s32","","Vector bitwise exclusive or (vector)",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"veorq_s32","","Vector bitwise exclusive or (vector)",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"veor_u8","","Vector bitwise exclusive or (vector)",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"veorq_u8","","Vector bitwise exclusive or (vector)",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"veor_u16","","Vector bitwise exclusive or (vector)",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"veorq_u16","","Vector bitwise exclusive or (vector)",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"veor_u32","","Vector bitwise exclusive or (vector)",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"veorq_u32","","Vector bitwise exclusive or (vector)",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"veor_s64","","Vector bitwise exclusive or (vector)",null,[[["int64x1_t"]],["int64x1_t"]]],[5,"veorq_s64","","Vector bitwise exclusive or (vector)",null,[[["int64x2_t"]],["int64x2_t"]]],[5,"veor_u64","","Vector bitwise exclusive or (vector)",null,[[["uint64x1_t"]],["uint64x1_t"]]],[5,"veorq_u64","","Vector bitwise exclusive or (vector)",null,[[["uint64x2_t"]],["uint64x2_t"]]],[5,"vceq_u8","","Compare bitwise Equal (vector)",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vceqq_u8","","Compare bitwise Equal (vector)",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vceq_u16","","Compare bitwise Equal (vector)",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vceqq_u16","","Compare bitwise Equal (vector)",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vceq_u32","","Compare bitwise Equal (vector)",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vceqq_u32","","Compare bitwise Equal (vector)",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vceq_s8","","Compare bitwise Equal (vector)",null,[[["int8x8_t"]],["uint8x8_t"]]],[5,"vceqq_s8","","Compare bitwise Equal (vector)",null,[[["int8x16_t"]],["uint8x16_t"]]],[5,"vceq_s16","","Compare bitwise Equal (vector)",null,[[["int16x4_t"]],["uint16x4_t"]]],[5,"vceqq_s16","","Compare bitwise Equal (vector)",null,[[["int16x8_t"]],["uint16x8_t"]]],[5,"vceq_s32","","Compare bitwise Equal (vector)",null,[[["int32x2_t"]],["uint32x2_t"]]],[5,"vceqq_s32","","Compare bitwise Equal (vector)",null,[[["int32x4_t"]],["uint32x4_t"]]],[5,"vceq_f32","","Floating-point compare equal",null,[[["float32x2_t"]],["uint32x2_t"]]],[5,"vceqq_f32","","Floating-point compare equal",null,[[["float32x4_t"]],["uint32x4_t"]]],[5,"vcgt_s8","","Compare signed greater than",null,[[["int8x8_t"]],["uint8x8_t"]]],[5,"vcgtq_s8","","Compare signed greater than",null,[[["int8x16_t"]],["uint8x16_t"]]],[5,"vcgt_s16","","Compare signed greater than",null,[[["int16x4_t"]],["uint16x4_t"]]],[5,"vcgtq_s16","","Compare signed greater than",null,[[["int16x8_t"]],["uint16x8_t"]]],[5,"vcgt_s32","","Compare signed greater than",null,[[["int32x2_t"]],["uint32x2_t"]]],[5,"vcgtq_s32","","Compare signed greater than",null,[[["int32x4_t"]],["uint32x4_t"]]],[5,"vcgt_u8","","Compare unsigned highe",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vcgtq_u8","","Compare unsigned highe",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vcgt_u16","","Compare unsigned highe",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vcgtq_u16","","Compare unsigned highe",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vcgt_u32","","Compare unsigned highe",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vcgtq_u32","","Compare unsigned highe",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vcgt_f32","","Floating-point compare greater than",null,[[["float32x2_t"]],["uint32x2_t"]]],[5,"vcgtq_f32","","Floating-point compare greater than",null,[[["float32x4_t"]],["uint32x4_t"]]],[5,"vclt_s8","","Compare signed less than",null,[[["int8x8_t"]],["uint8x8_t"]]],[5,"vcltq_s8","","Compare signed less than",null,[[["int8x16_t"]],["uint8x16_t"]]],[5,"vclt_s16","","Compare signed less than",null,[[["int16x4_t"]],["uint16x4_t"]]],[5,"vcltq_s16","","Compare signed less than",null,[[["int16x8_t"]],["uint16x8_t"]]],[5,"vclt_s32","","Compare signed less than",null,[[["int32x2_t"]],["uint32x2_t"]]],[5,"vcltq_s32","","Compare signed less than",null,[[["int32x4_t"]],["uint32x4_t"]]],[5,"vclt_u8","","Compare unsigned less than",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vcltq_u8","","Compare unsigned less than",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vclt_u16","","Compare unsigned less than",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vcltq_u16","","Compare unsigned less than",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vclt_u32","","Compare unsigned less than",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vcltq_u32","","Compare unsigned less than",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vclt_f32","","Floating-point compare less than",null,[[["float32x2_t"]],["uint32x2_t"]]],[5,"vcltq_f32","","Floating-point compare less than",null,[[["float32x4_t"]],["uint32x4_t"]]],[5,"vcle_s8","","Compare signed less than or equal",null,[[["int8x8_t"]],["uint8x8_t"]]],[5,"vcleq_s8","","Compare signed less than or equal",null,[[["int8x16_t"]],["uint8x16_t"]]],[5,"vcle_s16","","Compare signed less than or equal",null,[[["int16x4_t"]],["uint16x4_t"]]],[5,"vcleq_s16","","Compare signed less than or equal",null,[[["int16x8_t"]],["uint16x8_t"]]],[5,"vcle_s32","","Compare signed less than or equal",null,[[["int32x2_t"]],["uint32x2_t"]]],[5,"vcleq_s32","","Compare signed less than or equal",null,[[["int32x4_t"]],["uint32x4_t"]]],[5,"vcle_u8","","Compare unsigned less than or equal",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vcleq_u8","","Compare unsigned less than or equal",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vcle_u16","","Compare unsigned less than or equal",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vcleq_u16","","Compare unsigned less than or equal",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vcle_u32","","Compare unsigned less than or equal",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vcleq_u32","","Compare unsigned less than or equal",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vcle_f32","","Floating-point compare less than or equal",null,[[["float32x2_t"]],["uint32x2_t"]]],[5,"vcleq_f32","","Floating-point compare less than or equal",null,[[["float32x4_t"]],["uint32x4_t"]]],[5,"vcge_s8","","Compare signed greater than or equal",null,[[["int8x8_t"]],["uint8x8_t"]]],[5,"vcgeq_s8","","Compare signed greater than or equal",null,[[["int8x16_t"]],["uint8x16_t"]]],[5,"vcge_s16","","Compare signed greater than or equal",null,[[["int16x4_t"]],["uint16x4_t"]]],[5,"vcgeq_s16","","Compare signed greater than or equal",null,[[["int16x8_t"]],["uint16x8_t"]]],[5,"vcge_s32","","Compare signed greater than or equal",null,[[["int32x2_t"]],["uint32x2_t"]]],[5,"vcgeq_s32","","Compare signed greater than or equal",null,[[["int32x4_t"]],["uint32x4_t"]]],[5,"vcge_u8","","Compare unsigned greater than or equal",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vcgeq_u8","","Compare unsigned greater than or equal",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vcge_u16","","Compare unsigned greater than or equal",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vcgeq_u16","","Compare unsigned greater than or equal",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vcge_u32","","Compare unsigned greater than or equal",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vcgeq_u32","","Compare unsigned greater than or equal",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vcge_f32","","Floating-point compare greater than or equal",null,[[["float32x2_t"]],["uint32x2_t"]]],[5,"vcgeq_f32","","Floating-point compare greater than or equal",null,[[["float32x4_t"]],["uint32x4_t"]]],[5,"vqsub_u8","","Saturating subtract",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vqsubq_u8","","Saturating subtract",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vqsub_u16","","Saturating subtract",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vqsubq_u16","","Saturating subtract",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vqsub_u32","","Saturating subtract",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vqsubq_u32","","Saturating subtract",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vqsub_s8","","Saturating subtract",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vqsubq_s8","","Saturating subtract",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vqsub_s16","","Saturating subtract",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vqsubq_s16","","Saturating subtract",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vqsub_s32","","Saturating subtract",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vqsubq_s32","","Saturating subtract",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vhadd_u8","","Halving add",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vhaddq_u8","","Halving add",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vhadd_u16","","Halving add",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vhaddq_u16","","Halving add",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vhadd_u32","","Halving add",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vhaddq_u32","","Halving add",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vhadd_s8","","Halving add",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vhaddq_s8","","Halving add",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vhadd_s16","","Halving add",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vhaddq_s16","","Halving add",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vhadd_s32","","Halving add",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vhaddq_s32","","Halving add",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vrhadd_u8","","Rounding halving add",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vrhaddq_u8","","Rounding halving add",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vrhadd_u16","","Rounding halving add",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vrhaddq_u16","","Rounding halving add",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vrhadd_u32","","Rounding halving add",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vrhaddq_u32","","Rounding halving add",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vrhadd_s8","","Rounding halving add",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vrhaddq_s8","","Rounding halving add",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vrhadd_s16","","Rounding halving add",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vrhaddq_s16","","Rounding halving add",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vrhadd_s32","","Rounding halving add",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vrhaddq_s32","","Rounding halving add",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vqadd_u8","","Saturating add",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vqaddq_u8","","Saturating add",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vqadd_u16","","Saturating add",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vqaddq_u16","","Saturating add",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vqadd_u32","","Saturating add",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vqaddq_u32","","Saturating add",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vqadd_s8","","Saturating add",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vqaddq_s8","","Saturating add",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vqadd_s16","","Saturating add",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vqaddq_s16","","Saturating add",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vqadd_s32","","Saturating add",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vqaddq_s32","","Saturating add",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vmul_s8","","Multiply",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vmulq_s8","","Multiply",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vmul_s16","","Multiply",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vmulq_s16","","Multiply",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vmul_s32","","Multiply",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vmulq_s32","","Multiply",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vmul_u8","","Multiply",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vmulq_u8","","Multiply",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vmul_u16","","Multiply",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vmulq_u16","","Multiply",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vmul_u32","","Multiply",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vmulq_u32","","Multiply",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vmul_f32","","Multiply",null,[[["float32x2_t"]],["float32x2_t"]]],[5,"vmulq_f32","","Multiply",null,[[["float32x4_t"]],["float32x4_t"]]],[5,"vsub_s8","","Subtract",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vsubq_s8","","Subtract",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vsub_s16","","Subtract",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vsubq_s16","","Subtract",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vsub_s32","","Subtract",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vsubq_s32","","Subtract",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vsub_u8","","Subtract",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vsubq_u8","","Subtract",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vsub_u16","","Subtract",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vsubq_u16","","Subtract",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vsub_u32","","Subtract",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vsubq_u32","","Subtract",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vsub_s64","","Subtract",null,[[["int64x1_t"]],["int64x1_t"]]],[5,"vsubq_s64","","Subtract",null,[[["int64x2_t"]],["int64x2_t"]]],[5,"vsub_u64","","Subtract",null,[[["uint64x1_t"]],["uint64x1_t"]]],[5,"vsubq_u64","","Subtract",null,[[["uint64x2_t"]],["uint64x2_t"]]],[5,"vsub_f32","","Subtract",null,[[["float32x2_t"]],["float32x2_t"]]],[5,"vsubq_f32","","Subtract",null,[[["float32x4_t"]],["float32x4_t"]]],[5,"vhsub_u8","","Signed halving subtract",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vhsubq_u8","","Signed halving subtract",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vhsub_u16","","Signed halving subtract",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vhsubq_u16","","Signed halving subtract",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vhsub_u32","","Signed halving subtract",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vhsubq_u32","","Signed halving subtract",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vhsub_s8","","Signed halving subtract",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vhsubq_s8","","Signed halving subtract",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vhsub_s16","","Signed halving subtract",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vhsubq_s16","","Signed halving subtract",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vhsub_s32","","Signed halving subtract",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vhsubq_s32","","Signed halving subtract",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vqmovn_u64","","Unsigned saturating extract narrow.",null,[[["uint64x2_t"]],["uint32x2_t"]]],[5,"vadd_s8","","Vector add.",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vaddq_s8","","Vector add.",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vadd_s16","","Vector add.",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vaddq_s16","","Vector add.",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vadd_s32","","Vector add.",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vaddq_s32","","Vector add.",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vaddq_s64","","Vector add.",null,[[["int64x2_t"]],["int64x2_t"]]],[5,"vadd_u8","","Vector add.",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vaddq_u8","","Vector add.",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vadd_u16","","Vector add.",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vaddq_u16","","Vector add.",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vadd_u32","","Vector add.",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vaddq_u32","","Vector add.",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vaddq_u64","","Vector add.",null,[[["uint64x2_t"]],["uint64x2_t"]]],[5,"vadd_f32","","Vector add.",null,[[["float32x2_t"]],["float32x2_t"]]],[5,"vaddq_f32","","Vector add.",null,[[["float32x4_t"]],["float32x4_t"]]],[5,"vaddl_s8","","Vector long add.",null,[[["int8x8_t"]],["int16x8_t"]]],[5,"vaddl_s16","","Vector long add.",null,[[["int16x4_t"]],["int32x4_t"]]],[5,"vaddl_s32","","Vector long add.",null,[[["int32x2_t"]],["int64x2_t"]]],[5,"vaddl_u8","","Vector long add.",null,[[["uint8x8_t"]],["uint16x8_t"]]],[5,"vaddl_u16","","Vector long add.",null,[[["uint16x4_t"]],["uint32x4_t"]]],[5,"vaddl_u32","","Vector long add.",null,[[["uint32x2_t"]],["uint64x2_t"]]],[5,"vmovn_s16","","Vector narrow integer.",null,[[["int16x8_t"]],["int8x8_t"]]],[5,"vmovn_s32","","Vector narrow integer.",null,[[["int32x4_t"]],["int16x4_t"]]],[5,"vmovn_s64","","Vector narrow integer.",null,[[["int64x2_t"]],["int32x2_t"]]],[5,"vmovn_u16","","Vector narrow integer.",null,[[["uint16x8_t"]],["uint8x8_t"]]],[5,"vmovn_u32","","Vector narrow integer.",null,[[["uint32x4_t"]],["uint16x4_t"]]],[5,"vmovn_u64","","Vector narrow integer.",null,[[["uint64x2_t"]],["uint32x2_t"]]],[5,"vmovl_s8","","Vector long move.",null,[[["int8x8_t"]],["int16x8_t"]]],[5,"vmovl_s16","","Vector long move.",null,[[["int16x4_t"]],["int32x4_t"]]],[5,"vmovl_s32","","Vector long move.",null,[[["int32x2_t"]],["int64x2_t"]]],[5,"vmovl_u8","","Vector long move.",null,[[["uint8x8_t"]],["uint16x8_t"]]],[5,"vmovl_u16","","Vector long move.",null,[[["uint16x4_t"]],["uint32x4_t"]]],[5,"vmovl_u32","","Vector long move.",null,[[["uint32x2_t"]],["uint64x2_t"]]],[5,"vrsqrte_f32","","Reciprocal square-root estimate.",null,[[["float32x2_t"]],["float32x2_t"]]],[5,"vmvn_s8","","Vector bitwise not.",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vmvnq_s8","","Vector bitwise not.",null,[[["int8x16_t"]],["int8x16_t"]]],[5,"vmvn_s16","","Vector bitwise not.",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vmvnq_s16","","Vector bitwise not.",null,[[["int16x8_t"]],["int16x8_t"]]],[5,"vmvn_s32","","Vector bitwise not.",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vmvnq_s32","","Vector bitwise not.",null,[[["int32x4_t"]],["int32x4_t"]]],[5,"vmvn_u8","","Vector bitwise not.",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vmvnq_u8","","Vector bitwise not.",null,[[["uint8x16_t"]],["uint8x16_t"]]],[5,"vmvn_u16","","Vector bitwise not.",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vmvnq_u16","","Vector bitwise not.",null,[[["uint16x8_t"]],["uint16x8_t"]]],[5,"vmvn_u32","","Vector bitwise not.",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vmvnq_u32","","Vector bitwise not.",null,[[["uint32x4_t"]],["uint32x4_t"]]],[5,"vmvn_p8","","Vector bitwise not.",null,[[["poly8x8_t"]],["poly8x8_t"]]],[5,"vmvnq_p8","","Vector bitwise not.",null,[[["poly8x16_t"]],["poly8x16_t"]]],[5,"vpmin_s8","","Folding minimum of adjacent pairs",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vpmin_s16","","Folding minimum of adjacent pairs",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vpmin_s32","","Folding minimum of adjacent pairs",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vpmin_u8","","Folding minimum of adjacent pairs",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vpmin_u16","","Folding minimum of adjacent pairs",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vpmin_u32","","Folding minimum of adjacent pairs",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vpmin_f32","","Folding minimum of adjacent pairs",null,[[["float32x2_t"]],["float32x2_t"]]],[5,"vpmax_s8","","Folding maximum of adjacent pairs",null,[[["int8x8_t"]],["int8x8_t"]]],[5,"vpmax_s16","","Folding maximum of adjacent pairs",null,[[["int16x4_t"]],["int16x4_t"]]],[5,"vpmax_s32","","Folding maximum of adjacent pairs",null,[[["int32x2_t"]],["int32x2_t"]]],[5,"vpmax_u8","","Folding maximum of adjacent pairs",null,[[["uint8x8_t"]],["uint8x8_t"]]],[5,"vpmax_u16","","Folding maximum of adjacent pairs",null,[[["uint16x4_t"]],["uint16x4_t"]]],[5,"vpmax_u32","","Folding maximum of adjacent pairs",null,[[["uint32x2_t"]],["uint32x2_t"]]],[5,"vpmax_f32","","Folding maximum of adjacent pairs",null,[[["float32x2_t"]],["float32x2_t"]]],[5,"vgetq_lane_u64","","Move vector element to general-purpose register",null,[[["i32"],["uint64x2_t"]],["u64"]]],[5,"vget_lane_u64","","Move vector element to general-purpose register",null,[[["uint64x1_t"],["i32"]],["u64"]]],[5,"vgetq_lane_u16","","Move vector element to general-purpose register",null,[[["uint16x8_t"],["i32"]],["u16"]]],[5,"vgetq_lane_u32","","Move vector element to general-purpose register",null,[[["i32"],["uint32x4_t"]],["u32"]]],[5,"vget_lane_u8","","Move vector element to general-purpose register",null,[[["uint8x8_t"],["i32"]],["u8"]]],[5,"vdupq_n_s8","","Duplicate vector element to vector or scalar",null,[[["i8"]],["int8x16_t"]]],[5,"vdupq_n_u8","","Duplicate vector element to vector or scalar",null,[[["u8"]],["uint8x16_t"]]],[5,"vmovq_n_u8","","Duplicate vector element to vector or scalar",null,[[["u8"]],["uint8x16_t"]]],[5,"vreinterpret_u64_u32","","Vector reinterpret cast operation",null,[[["uint32x2_t"]],["uint64x1_t"]]],[5,"vreinterpretq_s8_u8","","Vector reinterpret cast operation",null,[[["uint8x16_t"]],["int8x16_t"]]],[5,"vreinterpretq_u16_u8","","Vector reinterpret cast operation",null,[[["uint8x16_t"]],["uint16x8_t"]]],[5,"vreinterpretq_u32_u8","","Vector reinterpret cast operation",null,[[["uint8x16_t"]],["uint32x4_t"]]],[5,"vreinterpretq_u64_u8","","Vector reinterpret cast operation",null,[[["uint8x16_t"]],["uint64x2_t"]]],[5,"vreinterpretq_u8_s8","","Vector reinterpret cast operation",null,[[["int8x16_t"]],["uint8x16_t"]]],[5,"vshrq_n_u8","","Unsigned shift right",null,[[["uint8x16_t"],["i32"]],["uint8x16_t"]]],[5,"vshlq_n_u8","","Shift right",null,[[["uint8x16_t"],["i32"]],["uint8x16_t"]]],[5,"vextq_s8","","Extract vector from pair of vectors",null,[[["int8x16_t"],["i32"]],["int8x16_t"]]],[5,"vextq_u8","","Extract vector from pair of vectors",null,[[["uint8x16_t"],["i32"]],["uint8x16_t"]]],[5,"vld1q_s8","","Load multiple single-element structures to one, two,…",null,[[],["int8x16_t"]]],[5,"vld1q_u8","","Load multiple single-element structures to one, two,…",null,[[],["uint8x16_t"]]],[5,"__dmb","","Generates a DMB (data memory barrier) instruction or…",null,[[["a"]]]],[5,"__dsb","","Generates a DSB (data synchronization barrier) instruction…",null,[[["a"]]]],[5,"__isb","","Generates an ISB (instruction synchronization barrier)…",null,[[["a"]]]],[5,"__nop","","Generates an unspecified no-op instruction.",null,[[]]],[5,"__rsr","","Reads a 32-bit system register",null,[[["r"]],["u32"]]],[5,"__rsrp","","Reads a system register containing an address",null,[[["r"]]]],[5,"__wsr","","Writes a 32-bit system register",null,[[["u32"],["r"]]]],[5,"__wsrp","","Writes a system register containing an address",null,[[["r"]]]],[0,"wasm32","core::arch","Platform-specific intrinsics for the `wasm32` platform.",null,null],[3,"v128","core::arch::wasm32","WASM-specific 128-bit wide SIMD vector type.",null,null],[5,"i32_atomic_wait","","Corresponding intrinsic to wasm's [`i32.atomic.wait`…",null,[[["i64"],["i32"]],["i32"]]],[5,"i64_atomic_wait","","Corresponding intrinsic to wasm's [`i64.atomic.wait`…",null,[[["i64"]],["i32"]]],[5,"atomic_notify","","Corresponding intrinsic to wasm's [`atomic.notify`…",null,[[["u32"]],["u32"]]],[5,"v128_load","","Loads a `v128` vector from the given heap address.",null,[[],["v128"]]],[5,"v128_store","","Stores a `v128` vector to the given heap address.",null,[[["v128"]]]],[5,"v128_const","","Materializes a constant SIMD value from the immediate…",null,[[["u8"]],["v128"]]],[5,"i8x16_splat","","Creates a vector with identical lanes.",null,[[["i8"]],["v128"]]],[5,"i8x16_extract_lane","","Extracts a lane from a 128-bit vector interpreted as 16…",null,[[["v128"],["usize"]],["i8"]]],[5,"i8x16_replace_lane","","Replaces a lane from a 128-bit vector interpreted as 16…",null,[[["v128"],["i8"],["usize"]],["v128"]]],[5,"i16x8_splat","","Creates a vector with identical lanes.",null,[[["i16"]],["v128"]]],[5,"i16x8_extract_lane","","Extracts a lane from a 128-bit vector interpreted as 8…",null,[[["v128"],["usize"]],["i16"]]],[5,"i16x8_replace_lane","","Replaces a lane from a 128-bit vector interpreted as 8…",null,[[["v128"],["usize"],["i16"]],["v128"]]],[5,"i32x4_splat","","Creates a vector with identical lanes.",null,[[["i32"]],["v128"]]],[5,"i32x4_extract_lane","","Extracts a lane from a 128-bit vector interpreted as 4…",null,[[["v128"],["usize"]],["i32"]]],[5,"i32x4_replace_lane","","Replaces a lane from a 128-bit vector interpreted as 4…",null,[[["v128"],["usize"],["i32"]],["v128"]]],[5,"i64x2_splat","","Creates a vector with identical lanes.",null,[[["i64"]],["v128"]]],[5,"i64x2_extract_lane","","Extracts a lane from a 128-bit vector interpreted as 2…",null,[[["v128"],["usize"]],["i64"]]],[5,"i64x2_replace_lane","","Replaces a lane from a 128-bit vector interpreted as 2…",null,[[["v128"],["i64"],["usize"]],["v128"]]],[5,"f32x4_splat","","Creates a vector with identical lanes.",null,[[["f32"]],["v128"]]],[5,"f32x4_extract_lane","","Extracts a lane from a 128-bit vector interpreted as 4…",null,[[["v128"],["usize"]],["f32"]]],[5,"f32x4_replace_lane","","Replaces a lane from a 128-bit vector interpreted as 4…",null,[[["v128"],["f32"],["usize"]],["v128"]]],[5,"f64x2_splat","","Creates a vector with identical lanes.",null,[[["f64"]],["v128"]]],[5,"f64x2_extract_lane","","Extracts lane from a 128-bit vector interpreted as 2…",null,[[["v128"],["usize"]],["f64"]]],[5,"f64x2_replace_lane","","Replaces a lane from a 128-bit vector interpreted as 2…",null,[[["v128"],["f64"],["usize"]],["v128"]]],[5,"i8x16_eq","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i8x16_ne","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i8x16_lt_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i8x16_lt_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i8x16_gt_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i8x16_gt_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i8x16_le_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i8x16_le_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i8x16_ge_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i8x16_ge_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i16x8_eq","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i16x8_ne","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i16x8_lt_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i16x8_lt_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i16x8_gt_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i16x8_gt_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i16x8_le_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i16x8_le_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i16x8_ge_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i16x8_ge_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i32x4_eq","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i32x4_ne","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i32x4_lt_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i32x4_lt_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i32x4_gt_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i32x4_gt_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i32x4_le_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i32x4_le_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i32x4_ge_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"i32x4_ge_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"f32x4_eq","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"f32x4_ne","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"f32x4_lt","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"f32x4_gt","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"f32x4_le","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"f32x4_ge","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"f64x2_eq","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"f64x2_ne","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"f64x2_lt","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"f64x2_gt","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"f64x2_le","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"f64x2_ge","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128"]],["v128"]]],[5,"v128_not","","Flips each bit of the 128-bit input vector.",null,[[["v128"]],["v128"]]],[5,"v128_and","","Performs a bitwise and of the two input 128-bit vectors,…",null,[[["v128"]],["v128"]]],[5,"v128_or","","Performs a bitwise or of the two input 128-bit vectors,…",null,[[["v128"]],["v128"]]],[5,"v128_xor","","Performs a bitwise xor of the two input 128-bit vectors,…",null,[[["v128"]],["v128"]]],[5,"v128_bitselect","","Use the bitmask in `c` to select bits from `v1` when 1 and…",null,[[["v128"]],["v128"]]],[5,"i8x16_neg","","Negates a 128-bit vectors intepreted as sixteen 8-bit…",null,[[["v128"]],["v128"]]],[5,"i8x16_any_true","","Returns 1 if any lane is nonzero or 0 if all lanes are zero.",null,[[["v128"]],["i32"]]],[5,"i8x16_all_true","","Returns 1 if all lanes are nonzero or 0 if any lane is…",null,[[["v128"]],["i32"]]],[5,"i8x16_shl","","Shifts each lane to the left by the specified number of…",null,[[["v128"],["u32"]],["v128"]]],[5,"i8x16_shr_s","","Shifts each lane to the right by the specified number of…",null,[[["v128"],["u32"]],["v128"]]],[5,"i8x16_shr_u","","Shifts each lane to the right by the specified number of…",null,[[["v128"],["u32"]],["v128"]]],[5,"i8x16_add","","Adds two 128-bit vectors as if they were two packed…",null,[[["v128"]],["v128"]]],[5,"i8x16_add_saturate_s","","Adds two 128-bit vectors as if they were two packed…",null,[[["v128"]],["v128"]]],[5,"i8x16_add_saturate_u","","Adds two 128-bit vectors as if they were two packed…",null,[[["v128"]],["v128"]]],[5,"i8x16_sub","","Subtracts two 128-bit vectors as if they were two packed…",null,[[["v128"]],["v128"]]],[5,"i8x16_sub_saturate_s","","Subtracts two 128-bit vectors as if they were two packed…",null,[[["v128"]],["v128"]]],[5,"i8x16_sub_saturate_u","","Subtracts two 128-bit vectors as if they were two packed…",null,[[["v128"]],["v128"]]],[5,"i8x16_mul","","Multiplies two 128-bit vectors as if they were two packed…",null,[[["v128"]],["v128"]]],[5,"i16x8_neg","","Negates a 128-bit vectors intepreted as eight 16-bit…",null,[[["v128"]],["v128"]]],[5,"i16x8_any_true","","Returns 1 if any lane is nonzero or 0 if all lanes are zero.",null,[[["v128"]],["i32"]]],[5,"i16x8_all_true","","Returns 1 if all lanes are nonzero or 0 if any lane is…",null,[[["v128"]],["i32"]]],[5,"i16x8_shl","","Shifts each lane to the left by the specified number of…",null,[[["v128"],["u32"]],["v128"]]],[5,"i16x8_shr_s","","Shifts each lane to the right by the specified number of…",null,[[["v128"],["u32"]],["v128"]]],[5,"i16x8_shr_u","","Shifts each lane to the right by the specified number of…",null,[[["v128"],["u32"]],["v128"]]],[5,"i16x8_add","","Adds two 128-bit vectors as if they were two packed eight…",null,[[["v128"]],["v128"]]],[5,"i16x8_add_saturate_s","","Adds two 128-bit vectors as if they were two packed eight…",null,[[["v128"]],["v128"]]],[5,"i16x8_add_saturate_u","","Adds two 128-bit vectors as if they were two packed eight…",null,[[["v128"]],["v128"]]],[5,"i16x8_sub","","Subtracts two 128-bit vectors as if they were two packed…",null,[[["v128"]],["v128"]]],[5,"i16x8_sub_saturate_s","","Subtracts two 128-bit vectors as if they were two packed…",null,[[["v128"]],["v128"]]],[5,"i16x8_sub_saturate_u","","Subtracts two 128-bit vectors as if they were two packed…",null,[[["v128"]],["v128"]]],[5,"i16x8_mul","","Multiplies two 128-bit vectors as if they were two packed…",null,[[["v128"]],["v128"]]],[5,"i32x4_neg","","Negates a 128-bit vectors intepreted as four 32-bit signed…",null,[[["v128"]],["v128"]]],[5,"i32x4_any_true","","Returns 1 if any lane is nonzero or 0 if all lanes are zero.",null,[[["v128"]],["i32"]]],[5,"i32x4_all_true","","Returns 1 if all lanes are nonzero or 0 if any lane is…",null,[[["v128"]],["i32"]]],[5,"i32x4_shl","","Shifts each lane to the left by the specified number of…",null,[[["v128"],["u32"]],["v128"]]],[5,"i32x4_shr_s","","Shifts each lane to the right by the specified number of…",null,[[["v128"],["u32"]],["v128"]]],[5,"i32x4_shr_u","","Shifts each lane to the right by the specified number of…",null,[[["v128"],["u32"]],["v128"]]],[5,"i32x4_add","","Adds two 128-bit vectors as if they were two packed four…",null,[[["v128"]],["v128"]]],[5,"i32x4_sub","","Subtracts two 128-bit vectors as if they were two packed…",null,[[["v128"]],["v128"]]],[5,"i32x4_mul","","Multiplies two 128-bit vectors as if they were two packed…",null,[[["v128"]],["v128"]]],[5,"i64x2_neg","","Negates a 128-bit vectors intepreted as two 64-bit signed…",null,[[["v128"]],["v128"]]],[5,"i64x2_any_true","","Returns 1 if any lane is nonzero or 0 if all lanes are zero.",null,[[["v128"]],["i32"]]],[5,"i64x2_all_true","","Returns 1 if all lanes are nonzero or 0 if any lane is…",null,[[["v128"]],["i32"]]],[5,"i64x2_shl","","Shifts each lane to the left by the specified number of…",null,[[["v128"],["u32"]],["v128"]]],[5,"i64x2_shr_s","","Shifts each lane to the right by the specified number of…",null,[[["v128"],["u32"]],["v128"]]],[5,"i64x2_shr_u","","Shifts each lane to the right by the specified number of…",null,[[["v128"],["u32"]],["v128"]]],[5,"i64x2_add","","Adds two 128-bit vectors as if they were two packed two…",null,[[["v128"]],["v128"]]],[5,"i64x2_sub","","Subtracts two 128-bit vectors as if they were two packed…",null,[[["v128"]],["v128"]]],[5,"f32x4_abs","","Calculates the absolute value of each lane of a 128-bit…",null,[[["v128"]],["v128"]]],[5,"f32x4_neg","","Negates each lane of a 128-bit vector interpreted as four…",null,[[["v128"]],["v128"]]],[5,"f32x4_sqrt","","Calculates the square root of each lane of a 128-bit…",null,[[["v128"]],["v128"]]],[5,"f32x4_add","","Adds pairwise lanes of two 128-bit vectors interpreted as…",null,[[["v128"]],["v128"]]],[5,"f32x4_sub","","Subtracts pairwise lanes of two 128-bit vectors…",null,[[["v128"]],["v128"]]],[5,"f32x4_mul","","Multiplies pairwise lanes of two 128-bit vectors…",null,[[["v128"]],["v128"]]],[5,"f32x4_div","","Divides pairwise lanes of two 128-bit vectors interpreted…",null,[[["v128"]],["v128"]]],[5,"f32x4_min","","Calculates the minimum of pairwise lanes of two 128-bit…",null,[[["v128"]],["v128"]]],[5,"f32x4_max","","Calculates the maximum of pairwise lanes of two 128-bit…",null,[[["v128"]],["v128"]]],[5,"f64x2_abs","","Calculates the absolute value of each lane of a 128-bit…",null,[[["v128"]],["v128"]]],[5,"f64x2_neg","","Negates each lane of a 128-bit vector interpreted as two…",null,[[["v128"]],["v128"]]],[5,"f64x2_sqrt","","Calculates the square root of each lane of a 128-bit…",null,[[["v128"]],["v128"]]],[5,"f64x2_add","","Adds pairwise lanes of two 128-bit vectors interpreted as…",null,[[["v128"]],["v128"]]],[5,"f64x2_sub","","Subtracts pairwise lanes of two 128-bit vectors…",null,[[["v128"]],["v128"]]],[5,"f64x2_mul","","Multiplies pairwise lanes of two 128-bit vectors…",null,[[["v128"]],["v128"]]],[5,"f64x2_div","","Divides pairwise lanes of two 128-bit vectors interpreted…",null,[[["v128"]],["v128"]]],[5,"f64x2_min","","Calculates the minimum of pairwise lanes of two 128-bit…",null,[[["v128"]],["v128"]]],[5,"f64x2_max","","Calculates the maximum of pairwise lanes of two 128-bit…",null,[[["v128"]],["v128"]]],[5,"i32x4_trunc_s_f32x4_sat","","Converts a 128-bit vector interpreted as four 32-bit…",null,[[["v128"]],["v128"]]],[5,"i32x4_trunc_u_f32x4_sat","","Converts a 128-bit vector interpreted as four 32-bit…",null,[[["v128"]],["v128"]]],[5,"i64x2_trunc_s_f64x2_sat","","Converts a 128-bit vector interpreted as two 64-bit…",null,[[["v128"]],["v128"]]],[5,"i64x2_trunc_u_f64x2_sat","","Converts a 128-bit vector interpreted as two 64-bit…",null,[[["v128"]],["v128"]]],[5,"f32x4_convert_i32x4_s","","Converts a 128-bit vector interpreted as four 32-bit…",null,[[["v128"]],["v128"]]],[5,"f32x4_convert_i32x4_u","","Converts a 128-bit vector interpreted as four 32-bit…",null,[[["v128"]],["v128"]]],[5,"f64x2_convert_s_i64x2","","Converts a 128-bit vector interpreted as two 64-bit signed…",null,[[["v128"]],["v128"]]],[5,"f64x2_convert_u_i64x2","","Converts a 128-bit vector interpreted as two 64-bit…",null,[[["v128"]],["v128"]]],[5,"memory_size","","Corresponding intrinsic to wasm's [`memory.size`…",null,[[["u32"]],["usize"]]],[5,"memory_grow","","Corresponding intrinsic to wasm's [`memory.grow`…",null,[[["u32"],["usize"]],["usize"]]],[5,"unreachable","","Generates the trap instruction `UNREACHABLE`",null,[[]]],[0,"mips","core::arch","Platform-specific intrinsics for the `mips` platform.",null,null],[3,"v16i8","core::arch::mips","",null,null],[3,"v8i16","","",null,null],[3,"v4i32","","",null,null],[3,"v2i64","","",null,null],[3,"v16u8","","",null,null],[3,"v8u16","","",null,null],[3,"v4u32","","",null,null],[3,"v2u64","","",null,null],[3,"v4f32","","",null,null],[3,"v2f64","","",null,null],[5,"__msa_add_a_b","","Vector Add Absolute Values.",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_add_a_h","","Vector Add Absolute Values",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_add_a_w","","Vector Add Absolute Values",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_add_a_d","","Vector Add Absolute Values",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_adds_a_b","","Signed Saturated Vector Saturated Add of Absolute Values",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_adds_a_h","","Vector Saturated Add of Absolute Values",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_adds_a_w","","Vector Saturated Add of Absolute Values",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_adds_a_d","","Vector Saturated Add of Absolute Values",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_adds_s_b","","Vector Signed Saturated Add of Signed Values",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_adds_s_h","","Vector Signed Saturated Add of Signed Values",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_adds_s_w","","Vector Signed Saturated Add of Signed Values",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_adds_s_d","","Vector Signed Saturated Add of Signed Values",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_adds_u_b","","Vector Unsigned Saturated Add of Unsigned Values",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_adds_u_h","","Vector Unsigned Saturated Add of Unsigned Values",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_adds_u_w","","Vector Unsigned Saturated Add of Unsigned Values",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_adds_u_d","","Vector Unsigned Saturated Add of Unsigned Values",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_addv_b","","Vector Add",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_addv_h","","Vector Add",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_addv_w","","Vector Add",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_addv_d","","Vector Add",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_addvi_b","","Immediate Add",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_addvi_h","","Immediate Add",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_addvi_w","","Immediate Add",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_addvi_d","","Immediate Add",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_and_v","","Vector Logical And",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_andi_b","","Immediate Logical And",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_asub_s_b","","Vector Absolute Values of Signed Subtract",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_asub_s_h","","Vector Absolute Values of Signed Subtract",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_asub_s_w","","Vector Absolute Values of Signed Subtract",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_asub_s_d","","Vector Absolute Values of Signed Subtract",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_asub_u_b","","Vector Absolute Values of Unsigned Subtract",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_asub_u_h","","Vector Absolute Values of Unsigned Subtract",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_asub_u_w","","Vector Absolute Values of Unsigned Subtract",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_asub_u_d","","Vector Absolute Values of Unsigned Subtract",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_ave_s_b","","Vector Signed Average",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_ave_s_h","","Vector Signed Average",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_ave_s_w","","Vector Signed Average",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_ave_s_d","","Vector Signed Average",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_ave_u_b","","Vector Unsigned Average",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_ave_u_h","","Vector Unsigned Average",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_ave_u_w","","Vector Unsigned Average",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_ave_u_d","","Vector Unsigned Average",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_aver_s_b","","Vector Signed Average Rounded",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_aver_s_h","","Vector Signed Average Rounded",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_aver_s_w","","Vector Signed Average Rounded",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_aver_s_d","","Vector Signed Average Rounded",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_aver_u_b","","Vector Unsigned Average Rounded",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_aver_u_h","","Vector Unsigned Average Rounded",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_aver_u_w","","Vector Unsigned Average Rounded",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_aver_u_d","","Vector Unsigned Average Rounded",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_bclr_b","","Vector Bit Clear",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_bclr_h","","Vector Bit Clear",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_bclr_w","","Vector Bit Clear",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_bclr_d","","Vector Bit Clear",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_bclri_b","","Immediate Bit Clear",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_bclri_h","","Immediate Bit Clear",null,[[["v8u16"],["i32"]],["v8u16"]]],[5,"__msa_bclri_w","","Immediate Bit Clear",null,[[["v4u32"],["i32"]],["v4u32"]]],[5,"__msa_bclri_d","","Immediate Bit Clear",null,[[["i32"],["v2u64"]],["v2u64"]]],[5,"__msa_binsl_b","","Vector Bit Insert Left",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_binsl_h","","Vector Bit Insert Left",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_binsl_w","","Vector Bit Insert Left",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_binsl_d","","Vector Bit Insert Left",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_binsli_b","","Immediate Bit Insert Left",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_binsli_h","","Immediate Bit Insert Left",null,[[["v8u16"],["i32"]],["v8u16"]]],[5,"__msa_binsli_w","","Immediate Bit Insert Left",null,[[["v4u32"],["i32"]],["v4u32"]]],[5,"__msa_binsli_d","","Immediate Bit Insert Left",null,[[["i32"],["v2u64"]],["v2u64"]]],[5,"__msa_binsr_b","","Vector Bit Insert Right",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_binsr_h","","Vector Bit Insert Right",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_binsr_w","","Vector Bit Insert Right",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_binsr_d","","Vector Bit Insert Right",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_binsri_b","","Immediate Bit Insert Right",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_binsri_h","","Immediate Bit Insert Right",null,[[["v8u16"],["i32"]],["v8u16"]]],[5,"__msa_binsri_w","","Immediate Bit Insert Right",null,[[["v4u32"],["i32"]],["v4u32"]]],[5,"__msa_binsri_d","","Immediate Bit Insert Right",null,[[["i32"],["v2u64"]],["v2u64"]]],[5,"__msa_bmnz_v","","Vector Bit Move If Not Zero",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_bmnzi_b","","Immediate Bit Move If Not Zero",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_bmz_v","","Vector Bit Move If Zero",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_bmzi_b","","Immediate Bit Move If Zero",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_bneg_b","","Vector Bit Negate",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_bneg_h","","Vector Bit Negate",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_bneg_w","","Vector Bit Negate",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_bneg_d","","Vector Bit Negate",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_bnegi_b","","Immediate Bit Negate",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_bnegi_h","","Immediate Bit Negate",null,[[["v8u16"],["i32"]],["v8u16"]]],[5,"__msa_bnegi_w","","Immediate Bit Negate",null,[[["v4u32"],["i32"]],["v4u32"]]],[5,"__msa_bnegi_d","","Immediate Bit Negate",null,[[["i32"],["v2u64"]],["v2u64"]]],[5,"__msa_bnz_b","","Immediate Branch If All Elements Are Not Zero",null,[[["v16u8"]],["i32"]]],[5,"__msa_bnz_h","","Immediate Branch If All Elements Are Not Zero",null,[[["v8u16"]],["i32"]]],[5,"__msa_bnz_w","","Immediate Branch If All Elements Are Not Zero",null,[[["v4u32"]],["i32"]]],[5,"__msa_bnz_d","","Immediate Branch If All Elements Are Not Zero",null,[[["v2u64"]],["i32"]]],[5,"__msa_bnz_v","","Immediate Branch If Not Zero (At Least One Element of Any…",null,[[["v16u8"]],["i32"]]],[5,"__msa_bsel_v","","Vector Bit Select",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_bseli_b","","Immediate Bit Select",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_bset_b","","Vector Bit Set",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_bset_h","","Vector Bit Set",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_bset_w","","Vector Bit Set",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_bset_d","","Vector Bit Set",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_bseti_b","","Immediate Bit Set",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_bseti_h","","Immediate Bit Set",null,[[["v8u16"],["i32"]],["v8u16"]]],[5,"__msa_bseti_w","","Immediate Bit Set",null,[[["v4u32"],["i32"]],["v4u32"]]],[5,"__msa_bseti_d","","Immediate Bit Set",null,[[["i32"],["v2u64"]],["v2u64"]]],[5,"__msa_bz_b","","Immediate Branch If At Least One Element Is Zero",null,[[["v16u8"]],["i32"]]],[5,"__msa_bz_h","","Immediate Branch If At Least One Element Is Zero",null,[[["v8u16"]],["i32"]]],[5,"__msa_bz_w","","Immediate Branch If At Least One Element Is Zero",null,[[["v4u32"]],["i32"]]],[5,"__msa_bz_d","","Immediate Branch If At Least One Element Is Zero",null,[[["v2u64"]],["i32"]]],[5,"__msa_bz_v","","Immediate Branch If Zero (All Elements of Any Format Are…",null,[[["v16u8"]],["i32"]]],[5,"__msa_ceq_b","","Vector Compare Equal",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_ceq_h","","Vector Compare Equal",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_ceq_w","","Vector Compare Equal",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_ceq_d","","Vector Compare Equal",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_ceqi_b","","Immediate Compare Equal",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_ceqi_h","","Immediate Compare Equal",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_ceqi_w","","Immediate Compare Equal",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_ceqi_d","","Immediate Compare Equal",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_cfcmsa","","GPR Copy from MSA Control Register",null,[[["i32"]],["i32"]]],[5,"__msa_cle_s_b","","Vector Compare Signed Less Than or Equal",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_cle_s_h","","Vector Compare Signed Less Than or Equal",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_cle_s_w","","Vector Compare Signed Less Than or Equal",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_cle_s_d","","Vector Compare Signed Less Than or Equal",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_cle_u_b","","Vector Compare Unsigned Less Than or Equal",null,[[["v16u8"]],["v16i8"]]],[5,"__msa_cle_u_h","","Vector Compare Unsigned Less Than or Equal",null,[[["v8u16"]],["v8i16"]]],[5,"__msa_cle_u_w","","Vector Compare Unsigned Less Than or Equal",null,[[["v4u32"]],["v4i32"]]],[5,"__msa_cle_u_d","","Vector Compare Unsigned Less Than or Equal",null,[[["v2u64"]],["v2i64"]]],[5,"__msa_clei_s_b","","Immediate Compare Signed Less Than or Equal",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_clei_s_h","","Immediate Compare Signed Less Than or Equal",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_clei_s_w","","Immediate Compare Signed Less Than or Equal",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_clei_s_d","","Immediate Compare Signed Less Than or Equal",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_clei_u_b","","Immediate Compare Unsigned Less Than or Equal",null,[[["i32"],["v16u8"]],["v16i8"]]],[5,"__msa_clei_u_h","","Immediate Compare Unsigned Less Than or Equal",null,[[["v8u16"],["i32"]],["v8i16"]]],[5,"__msa_clei_u_w","","Immediate Compare Unsigned Less Than or Equal",null,[[["v4u32"],["i32"]],["v4i32"]]],[5,"__msa_clei_u_d","","Immediate Compare Unsigned Less Than or Equal",null,[[["i32"],["v2u64"]],["v2i64"]]],[5,"__msa_clt_s_b","","Vector Compare Signed Less Than",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_clt_s_h","","Vector Compare Signed Less Than",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_clt_s_w","","Vector Compare Signed Less Than",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_clt_s_d","","Vector Compare Signed Less Than",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_clt_u_b","","Vector Compare Unsigned Less Than",null,[[["v16u8"]],["v16i8"]]],[5,"__msa_clt_u_h","","Vector Compare Unsigned Less Than",null,[[["v8u16"]],["v8i16"]]],[5,"__msa_clt_u_w","","Vector Compare Unsigned Less Than",null,[[["v4u32"]],["v4i32"]]],[5,"__msa_clt_u_d","","Vector Compare Unsigned Less Than",null,[[["v2u64"]],["v2i64"]]],[5,"__msa_clti_s_b","","Immediate Compare Signed Less Than",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_clti_s_h","","Immediate Compare Signed Less Than",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_clti_s_w","","Immediate Compare Signed Less Than",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_clti_s_d","","Immediate Compare Signed Less Than",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_clti_u_b","","Immediate Compare Unsigned Less Than",null,[[["i32"],["v16u8"]],["v16i8"]]],[5,"__msa_clti_u_h","","Immediate Compare Unsigned Less Than",null,[[["v8u16"],["i32"]],["v8i16"]]],[5,"__msa_clti_u_w","","Immediate Compare Unsigned Less Than",null,[[["v4u32"],["i32"]],["v4i32"]]],[5,"__msa_clti_u_d","","Immediate Compare Unsigned Less Than",null,[[["i32"],["v2u64"]],["v2i64"]]],[5,"__msa_copy_s_b","","Element Copy to GPR Signed",null,[[["v16i8"],["i32"]],["i32"]]],[5,"__msa_copy_s_h","","Element Copy to GPR Signed",null,[[["v8i16"],["i32"]],["i32"]]],[5,"__msa_copy_s_w","","Element Copy to GPR Signed",null,[[["v4i32"],["i32"]],["i32"]]],[5,"__msa_copy_s_d","","Element Copy to GPR Signed",null,[[["i32"],["v2i64"]],["i64"]]],[5,"__msa_copy_u_b","","Element Copy to GPR Unsigned",null,[[["v16i8"],["i32"]],["u32"]]],[5,"__msa_copy_u_h","","Element Copy to GPR Unsigned",null,[[["v8i16"],["i32"]],["u32"]]],[5,"__msa_copy_u_w","","Element Copy to GPR Unsigned",null,[[["v4i32"],["i32"]],["u32"]]],[5,"__msa_copy_u_d","","Element Copy to GPR Unsigned",null,[[["i32"],["v2i64"]],["u64"]]],[5,"__msa_ctcmsa","","GPR Copy to MSA Control Register",null,[[["i32"]]]],[5,"__msa_div_s_b","","Vector Signed Divide",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_div_s_h","","Vector Signed Divide",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_div_s_w","","Vector Signed Divide",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_div_s_d","","Vector Signed Divide",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_div_u_b","","Vector Unsigned Divide",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_div_u_h","","Vector Unsigned Divide",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_div_u_w","","Vector Unsigned Divide",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_div_u_d","","Vector Unsigned Divide",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_dotp_s_h","","Vector Signed Dot Product",null,[[["v16i8"]],["v8i16"]]],[5,"__msa_dotp_s_w","","Vector Signed Dot Product",null,[[["v8i16"]],["v4i32"]]],[5,"__msa_dotp_s_d","","Vector Signed Dot Product",null,[[["v4i32"]],["v2i64"]]],[5,"__msa_dotp_u_h","","Vector Unsigned Dot Product",null,[[["v16u8"]],["v8u16"]]],[5,"__msa_dotp_u_w","","Vector Unsigned Dot Product",null,[[["v8u16"]],["v4u32"]]],[5,"__msa_dotp_u_d","","Vector Unsigned Dot Product",null,[[["v4u32"]],["v2u64"]]],[5,"__msa_dpadd_s_h","","Vector Signed Dot Product and Add",null,[[["v8i16"],["v16i8"]],["v8i16"]]],[5,"__msa_dpadd_s_w","","Vector Signed Dot Product and Add",null,[[["v8i16"],["v4i32"]],["v4i32"]]],[5,"__msa_dpadd_s_d","","Vector Signed Dot Product and Add",null,[[["v4i32"],["v2i64"]],["v2i64"]]],[5,"__msa_dpadd_u_h","","Vector Unsigned Dot Product and Add",null,[[["v8u16"],["v16u8"]],["v8u16"]]],[5,"__msa_dpadd_u_w","","Vector Unsigned Dot Product and Add",null,[[["v4u32"],["v8u16"]],["v4u32"]]],[5,"__msa_dpadd_u_d","","Vector Unsigned Dot Product and Add",null,[[["v4u32"],["v2u64"]],["v2u64"]]],[5,"__msa_dpsub_s_h","","Vector Signed Dot Product and Add",null,[[["v8i16"],["v16i8"]],["v8i16"]]],[5,"__msa_dpsub_s_w","","Vector Signed Dot Product and Add",null,[[["v8i16"],["v4i32"]],["v4i32"]]],[5,"__msa_dpsub_s_d","","Vector Signed Dot Product and Add",null,[[["v4i32"],["v2i64"]],["v2i64"]]],[5,"__msa_dpsub_u_h","","Vector Unsigned Dot Product and Add",null,[[["v8i16"],["v16u8"]],["v8i16"]]],[5,"__msa_dpsub_u_w","","Vector Unsigned Dot Product and Add",null,[[["v4i32"],["v8u16"]],["v4i32"]]],[5,"__msa_dpsub_u_d","","Vector Unsigned Dot Product and Add",null,[[["v4u32"],["v2i64"]],["v2i64"]]],[5,"__msa_fadd_w","","Vector Floating-Point Addition",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fadd_d","","Vector Floating-Point Addition",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fcaf_w","","Vector Floating-Point Quiet Compare Always False",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fcaf_d","","Vector Floating-Point Quiet Compare Always False",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fceq_w","","Vector Floating-Point Quiet Compare Equal",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fceq_d","","Vector Floating-Point Quiet Compare Equal",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fclass_w","","Vector Floating-Point Class Mask",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fclass_d","","Vector Floating-Point Class Mask",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fcle_w","","Vector Floating-Point Quiet Compare Less or Equal",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fcle_d","","Vector Floating-Point Quiet Compare Less or Equal",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fclt_w","","Vector Floating-Point Quiet Compare Less Than",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fclt_d","","Vector Floating-Point Quiet Compare Less Than",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fcne_w","","Vector Floating-Point Quiet Compare Not Equal",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fcne_d","","Vector Floating-Point Quiet Compare Not Equal",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fcor_w","","Vector Floating-Point Quiet Compare Ordered",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fcor_d","","Vector Floating-Point Quiet Compare Ordered",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fcueq_w","","Vector Floating-Point Quiet Compare Unordered or Equal",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fcueq_d","","Vector Floating-Point Quiet Compare Unordered or Equal",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fcule_w","","Vector Floating-Point Quiet Compare Unordered or Less or…",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fcule_d","","Vector Floating-Point Quiet Compare Unordered or Less or…",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fcult_w","","Vector Floating-Point Quiet Compare Unordered or Less Than",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fcult_d","","Vector Floating-Point Quiet Compare Unordered or Less Than",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fcun_w","","Vector Floating-Point Quiet Compare Unordered",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fcun_d","","Vector Floating-Point Quiet Compare Unordered",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fcune_w","","Vector Floating-Point Quiet Compare Unordered or Not Equal",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fcune_d","","Vector Floating-Point Quiet Compare Unordered or Not Equal",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fdiv_w","","Vector Floating-Point Division",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fdiv_d","","Vector Floating-Point Division",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fexdo_w","","Vector Floating-Point Down-Convert Interchange Format",null,[[["v2f64"]],["v4f32"]]],[5,"__msa_fexp2_w","","Vector Floating-Point Down-Convert Interchange Format",null,[[["v4f32"],["v4i32"]],["v4f32"]]],[5,"__msa_fexp2_d","","Vector Floating-Point Down-Convert Interchange Format",null,[[["v2f64"],["v2i64"]],["v2f64"]]],[5,"__msa_fexupl_d","","Vector Floating-Point Up-Convert Interchange Format Left",null,[[["v4f32"]],["v2f64"]]],[5,"__msa_fexupr_d","","Vector Floating-Point Up-Convert Interchange Format Left",null,[[["v4f32"]],["v2f64"]]],[5,"__msa_ffint_s_w","","Vector Floating-Point Round and Convert from Signed Integer",null,[[["v4i32"]],["v4f32"]]],[5,"__msa_ffint_s_d","","Vector Floating-Point Round and Convert from Signed Integer",null,[[["v2i64"]],["v2f64"]]],[5,"__msa_ffint_u_w","","Vector Floating-Point Round and Convert from Unsigned…",null,[[["v4u32"]],["v4f32"]]],[5,"__msa_ffint_u_d","","Vector Floating-Point Round and Convert from Unsigned…",null,[[["v2u64"]],["v2f64"]]],[5,"__msa_ffql_w","","Vector Floating-Point Convert from Fixed-Point Left",null,[[["v8i16"]],["v4f32"]]],[5,"__msa_ffql_d","","Vector Floating-Point Convert from Fixed-Point Left",null,[[["v4i32"]],["v2f64"]]],[5,"__msa_ffqr_w","","Vector Floating-Point Convert from Fixed-Point Left",null,[[["v8i16"]],["v4f32"]]],[5,"__msa_ffqr_d","","Vector Floating-Point Convert from Fixed-Point Left",null,[[["v4i32"]],["v2f64"]]],[5,"__msa_fill_b","","Vector Fill from GPR",null,[[["i32"]],["v16i8"]]],[5,"__msa_fill_h","","Vector Fill from GPR",null,[[["i32"]],["v8i16"]]],[5,"__msa_fill_w","","Vector Fill from GPR",null,[[["i32"]],["v4i32"]]],[5,"__msa_fill_d","","Vector Fill from GPR",null,[[["i64"]],["v2i64"]]],[5,"__msa_flog2_w","","Vector Floating-Point Base 2 Logarithm",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_flog2_d","","Vector Floating-Point Base 2 Logarithm",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fmadd_w","","Vector Floating-Point Multiply-Add",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fmadd_d","","Vector Floating-Point Multiply-Add",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fmax_w","","Vector Floating-Point Maximum",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fmax_d","","Vector Floating-Point Maximum",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fmax_a_w","","Vector Floating-Point Maximum Based on Absolute Values",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fmax_a_d","","Vector Floating-Point Maximum Based on Absolute Values",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fmin_w","","Vector Floating-Point Minimum",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fmin_d","","Vector Floating-Point Minimum",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fmin_a_w","","Vector Floating-Point Minimum Based on Absolute Values",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fmin_a_d","","Vector Floating-Point Minimum Based on Absolute Values",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fmsub_w","","Vector Floating-Point Multiply-Sub",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fmsub_d","","Vector Floating-Point Multiply-Sub",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fmul_w","","Vector Floating-Point Multiplication",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fmul_d","","Vector Floating-Point Multiplication",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_frint_w","","Vector Floating-Point Round to Integer",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_frint_d","","Vector Floating-Point Round to Integer",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_frcp_w","","Vector Approximate Floating-Point Reciprocal",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_frcp_d","","Vector Approximate Floating-Point Reciprocal",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_frsqrt_w","","Vector Approximate Floating-Point Reciprocal of Square Root",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_frsqrt_d","","Vector Approximate Floating-Point Reciprocal of Square Root",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fsaf_w","","Vector Floating-Point Signaling Compare Always False",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fsaf_d","","Vector Floating-Point Signaling Compare Always False",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fseq_w","","Vector Floating-Point Signaling Compare Equal",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fseq_d","","Vector Floating-Point Signaling Compare Equal",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fsle_w","","Vector Floating-Point Signaling Compare Less or Equal",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fsle_d","","Vector Floating-Point Signaling Compare Less or Equal",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fslt_w","","Vector Floating-Point Signaling Compare Less Than",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fslt_d","","Vector Floating-Point Signaling Compare Less Than",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fsne_w","","Vector Floating-Point Signaling Compare Not Equal",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fsne_d","","Vector Floating-Point Signaling Compare Not Equal",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fsor_w","","Vector Floating-Point Signaling Compare Ordered",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fsor_d","","Vector Floating-Point Signaling Compare Ordered",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fsqrt_w","","Vector Floating-Point Square Root",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fsqrt_d","","Vector Floating-Point Square Root",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fsub_w","","Vector Floating-Point Subtraction",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fsub_d","","Vector Floating-Point Subtraction",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fsueq_w","","Vector Floating-Point Signaling Compare Ordered",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fsueq_d","","Vector Floating-Point Signaling Compare Ordered",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fsule_w","","Vector Floating-Point Signaling Compare Unordered or Less…",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fsule_d","","Vector Floating-Point Signaling Compare Unordered or Less…",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fsult_w","","Vector Floating-Point Signaling Compare Unordered or Less…",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fsult_d","","Vector Floating-Point Signaling Compare Unordered or Less…",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fsun_w","","Vector Floating-Point Signaling Compare Unordered",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fsun_d","","Vector Floating-Point Signaling Compare Unordered",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fsune_w","","Vector Floating-Point Signaling Compare Unordered or Not…",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fsune_d","","Vector Floating-Point Signaling Compare Unordered or Not…",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_ftint_s_w","","Vector Floating-Point Convert to Signed Integer",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_ftint_s_d","","Vector Floating-Point Convert to Signed Integer",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_ftint_u_w","","Vector Floating-Point Convert to Unsigned Integer",null,[[["v4f32"]],["v4u32"]]],[5,"__msa_ftint_u_d","","Vector Floating-Point Convert to Unsigned Integer",null,[[["v2f64"]],["v2u64"]]],[5,"__msa_ftq_h","","Vector Floating-Point Convert to Fixed-Point",null,[[["v4f32"]],["v8i16"]]],[5,"__msa_ftq_w","","Vector Floating-Point Convert to Fixed-Point",null,[[["v2f64"]],["v4i32"]]],[5,"__msa_ftrunc_s_w","","Vector Floating-Point Truncate and Convert to Signed Integer",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_ftrunc_s_d","","Vector Floating-Point Truncate and Convert to Signed Integer",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_ftrunc_u_w","","Vector Floating-Point Truncate and Convert to Unsigned…",null,[[["v4f32"]],["v4u32"]]],[5,"__msa_ftrunc_u_d","","Vector Floating-Point Truncate and Convert to Unsigned…",null,[[["v2f64"]],["v2u64"]]],[5,"__msa_hadd_s_h","","Vector Signed Horizontal Add",null,[[["v16i8"]],["v8i16"]]],[5,"__msa_hadd_s_w","","Vector Signed Horizontal Add",null,[[["v8i16"]],["v4i32"]]],[5,"__msa_hadd_s_d","","Vector Signed Horizontal Add",null,[[["v4i32"]],["v2i64"]]],[5,"__msa_hadd_u_h","","Vector Unsigned Horizontal Add",null,[[["v16u8"]],["v8u16"]]],[5,"__msa_hadd_u_w","","Vector Unsigned Horizontal Add",null,[[["v8u16"]],["v4u32"]]],[5,"__msa_hadd_u_d","","Vector Unsigned Horizontal Add",null,[[["v4u32"]],["v2u64"]]],[5,"__msa_hsub_s_h","","Vector Signed Horizontal Subtract",null,[[["v16i8"]],["v8i16"]]],[5,"__msa_hsub_s_w","","Vector Signed Horizontal Subtract",null,[[["v8i16"]],["v4i32"]]],[5,"__msa_hsub_s_d","","Vector Signed Horizontal Subtract",null,[[["v4i32"]],["v2i64"]]],[5,"__msa_hsub_u_h","","Vector Unsigned Horizontal Subtract",null,[[["v16u8"]],["v8i16"]]],[5,"__msa_hsub_u_w","","Vector Unsigned Horizontal Subtract",null,[[["v8u16"]],["v4i32"]]],[5,"__msa_hsub_u_d","","Vector Unsigned Horizontal Subtract",null,[[["v4u32"]],["v2i64"]]],[5,"__msa_ilvev_b","","Vector Interleave Even",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_ilvev_h","","Vector Interleave Even",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_ilvev_w","","Vector Interleave Even",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_ilvev_d","","Vector Interleave Even",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_ilvl_b","","Vector Interleave Left",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_ilvl_h","","Vector Interleave Left",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_ilvl_w","","Vector Interleave Left",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_ilvl_d","","Vector Interleave Left",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_ilvod_b","","Vector Interleave Odd",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_ilvod_h","","Vector Interleave Odd",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_ilvod_w","","Vector Interleave Odd",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_ilvod_d","","Vector Interleave Odd",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_ilvr_b","","Vector Interleave Right",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_ilvr_h","","Vector Interleave Right",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_ilvr_w","","Vector Interleave Right",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_ilvr_d","","Vector Interleave Right",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_insert_b","","GPR Insert Element",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_insert_h","","GPR Insert Element",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_insert_w","","GPR Insert Element",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_insert_d","","GPR Insert Element",null,[[["i32"],["i64"],["v2i64"]],["v2i64"]]],[5,"__msa_insve_b","","Element Insert Element",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_insve_h","","Element Insert Element",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_insve_w","","Element Insert Element",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_insve_d","","Element Insert Element",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_ld_b","","Vector Load",null,[[["i32"]],["v16i8"]]],[5,"__msa_ld_h","","Vector Load",null,[[["i32"]],["v8i16"]]],[5,"__msa_ld_w","","Vector Load",null,[[["i32"]],["v4i32"]]],[5,"__msa_ld_d","","Vector Load",null,[[["i32"]],["v2i64"]]],[5,"__msa_ldi_b","","Immediate Load",null,[[["i32"]],["v16i8"]]],[5,"__msa_ldi_h","","Immediate Load",null,[[["i32"]],["v8i16"]]],[5,"__msa_ldi_w","","Immediate Load",null,[[["i32"]],["v4i32"]]],[5,"__msa_ldi_d","","Immediate Load",null,[[["i32"]],["v2i64"]]],[5,"__msa_madd_q_h","","Vector Fixed-Point Multiply and Add",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_madd_q_w","","Vector Fixed-Point Multiply and Add",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_maddr_q_h","","Vector Fixed-Point Multiply and Add Rounded",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_maddr_q_w","","Vector Fixed-Point Multiply and Add Rounded",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_maddv_b","","Vector Multiply and Add",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_maddv_h","","Vector Multiply and Add",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_maddv_w","","Vector Multiply and Add",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_maddv_d","","Vector Multiply and Add",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_max_a_b","","Vector Maximum Based on Absolute Values",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_max_a_h","","Vector Maximum Based on Absolute Values",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_max_a_w","","Vector Maximum Based on Absolute Values",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_max_a_d","","Vector Maximum Based on Absolute Values",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_max_s_b","","Vector Signed Maximum",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_max_s_h","","Vector Signed Maximum",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_max_s_w","","Vector Signed Maximum",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_max_s_d","","Vector Signed Maximum",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_max_u_b","","Vector Unsigned Maximum",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_max_u_h","","Vector Unsigned Maximum",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_max_u_w","","Vector Unsigned Maximum",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_max_u_d","","Vector Unsigned Maximum",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_maxi_s_b","","Immediate Signed Maximum",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_maxi_s_h","","Immediate Signed Maximum",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_maxi_s_w","","Immediate Signed Maximum",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_maxi_s_d","","Immediate Signed Maximum",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_maxi_u_b","","Immediate Unsigned Maximum",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_maxi_u_h","","Immediate Unsigned Maximum",null,[[["v8u16"],["i32"]],["v8u16"]]],[5,"__msa_maxi_u_w","","Immediate Unsigned Maximum",null,[[["v4u32"],["i32"]],["v4u32"]]],[5,"__msa_maxi_u_d","","Immediate Unsigned Maximum",null,[[["i32"],["v2u64"]],["v2u64"]]],[5,"__msa_min_a_b","","Vector Minimum Based on Absolute Value",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_min_a_h","","Vector Minimum Based on Absolute Value",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_min_a_w","","Vector Minimum Based on Absolute Value",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_min_a_d","","Vector Minimum Based on Absolute Value",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_min_s_b","","Vector Signed Minimum",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_min_s_h","","Vector Signed Minimum",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_min_s_w","","Vector Signed Minimum",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_min_s_d","","Vector Signed Minimum",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_mini_s_b","","Immediate Signed Minimum",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_mini_s_h","","Immediate Signed Minimum",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_mini_s_w","","Immediate Signed Minimum",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_mini_s_d","","Immediate Signed Minimum",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_min_u_b","","Vector Unsigned Minimum",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_min_u_h","","Vector Unsigned Minimum",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_min_u_w","","Vector Unsigned Minimum",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_min_u_d","","Vector Unsigned Minimum",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_mini_u_b","","Immediate Unsigned Minimum",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_mini_u_h","","Immediate Unsigned Minimum",null,[[["v8u16"],["i32"]],["v8u16"]]],[5,"__msa_mini_u_w","","Immediate Unsigned Minimum",null,[[["v4u32"],["i32"]],["v4u32"]]],[5,"__msa_mini_u_d","","Immediate Unsigned Minimum",null,[[["i32"],["v2u64"]],["v2u64"]]],[5,"__msa_mod_s_b","","Vector Signed Modulo",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_mod_s_h","","Vector Signed Modulo",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_mod_s_w","","Vector Signed Modulo",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_mod_s_d","","Vector Signed Modulo",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_mod_u_b","","Vector Unsigned Modulo",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_mod_u_h","","Vector Unsigned Modulo",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_mod_u_w","","Vector Unsigned Modulo",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_mod_u_d","","Vector Unsigned Modulo",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_move_v","","Vector Move",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_msub_q_h","","Vector Fixed-Point Multiply and Subtract",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_msub_q_w","","Vector Fixed-Point Multiply and Subtract",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_msubr_q_h","","Vector Fixed-Point Multiply and Subtract Rounded",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_msubr_q_w","","Vector Fixed-Point Multiply and Subtract Rounded",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_msubv_b","","Vector Multiply and Subtract",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_msubv_h","","Vector Multiply and Subtract",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_msubv_w","","Vector Multiply and Subtract",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_msubv_d","","Vector Multiply and Subtract",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_mul_q_h","","Vector Fixed-Point Multiply",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_mul_q_w","","Vector Fixed-Point Multiply",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_mulr_q_h","","Vector Fixed-Point Multiply Rounded",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_mulr_q_w","","Vector Fixed-Point Multiply Rounded",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_mulv_b","","Vector Multiply",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_mulv_h","","Vector Multiply",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_mulv_w","","Vector Multiply",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_mulv_d","","Vector Multiply",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_nloc_b","","Vector Leading Ones Count",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_nloc_h","","Vector Leading Ones Count",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_nloc_w","","Vector Leading Ones Count",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_nloc_d","","Vector Leading Ones Count",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_nlzc_b","","Vector Leading Zeros Count",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_nlzc_h","","Vector Leading Zeros Count",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_nlzc_w","","Vector Leading Zeros Count",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_nlzc_d","","Vector Leading Zeros Count",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_nor_v","","Vector Logical Negated Or",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_nori_b","","Immediate Logical Negated Or",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_or_v","","Vector Logical Or",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_ori_b","","Immediate Logical Or",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_pckev_b","","Vector Pack Even",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_pckev_h","","Vector Pack Even",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_pckev_w","","Vector Pack Even",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_pckev_d","","Vector Pack Even",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_pckod_b","","Vector Pack Odd",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_pckod_h","","Vector Pack Odd",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_pckod_w","","Vector Pack Odd",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_pckod_d","","Vector Pack Odd",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_pcnt_b","","Vector Population Count",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_pcnt_h","","Vector Population Count",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_pcnt_w","","Vector Population Count",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_pcnt_d","","Vector Population Count",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_sat_s_b","","Immediate Signed Saturate",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_sat_s_h","","Immediate Signed Saturate",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_sat_s_w","","Immediate Signed Saturate",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_sat_s_d","","Immediate Signed Saturate",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_sat_u_b","","Immediate Unsigned Saturate",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_sat_u_h","","Immediate Unsigned Saturate",null,[[["v8u16"],["i32"]],["v8u16"]]],[5,"__msa_sat_u_w","","Immediate Unsigned Saturate",null,[[["v4u32"],["i32"]],["v4u32"]]],[5,"__msa_sat_u_d","","Immediate Unsigned Saturate",null,[[["i32"],["v2u64"]],["v2u64"]]],[5,"__msa_shf_b","","Immediate Set Shuffle Elements",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_shf_h","","Immediate Set Shuffle Elements",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_shf_w","","Immediate Set Shuffle Elements",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_sld_b","","GPR Columns Slide",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_sld_h","","GPR Columns Slide",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_sld_w","","GPR Columns Slide",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_sld_d","","GPR Columns Slide",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_sldi_b","","Immediate Columns Slide",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_sldi_h","","Immediate Columns Slide",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_sldi_w","","Immediate Columns Slide",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_sldi_d","","Immediate Columns Slide",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_sll_b","","Vector Shift Left",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_sll_h","","Vector Shift Left",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_sll_w","","Vector Shift Left",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_sll_d","","Vector Shift Left",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_slli_b","","Immediate Shift Left",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_slli_h","","Immediate Shift Left",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_slli_w","","Immediate Shift Left",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_slli_d","","Immediate Shift Left",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_splat_b","","GPR Element Splat",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_splat_h","","GPR Element Splat",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_splat_w","","GPR Element Splat",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_splat_d","","GPR Element Splat",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_splati_b","","Immediate Element Splat",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_splati_h","","Immediate Element Splat",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_splati_w","","Immediate Element Splat",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_splati_d","","Immediate Element Splat",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_sra_b","","Vector Shift Right Arithmetic",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_sra_h","","Vector Shift Right Arithmetic",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_sra_w","","Vector Shift Right Arithmetic",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_sra_d","","Vector Shift Right Arithmetic",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_srai_b","","Immediate Shift Right Arithmetic",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_srai_h","","Immediate Shift Right Arithmetic",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_srai_w","","Immediate Shift Right Arithmetic",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_srai_d","","Immediate Shift Right Arithmetic",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_srar_b","","Vector Shift Right Arithmetic Rounded",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_srar_h","","Vector Shift Right Arithmetic Rounded",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_srar_w","","Vector Shift Right Arithmetic Rounded",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_srar_d","","Vector Shift Right Arithmetic Rounded",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_srari_b","","Immediate Shift Right Arithmetic Rounded",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_srari_h","","Immediate Shift Right Arithmetic Rounded",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_srari_w","","Immediate Shift Right Arithmetic Rounded",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_srari_d","","Immediate Shift Right Arithmetic Rounded",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_srl_b","","Vector Shift Right Logical",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_srl_h","","Vector Shift Right Logical",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_srl_w","","Vector Shift Right Logical",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_srl_d","","Vector Shift Right Logical",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_srli_b","","Immediate Shift Right Logical",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_srli_h","","Immediate Shift Right Logical",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_srli_w","","Immediate Shift Right Logical",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_srli_d","","Immediate Shift Right Logical",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_srlr_b","","Vector Shift Right Logical Rounded",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_srlr_h","","Vector Shift Right Logical Rounded",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_srlr_w","","Vector Shift Right Logical Rounded",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_srlr_d","","Vector Shift Right Logical Rounded",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_srlri_b","","Immediate Shift Right Logical Rounded",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_srlri_h","","Immediate Shift Right Logical Rounded",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_srlri_w","","Immediate Shift Right Logical Rounded",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_srlri_d","","Immediate Shift Right Logical Rounded",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_st_b","","Vector Store",null,[[["v16i8"],["i32"]]]],[5,"__msa_st_h","","Vector Store",null,[[["v8i16"],["i32"]]]],[5,"__msa_st_w","","Vector Store",null,[[["v4i32"],["i32"]]]],[5,"__msa_st_d","","Vector Store",null,[[["i32"],["v2i64"]]]],[5,"__msa_subs_s_b","","Vector Signed Saturated Subtract of Signed Values",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_subs_s_h","","Vector Signed Saturated Subtract of Signed Values",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_subs_s_w","","Vector Signed Saturated Subtract of Signed Values",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_subs_s_d","","Vector Signed Saturated Subtract of Signed Values",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_subs_u_b","","Vector Unsigned Saturated Subtract of Unsigned Values",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_subs_u_h","","Vector Unsigned Saturated Subtract of Unsigned Values",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_subs_u_w","","Vector Unsigned Saturated Subtract of Unsigned Values",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_subs_u_d","","Vector Unsigned Saturated Subtract of Unsigned Values",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_subsus_u_b","","Vector Unsigned Saturated Subtract of Signed from Unsigned",null,[[["v16i8"],["v16u8"]],["v16u8"]]],[5,"__msa_subsus_u_h","","Vector Unsigned Saturated Subtract of Signed from Unsigned",null,[[["v8i16"],["v8u16"]],["v8u16"]]],[5,"__msa_subsus_u_w","","Vector Unsigned Saturated Subtract of Signed from Unsigned",null,[[["v4u32"],["v4i32"]],["v4u32"]]],[5,"__msa_subsus_u_d","","Vector Unsigned Saturated Subtract of Signed from Unsigned",null,[[["v2i64"],["v2u64"]],["v2u64"]]],[5,"__msa_subsuu_s_b","","Vector Signed Saturated Subtract of Unsigned Values",null,[[["v16u8"]],["v16i8"]]],[5,"__msa_subsuu_s_h","","Vector Signed Saturated Subtract of Unsigned Values",null,[[["v8u16"]],["v8i16"]]],[5,"__msa_subsuu_s_w","","Vector Signed Saturated Subtract of Unsigned Values",null,[[["v4u32"]],["v4i32"]]],[5,"__msa_subsuu_s_d","","Vector Signed Saturated Subtract of Unsigned Values",null,[[["v2u64"]],["v2i64"]]],[5,"__msa_subv_b","","Vector Subtract",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_subv_h","","Vector Subtract",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_subv_w","","Vector Subtract",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_subv_d","","Vector Subtract",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_subvi_b","","Immediate Subtract",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_subvi_h","","Immediate Subtract",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_subvi_w","","Immediate Subtract",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_subvi_d","","Immediate Subtract",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_vshf_b","","Vector Data Preserving Shuffle",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_vshf_h","","Vector Data Preserving Shuffle",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_vshf_w","","Vector Data Preserving Shuffle",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_vshf_d","","Vector Data Preserving Shuffle",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_xor_v","","Vector Logical Exclusive Or",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_xori_b","","Immediate Logical Exclusive Or",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"break_","","Generates the trap instruction `BREAK`",null,[[]]],[0,"mips64","core::arch","Platform-specific intrinsics for the `mips64` platform.",null,null],[3,"v16i8","core::arch::mips64","",null,null],[3,"v8i16","","",null,null],[3,"v4i32","","",null,null],[3,"v2i64","","",null,null],[3,"v16u8","","",null,null],[3,"v8u16","","",null,null],[3,"v4u32","","",null,null],[3,"v2u64","","",null,null],[3,"v4f32","","",null,null],[3,"v2f64","","",null,null],[5,"__msa_add_a_b","","Vector Add Absolute Values.",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_add_a_h","","Vector Add Absolute Values",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_add_a_w","","Vector Add Absolute Values",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_add_a_d","","Vector Add Absolute Values",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_adds_a_b","","Signed Saturated Vector Saturated Add of Absolute Values",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_adds_a_h","","Vector Saturated Add of Absolute Values",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_adds_a_w","","Vector Saturated Add of Absolute Values",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_adds_a_d","","Vector Saturated Add of Absolute Values",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_adds_s_b","","Vector Signed Saturated Add of Signed Values",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_adds_s_h","","Vector Signed Saturated Add of Signed Values",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_adds_s_w","","Vector Signed Saturated Add of Signed Values",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_adds_s_d","","Vector Signed Saturated Add of Signed Values",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_adds_u_b","","Vector Unsigned Saturated Add of Unsigned Values",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_adds_u_h","","Vector Unsigned Saturated Add of Unsigned Values",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_adds_u_w","","Vector Unsigned Saturated Add of Unsigned Values",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_adds_u_d","","Vector Unsigned Saturated Add of Unsigned Values",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_addv_b","","Vector Add",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_addv_h","","Vector Add",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_addv_w","","Vector Add",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_addv_d","","Vector Add",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_addvi_b","","Immediate Add",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_addvi_h","","Immediate Add",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_addvi_w","","Immediate Add",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_addvi_d","","Immediate Add",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_and_v","","Vector Logical And",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_andi_b","","Immediate Logical And",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_asub_s_b","","Vector Absolute Values of Signed Subtract",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_asub_s_h","","Vector Absolute Values of Signed Subtract",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_asub_s_w","","Vector Absolute Values of Signed Subtract",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_asub_s_d","","Vector Absolute Values of Signed Subtract",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_asub_u_b","","Vector Absolute Values of Unsigned Subtract",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_asub_u_h","","Vector Absolute Values of Unsigned Subtract",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_asub_u_w","","Vector Absolute Values of Unsigned Subtract",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_asub_u_d","","Vector Absolute Values of Unsigned Subtract",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_ave_s_b","","Vector Signed Average",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_ave_s_h","","Vector Signed Average",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_ave_s_w","","Vector Signed Average",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_ave_s_d","","Vector Signed Average",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_ave_u_b","","Vector Unsigned Average",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_ave_u_h","","Vector Unsigned Average",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_ave_u_w","","Vector Unsigned Average",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_ave_u_d","","Vector Unsigned Average",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_aver_s_b","","Vector Signed Average Rounded",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_aver_s_h","","Vector Signed Average Rounded",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_aver_s_w","","Vector Signed Average Rounded",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_aver_s_d","","Vector Signed Average Rounded",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_aver_u_b","","Vector Unsigned Average Rounded",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_aver_u_h","","Vector Unsigned Average Rounded",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_aver_u_w","","Vector Unsigned Average Rounded",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_aver_u_d","","Vector Unsigned Average Rounded",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_bclr_b","","Vector Bit Clear",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_bclr_h","","Vector Bit Clear",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_bclr_w","","Vector Bit Clear",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_bclr_d","","Vector Bit Clear",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_bclri_b","","Immediate Bit Clear",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_bclri_h","","Immediate Bit Clear",null,[[["v8u16"],["i32"]],["v8u16"]]],[5,"__msa_bclri_w","","Immediate Bit Clear",null,[[["v4u32"],["i32"]],["v4u32"]]],[5,"__msa_bclri_d","","Immediate Bit Clear",null,[[["i32"],["v2u64"]],["v2u64"]]],[5,"__msa_binsl_b","","Vector Bit Insert Left",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_binsl_h","","Vector Bit Insert Left",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_binsl_w","","Vector Bit Insert Left",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_binsl_d","","Vector Bit Insert Left",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_binsli_b","","Immediate Bit Insert Left",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_binsli_h","","Immediate Bit Insert Left",null,[[["v8u16"],["i32"]],["v8u16"]]],[5,"__msa_binsli_w","","Immediate Bit Insert Left",null,[[["v4u32"],["i32"]],["v4u32"]]],[5,"__msa_binsli_d","","Immediate Bit Insert Left",null,[[["i32"],["v2u64"]],["v2u64"]]],[5,"__msa_binsr_b","","Vector Bit Insert Right",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_binsr_h","","Vector Bit Insert Right",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_binsr_w","","Vector Bit Insert Right",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_binsr_d","","Vector Bit Insert Right",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_binsri_b","","Immediate Bit Insert Right",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_binsri_h","","Immediate Bit Insert Right",null,[[["v8u16"],["i32"]],["v8u16"]]],[5,"__msa_binsri_w","","Immediate Bit Insert Right",null,[[["v4u32"],["i32"]],["v4u32"]]],[5,"__msa_binsri_d","","Immediate Bit Insert Right",null,[[["i32"],["v2u64"]],["v2u64"]]],[5,"__msa_bmnz_v","","Vector Bit Move If Not Zero",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_bmnzi_b","","Immediate Bit Move If Not Zero",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_bmz_v","","Vector Bit Move If Zero",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_bmzi_b","","Immediate Bit Move If Zero",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_bneg_b","","Vector Bit Negate",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_bneg_h","","Vector Bit Negate",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_bneg_w","","Vector Bit Negate",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_bneg_d","","Vector Bit Negate",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_bnegi_b","","Immediate Bit Negate",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_bnegi_h","","Immediate Bit Negate",null,[[["v8u16"],["i32"]],["v8u16"]]],[5,"__msa_bnegi_w","","Immediate Bit Negate",null,[[["v4u32"],["i32"]],["v4u32"]]],[5,"__msa_bnegi_d","","Immediate Bit Negate",null,[[["i32"],["v2u64"]],["v2u64"]]],[5,"__msa_bnz_b","","Immediate Branch If All Elements Are Not Zero",null,[[["v16u8"]],["i32"]]],[5,"__msa_bnz_h","","Immediate Branch If All Elements Are Not Zero",null,[[["v8u16"]],["i32"]]],[5,"__msa_bnz_w","","Immediate Branch If All Elements Are Not Zero",null,[[["v4u32"]],["i32"]]],[5,"__msa_bnz_d","","Immediate Branch If All Elements Are Not Zero",null,[[["v2u64"]],["i32"]]],[5,"__msa_bnz_v","","Immediate Branch If Not Zero (At Least One Element of Any…",null,[[["v16u8"]],["i32"]]],[5,"__msa_bsel_v","","Vector Bit Select",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_bseli_b","","Immediate Bit Select",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_bset_b","","Vector Bit Set",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_bset_h","","Vector Bit Set",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_bset_w","","Vector Bit Set",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_bset_d","","Vector Bit Set",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_bseti_b","","Immediate Bit Set",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_bseti_h","","Immediate Bit Set",null,[[["v8u16"],["i32"]],["v8u16"]]],[5,"__msa_bseti_w","","Immediate Bit Set",null,[[["v4u32"],["i32"]],["v4u32"]]],[5,"__msa_bseti_d","","Immediate Bit Set",null,[[["i32"],["v2u64"]],["v2u64"]]],[5,"__msa_bz_b","","Immediate Branch If At Least One Element Is Zero",null,[[["v16u8"]],["i32"]]],[5,"__msa_bz_h","","Immediate Branch If At Least One Element Is Zero",null,[[["v8u16"]],["i32"]]],[5,"__msa_bz_w","","Immediate Branch If At Least One Element Is Zero",null,[[["v4u32"]],["i32"]]],[5,"__msa_bz_d","","Immediate Branch If At Least One Element Is Zero",null,[[["v2u64"]],["i32"]]],[5,"__msa_bz_v","","Immediate Branch If Zero (All Elements of Any Format Are…",null,[[["v16u8"]],["i32"]]],[5,"__msa_ceq_b","","Vector Compare Equal",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_ceq_h","","Vector Compare Equal",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_ceq_w","","Vector Compare Equal",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_ceq_d","","Vector Compare Equal",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_ceqi_b","","Immediate Compare Equal",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_ceqi_h","","Immediate Compare Equal",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_ceqi_w","","Immediate Compare Equal",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_ceqi_d","","Immediate Compare Equal",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_cfcmsa","","GPR Copy from MSA Control Register",null,[[["i32"]],["i32"]]],[5,"__msa_cle_s_b","","Vector Compare Signed Less Than or Equal",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_cle_s_h","","Vector Compare Signed Less Than or Equal",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_cle_s_w","","Vector Compare Signed Less Than or Equal",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_cle_s_d","","Vector Compare Signed Less Than or Equal",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_cle_u_b","","Vector Compare Unsigned Less Than or Equal",null,[[["v16u8"]],["v16i8"]]],[5,"__msa_cle_u_h","","Vector Compare Unsigned Less Than or Equal",null,[[["v8u16"]],["v8i16"]]],[5,"__msa_cle_u_w","","Vector Compare Unsigned Less Than or Equal",null,[[["v4u32"]],["v4i32"]]],[5,"__msa_cle_u_d","","Vector Compare Unsigned Less Than or Equal",null,[[["v2u64"]],["v2i64"]]],[5,"__msa_clei_s_b","","Immediate Compare Signed Less Than or Equal",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_clei_s_h","","Immediate Compare Signed Less Than or Equal",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_clei_s_w","","Immediate Compare Signed Less Than or Equal",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_clei_s_d","","Immediate Compare Signed Less Than or Equal",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_clei_u_b","","Immediate Compare Unsigned Less Than or Equal",null,[[["i32"],["v16u8"]],["v16i8"]]],[5,"__msa_clei_u_h","","Immediate Compare Unsigned Less Than or Equal",null,[[["v8u16"],["i32"]],["v8i16"]]],[5,"__msa_clei_u_w","","Immediate Compare Unsigned Less Than or Equal",null,[[["v4u32"],["i32"]],["v4i32"]]],[5,"__msa_clei_u_d","","Immediate Compare Unsigned Less Than or Equal",null,[[["i32"],["v2u64"]],["v2i64"]]],[5,"__msa_clt_s_b","","Vector Compare Signed Less Than",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_clt_s_h","","Vector Compare Signed Less Than",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_clt_s_w","","Vector Compare Signed Less Than",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_clt_s_d","","Vector Compare Signed Less Than",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_clt_u_b","","Vector Compare Unsigned Less Than",null,[[["v16u8"]],["v16i8"]]],[5,"__msa_clt_u_h","","Vector Compare Unsigned Less Than",null,[[["v8u16"]],["v8i16"]]],[5,"__msa_clt_u_w","","Vector Compare Unsigned Less Than",null,[[["v4u32"]],["v4i32"]]],[5,"__msa_clt_u_d","","Vector Compare Unsigned Less Than",null,[[["v2u64"]],["v2i64"]]],[5,"__msa_clti_s_b","","Immediate Compare Signed Less Than",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_clti_s_h","","Immediate Compare Signed Less Than",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_clti_s_w","","Immediate Compare Signed Less Than",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_clti_s_d","","Immediate Compare Signed Less Than",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_clti_u_b","","Immediate Compare Unsigned Less Than",null,[[["i32"],["v16u8"]],["v16i8"]]],[5,"__msa_clti_u_h","","Immediate Compare Unsigned Less Than",null,[[["v8u16"],["i32"]],["v8i16"]]],[5,"__msa_clti_u_w","","Immediate Compare Unsigned Less Than",null,[[["v4u32"],["i32"]],["v4i32"]]],[5,"__msa_clti_u_d","","Immediate Compare Unsigned Less Than",null,[[["i32"],["v2u64"]],["v2i64"]]],[5,"__msa_copy_s_b","","Element Copy to GPR Signed",null,[[["v16i8"],["i32"]],["i32"]]],[5,"__msa_copy_s_h","","Element Copy to GPR Signed",null,[[["v8i16"],["i32"]],["i32"]]],[5,"__msa_copy_s_w","","Element Copy to GPR Signed",null,[[["v4i32"],["i32"]],["i32"]]],[5,"__msa_copy_s_d","","Element Copy to GPR Signed",null,[[["i32"],["v2i64"]],["i64"]]],[5,"__msa_copy_u_b","","Element Copy to GPR Unsigned",null,[[["v16i8"],["i32"]],["u32"]]],[5,"__msa_copy_u_h","","Element Copy to GPR Unsigned",null,[[["v8i16"],["i32"]],["u32"]]],[5,"__msa_copy_u_w","","Element Copy to GPR Unsigned",null,[[["v4i32"],["i32"]],["u32"]]],[5,"__msa_copy_u_d","","Element Copy to GPR Unsigned",null,[[["i32"],["v2i64"]],["u64"]]],[5,"__msa_ctcmsa","","GPR Copy to MSA Control Register",null,[[["i32"]]]],[5,"__msa_div_s_b","","Vector Signed Divide",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_div_s_h","","Vector Signed Divide",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_div_s_w","","Vector Signed Divide",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_div_s_d","","Vector Signed Divide",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_div_u_b","","Vector Unsigned Divide",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_div_u_h","","Vector Unsigned Divide",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_div_u_w","","Vector Unsigned Divide",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_div_u_d","","Vector Unsigned Divide",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_dotp_s_h","","Vector Signed Dot Product",null,[[["v16i8"]],["v8i16"]]],[5,"__msa_dotp_s_w","","Vector Signed Dot Product",null,[[["v8i16"]],["v4i32"]]],[5,"__msa_dotp_s_d","","Vector Signed Dot Product",null,[[["v4i32"]],["v2i64"]]],[5,"__msa_dotp_u_h","","Vector Unsigned Dot Product",null,[[["v16u8"]],["v8u16"]]],[5,"__msa_dotp_u_w","","Vector Unsigned Dot Product",null,[[["v8u16"]],["v4u32"]]],[5,"__msa_dotp_u_d","","Vector Unsigned Dot Product",null,[[["v4u32"]],["v2u64"]]],[5,"__msa_dpadd_s_h","","Vector Signed Dot Product and Add",null,[[["v8i16"],["v16i8"]],["v8i16"]]],[5,"__msa_dpadd_s_w","","Vector Signed Dot Product and Add",null,[[["v8i16"],["v4i32"]],["v4i32"]]],[5,"__msa_dpadd_s_d","","Vector Signed Dot Product and Add",null,[[["v4i32"],["v2i64"]],["v2i64"]]],[5,"__msa_dpadd_u_h","","Vector Unsigned Dot Product and Add",null,[[["v8u16"],["v16u8"]],["v8u16"]]],[5,"__msa_dpadd_u_w","","Vector Unsigned Dot Product and Add",null,[[["v4u32"],["v8u16"]],["v4u32"]]],[5,"__msa_dpadd_u_d","","Vector Unsigned Dot Product and Add",null,[[["v4u32"],["v2u64"]],["v2u64"]]],[5,"__msa_dpsub_s_h","","Vector Signed Dot Product and Add",null,[[["v8i16"],["v16i8"]],["v8i16"]]],[5,"__msa_dpsub_s_w","","Vector Signed Dot Product and Add",null,[[["v8i16"],["v4i32"]],["v4i32"]]],[5,"__msa_dpsub_s_d","","Vector Signed Dot Product and Add",null,[[["v4i32"],["v2i64"]],["v2i64"]]],[5,"__msa_dpsub_u_h","","Vector Unsigned Dot Product and Add",null,[[["v8i16"],["v16u8"]],["v8i16"]]],[5,"__msa_dpsub_u_w","","Vector Unsigned Dot Product and Add",null,[[["v4i32"],["v8u16"]],["v4i32"]]],[5,"__msa_dpsub_u_d","","Vector Unsigned Dot Product and Add",null,[[["v4u32"],["v2i64"]],["v2i64"]]],[5,"__msa_fadd_w","","Vector Floating-Point Addition",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fadd_d","","Vector Floating-Point Addition",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fcaf_w","","Vector Floating-Point Quiet Compare Always False",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fcaf_d","","Vector Floating-Point Quiet Compare Always False",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fceq_w","","Vector Floating-Point Quiet Compare Equal",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fceq_d","","Vector Floating-Point Quiet Compare Equal",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fclass_w","","Vector Floating-Point Class Mask",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fclass_d","","Vector Floating-Point Class Mask",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fcle_w","","Vector Floating-Point Quiet Compare Less or Equal",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fcle_d","","Vector Floating-Point Quiet Compare Less or Equal",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fclt_w","","Vector Floating-Point Quiet Compare Less Than",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fclt_d","","Vector Floating-Point Quiet Compare Less Than",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fcne_w","","Vector Floating-Point Quiet Compare Not Equal",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fcne_d","","Vector Floating-Point Quiet Compare Not Equal",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fcor_w","","Vector Floating-Point Quiet Compare Ordered",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fcor_d","","Vector Floating-Point Quiet Compare Ordered",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fcueq_w","","Vector Floating-Point Quiet Compare Unordered or Equal",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fcueq_d","","Vector Floating-Point Quiet Compare Unordered or Equal",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fcule_w","","Vector Floating-Point Quiet Compare Unordered or Less or…",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fcule_d","","Vector Floating-Point Quiet Compare Unordered or Less or…",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fcult_w","","Vector Floating-Point Quiet Compare Unordered or Less Than",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fcult_d","","Vector Floating-Point Quiet Compare Unordered or Less Than",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fcun_w","","Vector Floating-Point Quiet Compare Unordered",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fcun_d","","Vector Floating-Point Quiet Compare Unordered",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fcune_w","","Vector Floating-Point Quiet Compare Unordered or Not Equal",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fcune_d","","Vector Floating-Point Quiet Compare Unordered or Not Equal",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fdiv_w","","Vector Floating-Point Division",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fdiv_d","","Vector Floating-Point Division",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fexdo_w","","Vector Floating-Point Down-Convert Interchange Format",null,[[["v2f64"]],["v4f32"]]],[5,"__msa_fexp2_w","","Vector Floating-Point Down-Convert Interchange Format",null,[[["v4f32"],["v4i32"]],["v4f32"]]],[5,"__msa_fexp2_d","","Vector Floating-Point Down-Convert Interchange Format",null,[[["v2f64"],["v2i64"]],["v2f64"]]],[5,"__msa_fexupl_d","","Vector Floating-Point Up-Convert Interchange Format Left",null,[[["v4f32"]],["v2f64"]]],[5,"__msa_fexupr_d","","Vector Floating-Point Up-Convert Interchange Format Left",null,[[["v4f32"]],["v2f64"]]],[5,"__msa_ffint_s_w","","Vector Floating-Point Round and Convert from Signed Integer",null,[[["v4i32"]],["v4f32"]]],[5,"__msa_ffint_s_d","","Vector Floating-Point Round and Convert from Signed Integer",null,[[["v2i64"]],["v2f64"]]],[5,"__msa_ffint_u_w","","Vector Floating-Point Round and Convert from Unsigned…",null,[[["v4u32"]],["v4f32"]]],[5,"__msa_ffint_u_d","","Vector Floating-Point Round and Convert from Unsigned…",null,[[["v2u64"]],["v2f64"]]],[5,"__msa_ffql_w","","Vector Floating-Point Convert from Fixed-Point Left",null,[[["v8i16"]],["v4f32"]]],[5,"__msa_ffql_d","","Vector Floating-Point Convert from Fixed-Point Left",null,[[["v4i32"]],["v2f64"]]],[5,"__msa_ffqr_w","","Vector Floating-Point Convert from Fixed-Point Left",null,[[["v8i16"]],["v4f32"]]],[5,"__msa_ffqr_d","","Vector Floating-Point Convert from Fixed-Point Left",null,[[["v4i32"]],["v2f64"]]],[5,"__msa_fill_b","","Vector Fill from GPR",null,[[["i32"]],["v16i8"]]],[5,"__msa_fill_h","","Vector Fill from GPR",null,[[["i32"]],["v8i16"]]],[5,"__msa_fill_w","","Vector Fill from GPR",null,[[["i32"]],["v4i32"]]],[5,"__msa_fill_d","","Vector Fill from GPR",null,[[["i64"]],["v2i64"]]],[5,"__msa_flog2_w","","Vector Floating-Point Base 2 Logarithm",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_flog2_d","","Vector Floating-Point Base 2 Logarithm",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fmadd_w","","Vector Floating-Point Multiply-Add",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fmadd_d","","Vector Floating-Point Multiply-Add",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fmax_w","","Vector Floating-Point Maximum",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fmax_d","","Vector Floating-Point Maximum",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fmax_a_w","","Vector Floating-Point Maximum Based on Absolute Values",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fmax_a_d","","Vector Floating-Point Maximum Based on Absolute Values",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fmin_w","","Vector Floating-Point Minimum",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fmin_d","","Vector Floating-Point Minimum",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fmin_a_w","","Vector Floating-Point Minimum Based on Absolute Values",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fmin_a_d","","Vector Floating-Point Minimum Based on Absolute Values",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fmsub_w","","Vector Floating-Point Multiply-Sub",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fmsub_d","","Vector Floating-Point Multiply-Sub",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fmul_w","","Vector Floating-Point Multiplication",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fmul_d","","Vector Floating-Point Multiplication",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_frint_w","","Vector Floating-Point Round to Integer",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_frint_d","","Vector Floating-Point Round to Integer",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_frcp_w","","Vector Approximate Floating-Point Reciprocal",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_frcp_d","","Vector Approximate Floating-Point Reciprocal",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_frsqrt_w","","Vector Approximate Floating-Point Reciprocal of Square Root",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_frsqrt_d","","Vector Approximate Floating-Point Reciprocal of Square Root",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fsaf_w","","Vector Floating-Point Signaling Compare Always False",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fsaf_d","","Vector Floating-Point Signaling Compare Always False",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fseq_w","","Vector Floating-Point Signaling Compare Equal",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fseq_d","","Vector Floating-Point Signaling Compare Equal",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fsle_w","","Vector Floating-Point Signaling Compare Less or Equal",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fsle_d","","Vector Floating-Point Signaling Compare Less or Equal",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fslt_w","","Vector Floating-Point Signaling Compare Less Than",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fslt_d","","Vector Floating-Point Signaling Compare Less Than",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fsne_w","","Vector Floating-Point Signaling Compare Not Equal",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fsne_d","","Vector Floating-Point Signaling Compare Not Equal",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fsor_w","","Vector Floating-Point Signaling Compare Ordered",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fsor_d","","Vector Floating-Point Signaling Compare Ordered",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fsqrt_w","","Vector Floating-Point Square Root",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fsqrt_d","","Vector Floating-Point Square Root",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fsub_w","","Vector Floating-Point Subtraction",null,[[["v4f32"]],["v4f32"]]],[5,"__msa_fsub_d","","Vector Floating-Point Subtraction",null,[[["v2f64"]],["v2f64"]]],[5,"__msa_fsueq_w","","Vector Floating-Point Signaling Compare Ordered",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fsueq_d","","Vector Floating-Point Signaling Compare Ordered",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fsule_w","","Vector Floating-Point Signaling Compare Unordered or Less…",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fsule_d","","Vector Floating-Point Signaling Compare Unordered or Less…",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fsult_w","","Vector Floating-Point Signaling Compare Unordered or Less…",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fsult_d","","Vector Floating-Point Signaling Compare Unordered or Less…",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fsun_w","","Vector Floating-Point Signaling Compare Unordered",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fsun_d","","Vector Floating-Point Signaling Compare Unordered",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_fsune_w","","Vector Floating-Point Signaling Compare Unordered or Not…",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_fsune_d","","Vector Floating-Point Signaling Compare Unordered or Not…",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_ftint_s_w","","Vector Floating-Point Convert to Signed Integer",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_ftint_s_d","","Vector Floating-Point Convert to Signed Integer",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_ftint_u_w","","Vector Floating-Point Convert to Unsigned Integer",null,[[["v4f32"]],["v4u32"]]],[5,"__msa_ftint_u_d","","Vector Floating-Point Convert to Unsigned Integer",null,[[["v2f64"]],["v2u64"]]],[5,"__msa_ftq_h","","Vector Floating-Point Convert to Fixed-Point",null,[[["v4f32"]],["v8i16"]]],[5,"__msa_ftq_w","","Vector Floating-Point Convert to Fixed-Point",null,[[["v2f64"]],["v4i32"]]],[5,"__msa_ftrunc_s_w","","Vector Floating-Point Truncate and Convert to Signed Integer",null,[[["v4f32"]],["v4i32"]]],[5,"__msa_ftrunc_s_d","","Vector Floating-Point Truncate and Convert to Signed Integer",null,[[["v2f64"]],["v2i64"]]],[5,"__msa_ftrunc_u_w","","Vector Floating-Point Truncate and Convert to Unsigned…",null,[[["v4f32"]],["v4u32"]]],[5,"__msa_ftrunc_u_d","","Vector Floating-Point Truncate and Convert to Unsigned…",null,[[["v2f64"]],["v2u64"]]],[5,"__msa_hadd_s_h","","Vector Signed Horizontal Add",null,[[["v16i8"]],["v8i16"]]],[5,"__msa_hadd_s_w","","Vector Signed Horizontal Add",null,[[["v8i16"]],["v4i32"]]],[5,"__msa_hadd_s_d","","Vector Signed Horizontal Add",null,[[["v4i32"]],["v2i64"]]],[5,"__msa_hadd_u_h","","Vector Unsigned Horizontal Add",null,[[["v16u8"]],["v8u16"]]],[5,"__msa_hadd_u_w","","Vector Unsigned Horizontal Add",null,[[["v8u16"]],["v4u32"]]],[5,"__msa_hadd_u_d","","Vector Unsigned Horizontal Add",null,[[["v4u32"]],["v2u64"]]],[5,"__msa_hsub_s_h","","Vector Signed Horizontal Subtract",null,[[["v16i8"]],["v8i16"]]],[5,"__msa_hsub_s_w","","Vector Signed Horizontal Subtract",null,[[["v8i16"]],["v4i32"]]],[5,"__msa_hsub_s_d","","Vector Signed Horizontal Subtract",null,[[["v4i32"]],["v2i64"]]],[5,"__msa_hsub_u_h","","Vector Unsigned Horizontal Subtract",null,[[["v16u8"]],["v8i16"]]],[5,"__msa_hsub_u_w","","Vector Unsigned Horizontal Subtract",null,[[["v8u16"]],["v4i32"]]],[5,"__msa_hsub_u_d","","Vector Unsigned Horizontal Subtract",null,[[["v4u32"]],["v2i64"]]],[5,"__msa_ilvev_b","","Vector Interleave Even",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_ilvev_h","","Vector Interleave Even",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_ilvev_w","","Vector Interleave Even",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_ilvev_d","","Vector Interleave Even",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_ilvl_b","","Vector Interleave Left",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_ilvl_h","","Vector Interleave Left",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_ilvl_w","","Vector Interleave Left",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_ilvl_d","","Vector Interleave Left",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_ilvod_b","","Vector Interleave Odd",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_ilvod_h","","Vector Interleave Odd",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_ilvod_w","","Vector Interleave Odd",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_ilvod_d","","Vector Interleave Odd",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_ilvr_b","","Vector Interleave Right",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_ilvr_h","","Vector Interleave Right",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_ilvr_w","","Vector Interleave Right",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_ilvr_d","","Vector Interleave Right",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_insert_b","","GPR Insert Element",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_insert_h","","GPR Insert Element",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_insert_w","","GPR Insert Element",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_insert_d","","GPR Insert Element",null,[[["i32"],["i64"],["v2i64"]],["v2i64"]]],[5,"__msa_insve_b","","Element Insert Element",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_insve_h","","Element Insert Element",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_insve_w","","Element Insert Element",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_insve_d","","Element Insert Element",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_ld_b","","Vector Load",null,[[["i32"]],["v16i8"]]],[5,"__msa_ld_h","","Vector Load",null,[[["i32"]],["v8i16"]]],[5,"__msa_ld_w","","Vector Load",null,[[["i32"]],["v4i32"]]],[5,"__msa_ld_d","","Vector Load",null,[[["i32"]],["v2i64"]]],[5,"__msa_ldi_b","","Immediate Load",null,[[["i32"]],["v16i8"]]],[5,"__msa_ldi_h","","Immediate Load",null,[[["i32"]],["v8i16"]]],[5,"__msa_ldi_w","","Immediate Load",null,[[["i32"]],["v4i32"]]],[5,"__msa_ldi_d","","Immediate Load",null,[[["i32"]],["v2i64"]]],[5,"__msa_madd_q_h","","Vector Fixed-Point Multiply and Add",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_madd_q_w","","Vector Fixed-Point Multiply and Add",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_maddr_q_h","","Vector Fixed-Point Multiply and Add Rounded",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_maddr_q_w","","Vector Fixed-Point Multiply and Add Rounded",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_maddv_b","","Vector Multiply and Add",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_maddv_h","","Vector Multiply and Add",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_maddv_w","","Vector Multiply and Add",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_maddv_d","","Vector Multiply and Add",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_max_a_b","","Vector Maximum Based on Absolute Values",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_max_a_h","","Vector Maximum Based on Absolute Values",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_max_a_w","","Vector Maximum Based on Absolute Values",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_max_a_d","","Vector Maximum Based on Absolute Values",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_max_s_b","","Vector Signed Maximum",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_max_s_h","","Vector Signed Maximum",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_max_s_w","","Vector Signed Maximum",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_max_s_d","","Vector Signed Maximum",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_max_u_b","","Vector Unsigned Maximum",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_max_u_h","","Vector Unsigned Maximum",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_max_u_w","","Vector Unsigned Maximum",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_max_u_d","","Vector Unsigned Maximum",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_maxi_s_b","","Immediate Signed Maximum",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_maxi_s_h","","Immediate Signed Maximum",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_maxi_s_w","","Immediate Signed Maximum",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_maxi_s_d","","Immediate Signed Maximum",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_maxi_u_b","","Immediate Unsigned Maximum",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_maxi_u_h","","Immediate Unsigned Maximum",null,[[["v8u16"],["i32"]],["v8u16"]]],[5,"__msa_maxi_u_w","","Immediate Unsigned Maximum",null,[[["v4u32"],["i32"]],["v4u32"]]],[5,"__msa_maxi_u_d","","Immediate Unsigned Maximum",null,[[["i32"],["v2u64"]],["v2u64"]]],[5,"__msa_min_a_b","","Vector Minimum Based on Absolute Value",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_min_a_h","","Vector Minimum Based on Absolute Value",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_min_a_w","","Vector Minimum Based on Absolute Value",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_min_a_d","","Vector Minimum Based on Absolute Value",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_min_s_b","","Vector Signed Minimum",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_min_s_h","","Vector Signed Minimum",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_min_s_w","","Vector Signed Minimum",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_min_s_d","","Vector Signed Minimum",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_mini_s_b","","Immediate Signed Minimum",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_mini_s_h","","Immediate Signed Minimum",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_mini_s_w","","Immediate Signed Minimum",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_mini_s_d","","Immediate Signed Minimum",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_min_u_b","","Vector Unsigned Minimum",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_min_u_h","","Vector Unsigned Minimum",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_min_u_w","","Vector Unsigned Minimum",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_min_u_d","","Vector Unsigned Minimum",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_mini_u_b","","Immediate Unsigned Minimum",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_mini_u_h","","Immediate Unsigned Minimum",null,[[["v8u16"],["i32"]],["v8u16"]]],[5,"__msa_mini_u_w","","Immediate Unsigned Minimum",null,[[["v4u32"],["i32"]],["v4u32"]]],[5,"__msa_mini_u_d","","Immediate Unsigned Minimum",null,[[["i32"],["v2u64"]],["v2u64"]]],[5,"__msa_mod_s_b","","Vector Signed Modulo",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_mod_s_h","","Vector Signed Modulo",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_mod_s_w","","Vector Signed Modulo",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_mod_s_d","","Vector Signed Modulo",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_mod_u_b","","Vector Unsigned Modulo",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_mod_u_h","","Vector Unsigned Modulo",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_mod_u_w","","Vector Unsigned Modulo",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_mod_u_d","","Vector Unsigned Modulo",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_move_v","","Vector Move",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_msub_q_h","","Vector Fixed-Point Multiply and Subtract",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_msub_q_w","","Vector Fixed-Point Multiply and Subtract",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_msubr_q_h","","Vector Fixed-Point Multiply and Subtract Rounded",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_msubr_q_w","","Vector Fixed-Point Multiply and Subtract Rounded",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_msubv_b","","Vector Multiply and Subtract",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_msubv_h","","Vector Multiply and Subtract",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_msubv_w","","Vector Multiply and Subtract",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_msubv_d","","Vector Multiply and Subtract",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_mul_q_h","","Vector Fixed-Point Multiply",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_mul_q_w","","Vector Fixed-Point Multiply",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_mulr_q_h","","Vector Fixed-Point Multiply Rounded",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_mulr_q_w","","Vector Fixed-Point Multiply Rounded",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_mulv_b","","Vector Multiply",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_mulv_h","","Vector Multiply",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_mulv_w","","Vector Multiply",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_mulv_d","","Vector Multiply",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_nloc_b","","Vector Leading Ones Count",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_nloc_h","","Vector Leading Ones Count",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_nloc_w","","Vector Leading Ones Count",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_nloc_d","","Vector Leading Ones Count",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_nlzc_b","","Vector Leading Zeros Count",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_nlzc_h","","Vector Leading Zeros Count",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_nlzc_w","","Vector Leading Zeros Count",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_nlzc_d","","Vector Leading Zeros Count",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_nor_v","","Vector Logical Negated Or",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_nori_b","","Immediate Logical Negated Or",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_or_v","","Vector Logical Or",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_ori_b","","Immediate Logical Or",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_pckev_b","","Vector Pack Even",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_pckev_h","","Vector Pack Even",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_pckev_w","","Vector Pack Even",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_pckev_d","","Vector Pack Even",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_pckod_b","","Vector Pack Odd",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_pckod_h","","Vector Pack Odd",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_pckod_w","","Vector Pack Odd",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_pckod_d","","Vector Pack Odd",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_pcnt_b","","Vector Population Count",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_pcnt_h","","Vector Population Count",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_pcnt_w","","Vector Population Count",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_pcnt_d","","Vector Population Count",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_sat_s_b","","Immediate Signed Saturate",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_sat_s_h","","Immediate Signed Saturate",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_sat_s_w","","Immediate Signed Saturate",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_sat_s_d","","Immediate Signed Saturate",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_sat_u_b","","Immediate Unsigned Saturate",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"__msa_sat_u_h","","Immediate Unsigned Saturate",null,[[["v8u16"],["i32"]],["v8u16"]]],[5,"__msa_sat_u_w","","Immediate Unsigned Saturate",null,[[["v4u32"],["i32"]],["v4u32"]]],[5,"__msa_sat_u_d","","Immediate Unsigned Saturate",null,[[["i32"],["v2u64"]],["v2u64"]]],[5,"__msa_shf_b","","Immediate Set Shuffle Elements",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_shf_h","","Immediate Set Shuffle Elements",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_shf_w","","Immediate Set Shuffle Elements",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_sld_b","","GPR Columns Slide",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_sld_h","","GPR Columns Slide",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_sld_w","","GPR Columns Slide",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_sld_d","","GPR Columns Slide",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_sldi_b","","Immediate Columns Slide",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_sldi_h","","Immediate Columns Slide",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_sldi_w","","Immediate Columns Slide",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_sldi_d","","Immediate Columns Slide",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_sll_b","","Vector Shift Left",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_sll_h","","Vector Shift Left",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_sll_w","","Vector Shift Left",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_sll_d","","Vector Shift Left",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_slli_b","","Immediate Shift Left",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_slli_h","","Immediate Shift Left",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_slli_w","","Immediate Shift Left",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_slli_d","","Immediate Shift Left",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_splat_b","","GPR Element Splat",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_splat_h","","GPR Element Splat",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_splat_w","","GPR Element Splat",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_splat_d","","GPR Element Splat",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_splati_b","","Immediate Element Splat",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_splati_h","","Immediate Element Splat",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_splati_w","","Immediate Element Splat",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_splati_d","","Immediate Element Splat",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_sra_b","","Vector Shift Right Arithmetic",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_sra_h","","Vector Shift Right Arithmetic",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_sra_w","","Vector Shift Right Arithmetic",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_sra_d","","Vector Shift Right Arithmetic",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_srai_b","","Immediate Shift Right Arithmetic",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_srai_h","","Immediate Shift Right Arithmetic",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_srai_w","","Immediate Shift Right Arithmetic",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_srai_d","","Immediate Shift Right Arithmetic",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_srar_b","","Vector Shift Right Arithmetic Rounded",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_srar_h","","Vector Shift Right Arithmetic Rounded",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_srar_w","","Vector Shift Right Arithmetic Rounded",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_srar_d","","Vector Shift Right Arithmetic Rounded",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_srari_b","","Immediate Shift Right Arithmetic Rounded",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_srari_h","","Immediate Shift Right Arithmetic Rounded",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_srari_w","","Immediate Shift Right Arithmetic Rounded",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_srari_d","","Immediate Shift Right Arithmetic Rounded",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_srl_b","","Vector Shift Right Logical",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_srl_h","","Vector Shift Right Logical",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_srl_w","","Vector Shift Right Logical",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_srl_d","","Vector Shift Right Logical",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_srli_b","","Immediate Shift Right Logical",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_srli_h","","Immediate Shift Right Logical",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_srli_w","","Immediate Shift Right Logical",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_srli_d","","Immediate Shift Right Logical",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_srlr_b","","Vector Shift Right Logical Rounded",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_srlr_h","","Vector Shift Right Logical Rounded",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_srlr_w","","Vector Shift Right Logical Rounded",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_srlr_d","","Vector Shift Right Logical Rounded",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_srlri_b","","Immediate Shift Right Logical Rounded",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_srlri_h","","Immediate Shift Right Logical Rounded",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_srlri_w","","Immediate Shift Right Logical Rounded",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_srlri_d","","Immediate Shift Right Logical Rounded",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_st_b","","Vector Store",null,[[["v16i8"],["i32"]]]],[5,"__msa_st_h","","Vector Store",null,[[["v8i16"],["i32"]]]],[5,"__msa_st_w","","Vector Store",null,[[["v4i32"],["i32"]]]],[5,"__msa_st_d","","Vector Store",null,[[["i32"],["v2i64"]]]],[5,"__msa_subs_s_b","","Vector Signed Saturated Subtract of Signed Values",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_subs_s_h","","Vector Signed Saturated Subtract of Signed Values",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_subs_s_w","","Vector Signed Saturated Subtract of Signed Values",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_subs_s_d","","Vector Signed Saturated Subtract of Signed Values",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_subs_u_b","","Vector Unsigned Saturated Subtract of Unsigned Values",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_subs_u_h","","Vector Unsigned Saturated Subtract of Unsigned Values",null,[[["v8u16"]],["v8u16"]]],[5,"__msa_subs_u_w","","Vector Unsigned Saturated Subtract of Unsigned Values",null,[[["v4u32"]],["v4u32"]]],[5,"__msa_subs_u_d","","Vector Unsigned Saturated Subtract of Unsigned Values",null,[[["v2u64"]],["v2u64"]]],[5,"__msa_subsus_u_b","","Vector Unsigned Saturated Subtract of Signed from Unsigned",null,[[["v16i8"],["v16u8"]],["v16u8"]]],[5,"__msa_subsus_u_h","","Vector Unsigned Saturated Subtract of Signed from Unsigned",null,[[["v8i16"],["v8u16"]],["v8u16"]]],[5,"__msa_subsus_u_w","","Vector Unsigned Saturated Subtract of Signed from Unsigned",null,[[["v4u32"],["v4i32"]],["v4u32"]]],[5,"__msa_subsus_u_d","","Vector Unsigned Saturated Subtract of Signed from Unsigned",null,[[["v2i64"],["v2u64"]],["v2u64"]]],[5,"__msa_subsuu_s_b","","Vector Signed Saturated Subtract of Unsigned Values",null,[[["v16u8"]],["v16i8"]]],[5,"__msa_subsuu_s_h","","Vector Signed Saturated Subtract of Unsigned Values",null,[[["v8u16"]],["v8i16"]]],[5,"__msa_subsuu_s_w","","Vector Signed Saturated Subtract of Unsigned Values",null,[[["v4u32"]],["v4i32"]]],[5,"__msa_subsuu_s_d","","Vector Signed Saturated Subtract of Unsigned Values",null,[[["v2u64"]],["v2i64"]]],[5,"__msa_subv_b","","Vector Subtract",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_subv_h","","Vector Subtract",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_subv_w","","Vector Subtract",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_subv_d","","Vector Subtract",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_subvi_b","","Immediate Subtract",null,[[["v16i8"],["i32"]],["v16i8"]]],[5,"__msa_subvi_h","","Immediate Subtract",null,[[["v8i16"],["i32"]],["v8i16"]]],[5,"__msa_subvi_w","","Immediate Subtract",null,[[["v4i32"],["i32"]],["v4i32"]]],[5,"__msa_subvi_d","","Immediate Subtract",null,[[["i32"],["v2i64"]],["v2i64"]]],[5,"__msa_vshf_b","","Vector Data Preserving Shuffle",null,[[["v16i8"]],["v16i8"]]],[5,"__msa_vshf_h","","Vector Data Preserving Shuffle",null,[[["v8i16"]],["v8i16"]]],[5,"__msa_vshf_w","","Vector Data Preserving Shuffle",null,[[["v4i32"]],["v4i32"]]],[5,"__msa_vshf_d","","Vector Data Preserving Shuffle",null,[[["v2i64"]],["v2i64"]]],[5,"__msa_xor_v","","Vector Logical Exclusive Or",null,[[["v16u8"]],["v16u8"]]],[5,"__msa_xori_b","","Immediate Logical Exclusive Or",null,[[["i32"],["v16u8"]],["v16u8"]]],[5,"break_","","Generates the trap instruction `BREAK`",null,[[]]],[0,"powerpc","core::arch","Platform-specific intrinsics for the `PowerPC` platform.",null,null],[3,"vector_signed_long","core::arch::powerpc","PowerPC-specific 128-bit wide vector of two packed `i64`",null,null],[3,"vector_unsigned_long","","PowerPC-specific 128-bit wide vector of two packed `u64`",null,null],[3,"vector_bool_long","","PowerPC-specific 128-bit wide vector mask of two elements",null,null],[3,"vector_double","","PowerPC-specific 128-bit wide vector of two packed `f64`",null,null],[5,"vec_xxpermdi","","Vector permute.",null,[[["t"],["u8"]],["t"]]],[5,"trap","","Generates the trap instruction `TRAP`",null,[[]]],[0,"powerpc64","core::arch","Platform-specific intrinsics for the `PowerPC64` platform.",null,null],[3,"vector_signed_long","core::arch::powerpc64","PowerPC-specific 128-bit wide vector of two packed `i64`",null,null],[3,"vector_unsigned_long","","PowerPC-specific 128-bit wide vector of two packed `u64`",null,null],[3,"vector_bool_long","","PowerPC-specific 128-bit wide vector mask of two elements",null,null],[3,"vector_double","","PowerPC-specific 128-bit wide vector of two packed `f64`",null,null],[5,"vec_xxpermdi","","Vector permute.",null,[[["t"],["u8"]],["t"]]],[5,"trap","","Generates the trap instruction `TRAP`",null,[[]]],[0,"nvptx","core::arch","Platform-specific intrinsics for the `NVPTX` platform.",null,null],[5,"_syncthreads","core::arch::nvptx","Synchronizes all threads in the block.",null,[[]]],[5,"_block_dim_x","","x-th thread-block dimension.",null,[[],["i32"]]],[5,"_block_dim_y","","y-th thread-block dimension.",null,[[],["i32"]]],[5,"_block_dim_z","","z-th thread-block dimension.",null,[[],["i32"]]],[5,"_block_idx_x","","x-th thread-block index.",null,[[],["i32"]]],[5,"_block_idx_y","","y-th thread-block index.",null,[[],["i32"]]],[5,"_block_idx_z","","z-th thread-block index.",null,[[],["i32"]]],[5,"_grid_dim_x","","x-th block-grid dimension.",null,[[],["i32"]]],[5,"_grid_dim_y","","y-th block-grid dimension.",null,[[],["i32"]]],[5,"_grid_dim_z","","z-th block-grid dimension.",null,[[],["i32"]]],[5,"_thread_idx_x","","x-th thread index.",null,[[],["i32"]]],[5,"_thread_idx_y","","y-th thread index.",null,[[],["i32"]]],[5,"_thread_idx_z","","z-th thread index.",null,[[],["i32"]]],[5,"trap","","Generates the trap instruction `TRAP`",null,[[]]],[5,"__assert_fail","","Syscall to be used whenever the assert expression produces…",null,[[["u32"]]]],[5,"vprintf","","Print formatted output from a kernel to a host-side output…",null,null],[5,"malloc","","Allocate memory dynamically from a fixed-size heap in…",null,null],[5,"free","","Free previously dynamically allocated memory.",null,null],[14,"panic","core","Panics the current thread.",null,null],[14,"assert_eq","","Asserts that two expressions are equal to each other…",null,null],[14,"assert_ne","","Asserts that two expressions are not equal to each other…",null,null],[14,"debug_assert","","Asserts that a boolean expression is `true` at runtime.",null,null],[14,"debug_assert_eq","","Asserts that two expressions are equal to each other.",null,null],[14,"debug_assert_ne","","Asserts that two expressions are not equal to each other.",null,null],[14,"matches","","Returns whether the given expression matches any of the…",null,null],[14,"try","","Unwraps a result or propagates its error.",null,null],[14,"write","","Writes formatted data into a buffer.",null,null],[14,"writeln","","Write formatted data into a buffer, with a newline appended.",null,null],[14,"unreachable","","Indicates unreachable code.",null,null],[14,"unimplemented","","Indicates unimplemented code by panicking with a message…",null,null],[14,"todo","","Indicates unfinished code.",null,null],[14,"compile_error","","Causes compilation to fail with the given error message…",null,null],[14,"format_args","","Constructs parameters for the other string-formatting…",null,null],[14,"format_args_nl","","Same as `format_args`, but adds a newline in the end.",null,null],[14,"env","","Inspects an environment variable at compile time.",null,null],[14,"option_env","","Optionally inspects an environment variable at compile time.",null,null],[14,"concat_idents","","Concatenates identifiers into one identifier.",null,null],[14,"concat","","Concatenates literals into a static string slice.",null,null],[14,"line","","Expands to the line number on which it was invoked.",null,null],[14,"column","","Expands to the column number at which it was invoked.",null,null],[14,"file","","Expands to the file name in which it was invoked.",null,null],[14,"stringify","","Stringifies its arguments.",null,null],[14,"include_str","","Includes a utf8-encoded file as a string.",null,null],[14,"include_bytes","","Includes a file as a reference to a byte array.",null,null],[14,"module_path","","Expands to a string that represents the current module path.",null,null],[14,"cfg","","Evaluates boolean combinations of configuration flags at…",null,null],[14,"include","","Parses a file as an expression or an item according to the…",null,null],[14,"assert","","Asserts that a boolean expression is `true` at runtime.",null,null],[14,"asm","","Inline assembly.",null,null],[14,"global_asm","","Module-level inline assembly.",null,null],[14,"log_syntax","","Prints passed tokens into the standard output.",null,null],[14,"trace_macros","","Enables or disables tracing functionality used for…",null,null],[14,"test","","Attribute macro applied to a function to turn it into a…",null,null],[14,"bench","","Attribute macro applied to a function to turn it into a…",null,null],[14,"test_case","","An implementation detail of the `#[test]` and `#[bench]`…",null,null],[14,"global_allocator","","Attribute macro applied to a static to register it as a…",null,null],[14,"RustcDecodable","","Unstable implementation detail of the `rustc` compiler, do…",null,null],[14,"RustcEncodable","","Unstable implementation detail of the `rustc` compiler, do…",null,null],[14,"Clone","","Derive macro generating an impl of the trait `Clone`.",null,null],[14,"PartialEq","","Derive macro generating an impl of the trait `PartialEq`.",null,null],[14,"Eq","","Derive macro generating an impl of the trait `Eq`.",null,null],[14,"Ord","","Derive macro generating an impl of the trait `Ord`.",null,null],[14,"PartialOrd","","Derive macro generating an impl of the trait `PartialOrd`.",null,null],[14,"Default","","Derive macro generating an impl of the trait `Default`.",null,null],[14,"Copy","","Derive macro generating an impl of the trait `Copy`.",null,null],[14,"Debug","","Derive macro generating an impl of the trait `Debug`.",null,null],[14,"Hash","","Derive macro generating an impl of the trait `Hash`.",null,null],[11,"borrow","core::num","",3,[[["self"]],["t"]]],[11,"borrow_mut","","",3,[[["self"]],["t"]]],[11,"into","","",3,[[],["u"]]],[11,"from","","",3,[[["t"]],["t"]]],[11,"try_into","","",3,[[],["result"]]],[11,"try_from","","",3,[[["u"]],["result"]]],[11,"type_id","","",3,[[["self"]],["typeid"]]],[11,"borrow","","",4,[[["self"]],["t"]]],[11,"borrow_mut","","",4,[[["self"]],["t"]]],[11,"into","","",4,[[],["u"]]],[11,"from","","",4,[[["t"]],["t"]]],[11,"try_into","","",4,[[],["result"]]],[11,"try_from","","",4,[[["u"]],["result"]]],[11,"type_id","","",4,[[["self"]],["typeid"]]],[11,"borrow","","",5,[[["self"]],["t"]]],[11,"borrow_mut","","",5,[[["self"]],["t"]]],[11,"into","","",5,[[],["u"]]],[11,"from","","",5,[[["t"]],["t"]]],[11,"try_into","","",5,[[],["result"]]],[11,"try_from","","",5,[[["u"]],["result"]]],[11,"type_id","","",5,[[["self"]],["typeid"]]],[11,"borrow","","",6,[[["self"]],["t"]]],[11,"borrow_mut","","",6,[[["self"]],["t"]]],[11,"into","","",6,[[],["u"]]],[11,"from","","",6,[[["t"]],["t"]]],[11,"try_into","","",6,[[],["result"]]],[11,"try_from","","",6,[[["u"]],["result"]]],[11,"type_id","","",6,[[["self"]],["typeid"]]],[11,"borrow","","",7,[[["self"]],["t"]]],[11,"borrow_mut","","",7,[[["self"]],["t"]]],[11,"into","","",7,[[],["u"]]],[11,"from","","",7,[[["t"]],["t"]]],[11,"try_into","","",7,[[],["result"]]],[11,"try_from","","",7,[[["u"]],["result"]]],[11,"type_id","","",7,[[["self"]],["typeid"]]],[11,"borrow","","",8,[[["self"]],["t"]]],[11,"borrow_mut","","",8,[[["self"]],["t"]]],[11,"into","","",8,[[],["u"]]],[11,"from","","",8,[[["t"]],["t"]]],[11,"try_into","","",8,[[],["result"]]],[11,"try_from","","",8,[[["u"]],["result"]]],[11,"type_id","","",8,[[["self"]],["typeid"]]],[11,"borrow","","",9,[[["self"]],["t"]]],[11,"borrow_mut","","",9,[[["self"]],["t"]]],[11,"into","","",9,[[],["u"]]],[11,"from","","",9,[[["t"]],["t"]]],[11,"try_into","","",9,[[],["result"]]],[11,"try_from","","",9,[[["u"]],["result"]]],[11,"type_id","","",9,[[["self"]],["typeid"]]],[11,"borrow","","",10,[[["self"]],["t"]]],[11,"borrow_mut","","",10,[[["self"]],["t"]]],[11,"into","","",10,[[],["u"]]],[11,"from","","",10,[[["t"]],["t"]]],[11,"try_into","","",10,[[],["result"]]],[11,"try_from","","",10,[[["u"]],["result"]]],[11,"type_id","","",10,[[["self"]],["typeid"]]],[11,"borrow","","",11,[[["self"]],["t"]]],[11,"borrow_mut","","",11,[[["self"]],["t"]]],[11,"into","","",11,[[],["u"]]],[11,"from","","",11,[[["t"]],["t"]]],[11,"try_into","","",11,[[],["result"]]],[11,"try_from","","",11,[[["u"]],["result"]]],[11,"type_id","","",11,[[["self"]],["typeid"]]],[11,"borrow","","",12,[[["self"]],["t"]]],[11,"borrow_mut","","",12,[[["self"]],["t"]]],[11,"into","","",12,[[],["u"]]],[11,"from","","",12,[[["t"]],["t"]]],[11,"try_into","","",12,[[],["result"]]],[11,"try_from","","",12,[[["u"]],["result"]]],[11,"type_id","","",12,[[["self"]],["typeid"]]],[11,"borrow","","",13,[[["self"]],["t"]]],[11,"borrow_mut","","",13,[[["self"]],["t"]]],[11,"into","","",13,[[],["u"]]],[11,"from","","",13,[[["t"]],["t"]]],[11,"try_into","","",13,[[],["result"]]],[11,"try_from","","",13,[[["u"]],["result"]]],[11,"type_id","","",13,[[["self"]],["typeid"]]],[11,"borrow","","",14,[[["self"]],["t"]]],[11,"borrow_mut","","",14,[[["self"]],["t"]]],[11,"into","","",14,[[],["u"]]],[11,"from","","",14,[[["t"]],["t"]]],[11,"try_into","","",14,[[],["result"]]],[11,"try_from","","",14,[[["u"]],["result"]]],[11,"type_id","","",14,[[["self"]],["typeid"]]],[11,"borrow","","",0,[[["self"]],["t"]]],[11,"borrow_mut","","",0,[[["self"]],["t"]]],[11,"into","","",0,[[],["u"]]],[11,"from","","",0,[[["t"]],["t"]]],[11,"try_into","","",0,[[],["result"]]],[11,"try_from","","",0,[[["u"]],["result"]]],[11,"type_id","","",0,[[["self"]],["typeid"]]],[11,"borrow","","",183,[[["self"]],["t"]]],[11,"borrow_mut","","",183,[[["self"]],["t"]]],[11,"into","","",183,[[],["u"]]],[11,"from","","",183,[[["t"]],["t"]]],[11,"from","","",183,[[],["t"]]],[11,"try_into","","",183,[[],["result"]]],[11,"try_from","","",183,[[["u"]],["result"]]],[11,"type_id","","",183,[[["self"]],["typeid"]]],[11,"borrow","","",15,[[["self"]],["t"]]],[11,"borrow_mut","","",15,[[["self"]],["t"]]],[11,"into","","",15,[[],["u"]]],[11,"from","","",15,[[["t"]],["t"]]],[11,"try_into","","",15,[[],["result"]]],[11,"try_from","","",15,[[["u"]],["result"]]],[11,"type_id","","",15,[[["self"]],["typeid"]]],[11,"borrow","","",184,[[["self"]],["t"]]],[11,"borrow_mut","","",184,[[["self"]],["t"]]],[11,"into","","",184,[[],["u"]]],[11,"from","","",184,[[["t"]],["t"]]],[11,"try_into","","",184,[[],["result"]]],[11,"try_from","","",184,[[["u"]],["result"]]],[11,"type_id","","",184,[[["self"]],["typeid"]]],[11,"borrow","","",1,[[["self"]],["t"]]],[11,"borrow_mut","","",1,[[["self"]],["t"]]],[11,"into","","",1,[[],["u"]]],[11,"from","","",1,[[["t"]],["t"]]],[11,"try_into","","",1,[[],["result"]]],[11,"try_from","","",1,[[["u"]],["result"]]],[11,"type_id","","",1,[[["self"]],["typeid"]]],[11,"borrow","","",2,[[["self"]],["t"]]],[11,"borrow_mut","","",2,[[["self"]],["t"]]],[11,"into","","",2,[[],["u"]]],[11,"from","","",2,[[["t"]],["t"]]],[11,"try_into","","",2,[[],["result"]]],[11,"try_from","","",2,[[["u"]],["result"]]],[11,"type_id","","",2,[[["self"]],["typeid"]]],[11,"borrow","core::mem","",16,[[["self"]],["t"]]],[11,"borrow_mut","","",16,[[["self"]],["t"]]],[11,"into","","",16,[[],["u"]]],[11,"from","","",16,[[["t"]],["t"]]],[11,"try_into","","",16,[[],["result"]]],[11,"try_from","","",16,[[["u"]],["result"]]],[11,"type_id","","",16,[[["self"]],["typeid"]]],[11,"borrow","","",185,[[["self"]],["t"]]],[11,"borrow_mut","","",185,[[["self"]],["t"]]],[11,"into","","",185,[[],["u"]]],[11,"from","","",185,[[["t"]],["t"]]],[11,"try_into","","",185,[[],["result"]]],[11,"try_from","","",185,[[["u"]],["result"]]],[11,"type_id","","",185,[[["self"]],["typeid"]]],[11,"borrow","","",17,[[["self"]],["t"]]],[11,"borrow_mut","","",17,[[["self"]],["t"]]],[11,"into","","",17,[[],["u"]]],[11,"from","","",17,[[["t"]],["t"]]],[11,"try_into","","",17,[[],["result"]]],[11,"try_from","","",17,[[["u"]],["result"]]],[11,"type_id","","",17,[[["self"]],["typeid"]]],[11,"borrow","core::ptr","",18,[[["self"]],["t"]]],[11,"borrow_mut","","",18,[[["self"]],["t"]]],[11,"into","","",18,[[],["u"]]],[11,"from","","",18,[[["t"]],["t"]]],[11,"try_into","","",18,[[],["result"]]],[11,"try_from","","",18,[[["u"]],["result"]]],[11,"type_id","","",18,[[["self"]],["typeid"]]],[11,"borrow","core::cmp","",22,[[["self"]],["t"]]],[11,"borrow_mut","","",22,[[["self"]],["t"]]],[11,"into","","",22,[[],["u"]]],[11,"from","","",22,[[["t"]],["t"]]],[11,"try_into","","",22,[[],["result"]]],[11,"try_from","","",22,[[["u"]],["result"]]],[11,"type_id","","",22,[[["self"]],["typeid"]]],[11,"borrow","","",23,[[["self"]],["t"]]],[11,"borrow_mut","","",23,[[["self"]],["t"]]],[11,"into","","",23,[[],["u"]]],[11,"from","","",23,[[["t"]],["t"]]],[11,"try_into","","",23,[[],["result"]]],[11,"try_from","","",23,[[["u"]],["result"]]],[11,"type_id","","",23,[[["self"]],["typeid"]]],[11,"borrow","core::convert","",186,[[["self"]],["t"]]],[11,"borrow_mut","","",186,[[["self"]],["t"]]],[11,"into","","",186,[[],["u"]]],[11,"from","","",186,[[["t"]],["t"]]],[11,"from","","",186,[[],["t"]]],[11,"try_into","","",186,[[],["result"]]],[11,"try_from","","",186,[[["u"]],["result"]]],[11,"type_id","","",186,[[["self"]],["typeid"]]],[11,"borrow","core::marker","",187,[[["self"]],["t"]]],[11,"borrow_mut","","",187,[[["self"]],["t"]]],[11,"into","","",187,[[],["u"]]],[11,"from","","",187,[[["t"]],["t"]]],[11,"try_into","","",187,[[],["result"]]],[11,"try_from","","",187,[[["u"]],["result"]]],[11,"type_id","","",187,[[["self"]],["typeid"]]],[11,"borrow","","",188,[[["self"]],["t"]]],[11,"borrow_mut","","",188,[[["self"]],["t"]]],[11,"into","","",188,[[],["u"]]],[11,"from","","",188,[[["t"]],["t"]]],[11,"try_into","","",188,[[],["result"]]],[11,"try_from","","",188,[[["u"]],["result"]]],[11,"type_id","","",188,[[["self"]],["typeid"]]],[11,"borrow","core::ops","",34,[[["self"]],["t"]]],[11,"borrow_mut","","",34,[[["self"]],["t"]]],[11,"into","","",34,[[],["u"]]],[11,"from","","",34,[[["t"]],["t"]]],[11,"try_into","","",34,[[],["result"]]],[11,"try_from","","",34,[[["u"]],["result"]]],[11,"type_id","","",34,[[["self"]],["typeid"]]],[11,"borrow","","",35,[[["self"]],["t"]]],[11,"borrow_mut","","",35,[[["self"]],["t"]]],[11,"into","","",35,[[],["u"]]],[11,"from","","",35,[[["t"]],["t"]]],[11,"try_into","","",35,[[],["result"]]],[11,"try_from","","",35,[[["u"]],["result"]]],[11,"type_id","","",35,[[["self"]],["typeid"]]],[11,"borrow","","",189,[[["self"]],["t"]]],[11,"borrow_mut","","",189,[[["self"]],["t"]]],[11,"into","","",189,[[],["u"]]],[11,"from","","",189,[[["t"]],["t"]]],[11,"try_into","","",189,[[],["result"]]],[11,"try_from","","",189,[[["u"]],["result"]]],[11,"type_id","","",189,[[["self"]],["typeid"]]],[11,"borrow","","",36,[[["self"]],["t"]]],[11,"borrow_mut","","",36,[[["self"]],["t"]]],[11,"into","","",36,[[],["u"]]],[11,"from","","",36,[[["t"]],["t"]]],[11,"try_into","","",36,[[],["result"]]],[11,"try_from","","",36,[[["u"]],["result"]]],[11,"type_id","","",36,[[["self"]],["typeid"]]],[11,"borrow","","",40,[[["self"]],["t"]]],[11,"borrow_mut","","",40,[[["self"]],["t"]]],[11,"into","","",40,[[],["u"]]],[11,"from","","",40,[[["t"]],["t"]]],[11,"try_into","","",40,[[],["result"]]],[11,"try_from","","",40,[[["u"]],["result"]]],[11,"type_id","","",40,[[["self"]],["typeid"]]],[11,"borrow","","",37,[[["self"]],["t"]]],[11,"borrow_mut","","",37,[[["self"]],["t"]]],[11,"into","","",37,[[],["u"]]],[11,"from","","",37,[[["t"]],["t"]]],[11,"try_into","","",37,[[],["result"]]],[11,"try_from","","",37,[[["u"]],["result"]]],[11,"type_id","","",37,[[["self"]],["typeid"]]],[11,"borrow","","",38,[[["self"]],["t"]]],[11,"borrow_mut","","",38,[[["self"]],["t"]]],[11,"into","","",38,[[],["u"]]],[11,"from","","",38,[[["t"]],["t"]]],[11,"try_into","","",38,[[],["result"]]],[11,"try_from","","",38,[[["u"]],["result"]]],[11,"type_id","","",38,[[["self"]],["typeid"]]],[11,"borrow","","",39,[[["self"]],["t"]]],[11,"borrow_mut","","",39,[[["self"]],["t"]]],[11,"into","","",39,[[],["u"]]],[11,"from","","",39,[[["t"]],["t"]]],[11,"try_into","","",39,[[],["result"]]],[11,"try_from","","",39,[[["u"]],["result"]]],[11,"type_id","","",39,[[["self"]],["typeid"]]],[11,"borrow","core::any","",75,[[["self"]],["t"]]],[11,"borrow_mut","","",75,[[["self"]],["t"]]],[11,"into","","",75,[[],["u"]]],[11,"from","","",75,[[["t"]],["t"]]],[11,"try_into","","",75,[[],["result"]]],[11,"try_from","","",75,[[["u"]],["result"]]],[11,"type_id","","",75,[[["self"]],["typeid"]]],[11,"borrow","core::array","",76,[[["self"]],["t"]]],[11,"borrow_mut","","",76,[[["self"]],["t"]]],[11,"into","","",76,[[],["u"]]],[11,"from","","",76,[[["t"]],["t"]]],[11,"try_into","","",76,[[],["result"]]],[11,"try_from","","",76,[[["u"]],["result"]]],[11,"type_id","","",76,[[["self"]],["typeid"]]],[11,"borrow","","",190,[[["self"]],["t"]]],[11,"borrow_mut","","",190,[[["self"]],["t"]]],[11,"into","","",190,[[],["u"]]],[11,"from","","",190,[[["t"]],["t"]]],[11,"try_into","","",190,[[],["result"]]],[11,"try_from","","",190,[[["u"]],["result"]]],[11,"type_id","","",190,[[["self"]],["typeid"]]],[11,"borrow","core::ascii","",191,[[["self"]],["t"]]],[11,"borrow_mut","","",191,[[["self"]],["t"]]],[11,"into","","",191,[[],["u"]]],[11,"from","","",191,[[["t"]],["t"]]],[11,"try_into","","",191,[[],["result"]]],[11,"try_from","","",191,[[["u"]],["result"]]],[11,"type_id","","",191,[[["self"]],["typeid"]]],[11,"borrow","core::cell","",78,[[["self"]],["t"]]],[11,"borrow_mut","","",78,[[["self"]],["t"]]],[11,"into","","",78,[[],["u"]]],[11,"from","","",78,[[["t"]],["t"]]],[11,"from","","",78,[[],["t"]]],[11,"try_into","","",78,[[],["result"]]],[11,"try_from","","",78,[[["u"]],["result"]]],[11,"type_id","","",78,[[["self"]],["typeid"]]],[11,"borrow","","",79,[[["self"]],["t"]]],[11,"borrow_mut","","",79,[[["self"]],["t"]]],[11,"into","","",79,[[],["u"]]],[11,"from","","",79,[[["t"]],["t"]]],[11,"from","","",79,[[],["t"]]],[11,"try_into","","",79,[[],["result"]]],[11,"try_from","","",79,[[["u"]],["result"]]],[11,"type_id","","",79,[[["self"]],["typeid"]]],[11,"borrow","","",192,[[["self"]],["t"]]],[11,"borrow_mut","","",192,[[["self"]],["t"]]],[11,"into","","",192,[[],["u"]]],[11,"from","","",192,[[["t"]],["t"]]],[11,"try_into","","",192,[[],["result"]]],[11,"try_from","","",192,[[["u"]],["result"]]],[11,"type_id","","",192,[[["self"]],["typeid"]]],[11,"borrow","","",193,[[["self"]],["t"]]],[11,"borrow_mut","","",193,[[["self"]],["t"]]],[11,"into","","",193,[[],["u"]]],[11,"from","","",193,[[["t"]],["t"]]],[11,"try_into","","",193,[[],["result"]]],[11,"try_from","","",193,[[["u"]],["result"]]],[11,"type_id","","",193,[[["self"]],["typeid"]]],[11,"borrow","","",80,[[["self"]],["t"]]],[11,"borrow_mut","","",80,[[["self"]],["t"]]],[11,"into","","",80,[[],["u"]]],[11,"from","","",80,[[["t"]],["t"]]],[11,"try_into","","",80,[[],["result"]]],[11,"try_from","","",80,[[["u"]],["result"]]],[11,"type_id","","",80,[[["self"]],["typeid"]]],[11,"borrow","","",81,[[["self"]],["t"]]],[11,"borrow_mut","","",81,[[["self"]],["t"]]],[11,"into","","",81,[[],["u"]]],[11,"from","","",81,[[["t"]],["t"]]],[11,"try_into","","",81,[[],["result"]]],[11,"try_from","","",81,[[["u"]],["result"]]],[11,"type_id","","",81,[[["self"]],["typeid"]]],[11,"borrow","","",82,[[["self"]],["t"]]],[11,"borrow_mut","","",82,[[["self"]],["t"]]],[11,"into","","",82,[[],["u"]]],[11,"from","","",82,[[["t"]],["t"]]],[11,"from","","",82,[[],["t"]]],[11,"try_into","","",82,[[],["result"]]],[11,"try_from","","",82,[[["u"]],["result"]]],[11,"type_id","","",82,[[["self"]],["typeid"]]],[11,"borrow","core::char","",194,[[["self"]],["t"]]],[11,"borrow_mut","","",194,[[["self"]],["t"]]],[11,"into","","",194,[[],["u"]]],[11,"from","","",194,[[["t"]],["t"]]],[11,"try_into","","",194,[[],["result"]]],[11,"try_from","","",194,[[["u"]],["result"]]],[11,"type_id","","",194,[[["self"]],["typeid"]]],[11,"borrow","","",195,[[["self"]],["t"]]],[11,"borrow_mut","","",195,[[["self"]],["t"]]],[11,"into","","",195,[[],["u"]]],[11,"from","","",195,[[["t"]],["t"]]],[11,"try_into","","",195,[[],["result"]]],[11,"try_from","","",195,[[["u"]],["result"]]],[11,"type_id","","",195,[[["self"]],["typeid"]]],[11,"borrow","","",196,[[["self"]],["t"]]],[11,"borrow_mut","","",196,[[["self"]],["t"]]],[11,"into","","",196,[[],["u"]]],[11,"from","","",196,[[["t"]],["t"]]],[11,"try_into","","",196,[[],["result"]]],[11,"try_from","","",196,[[["u"]],["result"]]],[11,"type_id","","",196,[[["self"]],["typeid"]]],[11,"borrow","","",84,[[["self"]],["t"]]],[11,"borrow_mut","","",84,[[["self"]],["t"]]],[11,"into","","",84,[[],["u"]]],[11,"from","","",84,[[["t"]],["t"]]],[11,"try_into","","",84,[[],["result"]]],[11,"try_from","","",84,[[["u"]],["result"]]],[11,"type_id","","",84,[[["self"]],["typeid"]]],[11,"borrow","","",83,[[["self"]],["t"]]],[11,"borrow_mut","","",83,[[["self"]],["t"]]],[11,"into","","",83,[[],["u"]]],[11,"from","","",83,[[["t"]],["t"]]],[11,"try_into","","",83,[[],["result"]]],[11,"try_from","","",83,[[["u"]],["result"]]],[11,"type_id","","",83,[[["self"]],["typeid"]]],[11,"borrow","","",197,[[["self"]],["t"]]],[11,"borrow_mut","","",197,[[["self"]],["t"]]],[11,"into","","",197,[[],["u"]]],[11,"from","","",197,[[["t"]],["t"]]],[11,"try_into","","",197,[[],["result"]]],[11,"try_from","","",197,[[["u"]],["result"]]],[11,"type_id","","",197,[[["self"]],["typeid"]]],[11,"borrow","","",198,[[["self"]],["t"]]],[11,"borrow_mut","","",198,[[["self"]],["t"]]],[11,"into","","",198,[[],["u"]]],[11,"from","","",198,[[["t"]],["t"]]],[11,"try_into","","",198,[[],["result"]]],[11,"try_from","","",198,[[["u"]],["result"]]],[11,"type_id","","",198,[[["self"]],["typeid"]]],[11,"borrow","","",199,[[["self"]],["t"]]],[11,"borrow_mut","","",199,[[["self"]],["t"]]],[11,"into","","",199,[[],["u"]]],[11,"from","","",199,[[["t"]],["t"]]],[11,"try_into","","",199,[[],["result"]]],[11,"try_from","","",199,[[["u"]],["result"]]],[11,"type_id","","",199,[[["self"]],["typeid"]]],[11,"borrow","","",200,[[["self"]],["t"]]],[11,"borrow_mut","","",200,[[["self"]],["t"]]],[11,"into","","",200,[[],["u"]]],[11,"from","","",200,[[["t"]],["t"]]],[11,"try_into","","",200,[[],["result"]]],[11,"try_from","","",200,[[["u"]],["result"]]],[11,"type_id","","",200,[[["self"]],["typeid"]]],[11,"borrow","","",201,[[["self"]],["t"]]],[11,"borrow_mut","","",201,[[["self"]],["t"]]],[11,"into","","",201,[[],["u"]]],[11,"from","","",201,[[["t"]],["t"]]],[11,"try_into","","",201,[[],["result"]]],[11,"try_from","","",201,[[["u"]],["result"]]],[11,"type_id","","",201,[[["self"]],["typeid"]]],[11,"borrow","core::ffi","",85,[[["self"]],["t"]]],[11,"borrow_mut","","",85,[[["self"]],["t"]]],[11,"into","","",85,[[],["u"]]],[11,"from","","",85,[[["t"]],["t"]]],[11,"try_into","","",85,[[],["result"]]],[11,"try_from","","",85,[[["u"]],["result"]]],[11,"type_id","","",85,[[["self"]],["typeid"]]],[11,"borrow","","",202,[[["self"]],["t"]]],[11,"borrow_mut","","",202,[[["self"]],["t"]]],[11,"into","","",202,[[],["u"]]],[11,"from","","",202,[[["t"]],["t"]]],[11,"try_into","","",202,[[],["result"]]],[11,"try_from","","",202,[[["u"]],["result"]]],[11,"type_id","","",202,[[["self"]],["typeid"]]],[11,"borrow","","",203,[[["self"]],["t"]]],[11,"borrow_mut","","",203,[[["self"]],["t"]]],[11,"into","","",203,[[],["u"]]],[11,"from","","",203,[[["t"]],["t"]]],[11,"try_into","","",203,[[],["result"]]],[11,"try_from","","",203,[[["u"]],["result"]]],[11,"type_id","","",203,[[["self"]],["typeid"]]],[11,"borrow","core::iter","",204,[[["self"]],["t"]]],[11,"borrow_mut","","",204,[[["self"]],["t"]]],[11,"into","","",204,[[],["u"]]],[11,"from","","",204,[[["t"]],["t"]]],[11,"try_into","","",204,[[],["result"]]],[11,"try_from","","",204,[[["u"]],["result"]]],[11,"type_id","","",204,[[["self"]],["typeid"]]],[11,"borrow","","",205,[[["self"]],["t"]]],[11,"borrow_mut","","",205,[[["self"]],["t"]]],[11,"into","","",205,[[],["u"]]],[11,"from","","",205,[[["t"]],["t"]]],[11,"try_into","","",205,[[],["result"]]],[11,"try_from","","",205,[[["u"]],["result"]]],[11,"type_id","","",205,[[["self"]],["typeid"]]],[11,"borrow","","",206,[[["self"]],["t"]]],[11,"borrow_mut","","",206,[[["self"]],["t"]]],[11,"into","","",206,[[],["u"]]],[11,"from","","",206,[[["t"]],["t"]]],[11,"try_into","","",206,[[],["result"]]],[11,"try_from","","",206,[[["u"]],["result"]]],[11,"type_id","","",206,[[["self"]],["typeid"]]],[11,"borrow","","",207,[[["self"]],["t"]]],[11,"borrow_mut","","",207,[[["self"]],["t"]]],[11,"into","","",207,[[],["u"]]],[11,"from","","",207,[[["t"]],["t"]]],[11,"try_into","","",207,[[],["result"]]],[11,"try_from","","",207,[[["u"]],["result"]]],[11,"type_id","","",207,[[["self"]],["typeid"]]],[11,"borrow","","",208,[[["self"]],["t"]]],[11,"borrow_mut","","",208,[[["self"]],["t"]]],[11,"into","","",208,[[],["u"]]],[11,"from","","",208,[[["t"]],["t"]]],[11,"try_into","","",208,[[],["result"]]],[11,"try_from","","",208,[[["u"]],["result"]]],[11,"type_id","","",208,[[["self"]],["typeid"]]],[11,"borrow","","",209,[[["self"]],["t"]]],[11,"borrow_mut","","",209,[[["self"]],["t"]]],[11,"into","","",209,[[],["u"]]],[11,"from","","",209,[[["t"]],["t"]]],[11,"try_into","","",209,[[],["result"]]],[11,"try_from","","",209,[[["u"]],["result"]]],[11,"type_id","","",209,[[["self"]],["typeid"]]],[11,"borrow","","",210,[[["self"]],["t"]]],[11,"borrow_mut","","",210,[[["self"]],["t"]]],[11,"into","","",210,[[],["u"]]],[11,"from","","",210,[[["t"]],["t"]]],[11,"try_into","","",210,[[],["result"]]],[11,"try_from","","",210,[[["u"]],["result"]]],[11,"type_id","","",210,[[["self"]],["typeid"]]],[11,"borrow","","",211,[[["self"]],["t"]]],[11,"borrow_mut","","",211,[[["self"]],["t"]]],[11,"into","","",211,[[],["u"]]],[11,"from","","",211,[[["t"]],["t"]]],[11,"try_into","","",211,[[],["result"]]],[11,"try_from","","",211,[[["u"]],["result"]]],[11,"type_id","","",211,[[["self"]],["typeid"]]],[11,"borrow","","",212,[[["self"]],["t"]]],[11,"borrow_mut","","",212,[[["self"]],["t"]]],[11,"into","","",212,[[],["u"]]],[11,"from","","",212,[[["t"]],["t"]]],[11,"try_into","","",212,[[],["result"]]],[11,"try_from","","",212,[[["u"]],["result"]]],[11,"type_id","","",212,[[["self"]],["typeid"]]],[11,"borrow","","",213,[[["self"]],["t"]]],[11,"borrow_mut","","",213,[[["self"]],["t"]]],[11,"into","","",213,[[],["u"]]],[11,"from","","",213,[[["t"]],["t"]]],[11,"try_into","","",213,[[],["result"]]],[11,"try_from","","",213,[[["u"]],["result"]]],[11,"type_id","","",213,[[["self"]],["typeid"]]],[11,"borrow","","",214,[[["self"]],["t"]]],[11,"borrow_mut","","",214,[[["self"]],["t"]]],[11,"into","","",214,[[],["u"]]],[11,"from","","",214,[[["t"]],["t"]]],[11,"try_into","","",214,[[],["result"]]],[11,"try_from","","",214,[[["u"]],["result"]]],[11,"type_id","","",214,[[["self"]],["typeid"]]],[11,"borrow","","",215,[[["self"]],["t"]]],[11,"borrow_mut","","",215,[[["self"]],["t"]]],[11,"into","","",215,[[],["u"]]],[11,"from","","",215,[[["t"]],["t"]]],[11,"try_into","","",215,[[],["result"]]],[11,"try_from","","",215,[[["u"]],["result"]]],[11,"type_id","","",215,[[["self"]],["typeid"]]],[11,"borrow","","",216,[[["self"]],["t"]]],[11,"borrow_mut","","",216,[[["self"]],["t"]]],[11,"into","","",216,[[],["u"]]],[11,"from","","",216,[[["t"]],["t"]]],[11,"try_into","","",216,[[],["result"]]],[11,"try_from","","",216,[[["u"]],["result"]]],[11,"type_id","","",216,[[["self"]],["typeid"]]],[11,"borrow","","",217,[[["self"]],["t"]]],[11,"borrow_mut","","",217,[[["self"]],["t"]]],[11,"into","","",217,[[],["u"]]],[11,"from","","",217,[[["t"]],["t"]]],[11,"try_into","","",217,[[],["result"]]],[11,"try_from","","",217,[[["u"]],["result"]]],[11,"type_id","","",217,[[["self"]],["typeid"]]],[11,"borrow","","",218,[[["self"]],["t"]]],[11,"borrow_mut","","",218,[[["self"]],["t"]]],[11,"into","","",218,[[],["u"]]],[11,"from","","",218,[[["t"]],["t"]]],[11,"try_into","","",218,[[],["result"]]],[11,"try_from","","",218,[[["u"]],["result"]]],[11,"type_id","","",218,[[["self"]],["typeid"]]],[11,"borrow","","",219,[[["self"]],["t"]]],[11,"borrow_mut","","",219,[[["self"]],["t"]]],[11,"into","","",219,[[],["u"]]],[11,"from","","",219,[[["t"]],["t"]]],[11,"try_into","","",219,[[],["result"]]],[11,"try_from","","",219,[[["u"]],["result"]]],[11,"type_id","","",219,[[["self"]],["typeid"]]],[11,"borrow","","",220,[[["self"]],["t"]]],[11,"borrow_mut","","",220,[[["self"]],["t"]]],[11,"into","","",220,[[],["u"]]],[11,"from","","",220,[[["t"]],["t"]]],[11,"try_into","","",220,[[],["result"]]],[11,"try_from","","",220,[[["u"]],["result"]]],[11,"type_id","","",220,[[["self"]],["typeid"]]],[11,"borrow","","",221,[[["self"]],["t"]]],[11,"borrow_mut","","",221,[[["self"]],["t"]]],[11,"into","","",221,[[],["u"]]],[11,"from","","",221,[[["t"]],["t"]]],[11,"try_into","","",221,[[],["result"]]],[11,"try_from","","",221,[[["u"]],["result"]]],[11,"type_id","","",221,[[["self"]],["typeid"]]],[11,"borrow","","",222,[[["self"]],["t"]]],[11,"borrow_mut","","",222,[[["self"]],["t"]]],[11,"into","","",222,[[],["u"]]],[11,"from","","",222,[[["t"]],["t"]]],[11,"try_into","","",222,[[],["result"]]],[11,"try_from","","",222,[[["u"]],["result"]]],[11,"type_id","","",222,[[["self"]],["typeid"]]],[11,"borrow","","",223,[[["self"]],["t"]]],[11,"borrow_mut","","",223,[[["self"]],["t"]]],[11,"into","","",223,[[],["u"]]],[11,"from","","",223,[[["t"]],["t"]]],[11,"try_into","","",223,[[],["result"]]],[11,"try_from","","",223,[[["u"]],["result"]]],[11,"type_id","","",223,[[["self"]],["typeid"]]],[11,"borrow","","",224,[[["self"]],["t"]]],[11,"borrow_mut","","",224,[[["self"]],["t"]]],[11,"into","","",224,[[],["u"]]],[11,"from","","",224,[[["t"]],["t"]]],[11,"try_into","","",224,[[],["result"]]],[11,"try_from","","",224,[[["u"]],["result"]]],[11,"type_id","","",224,[[["self"]],["typeid"]]],[11,"borrow","","",86,[[["self"]],["t"]]],[11,"borrow_mut","","",86,[[["self"]],["t"]]],[11,"into","","",86,[[],["u"]]],[11,"from","","",86,[[["t"]],["t"]]],[11,"try_into","","",86,[[],["result"]]],[11,"try_from","","",86,[[["u"]],["result"]]],[11,"type_id","","",86,[[["self"]],["typeid"]]],[11,"borrow","","",225,[[["self"]],["t"]]],[11,"borrow_mut","","",225,[[["self"]],["t"]]],[11,"into","","",225,[[],["u"]]],[11,"from","","",225,[[["t"]],["t"]]],[11,"try_into","","",225,[[],["result"]]],[11,"try_from","","",225,[[["u"]],["result"]]],[11,"type_id","","",225,[[["self"]],["typeid"]]],[11,"borrow","","",226,[[["self"]],["t"]]],[11,"borrow_mut","","",226,[[["self"]],["t"]]],[11,"into","","",226,[[],["u"]]],[11,"from","","",226,[[["t"]],["t"]]],[11,"try_into","","",226,[[],["result"]]],[11,"try_from","","",226,[[["u"]],["result"]]],[11,"type_id","","",226,[[["self"]],["typeid"]]],[11,"borrow","","",227,[[["self"]],["t"]]],[11,"borrow_mut","","",227,[[["self"]],["t"]]],[11,"into","","",227,[[],["u"]]],[11,"from","","",227,[[["t"]],["t"]]],[11,"try_into","","",227,[[],["result"]]],[11,"try_from","","",227,[[["u"]],["result"]]],[11,"type_id","","",227,[[["self"]],["typeid"]]],[11,"borrow","","",228,[[["self"]],["t"]]],[11,"borrow_mut","","",228,[[["self"]],["t"]]],[11,"into","","",228,[[],["u"]]],[11,"from","","",228,[[["t"]],["t"]]],[11,"try_into","","",228,[[],["result"]]],[11,"try_from","","",228,[[["u"]],["result"]]],[11,"type_id","","",228,[[["self"]],["typeid"]]],[11,"borrow","","",229,[[["self"]],["t"]]],[11,"borrow_mut","","",229,[[["self"]],["t"]]],[11,"into","","",229,[[],["u"]]],[11,"from","","",229,[[["t"]],["t"]]],[11,"try_into","","",229,[[],["result"]]],[11,"try_from","","",229,[[["u"]],["result"]]],[11,"type_id","","",229,[[["self"]],["typeid"]]],[11,"borrow","","",230,[[["self"]],["t"]]],[11,"borrow_mut","","",230,[[["self"]],["t"]]],[11,"into","","",230,[[],["u"]]],[11,"from","","",230,[[["t"]],["t"]]],[11,"try_into","","",230,[[],["result"]]],[11,"try_from","","",230,[[["u"]],["result"]]],[11,"type_id","","",230,[[["self"]],["typeid"]]],[11,"borrow","","",231,[[["self"]],["t"]]],[11,"borrow_mut","","",231,[[["self"]],["t"]]],[11,"into","","",231,[[],["u"]]],[11,"from","","",231,[[["t"]],["t"]]],[11,"try_into","","",231,[[],["result"]]],[11,"try_from","","",231,[[["u"]],["result"]]],[11,"type_id","","",231,[[["self"]],["typeid"]]],[11,"borrow","core::option","",232,[[["self"]],["t"]]],[11,"borrow_mut","","",232,[[["self"]],["t"]]],[11,"into","","",232,[[],["u"]]],[11,"from","","",232,[[["t"]],["t"]]],[11,"try_into","","",232,[[],["result"]]],[11,"try_from","","",232,[[["u"]],["result"]]],[11,"type_id","","",232,[[["self"]],["typeid"]]],[11,"borrow","","",233,[[["self"]],["t"]]],[11,"borrow_mut","","",233,[[["self"]],["t"]]],[11,"into","","",233,[[],["u"]]],[11,"from","","",233,[[["t"]],["t"]]],[11,"try_into","","",233,[[],["result"]]],[11,"try_from","","",233,[[["u"]],["result"]]],[11,"type_id","","",233,[[["self"]],["typeid"]]],[11,"borrow","","",234,[[["self"]],["t"]]],[11,"borrow_mut","","",234,[[["self"]],["t"]]],[11,"into","","",234,[[],["u"]]],[11,"from","","",234,[[["t"]],["t"]]],[11,"try_into","","",234,[[],["result"]]],[11,"try_from","","",234,[[["u"]],["result"]]],[11,"type_id","","",234,[[["self"]],["typeid"]]],[11,"borrow","","",235,[[["self"]],["t"]]],[11,"borrow_mut","","",235,[[["self"]],["t"]]],[11,"into","","",235,[[],["u"]]],[11,"from","","",235,[[["t"]],["t"]]],[11,"try_into","","",235,[[],["result"]]],[11,"try_from","","",235,[[["u"]],["result"]]],[11,"type_id","","",235,[[["self"]],["typeid"]]],[11,"borrow","","",96,[[["self"]],["t"]]],[11,"borrow_mut","","",96,[[["self"]],["t"]]],[11,"into","","",96,[[],["u"]]],[11,"from","","",96,[[["t"]],["t"]]],[11,"from","","",96,[[],["t"]]],[11,"try_into","","",96,[[],["result"]]],[11,"try_from","","",96,[[["u"]],["result"]]],[11,"type_id","","",96,[[["self"]],["typeid"]]],[11,"borrow","core::panic","",97,[[["self"]],["t"]]],[11,"borrow_mut","","",97,[[["self"]],["t"]]],[11,"into","","",97,[[],["u"]]],[11,"from","","",97,[[["t"]],["t"]]],[11,"try_into","","",97,[[],["result"]]],[11,"try_from","","",97,[[["u"]],["result"]]],[11,"type_id","","",97,[[["self"]],["typeid"]]],[11,"borrow","","",98,[[["self"]],["t"]]],[11,"borrow_mut","","",98,[[["self"]],["t"]]],[11,"into","","",98,[[],["u"]]],[11,"from","","",98,[[["t"]],["t"]]],[11,"try_into","","",98,[[],["result"]]],[11,"try_from","","",98,[[["u"]],["result"]]],[11,"type_id","","",98,[[["self"]],["typeid"]]],[11,"borrow","core::pin","",99,[[["self"]],["t"]]],[11,"borrow_mut","","",99,[[["self"]],["t"]]],[11,"into","","",99,[[],["u"]]],[11,"from","","",99,[[["t"]],["t"]]],[11,"try_into","","",99,[[],["result"]]],[11,"try_from","","",99,[[["u"]],["result"]]],[11,"type_id","","",99,[[["self"]],["typeid"]]],[11,"borrow","core::raw","",100,[[["self"]],["t"]]],[11,"borrow_mut","","",100,[[["self"]],["t"]]],[11,"into","","",100,[[],["u"]]],[11,"from","","",100,[[["t"]],["t"]]],[11,"try_into","","",100,[[],["result"]]],[11,"try_from","","",100,[[["u"]],["result"]]],[11,"type_id","","",100,[[["self"]],["typeid"]]],[11,"borrow","core::result","",236,[[["self"]],["t"]]],[11,"borrow_mut","","",236,[[["self"]],["t"]]],[11,"into","","",236,[[],["u"]]],[11,"from","","",236,[[["t"]],["t"]]],[11,"try_into","","",236,[[],["result"]]],[11,"try_from","","",236,[[["u"]],["result"]]],[11,"type_id","","",236,[[["self"]],["typeid"]]],[11,"borrow","","",237,[[["self"]],["t"]]],[11,"borrow_mut","","",237,[[["self"]],["t"]]],[11,"into","","",237,[[],["u"]]],[11,"from","","",237,[[["t"]],["t"]]],[11,"try_into","","",237,[[],["result"]]],[11,"try_from","","",237,[[["u"]],["result"]]],[11,"type_id","","",237,[[["self"]],["typeid"]]],[11,"borrow","","",238,[[["self"]],["t"]]],[11,"borrow_mut","","",238,[[["self"]],["t"]]],[11,"into","","",238,[[],["u"]]],[11,"from","","",238,[[["t"]],["t"]]],[11,"try_into","","",238,[[],["result"]]],[11,"try_from","","",238,[[["u"]],["result"]]],[11,"type_id","","",238,[[["self"]],["typeid"]]],[11,"borrow","","",101,[[["self"]],["t"]]],[11,"borrow_mut","","",101,[[["self"]],["t"]]],[11,"into","","",101,[[],["u"]]],[11,"from","","",101,[[["t"]],["t"]]],[11,"try_into","","",101,[[],["result"]]],[11,"try_from","","",101,[[["u"]],["result"]]],[11,"type_id","","",101,[[["self"]],["typeid"]]],[11,"borrow","core::sync::atomic","",103,[[["self"]],["t"]]],[11,"borrow_mut","","",103,[[["self"]],["t"]]],[11,"into","","",103,[[],["u"]]],[11,"from","","",103,[[["t"]],["t"]]],[11,"try_into","","",103,[[],["result"]]],[11,"try_from","","",103,[[["u"]],["result"]]],[11,"type_id","","",103,[[["self"]],["typeid"]]],[11,"borrow","","",104,[[["self"]],["t"]]],[11,"borrow_mut","","",104,[[["self"]],["t"]]],[11,"into","","",104,[[],["u"]]],[11,"from","","",104,[[["t"]],["t"]]],[11,"try_into","","",104,[[],["result"]]],[11,"try_from","","",104,[[["u"]],["result"]]],[11,"type_id","","",104,[[["self"]],["typeid"]]],[11,"borrow","","",105,[[["self"]],["t"]]],[11,"borrow_mut","","",105,[[["self"]],["t"]]],[11,"into","","",105,[[],["u"]]],[11,"from","","",105,[[["t"]],["t"]]],[11,"try_into","","",105,[[],["result"]]],[11,"try_from","","",105,[[["u"]],["result"]]],[11,"type_id","","",105,[[["self"]],["typeid"]]],[11,"borrow","","",106,[[["self"]],["t"]]],[11,"borrow_mut","","",106,[[["self"]],["t"]]],[11,"into","","",106,[[],["u"]]],[11,"from","","",106,[[["t"]],["t"]]],[11,"try_into","","",106,[[],["result"]]],[11,"try_from","","",106,[[["u"]],["result"]]],[11,"type_id","","",106,[[["self"]],["typeid"]]],[11,"borrow","","",107,[[["self"]],["t"]]],[11,"borrow_mut","","",107,[[["self"]],["t"]]],[11,"into","","",107,[[],["u"]]],[11,"from","","",107,[[["t"]],["t"]]],[11,"try_into","","",107,[[],["result"]]],[11,"try_from","","",107,[[["u"]],["result"]]],[11,"type_id","","",107,[[["self"]],["typeid"]]],[11,"borrow","","",108,[[["self"]],["t"]]],[11,"borrow_mut","","",108,[[["self"]],["t"]]],[11,"into","","",108,[[],["u"]]],[11,"from","","",108,[[["t"]],["t"]]],[11,"try_into","","",108,[[],["result"]]],[11,"try_from","","",108,[[["u"]],["result"]]],[11,"type_id","","",108,[[["self"]],["typeid"]]],[11,"borrow","","",109,[[["self"]],["t"]]],[11,"borrow_mut","","",109,[[["self"]],["t"]]],[11,"into","","",109,[[],["u"]]],[11,"from","","",109,[[["t"]],["t"]]],[11,"try_into","","",109,[[],["result"]]],[11,"try_from","","",109,[[["u"]],["result"]]],[11,"type_id","","",109,[[["self"]],["typeid"]]],[11,"borrow","","",110,[[["self"]],["t"]]],[11,"borrow_mut","","",110,[[["self"]],["t"]]],[11,"into","","",110,[[],["u"]]],[11,"from","","",110,[[["t"]],["t"]]],[11,"try_into","","",110,[[],["result"]]],[11,"try_from","","",110,[[["u"]],["result"]]],[11,"type_id","","",110,[[["self"]],["typeid"]]],[11,"borrow","","",111,[[["self"]],["t"]]],[11,"borrow_mut","","",111,[[["self"]],["t"]]],[11,"into","","",111,[[],["u"]]],[11,"from","","",111,[[["t"]],["t"]]],[11,"try_into","","",111,[[],["result"]]],[11,"try_from","","",111,[[["u"]],["result"]]],[11,"type_id","","",111,[[["self"]],["typeid"]]],[11,"borrow","","",112,[[["self"]],["t"]]],[11,"borrow_mut","","",112,[[["self"]],["t"]]],[11,"into","","",112,[[],["u"]]],[11,"from","","",112,[[["t"]],["t"]]],[11,"try_into","","",112,[[],["result"]]],[11,"try_from","","",112,[[["u"]],["result"]]],[11,"type_id","","",112,[[["self"]],["typeid"]]],[11,"borrow","","",113,[[["self"]],["t"]]],[11,"borrow_mut","","",113,[[["self"]],["t"]]],[11,"into","","",113,[[],["u"]]],[11,"from","","",113,[[["t"]],["t"]]],[11,"try_into","","",113,[[],["result"]]],[11,"try_from","","",113,[[["u"]],["result"]]],[11,"type_id","","",113,[[["self"]],["typeid"]]],[11,"borrow","","",114,[[["self"]],["t"]]],[11,"borrow_mut","","",114,[[["self"]],["t"]]],[11,"into","","",114,[[],["u"]]],[11,"from","","",114,[[["t"]],["t"]]],[11,"try_into","","",114,[[],["result"]]],[11,"try_from","","",114,[[["u"]],["result"]]],[11,"type_id","","",114,[[["self"]],["typeid"]]],[11,"borrow","","",102,[[["self"]],["t"]]],[11,"borrow_mut","","",102,[[["self"]],["t"]]],[11,"into","","",102,[[],["u"]]],[11,"from","","",102,[[["t"]],["t"]]],[11,"try_into","","",102,[[],["result"]]],[11,"try_from","","",102,[[["u"]],["result"]]],[11,"type_id","","",102,[[["self"]],["typeid"]]],[11,"borrow","core::fmt","",119,[[["self"]],["t"]]],[11,"borrow_mut","","",119,[[["self"]],["t"]]],[11,"into","","",119,[[],["u"]]],[11,"from","","",119,[[["t"]],["t"]]],[11,"try_into","","",119,[[],["result"]]],[11,"try_from","","",119,[[["u"]],["result"]]],[11,"type_id","","",119,[[["self"]],["typeid"]]],[11,"borrow","","",120,[[["self"]],["t"]]],[11,"borrow_mut","","",120,[[["self"]],["t"]]],[11,"into","","",120,[[],["u"]]],[11,"from","","",120,[[["t"]],["t"]]],[11,"try_into","","",120,[[],["result"]]],[11,"try_from","","",120,[[["u"]],["result"]]],[11,"type_id","","",120,[[["self"]],["typeid"]]],[11,"borrow","","",118,[[["self"]],["t"]]],[11,"borrow_mut","","",118,[[["self"]],["t"]]],[11,"into","","",118,[[],["u"]]],[11,"from","","",118,[[["t"]],["t"]]],[11,"try_into","","",118,[[],["result"]]],[11,"try_from","","",118,[[["u"]],["result"]]],[11,"type_id","","",118,[[["self"]],["typeid"]]],[11,"borrow","","",116,[[["self"]],["t"]]],[11,"borrow_mut","","",116,[[["self"]],["t"]]],[11,"into","","",116,[[],["u"]]],[11,"from","","",116,[[["t"]],["t"]]],[11,"try_into","","",116,[[],["result"]]],[11,"try_from","","",116,[[["u"]],["result"]]],[11,"type_id","","",116,[[["self"]],["typeid"]]],[11,"borrow","","",117,[[["self"]],["t"]]],[11,"borrow_mut","","",117,[[["self"]],["t"]]],[11,"into","","",117,[[],["u"]]],[11,"from","","",117,[[["t"]],["t"]]],[11,"try_into","","",117,[[],["result"]]],[11,"try_from","","",117,[[["u"]],["result"]]],[11,"type_id","","",117,[[["self"]],["typeid"]]],[11,"borrow","","",239,[[["self"]],["t"]]],[11,"borrow_mut","","",239,[[["self"]],["t"]]],[11,"into","","",239,[[],["u"]]],[11,"from","","",239,[[["t"]],["t"]]],[11,"try_into","","",239,[[],["result"]]],[11,"try_from","","",239,[[["u"]],["result"]]],[11,"type_id","","",239,[[["self"]],["typeid"]]],[11,"borrow","","",131,[[["self"]],["t"]]],[11,"borrow_mut","","",131,[[["self"]],["t"]]],[11,"into","","",131,[[],["u"]]],[11,"from","","",131,[[["t"]],["t"]]],[11,"try_into","","",131,[[],["result"]]],[11,"try_from","","",131,[[["u"]],["result"]]],[11,"type_id","","",131,[[["self"]],["typeid"]]],[11,"borrow","","",240,[[["self"]],["t"]]],[11,"borrow_mut","","",240,[[["self"]],["t"]]],[11,"into","","",240,[[],["u"]]],[11,"from","","",240,[[["t"]],["t"]]],[11,"try_into","","",240,[[],["result"]]],[11,"try_from","","",240,[[["u"]],["result"]]],[11,"type_id","","",240,[[["self"]],["typeid"]]],[11,"borrow","","",115,[[["self"]],["t"]]],[11,"borrow_mut","","",115,[[["self"]],["t"]]],[11,"into","","",115,[[],["u"]]],[11,"from","","",115,[[["t"]],["t"]]],[11,"try_into","","",115,[[],["result"]]],[11,"try_from","","",115,[[["u"]],["result"]]],[11,"type_id","","",115,[[["self"]],["typeid"]]],[11,"borrow","core::hash","",132,[[["self"]],["t"]]],[11,"borrow_mut","","",132,[[["self"]],["t"]]],[11,"into","","",132,[[],["u"]]],[11,"from","","",132,[[["t"]],["t"]]],[11,"try_into","","",132,[[],["result"]]],[11,"try_from","","",132,[[["u"]],["result"]]],[11,"type_id","","",132,[[["self"]],["typeid"]]],[11,"borrow","","",241,[[["self"]],["t"]]],[11,"borrow_mut","","",241,[[["self"]],["t"]]],[11,"into","","",241,[[],["u"]]],[11,"from","","",241,[[["t"]],["t"]]],[11,"try_into","","",241,[[],["result"]]],[11,"try_from","","",241,[[["u"]],["result"]]],[11,"type_id","","",241,[[["self"]],["typeid"]]],[11,"borrow","core::slice","",137,[[["self"]],["t"]]],[11,"borrow_mut","","",137,[[["self"]],["t"]]],[11,"into","","",137,[[],["u"]]],[11,"from","","",137,[[["t"]],["t"]]],[11,"try_into","","",137,[[],["result"]]],[11,"try_from","","",137,[[["u"]],["result"]]],[11,"type_id","","",137,[[["self"]],["typeid"]]],[11,"borrow","","",138,[[["self"]],["t"]]],[11,"borrow_mut","","",138,[[["self"]],["t"]]],[11,"into","","",138,[[],["u"]]],[11,"from","","",138,[[["t"]],["t"]]],[11,"try_into","","",138,[[],["result"]]],[11,"try_from","","",138,[[["u"]],["result"]]],[11,"type_id","","",138,[[["self"]],["typeid"]]],[11,"borrow","","",242,[[["self"]],["t"]]],[11,"borrow_mut","","",242,[[["self"]],["t"]]],[11,"into","","",242,[[],["u"]]],[11,"from","","",242,[[["t"]],["t"]]],[11,"try_into","","",242,[[],["result"]]],[11,"try_from","","",242,[[["u"]],["result"]]],[11,"type_id","","",242,[[["self"]],["typeid"]]],[11,"borrow","","",243,[[["self"]],["t"]]],[11,"borrow_mut","","",243,[[["self"]],["t"]]],[11,"into","","",243,[[],["u"]]],[11,"from","","",243,[[["t"]],["t"]]],[11,"try_into","","",243,[[],["result"]]],[11,"try_from","","",243,[[["u"]],["result"]]],[11,"type_id","","",243,[[["self"]],["typeid"]]],[11,"borrow","","",244,[[["self"]],["t"]]],[11,"borrow_mut","","",244,[[["self"]],["t"]]],[11,"into","","",244,[[],["u"]]],[11,"from","","",244,[[["t"]],["t"]]],[11,"try_into","","",244,[[],["result"]]],[11,"try_from","","",244,[[["u"]],["result"]]],[11,"type_id","","",244,[[["self"]],["typeid"]]],[11,"borrow","","",245,[[["self"]],["t"]]],[11,"borrow_mut","","",245,[[["self"]],["t"]]],[11,"into","","",245,[[],["u"]]],[11,"from","","",245,[[["t"]],["t"]]],[11,"try_into","","",245,[[],["result"]]],[11,"try_from","","",245,[[["u"]],["result"]]],[11,"type_id","","",245,[[["self"]],["typeid"]]],[11,"borrow","","",246,[[["self"]],["t"]]],[11,"borrow_mut","","",246,[[["self"]],["t"]]],[11,"into","","",246,[[],["u"]]],[11,"from","","",246,[[["t"]],["t"]]],[11,"try_into","","",246,[[],["result"]]],[11,"try_from","","",246,[[["u"]],["result"]]],[11,"type_id","","",246,[[["self"]],["typeid"]]],[11,"borrow","","",247,[[["self"]],["t"]]],[11,"borrow_mut","","",247,[[["self"]],["t"]]],[11,"into","","",247,[[],["u"]]],[11,"from","","",247,[[["t"]],["t"]]],[11,"try_into","","",247,[[],["result"]]],[11,"try_from","","",247,[[["u"]],["result"]]],[11,"type_id","","",247,[[["self"]],["typeid"]]],[11,"borrow","","",248,[[["self"]],["t"]]],[11,"borrow_mut","","",248,[[["self"]],["t"]]],[11,"into","","",248,[[],["u"]]],[11,"from","","",248,[[["t"]],["t"]]],[11,"try_into","","",248,[[],["result"]]],[11,"try_from","","",248,[[["u"]],["result"]]],[11,"type_id","","",248,[[["self"]],["typeid"]]],[11,"borrow","","",249,[[["self"]],["t"]]],[11,"borrow_mut","","",249,[[["self"]],["t"]]],[11,"into","","",249,[[],["u"]]],[11,"from","","",249,[[["t"]],["t"]]],[11,"try_into","","",249,[[],["result"]]],[11,"try_from","","",249,[[["u"]],["result"]]],[11,"type_id","","",249,[[["self"]],["typeid"]]],[11,"borrow","","",250,[[["self"]],["t"]]],[11,"borrow_mut","","",250,[[["self"]],["t"]]],[11,"into","","",250,[[],["u"]]],[11,"from","","",250,[[["t"]],["t"]]],[11,"try_into","","",250,[[],["result"]]],[11,"try_from","","",250,[[["u"]],["result"]]],[11,"type_id","","",250,[[["self"]],["typeid"]]],[11,"borrow","","",251,[[["self"]],["t"]]],[11,"borrow_mut","","",251,[[["self"]],["t"]]],[11,"into","","",251,[[],["u"]]],[11,"from","","",251,[[["t"]],["t"]]],[11,"try_into","","",251,[[],["result"]]],[11,"try_from","","",251,[[["u"]],["result"]]],[11,"type_id","","",251,[[["self"]],["typeid"]]],[11,"borrow","","",252,[[["self"]],["t"]]],[11,"borrow_mut","","",252,[[["self"]],["t"]]],[11,"into","","",252,[[],["u"]]],[11,"from","","",252,[[["t"]],["t"]]],[11,"try_into","","",252,[[],["result"]]],[11,"try_from","","",252,[[["u"]],["result"]]],[11,"type_id","","",252,[[["self"]],["typeid"]]],[11,"borrow","","",253,[[["self"]],["t"]]],[11,"borrow_mut","","",253,[[["self"]],["t"]]],[11,"into","","",253,[[],["u"]]],[11,"from","","",253,[[["t"]],["t"]]],[11,"try_into","","",253,[[],["result"]]],[11,"try_from","","",253,[[["u"]],["result"]]],[11,"type_id","","",253,[[["self"]],["typeid"]]],[11,"borrow","","",254,[[["self"]],["t"]]],[11,"borrow_mut","","",254,[[["self"]],["t"]]],[11,"into","","",254,[[],["u"]]],[11,"from","","",254,[[["t"]],["t"]]],[11,"try_into","","",254,[[],["result"]]],[11,"try_from","","",254,[[["u"]],["result"]]],[11,"type_id","","",254,[[["self"]],["typeid"]]],[11,"borrow","","",139,[[["self"]],["t"]]],[11,"borrow_mut","","",139,[[["self"]],["t"]]],[11,"into","","",139,[[],["u"]]],[11,"from","","",139,[[["t"]],["t"]]],[11,"try_into","","",139,[[],["result"]]],[11,"try_from","","",139,[[["u"]],["result"]]],[11,"type_id","","",139,[[["self"]],["typeid"]]],[11,"borrow","","",140,[[["self"]],["t"]]],[11,"borrow_mut","","",140,[[["self"]],["t"]]],[11,"into","","",140,[[],["u"]]],[11,"from","","",140,[[["t"]],["t"]]],[11,"try_into","","",140,[[],["result"]]],[11,"try_from","","",140,[[["u"]],["result"]]],[11,"type_id","","",140,[[["self"]],["typeid"]]],[11,"borrow","","",255,[[["self"]],["t"]]],[11,"borrow_mut","","",255,[[["self"]],["t"]]],[11,"into","","",255,[[],["u"]]],[11,"from","","",255,[[["t"]],["t"]]],[11,"try_into","","",255,[[],["result"]]],[11,"try_from","","",255,[[["u"]],["result"]]],[11,"type_id","","",255,[[["self"]],["typeid"]]],[11,"borrow","","",256,[[["self"]],["t"]]],[11,"borrow_mut","","",256,[[["self"]],["t"]]],[11,"into","","",256,[[],["u"]]],[11,"from","","",256,[[["t"]],["t"]]],[11,"try_into","","",256,[[],["result"]]],[11,"try_from","","",256,[[["u"]],["result"]]],[11,"type_id","","",256,[[["self"]],["typeid"]]],[11,"borrow","","",141,[[["self"]],["t"]]],[11,"borrow_mut","","",141,[[["self"]],["t"]]],[11,"into","","",141,[[],["u"]]],[11,"from","","",141,[[["t"]],["t"]]],[11,"try_into","","",141,[[],["result"]]],[11,"try_from","","",141,[[["u"]],["result"]]],[11,"type_id","","",141,[[["self"]],["typeid"]]],[11,"borrow","","",142,[[["self"]],["t"]]],[11,"borrow_mut","","",142,[[["self"]],["t"]]],[11,"into","","",142,[[],["u"]]],[11,"from","","",142,[[["t"]],["t"]]],[11,"try_into","","",142,[[],["result"]]],[11,"try_from","","",142,[[["u"]],["result"]]],[11,"type_id","","",142,[[["self"]],["typeid"]]],[11,"borrow","core::str","",257,[[["self"]],["t"]]],[11,"borrow_mut","","",257,[[["self"]],["t"]]],[11,"into","","",257,[[],["u"]]],[11,"from","","",257,[[["t"]],["t"]]],[11,"try_into","","",257,[[],["result"]]],[11,"try_from","","",257,[[["u"]],["result"]]],[11,"type_id","","",257,[[["self"]],["typeid"]]],[11,"borrow","","",150,[[["self"]],["t"]]],[11,"borrow_mut","","",150,[[["self"]],["t"]]],[11,"into","","",150,[[],["u"]]],[11,"from","","",150,[[["t"]],["t"]]],[11,"try_into","","",150,[[],["result"]]],[11,"try_from","","",150,[[["u"]],["result"]]],[11,"type_id","","",150,[[["self"]],["typeid"]]],[11,"borrow","","",151,[[["self"]],["t"]]],[11,"borrow_mut","","",151,[[["self"]],["t"]]],[11,"into","","",151,[[],["u"]]],[11,"from","","",151,[[["t"]],["t"]]],[11,"try_into","","",151,[[],["result"]]],[11,"try_from","","",151,[[["u"]],["result"]]],[11,"type_id","","",151,[[["self"]],["typeid"]]],[11,"borrow","","",152,[[["self"]],["t"]]],[11,"borrow_mut","","",152,[[["self"]],["t"]]],[11,"into","","",152,[[],["u"]]],[11,"from","","",152,[[["t"]],["t"]]],[11,"try_into","","",152,[[],["result"]]],[11,"try_from","","",152,[[["u"]],["result"]]],[11,"type_id","","",152,[[["self"]],["typeid"]]],[11,"borrow","","",258,[[["self"]],["t"]]],[11,"borrow_mut","","",258,[[["self"]],["t"]]],[11,"into","","",258,[[],["u"]]],[11,"from","","",258,[[["t"]],["t"]]],[11,"try_into","","",258,[[],["result"]]],[11,"try_from","","",258,[[["u"]],["result"]]],[11,"type_id","","",258,[[["self"]],["typeid"]]],[11,"borrow","","",259,[[["self"]],["t"]]],[11,"borrow_mut","","",259,[[["self"]],["t"]]],[11,"into","","",259,[[],["u"]]],[11,"from","","",259,[[["t"]],["t"]]],[11,"try_into","","",259,[[],["result"]]],[11,"try_from","","",259,[[["u"]],["result"]]],[11,"type_id","","",259,[[["self"]],["typeid"]]],[11,"borrow","","",260,[[["self"]],["t"]]],[11,"borrow_mut","","",260,[[["self"]],["t"]]],[11,"into","","",260,[[],["u"]]],[11,"from","","",260,[[["t"]],["t"]]],[11,"try_into","","",260,[[],["result"]]],[11,"try_from","","",260,[[["u"]],["result"]]],[11,"type_id","","",260,[[["self"]],["typeid"]]],[11,"borrow","","",261,[[["self"]],["t"]]],[11,"borrow_mut","","",261,[[["self"]],["t"]]],[11,"into","","",261,[[],["u"]]],[11,"from","","",261,[[["t"]],["t"]]],[11,"try_into","","",261,[[],["result"]]],[11,"try_from","","",261,[[["u"]],["result"]]],[11,"type_id","","",261,[[["self"]],["typeid"]]],[11,"borrow","","",262,[[["self"]],["t"]]],[11,"borrow_mut","","",262,[[["self"]],["t"]]],[11,"into","","",262,[[],["u"]]],[11,"from","","",262,[[["t"]],["t"]]],[11,"try_into","","",262,[[],["result"]]],[11,"try_from","","",262,[[["u"]],["result"]]],[11,"type_id","","",262,[[["self"]],["typeid"]]],[11,"borrow","","",263,[[["self"]],["t"]]],[11,"borrow_mut","","",263,[[["self"]],["t"]]],[11,"into","","",263,[[],["u"]]],[11,"from","","",263,[[["t"]],["t"]]],[11,"try_into","","",263,[[],["result"]]],[11,"try_from","","",263,[[["u"]],["result"]]],[11,"type_id","","",263,[[["self"]],["typeid"]]],[11,"borrow","","",264,[[["self"]],["t"]]],[11,"borrow_mut","","",264,[[["self"]],["t"]]],[11,"into","","",264,[[],["u"]]],[11,"from","","",264,[[["t"]],["t"]]],[11,"try_into","","",264,[[],["result"]]],[11,"try_from","","",264,[[["u"]],["result"]]],[11,"type_id","","",264,[[["self"]],["typeid"]]],[11,"borrow","","",265,[[["self"]],["t"]]],[11,"borrow_mut","","",265,[[["self"]],["t"]]],[11,"into","","",265,[[],["u"]]],[11,"from","","",265,[[["t"]],["t"]]],[11,"try_into","","",265,[[],["result"]]],[11,"try_from","","",265,[[["u"]],["result"]]],[11,"type_id","","",265,[[["self"]],["typeid"]]],[11,"borrow","","",266,[[["self"]],["t"]]],[11,"borrow_mut","","",266,[[["self"]],["t"]]],[11,"into","","",266,[[],["u"]]],[11,"from","","",266,[[["t"]],["t"]]],[11,"try_into","","",266,[[],["result"]]],[11,"try_from","","",266,[[["u"]],["result"]]],[11,"type_id","","",266,[[["self"]],["typeid"]]],[11,"borrow","","",267,[[["self"]],["t"]]],[11,"borrow_mut","","",267,[[["self"]],["t"]]],[11,"into","","",267,[[],["u"]]],[11,"from","","",267,[[["t"]],["t"]]],[11,"try_into","","",267,[[],["result"]]],[11,"try_from","","",267,[[["u"]],["result"]]],[11,"type_id","","",267,[[["self"]],["typeid"]]],[11,"borrow","","",268,[[["self"]],["t"]]],[11,"borrow_mut","","",268,[[["self"]],["t"]]],[11,"into","","",268,[[],["u"]]],[11,"from","","",268,[[["t"]],["t"]]],[11,"try_into","","",268,[[],["result"]]],[11,"try_from","","",268,[[["u"]],["result"]]],[11,"type_id","","",268,[[["self"]],["typeid"]]],[11,"borrow","","",269,[[["self"]],["t"]]],[11,"borrow_mut","","",269,[[["self"]],["t"]]],[11,"into","","",269,[[],["u"]]],[11,"from","","",269,[[["t"]],["t"]]],[11,"try_into","","",269,[[],["result"]]],[11,"try_from","","",269,[[["u"]],["result"]]],[11,"type_id","","",269,[[["self"]],["typeid"]]],[11,"borrow","","",270,[[["self"]],["t"]]],[11,"borrow_mut","","",270,[[["self"]],["t"]]],[11,"into","","",270,[[],["u"]]],[11,"from","","",270,[[["t"]],["t"]]],[11,"try_into","","",270,[[],["result"]]],[11,"try_from","","",270,[[["u"]],["result"]]],[11,"type_id","","",270,[[["self"]],["typeid"]]],[11,"borrow","","",271,[[["self"]],["t"]]],[11,"borrow_mut","","",271,[[["self"]],["t"]]],[11,"into","","",271,[[],["u"]]],[11,"from","","",271,[[["t"]],["t"]]],[11,"try_into","","",271,[[],["result"]]],[11,"try_from","","",271,[[["u"]],["result"]]],[11,"type_id","","",271,[[["self"]],["typeid"]]],[11,"borrow","","",272,[[["self"]],["t"]]],[11,"borrow_mut","","",272,[[["self"]],["t"]]],[11,"into","","",272,[[],["u"]]],[11,"from","","",272,[[["t"]],["t"]]],[11,"try_into","","",272,[[],["result"]]],[11,"try_from","","",272,[[["u"]],["result"]]],[11,"type_id","","",272,[[["self"]],["typeid"]]],[11,"borrow","","",273,[[["self"]],["t"]]],[11,"borrow_mut","","",273,[[["self"]],["t"]]],[11,"into","","",273,[[],["u"]]],[11,"from","","",273,[[["t"]],["t"]]],[11,"try_into","","",273,[[],["result"]]],[11,"try_from","","",273,[[["u"]],["result"]]],[11,"type_id","","",273,[[["self"]],["typeid"]]],[11,"borrow","","",274,[[["self"]],["t"]]],[11,"borrow_mut","","",274,[[["self"]],["t"]]],[11,"into","","",274,[[],["u"]]],[11,"from","","",274,[[["t"]],["t"]]],[11,"try_into","","",274,[[],["result"]]],[11,"try_from","","",274,[[["u"]],["result"]]],[11,"type_id","","",274,[[["self"]],["typeid"]]],[11,"borrow","","",275,[[["self"]],["t"]]],[11,"borrow_mut","","",275,[[["self"]],["t"]]],[11,"into","","",275,[[],["u"]]],[11,"from","","",275,[[["t"]],["t"]]],[11,"try_into","","",275,[[],["result"]]],[11,"try_from","","",275,[[["u"]],["result"]]],[11,"type_id","","",275,[[["self"]],["typeid"]]],[11,"borrow","","",276,[[["self"]],["t"]]],[11,"borrow_mut","","",276,[[["self"]],["t"]]],[11,"into","","",276,[[],["u"]]],[11,"from","","",276,[[["t"]],["t"]]],[11,"try_into","","",276,[[],["result"]]],[11,"try_from","","",276,[[["u"]],["result"]]],[11,"type_id","","",276,[[["self"]],["typeid"]]],[11,"borrow","","",277,[[["self"]],["t"]]],[11,"borrow_mut","","",277,[[["self"]],["t"]]],[11,"into","","",277,[[],["u"]]],[11,"from","","",277,[[["t"]],["t"]]],[11,"try_into","","",277,[[],["result"]]],[11,"try_from","","",277,[[["u"]],["result"]]],[11,"type_id","","",277,[[["self"]],["typeid"]]],[11,"borrow","core::str::pattern","",278,[[["self"]],["t"]]],[11,"borrow_mut","","",278,[[["self"]],["t"]]],[11,"into","","",278,[[],["u"]]],[11,"from","","",278,[[["t"]],["t"]]],[11,"try_into","","",278,[[],["result"]]],[11,"try_from","","",278,[[["u"]],["result"]]],[11,"type_id","","",278,[[["self"]],["typeid"]]],[11,"borrow","","",279,[[["self"]],["t"]]],[11,"borrow_mut","","",279,[[["self"]],["t"]]],[11,"into","","",279,[[],["u"]]],[11,"from","","",279,[[["t"]],["t"]]],[11,"try_into","","",279,[[],["result"]]],[11,"try_from","","",279,[[["u"]],["result"]]],[11,"type_id","","",279,[[["self"]],["typeid"]]],[11,"borrow","","",280,[[["self"]],["t"]]],[11,"borrow_mut","","",280,[[["self"]],["t"]]],[11,"into","","",280,[[],["u"]]],[11,"from","","",280,[[["t"]],["t"]]],[11,"try_into","","",280,[[],["result"]]],[11,"try_from","","",280,[[["u"]],["result"]]],[11,"type_id","","",280,[[["self"]],["typeid"]]],[11,"borrow","","",281,[[["self"]],["t"]]],[11,"borrow_mut","","",281,[[["self"]],["t"]]],[11,"into","","",281,[[],["u"]]],[11,"from","","",281,[[["t"]],["t"]]],[11,"try_into","","",281,[[],["result"]]],[11,"try_from","","",281,[[["u"]],["result"]]],[11,"type_id","","",281,[[["self"]],["typeid"]]],[11,"borrow","","",143,[[["self"]],["t"]]],[11,"borrow_mut","","",143,[[["self"]],["t"]]],[11,"into","","",143,[[],["u"]]],[11,"from","","",143,[[["t"]],["t"]]],[11,"try_into","","",143,[[],["result"]]],[11,"try_from","","",143,[[["u"]],["result"]]],[11,"type_id","","",143,[[["self"]],["typeid"]]],[11,"borrow","core::str::lossy","",148,[[["self"]],["t"]]],[11,"borrow_mut","","",148,[[["self"]],["t"]]],[11,"type_id","","",148,[[["self"]],["typeid"]]],[11,"borrow","","",282,[[["self"]],["t"]]],[11,"borrow_mut","","",282,[[["self"]],["t"]]],[11,"into","","",282,[[],["u"]]],[11,"from","","",282,[[["t"]],["t"]]],[11,"try_into","","",282,[[],["result"]]],[11,"try_from","","",282,[[["u"]],["result"]]],[11,"type_id","","",282,[[["self"]],["typeid"]]],[11,"borrow","","",147,[[["self"]],["t"]]],[11,"borrow_mut","","",147,[[["self"]],["t"]]],[11,"into","","",147,[[],["u"]]],[11,"from","","",147,[[["t"]],["t"]]],[11,"try_into","","",147,[[],["result"]]],[11,"try_from","","",147,[[["u"]],["result"]]],[11,"type_id","","",147,[[["self"]],["typeid"]]],[11,"borrow","core::time","",153,[[["self"]],["t"]]],[11,"borrow_mut","","",153,[[["self"]],["t"]]],[11,"into","","",153,[[],["u"]]],[11,"from","","",153,[[["t"]],["t"]]],[11,"try_into","","",153,[[],["result"]]],[11,"try_from","","",153,[[["u"]],["result"]]],[11,"type_id","","",153,[[["self"]],["typeid"]]],[11,"borrow","core::task","",158,[[["self"]],["t"]]],[11,"borrow_mut","","",158,[[["self"]],["t"]]],[11,"into","","",158,[[],["u"]]],[11,"from","","",158,[[["t"]],["t"]]],[11,"try_into","","",158,[[],["result"]]],[11,"try_from","","",158,[[["u"]],["result"]]],[11,"type_id","","",158,[[["self"]],["typeid"]]],[11,"borrow","","",156,[[["self"]],["t"]]],[11,"borrow_mut","","",156,[[["self"]],["t"]]],[11,"into","","",156,[[],["u"]]],[11,"from","","",156,[[["t"]],["t"]]],[11,"try_into","","",156,[[],["result"]]],[11,"try_from","","",156,[[["u"]],["result"]]],[11,"type_id","","",156,[[["self"]],["typeid"]]],[11,"borrow","","",157,[[["self"]],["t"]]],[11,"borrow_mut","","",157,[[["self"]],["t"]]],[11,"into","","",157,[[],["u"]]],[11,"from","","",157,[[["t"]],["t"]]],[11,"try_into","","",157,[[],["result"]]],[11,"try_from","","",157,[[["u"]],["result"]]],[11,"type_id","","",157,[[["self"]],["typeid"]]],[11,"borrow","","",159,[[["self"]],["t"]]],[11,"borrow_mut","","",159,[[["self"]],["t"]]],[11,"into","","",159,[[],["u"]]],[11,"from","","",159,[[["t"]],["t"]]],[11,"try_into","","",159,[[],["result"]]],[11,"try_from","","",159,[[["u"]],["result"]]],[11,"type_id","","",159,[[["self"]],["typeid"]]],[11,"borrow","","",155,[[["self"]],["t"]]],[11,"borrow_mut","","",155,[[["self"]],["t"]]],[11,"into","","",155,[[],["u"]]],[11,"from","","",155,[[["t"]],["t"]]],[11,"from","","",155,[[],["t"]]],[11,"try_into","","",155,[[],["result"]]],[11,"try_from","","",155,[[["u"]],["result"]]],[11,"type_id","","",155,[[["self"]],["typeid"]]],[11,"borrow","core::alloc","",162,[[["self"]],["t"]]],[11,"borrow_mut","","",162,[[["self"]],["t"]]],[11,"into","","",162,[[],["u"]]],[11,"from","","",162,[[["t"]],["t"]]],[11,"try_into","","",162,[[],["result"]]],[11,"try_from","","",162,[[["u"]],["result"]]],[11,"type_id","","",162,[[["self"]],["typeid"]]],[11,"borrow","","",283,[[["self"]],["t"]]],[11,"borrow_mut","","",283,[[["self"]],["t"]]],[11,"into","","",283,[[],["u"]]],[11,"from","","",283,[[["t"]],["t"]]],[11,"try_into","","",283,[[],["result"]]],[11,"try_from","","",283,[[["u"]],["result"]]],[11,"type_id","","",283,[[["self"]],["typeid"]]],[11,"borrow","","",284,[[["self"]],["t"]]],[11,"borrow_mut","","",284,[[["self"]],["t"]]],[11,"into","","",284,[[],["u"]]],[11,"from","","",284,[[["t"]],["t"]]],[11,"try_into","","",284,[[],["result"]]],[11,"try_from","","",284,[[["u"]],["result"]]],[11,"type_id","","",284,[[["self"]],["typeid"]]],[11,"borrow","","",163,[[["self"]],["t"]]],[11,"borrow_mut","","",163,[[["self"]],["t"]]],[11,"into","","",163,[[],["u"]]],[11,"from","","",163,[[["t"]],["t"]]],[11,"try_into","","",163,[[],["result"]]],[11,"try_from","","",163,[[["u"]],["result"]]],[11,"type_id","","",163,[[["self"]],["typeid"]]],[11,"borrow","core::arch::arm","",285,[[["self"]],["t"]]],[11,"borrow_mut","","",285,[[["self"]],["t"]]],[11,"into","","",285,[[],["u"]]],[11,"from","","",285,[[["t"]],["t"]]],[11,"try_into","","",285,[[],["result"]]],[11,"try_from","","",285,[[["u"]],["result"]]],[11,"type_id","","",285,[[["self"]],["typeid"]]],[11,"borrow","","",286,[[["self"]],["t"]]],[11,"borrow_mut","","",286,[[["self"]],["t"]]],[11,"into","","",286,[[],["u"]]],[11,"from","","",286,[[["t"]],["t"]]],[11,"try_into","","",286,[[],["result"]]],[11,"try_from","","",286,[[["u"]],["result"]]],[11,"type_id","","",286,[[["self"]],["typeid"]]],[11,"borrow","core::arch::x86","",287,[[["self"]],["t"]]],[11,"borrow_mut","","",287,[[["self"]],["t"]]],[11,"into","","",287,[[],["u"]]],[11,"from","","",287,[[["t"]],["t"]]],[11,"try_into","","",287,[[],["result"]]],[11,"try_from","","",287,[[["u"]],["result"]]],[11,"type_id","","",287,[[["self"]],["typeid"]]],[11,"borrow","","",288,[[["self"]],["t"]]],[11,"borrow_mut","","",288,[[["self"]],["t"]]],[11,"into","","",288,[[],["u"]]],[11,"from","","",288,[[["t"]],["t"]]],[11,"try_into","","",288,[[],["result"]]],[11,"try_from","","",288,[[["u"]],["result"]]],[11,"type_id","","",288,[[["self"]],["typeid"]]],[11,"borrow","","",289,[[["self"]],["t"]]],[11,"borrow_mut","","",289,[[["self"]],["t"]]],[11,"into","","",289,[[],["u"]]],[11,"from","","",289,[[["t"]],["t"]]],[11,"try_into","","",289,[[],["result"]]],[11,"try_from","","",289,[[["u"]],["result"]]],[11,"type_id","","",289,[[["self"]],["typeid"]]],[11,"borrow","","",290,[[["self"]],["t"]]],[11,"borrow_mut","","",290,[[["self"]],["t"]]],[11,"into","","",290,[[],["u"]]],[11,"from","","",290,[[["t"]],["t"]]],[11,"try_into","","",290,[[],["result"]]],[11,"try_from","","",290,[[["u"]],["result"]]],[11,"type_id","","",290,[[["self"]],["typeid"]]],[11,"borrow","","",291,[[["self"]],["t"]]],[11,"borrow_mut","","",291,[[["self"]],["t"]]],[11,"into","","",291,[[],["u"]]],[11,"from","","",291,[[["t"]],["t"]]],[11,"try_into","","",291,[[],["result"]]],[11,"try_from","","",291,[[["u"]],["result"]]],[11,"type_id","","",291,[[["self"]],["typeid"]]],[11,"borrow","","",292,[[["self"]],["t"]]],[11,"borrow_mut","","",292,[[["self"]],["t"]]],[11,"into","","",292,[[],["u"]]],[11,"from","","",292,[[["t"]],["t"]]],[11,"try_into","","",292,[[],["result"]]],[11,"try_from","","",292,[[["u"]],["result"]]],[11,"type_id","","",292,[[["self"]],["typeid"]]],[11,"borrow","","",293,[[["self"]],["t"]]],[11,"borrow_mut","","",293,[[["self"]],["t"]]],[11,"into","","",293,[[],["u"]]],[11,"from","","",293,[[["t"]],["t"]]],[11,"try_into","","",293,[[],["result"]]],[11,"try_from","","",293,[[["u"]],["result"]]],[11,"type_id","","",293,[[["self"]],["typeid"]]],[11,"borrow","","",294,[[["self"]],["t"]]],[11,"borrow_mut","","",294,[[["self"]],["t"]]],[11,"into","","",294,[[],["u"]]],[11,"from","","",294,[[["t"]],["t"]]],[11,"try_into","","",294,[[],["result"]]],[11,"try_from","","",294,[[["u"]],["result"]]],[11,"type_id","","",294,[[["self"]],["typeid"]]],[11,"borrow","","",295,[[["self"]],["t"]]],[11,"borrow_mut","","",295,[[["self"]],["t"]]],[11,"into","","",295,[[],["u"]]],[11,"from","","",295,[[["t"]],["t"]]],[11,"try_into","","",295,[[],["result"]]],[11,"try_from","","",295,[[["u"]],["result"]]],[11,"type_id","","",295,[[["self"]],["typeid"]]],[11,"borrow","","",296,[[["self"]],["t"]]],[11,"borrow_mut","","",296,[[["self"]],["t"]]],[11,"into","","",296,[[],["u"]]],[11,"from","","",296,[[["t"]],["t"]]],[11,"try_into","","",296,[[],["result"]]],[11,"try_from","","",296,[[["u"]],["result"]]],[11,"type_id","","",296,[[["self"]],["typeid"]]],[11,"borrow","","",164,[[["self"]],["t"]]],[11,"borrow_mut","","",164,[[["self"]],["t"]]],[11,"into","","",164,[[],["u"]]],[11,"from","","",164,[[["t"]],["t"]]],[11,"try_into","","",164,[[],["result"]]],[11,"try_from","","",164,[[["u"]],["result"]]],[11,"type_id","","",164,[[["self"]],["typeid"]]],[11,"borrow","core::arch::aarch64","",297,[[["self"]],["t"]]],[11,"borrow_mut","","",297,[[["self"]],["t"]]],[11,"into","","",297,[[],["u"]]],[11,"from","","",297,[[["t"]],["t"]]],[11,"try_into","","",297,[[],["result"]]],[11,"try_from","","",297,[[["u"]],["result"]]],[11,"type_id","","",297,[[["self"]],["typeid"]]],[11,"borrow","","",298,[[["self"]],["t"]]],[11,"borrow_mut","","",298,[[["self"]],["t"]]],[11,"into","","",298,[[],["u"]]],[11,"from","","",298,[[["t"]],["t"]]],[11,"try_into","","",298,[[],["result"]]],[11,"try_from","","",298,[[["u"]],["result"]]],[11,"type_id","","",298,[[["self"]],["typeid"]]],[11,"borrow","","",299,[[["self"]],["t"]]],[11,"borrow_mut","","",299,[[["self"]],["t"]]],[11,"into","","",299,[[],["u"]]],[11,"from","","",299,[[["t"]],["t"]]],[11,"try_into","","",299,[[],["result"]]],[11,"try_from","","",299,[[["u"]],["result"]]],[11,"type_id","","",299,[[["self"]],["typeid"]]],[11,"borrow","","",300,[[["self"]],["t"]]],[11,"borrow_mut","","",300,[[["self"]],["t"]]],[11,"into","","",300,[[],["u"]]],[11,"from","","",300,[[["t"]],["t"]]],[11,"try_into","","",300,[[],["result"]]],[11,"try_from","","",300,[[["u"]],["result"]]],[11,"type_id","","",300,[[["self"]],["typeid"]]],[11,"borrow","","",301,[[["self"]],["t"]]],[11,"borrow_mut","","",301,[[["self"]],["t"]]],[11,"into","","",301,[[],["u"]]],[11,"from","","",301,[[["t"]],["t"]]],[11,"try_into","","",301,[[],["result"]]],[11,"try_from","","",301,[[["u"]],["result"]]],[11,"type_id","","",301,[[["self"]],["typeid"]]],[11,"borrow","","",302,[[["self"]],["t"]]],[11,"borrow_mut","","",302,[[["self"]],["t"]]],[11,"into","","",302,[[],["u"]]],[11,"from","","",302,[[["t"]],["t"]]],[11,"try_into","","",302,[[],["result"]]],[11,"try_from","","",302,[[["u"]],["result"]]],[11,"type_id","","",302,[[["self"]],["typeid"]]],[11,"borrow","","",174,[[["self"]],["t"]]],[11,"borrow_mut","","",174,[[["self"]],["t"]]],[11,"into","","",174,[[],["u"]]],[11,"from","","",174,[[["t"]],["t"]]],[11,"try_into","","",174,[[],["result"]]],[11,"try_from","","",174,[[["u"]],["result"]]],[11,"type_id","","",174,[[["self"]],["typeid"]]],[11,"borrow","","",175,[[["self"]],["t"]]],[11,"borrow_mut","","",175,[[["self"]],["t"]]],[11,"into","","",175,[[],["u"]]],[11,"from","","",175,[[["t"]],["t"]]],[11,"try_into","","",175,[[],["result"]]],[11,"try_from","","",175,[[["u"]],["result"]]],[11,"type_id","","",175,[[["self"]],["typeid"]]],[11,"borrow","","",176,[[["self"]],["t"]]],[11,"borrow_mut","","",176,[[["self"]],["t"]]],[11,"into","","",176,[[],["u"]]],[11,"from","","",176,[[["t"]],["t"]]],[11,"try_into","","",176,[[],["result"]]],[11,"try_from","","",176,[[["u"]],["result"]]],[11,"type_id","","",176,[[["self"]],["typeid"]]],[11,"borrow","","",177,[[["self"]],["t"]]],[11,"borrow_mut","","",177,[[["self"]],["t"]]],[11,"into","","",177,[[],["u"]]],[11,"from","","",177,[[["t"]],["t"]]],[11,"try_into","","",177,[[],["result"]]],[11,"try_from","","",177,[[["u"]],["result"]]],[11,"type_id","","",177,[[["self"]],["typeid"]]],[11,"borrow","","",178,[[["self"]],["t"]]],[11,"borrow_mut","","",178,[[["self"]],["t"]]],[11,"into","","",178,[[],["u"]]],[11,"from","","",178,[[["t"]],["t"]]],[11,"try_into","","",178,[[],["result"]]],[11,"try_from","","",178,[[["u"]],["result"]]],[11,"type_id","","",178,[[["self"]],["typeid"]]],[11,"borrow","","",179,[[["self"]],["t"]]],[11,"borrow_mut","","",179,[[["self"]],["t"]]],[11,"into","","",179,[[],["u"]]],[11,"from","","",179,[[["t"]],["t"]]],[11,"try_into","","",179,[[],["result"]]],[11,"try_from","","",179,[[["u"]],["result"]]],[11,"type_id","","",179,[[["self"]],["typeid"]]],[11,"borrow","","",180,[[["self"]],["t"]]],[11,"borrow_mut","","",180,[[["self"]],["t"]]],[11,"into","","",180,[[],["u"]]],[11,"from","","",180,[[["t"]],["t"]]],[11,"try_into","","",180,[[],["result"]]],[11,"try_from","","",180,[[["u"]],["result"]]],[11,"type_id","","",180,[[["self"]],["typeid"]]],[11,"borrow","","",181,[[["self"]],["t"]]],[11,"borrow_mut","","",181,[[["self"]],["t"]]],[11,"into","","",181,[[],["u"]]],[11,"from","","",181,[[["t"]],["t"]]],[11,"try_into","","",181,[[],["result"]]],[11,"try_from","","",181,[[["u"]],["result"]]],[11,"type_id","","",181,[[["self"]],["typeid"]]],[11,"borrow","","",182,[[["self"]],["t"]]],[11,"borrow_mut","","",182,[[["self"]],["t"]]],[11,"into","","",182,[[],["u"]]],[11,"from","","",182,[[["t"]],["t"]]],[11,"try_into","","",182,[[],["result"]]],[11,"try_from","","",182,[[["u"]],["result"]]],[11,"type_id","","",182,[[["self"]],["typeid"]]],[11,"borrow","core::arch::arm","",303,[[["self"]],["t"]]],[11,"borrow_mut","","",303,[[["self"]],["t"]]],[11,"into","","",303,[[],["u"]]],[11,"from","","",303,[[["t"]],["t"]]],[11,"try_into","","",303,[[],["result"]]],[11,"try_from","","",303,[[["u"]],["result"]]],[11,"type_id","","",303,[[["self"]],["typeid"]]],[11,"borrow","","",304,[[["self"]],["t"]]],[11,"borrow_mut","","",304,[[["self"]],["t"]]],[11,"into","","",304,[[],["u"]]],[11,"from","","",304,[[["t"]],["t"]]],[11,"try_into","","",304,[[],["result"]]],[11,"try_from","","",304,[[["u"]],["result"]]],[11,"type_id","","",304,[[["self"]],["typeid"]]],[11,"borrow","","",305,[[["self"]],["t"]]],[11,"borrow_mut","","",305,[[["self"]],["t"]]],[11,"into","","",305,[[],["u"]]],[11,"from","","",305,[[["t"]],["t"]]],[11,"try_into","","",305,[[],["result"]]],[11,"try_from","","",305,[[["u"]],["result"]]],[11,"type_id","","",305,[[["self"]],["typeid"]]],[11,"borrow","","",306,[[["self"]],["t"]]],[11,"borrow_mut","","",306,[[["self"]],["t"]]],[11,"into","","",306,[[],["u"]]],[11,"from","","",306,[[["t"]],["t"]]],[11,"try_into","","",306,[[],["result"]]],[11,"try_from","","",306,[[["u"]],["result"]]],[11,"type_id","","",306,[[["self"]],["typeid"]]],[11,"borrow","","",307,[[["self"]],["t"]]],[11,"borrow_mut","","",307,[[["self"]],["t"]]],[11,"into","","",307,[[],["u"]]],[11,"from","","",307,[[["t"]],["t"]]],[11,"try_into","","",307,[[],["result"]]],[11,"try_from","","",307,[[["u"]],["result"]]],[11,"type_id","","",307,[[["self"]],["typeid"]]],[11,"borrow","","",308,[[["self"]],["t"]]],[11,"borrow_mut","","",308,[[["self"]],["t"]]],[11,"into","","",308,[[],["u"]]],[11,"from","","",308,[[["t"]],["t"]]],[11,"try_into","","",308,[[],["result"]]],[11,"try_from","","",308,[[["u"]],["result"]]],[11,"type_id","","",308,[[["self"]],["typeid"]]],[11,"borrow","","",309,[[["self"]],["t"]]],[11,"borrow_mut","","",309,[[["self"]],["t"]]],[11,"into","","",309,[[],["u"]]],[11,"from","","",309,[[["t"]],["t"]]],[11,"try_into","","",309,[[],["result"]]],[11,"try_from","","",309,[[["u"]],["result"]]],[11,"type_id","","",309,[[["self"]],["typeid"]]],[11,"borrow","","",310,[[["self"]],["t"]]],[11,"borrow_mut","","",310,[[["self"]],["t"]]],[11,"into","","",310,[[],["u"]]],[11,"from","","",310,[[["t"]],["t"]]],[11,"try_into","","",310,[[],["result"]]],[11,"try_from","","",310,[[["u"]],["result"]]],[11,"type_id","","",310,[[["self"]],["typeid"]]],[11,"borrow","","",311,[[["self"]],["t"]]],[11,"borrow_mut","","",311,[[["self"]],["t"]]],[11,"into","","",311,[[],["u"]]],[11,"from","","",311,[[["t"]],["t"]]],[11,"try_into","","",311,[[],["result"]]],[11,"try_from","","",311,[[["u"]],["result"]]],[11,"type_id","","",311,[[["self"]],["typeid"]]],[11,"borrow","","",312,[[["self"]],["t"]]],[11,"borrow_mut","","",312,[[["self"]],["t"]]],[11,"into","","",312,[[],["u"]]],[11,"from","","",312,[[["t"]],["t"]]],[11,"try_into","","",312,[[],["result"]]],[11,"try_from","","",312,[[["u"]],["result"]]],[11,"type_id","","",312,[[["self"]],["typeid"]]],[11,"borrow","","",313,[[["self"]],["t"]]],[11,"borrow_mut","","",313,[[["self"]],["t"]]],[11,"into","","",313,[[],["u"]]],[11,"from","","",313,[[["t"]],["t"]]],[11,"try_into","","",313,[[],["result"]]],[11,"try_from","","",313,[[["u"]],["result"]]],[11,"type_id","","",313,[[["self"]],["typeid"]]],[11,"borrow","","",314,[[["self"]],["t"]]],[11,"borrow_mut","","",314,[[["self"]],["t"]]],[11,"into","","",314,[[],["u"]]],[11,"from","","",314,[[["t"]],["t"]]],[11,"try_into","","",314,[[],["result"]]],[11,"try_from","","",314,[[["u"]],["result"]]],[11,"type_id","","",314,[[["self"]],["typeid"]]],[11,"borrow","","",315,[[["self"]],["t"]]],[11,"borrow_mut","","",315,[[["self"]],["t"]]],[11,"into","","",315,[[],["u"]]],[11,"from","","",315,[[["t"]],["t"]]],[11,"try_into","","",315,[[],["result"]]],[11,"try_from","","",315,[[["u"]],["result"]]],[11,"type_id","","",315,[[["self"]],["typeid"]]],[11,"borrow","","",316,[[["self"]],["t"]]],[11,"borrow_mut","","",316,[[["self"]],["t"]]],[11,"into","","",316,[[],["u"]]],[11,"from","","",316,[[["t"]],["t"]]],[11,"try_into","","",316,[[],["result"]]],[11,"try_from","","",316,[[["u"]],["result"]]],[11,"type_id","","",316,[[["self"]],["typeid"]]],[11,"borrow","","",317,[[["self"]],["t"]]],[11,"borrow_mut","","",317,[[["self"]],["t"]]],[11,"into","","",317,[[],["u"]]],[11,"from","","",317,[[["t"]],["t"]]],[11,"try_into","","",317,[[],["result"]]],[11,"try_from","","",317,[[["u"]],["result"]]],[11,"type_id","","",317,[[["self"]],["typeid"]]],[11,"borrow","","",318,[[["self"]],["t"]]],[11,"borrow_mut","","",318,[[["self"]],["t"]]],[11,"into","","",318,[[],["u"]]],[11,"from","","",318,[[["t"]],["t"]]],[11,"try_into","","",318,[[],["result"]]],[11,"try_from","","",318,[[["u"]],["result"]]],[11,"type_id","","",318,[[["self"]],["typeid"]]],[11,"borrow","","",319,[[["self"]],["t"]]],[11,"borrow_mut","","",319,[[["self"]],["t"]]],[11,"into","","",319,[[],["u"]]],[11,"from","","",319,[[["t"]],["t"]]],[11,"try_into","","",319,[[],["result"]]],[11,"try_from","","",319,[[["u"]],["result"]]],[11,"type_id","","",319,[[["self"]],["typeid"]]],[11,"borrow","","",320,[[["self"]],["t"]]],[11,"borrow_mut","","",320,[[["self"]],["t"]]],[11,"into","","",320,[[],["u"]]],[11,"from","","",320,[[["t"]],["t"]]],[11,"try_into","","",320,[[],["result"]]],[11,"try_from","","",320,[[["u"]],["result"]]],[11,"type_id","","",320,[[["self"]],["typeid"]]],[11,"borrow","","",321,[[["self"]],["t"]]],[11,"borrow_mut","","",321,[[["self"]],["t"]]],[11,"into","","",321,[[],["u"]]],[11,"from","","",321,[[["t"]],["t"]]],[11,"try_into","","",321,[[],["result"]]],[11,"try_from","","",321,[[["u"]],["result"]]],[11,"type_id","","",321,[[["self"]],["typeid"]]],[11,"borrow","","",322,[[["self"]],["t"]]],[11,"borrow_mut","","",322,[[["self"]],["t"]]],[11,"into","","",322,[[],["u"]]],[11,"from","","",322,[[["t"]],["t"]]],[11,"try_into","","",322,[[],["result"]]],[11,"try_from","","",322,[[["u"]],["result"]]],[11,"type_id","","",322,[[["self"]],["typeid"]]],[11,"borrow","","",323,[[["self"]],["t"]]],[11,"borrow_mut","","",323,[[["self"]],["t"]]],[11,"into","","",323,[[],["u"]]],[11,"from","","",323,[[["t"]],["t"]]],[11,"try_into","","",323,[[],["result"]]],[11,"try_from","","",323,[[["u"]],["result"]]],[11,"type_id","","",323,[[["self"]],["typeid"]]],[11,"borrow","","",324,[[["self"]],["t"]]],[11,"borrow_mut","","",324,[[["self"]],["t"]]],[11,"into","","",324,[[],["u"]]],[11,"from","","",324,[[["t"]],["t"]]],[11,"try_into","","",324,[[],["result"]]],[11,"try_from","","",324,[[["u"]],["result"]]],[11,"type_id","","",324,[[["self"]],["typeid"]]],[11,"borrow","","",165,[[["self"]],["t"]]],[11,"borrow_mut","","",165,[[["self"]],["t"]]],[11,"into","","",165,[[],["u"]]],[11,"from","","",165,[[["t"]],["t"]]],[11,"try_into","","",165,[[],["result"]]],[11,"try_from","","",165,[[["u"]],["result"]]],[11,"type_id","","",165,[[["self"]],["typeid"]]],[11,"borrow","","",166,[[["self"]],["t"]]],[11,"borrow_mut","","",166,[[["self"]],["t"]]],[11,"into","","",166,[[],["u"]]],[11,"from","","",166,[[["t"]],["t"]]],[11,"try_into","","",166,[[],["result"]]],[11,"try_from","","",166,[[["u"]],["result"]]],[11,"type_id","","",166,[[["self"]],["typeid"]]],[11,"borrow","","",167,[[["self"]],["t"]]],[11,"borrow_mut","","",167,[[["self"]],["t"]]],[11,"into","","",167,[[],["u"]]],[11,"from","","",167,[[["t"]],["t"]]],[11,"try_into","","",167,[[],["result"]]],[11,"try_from","","",167,[[["u"]],["result"]]],[11,"type_id","","",167,[[["self"]],["typeid"]]],[11,"borrow","","",168,[[["self"]],["t"]]],[11,"borrow_mut","","",168,[[["self"]],["t"]]],[11,"into","","",168,[[],["u"]]],[11,"from","","",168,[[["t"]],["t"]]],[11,"try_into","","",168,[[],["result"]]],[11,"try_from","","",168,[[["u"]],["result"]]],[11,"type_id","","",168,[[["self"]],["typeid"]]],[11,"borrow","","",169,[[["self"]],["t"]]],[11,"borrow_mut","","",169,[[["self"]],["t"]]],[11,"into","","",169,[[],["u"]]],[11,"from","","",169,[[["t"]],["t"]]],[11,"try_into","","",169,[[],["result"]]],[11,"try_from","","",169,[[["u"]],["result"]]],[11,"type_id","","",169,[[["self"]],["typeid"]]],[11,"borrow","","",170,[[["self"]],["t"]]],[11,"borrow_mut","","",170,[[["self"]],["t"]]],[11,"into","","",170,[[],["u"]]],[11,"from","","",170,[[["t"]],["t"]]],[11,"try_into","","",170,[[],["result"]]],[11,"try_from","","",170,[[["u"]],["result"]]],[11,"type_id","","",170,[[["self"]],["typeid"]]],[11,"borrow","","",171,[[["self"]],["t"]]],[11,"borrow_mut","","",171,[[["self"]],["t"]]],[11,"into","","",171,[[],["u"]]],[11,"from","","",171,[[["t"]],["t"]]],[11,"try_into","","",171,[[],["result"]]],[11,"try_from","","",171,[[["u"]],["result"]]],[11,"type_id","","",171,[[["self"]],["typeid"]]],[11,"borrow","","",172,[[["self"]],["t"]]],[11,"borrow_mut","","",172,[[["self"]],["t"]]],[11,"into","","",172,[[],["u"]]],[11,"from","","",172,[[["t"]],["t"]]],[11,"try_into","","",172,[[],["result"]]],[11,"try_from","","",172,[[["u"]],["result"]]],[11,"type_id","","",172,[[["self"]],["typeid"]]],[11,"borrow","","",173,[[["self"]],["t"]]],[11,"borrow_mut","","",173,[[["self"]],["t"]]],[11,"into","","",173,[[],["u"]]],[11,"from","","",173,[[["t"]],["t"]]],[11,"try_into","","",173,[[],["result"]]],[11,"try_from","","",173,[[["u"]],["result"]]],[11,"type_id","","",173,[[["self"]],["typeid"]]],[11,"borrow","core::arch::wasm32","",325,[[["self"]],["t"]]],[11,"borrow_mut","","",325,[[["self"]],["t"]]],[11,"into","","",325,[[],["u"]]],[11,"from","","",325,[[["t"]],["t"]]],[11,"try_into","","",325,[[],["result"]]],[11,"try_from","","",325,[[["u"]],["result"]]],[11,"type_id","","",325,[[["self"]],["typeid"]]],[11,"borrow","core::arch::mips","",326,[[["self"]],["t"]]],[11,"borrow_mut","","",326,[[["self"]],["t"]]],[11,"into","","",326,[[],["u"]]],[11,"from","","",326,[[["t"]],["t"]]],[11,"try_into","","",326,[[],["result"]]],[11,"try_from","","",326,[[["u"]],["result"]]],[11,"type_id","","",326,[[["self"]],["typeid"]]],[11,"borrow","","",327,[[["self"]],["t"]]],[11,"borrow_mut","","",327,[[["self"]],["t"]]],[11,"into","","",327,[[],["u"]]],[11,"from","","",327,[[["t"]],["t"]]],[11,"try_into","","",327,[[],["result"]]],[11,"try_from","","",327,[[["u"]],["result"]]],[11,"type_id","","",327,[[["self"]],["typeid"]]],[11,"borrow","","",328,[[["self"]],["t"]]],[11,"borrow_mut","","",328,[[["self"]],["t"]]],[11,"into","","",328,[[],["u"]]],[11,"from","","",328,[[["t"]],["t"]]],[11,"try_into","","",328,[[],["result"]]],[11,"try_from","","",328,[[["u"]],["result"]]],[11,"type_id","","",328,[[["self"]],["typeid"]]],[11,"borrow","","",329,[[["self"]],["t"]]],[11,"borrow_mut","","",329,[[["self"]],["t"]]],[11,"into","","",329,[[],["u"]]],[11,"from","","",329,[[["t"]],["t"]]],[11,"try_into","","",329,[[],["result"]]],[11,"try_from","","",329,[[["u"]],["result"]]],[11,"type_id","","",329,[[["self"]],["typeid"]]],[11,"borrow","","",330,[[["self"]],["t"]]],[11,"borrow_mut","","",330,[[["self"]],["t"]]],[11,"into","","",330,[[],["u"]]],[11,"from","","",330,[[["t"]],["t"]]],[11,"try_into","","",330,[[],["result"]]],[11,"try_from","","",330,[[["u"]],["result"]]],[11,"type_id","","",330,[[["self"]],["typeid"]]],[11,"borrow","","",331,[[["self"]],["t"]]],[11,"borrow_mut","","",331,[[["self"]],["t"]]],[11,"into","","",331,[[],["u"]]],[11,"from","","",331,[[["t"]],["t"]]],[11,"try_into","","",331,[[],["result"]]],[11,"try_from","","",331,[[["u"]],["result"]]],[11,"type_id","","",331,[[["self"]],["typeid"]]],[11,"borrow","","",332,[[["self"]],["t"]]],[11,"borrow_mut","","",332,[[["self"]],["t"]]],[11,"into","","",332,[[],["u"]]],[11,"from","","",332,[[["t"]],["t"]]],[11,"try_into","","",332,[[],["result"]]],[11,"try_from","","",332,[[["u"]],["result"]]],[11,"type_id","","",332,[[["self"]],["typeid"]]],[11,"borrow","","",333,[[["self"]],["t"]]],[11,"borrow_mut","","",333,[[["self"]],["t"]]],[11,"into","","",333,[[],["u"]]],[11,"from","","",333,[[["t"]],["t"]]],[11,"try_into","","",333,[[],["result"]]],[11,"try_from","","",333,[[["u"]],["result"]]],[11,"type_id","","",333,[[["self"]],["typeid"]]],[11,"borrow","","",334,[[["self"]],["t"]]],[11,"borrow_mut","","",334,[[["self"]],["t"]]],[11,"into","","",334,[[],["u"]]],[11,"from","","",334,[[["t"]],["t"]]],[11,"try_into","","",334,[[],["result"]]],[11,"try_from","","",334,[[["u"]],["result"]]],[11,"type_id","","",334,[[["self"]],["typeid"]]],[11,"borrow","","",335,[[["self"]],["t"]]],[11,"borrow_mut","","",335,[[["self"]],["t"]]],[11,"into","","",335,[[],["u"]]],[11,"from","","",335,[[["t"]],["t"]]],[11,"try_into","","",335,[[],["result"]]],[11,"try_from","","",335,[[["u"]],["result"]]],[11,"type_id","","",335,[[["self"]],["typeid"]]],[11,"borrow","core::arch::powerpc","",336,[[["self"]],["t"]]],[11,"borrow_mut","","",336,[[["self"]],["t"]]],[11,"into","","",336,[[],["u"]]],[11,"from","","",336,[[["t"]],["t"]]],[11,"try_into","","",336,[[],["result"]]],[11,"try_from","","",336,[[["u"]],["result"]]],[11,"type_id","","",336,[[["self"]],["typeid"]]],[11,"borrow","","",337,[[["self"]],["t"]]],[11,"borrow_mut","","",337,[[["self"]],["t"]]],[11,"into","","",337,[[],["u"]]],[11,"from","","",337,[[["t"]],["t"]]],[11,"try_into","","",337,[[],["result"]]],[11,"try_from","","",337,[[["u"]],["result"]]],[11,"type_id","","",337,[[["self"]],["typeid"]]],[11,"borrow","","",338,[[["self"]],["t"]]],[11,"borrow_mut","","",338,[[["self"]],["t"]]],[11,"into","","",338,[[],["u"]]],[11,"from","","",338,[[["t"]],["t"]]],[11,"try_into","","",338,[[],["result"]]],[11,"try_from","","",338,[[["u"]],["result"]]],[11,"type_id","","",338,[[["self"]],["typeid"]]],[11,"borrow","","",339,[[["self"]],["t"]]],[11,"borrow_mut","","",339,[[["self"]],["t"]]],[11,"into","","",339,[[],["u"]]],[11,"from","","",339,[[["t"]],["t"]]],[11,"try_into","","",339,[[],["result"]]],[11,"try_from","","",339,[[["u"]],["result"]]],[11,"type_id","","",339,[[["self"]],["typeid"]]],[11,"clone","core::num","",3,[[["self"]],["nonzerou8"]]],[11,"clone","","",4,[[["self"]],["nonzerou16"]]],[11,"clone","","",5,[[["self"]],["nonzerou32"]]],[11,"clone","","",6,[[["self"]],["nonzerou64"]]],[11,"clone","","",7,[[["self"]],["nonzerou128"]]],[11,"clone","","",8,[[["self"]],["nonzerousize"]]],[11,"clone","","",9,[[["self"]],["nonzeroi8"]]],[11,"clone","","",10,[[["self"]],["nonzeroi16"]]],[11,"clone","","",11,[[["self"]],["nonzeroi32"]]],[11,"clone","","",12,[[["self"]],["nonzeroi64"]]],[11,"clone","","",13,[[["self"]],["nonzeroi128"]]],[11,"clone","","",14,[[["self"]],["nonzeroisize"]]],[11,"clone","","",0,[[["self"]],["wrapping"]]],[11,"clone","","",184,[[["self"]],["parsefloaterror"]]],[11,"clone","","",1,[[["self"]],["fpcategory"]]],[11,"clone","","",183,[[["self"]],["tryfrominterror"]]],[11,"clone","","",15,[[["self"]],["parseinterror"]]],[11,"clone","","",2,[[["self"]],["interrorkind"]]],[11,"clone","core::mem","",16,[[["self"]],["manuallydrop"]]],[11,"clone","","",17,[[["self"]],["self"]]],[11,"clone","","",185,[[["self"]],["self"]]],[11,"clone","core::ptr","",18,[[["self"]],["self"]]],[11,"clone","core::cmp","",23,[[["self"]],["ordering"]]],[11,"clone","","",22,[[["self"]],["reverse"]]],[11,"clone","core::convert","",186,[[["self"]],["infallible"]]],[11,"clone","core::marker","",187,[[["self"]],["self"]]],[11,"clone","","",188,[[["self"]],["phantompinned"]]],[11,"clone","core::ops","",39,[[["self"]],["generatorstate"]]],[11,"clone","","",189,[[["self"]],["rangefull"]]],[11,"clone","","",34,[[["self"]],["range"]]],[11,"clone","","",35,[[["self"]],["rangefrom"]]],[11,"clone","","",36,[[["self"]],["rangeto"]]],[11,"clone","","",40,[[["self"]],["rangeinclusive"]]],[11,"clone","","",37,[[["self"]],["rangetoinclusive"]]],[11,"clone","","",38,[[["self"]],["bound"]]],[11,"clone","core::any","",75,[[["self"]],["typeid"]]],[11,"clone","core::array","",76,[[["self"]],["self"]]],[11,"clone","","",190,[[["self"]],["tryfromsliceerror"]]],[11,"clone","core::ascii","",191,[[["self"]],["escapedefault"]]],[11,"clone","core::cell","",78,[[["self"]],["cell"]]],[11,"clone","","Panics",79,[[["self"]],["refcell"]]],[11,"clone","core::char","",195,[[["self"]],["parsecharerror"]]],[11,"clone","","",194,[[["self"]],["chartryfromerror"]]],[11,"clone","","",196,[[["self"]],["decodeutf16"]]],[11,"clone","","",84,[[["self"]],["decodeutf16error"]]],[11,"clone","","",197,[[["self"]],["escapeunicode"]]],[11,"clone","","",198,[[["self"]],["escapedefault"]]],[11,"clone","","",199,[[["self"]],["escapedebug"]]],[11,"clone","","",200,[[["self"]],["tolowercase"]]],[11,"clone","","",201,[[["self"]],["touppercase"]]],[11,"clone","core::ffi","",85,[[["self"]],["self"]]],[11,"clone","core::iter","",216,[[["self"]],["chain"]]],[11,"clone","","",224,[[["self"]],["self"]]],[11,"clone","","",213,[[["self"]],["self"]]],[11,"clone","","",223,[[["self"]],["zip"]]],[11,"clone","","",222,[[["self"]],["rev"]]],[11,"clone","","",212,[[["self"]],["copied"]]],[11,"clone","","",211,[[["self"]],["cloned"]]],[11,"clone","","",217,[[["self"]],["cycle"]]],[11,"clone","","",215,[[["self"]],["stepby"]]],[11,"clone","","",221,[[["self"]],["map"]]],[11,"clone","","",219,[[["self"]],["filter"]]],[11,"clone","","",220,[[["self"]],["filtermap"]]],[11,"clone","","",218,[[["self"]],["enumerate"]]],[11,"clone","","",86,[[["self"]],["peekable"]]],[11,"clone","","",227,[[["self"]],["skipwhile"]]],[11,"clone","","",229,[[["self"]],["takewhile"]]],[11,"clone","","",214,[[["self"]],["mapwhile"]]],[11,"clone","","",226,[[["self"]],["skip"]]],[11,"clone","","",228,[[["self"]],["take"]]],[11,"clone","","",225,[[["self"]],["scan"]]],[11,"clone","","",230,[[["self"]],["fuse"]]],[11,"clone","","",231,[[["self"]],["inspect"]]],[11,"clone","","",208,[[["self"]],["repeat"]]],[11,"clone","","",209,[[["self"]],["repeatwith"]]],[11,"clone","","",204,[[["self"]],["empty"]]],[11,"clone","","",206,[[["self"]],["once"]]],[11,"clone","","",207,[[["self"]],["oncewith"]]],[11,"clone","","",205,[[["self"]],["fromfn"]]],[11,"clone","","",210,[[["self"]],["successors"]]],[11,"clone","core::option","",96,[[["self"]],["self"]]],[11,"clone_from","","",96,[[["self"],["self"]]]],[11,"clone","","",232,[[["self"]],["self"]]],[11,"clone","","",234,[[["self"]],["intoiter"]]],[11,"clone","","",235,[[["self"]],["noneerror"]]],[11,"clone","core::pin","",99,[[["self"]],["pin"]]],[11,"clone","core::raw","",100,[[["self"]],["traitobject"]]],[11,"clone","core::result","",101,[[["self"]],["self"]]],[11,"clone_from","","",101,[[["self"],["self"]]]],[11,"clone","","",236,[[["self"]],["self"]]],[11,"clone","","",238,[[["self"]],["intoiter"]]],[11,"clone","core::sync::atomic","",102,[[["self"]],["ordering"]]],[11,"clone","core::fmt","",239,[[["self"]],["error"]]],[11,"clone","","",240,[[["self"]],["arguments"]]],[11,"clone","core::hash","",132,[[["self"]],["siphasher"]]],[11,"clone","","",241,[[["self"]],["buildhasherdefault"]]],[11,"clone","core::slice","",137,[[["self"]],["self"]]],[11,"clone","","",242,[[["self"]],["self"]]],[11,"clone","","",243,[[["self"]],["self"]]],[11,"clone","","",246,[[["self"]],["rsplit"]]],[11,"clone","","",252,[[["self"]],["self"]]],[11,"clone","","",253,[[["self"]],["self"]]],[11,"clone","","",139,[[["self"]],["self"]]],[11,"clone","","",255,[[["self"]],["self"]]],[11,"clone","","",141,[[["self"]],["rchunksexact"]]],[11,"clone","core::str::pattern","",143,[[["self"]],["searchstep"]]],[11,"clone","","",278,[[["self"]],["charsearcher"]]],[11,"clone","","",279,[[["self"]],["charslicesearcher"]]],[11,"clone","","",280,[[["self"]],["charpredicatesearcher"]]],[11,"clone","","",281,[[["self"]],["strsearcher"]]],[11,"clone","core::str","",257,[[["self"]],["parseboolerror"]]],[11,"clone","","",150,[[["self"]],["utf8error"]]],[11,"clone","","",151,[[["self"]],["chars"]]],[11,"clone","","",152,[[["self"]],["charindices"]]],[11,"clone","","",258,[[["self"]],["bytes"]]],[11,"clone","","",259,[[["self"]],["self"]]],[11,"clone","","",260,[[["self"]],["self"]]],[11,"clone","","",261,[[["self"]],["self"]]],[11,"clone","","",262,[[["self"]],["self"]]],[11,"clone","","",263,[[["self"]],["self"]]],[11,"clone","","",264,[[["self"]],["self"]]],[11,"clone","","",265,[[["self"]],["self"]]],[11,"clone","","",266,[[["self"]],["self"]]],[11,"clone","","",267,[[["self"]],["self"]]],[11,"clone","","",268,[[["self"]],["self"]]],[11,"clone","","",269,[[["self"]],["lines"]]],[11,"clone","","",270,[[["self"]],["linesany"]]],[11,"clone","","",271,[[["self"]],["splitwhitespace"]]],[11,"clone","","",272,[[["self"]],["splitasciiwhitespace"]]],[11,"clone","","",273,[[["self"]],["self"]]],[11,"clone","","",274,[[["self"]],["encodeutf16"]]],[11,"clone","","",275,[[["self"]],["escapedebug"]]],[11,"clone","","",276,[[["self"]],["escapedefault"]]],[11,"clone","","",277,[[["self"]],["escapeunicode"]]],[11,"clone","core::time","",153,[[["self"]],["duration"]]],[11,"clone","core::char","",83,[[["self"]],["unicodeversion"]]],[11,"clone","core::task","",155,[[["self"]],["poll"]]],[11,"clone","","",157,[[["self"]],["rawwakervtable"]]],[11,"clone","","",159,[[["self"]],["self"]]],[11,"clone","core::alloc","",162,[[["self"]],["layout"]]],[11,"clone","","",283,[[["self"]],["layouterr"]]],[11,"clone","","",284,[[["self"]],["allocerr"]]],[11,"clone","","",163,[[["self"]],["cannotreallocinplace"]]],[11,"clone","core::arch::x86","",287,[[["self"]],["__m64"]]],[11,"clone","","",288,[[["self"]],["__m128i"]]],[11,"clone","","",289,[[["self"]],["__m128"]]],[11,"clone","","",290,[[["self"]],["__m128d"]]],[11,"clone","","",291,[[["self"]],["__m256i"]]],[11,"clone","","",292,[[["self"]],["__m256"]]],[11,"clone","","",293,[[["self"]],["__m256d"]]],[11,"clone","","",294,[[["self"]],["__m512i"]]],[11,"clone","","",295,[[["self"]],["__m512"]]],[11,"clone","","",296,[[["self"]],["__m512d"]]],[11,"clone","","",164,[[["self"]],["cpuidresult"]]],[11,"clone","core::arch::aarch64","",297,[[["self"]],["float64x1_t"]]],[11,"clone","","",298,[[["self"]],["float64x2_t"]]],[11,"clone","","",299,[[["self"]],["poly64x1_t"]]],[11,"clone","","",300,[[["self"]],["poly64_t"]]],[11,"clone","","",301,[[["self"]],["poly64x2_t"]]],[11,"clone","","",302,[[["self"]],["poly128_t"]]],[11,"clone","","",174,[[["self"]],["int8x16x2_t"]]],[11,"clone","","",175,[[["self"]],["int8x16x3_t"]]],[11,"clone","","",176,[[["self"]],["int8x16x4_t"]]],[11,"clone","","",177,[[["self"]],["uint8x16x2_t"]]],[11,"clone","","",178,[[["self"]],["uint8x16x3_t"]]],[11,"clone","","",179,[[["self"]],["uint8x16x4_t"]]],[11,"clone","","",180,[[["self"]],["poly8x16x2_t"]]],[11,"clone","","",181,[[["self"]],["poly8x16x3_t"]]],[11,"clone","","",182,[[["self"]],["poly8x16x4_t"]]],[11,"clone","core::arch::arm","",303,[[["self"]],["int8x8_t"]]],[11,"clone","","",304,[[["self"]],["uint8x8_t"]]],[11,"clone","","",305,[[["self"]],["poly8x8_t"]]],[11,"clone","","",306,[[["self"]],["int16x4_t"]]],[11,"clone","","",307,[[["self"]],["uint16x4_t"]]],[11,"clone","","",308,[[["self"]],["poly16x4_t"]]],[11,"clone","","",309,[[["self"]],["int32x2_t"]]],[11,"clone","","",310,[[["self"]],["uint32x2_t"]]],[11,"clone","","",311,[[["self"]],["float32x2_t"]]],[11,"clone","","",312,[[["self"]],["int64x1_t"]]],[11,"clone","","",313,[[["self"]],["uint64x1_t"]]],[11,"clone","","",314,[[["self"]],["int8x16_t"]]],[11,"clone","","",315,[[["self"]],["uint8x16_t"]]],[11,"clone","","",316,[[["self"]],["poly8x16_t"]]],[11,"clone","","",317,[[["self"]],["int16x8_t"]]],[11,"clone","","",318,[[["self"]],["uint16x8_t"]]],[11,"clone","","",319,[[["self"]],["poly16x8_t"]]],[11,"clone","","",320,[[["self"]],["int32x4_t"]]],[11,"clone","","",321,[[["self"]],["uint32x4_t"]]],[11,"clone","","",322,[[["self"]],["float32x4_t"]]],[11,"clone","","",323,[[["self"]],["int64x2_t"]]],[11,"clone","","",324,[[["self"]],["uint64x2_t"]]],[11,"clone","","",165,[[["self"]],["int8x8x2_t"]]],[11,"clone","","",166,[[["self"]],["int8x8x3_t"]]],[11,"clone","","",167,[[["self"]],["int8x8x4_t"]]],[11,"clone","","",168,[[["self"]],["uint8x8x2_t"]]],[11,"clone","","",169,[[["self"]],["uint8x8x3_t"]]],[11,"clone","","",170,[[["self"]],["uint8x8x4_t"]]],[11,"clone","","",171,[[["self"]],["poly8x8x2_t"]]],[11,"clone","","",172,[[["self"]],["poly8x8x3_t"]]],[11,"clone","","",173,[[["self"]],["poly8x8x4_t"]]],[11,"clone","core::arch::wasm32","",325,[[["self"]],["v128"]]],[11,"clone","core::arch::mips","",326,[[["self"]],["v16i8"]]],[11,"clone","","",327,[[["self"]],["v8i16"]]],[11,"clone","","",328,[[["self"]],["v4i32"]]],[11,"clone","","",329,[[["self"]],["v2i64"]]],[11,"clone","","",330,[[["self"]],["v16u8"]]],[11,"clone","","",331,[[["self"]],["v8u16"]]],[11,"clone","","",332,[[["self"]],["v4u32"]]],[11,"clone","","",333,[[["self"]],["v2u64"]]],[11,"clone","","",334,[[["self"]],["v4f32"]]],[11,"clone","","",335,[[["self"]],["v2f64"]]],[11,"clone","core::arch::powerpc","",336,[[["self"]],["vector_signed_long"]]],[11,"clone","","",337,[[["self"]],["vector_unsigned_long"]]],[11,"clone","","",338,[[["self"]],["vector_bool_long"]]],[11,"clone","","",339,[[["self"]],["vector_double"]]],[11,"eq","core::num","",3,[[["nonzerou8"],["self"]],["bool"]]],[11,"ne","","",3,[[["nonzerou8"],["self"]],["bool"]]],[11,"eq","","",4,[[["nonzerou16"],["self"]],["bool"]]],[11,"ne","","",4,[[["nonzerou16"],["self"]],["bool"]]],[11,"eq","","",5,[[["nonzerou32"],["self"]],["bool"]]],[11,"ne","","",5,[[["nonzerou32"],["self"]],["bool"]]],[11,"eq","","",6,[[["nonzerou64"],["self"]],["bool"]]],[11,"ne","","",6,[[["nonzerou64"],["self"]],["bool"]]],[11,"eq","","",7,[[["nonzerou128"],["self"]],["bool"]]],[11,"ne","","",7,[[["nonzerou128"],["self"]],["bool"]]],[11,"eq","","",8,[[["nonzerousize"],["self"]],["bool"]]],[11,"ne","","",8,[[["nonzerousize"],["self"]],["bool"]]],[11,"eq","","",9,[[["nonzeroi8"],["self"]],["bool"]]],[11,"ne","","",9,[[["nonzeroi8"],["self"]],["bool"]]],[11,"eq","","",10,[[["nonzeroi16"],["self"]],["bool"]]],[11,"ne","","",10,[[["nonzeroi16"],["self"]],["bool"]]],[11,"eq","","",11,[[["nonzeroi32"],["self"]],["bool"]]],[11,"ne","","",11,[[["nonzeroi32"],["self"]],["bool"]]],[11,"eq","","",12,[[["nonzeroi64"],["self"]],["bool"]]],[11,"ne","","",12,[[["nonzeroi64"],["self"]],["bool"]]],[11,"eq","","",13,[[["nonzeroi128"],["self"]],["bool"]]],[11,"ne","","",13,[[["nonzeroi128"],["self"]],["bool"]]],[11,"eq","","",14,[[["nonzeroisize"],["self"]],["bool"]]],[11,"ne","","",14,[[["nonzeroisize"],["self"]],["bool"]]],[11,"eq","","",0,[[["wrapping"],["self"]],["bool"]]],[11,"ne","","",0,[[["wrapping"],["self"]],["bool"]]],[11,"eq","","",184,[[["parsefloaterror"],["self"]],["bool"]]],[11,"ne","","",184,[[["parsefloaterror"],["self"]],["bool"]]],[11,"eq","","",1,[[["fpcategory"],["self"]],["bool"]]],[11,"eq","","",183,[[["tryfrominterror"],["self"]],["bool"]]],[11,"ne","","",183,[[["tryfrominterror"],["self"]],["bool"]]],[11,"eq","","",15,[[["parseinterror"],["self"]],["bool"]]],[11,"ne","","",15,[[["parseinterror"],["self"]],["bool"]]],[11,"eq","","",2,[[["interrorkind"],["self"]],["bool"]]],[11,"eq","core::mem","",16,[[["manuallydrop"],["self"]],["bool"]]],[11,"ne","","",16,[[["manuallydrop"],["self"]],["bool"]]],[11,"eq","","",185,[[["self"]],["bool"]]],[11,"eq","core::ptr","",18,[[["self"]],["bool"]]],[11,"eq","core::cmp","",23,[[["ordering"],["self"]],["bool"]]],[11,"eq","","",22,[[["reverse"],["self"]],["bool"]]],[11,"ne","","",22,[[["reverse"],["self"]],["bool"]]],[11,"eq","core::convert","",186,[[["infallible"],["self"]],["bool"]]],[11,"eq","core::marker","",187,[[["phantomdata"],["self"]],["bool"]]],[11,"eq","","",188,[[["phantompinned"],["self"]],["bool"]]],[11,"eq","core::ops","",39,[[["generatorstate"],["self"]],["bool"]]],[11,"ne","","",39,[[["generatorstate"],["self"]],["bool"]]],[11,"eq","","",189,[[["rangefull"],["self"]],["bool"]]],[11,"eq","","",34,[[["range"],["self"]],["bool"]]],[11,"ne","","",34,[[["range"],["self"]],["bool"]]],[11,"eq","","",35,[[["rangefrom"],["self"]],["bool"]]],[11,"ne","","",35,[[["rangefrom"],["self"]],["bool"]]],[11,"eq","","",36,[[["rangeto"],["self"]],["bool"]]],[11,"ne","","",36,[[["rangeto"],["self"]],["bool"]]],[11,"eq","","",40,[[["self"]],["bool"]]],[11,"eq","","",37,[[["rangetoinclusive"],["self"]],["bool"]]],[11,"ne","","",37,[[["rangetoinclusive"],["self"]],["bool"]]],[11,"eq","","",38,[[["bound"],["self"]],["bool"]]],[11,"ne","","",38,[[["bound"],["self"]],["bool"]]],[11,"eq","core::any","",75,[[["typeid"],["self"]],["bool"]]],[11,"ne","","",75,[[["typeid"],["self"]],["bool"]]],[11,"eq","core::cell","",78,[[["cell"],["self"]],["bool"]]],[11,"eq","","Panics",79,[[["refcell"],["self"]],["bool"]]],[11,"eq","core::char","",195,[[["parsecharerror"],["self"]],["bool"]]],[11,"ne","","",195,[[["parsecharerror"],["self"]],["bool"]]],[11,"eq","","",194,[[["chartryfromerror"],["self"]],["bool"]]],[11,"ne","","",194,[[["chartryfromerror"],["self"]],["bool"]]],[11,"eq","","",84,[[["decodeutf16error"],["self"]],["bool"]]],[11,"ne","","",84,[[["decodeutf16error"],["self"]],["bool"]]],[11,"eq","core::option","",96,[[["option"],["self"]],["bool"]]],[11,"ne","","",96,[[["option"],["self"]],["bool"]]],[11,"eq","","",235,[[["noneerror"],["self"]],["bool"]]],[11,"eq","core::pin","",99,[[["pin"],["self"]],["bool"]]],[11,"ne","","",99,[[["pin"],["self"]],["bool"]]],[11,"eq","core::result","",101,[[["result"],["self"]],["bool"]]],[11,"ne","","",101,[[["result"],["self"]],["bool"]]],[11,"eq","core::sync::atomic","",102,[[["ordering"],["self"]],["bool"]]],[11,"eq","core::fmt","",239,[[["error"],["self"]],["bool"]]],[11,"eq","core::hash","",241,[[["buildhasherdefault"],["self"]],["bool"]]],[11,"eq","core::str::pattern","",143,[[["searchstep"],["self"]],["bool"]]],[11,"ne","","",143,[[["searchstep"],["self"]],["bool"]]],[11,"eq","core::str::lossy","",147,[[["utf8lossychunk"],["self"]],["bool"]]],[11,"ne","","",147,[[["utf8lossychunk"],["self"]],["bool"]]],[11,"eq","core::str","",257,[[["parseboolerror"],["self"]],["bool"]]],[11,"ne","","",257,[[["parseboolerror"],["self"]],["bool"]]],[11,"eq","","",150,[[["utf8error"],["self"]],["bool"]]],[11,"ne","","",150,[[["utf8error"],["self"]],["bool"]]],[11,"eq","core::time","",153,[[["duration"],["self"]],["bool"]]],[11,"ne","","",153,[[["duration"],["self"]],["bool"]]],[11,"eq","core::char","",83,[[["unicodeversion"],["self"]],["bool"]]],[11,"ne","","",83,[[["unicodeversion"],["self"]],["bool"]]],[11,"eq","core::task","",155,[[["poll"],["self"]],["bool"]]],[11,"ne","","",155,[[["poll"],["self"]],["bool"]]],[11,"eq","","",156,[[["rawwaker"],["self"]],["bool"]]],[11,"ne","","",156,[[["rawwaker"],["self"]],["bool"]]],[11,"eq","","",157,[[["rawwakervtable"],["self"]],["bool"]]],[11,"ne","","",157,[[["rawwakervtable"],["self"]],["bool"]]],[11,"eq","core::alloc","",162,[[["layout"],["self"]],["bool"]]],[11,"ne","","",162,[[["layout"],["self"]],["bool"]]],[11,"eq","","",283,[[["layouterr"],["self"]],["bool"]]],[11,"ne","","",283,[[["layouterr"],["self"]],["bool"]]],[11,"eq","","",284,[[["allocerr"],["self"]],["bool"]]],[11,"eq","","",163,[[["cannotreallocinplace"],["self"]],["bool"]]],[11,"eq","core::arch::x86","",164,[[["cpuidresult"],["self"]],["bool"]]],[11,"ne","","",164,[[["cpuidresult"],["self"]],["bool"]]],[11,"cmp","core::num","",3,[[["nonzerou8"],["self"]],["ordering"]]],[11,"cmp","","",4,[[["nonzerou16"],["self"]],["ordering"]]],[11,"cmp","","",5,[[["nonzerou32"],["self"]],["ordering"]]],[11,"cmp","","",6,[[["nonzerou64"],["self"]],["ordering"]]],[11,"cmp","","",7,[[["nonzerou128"],["self"]],["ordering"]]],[11,"cmp","","",8,[[["nonzerousize"],["self"]],["ordering"]]],[11,"cmp","","",9,[[["nonzeroi8"],["self"]],["ordering"]]],[11,"cmp","","",10,[[["nonzeroi16"],["self"]],["ordering"]]],[11,"cmp","","",11,[[["nonzeroi32"],["self"]],["ordering"]]],[11,"cmp","","",12,[[["nonzeroi64"],["self"]],["ordering"]]],[11,"cmp","","",13,[[["nonzeroi128"],["self"]],["ordering"]]],[11,"cmp","","",14,[[["nonzeroisize"],["self"]],["ordering"]]],[11,"cmp","","",0,[[["wrapping"],["self"]],["ordering"]]],[11,"cmp","core::mem","",16,[[["manuallydrop"],["self"]],["ordering"]]],[11,"cmp","core::ptr","",18,[[["self"]],["ordering"]]],[11,"cmp","core::cmp","",22,[[["reverse"],["self"]],["ordering"]]],[11,"cmp","","",23,[[["ordering"],["self"]],["ordering"]]],[11,"cmp","core::convert","",186,[[["self"]],["ordering"]]],[11,"cmp","core::marker","",187,[[["phantomdata"],["self"]],["ordering"]]],[11,"cmp","","",188,[[["phantompinned"],["self"]],["ordering"]]],[11,"cmp","core::ops","",39,[[["generatorstate"],["self"]],["ordering"]]],[11,"cmp","core::any","",75,[[["typeid"],["self"]],["ordering"]]],[11,"cmp","core::cell","",78,[[["cell"],["self"]],["ordering"]]],[11,"cmp","","Panics",79,[[["refcell"],["self"]],["ordering"]]],[11,"cmp","core::option","",96,[[["option"],["self"]],["ordering"]]],[11,"cmp","","",235,[[["noneerror"],["self"]],["ordering"]]],[11,"cmp","core::pin","",99,[[["self"]],["ordering"]]],[11,"cmp","core::result","",101,[[["result"],["self"]],["ordering"]]],[11,"cmp","core::fmt","",239,[[["error"],["self"]],["ordering"]]],[11,"cmp","core::time","",153,[[["duration"],["self"]],["ordering"]]],[11,"cmp","core::char","",83,[[["unicodeversion"],["self"]],["ordering"]]],[11,"cmp","core::task","",155,[[["poll"],["self"]],["ordering"]]],[11,"cmp","core::arch::x86","",164,[[["cpuidresult"],["self"]],["ordering"]]],[11,"partial_cmp","core::num","",3,[[["nonzerou8"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",3,[[["nonzerou8"],["self"]],["bool"]]],[11,"le","","",3,[[["nonzerou8"],["self"]],["bool"]]],[11,"gt","","",3,[[["nonzerou8"],["self"]],["bool"]]],[11,"ge","","",3,[[["nonzerou8"],["self"]],["bool"]]],[11,"partial_cmp","","",4,[[["nonzerou16"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",4,[[["nonzerou16"],["self"]],["bool"]]],[11,"le","","",4,[[["nonzerou16"],["self"]],["bool"]]],[11,"gt","","",4,[[["nonzerou16"],["self"]],["bool"]]],[11,"ge","","",4,[[["nonzerou16"],["self"]],["bool"]]],[11,"partial_cmp","","",5,[[["nonzerou32"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",5,[[["nonzerou32"],["self"]],["bool"]]],[11,"le","","",5,[[["nonzerou32"],["self"]],["bool"]]],[11,"gt","","",5,[[["nonzerou32"],["self"]],["bool"]]],[11,"ge","","",5,[[["nonzerou32"],["self"]],["bool"]]],[11,"partial_cmp","","",6,[[["nonzerou64"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",6,[[["nonzerou64"],["self"]],["bool"]]],[11,"le","","",6,[[["nonzerou64"],["self"]],["bool"]]],[11,"gt","","",6,[[["nonzerou64"],["self"]],["bool"]]],[11,"ge","","",6,[[["nonzerou64"],["self"]],["bool"]]],[11,"partial_cmp","","",7,[[["nonzerou128"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",7,[[["nonzerou128"],["self"]],["bool"]]],[11,"le","","",7,[[["nonzerou128"],["self"]],["bool"]]],[11,"gt","","",7,[[["nonzerou128"],["self"]],["bool"]]],[11,"ge","","",7,[[["nonzerou128"],["self"]],["bool"]]],[11,"partial_cmp","","",8,[[["nonzerousize"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",8,[[["nonzerousize"],["self"]],["bool"]]],[11,"le","","",8,[[["nonzerousize"],["self"]],["bool"]]],[11,"gt","","",8,[[["nonzerousize"],["self"]],["bool"]]],[11,"ge","","",8,[[["nonzerousize"],["self"]],["bool"]]],[11,"partial_cmp","","",9,[[["nonzeroi8"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",9,[[["nonzeroi8"],["self"]],["bool"]]],[11,"le","","",9,[[["nonzeroi8"],["self"]],["bool"]]],[11,"gt","","",9,[[["nonzeroi8"],["self"]],["bool"]]],[11,"ge","","",9,[[["nonzeroi8"],["self"]],["bool"]]],[11,"partial_cmp","","",10,[[["nonzeroi16"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",10,[[["nonzeroi16"],["self"]],["bool"]]],[11,"le","","",10,[[["nonzeroi16"],["self"]],["bool"]]],[11,"gt","","",10,[[["nonzeroi16"],["self"]],["bool"]]],[11,"ge","","",10,[[["nonzeroi16"],["self"]],["bool"]]],[11,"partial_cmp","","",11,[[["nonzeroi32"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",11,[[["nonzeroi32"],["self"]],["bool"]]],[11,"le","","",11,[[["nonzeroi32"],["self"]],["bool"]]],[11,"gt","","",11,[[["nonzeroi32"],["self"]],["bool"]]],[11,"ge","","",11,[[["nonzeroi32"],["self"]],["bool"]]],[11,"partial_cmp","","",12,[[["nonzeroi64"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",12,[[["nonzeroi64"],["self"]],["bool"]]],[11,"le","","",12,[[["nonzeroi64"],["self"]],["bool"]]],[11,"gt","","",12,[[["nonzeroi64"],["self"]],["bool"]]],[11,"ge","","",12,[[["nonzeroi64"],["self"]],["bool"]]],[11,"partial_cmp","","",13,[[["nonzeroi128"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",13,[[["nonzeroi128"],["self"]],["bool"]]],[11,"le","","",13,[[["nonzeroi128"],["self"]],["bool"]]],[11,"gt","","",13,[[["nonzeroi128"],["self"]],["bool"]]],[11,"ge","","",13,[[["nonzeroi128"],["self"]],["bool"]]],[11,"partial_cmp","","",14,[[["nonzeroisize"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",14,[[["nonzeroisize"],["self"]],["bool"]]],[11,"le","","",14,[[["nonzeroisize"],["self"]],["bool"]]],[11,"gt","","",14,[[["nonzeroisize"],["self"]],["bool"]]],[11,"ge","","",14,[[["nonzeroisize"],["self"]],["bool"]]],[11,"partial_cmp","","",0,[[["wrapping"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",0,[[["wrapping"],["self"]],["bool"]]],[11,"le","","",0,[[["wrapping"],["self"]],["bool"]]],[11,"gt","","",0,[[["wrapping"],["self"]],["bool"]]],[11,"ge","","",0,[[["wrapping"],["self"]],["bool"]]],[11,"partial_cmp","core::mem","",16,[[["manuallydrop"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",16,[[["manuallydrop"],["self"]],["bool"]]],[11,"le","","",16,[[["manuallydrop"],["self"]],["bool"]]],[11,"gt","","",16,[[["manuallydrop"],["self"]],["bool"]]],[11,"ge","","",16,[[["manuallydrop"],["self"]],["bool"]]],[11,"partial_cmp","core::ptr","",18,[[["self"]],[["option",["ordering"]],["ordering"]]]],[11,"partial_cmp","core::cmp","",22,[[["reverse"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",22,[[["self"]],["bool"]]],[11,"le","","",22,[[["self"]],["bool"]]],[11,"gt","","",22,[[["self"]],["bool"]]],[11,"ge","","",22,[[["self"]],["bool"]]],[11,"partial_cmp","","",23,[[["ordering"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"partial_cmp","core::convert","",186,[[["self"]],[["option",["ordering"]],["ordering"]]]],[11,"partial_cmp","core::marker","",187,[[["phantomdata"],["self"]],[["ordering"],["option",["ordering"]]]]],[11,"partial_cmp","","",188,[[["phantompinned"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"partial_cmp","core::ops","",39,[[["generatorstate"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",39,[[["generatorstate"],["self"]],["bool"]]],[11,"le","","",39,[[["generatorstate"],["self"]],["bool"]]],[11,"gt","","",39,[[["generatorstate"],["self"]],["bool"]]],[11,"ge","","",39,[[["generatorstate"],["self"]],["bool"]]],[11,"partial_cmp","core::any","",75,[[["typeid"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",75,[[["typeid"],["self"]],["bool"]]],[11,"le","","",75,[[["typeid"],["self"]],["bool"]]],[11,"gt","","",75,[[["typeid"],["self"]],["bool"]]],[11,"ge","","",75,[[["typeid"],["self"]],["bool"]]],[11,"partial_cmp","core::cell","",78,[[["cell"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",78,[[["cell"],["self"]],["bool"]]],[11,"le","","",78,[[["cell"],["self"]],["bool"]]],[11,"gt","","",78,[[["cell"],["self"]],["bool"]]],[11,"ge","","",78,[[["cell"],["self"]],["bool"]]],[11,"partial_cmp","","Panics",79,[[["refcell"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","Panics",79,[[["refcell"],["self"]],["bool"]]],[11,"le","","Panics",79,[[["refcell"],["self"]],["bool"]]],[11,"gt","","Panics",79,[[["refcell"],["self"]],["bool"]]],[11,"ge","","Panics",79,[[["refcell"],["self"]],["bool"]]],[11,"partial_cmp","core::option","",96,[[["option"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",96,[[["option"],["self"]],["bool"]]],[11,"le","","",96,[[["option"],["self"]],["bool"]]],[11,"gt","","",96,[[["option"],["self"]],["bool"]]],[11,"ge","","",96,[[["option"],["self"]],["bool"]]],[11,"partial_cmp","","",235,[[["noneerror"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"partial_cmp","core::pin","",99,[[["pin"],["self"]],[["ordering"],["option",["ordering"]]]]],[11,"lt","","",99,[[["pin"],["self"]],["bool"]]],[11,"le","","",99,[[["pin"],["self"]],["bool"]]],[11,"gt","","",99,[[["pin"],["self"]],["bool"]]],[11,"ge","","",99,[[["pin"],["self"]],["bool"]]],[11,"partial_cmp","core::result","",101,[[["result"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",101,[[["result"],["self"]],["bool"]]],[11,"le","","",101,[[["result"],["self"]],["bool"]]],[11,"gt","","",101,[[["result"],["self"]],["bool"]]],[11,"ge","","",101,[[["result"],["self"]],["bool"]]],[11,"partial_cmp","core::fmt","",239,[[["error"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"partial_cmp","core::time","",153,[[["duration"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",153,[[["duration"],["self"]],["bool"]]],[11,"le","","",153,[[["duration"],["self"]],["bool"]]],[11,"gt","","",153,[[["duration"],["self"]],["bool"]]],[11,"ge","","",153,[[["duration"],["self"]],["bool"]]],[11,"partial_cmp","core::char","",83,[[["unicodeversion"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",83,[[["unicodeversion"],["self"]],["bool"]]],[11,"le","","",83,[[["unicodeversion"],["self"]],["bool"]]],[11,"gt","","",83,[[["unicodeversion"],["self"]],["bool"]]],[11,"ge","","",83,[[["unicodeversion"],["self"]],["bool"]]],[11,"partial_cmp","core::task","",155,[[["poll"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",155,[[["poll"],["self"]],["bool"]]],[11,"le","","",155,[[["poll"],["self"]],["bool"]]],[11,"gt","","",155,[[["poll"],["self"]],["bool"]]],[11,"ge","","",155,[[["poll"],["self"]],["bool"]]],[11,"partial_cmp","core::arch::x86","",164,[[["cpuidresult"],["self"]],[["option",["ordering"]],["ordering"]]]],[11,"lt","","",164,[[["cpuidresult"],["self"]],["bool"]]],[11,"le","","",164,[[["cpuidresult"],["self"]],["bool"]]],[11,"gt","","",164,[[["cpuidresult"],["self"]],["bool"]]],[11,"ge","","",164,[[["cpuidresult"],["self"]],["bool"]]],[11,"as_ref","core::slice","",137,[[["self"]]]],[11,"from","core::num","",183,[[["infallible"]],["tryfrominterror"]]],[11,"from","","",183,[[],["tryfrominterror"]]],[11,"from","core::ptr","",18,[[["t"]],["self"]]],[11,"from","","",18,[[["t"]],["self"]]],[11,"from","core::num","",4,[[["nonzerou8"]],["self"]]],[11,"from","","",5,[[["nonzerou8"]],["self"]]],[11,"from","","",6,[[["nonzerou8"]],["self"]]],[11,"from","","",7,[[["nonzerou8"]],["self"]]],[11,"from","","",8,[[["nonzerou8"]],["self"]]],[11,"from","","",5,[[["nonzerou16"]],["self"]]],[11,"from","","",6,[[["nonzerou16"]],["self"]]],[11,"from","","",7,[[["nonzerou16"]],["self"]]],[11,"from","","",8,[[["nonzerou16"]],["self"]]],[11,"from","","",6,[[["nonzerou32"]],["self"]]],[11,"from","","",7,[[["nonzerou32"]],["self"]]],[11,"from","","",7,[[["nonzerou64"]],["self"]]],[11,"from","","",10,[[["nonzeroi8"]],["self"]]],[11,"from","","",11,[[["nonzeroi8"]],["self"]]],[11,"from","","",12,[[["nonzeroi8"]],["self"]]],[11,"from","","",13,[[["nonzeroi8"]],["self"]]],[11,"from","","",14,[[["nonzeroi8"]],["self"]]],[11,"from","","",11,[[["nonzeroi16"]],["self"]]],[11,"from","","",12,[[["nonzeroi16"]],["self"]]],[11,"from","","",13,[[["nonzeroi16"]],["self"]]],[11,"from","","",14,[[["nonzeroi16"]],["self"]]],[11,"from","","",12,[[["nonzeroi32"]],["self"]]],[11,"from","","",13,[[["nonzeroi32"]],["self"]]],[11,"from","","",13,[[["nonzeroi64"]],["self"]]],[11,"from","","",10,[[["nonzerou8"]],["self"]]],[11,"from","","",11,[[["nonzerou8"]],["self"]]],[11,"from","","",12,[[["nonzerou8"]],["self"]]],[11,"from","","",13,[[["nonzerou8"]],["self"]]],[11,"from","","",14,[[["nonzerou8"]],["self"]]],[11,"from","","",11,[[["nonzerou16"]],["self"]]],[11,"from","","",12,[[["nonzerou16"]],["self"]]],[11,"from","","",13,[[["nonzerou16"]],["self"]]],[11,"from","","",12,[[["nonzerou32"]],["self"]]],[11,"from","","",13,[[["nonzerou32"]],["self"]]],[11,"from","","",13,[[["nonzerou64"]],["self"]]],[11,"from","core::convert","",186,[[],["self"]]],[11,"from","core::array","",190,[[["infallible"]],["tryfromsliceerror"]]],[11,"from","core::cell","",78,[[["t"]],["cell"]]],[11,"from","","",79,[[["t"]],["refcell"]]],[11,"from","","",82,[[["t"]],["unsafecell"]]],[11,"from","core::option","",96,[[["t"]],["option"]]],[11,"from","","",96,[[["option"]],[["t"],["option"]]]],[11,"from","","",96,[[["option"]],[["t"],["option"]]]],[11,"from","core::sync::atomic","Converts a `bool` into an `AtomicBool`.",103,[[["bool"]],["self"]]],[11,"from","","",104,[[],["self"]]],[11,"from","","Converts an `i8` into an `AtomicI8`.",105,[[["i8"]],["self"]]],[11,"from","","Converts an `u8` into an `AtomicU8`.",106,[[["u8"]],["self"]]],[11,"from","","Converts an `i16` into an `AtomicI16`.",107,[[["i16"]],["self"]]],[11,"from","","Converts an `u16` into an `AtomicU16`.",108,[[["u16"]],["self"]]],[11,"from","","Converts an `i32` into an `AtomicI32`.",109,[[["i32"]],["self"]]],[11,"from","","Converts an `u32` into an `AtomicU32`.",110,[[["u32"]],["self"]]],[11,"from","","Converts an `i64` into an `AtomicI64`.",111,[[["i64"]],["self"]]],[11,"from","","Converts an `u64` into an `AtomicU64`.",112,[[["u64"]],["self"]]],[11,"from","","Converts an `isize` into an `AtomicIsize`.",113,[[["isize"]],["self"]]],[11,"from","","Converts an `usize` into an `AtomicUsize`.",114,[[["usize"]],["self"]]],[11,"from","core::task","",155,[[["t"]],["poll"]]],[11,"default","core::num","",0,[[],["wrapping"]]],[11,"default","core::mem","",16,[[],["manuallydrop"]]],[11,"default","core::cmp","",22,[[],["reverse"]]],[11,"default","core::marker","",187,[[],["self"]]],[11,"default","core::cell","Creates a `Cell<T>`, with the `Default` value for T.",78,[[],["cell"]]],[11,"default","","Creates a `RefCell<T>`, with the `Default` value for T.",79,[[],["refcell"]]],[11,"default","","Creates an `UnsafeCell`, with the `Default` value for T.",82,[[],["unsafecell"]]],[11,"default","core::iter","",204,[[],["empty"]]],[11,"default","core::option","Returns [`None`][Option::None].",96,[[],["option"]]],[11,"default","core::sync::atomic","Creates an `AtomicBool` initialized to `false`.",103,[[],["self"]]],[11,"default","","Creates a null `AtomicPtr<T>`.",104,[[],["atomicptr"]]],[11,"default","","",105,[[],["self"]]],[11,"default","","",106,[[],["self"]]],[11,"default","","",107,[[],["self"]]],[11,"default","","",108,[[],["self"]]],[11,"default","","",109,[[],["self"]]],[11,"default","","",110,[[],["self"]]],[11,"default","","",111,[[],["self"]]],[11,"default","","",112,[[],["self"]]],[11,"default","","",113,[[],["self"]]],[11,"default","","",114,[[],["self"]]],[11,"default","core::fmt","",239,[[],["error"]]],[11,"default","core::hash","",132,[[],["siphasher"]]],[11,"default","","",241,[[],["buildhasherdefault"]]],[11,"default","core::time","",153,[[],["duration"]]],[11,"add","core::num","",0,[[["wrapping",["usize"]],["usize"]],[["wrapping",["usize"]],["usize"]]]],[11,"add","","",0,[[["wrapping"]]]],[11,"add","","",0,[[["wrapping",["u8"]],["u8"]],[["wrapping",["u8"]],["u8"]]]],[11,"add","","",0,[[["wrapping"]]]],[11,"add","","",0,[[["u16"],["wrapping",["u16"]]],[["u16"],["wrapping",["u16"]]]]],[11,"add","","",0,[[["wrapping"]]]],[11,"add","","",0,[[["u32"],["wrapping",["u32"]]],[["u32"],["wrapping",["u32"]]]]],[11,"add","","",0,[[["wrapping"]]]],[11,"add","","",0,[[["wrapping",["u64"]],["u64"]],[["wrapping",["u64"]],["u64"]]]],[11,"add","","",0,[[["wrapping"]]]],[11,"add","","",0,[[["wrapping",["u128"]],["u128"]],[["wrapping",["u128"]],["u128"]]]],[11,"add","","",0,[[["wrapping"]]]],[11,"add","","",0,[[["isize"],["wrapping",["isize"]]],[["isize"],["wrapping",["isize"]]]]],[11,"add","","",0,[[["wrapping"]]]],[11,"add","","",0,[[["wrapping",["i8"]],["i8"]],[["wrapping",["i8"]],["i8"]]]],[11,"add","","",0,[[["wrapping"]]]],[11,"add","","",0,[[["wrapping",["i16"]],["i16"]],[["wrapping",["i16"]],["i16"]]]],[11,"add","","",0,[[["wrapping"]]]],[11,"add","","",0,[[["wrapping",["i32"]],["i32"]],[["wrapping",["i32"]],["i32"]]]],[11,"add","","",0,[[["wrapping"]]]],[11,"add","","",0,[[["i64"],["wrapping",["i64"]]],[["i64"],["wrapping",["i64"]]]]],[11,"add","","",0,[[["wrapping"]]]],[11,"add","","",0,[[["i128"],["wrapping",["i128"]]],[["i128"],["wrapping",["i128"]]]]],[11,"add","","",0,[[["wrapping"]]]],[11,"add","core::time","",153,[[["duration"]],["duration"]]],[11,"sub","core::num","",0,[[["wrapping",["usize"]],["usize"]],[["wrapping",["usize"]],["usize"]]]],[11,"sub","","",0,[[["wrapping"]]]],[11,"sub","","",0,[[["wrapping",["u8"]],["u8"]],[["wrapping",["u8"]],["u8"]]]],[11,"sub","","",0,[[["wrapping"]]]],[11,"sub","","",0,[[["u16"],["wrapping",["u16"]]],[["u16"],["wrapping",["u16"]]]]],[11,"sub","","",0,[[["wrapping"]]]],[11,"sub","","",0,[[["u32"],["wrapping",["u32"]]],[["u32"],["wrapping",["u32"]]]]],[11,"sub","","",0,[[["wrapping"]]]],[11,"sub","","",0,[[["wrapping",["u64"]],["u64"]],[["wrapping",["u64"]],["u64"]]]],[11,"sub","","",0,[[["wrapping"]]]],[11,"sub","","",0,[[["wrapping",["u128"]],["u128"]],[["wrapping",["u128"]],["u128"]]]],[11,"sub","","",0,[[["wrapping"]]]],[11,"sub","","",0,[[["isize"],["wrapping",["isize"]]],[["isize"],["wrapping",["isize"]]]]],[11,"sub","","",0,[[["wrapping"]]]],[11,"sub","","",0,[[["wrapping",["i8"]],["i8"]],[["wrapping",["i8"]],["i8"]]]],[11,"sub","","",0,[[["wrapping"]]]],[11,"sub","","",0,[[["wrapping",["i16"]],["i16"]],[["wrapping",["i16"]],["i16"]]]],[11,"sub","","",0,[[["wrapping"]]]],[11,"sub","","",0,[[["wrapping",["i32"]],["i32"]],[["wrapping",["i32"]],["i32"]]]],[11,"sub","","",0,[[["wrapping"]]]],[11,"sub","","",0,[[["i64"],["wrapping",["i64"]]],[["i64"],["wrapping",["i64"]]]]],[11,"sub","","",0,[[["wrapping"]]]],[11,"sub","","",0,[[["i128"],["wrapping",["i128"]]],[["i128"],["wrapping",["i128"]]]]],[11,"sub","","",0,[[["wrapping"]]]],[11,"sub","core::time","",153,[[["duration"]],["duration"]]],[11,"mul","core::num","",0,[[["wrapping",["usize"]],["usize"]],[["wrapping",["usize"]],["usize"]]]],[11,"mul","","",0,[[["wrapping"]]]],[11,"mul","","",0,[[["wrapping",["u8"]],["u8"]],[["wrapping",["u8"]],["u8"]]]],[11,"mul","","",0,[[["wrapping"]]]],[11,"mul","","",0,[[["u16"],["wrapping",["u16"]]],[["u16"],["wrapping",["u16"]]]]],[11,"mul","","",0,[[["wrapping"]]]],[11,"mul","","",0,[[["u32"],["wrapping",["u32"]]],[["u32"],["wrapping",["u32"]]]]],[11,"mul","","",0,[[["wrapping"]]]],[11,"mul","","",0,[[["wrapping",["u64"]],["u64"]],[["wrapping",["u64"]],["u64"]]]],[11,"mul","","",0,[[["wrapping"]]]],[11,"mul","","",0,[[["wrapping",["u128"]],["u128"]],[["wrapping",["u128"]],["u128"]]]],[11,"mul","","",0,[[["wrapping"]]]],[11,"mul","","",0,[[["isize"],["wrapping",["isize"]]],[["isize"],["wrapping",["isize"]]]]],[11,"mul","","",0,[[["wrapping"]]]],[11,"mul","","",0,[[["wrapping",["i8"]],["i8"]],[["wrapping",["i8"]],["i8"]]]],[11,"mul","","",0,[[["wrapping"]]]],[11,"mul","","",0,[[["wrapping",["i16"]],["i16"]],[["wrapping",["i16"]],["i16"]]]],[11,"mul","","",0,[[["wrapping"]]]],[11,"mul","","",0,[[["wrapping",["i32"]],["i32"]],[["wrapping",["i32"]],["i32"]]]],[11,"mul","","",0,[[["wrapping"]]]],[11,"mul","","",0,[[["i64"],["wrapping",["i64"]]],[["i64"],["wrapping",["i64"]]]]],[11,"mul","","",0,[[["wrapping"]]]],[11,"mul","","",0,[[["i128"],["wrapping",["i128"]]],[["i128"],["wrapping",["i128"]]]]],[11,"mul","","",0,[[["wrapping"]]]],[11,"mul","core::time","",153,[[["u32"]],["duration"]]],[11,"div","core::num","",0,[[["wrapping",["usize"]],["usize"]],[["wrapping",["usize"]],["usize"]]]],[11,"div","","",0,[[["wrapping"]]]],[11,"div","","",0,[[["wrapping",["u8"]],["u8"]],[["wrapping",["u8"]],["u8"]]]],[11,"div","","",0,[[["wrapping"]]]],[11,"div","","",0,[[["u16"],["wrapping",["u16"]]],[["u16"],["wrapping",["u16"]]]]],[11,"div","","",0,[[["wrapping"]]]],[11,"div","","",0,[[["u32"],["wrapping",["u32"]]],[["u32"],["wrapping",["u32"]]]]],[11,"div","","",0,[[["wrapping"]]]],[11,"div","","",0,[[["wrapping",["u64"]],["u64"]],[["wrapping",["u64"]],["u64"]]]],[11,"div","","",0,[[["wrapping"]]]],[11,"div","","",0,[[["wrapping",["u128"]],["u128"]],[["wrapping",["u128"]],["u128"]]]],[11,"div","","",0,[[["wrapping"]]]],[11,"div","","",0,[[["isize"],["wrapping",["isize"]]],[["isize"],["wrapping",["isize"]]]]],[11,"div","","",0,[[["wrapping"]]]],[11,"div","","",0,[[["wrapping",["i8"]],["i8"]],[["wrapping",["i8"]],["i8"]]]],[11,"div","","",0,[[["wrapping"]]]],[11,"div","","",0,[[["wrapping",["i16"]],["i16"]],[["wrapping",["i16"]],["i16"]]]],[11,"div","","",0,[[["wrapping"]]]],[11,"div","","",0,[[["wrapping",["i32"]],["i32"]],[["wrapping",["i32"]],["i32"]]]],[11,"div","","",0,[[["wrapping"]]]],[11,"div","","",0,[[["i64"],["wrapping",["i64"]]],[["i64"],["wrapping",["i64"]]]]],[11,"div","","",0,[[["wrapping"]]]],[11,"div","","",0,[[["i128"],["wrapping",["i128"]]],[["i128"],["wrapping",["i128"]]]]],[11,"div","","",0,[[["wrapping"]]]],[11,"div","core::time","",153,[[["u32"]],["duration"]]],[11,"rem","core::num","",0,[[["wrapping",["usize"]],["usize"]],[["wrapping",["usize"]],["usize"]]]],[11,"rem","","",0,[[["wrapping"]]]],[11,"rem","","",0,[[["wrapping",["u8"]],["u8"]],[["wrapping",["u8"]],["u8"]]]],[11,"rem","","",0,[[["wrapping"]]]],[11,"rem","","",0,[[["u16"],["wrapping",["u16"]]],[["u16"],["wrapping",["u16"]]]]],[11,"rem","","",0,[[["wrapping"]]]],[11,"rem","","",0,[[["u32"],["wrapping",["u32"]]],[["u32"],["wrapping",["u32"]]]]],[11,"rem","","",0,[[["wrapping"]]]],[11,"rem","","",0,[[["wrapping",["u64"]],["u64"]],[["wrapping",["u64"]],["u64"]]]],[11,"rem","","",0,[[["wrapping"]]]],[11,"rem","","",0,[[["wrapping",["u128"]],["u128"]],[["wrapping",["u128"]],["u128"]]]],[11,"rem","","",0,[[["wrapping"]]]],[11,"rem","","",0,[[["isize"],["wrapping",["isize"]]],[["isize"],["wrapping",["isize"]]]]],[11,"rem","","",0,[[["wrapping"]]]],[11,"rem","","",0,[[["wrapping",["i8"]],["i8"]],[["wrapping",["i8"]],["i8"]]]],[11,"rem","","",0,[[["wrapping"]]]],[11,"rem","","",0,[[["wrapping",["i16"]],["i16"]],[["wrapping",["i16"]],["i16"]]]],[11,"rem","","",0,[[["wrapping"]]]],[11,"rem","","",0,[[["wrapping",["i32"]],["i32"]],[["wrapping",["i32"]],["i32"]]]],[11,"rem","","",0,[[["wrapping"]]]],[11,"rem","","",0,[[["i64"],["wrapping",["i64"]]],[["i64"],["wrapping",["i64"]]]]],[11,"rem","","",0,[[["wrapping"]]]],[11,"rem","","",0,[[["i128"],["wrapping",["i128"]]],[["i128"],["wrapping",["i128"]]]]],[11,"rem","","",0,[[["wrapping"]]]],[11,"neg","","",0,[[],["self"]]],[11,"neg","","",0,[[],["self"]]],[11,"neg","","",0,[[],["self"]]],[11,"neg","","",0,[[],["self"]]],[11,"neg","","",0,[[],["self"]]],[11,"neg","","",0,[[],["self"]]],[11,"neg","","",0,[[],["self"]]],[11,"neg","","",0,[[],["self"]]],[11,"neg","","",0,[[],["self"]]],[11,"neg","","",0,[[],["self"]]],[11,"neg","","",0,[[],["self"]]],[11,"neg","","",0,[[],["self"]]],[11,"add_assign","","",0,[[["self"],["wrapping",["usize"]],["usize"]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","","",0,[[["self"],["wrapping",["u8"]],["u8"]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","","",0,[[["u16"],["self"],["wrapping",["u16"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","","",0,[[["self"],["u32"],["wrapping",["u32"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","","",0,[[["self"],["wrapping",["u64"]],["u64"]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","","",0,[[["self"],["wrapping",["u128"]],["u128"]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","","",0,[[["isize"],["self"],["wrapping",["isize"]]]]],[11,"add_assign","","",0,[[["wrapping"],["self"]]]],[11,"add_assign","","",0,[[["wrapping",["i8"]],["self"],["i8"]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","","",0,[[["self"],["wrapping",["i16"]],["i16"]]]],[11,"add_assign","","",0,[[["wrapping"],["self"]]]],[11,"add_assign","","",0,[[["self"],["wrapping",["i32"]],["i32"]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","","",0,[[["i64"],["self"],["wrapping",["i64"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","","",0,[[["self"],["i128"],["wrapping",["i128"]]]]],[11,"add_assign","","",0,[[["self"],["wrapping"]]]],[11,"add_assign","core::time","",153,[[["self"],["duration"]]]],[11,"sub_assign","core::num","",0,[[["self"],["wrapping",["usize"]],["usize"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping",["u8"]],["u8"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","","",0,[[["u16"],["self"],["wrapping",["u16"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","","",0,[[["self"],["u32"],["wrapping",["u32"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping",["u64"]],["u64"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping",["u128"]],["u128"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","","",0,[[["isize"],["self"],["wrapping",["isize"]]]]],[11,"sub_assign","","",0,[[["wrapping"],["self"]]]],[11,"sub_assign","","",0,[[["wrapping",["i8"]],["self"],["i8"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping",["i16"]],["i16"]]]],[11,"sub_assign","","",0,[[["wrapping"],["self"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping",["i32"]],["i32"]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","","",0,[[["i64"],["self"],["wrapping",["i64"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","","",0,[[["self"],["i128"],["wrapping",["i128"]]]]],[11,"sub_assign","","",0,[[["self"],["wrapping"]]]],[11,"sub_assign","core::time","",153,[[["self"],["duration"]]]],[11,"mul_assign","core::num","",0,[[["self"],["wrapping",["usize"]],["usize"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping",["u8"]],["u8"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","","",0,[[["u16"],["self"],["wrapping",["u16"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","","",0,[[["self"],["u32"],["wrapping",["u32"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping",["u64"]],["u64"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping",["u128"]],["u128"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","","",0,[[["isize"],["self"],["wrapping",["isize"]]]]],[11,"mul_assign","","",0,[[["wrapping"],["self"]]]],[11,"mul_assign","","",0,[[["wrapping",["i8"]],["self"],["i8"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping",["i16"]],["i16"]]]],[11,"mul_assign","","",0,[[["wrapping"],["self"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping",["i32"]],["i32"]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","","",0,[[["i64"],["self"],["wrapping",["i64"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","","",0,[[["self"],["i128"],["wrapping",["i128"]]]]],[11,"mul_assign","","",0,[[["self"],["wrapping"]]]],[11,"mul_assign","core::time","",153,[[["self"],["u32"]]]],[11,"div_assign","core::num","",0,[[["self"],["wrapping",["usize"]],["usize"]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","","",0,[[["self"],["wrapping",["u8"]],["u8"]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","","",0,[[["u16"],["self"],["wrapping",["u16"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","","",0,[[["self"],["u32"],["wrapping",["u32"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","","",0,[[["self"],["wrapping",["u64"]],["u64"]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","","",0,[[["self"],["wrapping",["u128"]],["u128"]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","","",0,[[["isize"],["self"],["wrapping",["isize"]]]]],[11,"div_assign","","",0,[[["wrapping"],["self"]]]],[11,"div_assign","","",0,[[["wrapping",["i8"]],["self"],["i8"]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","","",0,[[["self"],["wrapping",["i16"]],["i16"]]]],[11,"div_assign","","",0,[[["wrapping"],["self"]]]],[11,"div_assign","","",0,[[["self"],["wrapping",["i32"]],["i32"]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","","",0,[[["i64"],["self"],["wrapping",["i64"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","","",0,[[["self"],["i128"],["wrapping",["i128"]]]]],[11,"div_assign","","",0,[[["self"],["wrapping"]]]],[11,"div_assign","core::time","",153,[[["self"],["u32"]]]],[11,"rem_assign","core::num","",0,[[["self"],["wrapping",["usize"]],["usize"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping",["u8"]],["u8"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem_assign","","",0,[[["u16"],["self"],["wrapping",["u16"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem_assign","","",0,[[["self"],["u32"],["wrapping",["u32"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping",["u64"]],["u64"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping",["u128"]],["u128"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem_assign","","",0,[[["isize"],["self"],["wrapping",["isize"]]]]],[11,"rem_assign","","",0,[[["wrapping"],["self"]]]],[11,"rem_assign","","",0,[[["wrapping",["i8"]],["self"],["i8"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping",["i16"]],["i16"]]]],[11,"rem_assign","","",0,[[["wrapping"],["self"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping",["i32"]],["i32"]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem_assign","","",0,[[["i64"],["self"],["wrapping",["i64"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"rem_assign","","",0,[[["self"],["i128"],["wrapping",["i128"]]]]],[11,"rem_assign","","",0,[[["self"],["wrapping"]]]],[11,"not","","",0,[[],[["wrapping",["usize"]],["usize"]]]],[11,"not","","",0,[[],[["wrapping",["u8"]],["u8"]]]],[11,"not","","",0,[[],[["u16"],["wrapping",["u16"]]]]],[11,"not","","",0,[[],[["u32"],["wrapping",["u32"]]]]],[11,"not","","",0,[[],[["wrapping",["u64"]],["u64"]]]],[11,"not","","",0,[[],[["wrapping",["u128"]],["u128"]]]],[11,"not","","",0,[[],[["isize"],["wrapping",["isize"]]]]],[11,"not","","",0,[[],[["wrapping",["i8"]],["i8"]]]],[11,"not","","",0,[[],[["wrapping",["i16"]],["i16"]]]],[11,"not","","",0,[[],[["wrapping",["i32"]],["i32"]]]],[11,"not","","",0,[[],[["i64"],["wrapping",["i64"]]]]],[11,"not","","",0,[[],[["i128"],["wrapping",["i128"]]]]],[11,"bitand","","",0,[[["wrapping",["usize"]],["usize"]],[["wrapping",["usize"]],["usize"]]]],[11,"bitand","","",0,[[["wrapping"]]]],[11,"bitand","","",0,[[["wrapping",["u8"]],["u8"]],[["wrapping",["u8"]],["u8"]]]],[11,"bitand","","",0,[[["wrapping"]]]],[11,"bitand","","",0,[[["u16"],["wrapping",["u16"]]],[["u16"],["wrapping",["u16"]]]]],[11,"bitand","","",0,[[["wrapping"]]]],[11,"bitand","","",0,[[["u32"],["wrapping",["u32"]]],[["u32"],["wrapping",["u32"]]]]],[11,"bitand","","",0,[[["wrapping"]]]],[11,"bitand","","",0,[[["wrapping",["u64"]],["u64"]],[["wrapping",["u64"]],["u64"]]]],[11,"bitand","","",0,[[["wrapping"]]]],[11,"bitand","","",0,[[["wrapping",["u128"]],["u128"]],[["wrapping",["u128"]],["u128"]]]],[11,"bitand","","",0,[[["wrapping"]]]],[11,"bitand","","",0,[[["isize"],["wrapping",["isize"]]],[["isize"],["wrapping",["isize"]]]]],[11,"bitand","","",0,[[["wrapping"]]]],[11,"bitand","","",0,[[["wrapping",["i8"]],["i8"]],[["wrapping",["i8"]],["i8"]]]],[11,"bitand","","",0,[[["wrapping"]]]],[11,"bitand","","",0,[[["wrapping",["i16"]],["i16"]],[["wrapping",["i16"]],["i16"]]]],[11,"bitand","","",0,[[["wrapping"]]]],[11,"bitand","","",0,[[["wrapping",["i32"]],["i32"]],[["wrapping",["i32"]],["i32"]]]],[11,"bitand","","",0,[[["wrapping"]]]],[11,"bitand","","",0,[[["i64"],["wrapping",["i64"]]],[["i64"],["wrapping",["i64"]]]]],[11,"bitand","","",0,[[["wrapping"]]]],[11,"bitand","","",0,[[["i128"],["wrapping",["i128"]]],[["i128"],["wrapping",["i128"]]]]],[11,"bitand","","",0,[[["wrapping"]]]],[11,"bitor","","",0,[[["wrapping",["usize"]],["usize"]],[["wrapping",["usize"]],["usize"]]]],[11,"bitor","","",0,[[["wrapping"]]]],[11,"bitor","","",0,[[["wrapping",["u8"]],["u8"]],[["wrapping",["u8"]],["u8"]]]],[11,"bitor","","",0,[[["wrapping"]]]],[11,"bitor","","",0,[[["u16"],["wrapping",["u16"]]],[["u16"],["wrapping",["u16"]]]]],[11,"bitor","","",0,[[["wrapping"]]]],[11,"bitor","","",0,[[["u32"],["wrapping",["u32"]]],[["u32"],["wrapping",["u32"]]]]],[11,"bitor","","",0,[[["wrapping"]]]],[11,"bitor","","",0,[[["wrapping",["u64"]],["u64"]],[["wrapping",["u64"]],["u64"]]]],[11,"bitor","","",0,[[["wrapping"]]]],[11,"bitor","","",0,[[["wrapping",["u128"]],["u128"]],[["wrapping",["u128"]],["u128"]]]],[11,"bitor","","",0,[[["wrapping"]]]],[11,"bitor","","",0,[[["isize"],["wrapping",["isize"]]],[["isize"],["wrapping",["isize"]]]]],[11,"bitor","","",0,[[["wrapping"]]]],[11,"bitor","","",0,[[["wrapping",["i8"]],["i8"]],[["wrapping",["i8"]],["i8"]]]],[11,"bitor","","",0,[[["wrapping"]]]],[11,"bitor","","",0,[[["wrapping",["i16"]],["i16"]],[["wrapping",["i16"]],["i16"]]]],[11,"bitor","","",0,[[["wrapping"]]]],[11,"bitor","","",0,[[["wrapping",["i32"]],["i32"]],[["wrapping",["i32"]],["i32"]]]],[11,"bitor","","",0,[[["wrapping"]]]],[11,"bitor","","",0,[[["i64"],["wrapping",["i64"]]],[["i64"],["wrapping",["i64"]]]]],[11,"bitor","","",0,[[["wrapping"]]]],[11,"bitor","","",0,[[["i128"],["wrapping",["i128"]]],[["i128"],["wrapping",["i128"]]]]],[11,"bitor","","",0,[[["wrapping"]]]],[11,"bitxor","","",0,[[["wrapping",["usize"]],["usize"]],[["wrapping",["usize"]],["usize"]]]],[11,"bitxor","","",0,[[["wrapping"]]]],[11,"bitxor","","",0,[[["wrapping",["u8"]],["u8"]],[["wrapping",["u8"]],["u8"]]]],[11,"bitxor","","",0,[[["wrapping"]]]],[11,"bitxor","","",0,[[["u16"],["wrapping",["u16"]]],[["u16"],["wrapping",["u16"]]]]],[11,"bitxor","","",0,[[["wrapping"]]]],[11,"bitxor","","",0,[[["u32"],["wrapping",["u32"]]],[["u32"],["wrapping",["u32"]]]]],[11,"bitxor","","",0,[[["wrapping"]]]],[11,"bitxor","","",0,[[["wrapping",["u64"]],["u64"]],[["wrapping",["u64"]],["u64"]]]],[11,"bitxor","","",0,[[["wrapping"]]]],[11,"bitxor","","",0,[[["wrapping",["u128"]],["u128"]],[["wrapping",["u128"]],["u128"]]]],[11,"bitxor","","",0,[[["wrapping"]]]],[11,"bitxor","","",0,[[["isize"],["wrapping",["isize"]]],[["isize"],["wrapping",["isize"]]]]],[11,"bitxor","","",0,[[["wrapping"]]]],[11,"bitxor","","",0,[[["wrapping",["i8"]],["i8"]],[["wrapping",["i8"]],["i8"]]]],[11,"bitxor","","",0,[[["wrapping"]]]],[11,"bitxor","","",0,[[["wrapping",["i16"]],["i16"]],[["wrapping",["i16"]],["i16"]]]],[11,"bitxor","","",0,[[["wrapping"]]]],[11,"bitxor","","",0,[[["wrapping",["i32"]],["i32"]],[["wrapping",["i32"]],["i32"]]]],[11,"bitxor","","",0,[[["wrapping"]]]],[11,"bitxor","","",0,[[["i64"],["wrapping",["i64"]]],[["i64"],["wrapping",["i64"]]]]],[11,"bitxor","","",0,[[["wrapping"]]]],[11,"bitxor","","",0,[[["i128"],["wrapping",["i128"]]],[["i128"],["wrapping",["i128"]]]]],[11,"bitxor","","",0,[[["wrapping"]]]],[11,"shl","","",0,[[["usize"]],[["wrapping",["u8"]],["u8"]]]],[11,"shl","","",0,[[["usize"]]]],[11,"shl","","",0,[[["usize"]],[["u16"],["wrapping",["u16"]]]]],[11,"shl","","",0,[[["usize"]]]],[11,"shl","","",0,[[["usize"]],[["u32"],["wrapping",["u32"]]]]],[11,"shl","","",0,[[["usize"]]]],[11,"shl","","",0,[[["usize"]],[["wrapping",["u64"]],["u64"]]]],[11,"shl","","",0,[[["usize"]]]],[11,"shl","","",0,[[["usize"]],[["wrapping",["u128"]],["u128"]]]],[11,"shl","","",0,[[["usize"]]]],[11,"shl","","",0,[[["usize"]],[["wrapping",["usize"]],["usize"]]]],[11,"shl","","",0,[[["usize"]]]],[11,"shl","","",0,[[["usize"]],[["wrapping",["i8"]],["i8"]]]],[11,"shl","","",0,[[["usize"]]]],[11,"shl","","",0,[[["usize"]],[["wrapping",["i16"]],["i16"]]]],[11,"shl","","",0,[[["usize"]]]],[11,"shl","","",0,[[["usize"]],[["wrapping",["i32"]],["i32"]]]],[11,"shl","","",0,[[["usize"]]]],[11,"shl","","",0,[[["usize"]],[["i64"],["wrapping",["i64"]]]]],[11,"shl","","",0,[[["usize"]]]],[11,"shl","","",0,[[["usize"]],[["i128"],["wrapping",["i128"]]]]],[11,"shl","","",0,[[["usize"]]]],[11,"shl","","",0,[[["usize"]],[["isize"],["wrapping",["isize"]]]]],[11,"shl","","",0,[[["usize"]]]],[11,"shr","","",0,[[["usize"]],[["wrapping",["u8"]],["u8"]]]],[11,"shr","","",0,[[["usize"]]]],[11,"shr","","",0,[[["usize"]],[["u16"],["wrapping",["u16"]]]]],[11,"shr","","",0,[[["usize"]]]],[11,"shr","","",0,[[["usize"]],[["u32"],["wrapping",["u32"]]]]],[11,"shr","","",0,[[["usize"]]]],[11,"shr","","",0,[[["usize"]],[["wrapping",["u64"]],["u64"]]]],[11,"shr","","",0,[[["usize"]]]],[11,"shr","","",0,[[["usize"]],[["wrapping",["u128"]],["u128"]]]],[11,"shr","","",0,[[["usize"]]]],[11,"shr","","",0,[[["usize"]],[["wrapping",["usize"]],["usize"]]]],[11,"shr","","",0,[[["usize"]]]],[11,"shr","","",0,[[["usize"]],[["wrapping",["i8"]],["i8"]]]],[11,"shr","","",0,[[["usize"]]]],[11,"shr","","",0,[[["usize"]],[["wrapping",["i16"]],["i16"]]]],[11,"shr","","",0,[[["usize"]]]],[11,"shr","","",0,[[["usize"]],[["wrapping",["i32"]],["i32"]]]],[11,"shr","","",0,[[["usize"]]]],[11,"shr","","",0,[[["usize"]],[["i64"],["wrapping",["i64"]]]]],[11,"shr","","",0,[[["usize"]]]],[11,"shr","","",0,[[["usize"]],[["i128"],["wrapping",["i128"]]]]],[11,"shr","","",0,[[["usize"]]]],[11,"shr","","",0,[[["usize"]],[["isize"],["wrapping",["isize"]]]]],[11,"shr","","",0,[[["usize"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping",["usize"]],["usize"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping",["u8"]],["u8"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand_assign","","",0,[[["u16"],["self"],["wrapping",["u16"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand_assign","","",0,[[["self"],["u32"],["wrapping",["u32"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping",["u64"]],["u64"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping",["u128"]],["u128"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand_assign","","",0,[[["isize"],["self"],["wrapping",["isize"]]]]],[11,"bitand_assign","","",0,[[["wrapping"],["self"]]]],[11,"bitand_assign","","",0,[[["wrapping",["i8"]],["self"],["i8"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping",["i16"]],["i16"]]]],[11,"bitand_assign","","",0,[[["wrapping"],["self"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping",["i32"]],["i32"]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand_assign","","",0,[[["i64"],["self"],["wrapping",["i64"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitand_assign","","",0,[[["self"],["i128"],["wrapping",["i128"]]]]],[11,"bitand_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping",["usize"]],["usize"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping",["u8"]],["u8"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["u16"],["self"],["wrapping",["u16"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["self"],["u32"],["wrapping",["u32"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping",["u64"]],["u64"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping",["u128"]],["u128"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["isize"],["self"],["wrapping",["isize"]]]]],[11,"bitor_assign","","",0,[[["wrapping"],["self"]]]],[11,"bitor_assign","","",0,[[["wrapping",["i8"]],["self"],["i8"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping",["i16"]],["i16"]]]],[11,"bitor_assign","","",0,[[["wrapping"],["self"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping",["i32"]],["i32"]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["i64"],["self"],["wrapping",["i64"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitor_assign","","",0,[[["self"],["i128"],["wrapping",["i128"]]]]],[11,"bitor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["usize"]],["usize"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["u8"]],["u8"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["u16"],["self"],["wrapping",["u16"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["self"],["u32"],["wrapping",["u32"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["u64"]],["u64"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["u128"]],["u128"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["isize"],["self"],["wrapping",["isize"]]]]],[11,"bitxor_assign","","",0,[[["wrapping"],["self"]]]],[11,"bitxor_assign","","",0,[[["wrapping",["i8"]],["self"],["i8"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["i16"]],["i16"]]]],[11,"bitxor_assign","","",0,[[["wrapping"],["self"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping",["i32"]],["i32"]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["i64"],["self"],["wrapping",["i64"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"bitxor_assign","","",0,[[["self"],["i128"],["wrapping",["i128"]]]]],[11,"bitxor_assign","","",0,[[["self"],["wrapping"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shl_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"shr_assign","","",0,[[["self"],["usize"]]]],[11,"deref","core::mem","",16,[[["self"]],["t"]]],[11,"deref","core::cell","",80,[[["self"]],["t"]]],[11,"deref","","",81,[[["self"]],["t"]]],[11,"deref","core::ffi","",202,[[["self"]],["valistimpl"]]],[11,"deref","core::pin","",99,[[["self"]]]],[11,"deref_mut","core::mem","",16,[[["self"]],["t"]]],[11,"deref_mut","core::cell","",81,[[["self"]],["t"]]],[11,"deref_mut","core::ffi","",202,[[["self"]],["valistimpl"]]],[11,"deref_mut","core::pin","",99,[[["self"]]]],[11,"drop","core::array","",76,[[["self"]]]],[11,"drop","core::ffi","",85,[[["self"]]]],[11,"drop","core::task","",159,[[["self"]]]],[11,"resume","core::pin","",99,[[["r"],["self"],["pin"]],["generatorstate"]]],[11,"start_bound","core::ops","",189,[[["self"]],[["t"],["bound"]]]],[11,"end_bound","","",189,[[["self"]],[["t"],["bound"]]]],[11,"start_bound","","",35,[[["self"]],[["t"],["bound"]]]],[11,"end_bound","","",35,[[["self"]],[["t"],["bound"]]]],[11,"start_bound","","",36,[[["self"]],[["t"],["bound"]]]],[11,"end_bound","","",36,[[["self"]],[["t"],["bound"]]]],[11,"start_bound","","",34,[[["self"]],[["t"],["bound"]]]],[11,"end_bound","","",34,[[["self"]],[["t"],["bound"]]]],[11,"start_bound","","",40,[[["self"]],[["t"],["bound"]]]],[11,"end_bound","","",40,[[["self"]],[["t"],["bound"]]]],[11,"start_bound","","",37,[[["self"]],[["t"],["bound"]]]],[11,"end_bound","","",37,[[["self"]],[["t"],["bound"]]]],[11,"start_bound","","",35,[[["self"]],[["t"],["bound"]]]],[11,"end_bound","","",35,[[["self"]],[["t"],["bound"]]]],[11,"start_bound","","",36,[[["self"]],[["t"],["bound"]]]],[11,"end_bound","","",36,[[["self"]],[["t"],["bound"]]]],[11,"start_bound","","",34,[[["self"]],[["t"],["bound"]]]],[11,"end_bound","","",34,[[["self"]],[["t"],["bound"]]]],[11,"start_bound","","",40,[[["self"]],[["t"],["bound"]]]],[11,"end_bound","","",40,[[["self"]],[["t"],["bound"]]]],[11,"start_bound","","",37,[[["self"]],[["t"],["bound"]]]],[11,"end_bound","","",37,[[["self"]],[["t"],["bound"]]]],[11,"into_result","core::option","",96,[[],[["noneerror"],["result",["noneerror"]]]]],[11,"from_ok","","",96,[[["t"]],["self"]]],[11,"from_error","","",96,[[["noneerror"]],["self"]]],[11,"into_result","core::result","",101,[[],["self"]]],[11,"from_ok","","",101,[[["t"]],["self"]]],[11,"from_error","","",101,[[["e"]],["self"]]],[11,"into_result","core::task","",155,[[],["result"]]],[11,"from_error","","",155,[[],["self"]]],[11,"from_ok","","",155,[[],["self"]]],[11,"into_result","","",155,[[],["result"]]],[11,"from_error","","",155,[[],["self"]]],[11,"from_ok","","",155,[[],["self"]]],[11,"sum","core::num","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","","",0,[[["iterator"]],["self"]]],[11,"sum","core::result","Takes each element in the `Iterator`: if it is an `Err`,…",101,[[["i"]],["result"]]],[11,"sum","core::option","Takes each element in the `Iterator`: if it is a `None`,…",96,[[["i"]],["option"]]],[11,"sum","core::time","",153,[[["iterator"]],["duration"]]],[11,"sum","","",153,[[["iterator"]],["duration"]]],[11,"product","core::num","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","","",0,[[["iterator"]],["self"]]],[11,"product","core::result","Takes each element in the `Iterator`: if it is an `Err`,…",101,[[["i"]],["result"]]],[11,"product","core::option","Takes each element in the `Iterator`: if it is a `None`,…",96,[[["i"]],["option"]]],[11,"from_iter","","Takes each element in the [`Iterator`]: if it is…",96,[[["intoiterator"]],["option"]]],[11,"from_iter","core::result","Takes each element in the `Iterator`: if it is an `Err`,…",101,[[["intoiterator"]],["result"]]],[11,"into_iter","core::option","Returns a consuming iterator over the possibly contained…",96,[[],["intoiter"]]],[11,"into_iter","core::result","Returns a consuming iterator over the possibly contained…",101,[[],["intoiter"]]],[11,"next_back","core::array","",76,[[["self"]],["option"]]],[11,"next_back","core::ascii","",191,[[["self"]],[["option",["u8"]],["u8"]]]],[11,"next_back","core::iter","",216,[[["self"]],["option"]]],[11,"nth_back","","",216,[[["self"],["usize"]],["option"]]],[11,"try_rfold","","",216,[[["self"],["acc"],["f"]],["r"]]],[11,"rfold","","",216,[[["acc"],["f"]],["acc"]]],[11,"next_back","","",224,[[["self"]],["option"]]],[11,"try_rfold","","",224,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",224,[[["acc"],["fold"]],["acc"]]],[11,"next_back","","",213,[[["self"]],["option"]]],[11,"try_rfold","","",213,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",213,[[["acc"],["fold"]],["acc"]]],[11,"next_back","","",223,[[["self"]],["option"]]],[11,"next_back","","",222,[[["self"]],["option"]]],[11,"nth_back","","",222,[[["self"],["usize"]],["option"]]],[11,"try_rfold","","",222,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","",222,[[["acc"],["f"]],["acc"]]],[11,"rfind","","",222,[[["self"],["p"]],["option"]]],[11,"next_back","","",212,[[["self"]],["option"]]],[11,"try_rfold","","",212,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","",212,[[["acc"],["f"]],["acc"]]],[11,"next_back","","",211,[[["self"]],["option"]]],[11,"try_rfold","","",211,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","",211,[[["acc"],["f"]],["acc"]]],[11,"next_back","","",215,[[["self"]],["option"]]],[11,"nth_back","","",215,[[["self"],["usize"]],["option"]]],[11,"try_rfold","","",215,[[["self"],["acc"],["f"]],["r"]]],[11,"next_back","","",221,[[["self"]],["option"]]],[11,"try_rfold","","",221,[[["self"],["acc"],["g"]],["r"]]],[11,"rfold","","",221,[[["acc"],["g"]],["acc"]]],[11,"next_back","","",219,[[["self"]],["option"]]],[11,"try_rfold","","",219,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",219,[[["acc"],["fold"]],["acc"]]],[11,"next_back","","",220,[[["self"]],["option"]]],[11,"try_rfold","","",220,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",220,[[["acc"],["fold"]],["acc"]]],[11,"next_back","","",218,[[["self"]],["option"]]],[11,"nth_back","","",218,[[["self"],["usize"]],["option"]]],[11,"try_rfold","","",218,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",218,[[["acc"],["fold"]],["acc"]]],[11,"next_back","","",86,[[["self"]],["option"]]],[11,"try_rfold","","",86,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","",86,[[["acc"],["fold"]],["acc"]]],[11,"next_back","","",226,[[["self"]],["option"]]],[11,"nth_back","","",226,[[["self"],["usize"]],["option"]]],[11,"try_rfold","","",226,[[["self"],["acc"],["fold"]],["r"]]],[11,"next_back","","",228,[[["self"]],["option"]]],[11,"nth_back","","",228,[[["self"],["usize"]],["option"]]],[11,"try_rfold","","",228,[[["self"],["acc"],["fold"]],["r"]]],[11,"next_back","","",230,[[["self"]],["option"]]],[11,"nth_back","","",230,[[["self"],["usize"]],["option"]]],[11,"try_rfold","","",230,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",230,[[["acc"],["fold"]],["acc"]]],[11,"next_back","","",230,[[["self"]],["option"]]],[11,"nth_back","","",230,[[["self"],["usize"]],["option"]]],[11,"try_rfold","","",230,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",230,[[["acc"],["fold"]],["acc"]]],[11,"next_back","","",231,[[["self"]],["option"]]],[11,"try_rfold","","",231,[[["self"],["acc"],["fold"]],["r"]]],[11,"rfold","","",231,[[["acc"],["fold"]],["acc"]]],[11,"next_back","core::ops","",34,[[["self"]],["option"]]],[11,"nth_back","","",34,[[["self"],["usize"]],["option"]]],[11,"next_back","","",40,[[["self"]],["option"]]],[11,"nth_back","","",40,[[["self"],["usize"]],["option"]]],[11,"try_rfold","","",40,[[["self"],["b"],["f"]],["r"]]],[11,"next_back","core::iter","",208,[[["self"]],["option"]]],[11,"next_back","","",204,[[["self"]],["option"]]],[11,"next_back","","",206,[[["self"]],["option"]]],[11,"next_back","","",207,[[["self"]],["option"]]],[11,"next_back","core::option","",232,[[["self"]],[["a"],["option"]]]],[11,"next_back","","",233,[[["self"]],[["a"],["option"]]]],[11,"next_back","","",234,[[["self"]],["option"]]],[11,"next_back","core::result","",236,[[["self"]],[["t"],["option"]]]],[11,"next_back","","",237,[[["self"]],[["t"],["option"]]]],[11,"next_back","","",238,[[["self"]],["option"]]],[11,"next_back","core::slice","",137,[[["self"]],[["t"],["option"]]]],[11,"nth_back","","",137,[[["self"],["usize"]],[["t"],["option"]]]],[11,"next_back","","",138,[[["self"]],[["t"],["option"]]]],[11,"nth_back","","",138,[[["self"],["usize"]],[["t"],["option"]]]],[11,"next_back","","",242,[[["self"]],["option"]]],[11,"next_back","","",243,[[["self"]],["option"]]],[11,"next_back","","",244,[[["self"]],["option"]]],[11,"next_back","","",245,[[["self"]],["option"]]],[11,"next_back","","",246,[[["self"]],["option"]]],[11,"next_back","","",247,[[["self"]],["option"]]],[11,"next_back","","",252,[[["self"]],["option"]]],[11,"nth_back","","",252,[[["self"],["usize"]],["option"]]],[11,"next_back","","",253,[[["self"]],["option"]]],[11,"nth_back","","",253,[[["self"],["usize"]],["option"]]],[11,"next_back","","",254,[[["self"]],["option"]]],[11,"nth_back","","",254,[[["self"],["usize"]],["option"]]],[11,"next_back","","",139,[[["self"]],["option"]]],[11,"nth_back","","",139,[[["self"],["usize"]],["option"]]],[11,"next_back","","",140,[[["self"]],["option"]]],[11,"nth_back","","",140,[[["self"],["usize"]],["option"]]],[11,"next_back","","",255,[[["self"]],["option"]]],[11,"nth_back","","",255,[[["self"],["usize"]],["option"]]],[11,"next_back","","",256,[[["self"]],["option"]]],[11,"nth_back","","",256,[[["self"],["usize"]],["option"]]],[11,"next_back","","",141,[[["self"]],["option"]]],[11,"nth_back","","",141,[[["self"],["usize"]],["option"]]],[11,"next_back","","",142,[[["self"]],["option"]]],[11,"nth_back","","",142,[[["self"],["usize"]],["option"]]],[11,"next_back","core::str","",151,[[["self"]],[["char"],["option",["char"]]]]],[11,"next_back","","",152,[[["self"]],["option"]]],[11,"next_back","","",258,[[["self"]],[["option",["u8"]],["u8"]]]],[11,"nth_back","","",258,[[["self"],["usize"]],["option"]]],[11,"rfind","","",258,[[["self"],["p"]],["option"]]],[11,"next_back","","",259,[[["self"]],[["str"],["option",["str"]]]]],[11,"next_back","","",260,[[["self"]],[["str"],["option",["str"]]]]],[11,"next_back","","",261,[[["self"]],[["str"],["option",["str"]]]]],[11,"next_back","","",262,[[["self"]],[["str"],["option",["str"]]]]],[11,"next_back","","",265,[[["self"]],["option"]]],[11,"next_back","","",266,[[["self"]],["option"]]],[11,"next_back","","",267,[[["self"]],[["str"],["option",["str"]]]]],[11,"next_back","","",268,[[["self"]],[["str"],["option",["str"]]]]],[11,"next_back","","",269,[[["self"]],[["str"],["option",["str"]]]]],[11,"next_back","","",270,[[["self"]],[["str"],["option",["str"]]]]],[11,"next_back","","",271,[[["self"]],[["str"],["option",["str"]]]]],[11,"next_back","","",272,[[["self"]],[["str"],["option",["str"]]]]],[11,"next_back","","",273,[[["self"]],[["str"],["option",["str"]]]]],[11,"len","core::array","",76,[[["self"]],["usize"]]],[11,"is_empty","","",76,[[["self"]],["bool"]]],[11,"len","core::char","",197,[[["self"]],["usize"]]],[11,"len","","",198,[[["self"]],["usize"]]],[11,"len","core::iter","",222,[[["self"]],["usize"]]],[11,"is_empty","","",222,[[["self"]],["bool"]]],[11,"len","","",212,[[["self"]],["usize"]]],[11,"is_empty","","",212,[[["self"]],["bool"]]],[11,"len","","",211,[[["self"]],["usize"]]],[11,"is_empty","","",211,[[["self"]],["bool"]]],[11,"len","","",221,[[["self"]],["usize"]]],[11,"is_empty","","",221,[[["self"]],["bool"]]],[11,"len","","",218,[[["self"]],["usize"]]],[11,"is_empty","","",218,[[["self"]],["bool"]]],[11,"len","","",230,[[["self"]],["usize"]]],[11,"is_empty","","",230,[[["self"]],["bool"]]],[11,"len","","",231,[[["self"]],["usize"]]],[11,"is_empty","","",231,[[["self"]],["bool"]]],[11,"len","","",204,[[["self"]],["usize"]]],[11,"len","","",206,[[["self"]],["usize"]]],[11,"len","","",207,[[["self"]],["usize"]]],[11,"len","core::slice","",137,[[["self"]],["usize"]]],[11,"is_empty","","",137,[[["self"]],["bool"]]],[11,"len","","",138,[[["self"]],["usize"]]],[11,"is_empty","","",138,[[["self"]],["bool"]]],[11,"is_empty","","",139,[[["self"]],["bool"]]],[11,"is_empty","","",140,[[["self"]],["bool"]]],[11,"is_empty","","",141,[[["self"]],["bool"]]],[11,"is_empty","","",142,[[["self"]],["bool"]]],[11,"len","core::str","",258,[[["self"]],["usize"]]],[11,"is_empty","","",258,[[["self"]],["bool"]]],[11,"next","core::array","",76,[[["self"]],["option"]]],[11,"size_hint","","",76,[[["self"]]]],[11,"count","","",76,[[],["usize"]]],[11,"last","","",76,[[],["option"]]],[11,"next","core::ascii","",191,[[["self"]],[["option",["u8"]],["u8"]]]],[11,"size_hint","","",191,[[["self"]]]],[11,"last","","",191,[[],[["option",["u8"]],["u8"]]]],[11,"next","core::char","",196,[[["self"]],[["result",["char","decodeutf16error"]],["option",["result"]]]]],[11,"size_hint","","",196,[[["self"]]]],[11,"next","","",197,[[["self"]],[["char"],["option",["char"]]]]],[11,"size_hint","","",197,[[["self"]]]],[11,"count","","",197,[[],["usize"]]],[11,"last","","",197,[[],[["char"],["option",["char"]]]]],[11,"next","","",198,[[["self"]],[["char"],["option",["char"]]]]],[11,"size_hint","","",198,[[["self"]]]],[11,"count","","",198,[[],["usize"]]],[11,"nth","","",198,[[["self"],["usize"]],[["char"],["option",["char"]]]]],[11,"last","","",198,[[],[["char"],["option",["char"]]]]],[11,"next","","",199,[[["self"]],[["char"],["option",["char"]]]]],[11,"size_hint","","",199,[[["self"]]]],[11,"next","","",200,[[["self"]],[["char"],["option",["char"]]]]],[11,"size_hint","","",200,[[["self"]]]],[11,"next","","",201,[[["self"]],[["char"],["option",["char"]]]]],[11,"size_hint","","",201,[[["self"]]]],[11,"next","core::iter","",216,[[["self"]],["option"]]],[11,"count","","",216,[[],["usize"]]],[11,"try_fold","","",216,[[["self"],["acc"],["f"]],["r"]]],[11,"fold","","",216,[[["acc"],["f"]],["acc"]]],[11,"nth","","",216,[[["self"],["usize"]],["option"]]],[11,"find","","",216,[[["self"],["p"]],["option"]]],[11,"last","","",216,[[],["option"]]],[11,"size_hint","","",216,[[["self"]]]],[11,"next","","",224,[[["self"]],["option"]]],[11,"size_hint","","",224,[[["self"]]]],[11,"try_fold","","",224,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",224,[[["acc"],["fold"]],["acc"]]],[11,"next","","",213,[[["self"]],["option"]]],[11,"size_hint","","",213,[[["self"]]]],[11,"try_fold","","",213,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",213,[[["acc"],["fold"]],["acc"]]],[11,"next","","",223,[[["self"]],["option"]]],[11,"size_hint","","",223,[[["self"]]]],[11,"nth","","",223,[[["self"],["usize"]],["option"]]],[11,"next","","",222,[[["self"]],["option"]]],[11,"size_hint","","",222,[[["self"]]]],[11,"nth","","",222,[[["self"],["usize"]],["option"]]],[11,"try_fold","","",222,[[["self"],["b"],["f"]],["r"]]],[11,"fold","","",222,[[["acc"],["f"]],["acc"]]],[11,"find","","",222,[[["self"],["p"]],["option"]]],[11,"next","","",212,[[["self"]],["option"]]],[11,"size_hint","","",212,[[["self"]]]],[11,"try_fold","","",212,[[["self"],["b"],["f"]],["r"]]],[11,"fold","","",212,[[["acc"],["f"]],["acc"]]],[11,"next","","",211,[[["self"]],["option"]]],[11,"size_hint","","",211,[[["self"]]]],[11,"try_fold","","",211,[[["self"],["b"],["f"]],["r"]]],[11,"fold","","",211,[[["acc"],["f"]],["acc"]]],[11,"next","","",217,[[["self"]],["option"]]],[11,"size_hint","","",217,[[["self"]]]],[11,"try_fold","","",217,[[["self"],["acc"],["f"]],["r"]]],[11,"next","","",215,[[["self"]],["option"]]],[11,"size_hint","","",215,[[["self"]]]],[11,"nth","","",215,[[["self"],["usize"]],["option"]]],[11,"try_fold","","",215,[[["self"],["acc"],["f"]],["r"]]],[11,"next","","",221,[[["self"]],["option"]]],[11,"size_hint","","",221,[[["self"]]]],[11,"try_fold","","",221,[[["self"],["acc"],["g"]],["r"]]],[11,"fold","","",221,[[["acc"],["g"]],["acc"]]],[11,"next","","",219,[[["self"]],["option"]]],[11,"size_hint","","",219,[[["self"]]]],[11,"count","","",219,[[],["usize"]]],[11,"try_fold","","",219,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",219,[[["acc"],["fold"]],["acc"]]],[11,"next","","",220,[[["self"]],["option"]]],[11,"size_hint","","",220,[[["self"]]]],[11,"try_fold","","",220,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",220,[[["acc"],["fold"]],["acc"]]],[11,"next","","Overflow Behavior",218,[[["self"]],["option"]]],[11,"size_hint","","",218,[[["self"]]]],[11,"nth","","",218,[[["self"],["usize"]],["option"]]],[11,"count","","",218,[[],["usize"]]],[11,"try_fold","","",218,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",218,[[["acc"],["fold"]],["acc"]]],[11,"next","","",86,[[["self"]],["option"]]],[11,"count","","",86,[[],["usize"]]],[11,"nth","","",86,[[["self"],["usize"]],["option"]]],[11,"last","","",86,[[],["option"]]],[11,"size_hint","","",86,[[["self"]]]],[11,"try_fold","","",86,[[["self"],["b"],["f"]],["r"]]],[11,"fold","","",86,[[["acc"],["fold"]],["acc"]]],[11,"next","","",227,[[["self"]],["option"]]],[11,"size_hint","","",227,[[["self"]]]],[11,"try_fold","","",227,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",227,[[["acc"],["fold"]],["acc"]]],[11,"next","","",229,[[["self"]],["option"]]],[11,"size_hint","","",229,[[["self"]]]],[11,"try_fold","","",229,[[["self"],["acc"],["fold"]],["r"]]],[11,"next","","",214,[[["self"]],["option"]]],[11,"size_hint","","",214,[[["self"]]]],[11,"try_fold","","",214,[[["self"],["acc"],["fold"]],["r"]]],[11,"next","","",226,[[["self"]],["option"]]],[11,"nth","","",226,[[["self"],["usize"]],["option"]]],[11,"count","","",226,[[],["usize"]]],[11,"last","","",226,[[],["option"]]],[11,"size_hint","","",226,[[["self"]]]],[11,"try_fold","","",226,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",226,[[["acc"],["fold"]],["acc"]]],[11,"next","","",228,[[["self"]],["option"]]],[11,"nth","","",228,[[["self"],["usize"]],["option"]]],[11,"size_hint","","",228,[[["self"]]]],[11,"try_fold","","",228,[[["self"],["acc"],["fold"]],["r"]]],[11,"next","","",225,[[["self"]],["option"]]],[11,"size_hint","","",225,[[["self"]]]],[11,"try_fold","","",225,[[["self"],["acc"],["fold"]],["r"]]],[11,"next","","",230,[[["self"]],["option"]]],[11,"nth","","",230,[[["self"],["usize"]],["option"]]],[11,"last","","",230,[[],["option"]]],[11,"count","","",230,[[],["usize"]]],[11,"size_hint","","",230,[[["self"]]]],[11,"try_fold","","",230,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",230,[[["acc"],["fold"]],["acc"]]],[11,"next","","",230,[[["self"]],["option"]]],[11,"nth","","",230,[[["self"],["usize"]],["option"]]],[11,"last","","",230,[[],["option"]]],[11,"count","","",230,[[],["usize"]]],[11,"size_hint","","",230,[[["self"]]]],[11,"try_fold","","",230,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",230,[[["acc"],["fold"]],["acc"]]],[11,"next","","",231,[[["self"]],["option"]]],[11,"size_hint","","",231,[[["self"]]]],[11,"try_fold","","",231,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",231,[[["acc"],["fold"]],["acc"]]],[11,"next","core::ops","",34,[[["self"]],["option"]]],[11,"size_hint","","",34,[[["self"]]]],[11,"nth","","",34,[[["self"],["usize"]],["option"]]],[11,"last","","",34,[[],["option"]]],[11,"min","","",34,[[],["option"]]],[11,"max","","",34,[[],["option"]]],[11,"next","","",35,[[["self"]],["option"]]],[11,"size_hint","","",35,[[["self"]]]],[11,"nth","","",35,[[["self"],["usize"]],["option"]]],[11,"next","","",40,[[["self"]],["option"]]],[11,"size_hint","","",40,[[["self"]]]],[11,"nth","","",40,[[["self"],["usize"]],["option"]]],[11,"try_fold","","",40,[[["self"],["b"],["f"]],["r"]]],[11,"last","","",40,[[],["option"]]],[11,"min","","",40,[[],["option"]]],[11,"max","","",40,[[],["option"]]],[11,"next","core::iter","",208,[[["self"]],["option"]]],[11,"size_hint","","",208,[[["self"]]]],[11,"next","","",209,[[["self"]],["option"]]],[11,"size_hint","","",209,[[["self"]]]],[11,"next","","",204,[[["self"]],["option"]]],[11,"size_hint","","",204,[[["self"]]]],[11,"next","","",206,[[["self"]],["option"]]],[11,"size_hint","","",206,[[["self"]]]],[11,"next","","",207,[[["self"]],["option"]]],[11,"size_hint","","",207,[[["self"]]]],[11,"next","","",205,[[["self"]],["option"]]],[11,"next","","",210,[[["self"]],["option"]]],[11,"size_hint","","",210,[[["self"]]]],[11,"next","core::option","",232,[[["self"]],[["a"],["option"]]]],[11,"size_hint","","",232,[[["self"]]]],[11,"next","","",233,[[["self"]],[["a"],["option"]]]],[11,"size_hint","","",233,[[["self"]]]],[11,"next","","",234,[[["self"]],["option"]]],[11,"size_hint","","",234,[[["self"]]]],[11,"next","core::result","",236,[[["self"]],[["t"],["option"]]]],[11,"size_hint","","",236,[[["self"]]]],[11,"next","","",237,[[["self"]],[["t"],["option"]]]],[11,"size_hint","","",237,[[["self"]]]],[11,"next","","",238,[[["self"]],["option"]]],[11,"size_hint","","",238,[[["self"]]]],[11,"next","core::slice","",137,[[["self"]],[["t"],["option"]]]],[11,"size_hint","","",137,[[["self"]]]],[11,"count","","",137,[[],["usize"]]],[11,"nth","","",137,[[["self"],["usize"]],[["t"],["option"]]]],[11,"last","","",137,[[],[["t"],["option"]]]],[11,"position","","",137,[[["self"],["p"]],[["option",["usize"]],["usize"]]]],[11,"rposition","","",137,[[["self"],["p"]],[["option",["usize"]],["usize"]]]],[11,"is_sorted_by","","",137,[[["f"]],["bool"]]],[11,"next","","",138,[[["self"]],[["t"],["option"]]]],[11,"size_hint","","",138,[[["self"]]]],[11,"count","","",138,[[],["usize"]]],[11,"nth","","",138,[[["self"],["usize"]],[["t"],["option"]]]],[11,"last","","",138,[[],[["t"],["option"]]]],[11,"position","","",138,[[["self"],["p"]],[["option",["usize"]],["usize"]]]],[11,"rposition","","",138,[[["self"],["p"]],[["option",["usize"]],["usize"]]]],[11,"next","","",242,[[["self"]],["option"]]],[11,"size_hint","","",242,[[["self"]]]],[11,"next","","",243,[[["self"]],["option"]]],[11,"size_hint","","",243,[[["self"]]]],[11,"next","","",244,[[["self"]],["option"]]],[11,"size_hint","","",244,[[["self"]]]],[11,"next","","",245,[[["self"]],["option"]]],[11,"size_hint","","",245,[[["self"]]]],[11,"next","","",246,[[["self"]],["option"]]],[11,"size_hint","","",246,[[["self"]]]],[11,"next","","",247,[[["self"]],["option"]]],[11,"size_hint","","",247,[[["self"]]]],[11,"next","","",248,[[["self"]],["option"]]],[11,"size_hint","","",248,[[["self"]]]],[11,"next","","",249,[[["self"]],["option"]]],[11,"size_hint","","",249,[[["self"]]]],[11,"next","","",250,[[["self"]],["option"]]],[11,"size_hint","","",250,[[["self"]]]],[11,"next","","",251,[[["self"]],["option"]]],[11,"size_hint","","",251,[[["self"]]]],[11,"next","","",252,[[["self"]],["option"]]],[11,"size_hint","","",252,[[["self"]]]],[11,"count","","",252,[[],["usize"]]],[11,"nth","","",252,[[["self"],["usize"]],["option"]]],[11,"last","","",252,[[],["option"]]],[11,"next","","",253,[[["self"]],["option"]]],[11,"size_hint","","",253,[[["self"]]]],[11,"count","","",253,[[],["usize"]]],[11,"nth","","",253,[[["self"],["usize"]],["option"]]],[11,"last","","",253,[[],["option"]]],[11,"next","","",254,[[["self"]],["option"]]],[11,"size_hint","","",254,[[["self"]]]],[11,"count","","",254,[[],["usize"]]],[11,"nth","","",254,[[["self"],["usize"]],["option"]]],[11,"last","","",254,[[],["option"]]],[11,"next","","",139,[[["self"]],["option"]]],[11,"size_hint","","",139,[[["self"]]]],[11,"count","","",139,[[],["usize"]]],[11,"nth","","",139,[[["self"],["usize"]],["option"]]],[11,"last","","",139,[[],["option"]]],[11,"next","","",140,[[["self"]],["option"]]],[11,"size_hint","","",140,[[["self"]]]],[11,"count","","",140,[[],["usize"]]],[11,"nth","","",140,[[["self"],["usize"]],["option"]]],[11,"last","","",140,[[],["option"]]],[11,"next","","",255,[[["self"]],["option"]]],[11,"size_hint","","",255,[[["self"]]]],[11,"count","","",255,[[],["usize"]]],[11,"nth","","",255,[[["self"],["usize"]],["option"]]],[11,"last","","",255,[[],["option"]]],[11,"next","","",256,[[["self"]],["option"]]],[11,"size_hint","","",256,[[["self"]]]],[11,"count","","",256,[[],["usize"]]],[11,"nth","","",256,[[["self"],["usize"]],["option"]]],[11,"last","","",256,[[],["option"]]],[11,"next","","",141,[[["self"]],["option"]]],[11,"size_hint","","",141,[[["self"]]]],[11,"count","","",141,[[],["usize"]]],[11,"nth","","",141,[[["self"],["usize"]],["option"]]],[11,"last","","",141,[[],["option"]]],[11,"next","","",142,[[["self"]],["option"]]],[11,"size_hint","","",142,[[["self"]]]],[11,"count","","",142,[[],["usize"]]],[11,"nth","","",142,[[["self"],["usize"]],["option"]]],[11,"last","","",142,[[],["option"]]],[11,"next","core::str::lossy","",282,[[["self"]],[["option",["utf8lossychunk"]],["utf8lossychunk"]]]],[11,"next","core::str","",151,[[["self"]],[["char"],["option",["char"]]]]],[11,"count","","",151,[[],["usize"]]],[11,"size_hint","","",151,[[["self"]]]],[11,"last","","",151,[[],[["char"],["option",["char"]]]]],[11,"next","","",152,[[["self"]],["option"]]],[11,"count","","",152,[[],["usize"]]],[11,"size_hint","","",152,[[["self"]]]],[11,"last","","",152,[[],["option"]]],[11,"next","","",258,[[["self"]],[["option",["u8"]],["u8"]]]],[11,"size_hint","","",258,[[["self"]]]],[11,"count","","",258,[[],["usize"]]],[11,"last","","",258,[[],["option"]]],[11,"nth","","",258,[[["self"],["usize"]],["option"]]],[11,"all","","",258,[[["self"],["f"]],["bool"]]],[11,"any","","",258,[[["self"],["f"]],["bool"]]],[11,"find","","",258,[[["self"],["p"]],["option"]]],[11,"position","","",258,[[["self"],["p"]],[["option",["usize"]],["usize"]]]],[11,"rposition","","",258,[[["self"],["p"]],[["option",["usize"]],["usize"]]]],[11,"next","","",259,[[["self"]],[["str"],["option",["str"]]]]],[11,"next","","",260,[[["self"]],[["str"],["option",["str"]]]]],[11,"next","","",261,[[["self"]],[["str"],["option",["str"]]]]],[11,"next","","",262,[[["self"]],[["str"],["option",["str"]]]]],[11,"next","","",263,[[["self"]],[["str"],["option",["str"]]]]],[11,"next","","",264,[[["self"]],[["str"],["option",["str"]]]]],[11,"next","","",265,[[["self"]],["option"]]],[11,"next","","",266,[[["self"]],["option"]]],[11,"next","","",267,[[["self"]],[["str"],["option",["str"]]]]],[11,"next","","",268,[[["self"]],[["str"],["option",["str"]]]]],[11,"next","","",269,[[["self"]],[["str"],["option",["str"]]]]],[11,"size_hint","","",269,[[["self"]]]],[11,"last","","",269,[[],[["str"],["option",["str"]]]]],[11,"next","","",270,[[["self"]],[["str"],["option",["str"]]]]],[11,"size_hint","","",270,[[["self"]]]],[11,"next","","",271,[[["self"]],[["str"],["option",["str"]]]]],[11,"size_hint","","",271,[[["self"]]]],[11,"last","","",271,[[],[["str"],["option",["str"]]]]],[11,"next","","",272,[[["self"]],[["str"],["option",["str"]]]]],[11,"size_hint","","",272,[[["self"]]]],[11,"last","","",272,[[],[["str"],["option",["str"]]]]],[11,"next","","",273,[[["self"]],[["str"],["option",["str"]]]]],[11,"next","","",274,[[["self"]],[["u16"],["option",["u16"]]]]],[11,"size_hint","","",274,[[["self"]]]],[11,"next","","",275,[[["self"]],[["char"],["option",["char"]]]]],[11,"size_hint","","",275,[[["self"]]]],[11,"try_fold","","",275,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",275,[[["acc"],["fold"]],["acc"]]],[11,"next","","",276,[[["self"]],[["char"],["option",["char"]]]]],[11,"size_hint","","",276,[[["self"]]]],[11,"try_fold","","",276,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",276,[[["acc"],["fold"]],["acc"]]],[11,"next","","",277,[[["self"]],[["char"],["option",["char"]]]]],[11,"size_hint","","",277,[[["self"]]]],[11,"try_fold","","",277,[[["self"],["acc"],["fold"]],["r"]]],[11,"fold","","",277,[[["acc"],["fold"]],["acc"]]],[11,"write_str","core::fmt","",131,[[["str"],["self"]],["result"]]],[11,"write_char","","",131,[[["self"],["char"]],["result"]]],[11,"write_fmt","","",131,[[["self"],["arguments"]],["result"]]],[11,"fmt","core::num","",3,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",4,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",5,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",6,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",7,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",8,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",9,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",10,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",11,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",12,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",13,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",14,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",0,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",184,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",1,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",183,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",15,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",2,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::mem","",16,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",17,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",185,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::ptr","",18,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::cmp","",23,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",22,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::convert","",186,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::marker","",188,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::ops","",39,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",189,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",34,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",35,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",36,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",40,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",37,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",38,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::any","",74,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",74,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",74,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",75,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::array","",76,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",190,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::ascii","",191,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::cell","",192,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",193,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::char","",195,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",194,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",196,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",84,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",197,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",198,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",199,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",200,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",201,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::ffi","",203,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",85,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",202,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::iter","",216,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",224,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",213,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",223,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",222,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",212,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",211,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",217,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",215,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",221,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",219,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",220,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",218,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",86,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",227,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",229,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",214,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",226,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",228,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",225,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",230,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",231,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",208,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",209,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",204,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",206,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",207,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",205,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",210,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::option","",96,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",232,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",233,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",234,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",235,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::panic","",97,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",98,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::pin","",99,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::result","",101,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",236,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",237,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",238,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::sync::atomic","",102,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",105,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",106,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",107,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",108,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",109,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",110,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",111,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",112,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",113,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",114,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",103,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",104,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::fmt","",115,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",239,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",240,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::marker","",187,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::cell","",78,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",79,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",80,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",81,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",82,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::hash","",132,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",241,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::slice","",137,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",138,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",242,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",243,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",244,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",245,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",246,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",247,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",248,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",249,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",250,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",251,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",252,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",253,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",254,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",139,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",140,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",255,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",256,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",141,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",142,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::str::pattern","",143,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",278,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",279,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",280,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",281,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::str::lossy","",147,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",148,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::str","",257,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",150,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",151,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",152,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",258,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",259,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",260,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",261,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",262,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",263,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",264,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",265,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",266,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",267,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",268,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",269,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",270,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",271,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",272,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",273,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",274,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",275,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",276,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",277,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::time","",153,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::char","",83,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::task","",155,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",156,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",157,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",158,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",159,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::alloc","",162,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",283,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",284,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",163,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::arch::x86","",287,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",288,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",289,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",290,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",291,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",292,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",293,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",294,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",295,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",296,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",164,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::arch::aarch64","",297,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",298,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",299,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",300,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",301,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",302,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::arch::arm","",303,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",304,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",305,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",306,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",307,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",308,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",309,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",310,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",311,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",312,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",313,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",314,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",315,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",316,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",317,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",318,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",319,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",320,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",321,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",322,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",323,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",324,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::arch::wasm32","",325,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::arch::mips","",326,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",327,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",328,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",329,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",330,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",331,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",332,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",333,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",334,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",335,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::arch::powerpc","",336,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",337,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",338,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",339,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::num","",3,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",4,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",5,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",6,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",7,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",8,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",9,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",10,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",11,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",12,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",13,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",14,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",0,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",184,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",183,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",15,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::convert","",186,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::array","",190,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::ascii","",191,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::cell","",192,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",193,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",80,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",81,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::char","",195,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",194,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",84,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",197,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",198,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",199,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",200,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",201,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::panic","",97,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",98,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::pin","",99,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::fmt","",240,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",239,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::str::lossy","",148,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::str","",257,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",150,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",275,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",276,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",277,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::alloc","",283,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",284,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",163,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::num","",3,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",4,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",5,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",6,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",7,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",8,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",9,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",10,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",11,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",12,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",13,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",14,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",0,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",3,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",4,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",5,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",6,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",7,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",8,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",9,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",10,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",11,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",12,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",13,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",14,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",0,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",3,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",4,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",5,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",6,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",7,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",8,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",9,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",10,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",11,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",12,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",13,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",14,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",0,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",3,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",4,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",5,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",6,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",7,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",8,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",9,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",10,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",11,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",12,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",13,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",14,[[["formatter"],["self"]],["result"]]],[11,"fmt","","",0,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::ptr","",18,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::pin","",99,[[["formatter"],["self"]],["result"]]],[11,"fmt","core::sync::atomic","",104,[[["formatter"],["self"]],["result"]]],[11,"hash","core::num","",3,[[["__h"],["self"]]]],[11,"hash","","",4,[[["__h"],["self"]]]],[11,"hash","","",5,[[["__h"],["self"]]]],[11,"hash","","",6,[[["__h"],["self"]]]],[11,"hash","","",7,[[["__h"],["self"]]]],[11,"hash","","",8,[[["__h"],["self"]]]],[11,"hash","","",9,[[["__h"],["self"]]]],[11,"hash","","",10,[[["__h"],["self"]]]],[11,"hash","","",11,[[["__h"],["self"]]]],[11,"hash","","",12,[[["__h"],["self"]]]],[11,"hash","","",13,[[["__h"],["self"]]]],[11,"hash","","",14,[[["__h"],["self"]]]],[11,"hash","","",0,[[["__h"],["self"]]]],[11,"hash","core::mem","",16,[[["__h"],["self"]]]],[11,"hash","","",185,[[["h"],["self"]]]],[11,"hash","core::ptr","",18,[[["h"],["self"]]]],[11,"hash","core::cmp","",23,[[["__h"],["self"]]]],[11,"hash","","",22,[[["__h"],["self"]]]],[11,"hash","core::marker","",187,[[["h"],["self"]]]],[11,"hash","","",188,[[["__h"],["self"]]]],[11,"hash","core::ops","",39,[[["__h"],["self"]]]],[11,"hash","","",189,[[["__h"],["self"]]]],[11,"hash","","",34,[[["__h"],["self"]]]],[11,"hash","","",35,[[["__h"],["self"]]]],[11,"hash","","",36,[[["__h"],["self"]]]],[11,"hash","","",40,[[["h"],["self"]]]],[11,"hash","","",37,[[["__h"],["self"]]]],[11,"hash","","",38,[[["__h"],["self"]]]],[11,"hash","core::any","",75,[[["__h"],["self"]]]],[11,"hash","core::option","",96,[[["__h"],["self"]]]],[11,"hash","","",235,[[["__h"],["self"]]]],[11,"hash","core::pin","",99,[[["h"],["self"]]]],[11,"hash","core::result","",101,[[["__h"],["self"]]]],[11,"hash","core::sync::atomic","",102,[[["__h"],["self"]]]],[11,"hash","core::fmt","",239,[[["__h"],["self"]]]],[11,"hash","core::time","",153,[[["__h"],["self"]]]],[11,"hash","core::task","",155,[[["__h"],["self"]]]],[11,"write","core::hash","",132,[[["self"]]]],[11,"finish","","",132,[[["self"]],["u64"]]],[11,"build_hasher","","",241,[[["self"]],["h"]]],[11,"get","core::ops","",34,[[],["option"]]],[11,"get_mut","","",34,[[],["option"]]],[11,"get_unchecked","","",34,[[]]],[11,"get_unchecked_mut","","",34,[[]]],[11,"index","","",34,[[]]],[11,"index_mut","","",34,[[]]],[11,"get","","",36,[[],["option"]]],[11,"get_mut","","",36,[[],["option"]]],[11,"get_unchecked","","",36,[[]]],[11,"get_unchecked_mut","","",36,[[]]],[11,"index","","",36,[[]]],[11,"index_mut","","",36,[[]]],[11,"get","","",35,[[],["option"]]],[11,"get_mut","","",35,[[],["option"]]],[11,"get_unchecked","","",35,[[]]],[11,"get_unchecked_mut","","",35,[[]]],[11,"index","","",35,[[]]],[11,"index_mut","","",35,[[]]],[11,"get","","",189,[[],["option"]]],[11,"get_mut","","",189,[[],["option"]]],[11,"get_unchecked","","",189,[[]]],[11,"get_unchecked_mut","","",189,[[]]],[11,"index","","",189,[[]]],[11,"index_mut","","",189,[[]]],[11,"get","","",40,[[],["option"]]],[11,"get_mut","","",40,[[],["option"]]],[11,"get_unchecked","","",40,[[]]],[11,"get_unchecked_mut","","",40,[[]]],[11,"index","","",40,[[]]],[11,"index_mut","","",40,[[]]],[11,"get","","",37,[[],["option"]]],[11,"get_mut","","",37,[[],["option"]]],[11,"get_unchecked","","",37,[[]]],[11,"get_unchecked_mut","","",37,[[]]],[11,"index","","",37,[[]]],[11,"index_mut","","",37,[[]]],[11,"get","","",189,[[["str"]],["option"]]],[11,"get_mut","","",189,[[["str"]],["option"]]],[11,"get_unchecked","","",189,[[["str"]]]],[11,"get_unchecked_mut","","",189,[[["str"]]]],[11,"index","","",189,[[["str"]]]],[11,"index_mut","","",189,[[["str"]]]],[11,"get","","",34,[[["str"]],["option"]]],[11,"get_mut","","",34,[[["str"]],["option"]]],[11,"get_unchecked","","",34,[[["str"]]]],[11,"get_unchecked_mut","","",34,[[["str"]]]],[11,"index","","",34,[[["str"]]]],[11,"index_mut","","",34,[[["str"]]]],[11,"get","","",36,[[["str"]],["option"]]],[11,"get_mut","","",36,[[["str"]],["option"]]],[11,"get_unchecked","","",36,[[["str"]]]],[11,"get_unchecked_mut","","",36,[[["str"]]]],[11,"index","","",36,[[["str"]]]],[11,"index_mut","","",36,[[["str"]]]],[11,"get","","",35,[[["str"]],["option"]]],[11,"get_mut","","",35,[[["str"]],["option"]]],[11,"get_unchecked","","",35,[[["str"]]]],[11,"get_unchecked_mut","","",35,[[["str"]]]],[11,"index","","",35,[[["str"]]]],[11,"index_mut","","",35,[[["str"]]]],[11,"get","","",40,[[["str"]],["option"]]],[11,"get_mut","","",40,[[["str"]],["option"]]],[11,"get_unchecked","","",40,[[["str"]]]],[11,"get_unchecked_mut","","",40,[[["str"]]]],[11,"index","","",40,[[["str"]]]],[11,"index_mut","","",40,[[["str"]]]],[11,"get","","",37,[[["str"]],["option"]]],[11,"get_mut","","",37,[[["str"]],["option"]]],[11,"get_unchecked","","",37,[[["str"]]]],[11,"get_unchecked_mut","","",37,[[["str"]]]],[11,"index","","",37,[[["str"]]]],[11,"index_mut","","",37,[[["str"]]]],[11,"haystack","core::str::pattern","",278,[[["self"]],["str"]]],[11,"next","","",278,[[["self"]],["searchstep"]]],[11,"next_match","","",278,[[["self"]],["option"]]],[11,"haystack","","",279,[[["self"]],["str"]]],[11,"next","","",279,[[["self"]],["searchstep"]]],[11,"next_match","","",279,[[["self"]],["option"]]],[11,"next_reject","","",279,[[["self"]],["option"]]],[11,"haystack","","",280,[[["self"]],["str"]]],[11,"next","","",280,[[["self"]],["searchstep"]]],[11,"next_match","","",280,[[["self"]],["option"]]],[11,"next_reject","","",280,[[["self"]],["option"]]],[11,"haystack","","",281,[[["self"]],["str"]]],[11,"next","","",281,[[["self"]],["searchstep"]]],[11,"next_match","","",281,[[["self"]],["option"]]],[11,"next_back","","",278,[[["self"]],["searchstep"]]],[11,"next_match_back","","",278,[[["self"]],["option"]]],[11,"next_back","","",279,[[["self"]],["searchstep"]]],[11,"next_match_back","","",279,[[["self"]],["option"]]],[11,"next_reject_back","","",279,[[["self"]],["option"]]],[11,"next_back","","",280,[[["self"]],["searchstep"]]],[11,"next_match_back","","",280,[[["self"]],["option"]]],[11,"next_reject_back","","",280,[[["self"]],["option"]]],[11,"next_back","","",281,[[["self"]],["searchstep"]]],[11,"next_match_back","","",281,[[["self"]],["option"]]],[11,"from_str","core::num","",3,[[["str"]],["result"]]],[11,"from_str","","",4,[[["str"]],["result"]]],[11,"from_str","","",5,[[["str"]],["result"]]],[11,"from_str","","",6,[[["str"]],["result"]]],[11,"from_str","","",7,[[["str"]],["result"]]],[11,"from_str","","",8,[[["str"]],["result"]]],[11,"from_str","","",9,[[["str"]],["result"]]],[11,"from_str","","",10,[[["str"]],["result"]]],[11,"from_str","","",11,[[["str"]],["result"]]],[11,"from_str","","",12,[[["str"]],["result"]]],[11,"from_str","","",13,[[["str"]],["result"]]],[11,"from_str","","",14,[[["str"]],["result"]]],[11,"poll","core::pin","",99,[[["self"],["context"],["pin"]],["poll"]]],[11,"contains","core::ops","Returns `true` if `item` is contained in the range.",71,[[["u"],["self"]],["bool"]]],[11,"sub_usize","core::iter","Subtracts a `usize`, returning `None` on underflow.",88,[[["usize"],["self"]],["option"]]],[11,"nth_back","","Returns the `n`th element from the end of the iterator.",89,[[["self"],["usize"]],["option"]]],[11,"try_rfold","","This is the reverse version of [`try_fold()`]: it takes…",89,[[["self"],["b"],["f"]],["r"]]],[11,"rfold","","An iterator method that reduces the iterator's elements to…",89,[[["b"],["f"]],["b"]]],[11,"rfind","","Searches for an element of an iterator from the back that…",89,[[["self"],["p"]],["option"]]],[11,"len","","Returns the exact length of the iterator.",93,[[["self"]],["usize"]]],[11,"is_empty","","Returns `true` if the iterator is empty.",93,[[["self"]],["bool"]]],[11,"size_hint","","Returns the bounds on the remaining length of the iterator.",87,[[["self"]]]],[11,"count","","Consumes the iterator, counting the number of iterations…",87,[[],["usize"]]],[11,"last","","Consumes the iterator, returning the last element.",87,[[],["option"]]],[11,"nth","","Returns the `n`th element of the iterator.",87,[[["self"],["usize"]],["option"]]],[11,"step_by","","Creates an iterator starting at the same point, but…",87,[[["usize"]],["stepby"]]],[11,"chain","","Takes two iterators and creates a new iterator over both…",87,[[["u"]],["chain"]]],[11,"zip","","'Zips up' two iterators into a single iterator of pairs.",87,[[["u"]],["zip"]]],[11,"map","","Takes a closure and creates an iterator which calls that…",87,[[["f"]],["map"]]],[11,"for_each","","Calls a closure on each element of an iterator.",87,[[["f"]]]],[11,"filter","","Creates an iterator which uses a closure to determine if…",87,[[["p"]],["filter"]]],[11,"filter_map","","Creates an iterator that both filters and maps.",87,[[["f"]],["filtermap"]]],[11,"enumerate","","Creates an iterator which gives the current iteration…",87,[[],["enumerate"]]],[11,"peekable","","Creates an iterator which can use `peek` to look at the…",87,[[],["peekable"]]],[11,"skip_while","","Creates an iterator that [`skip`]s elements based on a…",87,[[["p"]],["skipwhile"]]],[11,"take_while","","Creates an iterator that yields elements based on a…",87,[[["p"]],["takewhile"]]],[11,"map_while","","Creates an iterator that both yields elements based on a…",87,[[["p"]],["mapwhile"]]],[11,"skip","","Creates an iterator that skips the first `n` elements.",87,[[["usize"]],["skip"]]],[11,"take","","Creates an iterator that yields its first `n` elements.",87,[[["usize"]],["take"]]],[11,"scan","","An iterator adaptor similar to [`fold`] that holds…",87,[[["f"],["st"]],["scan"]]],[11,"flat_map","","Creates an iterator that works like map, but flattens…",87,[[["f"]],["flatmap"]]],[11,"flatten","","Creates an iterator that flattens nested structure.",87,[[],["flatten"]]],[11,"fuse","","Creates an iterator which ends after the first [`None`].",87,[[],["fuse"]]],[11,"inspect","","Does something with each element of an iterator, passing…",87,[[["f"]],["inspect"]]],[11,"by_ref","","Borrows an iterator, rather than consuming it.",87,[[["self"]],["self"]]],[11,"collect","","Transforms an iterator into a collection.",87,[[],["fromiterator"]]],[11,"partition","","Consumes an iterator, creating two collections from it.",87,[[["f"]]]],[11,"partition_in_place","","Reorders the elements of this iterator in-place according…",87,[[["p"]],["usize"]]],[11,"is_partitioned","","Checks if the elements of this iterator are partitioned…",87,[[["p"]],["bool"]]],[11,"try_fold","","An iterator method that applies a function as long as it…",87,[[["self"],["b"],["f"]],["r"]]],[11,"try_for_each","","An iterator method that applies a fallible function to…",87,[[["self"],["f"]],["r"]]],[11,"fold","","An iterator method that applies a function, producing a…",87,[[["b"],["f"]],["b"]]],[11,"all","","Tests if every element of the iterator matches a predicate.",87,[[["self"],["f"]],["bool"]]],[11,"any","","Tests if any element of the iterator matches a predicate.",87,[[["self"],["f"]],["bool"]]],[11,"find","","Searches for an element of an iterator that satisfies a…",87,[[["self"],["p"]],["option"]]],[11,"find_map","","Applies function to the elements of iterator and returns…",87,[[["self"],["f"]],["option"]]],[11,"try_find","","Applies function to the elements of iterator and returns…",87,[[["self"],["f"]],[["result",["option"]],["option"]]]],[11,"position","","Searches for an element in an iterator, returning its index.",87,[[["self"],["p"]],[["option",["usize"]],["usize"]]]],[11,"rposition","","Searches for an element in an iterator from the right,…",87,[[["self"],["p"]],[["option",["usize"]],["usize"]]]],[11,"max","","Returns the maximum element of an iterator.",87,[[],["option"]]],[11,"min","","Returns the minimum element of an iterator.",87,[[],["option"]]],[11,"max_by_key","","Returns the element that gives the maximum value from the…",87,[[["f"]],["option"]]],[11,"max_by","","Returns the element that gives the maximum value with…",87,[[["f"]],["option"]]],[11,"min_by_key","","Returns the element that gives the minimum value from the…",87,[[["f"]],["option"]]],[11,"min_by","","Returns the element that gives the minimum value with…",87,[[["f"]],["option"]]],[11,"rev","","Reverses an iterator's direction.",87,[[],["rev"]]],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",87,[[]]],[11,"copied","","Creates an iterator which copies all of its elements.",87,[[],["copied"]]],[11,"cloned","","Creates an iterator which [`clone`]s all of its elements.",87,[[],["cloned"]]],[11,"cycle","","Repeats an iterator endlessly.",87,[[],["cycle"]]],[11,"sum","","Sums the elements of an iterator.",87,[[],["s"]]],[11,"product","","Iterates over the entire iterator, multiplying all the…",87,[[],["p"]]],[11,"cmp","","Lexicographically compares the elements of this `Iterator`…",87,[[["i"]],["ordering"]]],[11,"cmp_by","","Lexicographically compares the elements of this `Iterator`…",87,[[["i"],["f"]],["ordering"]]],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator`…",87,[[["i"]],[["option",["ordering"]],["ordering"]]]],[11,"partial_cmp_by","","Lexicographically compares the elements of this `Iterator`…",87,[[["i"],["f"]],[["option",["ordering"]],["ordering"]]]],[11,"eq","","Determines if the elements of this `Iterator` are equal to…",87,[[["i"]],["bool"]]],[11,"eq_by","","Determines if the elements of this `Iterator` are equal to…",87,[[["i"],["f"]],["bool"]]],[11,"ne","","Determines if the elements of this `Iterator` are unequal…",87,[[["i"]],["bool"]]],[11,"lt","","Determines if the elements of this `Iterator` are…",87,[[["i"]],["bool"]]],[11,"le","","Determines if the elements of this `Iterator` are…",87,[[["i"]],["bool"]]],[11,"gt","","Determines if the elements of this `Iterator` are…",87,[[["i"]],["bool"]]],[11,"ge","","Determines if the elements of this `Iterator` are…",87,[[["i"]],["bool"]]],[11,"is_sorted","","Checks if the elements of this iterator are sorted.",87,[[],["bool"]]],[11,"is_sorted_by","","Checks if the elements of this iterator are sorted using…",87,[[["f"]],["bool"]]],[11,"is_sorted_by_key","","Checks if the elements of this iterator are sorted using…",87,[[["f"]],["bool"]]]],"p":[[3,"Wrapping"],[4,"FpCategory"],[4,"IntErrorKind"],[3,"NonZeroU8"],[3,"NonZeroU16"],[3,"NonZeroU32"],[3,"NonZeroU64"],[3,"NonZeroU128"],[3,"NonZeroUsize"],[3,"NonZeroI8"],[3,"NonZeroI16"],[3,"NonZeroI32"],[3,"NonZeroI64"],[3,"NonZeroI128"],[3,"NonZeroIsize"],[3,"ParseIntError"],[3,"ManuallyDrop"],[19,"MaybeUninit"],[3,"NonNull"],[8,"Borrow"],[8,"BorrowMut"],[8,"Clone"],[3,"Reverse"],[4,"Ordering"],[8,"PartialEq"],[8,"Ord"],[8,"PartialOrd"],[8,"AsRef"],[8,"AsMut"],[8,"Into"],[8,"From"],[8,"TryInto"],[8,"TryFrom"],[8,"Default"],[3,"Range"],[3,"RangeFrom"],[3,"RangeTo"],[3,"RangeToInclusive"],[4,"Bound"],[4,"GeneratorState"],[3,"RangeInclusive"],[8,"Add"],[8,"Div"],[8,"Mul"],[8,"Neg"],[8,"Rem"],[8,"Sub"],[8,"AddAssign"],[8,"DivAssign"],[8,"MulAssign"],[8,"RemAssign"],[8,"SubAssign"],[8,"BitAnd"],[8,"BitOr"],[8,"BitXor"],[8,"Not"],[8,"Shl"],[8,"Shr"],[8,"BitAndAssign"],[8,"BitOrAssign"],[8,"BitXorAssign"],[8,"ShlAssign"],[8,"ShrAssign"],[8,"Deref"],[8,"DerefMut"],[8,"Drop"],[8,"Fn"],[8,"FnMut"],[8,"FnOnce"],[8,"Index"],[8,"IndexMut"],[8,"RangeBounds"],[8,"Try"],[8,"Generator"],[8,"Any"],[3,"TypeId"],[3,"IntoIter"],[8,"FixedSizeArray"],[3,"Cell"],[3,"RefCell"],[3,"Ref"],[3,"RefMut"],[3,"UnsafeCell"],[3,"UnicodeVersion"],[3,"DecodeUtf16Error"],[3,"VaListImpl"],[3,"Peekable"],[8,"Iterator"],[8,"Step"],[8,"DoubleEndedIterator"],[8,"Extend"],[8,"FromIterator"],[8,"IntoIterator"],[8,"ExactSizeIterator"],[8,"Product"],[8,"Sum"],[4,"Option"],[3,"PanicInfo"],[3,"Location"],[3,"Pin"],[3,"TraitObject"],[4,"Result"],[4,"Ordering"],[3,"AtomicBool"],[3,"AtomicPtr"],[3,"AtomicI8"],[3,"AtomicU8"],[3,"AtomicI16"],[3,"AtomicU16"],[3,"AtomicI32"],[3,"AtomicU32"],[3,"AtomicI64"],[3,"AtomicU64"],[3,"AtomicIsize"],[3,"AtomicUsize"],[4,"Alignment"],[3,"DebugStruct"],[3,"DebugTuple"],[3,"DebugSet"],[3,"DebugList"],[3,"DebugMap"],[8,"Write"],[8,"Debug"],[8,"Display"],[8,"Octal"],[8,"Binary"],[8,"LowerHex"],[8,"UpperHex"],[8,"Pointer"],[8,"LowerExp"],[8,"UpperExp"],[3,"Formatter"],[3,"SipHasher"],[8,"Hash"],[8,"Hasher"],[8,"BuildHasher"],[8,"SliceIndex"],[3,"Iter"],[3,"IterMut"],[3,"ChunksExact"],[3,"ChunksExactMut"],[3,"RChunksExact"],[3,"RChunksExactMut"],[4,"SearchStep"],[8,"Pattern"],[8,"Searcher"],[8,"ReverseSearcher"],[3,"Utf8LossyChunk"],[3,"Utf8Lossy"],[8,"FromStr"],[3,"Utf8Error"],[3,"Chars"],[3,"CharIndices"],[3,"Duration"],[8,"Future"],[4,"Poll"],[3,"RawWaker"],[3,"RawWakerVTable"],[3,"Context"],[3,"Waker"],[8,"GlobalAlloc"],[8,"AllocRef"],[3,"Layout"],[3,"CannotReallocInPlace"],[3,"CpuidResult"],[3,"int8x8x2_t"],[3,"int8x8x3_t"],[3,"int8x8x4_t"],[3,"uint8x8x2_t"],[3,"uint8x8x3_t"],[3,"uint8x8x4_t"],[3,"poly8x8x2_t"],[3,"poly8x8x3_t"],[3,"poly8x8x4_t"],[3,"int8x16x2_t"],[3,"int8x16x3_t"],[3,"int8x16x4_t"],[3,"uint8x16x2_t"],[3,"uint8x16x3_t"],[3,"uint8x16x4_t"],[3,"poly8x16x2_t"],[3,"poly8x16x3_t"],[3,"poly8x16x4_t"],[3,"TryFromIntError"],[3,"ParseFloatError"],[3,"Discriminant"],[4,"Infallible"],[3,"PhantomData"],[3,"PhantomPinned"],[3,"RangeFull"],[3,"TryFromSliceError"],[3,"EscapeDefault"],[3,"BorrowError"],[3,"BorrowMutError"],[3,"CharTryFromError"],[3,"ParseCharError"],[3,"DecodeUtf16"],[3,"EscapeUnicode"],[3,"EscapeDefault"],[3,"EscapeDebug"],[3,"ToLowercase"],[3,"ToUppercase"],[3,"VaList"],[4,"c_void"],[3,"Empty"],[3,"FromFn"],[3,"Once"],[3,"OnceWith"],[3,"Repeat"],[3,"RepeatWith"],[3,"Successors"],[3,"Cloned"],[3,"Copied"],[3,"Flatten"],[3,"MapWhile"],[3,"StepBy"],[3,"Chain"],[3,"Cycle"],[3,"Enumerate"],[3,"Filter"],[3,"FilterMap"],[3,"Map"],[3,"Rev"],[3,"Zip"],[3,"FlatMap"],[3,"Scan"],[3,"Skip"],[3,"SkipWhile"],[3,"Take"],[3,"TakeWhile"],[3,"Fuse"],[3,"Inspect"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"NoneError"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Error"],[3,"Arguments"],[3,"BuildHasherDefault"],[3,"Split"],[3,"SplitInclusive"],[3,"SplitMut"],[3,"SplitInclusiveMut"],[3,"RSplit"],[3,"RSplitMut"],[3,"SplitN"],[3,"RSplitN"],[3,"SplitNMut"],[3,"RSplitNMut"],[3,"Windows"],[3,"Chunks"],[3,"ChunksMut"],[3,"RChunks"],[3,"RChunksMut"],[3,"ParseBoolError"],[3,"Bytes"],[3,"Split"],[3,"RSplit"],[3,"SplitTerminator"],[3,"RSplitTerminator"],[3,"SplitN"],[3,"RSplitN"],[3,"MatchIndices"],[3,"RMatchIndices"],[3,"Matches"],[3,"RMatches"],[3,"Lines"],[3,"LinesAny"],[3,"SplitWhitespace"],[3,"SplitAsciiWhitespace"],[3,"SplitInclusive"],[3,"EncodeUtf16"],[3,"EscapeDebug"],[3,"EscapeDefault"],[3,"EscapeUnicode"],[3,"CharSearcher"],[3,"CharSliceSearcher"],[3,"CharPredicateSearcher"],[3,"StrSearcher"],[3,"Utf8LossyChunksIter"],[3,"LayoutErr"],[3,"AllocErr"],[3,"SY"],[3,"APSR"],[3,"__m64"],[3,"__m128i"],[3,"__m128"],[3,"__m128d"],[3,"__m256i"],[3,"__m256"],[3,"__m256d"],[3,"__m512i"],[3,"__m512"],[3,"__m512d"],[3,"float64x1_t"],[3,"float64x2_t"],[3,"poly64x1_t"],[3,"poly64_t"],[3,"poly64x2_t"],[3,"poly128_t"],[3,"int8x8_t"],[3,"uint8x8_t"],[3,"poly8x8_t"],[3,"int16x4_t"],[3,"uint16x4_t"],[3,"poly16x4_t"],[3,"int32x2_t"],[3,"uint32x2_t"],[3,"float32x2_t"],[3,"int64x1_t"],[3,"uint64x1_t"],[3,"int8x16_t"],[3,"uint8x16_t"],[3,"poly8x16_t"],[3,"int16x8_t"],[3,"uint16x8_t"],[3,"poly16x8_t"],[3,"int32x4_t"],[3,"uint32x4_t"],[3,"float32x4_t"],[3,"int64x2_t"],[3,"uint64x2_t"],[3,"v128"],[3,"v16i8"],[3,"v8i16"],[3,"v4i32"],[3,"v2i64"],[3,"v16u8"],[3,"v8u16"],[3,"v4u32"],[3,"v2u64"],[3,"v4f32"],[3,"v2f64"],[3,"vector_signed_long"],[3,"vector_unsigned_long"],[3,"vector_bool_long"],[3,"vector_double"]]};
searchIndex["proc_macro"] = {"doc":"A support library for macro authors when defining new…","i":[[3,"Diagnostic","proc_macro","A structure representing a diagnostic message and…",null,null],[3,"TokenStream","","The main type provided by this crate, representing an…",null,null],[3,"LexError","","Error returned from `TokenStream::from_str`.",null,null],[3,"Span","","A region of source code, along with macro expansion…",null,null],[3,"LineColumn","","A line-column pair representing the start or end of a…",null,null],[12,"line","","The 1-indexed line in the source file on which the span…",0,null],[12,"column","","The 0-indexed column (in UTF-8 characters) in the source…",0,null],[3,"SourceFile","","The source file of a given `Span`.",null,null],[3,"Group","","A delimited token stream.",null,null],[3,"Punct","","An `Punct` is an single punctuation character like `+`,…",null,null],[3,"Ident","","An identifier (`ident`).",null,null],[3,"Literal","","A literal string (`\"hello\"`), byte string (`b\"hello\"`),…",null,null],[4,"Level","","An enum representing a diagnostic level.",null,null],[13,"Error","","An error.",1,null],[13,"Warning","","A warning.",1,null],[13,"Note","","A note.",1,null],[13,"Help","","A help message.",1,null],[4,"TokenTree","","A single token or a delimited sequence of token trees…",null,null],[13,"Group","","A token stream surrounded by bracket delimiters.",2,null],[13,"Ident","","An identifier.",2,null],[13,"Punct","","A single punctuation character (`+`, `,`, `$`, etc.).",2,null],[13,"Literal","","A literal character (`'a'`), string (`\"hello\"`), number…",2,null],[4,"Delimiter","","Describes how a sequence of token trees is delimited.",null,null],[13,"Parenthesis","","`( ... )`",3,null],[13,"Brace","","`{ ... }`",3,null],[13,"Bracket","","`[ ... ]`",3,null],[13,"None","","`Ø ... Ø` An implicit delimiter, that may, for example,…",3,null],[4,"Spacing","","Whether an `Punct` is followed immediately by another…",null,null],[13,"Alone","","e.g., `+` is `Alone` in `+ =`, `+ident` or `+()`.",4,null],[13,"Joint","","e.g., `+` is `Joint` in `+=` or `'#`. Additionally, single…",4,null],[5,"quote","","Quote a `TokenStream` into a `TokenStream`. This is the…",null,[[["tokenstream"]],["tokenstream"]]],[5,"quote_span","","Quote a `Span` into a `TokenStream`. This is needed to…",null,[[["span"]],["tokenstream"]]],[11,"new","","Creates a new diagnostic with the given `level` and…",5,[[["into",["string"]],["string"],["level"]],["diagnostic"]]],[11,"spanned","","Creates a new diagnostic with the given `level` and…",5,[[["s"],["t"],["level"]],["diagnostic"]]],[11,"span_error","","Adds a new child diagnostic message to `self` with the…",5,[[["s"],["t"]],["diagnostic"]]],[11,"error","","Adds a new child diagnostic message to `self` with the…",5,[[["into",["string"]],["string"]],["diagnostic"]]],[11,"span_warning","","Adds a new child diagnostic message to `self` with the…",5,[[["s"],["t"]],["diagnostic"]]],[11,"warning","","Adds a new child diagnostic message to `self` with the…",5,[[["into",["string"]],["string"]],["diagnostic"]]],[11,"span_note","","Adds a new child diagnostic message to `self` with the…",5,[[["s"],["t"]],["diagnostic"]]],[11,"note","","Adds a new child diagnostic message to `self` with the…",5,[[["into",["string"]],["string"]],["diagnostic"]]],[11,"span_help","","Adds a new child diagnostic message to `self` with the…",5,[[["s"],["t"]],["diagnostic"]]],[11,"help","","Adds a new child diagnostic message to `self` with the…",5,[[["into",["string"]],["string"]],["diagnostic"]]],[11,"level","","Returns the diagnostic `level` for `self`.",5,[[["self"]],["level"]]],[11,"set_level","","Sets the level in `self` to `level`.",5,[[["self"],["level"]]]],[11,"message","","Returns the message in `self`.",5,[[["self"]],["str"]]],[11,"set_message","","Sets the message in `self` to `message`.",5,[[["self"],["into",["string"]],["string"]]]],[11,"spans","","Returns the `Span`s in `self`.",5,[[["self"]]]],[11,"set_spans","","Sets the `Span`s in `self` to `spans`.",5,[[["self"],["multispan"]]]],[11,"children","","Returns an iterator over the children diagnostics of `self`.",5,[[["self"]],["children"]]],[11,"emit","","Emit the diagnostic.",5,[[]]],[0,"token_stream","","Public implementation details for the `TokenStream` type,…",null,null],[3,"IntoIter","proc_macro::token_stream","An iterator over `TokenStream`'s `TokenTree`s. The…",null,null],[8,"MultiSpan","proc_macro","Trait implemented by types that can be converted into a…",null,null],[10,"into_spans","","Converts `self` into a `Vec<Span>`.",6,[[],[["span"],["vec",["span"]]]]],[11,"new","","Returns an empty `TokenStream` containing no token trees.",7,[[],["tokenstream"]]],[11,"is_empty","","Checks if this `TokenStream` is empty.",7,[[["self"]],["bool"]]],[11,"def_site","","A span that resolves at the macro definition site.",8,[[],["span"]]],[11,"call_site","","The span of the invocation of the current procedural…",8,[[],["span"]]],[11,"mixed_site","","A span that represents `macro_rules` hygiene, and…",8,[[],["span"]]],[11,"source_file","","The original source file into which this span points.",8,[[["self"]],["sourcefile"]]],[11,"parent","","The `Span` for the tokens in the previous macro expansion…",8,[[["self"]],[["option",["span"]],["span"]]]],[11,"source","","The span for the origin source code that `self` was…",8,[[["self"]],["span"]]],[11,"start","","Gets the starting line/column in the source file for this…",8,[[["self"]],["linecolumn"]]],[11,"end","","Gets the ending line/column in the source file for this…",8,[[["self"]],["linecolumn"]]],[11,"join","","Creates a new span encompassing `self` and `other`.",8,[[["span"],["self"]],[["option",["span"]],["span"]]]],[11,"resolved_at","","Creates a new span with the same line/column information…",8,[[["span"],["self"]],["span"]]],[11,"located_at","","Creates a new span with the same name resolution behavior…",8,[[["span"],["self"]],["span"]]],[11,"eq","","Compares to spans to see if they're equal.",8,[[["span"],["self"]],["bool"]]],[11,"source_text","","Returns the source text behind a span. This preserves the…",8,[[["self"]],[["option",["string"]],["string"]]]],[11,"error","","Creates a new `Diagnostic` with the given `message` at the…",8,[[["into",["string"]],["string"]],["diagnostic"]]],[11,"warning","","Creates a new `Diagnostic` with the given `message` at the…",8,[[["into",["string"]],["string"]],["diagnostic"]]],[11,"note","","Creates a new `Diagnostic` with the given `message` at the…",8,[[["into",["string"]],["string"]],["diagnostic"]]],[11,"help","","Creates a new `Diagnostic` with the given `message` at the…",8,[[["into",["string"]],["string"]],["diagnostic"]]],[11,"path","","Gets the path to this source file.",9,[[["self"]],["pathbuf"]]],[11,"is_real","","Returns `true` if this source file is a real source file,…",9,[[["self"]],["bool"]]],[11,"span","","Returns the span of this tree, delegating to the `span`…",2,[[["self"]],["span"]]],[11,"set_span","","Configures the span for only this token.",2,[[["self"],["span"]]]],[11,"new","","Creates a new `Group` with the given delimiter and token…",10,[[["tokenstream"],["delimiter"]],["group"]]],[11,"delimiter","","Returns the delimiter of this `Group`",10,[[["self"]],["delimiter"]]],[11,"stream","","Returns the `TokenStream` of tokens that are delimited in…",10,[[["self"]],["tokenstream"]]],[11,"span","","Returns the span for the delimiters of this token stream,…",10,[[["self"]],["span"]]],[11,"span_open","","Returns the span pointing to the opening delimiter of this…",10,[[["self"]],["span"]]],[11,"span_close","","Returns the span pointing to the closing delimiter of this…",10,[[["self"]],["span"]]],[11,"set_span","","Configures the span for this `Group`'s delimiters, but not…",10,[[["self"],["span"]]]],[11,"new","","Creates a new `Punct` from the given character and…",11,[[["spacing"],["char"]],["punct"]]],[11,"as_char","","Returns the value of this punctuation character as `char`.",11,[[["self"]],["char"]]],[11,"spacing","","Returns the spacing of this punctuation character,…",11,[[["self"]],["spacing"]]],[11,"span","","Returns the span for this punctuation character.",11,[[["self"]],["span"]]],[11,"set_span","","Configure the span for this punctuation character.",11,[[["self"],["span"]]]],[11,"new","","Creates a new `Ident` with the given `string` as well as…",12,[[["str"],["span"]],["ident"]]],[11,"new_raw","","Same as `Ident::new`, but creates a raw identifier…",12,[[["str"],["span"]],["ident"]]],[11,"span","","Returns the span of this `Ident`, encompassing the entire…",12,[[["self"]],["span"]]],[11,"set_span","","Configures the span of this `Ident`, possibly changing its…",12,[[["self"],["span"]]]],[11,"u8_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[["u8"]],["literal"]]],[11,"u16_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[["u16"]],["literal"]]],[11,"u32_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[["u32"]],["literal"]]],[11,"u64_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[["u64"]],["literal"]]],[11,"u128_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[["u128"]],["literal"]]],[11,"usize_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[["usize"]],["literal"]]],[11,"i8_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[["i8"]],["literal"]]],[11,"i16_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[["i16"]],["literal"]]],[11,"i32_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[["i32"]],["literal"]]],[11,"i64_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[["i64"]],["literal"]]],[11,"i128_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[["i128"]],["literal"]]],[11,"isize_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[["isize"]],["literal"]]],[11,"u8_unsuffixed","","Creates a new unsuffixed integer literal with the…",13,[[["u8"]],["literal"]]],[11,"u16_unsuffixed","","Creates a new unsuffixed integer literal with the…",13,[[["u16"]],["literal"]]],[11,"u32_unsuffixed","","Creates a new unsuffixed integer literal with the…",13,[[["u32"]],["literal"]]],[11,"u64_unsuffixed","","Creates a new unsuffixed integer literal with the…",13,[[["u64"]],["literal"]]],[11,"u128_unsuffixed","","Creates a new unsuffixed integer li